// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins.BBaseNode;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins.BNeedsFreeNode;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins.BaseReduceNode;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins.CtypesFromOutparamNode;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins.HashNode;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins.ObjectsNode;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins.SetStateNode;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins.PyObjectStgDictNode;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltinsFactory.PyObjectStgDictNodeGen;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes.ReadBytesNode;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodesFactory.ReadBytesNodeGen;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes.HashingStorageAddAllToOther;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodesFactory.HashingStorageAddAllToOtherNodeGen;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetInternalObjectArrayNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.GetInternalObjectArrayNodeGen;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes.GetNameNode;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory.GetNameNodeGen;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(CDataBuiltins.class)
@SuppressWarnings("javadoc")
public final class CDataBuiltinsFactory {

    private static final LibraryFactory<DynamicObjectLibrary> DYNAMIC_OBJECT_LIBRARY_ = LibraryFactory.resolve(DynamicObjectLibrary.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(BBaseNodeFactory.getInstance(), BNeedsFreeNodeFactory.getInstance(), ObjectsNodeFactory.getInstance(), CtypesFromOutparamNodeFactory.getInstance(), HashNodeFactory.getInstance(), BaseReduceNodeFactory.getInstance(), SetStateNodeFactory.getInstance());
    }

    @GeneratedBy(BBaseNode.class)
    protected static final class BBaseNodeFactory implements NodeFactory<BBaseNode> {

        private static final BBaseNodeFactory B_BASE_NODE_FACTORY_INSTANCE = new BBaseNodeFactory();

        private BBaseNodeFactory() {
        }

        @Override
        public Class<BBaseNode> getNodeClass() {
            return BBaseNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public BBaseNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        protected static NodeFactory<BBaseNode> getInstance() {
            return B_BASE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BBaseNode create() {
            return new BBaseNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BBaseNode#getBBase}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(BBaseNode.class)
        @SuppressWarnings("javadoc")
        protected static final class BBaseNodeGen extends BBaseNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BBaseNode#getBBase}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private BBaseNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CDataBuiltins.BBaseNode.getBBase(CDataObject)] */ && arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    return getBBase(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CDataBuiltins.BBaseNode.getBBase(CDataObject)] */;
                    this.state_0_ = state_0;
                    return getBBase(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(BNeedsFreeNode.class)
    protected static final class BNeedsFreeNodeFactory implements NodeFactory<BNeedsFreeNode> {

        private static final BNeedsFreeNodeFactory B_NEEDS_FREE_NODE_FACTORY_INSTANCE = new BNeedsFreeNodeFactory();

        private BNeedsFreeNodeFactory() {
        }

        @Override
        public Class<BNeedsFreeNode> getNodeClass() {
            return BNeedsFreeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public BNeedsFreeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        protected static NodeFactory<BNeedsFreeNode> getInstance() {
            return B_NEEDS_FREE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BNeedsFreeNode create() {
            return new BNeedsFreeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BNeedsFreeNode#getBNeedsFree}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(BNeedsFreeNode.class)
        @SuppressWarnings("javadoc")
        protected static final class BNeedsFreeNodeGen extends BNeedsFreeNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BNeedsFreeNode#getBNeedsFree}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private BNeedsFreeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CDataBuiltins.BNeedsFreeNode.getBNeedsFree(CDataObject)] */ && arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    return getBNeedsFree(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CDataBuiltins.BNeedsFreeNode.getBNeedsFree(CDataObject)] */;
                    this.state_0_ = state_0;
                    return getBNeedsFree(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ObjectsNode.class)
    protected static final class ObjectsNodeFactory implements NodeFactory<ObjectsNode> {

        private static final ObjectsNodeFactory OBJECTS_NODE_FACTORY_INSTANCE = new ObjectsNodeFactory();

        private ObjectsNodeFactory() {
        }

        @Override
        public Class<ObjectsNode> getNodeClass() {
            return ObjectsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ObjectsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        protected static NodeFactory<ObjectsNode> getInstance() {
            return OBJECTS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ObjectsNode create() {
            return new ObjectsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ObjectsNode#getObjects}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ObjectsNode.class)
        @SuppressWarnings("javadoc")
        protected static final class ObjectsNodeGen extends ObjectsNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ObjectsNode#getObjects}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ObjectsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CDataBuiltins.ObjectsNode.getObjects(CDataObject)] */ && arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    return getObjects(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CDataBuiltins.ObjectsNode.getObjects(CDataObject)] */;
                    this.state_0_ = state_0;
                    return getObjects(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(CtypesFromOutparamNode.class)
    protected static final class CtypesFromOutparamNodeFactory implements NodeFactory<CtypesFromOutparamNode> {

        private static final CtypesFromOutparamNodeFactory CTYPES_FROM_OUTPARAM_NODE_FACTORY_INSTANCE = new CtypesFromOutparamNodeFactory();

        private CtypesFromOutparamNodeFactory() {
        }

        @Override
        public Class<CtypesFromOutparamNode> getNodeClass() {
            return CtypesFromOutparamNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public CtypesFromOutparamNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        protected static NodeFactory<CtypesFromOutparamNode> getInstance() {
            return CTYPES_FROM_OUTPARAM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CtypesFromOutparamNode create() {
            return new CtypesFromOutparamNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CtypesFromOutparamNode#PyCData_from_outparam}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(CtypesFromOutparamNode.class)
        @SuppressWarnings("javadoc")
        protected static final class CtypesFromOutparamNodeGen extends CtypesFromOutparamNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CtypesFromOutparamNode#PyCData_from_outparam}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private CtypesFromOutparamNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CDataBuiltins.CtypesFromOutparamNode.PyCData_from_outparam(CDataObject)] */ && arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    return CtypesFromOutparamNode.PyCData_from_outparam(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CDataBuiltins.CtypesFromOutparamNode.PyCData_from_outparam(CDataObject)] */;
                    this.state_0_ = state_0;
                    return CtypesFromOutparamNode.PyCData_from_outparam(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(HashNode.class)
    protected static final class HashNodeFactory implements NodeFactory<HashNode> {

        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        @Override
        public Class<HashNode> getNodeClass() {
            return HashNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public HashNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        protected static NodeFactory<HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNode create(ReadArgumentNode[] arguments) {
            return new HashNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link HashNode#hash}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(HashNode.class)
        @SuppressWarnings("javadoc")
        protected static final class HashNodeGen extends HashNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HashNode#hash}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link PRaiseNode} raiseNode</pre>
             */
            @Child private PRaiseNode raiseNode_;

            private HashNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[CDataBuiltins.HashNode.hash(CDataObject, PRaiseNode)] */ && arguments0Value_ instanceof CDataObject) {
                    CDataObject arguments0Value__ = (CDataObject) arguments0Value_;
                    {
                        PRaiseNode raiseNode__ = this.raiseNode_;
                        if (raiseNode__ != null) {
                            return HashNode.hash(arguments0Value__, raiseNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private long executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof CDataObject) {
                    CDataObject arguments0Value_ = (CDataObject) arguments0Value;
                    PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                    Objects.requireNonNull(raiseNode__, "Specialization 'hash(CDataObject, PRaiseNode)' cache 'raiseNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.raiseNode_ = raiseNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CDataBuiltins.HashNode.hash(CDataObject, PRaiseNode)] */;
                    this.state_0_ = state_0;
                    return HashNode.hash(arguments0Value_, raiseNode__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(BaseReduceNode.class)
    protected static final class BaseReduceNodeFactory implements NodeFactory<BaseReduceNode> {

        private static final BaseReduceNodeFactory BASE_REDUCE_NODE_FACTORY_INSTANCE = new BaseReduceNodeFactory();

        private BaseReduceNodeFactory() {
        }

        @Override
        public Class<BaseReduceNode> getNodeClass() {
            return BaseReduceNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public BaseReduceNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        protected static NodeFactory<BaseReduceNode> getInstance() {
            return BASE_REDUCE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BaseReduceNode create() {
            return new BaseReduceNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BaseReduceNode#reduce}
         *     Activation probability: 1.00000
         *     With/without class size: 64/42 bytes
         * </pre>
         */
        @GeneratedBy(BaseReduceNode.class)
        @SuppressWarnings("javadoc")
        protected static final class BaseReduceNodeGen extends BaseReduceNode {

            private static final StateField STATE_0_BaseReduceNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField STATE_1_BaseReduceNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link PyObjectStgDictNode} pyObjectStgDictNode
             *   Inline method: {@link PyObjectStgDictNodeGen#inline}</pre>
             */
            private static final PyObjectStgDictNode INLINED_PY_OBJECT_STG_DICT_NODE_ = PyObjectStgDictNodeGen.inline(InlineTarget.create(PyObjectStgDictNode.class, STATE_0_BaseReduceNode_UPDATER.subUpdater(1, 18), ReferenceField.create(MethodHandles.lookup(), "pyObjectStgDictNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "pyObjectStgDictNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link ReadBytesNode} readBytesNode
             *   Inline method: {@link ReadBytesNodeGen#inline}</pre>
             */
            private static final ReadBytesNode INLINED_READ_BYTES_NODE_ = ReadBytesNodeGen.inline(InlineTarget.create(ReadBytesNode.class, STATE_0_BaseReduceNode_UPDATER.subUpdater(19, 7), ReferenceField.create(MethodHandles.lookup(), "readBytesNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "readBytesNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_1_BaseReduceNode_UPDATER.subUpdater(0, 17), ReferenceField.create(MethodHandles.lookup(), "getClassNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_BaseReduceNode_UPDATER.subUpdater(26, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BaseReduceNode#reduce}
             *   1-18: InlinedCache
             *        Specialization: {@link BaseReduceNode#reduce}
             *        Parameter: {@link PyObjectStgDictNode} pyObjectStgDictNode
             *        Inline method: {@link PyObjectStgDictNodeGen#inline}
             *   19-25: InlinedCache
             *        Specialization: {@link BaseReduceNode#reduce}
             *        Parameter: {@link ReadBytesNode} readBytesNode
             *        Inline method: {@link ReadBytesNodeGen#inline}
             *   26: InlinedCache
             *        Specialization: {@link BaseReduceNode#reduce}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-16: InlinedCache
             *        Specialization: {@link BaseReduceNode#reduce}
             *        Parameter: {@link GetClassNode} getClassNode
             *        Inline method: {@link GetClassNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link PyObjectStgDictNode} pyObjectStgDictNode
             *   Inline method: {@link PyObjectStgDictNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node pyObjectStgDictNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link PyObjectStgDictNode} pyObjectStgDictNode
             *   Inline method: {@link PyObjectStgDictNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node pyObjectStgDictNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link GetAttributeNode} getAttributeNode</pre>
             */
            @Child private GetAttributeNode getAttributeNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link DynamicObjectLibrary} dylib</pre>
             */
            @Child private DynamicObjectLibrary dylib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link ReadBytesNode} readBytesNode
             *   Inline method: {@link ReadBytesNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node readBytesNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link ReadBytesNode} readBytesNode
             *   Inline method: {@link ReadBytesNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node readBytesNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getClassNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseReduceNode#reduce}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            private BaseReduceNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CDataBuiltins.BaseReduceNode.reduce(VirtualFrame, CDataObject, Node, PyObjectStgDictNode, GetAttributeNode, DynamicObjectLibrary, ReadBytesNode, GetClassNode, PythonObjectFactory, Lazy)] */ && arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    {
                        GetAttributeNode getAttributeNode__ = this.getAttributeNode_;
                        if (getAttributeNode__ != null) {
                            DynamicObjectLibrary dylib__ = this.dylib_;
                            if (dylib__ != null) {
                                PythonObjectFactory factory__ = this.factory_;
                                if (factory__ != null) {
                                    Node inliningTarget__ = (this);
                                    return BaseReduceNode.reduce(frameValue, arg0Value_, inliningTarget__, INLINED_PY_OBJECT_STG_DICT_NODE_, getAttributeNode__, dylib__, INLINED_READ_BYTES_NODE_, INLINED_GET_CLASS_NODE_, factory__, INLINED_RAISE_NODE_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof CDataObject) {
                        CDataObject arg0Value_ = (CDataObject) arg0Value;
                        inliningTarget__ = (this);
                        GetAttributeNode getAttributeNode__ = this.insert((GetAttributeNode.create(SpecialAttributeNames.T___DICT__)));
                        Objects.requireNonNull(getAttributeNode__, "Specialization 'reduce(VirtualFrame, CDataObject, Node, PyObjectStgDictNode, GetAttributeNode, DynamicObjectLibrary, ReadBytesNode, GetClassNode, PythonObjectFactory, Lazy)' cache 'getAttributeNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.getAttributeNode_ = getAttributeNode__;
                        DynamicObjectLibrary dylib__ = this.insert((DYNAMIC_OBJECT_LIBRARY_.createDispatched(1)));
                        Objects.requireNonNull(dylib__, "Specialization 'reduce(VirtualFrame, CDataObject, Node, PyObjectStgDictNode, GetAttributeNode, DynamicObjectLibrary, ReadBytesNode, GetClassNode, PythonObjectFactory, Lazy)' cache 'dylib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.dylib_ = dylib__;
                        PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                        Objects.requireNonNull(factory__, "Specialization 'reduce(VirtualFrame, CDataObject, Node, PyObjectStgDictNode, GetAttributeNode, DynamicObjectLibrary, ReadBytesNode, GetClassNode, PythonObjectFactory, Lazy)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.factory_ = factory__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[CDataBuiltins.BaseReduceNode.reduce(VirtualFrame, CDataObject, Node, PyObjectStgDictNode, GetAttributeNode, DynamicObjectLibrary, ReadBytesNode, GetClassNode, PythonObjectFactory, Lazy)] */;
                        this.state_0_ = state_0;
                        return BaseReduceNode.reduce(frameValue, arg0Value_, inliningTarget__, INLINED_PY_OBJECT_STG_DICT_NODE_, getAttributeNode__, dylib__, INLINED_READ_BYTES_NODE_, INLINED_GET_CLASS_NODE_, factory__, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(SetStateNode.class)
    static final class SetStateNodeFactory implements NodeFactory<SetStateNode> {

        private static final SetStateNodeFactory SET_STATE_NODE_FACTORY_INSTANCE = new SetStateNodeFactory();

        private SetStateNodeFactory() {
        }

        @Override
        public Class<SetStateNode> getNodeClass() {
            return SetStateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public SetStateNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<SetStateNode> getInstance() {
            return SET_STATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SetStateNode create() {
            return new SetStateNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SetStateNode#PyCData_setstate}
         *     Activation probability: 1.00000
         *     With/without class size: 68/47 bytes
         * </pre>
         */
        @GeneratedBy(SetStateNode.class)
        @SuppressWarnings("javadoc")
        static final class SetStateNodeGen extends SetStateNode {

            private static final StateField STATE_0_SetStateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField STATE_1_SetStateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetInternalObjectArrayNode} getArray
             *   Inline method: {@link GetInternalObjectArrayNodeGen#inline}</pre>
             */
            private static final GetInternalObjectArrayNode INLINED_GET_ARRAY_ = GetInternalObjectArrayNodeGen.inline(InlineTarget.create(GetInternalObjectArrayNode.class, STATE_0_SetStateNode_UPDATER.subUpdater(1, 26), ReferenceField.create(MethodHandles.lookup(), "getArray__field1_", Object.class), ReferenceField.create(MethodHandles.lookup(), "getArray__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getArray__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_1_SetStateNode_UPDATER.subUpdater(0, 17), ReferenceField.create(MethodHandles.lookup(), "getClassNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetNameNode} getNameNode
             *   Inline method: {@link GetNameNodeGen#inline}</pre>
             */
            private static final GetNameNode INLINED_GET_NAME_NODE_ = GetNameNodeGen.inline(InlineTarget.create(GetNameNode.class, STATE_0_SetStateNode_UPDATER.subUpdater(27, 4), ReferenceField.create(MethodHandles.lookup(), "getNameNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}</pre>
             */
            private static final PyNumberAsSizeNode INLINED_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineTarget.create(PyNumberAsSizeNode.class, STATE_1_SetStateNode_UPDATER.subUpdater(17, 5), ReferenceField.create(MethodHandles.lookup(), "asSizeNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "asSizeNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link HashingStorageAddAllToOther} addAllToOtherNode
             *   Inline method: {@link HashingStorageAddAllToOtherNodeGen#inline}</pre>
             */
            private static final HashingStorageAddAllToOther INLINED_ADD_ALL_TO_OTHER_NODE_ = HashingStorageAddAllToOtherNodeGen.inline(InlineTarget.create(HashingStorageAddAllToOther.class, STATE_1_SetStateNode_UPDATER.subUpdater(22, 2), ReferenceField.create(MethodHandles.lookup(), "addAllToOtherNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_SetStateNode_UPDATER.subUpdater(31, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SetStateNode#PyCData_setstate}
             *   1-26: InlinedCache
             *        Specialization: {@link SetStateNode#PyCData_setstate}
             *        Parameter: {@link GetInternalObjectArrayNode} getArray
             *        Inline method: {@link GetInternalObjectArrayNodeGen#inline}
             *   27-30: InlinedCache
             *        Specialization: {@link SetStateNode#PyCData_setstate}
             *        Parameter: {@link GetNameNode} getNameNode
             *        Inline method: {@link GetNameNodeGen#inline}
             *   31: InlinedCache
             *        Specialization: {@link SetStateNode#PyCData_setstate}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-16: InlinedCache
             *        Specialization: {@link SetStateNode#PyCData_setstate}
             *        Parameter: {@link GetClassNode} getClassNode
             *        Inline method: {@link GetClassNodeGen#inline}
             *   17-21: InlinedCache
             *        Specialization: {@link SetStateNode#PyCData_setstate}
             *        Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *        Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   22-23: InlinedCache
             *        Specialization: {@link SetStateNode#PyCData_setstate}
             *        Parameter: {@link HashingStorageAddAllToOther} addAllToOtherNode
             *        Inline method: {@link HashingStorageAddAllToOtherNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetInternalObjectArrayNode} getArray
             *   Inline method: {@link GetInternalObjectArrayNodeGen#inline}
             *   Inline field: {@link Object} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object getArray__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetInternalObjectArrayNode} getArray
             *   Inline method: {@link GetInternalObjectArrayNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getArray__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetInternalObjectArrayNode} getArray
             *   Inline method: {@link GetInternalObjectArrayNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getArray__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetAttributeNode} getAttributeNode</pre>
             */
            @Child private GetAttributeNode getAttributeNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getClassNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link GetNameNode} getNameNode
             *   Inline method: {@link GetNameNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getNameNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link HashingStorageAddAllToOther} addAllToOtherNode
             *   Inline method: {@link HashingStorageAddAllToOtherNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node addAllToOtherNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#PyCData_setstate}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            private SetStateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CDataBuiltins.SetStateNode.PyCData_setstate(VirtualFrame, CDataObject, PTuple, Node, GetInternalObjectArrayNode, GetAttributeNode, GetClassNode, GetNameNode, PyNumberAsSizeNode, HashingStorageAddAllToOther, Lazy)] */ && arg0Value instanceof CDataObject) {
                    CDataObject arg0Value_ = (CDataObject) arg0Value;
                    if (arg1Value instanceof PTuple) {
                        PTuple arg1Value_ = (PTuple) arg1Value;
                        {
                            GetAttributeNode getAttributeNode__ = this.getAttributeNode_;
                            if (getAttributeNode__ != null) {
                                Node inliningTarget__ = (this);
                                return SetStateNode.PyCData_setstate(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_GET_ARRAY_, getAttributeNode__, INLINED_GET_CLASS_NODE_, INLINED_GET_NAME_NODE_, INLINED_AS_SIZE_NODE_, INLINED_ADD_ALL_TO_OTHER_NODE_, INLINED_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof CDataObject) {
                        CDataObject arg0Value_ = (CDataObject) arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple) arg1Value;
                            inliningTarget__ = (this);
                            GetAttributeNode getAttributeNode__ = this.insert((GetAttributeNode.create(SpecialAttributeNames.T___DICT__)));
                            Objects.requireNonNull(getAttributeNode__, "Specialization 'PyCData_setstate(VirtualFrame, CDataObject, PTuple, Node, GetInternalObjectArrayNode, GetAttributeNode, GetClassNode, GetNameNode, PyNumberAsSizeNode, HashingStorageAddAllToOther, Lazy)' cache 'getAttributeNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.getAttributeNode_ = getAttributeNode__;
                            state_0 = state_0 | 0b1 /* add SpecializationActive[CDataBuiltins.SetStateNode.PyCData_setstate(VirtualFrame, CDataObject, PTuple, Node, GetInternalObjectArrayNode, GetAttributeNode, GetClassNode, GetNameNode, PyNumberAsSizeNode, HashingStorageAddAllToOther, Lazy)] */;
                            this.state_0_ = state_0;
                            return SetStateNode.PyCData_setstate(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_GET_ARRAY_, getAttributeNode__, INLINED_GET_CLASS_NODE_, INLINED_GET_NAME_NODE_, INLINED_AS_SIZE_NODE_, INLINED_ADD_ALL_TO_OTHER_NODE_, INLINED_RAISE_NODE_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
