// CheckStyle: start generated
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;

/**
 * Debug Info: <pre>
 *   Specialization {@link IsForeignObjectNode#doBoolean}
 *     Activation probability: 0.21250
 *     With/without class size: 6/0 bytes
 *   Specialization {@link IsForeignObjectNode#doInt}
 *     Activation probability: 0.18750
 *     With/without class size: 6/0 bytes
 *   Specialization {@link IsForeignObjectNode#doLong}
 *     Activation probability: 0.16250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link IsForeignObjectNode#doDouble}
 *     Activation probability: 0.13750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link IsForeignObjectNode#doString}
 *     Activation probability: 0.11250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link IsForeignObjectNode#doPythonObject}
 *     Activation probability: 0.08750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link IsForeignObjectNode#doPBCT}
 *     Activation probability: 0.06250
 *     With/without class size: 4/0 bytes
 *   Specialization {@link IsForeignObjectNode#doForeign}
 *     Activation probability: 0.03750
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(IsForeignObjectNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class IsForeignObjectNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static IsForeignObjectNode getUncached() {
        return IsForeignObjectNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul>
     */
    @NeverDefault
    public static IsForeignObjectNode inline(@RequiredField(bits = 8, value = StateField.class) InlineTarget target) {
        return new IsForeignObjectNodeGen.Inlined(target);
    }

    @GeneratedBy(IsForeignObjectNode.class)
    @DenyReplace
    private static final class Inlined extends IsForeignObjectNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link IsForeignObjectNode#doBoolean}
         *   1: SpecializationActive {@link IsForeignObjectNode#doInt}
         *   2: SpecializationActive {@link IsForeignObjectNode#doLong}
         *   3: SpecializationActive {@link IsForeignObjectNode#doDouble}
         *   4: SpecializationActive {@link IsForeignObjectNode#doString}
         *   5: SpecializationActive {@link IsForeignObjectNode#doPythonObject}
         *   6: SpecializationActive {@link IsForeignObjectNode#doPBCT}
         *   7: SpecializationActive {@link IsForeignObjectNode#doForeign}
         * </pre>
         */
        private final StateField state_0_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(IsForeignObjectNode.class);
            this.state_0_ = target.getState(0, 8);
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value) {
            if (!((state_0 & 0b1) != 0 /* is SpecializationActive[IsForeignObjectNode.doBoolean(Boolean)] */) && arg1Value instanceof Boolean) {
                return false;
            }
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[IsForeignObjectNode.doInt(Integer)] */) && arg1Value instanceof Integer) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[IsForeignObjectNode.doLong(Long)] */) && arg1Value instanceof Long) {
                return false;
            }
            if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[IsForeignObjectNode.doDouble(Double)] */) && arg1Value instanceof Double) {
                return false;
            }
            if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[IsForeignObjectNode.doString(TruffleString)] */) && arg1Value instanceof TruffleString) {
                return false;
            }
            if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[IsForeignObjectNode.doPythonObject(PythonAbstractObject)] */) && arg1Value instanceof PythonAbstractObject) {
                return false;
            }
            if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[IsForeignObjectNode.doPBCT(PythonBuiltinClassType)] */) && arg1Value instanceof PythonBuiltinClassType) {
                return false;
            }
            return true;
        }

        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0 /* is SpecializationActive[IsForeignObjectNode.doBoolean(Boolean)] || SpecializationActive[IsForeignObjectNode.doInt(Integer)] || SpecializationActive[IsForeignObjectNode.doLong(Long)] || SpecializationActive[IsForeignObjectNode.doDouble(Double)] || SpecializationActive[IsForeignObjectNode.doString(TruffleString)] || SpecializationActive[IsForeignObjectNode.doPythonObject(PythonAbstractObject)] || SpecializationActive[IsForeignObjectNode.doPBCT(PythonBuiltinClassType)] || SpecializationActive[IsForeignObjectNode.doForeign(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[IsForeignObjectNode.doBoolean(Boolean)] */ && arg1Value instanceof Boolean) {
                    Boolean arg1Value_ = (Boolean) arg1Value;
                    return IsForeignObjectNode.doBoolean(arg1Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[IsForeignObjectNode.doInt(Integer)] */ && arg1Value instanceof Integer) {
                    Integer arg1Value_ = (Integer) arg1Value;
                    return IsForeignObjectNode.doInt(arg1Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[IsForeignObjectNode.doLong(Long)] */ && arg1Value instanceof Long) {
                    Long arg1Value_ = (Long) arg1Value;
                    return IsForeignObjectNode.doLong(arg1Value_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[IsForeignObjectNode.doDouble(Double)] */ && arg1Value instanceof Double) {
                    Double arg1Value_ = (Double) arg1Value;
                    return IsForeignObjectNode.doDouble(arg1Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[IsForeignObjectNode.doString(TruffleString)] */ && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    return IsForeignObjectNode.doString(arg1Value_);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[IsForeignObjectNode.doPythonObject(PythonAbstractObject)] */ && arg1Value instanceof PythonAbstractObject) {
                    PythonAbstractObject arg1Value_ = (PythonAbstractObject) arg1Value;
                    return IsForeignObjectNode.doPythonObject(arg1Value_);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[IsForeignObjectNode.doPBCT(PythonBuiltinClassType)] */ && arg1Value instanceof PythonBuiltinClassType) {
                    PythonBuiltinClassType arg1Value_ = (PythonBuiltinClassType) arg1Value;
                    return IsForeignObjectNode.doPBCT(arg1Value_);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[IsForeignObjectNode.doForeign(Object)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IsForeignObjectNode.doForeign(arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Boolean) {
                Boolean arg1Value_ = (Boolean) arg1Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[IsForeignObjectNode.doBoolean(Boolean)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsForeignObjectNode.doBoolean(arg1Value_);
            }
            if (arg1Value instanceof Integer) {
                Integer arg1Value_ = (Integer) arg1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[IsForeignObjectNode.doInt(Integer)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsForeignObjectNode.doInt(arg1Value_);
            }
            if (arg1Value instanceof Long) {
                Long arg1Value_ = (Long) arg1Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[IsForeignObjectNode.doLong(Long)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsForeignObjectNode.doLong(arg1Value_);
            }
            if (arg1Value instanceof Double) {
                Double arg1Value_ = (Double) arg1Value;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[IsForeignObjectNode.doDouble(Double)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsForeignObjectNode.doDouble(arg1Value_);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[IsForeignObjectNode.doString(TruffleString)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsForeignObjectNode.doString(arg1Value_);
            }
            if (arg1Value instanceof PythonAbstractObject) {
                PythonAbstractObject arg1Value_ = (PythonAbstractObject) arg1Value;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[IsForeignObjectNode.doPythonObject(PythonAbstractObject)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsForeignObjectNode.doPythonObject(arg1Value_);
            }
            if (arg1Value instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType arg1Value_ = (PythonBuiltinClassType) arg1Value;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[IsForeignObjectNode.doPBCT(PythonBuiltinClassType)] */;
                this.state_0_.set(arg0Value, state_0);
                return IsForeignObjectNode.doPBCT(arg1Value_);
            }
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[IsForeignObjectNode.doForeign(Object)] */;
            this.state_0_.set(arg0Value, state_0);
            return IsForeignObjectNode.doForeign(arg1Value);
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(IsForeignObjectNode.class)
    @DenyReplace
    private static final class Uncached extends IsForeignObjectNode {

        @TruffleBoundary
        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof Boolean) {
                Boolean arg1Value_ = (Boolean) arg1Value;
                return IsForeignObjectNode.doBoolean(arg1Value_);
            }
            if (arg1Value instanceof Integer) {
                Integer arg1Value_ = (Integer) arg1Value;
                return IsForeignObjectNode.doInt(arg1Value_);
            }
            if (arg1Value instanceof Long) {
                Long arg1Value_ = (Long) arg1Value;
                return IsForeignObjectNode.doLong(arg1Value_);
            }
            if (arg1Value instanceof Double) {
                Double arg1Value_ = (Double) arg1Value;
                return IsForeignObjectNode.doDouble(arg1Value_);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                return IsForeignObjectNode.doString(arg1Value_);
            }
            if (arg1Value instanceof PythonAbstractObject) {
                PythonAbstractObject arg1Value_ = (PythonAbstractObject) arg1Value;
                return IsForeignObjectNode.doPythonObject(arg1Value_);
            }
            if (arg1Value instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType arg1Value_ = (PythonBuiltinClassType) arg1Value;
                return IsForeignObjectNode.doPBCT(arg1Value_);
            }
            return IsForeignObjectNode.doForeign(arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
