// CheckStyle: start generated
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNodeGen;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberIndexNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.math.BigInteger;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link CastToJavaBigIntegerNode#fromBoolean}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link CastToJavaBigIntegerNode#fromInt}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link CastToJavaBigIntegerNode#fromLong}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link CastToJavaBigIntegerNode#fromPInt}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link CastToJavaBigIntegerNode#generic}
 *     Activation probability: 0.08000
 *     With/without class size: 8/40 bytes
 * </pre>
 */
@GeneratedBy(CastToJavaBigIntegerNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class CastToJavaBigIntegerNodeGen extends CastToJavaBigIntegerNode {

    private static final StateField GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER = StateField.create(GenericData.lookup_(), "generic_state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link CastToJavaBigIntegerNode#generic}
     *   Parameter: {@link Lazy} raise
     *   Inline method: {@link LazyNodeGen#inline}</pre>
     */
    private static final Lazy INLINED_GENERIC_RAISE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 1), ReferenceField.create(GenericData.lookup_(), "generic_raise__field1_", Node.class)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link CastToJavaBigIntegerNode#generic}
     *   Parameter: {@link GetClassNode} getClassNode
     *   Inline method: {@link GetClassNodeGen#inline}</pre>
     */
    private static final GetClassNode INLINED_GENERIC_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(1, 17), ReferenceField.create(GenericData.lookup_(), "generic_getClassNode__field1_", Node.class)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link CastToJavaBigIntegerNode#generic}
     *   Parameter: {@link PyIndexCheckNode} indexCheckNode
     *   Inline method: {@link PyIndexCheckNodeGen#inline}</pre>
     */
    private static final PyIndexCheckNode INLINED_GENERIC_INDEX_CHECK_NODE_ = PyIndexCheckNodeGen.inline(InlineTarget.create(PyIndexCheckNode.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(18, 7), ReferenceField.create(GenericData.lookup_(), "generic_indexCheckNode__field1_", Node.class)));
    /**
     * Source Info: <pre>
     *   Specialization: {@link CastToJavaBigIntegerNode#generic}
     *   Parameter: {@link PyNumberIndexNode} indexNode
     *   Inline method: {@link PyNumberIndexNodeGen#inline}</pre>
     */
    private static final PyNumberIndexNode INLINED_GENERIC_INDEX_NODE_ = PyNumberIndexNodeGen.inline(InlineTarget.create(PyNumberIndexNode.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(25, 6), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field1_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field2_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field3_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field4_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field5_", Node.class)));
    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link CastToJavaBigIntegerNode#fromBoolean}
     *   1: SpecializationActive {@link CastToJavaBigIntegerNode#fromInt}
     *   2: SpecializationActive {@link CastToJavaBigIntegerNode#fromLong}
     *   3: SpecializationActive {@link CastToJavaBigIntegerNode#fromPInt}
     *   4: SpecializationActive {@link CastToJavaBigIntegerNode#generic}
     *   5-6: ImplicitCast[type=int, index=1]
     *   7-9: ImplicitCast[type=long, index=1]
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private GenericData generic_cache;

    private CastToJavaBigIntegerNodeGen() {
    }

    @Override
    public BigInteger execute(Node arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] || SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] || SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.fromPInt(PInt)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] */ && arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                return CastToJavaBigIntegerNode.fromBoolean(arg1Value_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */ && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                return CastToJavaBigIntegerNode.fromInt(arg1Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                return CastToJavaBigIntegerNode.fromLong(arg1Value_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromPInt(PInt)] */ && arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                return CastToJavaBigIntegerNode.fromPInt(arg1Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                GenericData s4_ = this.generic_cache;
                if (s4_ != null) {
                    return CastToJavaBigIntegerNode.generic(s4_, arg1Value, INLINED_GENERIC_RAISE_, s4_.rec_, INLINED_GENERIC_GET_CLASS_NODE_, INLINED_GENERIC_INDEX_CHECK_NODE_, INLINED_GENERIC_INDEX_NODE_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    @Override
    public BigInteger execute(Node arg0Value, boolean arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10111) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] || SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] || SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] */) {
                return CastToJavaBigIntegerNode.fromBoolean(arg1Value);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */ && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                return CastToJavaBigIntegerNode.fromInt(arg1Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                return CastToJavaBigIntegerNode.fromLong(arg1Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                GenericData s4_ = this.generic_cache;
                if (s4_ != null) {
                    return CastToJavaBigIntegerNode.generic(s4_, arg1Value, INLINED_GENERIC_RAISE_, s4_.rec_, INLINED_GENERIC_GET_CLASS_NODE_, INLINED_GENERIC_INDEX_CHECK_NODE_, INLINED_GENERIC_INDEX_NODE_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    @Override
    public BigInteger execute(Node arg0Value, int arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10110) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] || SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */) {
                return CastToJavaBigIntegerNode.fromInt(arg1Value);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                return CastToJavaBigIntegerNode.fromLong(arg1Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                GenericData s4_ = this.generic_cache;
                if (s4_ != null) {
                    return CastToJavaBigIntegerNode.generic(s4_, arg1Value, INLINED_GENERIC_RAISE_, s4_.rec_, INLINED_GENERIC_GET_CLASS_NODE_, INLINED_GENERIC_INDEX_CHECK_NODE_, INLINED_GENERIC_INDEX_NODE_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    @Override
    public BigInteger execute(Node arg0Value, long arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                return CastToJavaBigIntegerNode.fromLong(arg1Value_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                GenericData s4_ = this.generic_cache;
                if (s4_ != null) {
                    return CastToJavaBigIntegerNode.generic(s4_, arg1Value, INLINED_GENERIC_RAISE_, s4_.rec_, INLINED_GENERIC_GET_CLASS_NODE_, INLINED_GENERIC_INDEX_CHECK_NODE_, INLINED_GENERIC_INDEX_NODE_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private BigInteger executeAndSpecialize(Node arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if (arg1Value instanceof Boolean) {
            boolean arg1Value_ = (boolean) arg1Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] */;
            this.state_0_ = state_0;
            return CastToJavaBigIntegerNode.fromBoolean(arg1Value_);
        }
        {
            int intCast1;
            if ((intCast1 = PythonArithmeticTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast1, arg1Value);
                state_0 = (state_0 | (intCast1 << 5) /* set-int ImplicitCast[type=int, index=1] */);
                state_0 = state_0 | 0b10 /* add SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */;
                this.state_0_ = state_0;
                return CastToJavaBigIntegerNode.fromInt(arg1Value_);
            }
        }
        {
            int longCast1;
            if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                state_0 = (state_0 | (longCast1 << 7) /* set-int ImplicitCast[type=long, index=1] */);
                state_0 = state_0 | 0b100 /* add SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */;
                this.state_0_ = state_0;
                return CastToJavaBigIntegerNode.fromLong(arg1Value_);
            }
        }
        if (arg1Value instanceof PInt) {
            PInt arg1Value_ = (PInt) arg1Value;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[CastToJavaBigIntegerNode.fromPInt(PInt)] */;
            this.state_0_ = state_0;
            return CastToJavaBigIntegerNode.fromPInt(arg1Value_);
        }
        GenericData s4_ = this.insert(new GenericData());
        CastToJavaBigIntegerNode rec__ = s4_.insert((CastToJavaBigIntegerNodeGen.create()));
        Objects.requireNonNull(rec__, "Specialization 'generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)' cache 'rec' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        s4_.rec_ = rec__;
        VarHandle.storeStoreFence();
        this.generic_cache = s4_;
        state_0 = state_0 | 0b10000 /* add SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */;
        this.state_0_ = state_0;
        return CastToJavaBigIntegerNode.generic(s4_, arg1Value, INLINED_GENERIC_RAISE_, rec__, INLINED_GENERIC_GET_CLASS_NODE_, INLINED_GENERIC_INDEX_CHECK_NODE_, INLINED_GENERIC_INDEX_NODE_);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0b11111) == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @NeverDefault
    public static CastToJavaBigIntegerNode create() {
        return new CastToJavaBigIntegerNodeGen();
    }

    @NeverDefault
    public static CastToJavaBigIntegerNode getUncached() {
        return CastToJavaBigIntegerNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#generic_cache}
     * </ul>
     */
    @NeverDefault
    public static CastToJavaBigIntegerNode inline(@RequiredField(bits = 10, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
        return new CastToJavaBigIntegerNodeGen.Inlined(target);
    }

    @GeneratedBy(CastToJavaBigIntegerNode.class)
    @DenyReplace
    private static final class Inlined extends CastToJavaBigIntegerNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link CastToJavaBigIntegerNode#fromBoolean}
         *   1: SpecializationActive {@link CastToJavaBigIntegerNode#fromInt}
         *   2: SpecializationActive {@link CastToJavaBigIntegerNode#fromLong}
         *   3: SpecializationActive {@link CastToJavaBigIntegerNode#fromPInt}
         *   4: SpecializationActive {@link CastToJavaBigIntegerNode#generic}
         *   5-6: ImplicitCast[type=int, index=1]
         *   7-9: ImplicitCast[type=long, index=1]
         * </pre>
         */
        private final StateField state_0_;
        private final ReferenceField<GenericData> generic_cache;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link Lazy} raise
         *   Inline method: {@link LazyNodeGen#inline}</pre>
         */
        private final Lazy generic_raise_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link GetClassNode} getClassNode
         *   Inline method: {@link GetClassNodeGen#inline}</pre>
         */
        private final GetClassNode generic_getClassNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyIndexCheckNode} indexCheckNode
         *   Inline method: {@link PyIndexCheckNodeGen#inline}</pre>
         */
        private final PyIndexCheckNode generic_indexCheckNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyNumberIndexNode} indexNode
         *   Inline method: {@link PyNumberIndexNodeGen#inline}</pre>
         */
        private final PyNumberIndexNode generic_indexNode_;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(CastToJavaBigIntegerNode.class);
            this.state_0_ = target.getState(0, 10);
            this.generic_cache = target.getReference(1, GenericData.class);
            this.generic_raise_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(0, 1), ReferenceField.create(GenericData.lookup_(), "generic_raise__field1_", Node.class)));
            this.generic_getClassNode_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(1, 17), ReferenceField.create(GenericData.lookup_(), "generic_getClassNode__field1_", Node.class)));
            this.generic_indexCheckNode_ = PyIndexCheckNodeGen.inline(InlineTarget.create(PyIndexCheckNode.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(18, 7), ReferenceField.create(GenericData.lookup_(), "generic_indexCheckNode__field1_", Node.class)));
            this.generic_indexNode_ = PyNumberIndexNodeGen.inline(InlineTarget.create(PyNumberIndexNode.class, GENERIC__CAST_TO_JAVA_BIG_INTEGER_NODE_GENERIC_STATE_0_UPDATER.subUpdater(25, 6), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field1_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field2_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field3_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field4_", Node.class), ReferenceField.create(GenericData.lookup_(), "generic_indexNode__field5_", Node.class)));
        }

        @Override
        public BigInteger execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b11111) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] || SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] || SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.fromPInt(PInt)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] */ && arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (boolean) arg1Value;
                    return CastToJavaBigIntegerNode.fromBoolean(arg1Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */ && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                    return CastToJavaBigIntegerNode.fromInt(arg1Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                    return CastToJavaBigIntegerNode.fromLong(arg1Value_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromPInt(PInt)] */ && arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    return CastToJavaBigIntegerNode.fromPInt(arg1Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                    GenericData s4_ = this.generic_cache.get(arg0Value);
                    if (s4_ != null) {
                        return CastToJavaBigIntegerNode.generic(s4_, arg1Value, this.generic_raise_, s4_.rec_, this.generic_getClassNode_, this.generic_indexCheckNode_, this.generic_indexNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public BigInteger execute(Node arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b10111) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] || SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] || SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] */) {
                    return CastToJavaBigIntegerNode.fromBoolean(arg1Value);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */ && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                    return CastToJavaBigIntegerNode.fromInt(arg1Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                    return CastToJavaBigIntegerNode.fromLong(arg1Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                    GenericData s4_ = this.generic_cache.get(arg0Value);
                    if (s4_ != null) {
                        return CastToJavaBigIntegerNode.generic(s4_, arg1Value, this.generic_raise_, s4_.rec_, this.generic_getClassNode_, this.generic_indexCheckNode_, this.generic_indexNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public BigInteger execute(Node arg0Value, int arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b10110) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] || SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */) {
                    return CastToJavaBigIntegerNode.fromInt(arg1Value);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                    return CastToJavaBigIntegerNode.fromLong(arg1Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                    GenericData s4_ = this.generic_cache.get(arg0Value);
                    if (s4_ != null) {
                        return CastToJavaBigIntegerNode.generic(s4_, arg1Value, this.generic_raise_, s4_.rec_, this.generic_getClassNode_, this.generic_indexCheckNode_, this.generic_indexNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public BigInteger execute(Node arg0Value, long arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b10100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] || SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                    return CastToJavaBigIntegerNode.fromLong(arg1Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */) {
                    GenericData s4_ = this.generic_cache.get(arg0Value);
                    if (s4_ != null) {
                        return CastToJavaBigIntegerNode.generic(s4_, arg1Value, this.generic_raise_, s4_.rec_, this.generic_getClassNode_, this.generic_indexCheckNode_, this.generic_indexNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private BigInteger executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[CastToJavaBigIntegerNode.fromBoolean(boolean)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaBigIntegerNode.fromBoolean(arg1Value_);
            }
            {
                int intCast1;
                if ((intCast1 = PythonArithmeticTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast1, arg1Value);
                    state_0 = (state_0 | (intCast1 << 5) /* set-int ImplicitCast[type=int, index=1] */);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[CastToJavaBigIntegerNode.fromInt(int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CastToJavaBigIntegerNode.fromInt(arg1Value_);
                }
            }
            {
                int longCast1;
                if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                    state_0 = (state_0 | (longCast1 << 7) /* set-int ImplicitCast[type=long, index=1] */);
                    state_0 = state_0 | 0b100 /* add SpecializationActive[CastToJavaBigIntegerNode.fromLong(long)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CastToJavaBigIntegerNode.fromLong(arg1Value_);
                }
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[CastToJavaBigIntegerNode.fromPInt(PInt)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaBigIntegerNode.fromPInt(arg1Value_);
            }
            GenericData s4_ = arg0Value.insert(new GenericData());
            CastToJavaBigIntegerNode rec__ = s4_.insert((CastToJavaBigIntegerNodeGen.create()));
            Objects.requireNonNull(rec__, "Specialization 'generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)' cache 'rec' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            s4_.rec_ = rec__;
            VarHandle.storeStoreFence();
            this.generic_cache.set(arg0Value, s4_);
            state_0 = state_0 | 0b10000 /* add SpecializationActive[CastToJavaBigIntegerNode.generic(Node, Object, Lazy, CastToJavaBigIntegerNode, GetClassNode, PyIndexCheckNode, PyNumberIndexNode)] */;
            this.state_0_.set(arg0Value, state_0);
            return CastToJavaBigIntegerNode.generic(s4_, arg1Value, this.generic_raise_, rec__, this.generic_getClassNode_, this.generic_indexCheckNode_, this.generic_indexNode_);
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(CastToJavaBigIntegerNode.class)
    @DenyReplace
    private static final class GenericData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0: InlinedCache
         *        Specialization: {@link CastToJavaBigIntegerNode#generic}
         *        Parameter: {@link Lazy} raise
         *        Inline method: {@link LazyNodeGen#inline}
         *   1-17: InlinedCache
         *        Specialization: {@link CastToJavaBigIntegerNode#generic}
         *        Parameter: {@link GetClassNode} getClassNode
         *        Inline method: {@link GetClassNodeGen#inline}
         *   18-24: InlinedCache
         *        Specialization: {@link CastToJavaBigIntegerNode#generic}
         *        Parameter: {@link PyIndexCheckNode} indexCheckNode
         *        Inline method: {@link PyIndexCheckNodeGen#inline}
         *   25-30: InlinedCache
         *        Specialization: {@link CastToJavaBigIntegerNode#generic}
         *        Parameter: {@link PyNumberIndexNode} indexNode
         *        Inline method: {@link PyNumberIndexNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int generic_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link Lazy} raise
         *   Inline method: {@link LazyNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_raise__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link CastToJavaBigIntegerNode} rec</pre>
         */
        @Child CastToJavaBigIntegerNode rec_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link GetClassNode} getClassNode
         *   Inline method: {@link GetClassNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_getClassNode__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyIndexCheckNode} indexCheckNode
         *   Inline method: {@link PyIndexCheckNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_indexCheckNode__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyNumberIndexNode} indexNode
         *   Inline method: {@link PyNumberIndexNodeGen#inline}
         *   Inline field: {@link Node} field1</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_indexNode__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyNumberIndexNode} indexNode
         *   Inline method: {@link PyNumberIndexNodeGen#inline}
         *   Inline field: {@link Node} field2</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_indexNode__field2_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyNumberIndexNode} indexNode
         *   Inline method: {@link PyNumberIndexNodeGen#inline}
         *   Inline field: {@link Node} field3</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_indexNode__field3_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyNumberIndexNode} indexNode
         *   Inline method: {@link PyNumberIndexNodeGen#inline}
         *   Inline field: {@link Node} field4</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_indexNode__field4_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaBigIntegerNode#generic}
         *   Parameter: {@link PyNumberIndexNode} indexNode
         *   Inline method: {@link PyNumberIndexNodeGen#inline}
         *   Inline field: {@link Node} field5</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node generic_indexNode__field5_;

        GenericData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
    @GeneratedBy(CastToJavaBigIntegerNode.class)
    @DenyReplace
    private static final class Uncached extends CastToJavaBigIntegerNode {

        @TruffleBoundary
        @Override
        public BigInteger execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                return CastToJavaBigIntegerNode.fromBoolean(arg1Value_);
            }
            if (PythonArithmeticTypesGen.isImplicitInteger(arg1Value)) {
                int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(arg1Value);
                return CastToJavaBigIntegerNode.fromInt(arg1Value_);
            }
            if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(arg1Value);
                return CastToJavaBigIntegerNode.fromLong(arg1Value_);
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                return CastToJavaBigIntegerNode.fromPInt(arg1Value_);
            }
            return CastToJavaBigIntegerNode.generic(arg0Value, arg1Value, (Lazy.getUncached()), (CastToJavaBigIntegerNodeGen.getUncached()), (GetClassNode.getUncached()), (PyIndexCheckNodeGen.getUncached()), (PyNumberIndexNodeGen.getUncached()));
        }

        @TruffleBoundary
        @Override
        public BigInteger execute(Node arg0Value, boolean arg1Value) {
            return CastToJavaBigIntegerNode.fromBoolean(arg1Value);
        }

        @TruffleBoundary
        @Override
        public BigInteger execute(Node arg0Value, int arg1Value) {
            return CastToJavaBigIntegerNode.fromInt(arg1Value);
        }

        @TruffleBoundary
        @Override
        public BigInteger execute(Node arg0Value, long arg1Value) {
            if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(arg1Value);
                return CastToJavaBigIntegerNode.fromLong(arg1Value_);
            }
            return CastToJavaBigIntegerNode.generic(arg0Value, arg1Value, (Lazy.getUncached()), (CastToJavaBigIntegerNodeGen.getUncached()), (GetClassNode.getUncached()), (PyIndexCheckNodeGen.getUncached()), (PyNumberIndexNodeGen.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
