/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.WeakRefModuleBuiltins;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashSet;

@ExportLibrary(value=ReflectionLibrary.class)
public final class PythonBuiltinClassType
extends Enum<PythonBuiltinClassType>
implements TruffleObject {
    public static final /* enum */ PythonBuiltinClassType ForeignObject = new PythonBuiltinClassType("foreign", Flags.PRIVATE_DERIVED_WODICT, 8023146548486679L);
    public static final /* enum */ PythonBuiltinClassType Boolean = new PythonBuiltinClassType("bool", "builtins", Flags.PUBLIC_DERIVED_WODICT, 10200940543L);
    public static final /* enum */ PythonBuiltinClassType PArray = new PythonBuiltinClassType("array", "array", 8918138812891136L);
    public static final /* enum */ PythonBuiltinClassType PArrayIterator = new PythonBuiltinClassType("arrayiterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PIterator = new PythonBuiltinClassType("iterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PBuiltinFunction = new PythonBuiltinClassType("method_descriptor", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PBuiltinFunctionOrMethod = new PythonBuiltinClassType("builtin_function_or_method", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType WrapperDescriptor = new PythonBuiltinClassType("wrapper_descriptor", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType MethodWrapper = new PythonBuiltinClassType("method-wrapper", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PBuiltinMethod = new PythonBuiltinClassType("builtin_method", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PBuiltinClassMethod = new PythonBuiltinClassType("classmethod_descriptor", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType GetSetDescriptor = new PythonBuiltinClassType("getset_descriptor", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType MemberDescriptor = new PythonBuiltinClassType("member_descriptor", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PByteArray = new PythonBuiltinClassType("bytearray", "builtins", 8918138812891144L);
    public static final /* enum */ PythonBuiltinClassType PBytes = new PythonBuiltinClassType("bytes", "builtins", 3534929883299848L);
    public static final /* enum */ PythonBuiltinClassType PCell = new PythonBuiltinClassType("cell", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PSimpleNamespace = new PythonBuiltinClassType("SimpleNamespace", null, "types", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PKeyWrapper = new PythonBuiltinClassType("KeyWrapper", "_functools", "functools", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PPartial = new PythonBuiltinClassType("partial", "_functools", "functools", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PLruListElem = new PythonBuiltinClassType("_lru_list_elem", null, "functools", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PLruCacheWrapper = new PythonBuiltinClassType("_lru_cache_wrapper", "_functools", "functools", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PDefaultDict = new PythonBuiltinClassType("defaultdict", "_collections", "collections", Flags.PUBLIC_BASE_WODICT, 8022037104721920L);
    public static final /* enum */ PythonBuiltinClassType PDeque = new PythonBuiltinClassType("deque", "_collections", Flags.PUBLIC_BASE_WODICT, 1036839464993280L);
    public static final /* enum */ PythonBuiltinClassType PTupleGetter = new PythonBuiltinClassType("_tuplegetter", "_collections", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDequeIter = new PythonBuiltinClassType("_deque_iterator", "_collections", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDequeRevIter = new PythonBuiltinClassType("_deque_reverse_iterator", "_collections", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType POrderedDict = new PythonBuiltinClassType("OrderedDict", "_collections", Flags.PUBLIC_BASE_WDICT, 8022037104721920L);
    public static final /* enum */ PythonBuiltinClassType POrderedDictKeys = new PythonBuiltinClassType("odict_keys", Flags.PRIVATE_DERIVED_WODICT, 141837000040450L);
    public static final /* enum */ PythonBuiltinClassType POrderedDictValues = new PythonBuiltinClassType("odict_values", Flags.PRIVATE_DERIVED_WODICT, 0x10000000000L);
    public static final /* enum */ PythonBuiltinClassType POrderedDictItems = new PythonBuiltinClassType("odict_items", Flags.PRIVATE_DERIVED_WODICT, 141837000040450L);
    public static final /* enum */ PythonBuiltinClassType POrderedDictIterator = new PythonBuiltinClassType("odict_iterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PComplex = new PythonBuiltinClassType("complex", "builtins", 1073742823L);
    public static final /* enum */ PythonBuiltinClassType PDict = new PythonBuiltinClassType("dict", "builtins", 8022037104721920L);
    public static final /* enum */ PythonBuiltinClassType PDictItemIterator = new PythonBuiltinClassType("dict_itemiterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDictReverseItemIterator = new PythonBuiltinClassType("dict_reverseitemiterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDictItemsView = new PythonBuiltinClassType("dict_items", Flags.PRIVATE_DERIVED_WODICT, 141837000040450L);
    public static final /* enum */ PythonBuiltinClassType PDictKeyIterator = new PythonBuiltinClassType("dict_keyiterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDictReverseKeyIterator = new PythonBuiltinClassType("dict_reversekeyiterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDictKeysView = new PythonBuiltinClassType("dict_keys", Flags.PRIVATE_DERIVED_WODICT, 141837000040450L);
    public static final /* enum */ PythonBuiltinClassType PDictValueIterator = new PythonBuiltinClassType("dict_valueiterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDictReverseValueIterator = new PythonBuiltinClassType("dict_reversevalueiterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDictValuesView = new PythonBuiltinClassType("dict_values", Flags.PRIVATE_DERIVED_WODICT, 0x10000000000L);
    public static final /* enum */ PythonBuiltinClassType PEllipsis = new PythonBuiltinClassType("ellipsis", "builtins", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PEnumerate = new PythonBuiltinClassType("enumerate", "builtins");
    public static final /* enum */ PythonBuiltinClassType PMap = new PythonBuiltinClassType("map", "builtins");
    public static final /* enum */ PythonBuiltinClassType PFloat = new PythonBuiltinClassType("float", "builtins", 1610941439L);
    public static final /* enum */ PythonBuiltinClassType PFrame = new PythonBuiltinClassType("frame", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PFrozenSet = new PythonBuiltinClassType("frozenset", "builtins", 141837000040450L);
    public static final /* enum */ PythonBuiltinClassType PFunction = new PythonBuiltinClassType("function", Flags.PRIVATE_DERIVED_WDICT);
    public static final /* enum */ PythonBuiltinClassType PGenerator = new PythonBuiltinClassType("generator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PCoroutine = new PythonBuiltinClassType("coroutine", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PCoroutineWrapper = new PythonBuiltinClassType("coroutine_wrapper", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PAsyncGenerator = new PythonBuiltinClassType("async_generator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PInt = new PythonBuiltinClassType("int", "builtins", 10200940543L);
    public static final /* enum */ PythonBuiltinClassType PList = new PythonBuiltinClassType("list", "builtins", 8882954440802304L);
    public static final /* enum */ PythonBuiltinClassType PMappingproxy = new PythonBuiltinClassType("mappingproxy", Flags.PRIVATE_DERIVED_WODICT, 3518437477351424L);
    public static final /* enum */ PythonBuiltinClassType PMemoryView = new PythonBuiltinClassType("memoryview", "builtins", Flags.PUBLIC_DERIVED_WODICT, 7891194952548352L);
    public static final /* enum */ PythonBuiltinClassType PAsyncGenASend = new PythonBuiltinClassType("async_generator_asend", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PAsyncGenAThrow = new PythonBuiltinClassType("async_generator_athrow", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PAsyncGenAWrappedValue = new PythonBuiltinClassType("async_generator_wrapped_value", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PMethod = new PythonBuiltinClassType("method", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PMMap = new PythonBuiltinClassType("mmap", "mmap", 7926379324637184L);
    public static final /* enum */ PythonBuiltinClassType PNone = new PythonBuiltinClassType("NoneType", Flags.PRIVATE_DERIVED_WODICT, 512L);
    public static final /* enum */ PythonBuiltinClassType PNotImplemented = new PythonBuiltinClassType("NotImplementedType", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PProperty = new PythonBuiltinClassType("property", "builtins", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType PSimpleQueue = new PythonBuiltinClassType("SimpleQueue", "_queue", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType PRandom = new PythonBuiltinClassType("Random", "_random");
    public static final /* enum */ PythonBuiltinClassType PRange = new PythonBuiltinClassType("range", "builtins", Flags.PUBLIC_DERIVED_WODICT, 3528332813533696L);
    public static final /* enum */ PythonBuiltinClassType PReferenceType = new PythonBuiltinClassType("ReferenceType", "_weakref");
    public static final /* enum */ PythonBuiltinClassType PSentinelIterator = new PythonBuiltinClassType("callable_iterator", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PForeignArrayIterator = new PythonBuiltinClassType("foreign_iterator");
    public static final /* enum */ PythonBuiltinClassType PReverseIterator = new PythonBuiltinClassType("reversed", "builtins");
    public static final /* enum */ PythonBuiltinClassType PSet = new PythonBuiltinClassType("set", "builtins", 141837470851074L);
    public static final /* enum */ PythonBuiltinClassType PSlice = new PythonBuiltinClassType("slice", "builtins");
    public static final /* enum */ PythonBuiltinClassType PString = new PythonBuiltinClassType("str", "builtins", 3534929883299848L);
    public static final /* enum */ PythonBuiltinClassType PTraceback = new PythonBuiltinClassType("traceback");
    public static final /* enum */ PythonBuiltinClassType PTuple = new PythonBuiltinClassType("tuple", "builtins", 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PythonClass = new PythonBuiltinClassType("type", "builtins", Flags.PUBLIC_BASE_WDICT, 32768L);
    public static final /* enum */ PythonBuiltinClassType PythonModule = new PythonBuiltinClassType("module", Flags.PRIVATE_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PythonModuleDef = new PythonBuiltinClassType("moduledef", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PythonObject = new PythonBuiltinClassType("object", "builtins");
    public static final /* enum */ PythonBuiltinClassType Super = new PythonBuiltinClassType("super", "builtins");
    public static final /* enum */ PythonBuiltinClassType PCode = new PythonBuiltinClassType("code", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PGenericAlias = new PythonBuiltinClassType("GenericAlias", "types", Flags.PUBLIC_BASE_WODICT, 0x8000000008000L);
    public static final /* enum */ PythonBuiltinClassType PUnionType = new PythonBuiltinClassType("UnionType", "types", Flags.PUBLIC_DERIVED_WODICT, 0x8000000008000L);
    public static final /* enum */ PythonBuiltinClassType PZip = new PythonBuiltinClassType("zip", "builtins");
    public static final /* enum */ PythonBuiltinClassType PThread = new PythonBuiltinClassType("start_new_thread", "_thread");
    public static final /* enum */ PythonBuiltinClassType PThreadLocal = new PythonBuiltinClassType("_local", "_thread");
    public static final /* enum */ PythonBuiltinClassType PLock = new PythonBuiltinClassType("LockType", "_thread");
    public static final /* enum */ PythonBuiltinClassType PRLock = new PythonBuiltinClassType("RLock", "_thread");
    public static final /* enum */ PythonBuiltinClassType PSemLock = new PythonBuiltinClassType("SemLock", "_multiprocessing");
    public static final /* enum */ PythonBuiltinClassType PGraalPySemLock = new PythonBuiltinClassType("SemLock", "_multiprocessing_graalpy");
    public static final /* enum */ PythonBuiltinClassType PSocket = new PythonBuiltinClassType("socket", "_socket");
    public static final /* enum */ PythonBuiltinClassType PStaticmethod = new PythonBuiltinClassType("staticmethod", "builtins", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PClassmethod = new PythonBuiltinClassType("classmethod", "builtins", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PInstancemethod = new PythonBuiltinClassType("instancemethod", "builtins", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PScandirIterator = new PythonBuiltinClassType("ScandirIterator", "posix", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PDirEntry = new PythonBuiltinClassType("DirEntry", "posix", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType LsprofProfiler = new PythonBuiltinClassType("Profiler", "_lsprof");
    public static final /* enum */ PythonBuiltinClassType PStruct = new PythonBuiltinClassType("Struct", "_struct");
    public static final /* enum */ PythonBuiltinClassType PStructUnpackIterator = new PythonBuiltinClassType("unpack_iterator", "_struct");
    public static final /* enum */ PythonBuiltinClassType Pickler = new PythonBuiltinClassType("Pickler", "_pickle");
    public static final /* enum */ PythonBuiltinClassType PicklerMemoProxy = new PythonBuiltinClassType("PicklerMemoProxy", "_pickle");
    public static final /* enum */ PythonBuiltinClassType UnpicklerMemoProxy = new PythonBuiltinClassType("UnpicklerMemoProxy", "_pickle");
    public static final /* enum */ PythonBuiltinClassType Unpickler = new PythonBuiltinClassType("Unpickler", "_pickle");
    public static final /* enum */ PythonBuiltinClassType PickleBuffer = new PythonBuiltinClassType("PickleBuffer", "_pickle");
    public static final /* enum */ PythonBuiltinClassType BZ2Compressor = new PythonBuiltinClassType("BZ2Compressor", "_bz2");
    public static final /* enum */ PythonBuiltinClassType BZ2Decompressor = new PythonBuiltinClassType("BZ2Decompressor", "_bz2");
    public static final /* enum */ PythonBuiltinClassType PLZMACompressor = new PythonBuiltinClassType("LZMACompressor", "_lzma");
    public static final /* enum */ PythonBuiltinClassType PLZMADecompressor = new PythonBuiltinClassType("LZMADecompressor", "_lzma");
    public static final /* enum */ PythonBuiltinClassType ZlibCompress = new PythonBuiltinClassType("Compress", "zlib");
    public static final /* enum */ PythonBuiltinClassType ZlibDecompress = new PythonBuiltinClassType("Decompress", "zlib");
    public static final /* enum */ PythonBuiltinClassType PIOBase = new PythonBuiltinClassType("_IOBase", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PRawIOBase = new PythonBuiltinClassType("_RawIOBase", "_io");
    public static final /* enum */ PythonBuiltinClassType PTextIOBase = new PythonBuiltinClassType("_TextIOBase", "_io");
    public static final /* enum */ PythonBuiltinClassType PBufferedIOBase = new PythonBuiltinClassType("_BufferedIOBase", "_io");
    public static final /* enum */ PythonBuiltinClassType PBufferedReader = new PythonBuiltinClassType("BufferedReader", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PBufferedWriter = new PythonBuiltinClassType("BufferedWriter", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PBufferedRWPair = new PythonBuiltinClassType("BufferedRWPair", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PBufferedRandom = new PythonBuiltinClassType("BufferedRandom", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PFileIO = new PythonBuiltinClassType("FileIO", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PTextIOWrapper = new PythonBuiltinClassType("TextIOWrapper", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PIncrementalNewlineDecoder = new PythonBuiltinClassType("IncrementalNewlineDecoder", "_io", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType PStringIO = new PythonBuiltinClassType("StringIO", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PBytesIO = new PythonBuiltinClassType("BytesIO", "_io", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PBytesIOBuf = new PythonBuiltinClassType("_BytesIOBuffer", "_io", Flags.PRIVATE_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType PStatResult = new PythonBuiltinClassType("stat_result", "os", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PStatvfsResult = new PythonBuiltinClassType("statvfs_result", "os", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PTerminalSize = new PythonBuiltinClassType("terminal_size", "os", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PUnameResult = new PythonBuiltinClassType("uname_result", "posix", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PStructTime = new PythonBuiltinClassType("struct_time", "time", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PProfilerEntry = new PythonBuiltinClassType("profiler_entry", "_lsprof", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PProfilerSubentry = new PythonBuiltinClassType("profiler_subentry", "_lsprof", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PStructPasswd = new PythonBuiltinClassType("struct_passwd", "pwd", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PStructRusage = new PythonBuiltinClassType("struct_rusage", "resource", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PVersionInfo = new PythonBuiltinClassType("version_info", "sys", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PFlags = new PythonBuiltinClassType("flags", "sys", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PFloatInfo = new PythonBuiltinClassType("float_info", "sys", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PIntInfo = new PythonBuiltinClassType("int_info", "sys", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PHashInfo = new PythonBuiltinClassType("hash_info", "sys", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PThreadInfo = new PythonBuiltinClassType("thread_info", "sys", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PUnraisableHookArgs = new PythonBuiltinClassType("UnraisableHookArgs", "sys", Flags.PUBLIC_DERIVED_WODICT, 3534929883299840L);
    public static final /* enum */ PythonBuiltinClassType PSSLSession = new PythonBuiltinClassType("SSLSession", "_ssl");
    public static final /* enum */ PythonBuiltinClassType PSSLContext = new PythonBuiltinClassType("_SSLContext", "_ssl");
    public static final /* enum */ PythonBuiltinClassType PSSLSocket = new PythonBuiltinClassType("_SSLSocket", "_ssl");
    public static final /* enum */ PythonBuiltinClassType PMemoryBIO = new PythonBuiltinClassType("MemoryBIO", "_ssl");
    public static final /* enum */ PythonBuiltinClassType PTee = new PythonBuiltinClassType("_tee", "itertools", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PTeeDataObject = new PythonBuiltinClassType("_tee_dataobject", "itertools", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PAccumulate = new PythonBuiltinClassType("accumulate", "itertools");
    public static final /* enum */ PythonBuiltinClassType PCombinations = new PythonBuiltinClassType("combinations", "itertools");
    public static final /* enum */ PythonBuiltinClassType PCombinationsWithReplacement = new PythonBuiltinClassType("combinations_with_replacement", "itertools");
    public static final /* enum */ PythonBuiltinClassType PCompress = new PythonBuiltinClassType("compress", "itertools");
    public static final /* enum */ PythonBuiltinClassType PCycle = new PythonBuiltinClassType("cycle", "itertools");
    public static final /* enum */ PythonBuiltinClassType PDropwhile = new PythonBuiltinClassType("dropwhile", "itertools");
    public static final /* enum */ PythonBuiltinClassType PFilterfalse = new PythonBuiltinClassType("filterfalse", "itertools");
    public static final /* enum */ PythonBuiltinClassType PGroupBy = new PythonBuiltinClassType("groupby", "itertools");
    public static final /* enum */ PythonBuiltinClassType PGrouper = new PythonBuiltinClassType("grouper", "itertools", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType PPairwise = new PythonBuiltinClassType("pairwise", "itertools");
    public static final /* enum */ PythonBuiltinClassType PPermutations = new PythonBuiltinClassType("permutations", "itertools");
    public static final /* enum */ PythonBuiltinClassType PProduct = new PythonBuiltinClassType("product", "itertools");
    public static final /* enum */ PythonBuiltinClassType PRepeat = new PythonBuiltinClassType("repeat", "itertools");
    public static final /* enum */ PythonBuiltinClassType PChain = new PythonBuiltinClassType("chain", "itertools");
    public static final /* enum */ PythonBuiltinClassType PCount = new PythonBuiltinClassType("count", "itertools");
    public static final /* enum */ PythonBuiltinClassType PIslice = new PythonBuiltinClassType("islice", "itertools");
    public static final /* enum */ PythonBuiltinClassType PStarmap = new PythonBuiltinClassType("starmap", "itertools");
    public static final /* enum */ PythonBuiltinClassType PTakewhile = new PythonBuiltinClassType("takewhile", "itertools");
    public static final /* enum */ PythonBuiltinClassType PZipLongest = new PythonBuiltinClassType("zip_longest", "itertools");
    public static final /* enum */ PythonBuiltinClassType JSONScanner = new PythonBuiltinClassType("Scanner", "_json", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType JSONEncoder = new PythonBuiltinClassType("Encoder", "_json", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType CSVDialect = new PythonBuiltinClassType("Dialect", "_csv", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType CSVReader = new PythonBuiltinClassType("Reader", "_csv", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType CSVWriter = new PythonBuiltinClassType("Writer", "_csv", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType PEncodingMap = new PythonBuiltinClassType("EncodingMap", Flags.PRIVATE_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType MD5Type = new PythonBuiltinClassType("md5", "_md5", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType SHA1Type = new PythonBuiltinClassType("sha1", "_sha1", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType SHA224Type = new PythonBuiltinClassType("sha224", "_sha256", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType SHA256Type = new PythonBuiltinClassType("sha256", "_sha256", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType SHA384Type = new PythonBuiltinClassType("sha384", "_sha512", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType SHA512Type = new PythonBuiltinClassType("sha512", "_sha512", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Sha3SHA224Type = new PythonBuiltinClassType("sha3_224", "_sha3", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Sha3SHA256Type = new PythonBuiltinClassType("sha3_256", "_sha3", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Sha3SHA384Type = new PythonBuiltinClassType("sha3_384", "_sha3", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Sha3SHA512Type = new PythonBuiltinClassType("sha3_512", "_sha3", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Sha3Shake128Type = new PythonBuiltinClassType("shake_128", "_sha3", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Sha3Shake256Type = new PythonBuiltinClassType("shake_256", "_sha3", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Blake2bType = new PythonBuiltinClassType("blake2b", "_blake2", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Blake2sType = new PythonBuiltinClassType("blake2s", "_blake2", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType HashlibHash = new PythonBuiltinClassType("HASH", "_hashlib", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType HashlibHashXof = new PythonBuiltinClassType("HASHXOF", "_hashlib", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType HashlibHmac = new PythonBuiltinClassType("HMAC", "_hashlib", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType UnsupportedDigestmodError = new PythonBuiltinClassType("UnsupportedDigestmodError", "_hashlib", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType AST = new PythonBuiltinClassType("AST", "_ast", "ast", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType CArgObject = new PythonBuiltinClassType("CArgObject", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType CThunkObject = new PythonBuiltinClassType("CThunkObject", "_ctypes", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType StgDict = new PythonBuiltinClassType("StgDict", Flags.PRIVATE_DERIVED_WODICT, 8022037104721920L);
    public static final /* enum */ PythonBuiltinClassType PyCStructType = new PythonBuiltinClassType("PyCStructType", "_ctypes", Flags.PUBLIC_BASE_WODICT, 0x40000008000L);
    public static final /* enum */ PythonBuiltinClassType UnionType = new PythonBuiltinClassType("UnionType", "_ctypes", Flags.PUBLIC_BASE_WODICT, 0x40000008000L);
    public static final /* enum */ PythonBuiltinClassType PyCPointerType = new PythonBuiltinClassType("PyCPointerType", "_ctypes", Flags.PUBLIC_BASE_WODICT, 0x40000008000L);
    public static final /* enum */ PythonBuiltinClassType PyCArrayType = new PythonBuiltinClassType("PyCArrayType", "_ctypes", Flags.PUBLIC_BASE_WODICT, 0x40000008000L);
    public static final /* enum */ PythonBuiltinClassType PyCSimpleType = new PythonBuiltinClassType("PyCSimpleType", "_ctypes", Flags.PUBLIC_BASE_WODICT, 0x40000008000L);
    public static final /* enum */ PythonBuiltinClassType PyCFuncPtrType = new PythonBuiltinClassType("PyCFuncPtrType", "_ctypes", Flags.PUBLIC_BASE_WODICT, 0x40000008000L);
    public static final /* enum */ PythonBuiltinClassType Structure = new PythonBuiltinClassType("Structure", "_ctypes", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType Union = new PythonBuiltinClassType("Union", "_ctypes", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType PyCPointer = new PythonBuiltinClassType("_Pointer", "_ctypes", Flags.PUBLIC_BASE_WODICT, 0x8280000000200L);
    public static final /* enum */ PythonBuiltinClassType PyCArray = new PythonBuiltinClassType("Array", "_ctypes", Flags.PUBLIC_BASE_WODICT, 7926379324637184L);
    public static final /* enum */ PythonBuiltinClassType PyCData = new PythonBuiltinClassType("_CData", "_ctypes", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType SimpleCData = new PythonBuiltinClassType("_SimpleCData", "_ctypes", Flags.PUBLIC_BASE_WODICT, 512L);
    public static final /* enum */ PythonBuiltinClassType PyCFuncPtr = new PythonBuiltinClassType("PyCFuncPtr", "_ctypes", Flags.PUBLIC_BASE_WODICT, 512L);
    public static final /* enum */ PythonBuiltinClassType CField = new PythonBuiltinClassType("CField", "_ctypes", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType DictRemover = new PythonBuiltinClassType("DictRemover", "_ctypes", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType StructParam = new PythonBuiltinClassType("StructParam_Type", "_ctypes", Flags.PUBLIC_BASE_WODICT);
    public static final /* enum */ PythonBuiltinClassType ArgError = new PythonBuiltinClassType("ArgumentError", "_ctypes", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType MultibyteCodec = new PythonBuiltinClassType("MultibyteCodec", "_multibytecodec", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType MultibyteIncrementalEncoder = new PythonBuiltinClassType("MultibyteIncrementalEncoder", "_multibytecodec", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType MultibyteIncrementalDecoder = new PythonBuiltinClassType("MultibyteIncrementalDecoder", "_multibytecodec", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType MultibyteStreamReader = new PythonBuiltinClassType("MultibyteStreamReader", "_multibytecodec", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType MultibyteStreamWriter = new PythonBuiltinClassType("MultibyteStreamWriter", "_multibytecodec", Flags.PUBLIC_BASE_WDICT);
    public static final /* enum */ PythonBuiltinClassType PBaseException = new PythonBuiltinClassType("BaseException", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SystemExit = new PythonBuiltinClassType("SystemExit", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType KeyboardInterrupt = new PythonBuiltinClassType("KeyboardInterrupt", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType GeneratorExit = new PythonBuiltinClassType("GeneratorExit", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType Exception = new PythonBuiltinClassType("Exception", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType StopIteration = new PythonBuiltinClassType("StopIteration", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType StopAsyncIteration = new PythonBuiltinClassType("StopAsyncIteration", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ArithmeticError = new PythonBuiltinClassType("ArithmeticError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType FloatingPointError = new PythonBuiltinClassType("FloatingPointError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType OverflowError = new PythonBuiltinClassType("OverflowError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ZeroDivisionError = new PythonBuiltinClassType("ZeroDivisionError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType AssertionError = new PythonBuiltinClassType("AssertionError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType AttributeError = new PythonBuiltinClassType("AttributeError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType BufferError = new PythonBuiltinClassType("BufferError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType EOFError = new PythonBuiltinClassType("EOFError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ImportError = new PythonBuiltinClassType("ImportError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ModuleNotFoundError = new PythonBuiltinClassType("ModuleNotFoundError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType LookupError = new PythonBuiltinClassType("LookupError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType IndexError = new PythonBuiltinClassType("IndexError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType KeyError = new PythonBuiltinClassType("KeyError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType MemoryError = new PythonBuiltinClassType("MemoryError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType NameError = new PythonBuiltinClassType("NameError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UnboundLocalError = new PythonBuiltinClassType("UnboundLocalError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType OSError = new PythonBuiltinClassType("OSError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType BlockingIOError = new PythonBuiltinClassType("BlockingIOError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ChildProcessError = new PythonBuiltinClassType("ChildProcessError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ConnectionError = new PythonBuiltinClassType("ConnectionError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType BrokenPipeError = new PythonBuiltinClassType("BrokenPipeError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ConnectionAbortedError = new PythonBuiltinClassType("ConnectionAbortedError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ConnectionRefusedError = new PythonBuiltinClassType("ConnectionRefusedError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ConnectionResetError = new PythonBuiltinClassType("ConnectionResetError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType FileExistsError = new PythonBuiltinClassType("FileExistsError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType FileNotFoundError = new PythonBuiltinClassType("FileNotFoundError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType InterruptedError = new PythonBuiltinClassType("InterruptedError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType IsADirectoryError = new PythonBuiltinClassType("IsADirectoryError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType NotADirectoryError = new PythonBuiltinClassType("NotADirectoryError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType PermissionError = new PythonBuiltinClassType("PermissionError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ProcessLookupError = new PythonBuiltinClassType("ProcessLookupError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType TimeoutError = new PythonBuiltinClassType("TimeoutError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ZLibError = new PythonBuiltinClassType("error", "zlib", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType CSVError = new PythonBuiltinClassType("Error", "_csv", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType LZMAError = new PythonBuiltinClassType("LZMAError", "_lzma", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType StructError = new PythonBuiltinClassType("StructError", "_struct", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType PickleError = new PythonBuiltinClassType("PickleError", "_pickle", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType PicklingError = new PythonBuiltinClassType("PicklingError", "_pickle", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UnpicklingError = new PythonBuiltinClassType("UnpicklingError", "_pickle", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SocketGAIError = new PythonBuiltinClassType("gaierror", "_socket", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SocketHError = new PythonBuiltinClassType("herror", "_socket", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType BinasciiError = new PythonBuiltinClassType("Error", "binascii", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType BinasciiIncomplete = new PythonBuiltinClassType("Incomplete", "binascii", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SSLError = new PythonBuiltinClassType("SSLError", "_ssl", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SSLZeroReturnError = new PythonBuiltinClassType("SSLZeroReturnError", "_ssl", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SSLWantReadError = new PythonBuiltinClassType("SSLWantReadError", "_ssl", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SSLWantWriteError = new PythonBuiltinClassType("SSLWantWriteError", "_ssl", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SSLSyscallError = new PythonBuiltinClassType("SSLSyscallError", "_ssl", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SSLEOFError = new PythonBuiltinClassType("SSLEOFError", "_ssl", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SSLCertVerificationError = new PythonBuiltinClassType("SSLCertVerificationError", "_ssl", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType PForeignException = new PythonBuiltinClassType("ForeignException", Flags.FOREIGN_EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ReferenceError = new PythonBuiltinClassType("ReferenceError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType RuntimeError = new PythonBuiltinClassType("RuntimeError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType NotImplementedError = new PythonBuiltinClassType("NotImplementedError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SyntaxError = new PythonBuiltinClassType("SyntaxError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType IndentationError = new PythonBuiltinClassType("IndentationError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType TabError = new PythonBuiltinClassType("TabError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SystemError = new PythonBuiltinClassType("SystemError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType TypeError = new PythonBuiltinClassType("TypeError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ValueError = new PythonBuiltinClassType("ValueError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UnicodeError = new PythonBuiltinClassType("UnicodeError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UnicodeDecodeError = new PythonBuiltinClassType("UnicodeDecodeError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UnicodeEncodeError = new PythonBuiltinClassType("UnicodeEncodeError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UnicodeTranslateError = new PythonBuiltinClassType("UnicodeTranslateError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType RecursionError = new PythonBuiltinClassType("RecursionError", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType IOUnsupportedOperation = new PythonBuiltinClassType("UnsupportedOperation", "io", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType Empty = new PythonBuiltinClassType("Empty", "_queue", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType Warning = new PythonBuiltinClassType("Warning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType BytesWarning = new PythonBuiltinClassType("BytesWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType DeprecationWarning = new PythonBuiltinClassType("DeprecationWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType FutureWarning = new PythonBuiltinClassType("FutureWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ImportWarning = new PythonBuiltinClassType("ImportWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType PendingDeprecationWarning = new PythonBuiltinClassType("PendingDeprecationWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ResourceWarning = new PythonBuiltinClassType("ResourceWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType RuntimeWarning = new PythonBuiltinClassType("RuntimeWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType SyntaxWarning = new PythonBuiltinClassType("SyntaxWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UnicodeWarning = new PythonBuiltinClassType("UnicodeWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType UserWarning = new PythonBuiltinClassType("UserWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType EncodingWarning = new PythonBuiltinClassType("EncodingWarning", "builtins", Flags.EXCEPTION);
    public static final /* enum */ PythonBuiltinClassType ContextVarsToken = new PythonBuiltinClassType("Token", "_contextvars", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType ContextVarsContext = new PythonBuiltinClassType("Context", "_contextvars", Flags.PUBLIC_DERIVED_WODICT, 0xC800000000000L);
    public static final /* enum */ PythonBuiltinClassType ContextVar = new PythonBuiltinClassType("ContextVar", "_contextvars", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType ContextIterator = new PythonBuiltinClassType("context_iterator", "_contextvars", Flags.PUBLIC_DERIVED_WODICT);
    public static final /* enum */ PythonBuiltinClassType Capsule = new PythonBuiltinClassType("capsule");
    public static final /* enum */ PythonBuiltinClassType nil = new PythonBuiltinClassType("nil");
    private final TruffleString name;
    private final TruffleString publishInModule;
    private final TruffleString moduleName;
    private final TruffleString printName;
    private final boolean basetype;
    private final boolean isBuiltinWithDict;
    @CompilerDirectives.CompilationFinal
    private PythonBuiltinClassType type;
    @CompilerDirectives.CompilationFinal
    private PythonBuiltinClassType base;
    @CompilerDirectives.CompilationFinal
    private int weaklistoffset;
    private SpecialMethodSlot[] redefinedSlots;
    private Object[] specialMethodSlots;
    private final long methodsFlags;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final PythonBuiltinClassType[] VALUES;
    private static final /* synthetic */ PythonBuiltinClassType[] $VALUES;

    public static PythonBuiltinClassType[] values() {
        return (PythonBuiltinClassType[])$VALUES.clone();
    }

    public static PythonBuiltinClassType valueOf(String name) {
        return Enum.valueOf(PythonBuiltinClassType.class, name);
    }

    private PythonBuiltinClassType(String name, String module, Flags flags) {
        this(name, module, module, flags);
    }

    private PythonBuiltinClassType(String name, String module, Flags flags, long methodsFlags) {
        this(name, module, module, flags, methodsFlags);
    }

    private PythonBuiltinClassType(String name, String publishInModule, String moduleName, Flags flags) {
        this(name, publishInModule, moduleName, flags, 0L);
    }

    private PythonBuiltinClassType(String name, String publishInModule, String moduleName, Flags flags, long methodsFlags) {
        this.name = PythonUtils.toTruffleStringUncached(name);
        this.publishInModule = PythonUtils.toTruffleStringUncached(publishInModule);
        this.moduleName = flags.isPublic && moduleName != null ? PythonUtils.toTruffleStringUncached(moduleName) : null;
        this.printName = moduleName != null && moduleName != "builtins" ? PythonUtils.toTruffleStringUncached(moduleName + "." + name) : this.name;
        this.basetype = flags.isBaseType;
        this.isBuiltinWithDict = flags.isBuiltinWithDict;
        this.methodsFlags = methodsFlags;
        this.weaklistoffset = -1;
    }

    private PythonBuiltinClassType(String name, String module) {
        this(name, module, Flags.PUBLIC_BASE_WODICT);
    }

    private PythonBuiltinClassType(String name, String module, long methodsFlags) {
        this(name, module, Flags.PUBLIC_BASE_WODICT, methodsFlags);
    }

    private PythonBuiltinClassType(String name, Flags flags) {
        this(name, null, flags);
    }

    private PythonBuiltinClassType(String name, Flags flags, long methodsFlags) {
        this(name, null, flags, methodsFlags);
    }

    private PythonBuiltinClassType(String name) {
        this(name, null, Flags.PRIVATE_BASE_WODICT);
    }

    public boolean isAcceptableBase() {
        return this.basetype;
    }

    public TruffleString getName() {
        return this.name;
    }

    public TruffleString getPrintName() {
        return this.printName;
    }

    public PythonBuiltinClassType getType() {
        return this.type;
    }

    public PythonBuiltinClassType getBase() {
        return this.base;
    }

    public boolean isBuiltinWithDict() {
        return this.isBuiltinWithDict;
    }

    public TruffleString getPublishInModule() {
        return this.publishInModule;
    }

    public TruffleString getModuleName() {
        return this.moduleName;
    }

    public Object[] getSpecialMethodSlots() {
        return this.specialMethodSlots;
    }

    public void setSpecialMethodSlots(Object[] slots) {
        assert (this.specialMethodSlots == null);
        this.specialMethodSlots = slots;
    }

    public long getMethodsFlags() {
        return this.methodsFlags;
    }

    public int getWeaklistoffset() {
        return this.weaklistoffset;
    }

    public boolean redefinesSlot(SpecialMethodSlot slot) {
        if (this.redefinedSlots != null) {
            for (SpecialMethodSlot redefSlot : this.redefinedSlots) {
                if (redefSlot != slot) continue;
                return true;
            }
        }
        if (this.base != null) {
            return this.base.redefinesSlot(slot);
        }
        return false;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return this.name.toJavaStringUncached();
    }

    public final Shape getInstanceShape(PythonLanguage lang) {
        if (this.name == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"incorrect use of Python builtin type marker");
        }
        return lang.getBuiltinTypeInstanceShape(this);
    }

    @ExportMessage
    public Object send(Message message, Object[] args, @CachedLibrary(limit="1") ReflectionLibrary lib) throws Exception {
        return lib.send((Object)PythonContext.get((Node)lib).lookupType(this), message, args);
    }

    private static /* synthetic */ PythonBuiltinClassType[] $values() {
        return new PythonBuiltinClassType[]{ForeignObject, Boolean, PArray, PArrayIterator, PIterator, PBuiltinFunction, PBuiltinFunctionOrMethod, WrapperDescriptor, MethodWrapper, PBuiltinMethod, PBuiltinClassMethod, GetSetDescriptor, MemberDescriptor, PByteArray, PBytes, PCell, PSimpleNamespace, PKeyWrapper, PPartial, PLruListElem, PLruCacheWrapper, PDefaultDict, PDeque, PTupleGetter, PDequeIter, PDequeRevIter, POrderedDict, POrderedDictKeys, POrderedDictValues, POrderedDictItems, POrderedDictIterator, PComplex, PDict, PDictItemIterator, PDictReverseItemIterator, PDictItemsView, PDictKeyIterator, PDictReverseKeyIterator, PDictKeysView, PDictValueIterator, PDictReverseValueIterator, PDictValuesView, PEllipsis, PEnumerate, PMap, PFloat, PFrame, PFrozenSet, PFunction, PGenerator, PCoroutine, PCoroutineWrapper, PAsyncGenerator, PInt, PList, PMappingproxy, PMemoryView, PAsyncGenASend, PAsyncGenAThrow, PAsyncGenAWrappedValue, PMethod, PMMap, PNone, PNotImplemented, PProperty, PSimpleQueue, PRandom, PRange, PReferenceType, PSentinelIterator, PForeignArrayIterator, PReverseIterator, PSet, PSlice, PString, PTraceback, PTuple, PythonClass, PythonModule, PythonModuleDef, PythonObject, Super, PCode, PGenericAlias, PUnionType, PZip, PThread, PThreadLocal, PLock, PRLock, PSemLock, PGraalPySemLock, PSocket, PStaticmethod, PClassmethod, PInstancemethod, PScandirIterator, PDirEntry, LsprofProfiler, PStruct, PStructUnpackIterator, Pickler, PicklerMemoProxy, UnpicklerMemoProxy, Unpickler, PickleBuffer, BZ2Compressor, BZ2Decompressor, PLZMACompressor, PLZMADecompressor, ZlibCompress, ZlibDecompress, PIOBase, PRawIOBase, PTextIOBase, PBufferedIOBase, PBufferedReader, PBufferedWriter, PBufferedRWPair, PBufferedRandom, PFileIO, PTextIOWrapper, PIncrementalNewlineDecoder, PStringIO, PBytesIO, PBytesIOBuf, PStatResult, PStatvfsResult, PTerminalSize, PUnameResult, PStructTime, PProfilerEntry, PProfilerSubentry, PStructPasswd, PStructRusage, PVersionInfo, PFlags, PFloatInfo, PIntInfo, PHashInfo, PThreadInfo, PUnraisableHookArgs, PSSLSession, PSSLContext, PSSLSocket, PMemoryBIO, PTee, PTeeDataObject, PAccumulate, PCombinations, PCombinationsWithReplacement, PCompress, PCycle, PDropwhile, PFilterfalse, PGroupBy, PGrouper, PPairwise, PPermutations, PProduct, PRepeat, PChain, PCount, PIslice, PStarmap, PTakewhile, PZipLongest, JSONScanner, JSONEncoder, CSVDialect, CSVReader, CSVWriter, PEncodingMap, MD5Type, SHA1Type, SHA224Type, SHA256Type, SHA384Type, SHA512Type, Sha3SHA224Type, Sha3SHA256Type, Sha3SHA384Type, Sha3SHA512Type, Sha3Shake128Type, Sha3Shake256Type, Blake2bType, Blake2sType, HashlibHash, HashlibHashXof, HashlibHmac, UnsupportedDigestmodError, AST, CArgObject, CThunkObject, StgDict, PyCStructType, UnionType, PyCPointerType, PyCArrayType, PyCSimpleType, PyCFuncPtrType, Structure, Union, PyCPointer, PyCArray, PyCData, SimpleCData, PyCFuncPtr, CField, DictRemover, StructParam, ArgError, MultibyteCodec, MultibyteIncrementalEncoder, MultibyteIncrementalDecoder, MultibyteStreamReader, MultibyteStreamWriter, PBaseException, SystemExit, KeyboardInterrupt, GeneratorExit, Exception, StopIteration, StopAsyncIteration, ArithmeticError, FloatingPointError, OverflowError, ZeroDivisionError, AssertionError, AttributeError, BufferError, EOFError, ImportError, ModuleNotFoundError, LookupError, IndexError, KeyError, MemoryError, NameError, UnboundLocalError, OSError, BlockingIOError, ChildProcessError, ConnectionError, BrokenPipeError, ConnectionAbortedError, ConnectionRefusedError, ConnectionResetError, FileExistsError, FileNotFoundError, InterruptedError, IsADirectoryError, NotADirectoryError, PermissionError, ProcessLookupError, TimeoutError, ZLibError, CSVError, LZMAError, StructError, PickleError, PicklingError, UnpicklingError, SocketGAIError, SocketHError, BinasciiError, BinasciiIncomplete, SSLError, SSLZeroReturnError, SSLWantReadError, SSLWantWriteError, SSLSyscallError, SSLEOFError, SSLCertVerificationError, PForeignException, ReferenceError, RuntimeError, NotImplementedError, SyntaxError, IndentationError, TabError, SystemError, TypeError, ValueError, UnicodeError, UnicodeDecodeError, UnicodeEncodeError, UnicodeTranslateError, RecursionError, IOUnsupportedOperation, Empty, Warning, BytesWarning, DeprecationWarning, FutureWarning, ImportWarning, PendingDeprecationWarning, ResourceWarning, RuntimeWarning, SyntaxWarning, UnicodeWarning, UserWarning, EncodingWarning, ContextVarsToken, ContextVarsContext, ContextVar, ContextIterator, Capsule, nil};
    }

    static {
        $VALUES = PythonBuiltinClassType.$values();
        VALUES = Arrays.copyOf(PythonBuiltinClassType.values(), PythonBuiltinClassType.values().length - 1);
        SpecialMethodSlot[] repr = new SpecialMethodSlot[]{SpecialMethodSlot.Repr};
        SpecialMethodSlot[] reprAndNew = new SpecialMethodSlot[]{SpecialMethodSlot.Repr, SpecialMethodSlot.New};
        PythonBuiltinClassType.Boolean.redefinedSlots = new SpecialMethodSlot[]{SpecialMethodSlot.And};
        PythonBuiltinClassType.Super.redefinedSlots = repr;
        PythonBuiltinClassType.PythonModule.redefinedSlots = repr;
        PythonBuiltinClassType.SyntaxError.redefinedSlots = new SpecialMethodSlot[]{SpecialMethodSlot.Str};
        PythonBuiltinClassType.UnicodeEncodeError.redefinedSlots = new SpecialMethodSlot[]{SpecialMethodSlot.Str};
        PythonBuiltinClassType.UnicodeDecodeError.redefinedSlots = new SpecialMethodSlot[]{SpecialMethodSlot.Str};
        PythonBuiltinClassType.UnicodeTranslateError.redefinedSlots = new SpecialMethodSlot[]{SpecialMethodSlot.Str};
        PythonBuiltinClassType.OSError.redefinedSlots = new SpecialMethodSlot[]{SpecialMethodSlot.Str};
        PythonBuiltinClassType.PStructUnpackIterator.redefinedSlots = new SpecialMethodSlot[]{SpecialMethodSlot.Next, SpecialMethodSlot.Iter, SpecialMethodSlot.LengthHint};
        PythonBuiltinClassType.PStruct.type = PythonClass;
        PythonBuiltinClassType.PStructRusage.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PStructPasswd.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PUnameResult.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PUnraisableHookArgs.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PIntInfo.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PHashInfo.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PStructTime.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PProfilerEntry.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PProfilerSubentry.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PThreadInfo.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PStatResult.redefinedSlots = repr;
        PythonBuiltinClassType.PStatvfsResult.redefinedSlots = repr;
        PythonBuiltinClassType.PFloatInfo.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PVersionInfo.redefinedSlots = repr;
        PythonBuiltinClassType.PFlags.redefinedSlots = repr;
        PythonBuiltinClassType.PTerminalSize.redefinedSlots = reprAndNew;
        PythonBuiltinClassType.PythonObject.type = PythonClass;
        PythonBuiltinClassType.PythonObject.base = null;
        PythonBuiltinClassType.PBuiltinMethod.base = PBuiltinFunctionOrMethod;
        PythonBuiltinClassType.Boolean.base = PInt;
        PythonBuiltinClassType.SystemExit.base = PBaseException;
        PythonBuiltinClassType.KeyboardInterrupt.base = PBaseException;
        PythonBuiltinClassType.GeneratorExit.base = PBaseException;
        PythonBuiltinClassType.Exception.base = PBaseException;
        PythonBuiltinClassType.StopIteration.base = Exception;
        PythonBuiltinClassType.StopAsyncIteration.base = Exception;
        PythonBuiltinClassType.ArithmeticError.base = Exception;
        PythonBuiltinClassType.FloatingPointError.base = ArithmeticError;
        PythonBuiltinClassType.OverflowError.base = ArithmeticError;
        PythonBuiltinClassType.ZeroDivisionError.base = ArithmeticError;
        PythonBuiltinClassType.AssertionError.base = Exception;
        PythonBuiltinClassType.AttributeError.base = Exception;
        PythonBuiltinClassType.BufferError.base = Exception;
        PythonBuiltinClassType.EOFError.base = Exception;
        PythonBuiltinClassType.ImportError.base = Exception;
        PythonBuiltinClassType.ModuleNotFoundError.base = ImportError;
        PythonBuiltinClassType.LookupError.base = Exception;
        PythonBuiltinClassType.IndexError.base = LookupError;
        PythonBuiltinClassType.KeyError.base = LookupError;
        PythonBuiltinClassType.MemoryError.base = Exception;
        PythonBuiltinClassType.NameError.base = Exception;
        PythonBuiltinClassType.UnboundLocalError.base = NameError;
        PythonBuiltinClassType.OSError.base = Exception;
        PythonBuiltinClassType.BlockingIOError.base = OSError;
        PythonBuiltinClassType.ChildProcessError.base = OSError;
        PythonBuiltinClassType.ConnectionError.base = OSError;
        PythonBuiltinClassType.BrokenPipeError.base = ConnectionError;
        PythonBuiltinClassType.ConnectionAbortedError.base = ConnectionError;
        PythonBuiltinClassType.ConnectionRefusedError.base = ConnectionError;
        PythonBuiltinClassType.ConnectionResetError.base = ConnectionError;
        PythonBuiltinClassType.FileExistsError.base = OSError;
        PythonBuiltinClassType.FileNotFoundError.base = OSError;
        PythonBuiltinClassType.InterruptedError.base = OSError;
        PythonBuiltinClassType.IsADirectoryError.base = OSError;
        PythonBuiltinClassType.NotADirectoryError.base = OSError;
        PythonBuiltinClassType.PermissionError.base = OSError;
        PythonBuiltinClassType.ProcessLookupError.base = OSError;
        PythonBuiltinClassType.TimeoutError.base = OSError;
        PythonBuiltinClassType.ZLibError.base = Exception;
        PythonBuiltinClassType.CSVError.base = Exception;
        PythonBuiltinClassType.LZMAError.base = Exception;
        PythonBuiltinClassType.SocketGAIError.base = OSError;
        PythonBuiltinClassType.SocketHError.base = OSError;
        PythonBuiltinClassType.SSLError.base = OSError;
        PythonBuiltinClassType.SSLZeroReturnError.base = SSLError;
        PythonBuiltinClassType.SSLWantReadError.base = SSLError;
        PythonBuiltinClassType.SSLWantWriteError.base = SSLError;
        PythonBuiltinClassType.SSLSyscallError.base = SSLError;
        PythonBuiltinClassType.SSLCertVerificationError.base = SSLError;
        PythonBuiltinClassType.SSLEOFError.base = SSLError;
        PythonBuiltinClassType.ReferenceError.base = Exception;
        PythonBuiltinClassType.RuntimeError.base = Exception;
        PythonBuiltinClassType.NotImplementedError.base = RuntimeError;
        PythonBuiltinClassType.SyntaxError.base = Exception;
        PythonBuiltinClassType.IndentationError.base = SyntaxError;
        PythonBuiltinClassType.TabError.base = IndentationError;
        PythonBuiltinClassType.SystemError.base = Exception;
        PythonBuiltinClassType.TypeError.base = Exception;
        PythonBuiltinClassType.ValueError.base = Exception;
        PythonBuiltinClassType.UnicodeError.base = ValueError;
        PythonBuiltinClassType.UnicodeDecodeError.base = UnicodeError;
        PythonBuiltinClassType.UnicodeEncodeError.base = UnicodeError;
        PythonBuiltinClassType.UnicodeTranslateError.base = UnicodeError;
        PythonBuiltinClassType.RecursionError.base = RuntimeError;
        PythonBuiltinClassType.StructError.base = Exception;
        PythonBuiltinClassType.BinasciiError.base = ValueError;
        PythonBuiltinClassType.BinasciiIncomplete.base = Exception;
        PythonBuiltinClassType.PickleError.base = Exception;
        PythonBuiltinClassType.PicklingError.base = PickleError;
        PythonBuiltinClassType.UnpicklingError.base = PickleError;
        PythonBuiltinClassType.PForeignException.base = PBaseException;
        PythonBuiltinClassType.Warning.base = Exception;
        PythonBuiltinClassType.BytesWarning.base = Warning;
        PythonBuiltinClassType.DeprecationWarning.base = Warning;
        PythonBuiltinClassType.FutureWarning.base = Warning;
        PythonBuiltinClassType.ImportWarning.base = Warning;
        PythonBuiltinClassType.PendingDeprecationWarning.base = Warning;
        PythonBuiltinClassType.ResourceWarning.base = Warning;
        PythonBuiltinClassType.RuntimeWarning.base = Warning;
        PythonBuiltinClassType.SyntaxWarning.base = Warning;
        PythonBuiltinClassType.UnicodeWarning.base = Warning;
        PythonBuiltinClassType.UserWarning.base = Warning;
        PythonBuiltinClassType.EncodingWarning.base = Warning;
        PythonBuiltinClassType.PStatResult.base = PTuple;
        PythonBuiltinClassType.PStatvfsResult.base = PTuple;
        PythonBuiltinClassType.PTerminalSize.base = PTuple;
        PythonBuiltinClassType.PUnameResult.base = PTuple;
        PythonBuiltinClassType.PStructTime.base = PTuple;
        PythonBuiltinClassType.PProfilerEntry.base = PTuple;
        PythonBuiltinClassType.PProfilerSubentry.base = PTuple;
        PythonBuiltinClassType.PStructPasswd.base = PTuple;
        PythonBuiltinClassType.PStructRusage.base = PTuple;
        PythonBuiltinClassType.PVersionInfo.base = PTuple;
        PythonBuiltinClassType.PFlags.base = PTuple;
        PythonBuiltinClassType.PFloatInfo.base = PTuple;
        PythonBuiltinClassType.PIntInfo.base = PTuple;
        PythonBuiltinClassType.PHashInfo.base = PTuple;
        PythonBuiltinClassType.PThreadInfo.base = PTuple;
        PythonBuiltinClassType.PUnraisableHookArgs.base = PTuple;
        PythonBuiltinClassType.PDefaultDict.base = PDict;
        PythonBuiltinClassType.POrderedDict.base = PDict;
        PythonBuiltinClassType.POrderedDictKeys.base = PDictKeysView;
        PythonBuiltinClassType.POrderedDictValues.base = PDictValuesView;
        PythonBuiltinClassType.POrderedDictItems.base = PDictItemsView;
        PythonBuiltinClassType.PArrayIterator.type = PythonClass;
        PythonBuiltinClassType.PSocket.type = PythonClass;
        PythonBuiltinClassType.IOUnsupportedOperation.base = OSError;
        PythonBuiltinClassType.PRawIOBase.base = PIOBase;
        PythonBuiltinClassType.PTextIOBase.base = PIOBase;
        PythonBuiltinClassType.PBufferedIOBase.base = PIOBase;
        PythonBuiltinClassType.PBufferedReader.base = PBufferedIOBase;
        PythonBuiltinClassType.PBufferedWriter.base = PBufferedIOBase;
        PythonBuiltinClassType.PBufferedRWPair.base = PBufferedIOBase;
        PythonBuiltinClassType.PBufferedRandom.base = PBufferedIOBase;
        PythonBuiltinClassType.PBytesIO.base = PBufferedIOBase;
        PythonBuiltinClassType.PFileIO.base = PRawIOBase;
        PythonBuiltinClassType.PTextIOWrapper.base = PTextIOBase;
        PythonBuiltinClassType.PStringIO.base = PTextIOBase;
        PythonBuiltinClassType.UnsupportedDigestmodError.base = ValueError;
        PythonBuiltinClassType.HashlibHashXof.base = HashlibHash;
        PythonBuiltinClassType.StgDict.base = PDict;
        PythonBuiltinClassType.PyCStructType.base = PythonClass;
        PythonBuiltinClassType.UnionType.base = PythonClass;
        PythonBuiltinClassType.PyCPointerType.base = PythonClass;
        PythonBuiltinClassType.PyCArrayType.base = PythonClass;
        PythonBuiltinClassType.PyCSimpleType.base = PythonClass;
        PythonBuiltinClassType.PyCFuncPtrType.base = PythonClass;
        PythonBuiltinClassType.Structure.type = PyCStructType;
        PythonBuiltinClassType.Structure.base = PyCData;
        PythonBuiltinClassType.Union.type = UnionType;
        PythonBuiltinClassType.Union.base = PyCData;
        PythonBuiltinClassType.PyCPointer.type = PyCPointerType;
        PythonBuiltinClassType.PyCPointer.base = PyCData;
        PythonBuiltinClassType.PyCArray.type = PyCArrayType;
        PythonBuiltinClassType.PyCArray.base = PyCData;
        PythonBuiltinClassType.SimpleCData.type = PyCSimpleType;
        PythonBuiltinClassType.SimpleCData.base = PyCData;
        PythonBuiltinClassType.PyCFuncPtr.type = PyCFuncPtrType;
        PythonBuiltinClassType.PyCFuncPtr.base = PyCData;
        PythonBuiltinClassType.ArgError.base = PBaseException;
        PythonBuiltinClassType.Empty.base = Exception;
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        HashSet<CallSite> set = assertionsEnabled ? new HashSet<CallSite>() : null;
        for (PythonBuiltinClassType type : VALUES) {
            assert (set.add((CallSite)((Object)(String.valueOf(type.moduleName) + "." + String.valueOf(type.name))))) : type.name();
            if (type.base == null && type != PythonObject) {
                type.base = PythonObject;
            }
            if (type.type == null && type.base != null) {
                type.type = type.base.type;
            }
            type.weaklistoffset = WeakRefModuleBuiltins.getBuiltinTypeWeaklistoffset(type);
        }
        for (PythonBuiltinClassType type : VALUES) {
            if (type.type != null) continue;
            type.type = PythonClass;
        }
    }

    private static class Flags {
        static final Flags EXCEPTION = new Flags(true, true, true);
        static final Flags FOREIGN_EXCEPTION = new Flags(false, false, true);
        static final Flags PRIVATE_DERIVED_WDICT = new Flags(false, false, true);
        static final Flags PRIVATE_BASE_WDICT = new Flags(false, true, true);
        static final Flags PRIVATE_BASE_WODICT = new Flags(false, true, false);
        static final Flags PUBLIC_BASE_WDICT = new Flags(true, true, true);
        static final Flags PUBLIC_BASE_WODICT = new Flags(true, true, false);
        static final Flags PUBLIC_DERIVED_WODICT = new Flags(true, false, false);
        static final Flags PRIVATE_DERIVED_WODICT = new Flags(false, false, false);
        final boolean isPublic;
        final boolean isBaseType;
        final boolean isBuiltinWithDict;

        Flags(boolean isPublic, boolean isBaseType, boolean isBuiltinWithDict) {
            this.isPublic = isPublic;
            this.isBaseType = isBaseType;
            this.isBuiltinWithDict = isBuiltinWithDict;
        }
    }
}

