/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinConstructorsClinicProviders;
import com.oracle.graal.python.builtins.modules.BuiltinConstructorsFactory;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.enumerate.PEnumerate;
import com.oracle.graal.python.builtins.objects.floats.FloatUtils;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.PBigRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PZip;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.map.PMap;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.namespace.PSimpleNamespace;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.property.PProperty;
import com.oracle.graal.python.builtins.objects.range.PBigRange;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.range.RangeNodes;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.lib.CanBeDoubleNode;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyComplexCheckExactNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatFromString;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyMemoryViewFromObject;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.SplitArgsNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.List;

@CoreFunctions(defineModule="builtins", isEager=true)
public final class BuiltinConstructors
extends PythonBuiltins {
    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BuiltinConstructorsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(BuiltinNames.T_NOT_IMPLEMENTED, (Object)PNotImplemented.NOT_IMPLEMENTED);
    }

    @Builtin(name="GenericAlias", minNumOfPositionalArgs=3, constructsClass=PythonBuiltinClassType.PGenericAlias)
    @GenerateNodeFactory
    static abstract class GenericAliasNode
    extends PythonTernaryBuiltinNode {
        GenericAliasNode() {
        }

        @Specialization
        static PGenericAlias doit(Object cls, Object origin, Object arguments, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, origin, arguments);
        }
    }

    @Builtin(name="SimpleNamespace", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, isPublic=false, constructsClass=PythonBuiltinClassType.PSimpleNamespace, doc="A simple attribute-based namespace.\n\nSimpleNamespace(**kwargs)")
    @GenerateNodeFactory
    public static abstract class SimpleNamespaceNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static PSimpleNamespace doit(Object self, Object[] args, PKeyword[] keywords, @Cached PythonObjectFactory factory) {
            return factory.createSimpleNamespace(self);
        }
    }

    @Builtin(name="property", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PProperty)
    @GenerateNodeFactory
    public static abstract class PropertyNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static PProperty doit(Object self, Object[] args, PKeyword[] keywords, @Cached PythonObjectFactory factory) {
            return factory.createProperty(self);
        }
    }

    @Builtin(name="map", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PMap)
    @GenerateNodeFactory
    public static abstract class MapNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static PMap doit(Object self, Object[] args, PKeyword[] keywords, @Cached PythonObjectFactory factory) {
            return factory.createMap(self);
        }
    }

    @Builtin(name="staticmethod", minNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PStaticmethod)
    @GenerateNodeFactory
    public static abstract class StaticmethodNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doObjectIndirect(Object self, Object callable, @Cached PythonObjectFactory factory) {
            return factory.createStaticmethod(self);
        }
    }

    @Builtin(name="instancemethod", minNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PInstancemethod, isPublic=false, doc="instancemethod(function)\n\nBind a function to a class.")
    @GenerateNodeFactory
    public static abstract class InstancemethodNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doObjectIndirect(Object self, Object callable, @Cached PythonObjectFactory factory) {
            return factory.createInstancemethod(self);
        }
    }

    @Builtin(name="classmethod", minNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PClassmethod, doc="classmethod(function) -> method\n\nConvert a function to be a class method.\n\nA class method receives the class as implicit first argument,\njust like an instance method receives the instance.\nTo declare a class method, use this idiom:\n\n  class C:\n      @classmethod\n      def f(cls, arg1, arg2, ...):\n          ...\n\nIt can be called either on the class (e.g. C.f()) or on an instance\n(e.g. C().f()).  The instance is ignored except for its class.\nIf a class method is called for a derived class, the derived class\nobject is passed as the implied first argument.\n\nClass methods are different than C++ or Java static methods.\nIf you want those, see the staticmethod builtin.")
    @GenerateNodeFactory
    public static abstract class ClassmethodNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doObjectIndirect(Object self, Object callable, @Cached PythonObjectFactory factory) {
            return factory.createClassmethod(self);
        }
    }

    @Builtin(name="super", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=3, constructsClass=PythonBuiltinClassType.Super)
    @GenerateNodeFactory
    public static abstract class SuperInitNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object doObjectIndirect(Object self, Object type, Object object, @Cached PythonObjectFactory factory) {
            return factory.createSuperObject(self);
        }
    }

    @Builtin(name="memoryview", minNumOfPositionalArgs=2, parameterNames={"$cls", "object"}, constructsClass=PythonBuiltinClassType.PMemoryView)
    @GenerateNodeFactory
    public static abstract class MemoryViewNode
    extends PythonBuiltinNode {
        public abstract PMemoryView execute(VirtualFrame var1, Object var2, Object var3);

        public final PMemoryView execute(VirtualFrame frame, Object object) {
            return this.execute(frame, (Object)PythonBuiltinClassType.PMemoryView, object);
        }

        @Specialization
        PMemoryView fromObject(VirtualFrame frame, Object cls, Object object, @Cached PyMemoryViewFromObject memoryViewFromObject) {
            return memoryViewFromObject.execute(frame, object);
        }

        @NeverDefault
        public static MemoryViewNode create() {
            return BuiltinConstructorsFactory.MemoryViewNodeFactory.create(null);
        }
    }

    @Builtin(name="slice", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4, constructsClass=PythonBuiltinClassType.PSlice)
    @GenerateNodeFactory
    static abstract class SliceNode
    extends PythonQuaternaryBuiltinNode {
        SliceNode() {
        }

        @Specialization(guards={"isNoValue(second)"})
        static Object singleArg(Object cls, Object first, Object second, Object third, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PySliceNew sliceNode) {
            return sliceNode.execute(inliningTarget, PNone.NONE, first, PNone.NONE);
        }

        @Specialization(guards={"!isNoValue(stop)", "isNoValue(step)"})
        static Object twoArgs(Object cls, Object start, Object stop, Object step, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PySliceNew sliceNode) {
            return sliceNode.execute(inliningTarget, start, stop, PNone.NONE);
        }

        @Fallback
        static Object threeArgs(Object cls, Object start, Object stop, Object step, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PySliceNew sliceNode) {
            return sliceNode.execute(inliningTarget, start, stop, step);
        }
    }

    @Builtin(name="wrapper_descriptor", constructsClass=PythonBuiltinClassType.WrapperDescriptor, isPublic=false, minNumOfPositionalArgs=1, parameterNames={"cls", "fget", "fset", "name", "owner"})
    @GenerateNodeFactory
    public static abstract class WrapperDescriptorNode
    extends DescriptorNode {
        @Specialization(guards={"isPythonClass(owner)"})
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(Object clazz, Object get, Object set, TruffleString name, Object owner) {
            this.denyInstantiationAfterInitialization(BuiltinNames.T_WRAPPER_DESCRIPTOR);
            return PythonObjectFactory.getUncached().createGetSetDescriptor(WrapperDescriptorNode.ensure(get), WrapperDescriptorNode.ensure(set), name, owner);
        }
    }

    @Builtin(name="member_descriptor", constructsClass=PythonBuiltinClassType.MemberDescriptor, isPublic=false, minNumOfPositionalArgs=1, parameterNames={"cls", "fget", "fset", "name", "owner"})
    @GenerateNodeFactory
    public static abstract class MemberDescriptorNode
    extends DescriptorNode {
        @Specialization(guards={"isPythonClass(owner)"})
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(Object clazz, Object get, Object set, TruffleString name, Object owner) {
            this.denyInstantiationAfterInitialization(BuiltinNames.T_MEMBER_DESCRIPTOR);
            return PythonObjectFactory.getUncached().createGetSetDescriptor(MemberDescriptorNode.ensure(get), MemberDescriptorNode.ensure(set), name, owner);
        }
    }

    @Builtin(name="getset_descriptor", constructsClass=PythonBuiltinClassType.GetSetDescriptor, isPublic=false, minNumOfPositionalArgs=1, parameterNames={"cls", "fget", "fset", "name", "owner"})
    @GenerateNodeFactory
    public static abstract class GetSetDescriptorNode
    extends DescriptorNode {
        @Specialization(guards={"isPythonClass(owner)"})
        @CompilerDirectives.TruffleBoundary
        Object call(Object clazz, Object get, Object set, TruffleString name, Object owner) {
            this.denyInstantiationAfterInitialization(BuiltinNames.T_GETSET_DESCRIPTOR);
            return PythonObjectFactory.getUncached().createGetSetDescriptor(GetSetDescriptorNode.ensure(get), GetSetDescriptorNode.ensure(set), name, owner);
        }
    }

    static abstract class DescriptorNode
    extends PythonBuiltinNode {
        DescriptorNode() {
        }

        @CompilerDirectives.TruffleBoundary
        protected final void denyInstantiationAfterInitialization(TruffleString name) {
            if (this.getContext().isCoreInitialized()) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, name);
            }
        }

        protected static Object ensure(Object value) {
            return value == PNone.NO_VALUE ? null : value;
        }
    }

    @Builtin(name="mappingproxy", constructsClass=PythonBuiltinClassType.PMappingproxy, isPublic=false, minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class MappingproxyNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"!isNoValue(obj)"})
        static Object doMapping(Object klass, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyMappingCheckNode mappingCheckNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (!(obj instanceof PList) && !(obj instanceof PTuple) && mappingCheckNode.execute(inliningTarget, obj)) {
                return factory.createMappingproxy(klass, obj);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "mappingproxy()", "mapping", obj);
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object doMissing(Object klass, PNone none, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.MISSING_D_REQUIRED_S_ARGUMENT_S_POS, "mappingproxy()", "mapping", 1);
        }
    }

    @Builtin(name="BaseException", constructsClass=PythonBuiltinClassType.PBaseException, minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BaseExceptionNode
    extends PythonVarargsBuiltinNode {
        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (arguments.length == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
            }
            if (arguments.length == 1) {
                return this.execute(frame, arguments[0], PythonUtils.EMPTY_OBJECT_ARRAY, keywords);
            }
            Object[] argsWithoutSelf = PythonUtils.arrayCopyOfRange(arguments, 1, arguments.length);
            return this.execute(frame, arguments[0], argsWithoutSelf, keywords);
        }

        @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)"}, limit="1")
        static Object doManaged(Object cls, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached InlinedConditionProfile argsProfile) {
            PTuple argsTuple = argsProfile.profile(inliningTarget, args.length == 0) ? null : factory.createTuple(args);
            return factory.createBaseException(cls, null, argsTuple);
        }

        @Specialization(guards={"needsNativeAllocationNode.execute(inliningTarget, cls)"}, limit="1")
        static Object doNativeSubtype(Object cls, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached CExtNodes.PCallCapiFunction callCapiFunction, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached CApiTransitions.NativeToPythonNode toPythonNode, @Cached ExternalFunctionNodes.DefaultCheckFunctionResultNode checkFunctionResultNode) {
            PTuple argsTuple = args.length > 0 ? factory.createTuple(args) : factory.createEmptyTuple();
            Object nativeResult = callCapiFunction.call(NativeCAPISymbol.FUN_EXCEPTION_SUBTYPE_NEW, toNativeNode.execute(cls), toNativeNode.execute(argsTuple));
            return toPythonNode.execute(checkFunctionResultNode.execute(PythonContext.get(inliningTarget), NativeCAPISymbol.FUN_EXCEPTION_SUBTYPE_NEW.getTsName(), nativeResult));
        }
    }

    @Builtin(name="cell", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PCell, isPublic=false)
    @GenerateNodeFactory
    public static abstract class CellTypeNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.CompilationFinal
        private Assumption sharedAssumption;

        private Assumption getAssumption() {
            if (this.sharedAssumption == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.sharedAssumption = Truffle.getRuntime().createAssumption("cell is effectively final");
            }
            if (CompilerDirectives.inCompiledCode()) {
                return this.sharedAssumption;
            }
            return Truffle.getRuntime().createAssumption("cell is effectively final");
        }

        @Specialization
        Object newCell(Object cls, Object contents, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached InlinedConditionProfile nonEmptyProfile) {
            Assumption assumption = this.getAssumption();
            PCell cell = factory.createCell(assumption);
            if (nonEmptyProfile.profile(inliningTarget, !PGuards.isNoValue(contents))) {
                cell.setRef(contents, assumption);
            }
            return cell;
        }
    }

    @Builtin(name="code", constructsClass=PythonBuiltinClassType.PCode, isPublic=false, minNumOfPositionalArgs=15, numOfPositionalOnlyArgs=17, parameterNames={"$cls", "argcount", "posonlyargcount", "kwonlyargcount", "nlocals", "stacksize", "flags", "codestring", "constants", "names", "varnames", "filename", "name", "firstlineno", "linetable", "freevars", "cellvars"})
    @ArgumentsClinic(value={@ArgumentClinic(name="argcount", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="posonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="kwonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="nlocals", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="stacksize", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="filename", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="firstlineno", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    public static abstract class CodeConstructorNode
    extends PythonClinicBuiltinNode {
        @Specialization
        PCode call(VirtualFrame frame, Object cls, int argcount, int posonlyargcount, int kwonlyargcount, int nlocals, int stacksize, int flags, PBytes codestring, PTuple constants, PTuple names, PTuple varnames, TruffleString filename, TruffleString name, int firstlineno, PBytes linetable, PTuple freevars, PTuple cellvars, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached CodeNodes.CreateCodeNode createCodeNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached CastToTruffleStringNode castToTruffleStringNode) {
            byte[] codeBytes = bufferLib.getCopiedByteArray(codestring);
            byte[] linetableBytes = bufferLib.getCopiedByteArray(linetable);
            Object[] constantsArr = getObjectArrayNode.execute(inliningTarget, constants);
            TruffleString[] namesArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, names), castToTruffleStringNode);
            TruffleString[] varnamesArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, varnames), castToTruffleStringNode);
            TruffleString[] freevarsArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, freevars), castToTruffleStringNode);
            TruffleString[] cellcarsArr = PythonUtils.objectArrayToTruffleStringArray(inliningTarget, getObjectArrayNode.execute(inliningTarget, cellvars), castToTruffleStringNode);
            return createCodeNode.execute(frame, argcount, posonlyargcount, kwonlyargcount, nlocals, stacksize, flags, codeBytes, constantsArr, namesArr, varnamesArr, freevarsArr, cellcarsArr, filename, name, firstlineno, linetableBytes);
        }

        @Fallback
        static PCode call(Object cls, Object argcount, Object kwonlyargcount, Object posonlyargcount, Object nlocals, Object stacksize, Object flags, Object codestring, Object constants, Object names, Object varnames, Object filename, Object name, Object firstlineno, Object linetable, Object freevars, Object cellvars, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INVALID_ARGS, "code");
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinConstructorsClinicProviders.CodeConstructorNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="TracebackType", constructsClass=PythonBuiltinClassType.PTraceback, isPublic=false, minNumOfPositionalArgs=5, parameterNames={"$cls", "tb_next", "tb_frame", "tb_lasti", "tb_lineno"})
    @ArgumentsClinic(value={@ArgumentClinic(name="tb_lasti", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="tb_lineno", conversion=ArgumentClinic.ClinicConversion.Index)})
    @GenerateNodeFactory
    public static abstract class TracebackTypeNode
    extends PythonClinicBuiltinNode {
        @Specialization
        static Object createTraceback(Object cls, PTraceback next, PFrame pframe, int lasti, int lineno, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createTraceback(pframe, lineno, lasti, next);
        }

        @Specialization
        static Object createTraceback(Object cls, PNone next, PFrame pframe, int lasti, int lineno, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createTraceback(pframe, lineno, lasti, null);
        }

        @Specialization(guards={"!isPTraceback(next)", "!isNone(next)"})
        static Object errorNext(Object cls, Object next, Object frame, Object lasti, Object lineno, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_TRACEBACK_OBJ_OR_NONE, next);
        }

        @Specialization(guards={"!isPFrame(frame)"})
        static Object errorFrame(Object cls, Object next, Object frame, Object lasti, Object lineno, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.TRACEBACK_TYPE_ARG_MUST_BE_FRAME, frame);
        }

        protected static boolean isPFrame(Object obj) {
            return obj instanceof PFrame;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinConstructorsClinicProviders.TracebackTypeNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="frame", constructsClass=PythonBuiltinClassType.PFrame, isPublic=false)
    @GenerateNodeFactory
    public static abstract class FrameTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object call(@Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.RuntimeError, ErrorMessages.CANNOT_CALL_CTOR_OF, "frame type");
        }
    }

    @Builtin(name="builtin_function_or_method", minNumOfPositionalArgs=3, constructsClass=PythonBuiltinClassType.PBuiltinFunctionOrMethod, isPublic=false)
    @GenerateNodeFactory
    public static abstract class BuiltinMethodTypeNode
    extends PythonBuiltinNode {
        @Specialization
        Object method(Object cls, Object self, PBuiltinFunction func, @Cached PythonObjectFactory factory) {
            return factory.createBuiltinMethod(cls, self, func);
        }
    }

    @Builtin(name="method", minNumOfPositionalArgs=3, constructsClass=PythonBuiltinClassType.PMethod, isPublic=false)
    @GenerateNodeFactory
    public static abstract class MethodTypeNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object method(Object cls, PFunction func, Object self, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createMethod(cls, self, func);
        }

        @Specialization
        static Object methodBuiltin(Object cls, PBuiltinFunction func, Object self, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createMethod(self, func);
        }

        @Specialization
        static Object methodGeneric(Object cls, Object func, Object self, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (callableCheck.execute(inliningTarget, func)) {
                return factory.createMethod(self, func);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.FIRST_ARG_MUST_BE_CALLABLE_S, "");
        }
    }

    @Builtin(name="generator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PGenerator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class GeneratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object generator(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "generator");
        }
    }

    @Builtin(name="foreign_iterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PForeignArrayIterator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class ForeignIteratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object iterator(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "foreign_iterator");
        }
    }

    @Builtin(name="callable_iterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PSentinelIterator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class CallableIteratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object iterator(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "callable_iterator");
        }
    }

    @Builtin(name="arrayiterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PArrayIterator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class ArrayIteratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object iterator(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "arrayiterator");
        }
    }

    @Builtin(name="iterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PIterator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class IteratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object iterator(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "iterator");
        }
    }

    @Builtin(name="dict_itemiterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDictItemIterator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class DictItemsIteratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object dictKeys(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "dict_itemiterator");
        }
    }

    @Builtin(name="dict_items", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDictItemsView, isPublic=false)
    @GenerateNodeFactory
    public static abstract class DictItemsTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object dictKeys(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "dict_items");
        }
    }

    @Builtin(name="dict_valueiterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDictValueIterator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class DictValuesIteratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object dictKeys(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "dict_valueiterator");
        }
    }

    @Builtin(name="dict_values", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDictValuesView, isPublic=false)
    @GenerateNodeFactory
    public static abstract class DictValuesTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object dictKeys(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "dict_values");
        }
    }

    @Builtin(name="dict_keyiterator", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDictKeyIterator, isPublic=false)
    @GenerateNodeFactory
    public static abstract class DictKeysIteratorTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object dictKeys(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "dict_keyiterator");
        }
    }

    @Builtin(name="dict_keys", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDictKeysView, isPublic=false)
    @GenerateNodeFactory
    public static abstract class DictKeysTypeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object dictKeys(Object args, Object kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "dict_keys");
        }
    }

    @Builtin(name="NoneType", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PNone, isPublic=false)
    @GenerateNodeFactory
    public static abstract class NoneTypeNode
    extends PythonBuiltinNode {
        @Specialization
        public static PNone module(Object cls) {
            return PNone.NONE;
        }
    }

    @Builtin(name="ellipsis", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PEllipsis, isPublic=false)
    @GenerateNodeFactory
    public static abstract class EllipsisTypeNode
    extends PythonBuiltinNode {
        @Specialization
        public static PEllipsis call(Object cls) {
            return PEllipsis.INSTANCE;
        }
    }

    @Builtin(name="NotImplementedType", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PNotImplemented, isPublic=false)
    @GenerateNodeFactory
    public static abstract class NotImplementedTypeNode
    extends PythonBuiltinNode {
        @Specialization
        public static PNotImplemented module(Object cls) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="module", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PythonModule, isPublic=false, doc="module(name, doc=None)\n--\n\nCreate a module object.\n\nThe name must be a string; the optional doc argument can have any type.")
    @GenerateNodeFactory
    public static abstract class ModuleNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doType(PythonBuiltinClass self, Object[] varargs, PKeyword[] kwargs, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createPythonModule((Object)self.getType());
        }

        @Specialization(guards={"!isPythonBuiltinClass(self)"})
        static Object doManaged(PythonManagedClass self, Object[] varargs, PKeyword[] kwargs, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createPythonModule(self);
        }

        @Specialization
        static Object doType(PythonBuiltinClassType self, Object[] varargs, PKeyword[] kwargs, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createPythonModule((Object)self);
        }

        @Specialization(guards={"isTypeNode.execute(inliningTarget, self)"}, limit="1")
        static Object doNative(PythonAbstractNativeObject self, Object[] varargs, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createPythonModule(self);
        }
    }

    @Builtin(name="type", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, needsFrame=true, constructsClass=PythonBuiltinClassType.PythonClass)
    @GenerateNodeFactory
    public static abstract class TypeNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private IsSubtypeNode isSubtypeNode;
        @Node.Child
        private TypeNodes.IsAcceptableBaseNode isAcceptableBaseNode;

        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5, PKeyword[] var6);

        @Override
        public final Object execute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            if (arguments.length == 3) {
                return this.execute(frame, self, arguments[0], arguments[1], arguments[2], keywords);
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_EXACTLY_D_ARGUMENTS_D_GIVEN, "type.__new__", 3, arguments.length);
        }

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            if (arguments.length == 4) {
                return this.execute(frame, arguments[0], arguments[1], arguments[2], arguments[3], keywords);
            }
            if (arguments.length == 3) {
                return this.execute(frame, self, arguments[0], arguments[1], arguments[2], keywords);
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_EXACTLY_D_ARGUMENTS_D_GIVEN, "type.__new__", 3, arguments.length);
        }

        @Specialization(guards={"isString(wName)"})
        Object typeNew(VirtualFrame frame, Object cls, Object wName, PTuple bases, PDict namespaceOrig, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(value="create(New)") LookupCallableSlotInMRONode getNewFuncNode, @Cached TypeBuiltins.BindNew bindNew, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PyObjectLookupAttr lookupMroEntriesNode, @Cached CastToTruffleStringNode castStr, @Cached CallNode callNewFuncNode, @Cached TypeNodes.CreateTypeNode createType, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            TruffleString name = castStr.execute(inliningTarget, wName);
            Object metaclass = cls;
            Object winner = this.calculateMetaclass(frame, inliningTarget, metaclass, bases, getClassNode, isTypeNode, lookupMroEntriesNode, getObjectArrayNode);
            if (winner != metaclass) {
                Object newFunc = getNewFuncNode.execute(winner);
                if (newFunc instanceof PBuiltinMethod && ((PBuiltinMethod)newFunc).getBuiltinFunction().getFunctionRootNode().getCallTarget() == this.getRootNode().getCallTarget()) {
                    metaclass = winner;
                } else {
                    return callNewFuncNode.execute((Frame)frame, bindNew.execute(frame, inliningTarget, newFunc, winner), new Object[]{winner, name, bases, namespaceOrig}, kwds);
                }
            }
            return createType.execute(frame, namespaceOrig, name, bases, metaclass, kwds);
        }

        @Fallback
        Object generic(Object cls, Object name, Object bases, Object namespace, PKeyword[] kwds) {
            if (!(bases instanceof PTuple)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "type.__new__()", 2, "tuple", bases);
            }
            if (!(namespace instanceof PDict)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "type.__new__()", 3, "dict", bases);
            }
            throw CompilerDirectives.shouldNotReachHere((String)"type fallback reached incorrectly");
        }

        private Object calculateMetaclass(VirtualFrame frame, Node inliningTarget, Object cls, PTuple bases, GetClassNode getClassNode, TypeNodes.IsTypeNode isTypeNode, PyObjectLookupAttr lookupMroEntries, SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            Object winner = cls;
            for (Object base : getObjectArrayNode.execute(inliningTarget, bases)) {
                if (!isTypeNode.execute(inliningTarget, base) && lookupMroEntries.execute((Frame)frame, inliningTarget, base, SpecialMethodNames.T___MRO_ENTRIES__) != PNone.NO_VALUE) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_SUPPORT_MRO_ENTRY_RESOLUTION);
                }
                if (!this.ensureIsAcceptableBaseNode().execute(base)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TYPE_IS_NOT_ACCEPTABLE_BASE_TYPE, base);
                }
                Object typ = getClassNode.execute(inliningTarget, base);
                if (this.isSubType(frame, winner, typ)) continue;
                if (this.isSubType(frame, typ, winner)) {
                    winner = typ;
                    continue;
                }
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.METACLASS_CONFLICT);
            }
            return winner;
        }

        protected boolean isSubType(VirtualFrame frame, Object subclass, Object superclass) {
            if (this.isSubtypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isSubtypeNode = (IsSubtypeNode)this.insert(IsSubtypeNode.create());
            }
            return this.isSubtypeNode.execute(frame, subclass, superclass);
        }

        @NeverDefault
        public static TypeNode create() {
            return BuiltinConstructorsFactory.TypeNodeFactory.create();
        }

        @Specialization(guards={"!isNoValue(bases)", "!isNoValue(dict)"})
        Object typeGeneric(VirtualFrame frame, Object cls, Object name, Object bases, Object dict, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached TypeNode nextTypeNode, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode) {
            if (!(name instanceof TruffleString) && !(name instanceof PString)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRINGS_NOT_P, "type() argument 1", name);
            }
            if (!(bases instanceof PTuple)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRINGS_NOT_P, "type() argument 2", bases);
            }
            if (!(dict instanceof PDict)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_STRINGS_NOT_P, "type() argument 3", dict);
            }
            if (!isTypeNode.execute(inliningTarget, cls)) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.CREATING_CLASS_NON_CLS_META_CLS);
            }
            return nextTypeNode.execute(frame, cls, name, bases, dict, kwds);
        }

        private TypeNodes.IsAcceptableBaseNode ensureIsAcceptableBaseNode() {
            if (this.isAcceptableBaseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isAcceptableBaseNode = (TypeNodes.IsAcceptableBaseNode)this.insert(TypeNodes.IsAcceptableBaseNode.create());
            }
            return this.isAcceptableBaseNode;
        }
    }

    @Builtin(name="method_descriptor", minNumOfPositionalArgs=3, maxNumOfPositionalArgs=6, constructsClass=PythonBuiltinClassType.PBuiltinFunction, isPublic=false)
    @GenerateNodeFactory
    public static abstract class BuiltinFunctionNode
    extends PythonBuiltinNode {
        @Specialization
        static PFunction function(Object cls, Object method_def, Object def, Object name, Object module, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "method_descriptor");
        }
    }

    @Builtin(name="function", minNumOfPositionalArgs=3, parameterNames={"$cls", "code", "globals", "name", "argdefs", "closure"}, constructsClass=PythonBuiltinClassType.PFunction, isPublic=false)
    @GenerateNodeFactory
    public static abstract class FunctionNode
    extends PythonBuiltinNode {
        @Specialization
        static PFunction function(Object cls, PCode code, PDict globals, TruffleString name, PNone defaultArgs, PNone closure, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFunction(name, code, globals, null);
        }

        @Specialization
        static PFunction function(Object cls, PCode code, PDict globals, PNone name, PNone defaultArgs, PTuple closure, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getObjectArrayNode") @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFunction(BuiltinNames.T_LAMBDA_NAME, code, globals, PCell.toCellArray(getObjectArrayNode.execute(inliningTarget, closure)));
        }

        @Specialization
        static PFunction function(Object cls, PCode code, PDict globals, PNone name, PNone defaultArgs, PNone closure, @Cached.Shared(value="getObjectArrayNode") @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFunction(BuiltinNames.T_LAMBDA_NAME, code, globals, null);
        }

        @Specialization
        static PFunction function(Object cls, PCode code, PDict globals, TruffleString name, PNone defaultArgs, PTuple closure, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getObjectArrayNode") @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFunction(name, code, globals, PCell.toCellArray(getObjectArrayNode.execute(inliningTarget, closure)));
        }

        @Specialization
        static PFunction function(Object cls, PCode code, PDict globals, PNone name, PTuple defaultArgs, PNone closure, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getObjectArrayNode") @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFunction(code.getName(), code, globals, getObjectArrayNode.execute(inliningTarget, defaultArgs), null, null);
        }

        @Specialization
        static PFunction function(Object cls, PCode code, PDict globals, TruffleString name, PTuple defaultArgs, PNone closure, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getObjectArrayNode") @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFunction(name, code, globals, getObjectArrayNode.execute(inliningTarget, defaultArgs), null, null);
        }

        @Specialization
        static PFunction function(Object cls, PCode code, PDict globals, TruffleString name, PTuple defaultArgs, PTuple closure, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getObjectArrayNode") @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFunction(name, code, globals, getObjectArrayNode.execute(inliningTarget, defaultArgs), null, PCell.toCellArray(getObjectArrayNode.execute(inliningTarget, closure)));
        }

        @Fallback
        static PFunction function(Object cls, Object code, Object globals, Object name, Object defaultArgs, Object closure, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.FUNC_CONSTRUCTION_NOT_SUPPORTED, cls, code, globals, name, defaultArgs, closure);
        }
    }

    @Builtin(name="zip", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PZip)
    @GenerateNodeFactory
    public static abstract class ZipNode
    extends PythonBuiltinNode {
        static boolean isNoneOrEmptyPKeyword(Object value) {
            PKeyword[] kw;
            return PGuards.isPNone(value) || value instanceof PKeyword[] && (kw = (PKeyword[])value).length == 0;
        }

        @Specialization(guards={"isNoneOrEmptyPKeyword(kw)"})
        static PZip zip(VirtualFrame frame, Object cls, Object[] args, Object kw, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ZipNode.zip(frame, inliningTarget, cls, args, false, getIter, factory);
        }

        @Specialization(guards={"kw.length == 1"})
        static PZip zip(VirtualFrame frame, Object cls, Object[] args, PKeyword[] kw, @Bind(value="this") Node inliningTarget, @Cached TruffleString.EqualNode eqNode, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached PyObjectIsTrueNode isTrueNode, @Cached InlinedConditionProfile profile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (profile.profile(inliningTarget, eqNode.execute((AbstractTruffleString)kw[0].getName(), (AbstractTruffleString)StringLiterals.T_STRICT, PythonUtils.TS_ENCODING))) {
                return ZipNode.zip(frame, inliningTarget, cls, args, isTrueNode.execute((Frame)frame, inliningTarget, kw[0].getValue()), getIter, factory);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_IS_AN_INVALID_ARG_FOR_S, kw[0].getName(), BuiltinNames.T_ZIP);
        }

        @Specialization(guards={"kw.length != 1"})
        static Object zip(Object cls, Object[] args, PKeyword[] kw, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.S_TAKES_AT_MOST_ONE_KEYWORD_ARGUMENT_D_GIVEN, BuiltinNames.T_ZIP, kw.length);
        }

        private static PZip zip(VirtualFrame frame, Node inliningTarget, Object cls, Object[] args, boolean strict, PyObjectGetIter getIter, PythonObjectFactory factory) {
            Object[] iterables = new Object[args.length];
            LoopNode.reportLoopCount((Node)inliningTarget, (int)args.length);
            for (int i = 0; i < args.length; ++i) {
                Object item = args[i];
                iterables[i] = getIter.execute((Frame)frame, inliningTarget, item);
            }
            return factory.createZip(cls, iterables, strict);
        }
    }

    @Builtin(name="tuple", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PTuple)
    @GenerateNodeFactory
    public static abstract class TupleNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)"})
        static PTuple constructTuple(VirtualFrame frame, Object cls, Object iterable, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached TupleNodes.ConstructTupleNode constructTupleNode) {
            return constructTupleNode.execute((Frame)frame, cls, iterable);
        }

        @Specialization(guards={"needsNativeAllocationNode.execute(inliningTarget, cls)", "isSubtypeOfTuple(frame, isSubtype, cls)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static Object doNative(VirtualFrame frame, Object cls, Object iterable, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached IsSubtypeNode isSubtype, @Cached CExtNodes.TupleSubtypeNew subtypeNew) {
            return subtypeNew.call(cls, iterable);
        }

        protected static boolean isSubtypeOfTuple(VirtualFrame frame, IsSubtypeNode isSubtypeNode, Object cls) {
            return isSubtypeNode.execute(frame, cls, (Object)PythonBuiltinClassType.PTuple);
        }

        @Fallback
        static PTuple tupleObject(Object cls, Object arg, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
        }
    }

    @Builtin(name="str", minNumOfPositionalArgs=1, parameterNames={"cls", "object", "encoding", "errors"}, constructsClass=PythonBuiltinClassType.PString)
    @GenerateNodeFactory
    public static abstract class StrNode
    extends PythonBuiltinNode {
        public final Object executeWith(Object arg) {
            return this.executeWith(null, (Object)PythonBuiltinClassType.PString, arg, PNone.NO_VALUE, PNone.NO_VALUE);
        }

        public final Object executeWith(VirtualFrame frame, Object arg) {
            return this.executeWith(frame, (Object)PythonBuiltinClassType.PString, arg, PNone.NO_VALUE, PNone.NO_VALUE);
        }

        public abstract Object executeWith(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

        @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)", "isNoValue(arg)"}, limit="1")
        static Object strNoArgs(Object cls, PNone arg, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return StrNode.asPString(cls, StringLiterals.T_EMPTY_STRING, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)", "!isNoValue(obj)", "isNoValue(encoding)", "isNoValue(errors)"}, limit="1")
        static Object strOneArg(VirtualFrame frame, Object cls, Object obj, PNone encoding, PNone errors, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Exclusive @Cached InlinedConditionProfile isStringProfile, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached.Exclusive @Cached PyObjectStrAsObjectNode strNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object result = strNode.execute((Frame)frame, inliningTarget, obj);
            if (isStringProfile.profile(inliningTarget, (result = TruffleStringMigrationHelpers.assertNoJavaString(result)) instanceof TruffleString)) {
                return StrNode.asPString(cls, (TruffleString)result, inliningTarget, isPrimitiveProfile, factory);
            }
            if (isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PString)) {
                return result;
            }
            try {
                return StrNode.asPString(cls, castToTruffleStringNode.execute(inliningTarget, result), inliningTarget, isPrimitiveProfile, factory);
            }
            catch (CannotCastException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("asPstring result not castable to String");
            }
        }

        @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)", "!isNoValue(encoding) || !isNoValue(errors)"}, limit="3")
        static Object doBuffer(VirtualFrame frame, Object cls, Object obj, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached.Exclusive @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Exclusive @Cached InlinedConditionProfile isStringProfile, @Cached.Exclusive @Cached InlinedConditionProfile isPStringProfile, @CachedLibrary(value="obj") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached(value="create(T_DECODE)") LookupAndCallTernaryNode callDecodeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object buffer;
            try {
                buffer = acquireLib.acquireReadonly(obj, frame, indirectCallData);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.NEED_BYTELIKE_OBJ, obj);
            }
            try {
                PBytes bytesObj = factory.createBytes(bufferLib.getCopiedByteArray(buffer));
                Object en = encoding == PNone.NO_VALUE ? StringLiterals.T_UTF8 : encoding;
                Object result = TruffleStringMigrationHelpers.assertNoJavaString(callDecodeNode.execute(frame, bytesObj, en, errors));
                if (isStringProfile.profile(inliningTarget, result instanceof TruffleString)) {
                    Object object = StrNode.asPString(cls, (TruffleString)result, inliningTarget, isPrimitiveProfile, factory);
                    return object;
                }
                if (isPStringProfile.profile(inliningTarget, result instanceof PString)) {
                    Object object = result;
                    return object;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.P_S_RETURNED_NON_STRING, bytesObj, "decode", result);
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Specialization(guards={"needsNativeAllocationNode.execute(inliningTarget, cls)", "isSubtypeOfString(frame, isSubtype, cls)", "isNoValue(encoding)", "isNoValue(errors)"}, limit="1")
        static Object doNativeSubclass(VirtualFrame frame, Object cls, Object obj, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached PyObjectStrAsObjectNode strNode, @Cached CExtNodes.StringSubtypeNew subtypeNew) {
            if (obj == PNone.NO_VALUE) {
                return subtypeNew.call(cls, StringLiterals.T_EMPTY_STRING);
            }
            return subtypeNew.call(cls, strNode.execute((Frame)frame, inliningTarget, obj));
        }

        protected static boolean isSubtypeOfString(VirtualFrame frame, IsSubtypeNode isSubtypeNode, Object cls) {
            return isSubtypeNode.execute(frame, cls, (Object)PythonBuiltinClassType.PString);
        }

        private static Object asPString(Object cls, TruffleString str, Node inliningTarget, BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, PythonObjectFactory factory) {
            if (isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PString)) {
                return str;
            }
            return factory.createString(cls, str);
        }

        @NeverDefault
        public static StrNode create() {
            return BuiltinConstructorsFactory.StrNodeFactory.create(null);
        }
    }

    @Builtin(name="set", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PSet)
    @GenerateNodeFactory
    public static abstract class SetNode
    extends PythonBuiltinNode {
        @Specialization
        public PSet setEmpty(Object cls, Object arg, @Cached PythonObjectFactory factory) {
            return factory.createSet(cls);
        }
    }

    @Builtin(name="range", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4, constructsClass=PythonBuiltinClassType.PRange)
    @GenerateNodeFactory
    @ReportPolymorphism
    public static abstract class RangeNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization(guards={"isStop(start, stop, step)"})
        static Object doIntStop(Object cls, int stop, PNone start, PNone step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="exceptionProfile") @Cached InlinedBranchProfile exceptionProfile, @Cached.Shared(value="lenOfRangeNodeExact") @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared(value="createBigRangeNode") @Cached RangeNodes.CreateBigRangeNode createBigRangeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return RangeNode.doInt(cls, 0, stop, 1, inliningTarget, exceptionProfile, lenOfRangeNodeExact, createBigRangeNode, factory, raiseNode);
        }

        @Specialization(guards={"isStop(start, stop, step)"})
        static Object doPintStop(Object cls, PInt stop, PNone start, PNone step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="lenOfRangeNode") @Cached RangeNodes.LenOfRangeNode lenOfRangeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return RangeNode.doPint(cls, factory.createInt(0), stop, factory.createInt(1), inliningTarget, lenOfRangeNode, factory, raiseNode);
        }

        @Specialization(guards={"isStop(start, stop, step)"})
        static Object doGenericStop(VirtualFrame frame, Object cls, Object stop, PNone start, PNone step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="exceptionProfile") @Cached InlinedBranchProfile exceptionProfile, @Cached.Shared(value="lenOfRangeNodeExact") @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared(value="createBigRangeNode") @Cached RangeNodes.CreateBigRangeNode createBigRangeNode, @Cached.Shared(value="cast") @Cached CastToJavaIntExactNode cast, @Cached.Shared(value="overflowProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile overflowProfile, @Cached.Shared(value="indexNode") @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return RangeNode.doGeneric(frame, cls, 0, stop, 1, inliningTarget, exceptionProfile, lenOfRangeNodeExact, createBigRangeNode, cast, overflowProfile, indexNode, factory, raiseNode);
        }

        @Specialization(guards={"isStartStop(start, stop, step)"})
        static Object doIntStartStop(Object cls, int start, int stop, PNone step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="exceptionProfile") @Cached InlinedBranchProfile exceptionProfile, @Cached.Shared(value="lenOfRangeNodeExact") @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared(value="createBigRangeNode") @Cached RangeNodes.CreateBigRangeNode createBigRangeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return RangeNode.doInt(cls, start, stop, 1, inliningTarget, exceptionProfile, lenOfRangeNodeExact, createBigRangeNode, factory, raiseNode);
        }

        @Specialization(guards={"isStartStop(start, stop, step)"})
        static Object doPintStartStop(Object cls, PInt start, PInt stop, PNone step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="lenOfRangeNode") @Cached RangeNodes.LenOfRangeNode lenOfRangeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return RangeNode.doPint(cls, start, stop, factory.createInt(1), inliningTarget, lenOfRangeNode, factory, raiseNode);
        }

        @Specialization(guards={"isStartStop(start, stop, step)"})
        static Object doGenericStartStop(VirtualFrame frame, Object cls, Object start, Object stop, PNone step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="exceptionProfile") @Cached InlinedBranchProfile exceptionProfile, @Cached.Shared(value="lenOfRangeNodeExact") @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared(value="createBigRangeNode") @Cached RangeNodes.CreateBigRangeNode createBigRangeNode, @Cached.Shared(value="cast") @Cached CastToJavaIntExactNode cast, @Cached.Shared(value="overflowProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile overflowProfile, @Cached.Shared(value="indexNode") @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return RangeNode.doGeneric(frame, cls, start, stop, 1, inliningTarget, exceptionProfile, lenOfRangeNodeExact, createBigRangeNode, cast, overflowProfile, indexNode, factory, raiseNode);
        }

        @Specialization
        static Object doInt(Object cls, int start, int stop, int step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="exceptionProfile") @Cached InlinedBranchProfile exceptionProfile, @Cached.Shared(value="lenOfRangeNodeExact") @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNode, @Cached.Shared(value="createBigRangeNode") @Cached RangeNodes.CreateBigRangeNode createBigRangeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (step == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARG_MUST_NOT_BE_ZERO, "range()", 3);
            }
            try {
                int len = lenOfRangeNode.executeInt(inliningTarget, start, stop, step);
                return factory.createIntRange(start, stop, step, len);
            }
            catch (OverflowException e) {
                exceptionProfile.enter(inliningTarget);
                return createBigRangeNode.execute(inliningTarget, start, stop, step);
            }
        }

        @Specialization
        static Object doPint(Object cls, PInt start, PInt stop, PInt step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="lenOfRangeNode") @Cached RangeNodes.LenOfRangeNode lenOfRangeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (step.isZero()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARG_MUST_NOT_BE_ZERO, "range()", 3);
            }
            BigInteger len = lenOfRangeNode.execute(inliningTarget, start.getValue(), stop.getValue(), step.getValue());
            return factory.createBigRange(start, stop, step, factory.createInt(len));
        }

        @Specialization(guards={"isStartStopStep(start, stop, step)"})
        static Object doGeneric(VirtualFrame frame, Object cls, Object start, Object stop, Object step, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="exceptionProfile") @Cached InlinedBranchProfile exceptionProfile, @Cached.Shared(value="lenOfRangeNodeExact") @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared(value="createBigRangeNode") @Cached RangeNodes.CreateBigRangeNode createBigRangeNode, @Cached.Shared(value="cast") @Cached CastToJavaIntExactNode cast, @Cached.Shared(value="overflowProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile overflowProfile, @Cached.Shared(value="indexNode") @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            Object lstart = indexNode.execute((Frame)frame, inliningTarget, start);
            Object lstop = indexNode.execute((Frame)frame, inliningTarget, stop);
            Object lstep = indexNode.execute((Frame)frame, inliningTarget, step);
            try {
                int istart = cast.execute(inliningTarget, lstart);
                int istop = cast.execute(inliningTarget, lstop);
                int istep = cast.execute(inliningTarget, lstep);
                return RangeNode.doInt(cls, istart, istop, istep, inliningTarget, exceptionProfile, lenOfRangeNodeExact, createBigRangeNode, factory, raiseNode);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.OverflowError, overflowProfile);
                return createBigRangeNode.execute(inliningTarget, lstart, lstop, lstep);
            }
        }

        protected static boolean isStop(Object start, Object stop, Object step) {
            return PGuards.isNoValue(start) && !PGuards.isNoValue(stop) && PGuards.isNoValue(step);
        }

        protected static boolean isStartStop(Object start, Object stop, Object step) {
            return !PGuards.isNoValue(start) && !PGuards.isNoValue(stop) && PGuards.isNoValue(step);
        }

        protected static boolean isStartStopStep(Object start, Object stop, Object step) {
            return !PGuards.isNoValue(start) && !PGuards.isNoValue(stop) && !PGuards.isNoValue(step);
        }
    }

    @Builtin(name="object", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PythonObject)
    @GenerateNodeFactory
    public static abstract class ObjectNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private SplitArgsNode splitArgsNode;
        @Node.Child
        private LookupCallableSlotInMRONode lookupInit;
        @Node.Child
        private LookupCallableSlotInMRONode lookupNew;
        @Node.Child
        private ReportAbstractClassNode reportAbstractClassNode;
        @CompilerDirectives.CompilationFinal
        private ValueProfile profileInit;
        @CompilerDirectives.CompilationFinal
        private ValueProfile profileNew;
        @CompilerDirectives.CompilationFinal
        private ValueProfile profileInitFactory;
        @CompilerDirectives.CompilationFinal
        private ValueProfile profileNewFactory;

        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (this.splitArgsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.splitArgsNode = (SplitArgsNode)this.insert(SplitArgsNode.create());
            }
            return this.execute(frame, arguments[0], this.splitArgsNode.executeCached(arguments), keywords);
        }

        @Specialization(guards={"!self.needsNativeAllocation()"})
        Object doManagedObject(VirtualFrame frame, PythonManagedClass self, Object[] varargs, PKeyword[] kwargs, @Cached.Shared @Cached PythonObjectFactory factory) {
            this.checkExcessArgs(self, varargs, kwargs);
            if (self.isAbstractClass()) {
                throw this.reportAbstractClass(frame, self);
            }
            return factory.createPythonObject(self);
        }

        @Specialization
        Object doBuiltinTypeType(PythonBuiltinClassType self, Object[] varargs, PKeyword[] kwargs, @Cached.Shared @Cached PythonObjectFactory factory) {
            this.checkExcessArgs((Object)self, varargs, kwargs);
            return factory.createPythonObject((Object)self);
        }

        @Specialization(guards={"self.needsNativeAllocation()"})
        @HostCompilerDirectives.InliningCutoff
        Object doNativeObjectIndirect(VirtualFrame frame, PythonManagedClass self, Object[] varargs, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CallNativeGenericNewNode callNativeGenericNewNode) {
            this.checkExcessArgs(self, varargs, kwargs);
            if (self.isAbstractClass()) {
                throw this.reportAbstractClass(frame, self);
            }
            return callNativeGenericNewNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"isNativeClass(self)"})
        @HostCompilerDirectives.InliningCutoff
        Object doNativeObjectDirect(VirtualFrame frame, Object self, Object[] varargs, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.GetTypeFlagsNode getTypeFlagsNode, @Cached.Shared @Cached CallNativeGenericNewNode callNativeGenericNewNode) {
            this.checkExcessArgs(self, varargs, kwargs);
            if ((getTypeFlagsNode.execute(self) & 0x100000L) != 0L) {
                throw this.reportAbstractClass(frame, self);
            }
            return callNativeGenericNewNode.execute(inliningTarget, self);
        }

        @Fallback
        Object fallback(Object o, Object[] varargs, PKeyword[] kwargs) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "object.__new__(X): X", o);
        }

        private void checkExcessArgs(Object type, Object[] varargs, PKeyword[] kwargs) {
            if (varargs.length != 0 || kwargs.length != 0) {
                if (this.lookupNew == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.lookupNew = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.New));
                }
                if (this.lookupInit == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.lookupInit = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Init));
                }
                if (this.profileNew == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.profileNew = this.createValueIdentityProfile();
                }
                if (this.profileInit == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.profileInit = this.createValueIdentityProfile();
                }
                if (this.profileNewFactory == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.profileNewFactory = ValueProfile.createClassProfile();
                }
                if (this.profileInitFactory == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.profileInitFactory = ValueProfile.createClassProfile();
                }
                if (ObjectBuiltins.InitNode.overridesBuiltinMethod(type, this.profileNew, this.lookupNew, this.profileNewFactory, BuiltinConstructorsFactory.ObjectNodeFactory.class)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.NEW_TAKES_ONE_ARG);
                }
                if (!ObjectBuiltins.InitNode.overridesBuiltinMethod(type, this.profileInit, this.lookupInit, this.profileInitFactory, ObjectBuiltinsFactory.InitNodeFactory.class)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.NEW_TAKES_NO_ARGS, type);
                }
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private PException reportAbstractClass(VirtualFrame frame, Object type) {
            if (this.reportAbstractClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportAbstractClassNode = (ReportAbstractClassNode)this.insert(BuiltinConstructorsFactory.ObjectNodeFactory.ReportAbstractClassNodeGen.create());
            }
            return this.reportAbstractClassNode.execute(frame, type);
        }

        @GenerateInline
        @GenerateCached(value=false)
        protected static abstract class CallNativeGenericNewNode
        extends Node {
            protected CallNativeGenericNewNode() {
            }

            abstract Object execute(Node var1, Object var2);

            @Specialization
            static Object call(Object cls, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached(inline=false) CApiTransitions.NativeToPythonNode toPythonNode, @Cached(inline=false) CExtNodes.PCallCapiFunction callCapiFunction) {
                return toPythonNode.execute(callCapiFunction.call(NativeCAPISymbol.FUN_PY_OBJECT_NEW, toNativeNode.execute(cls)));
            }
        }

        @GenerateInline(value=false)
        static abstract class ReportAbstractClassNode
        extends PNodeWithContext {
            ReportAbstractClassNode() {
            }

            public abstract PException execute(VirtualFrame var1, Object var2);

            @Specialization
            static PException report(VirtualFrame frame, Object type, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callSort, @Cached PyObjectCallMethodObjArgs callJoin, @Cached PyObjectSizeNode sizeNode, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CastToTruffleStringNode cast, @Cached ListNodes.ConstructListNode constructListNode, @Cached PRaiseNode raiseNode) {
                PList list = constructListNode.execute((Frame)frame, readAttributeFromObjectNode.execute(type, (Object)SpecialAttributeNames.T___ABSTRACTMETHODS__));
                int methodCount = sizeNode.execute((Frame)frame, inliningTarget, list);
                callSort.execute((Frame)frame, inliningTarget, list, SpecialMethodNames.T_SORT, new Object[0]);
                TruffleString joined = cast.execute(inliningTarget, callJoin.execute((Frame)frame, inliningTarget, StringLiterals.T_COMMA_SPACE, SpecialMethodNames.T_JOIN, list));
                throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANT_INSTANTIATE_ABSTRACT_CLASS_WITH_ABSTRACT_METHODS, type, methodCount > 1 ? "s" : "", joined);
            }
        }
    }

    @Builtin(name="list", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PList)
    @GenerateNodeFactory
    public static abstract class ListNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        protected PList constructList(Object cls, Object[] arguments, PKeyword[] keywords, @Cached PythonObjectFactory factory) {
            return factory.createList(cls);
        }
    }

    @Builtin(name="bool", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.Boolean, base={PythonBuiltinClassType.PInt})
    @GenerateNodeFactory
    @ReportPolymorphism
    public static abstract class BoolNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static boolean bool(VirtualFrame frame, Object cls, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrue) {
            return isTrue.execute((Frame)frame, inliningTarget, obj);
        }
    }

    @Builtin(name="int", minNumOfPositionalArgs=1, parameterNames={"cls", "x", "base"}, numOfPositionalOnlyArgs=2, constructsClass=PythonBuiltinClassType.PInt)
    @GenerateNodeFactory
    public static abstract class IntNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private BytesNodes.ToBytesNode toByteArrayNode;
        @Node.Child
        private LookupAndCallUnaryNode callIndexNode;
        @Node.Child
        private LookupAndCallUnaryNode callTruncNode;
        @Node.Child
        private LookupAndCallUnaryNode callReprNode;
        @Node.Child
        private LookupAndCallUnaryNode callIntNode;
        @Node.Child
        private WarningsModuleBuiltins.WarnNode warnNode;

        public final Object executeWith(VirtualFrame frame, Object number) {
            return this.execute(frame, (Object)PythonBuiltinClassType.PInt, number, 10);
        }

        public final Object executeWith(VirtualFrame frame, Object number, Object base) {
            return this.execute(frame, (Object)PythonBuiltinClassType.PInt, number, base);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object stringToIntInternal(String num, int base, PythonContext context) {
            try {
                BigInteger bi = IntNode.asciiToBigInteger(num, base, context);
                if (bi == null) {
                    return null;
                }
                if (bi.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || bi.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
                    return bi;
                }
                return bi.intValue();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private Object stringToInt(VirtualFrame frame, Object cls, String number, int base, Object origObj, Node inliningTarget, BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, InlinedBranchProfile notSimpleDecimalLiteralProfile, InlinedBranchProfile invalidValueProfile, InlinedBranchProfile bigIntegerProfile, InlinedBranchProfile primitiveIntProfile, InlinedBranchProfile fullIntProfile, PythonObjectFactory factory, PRaiseNode.Lazy raiseNode) {
            Object value;
            if ((base == 0 || base == 10) && (value = IntNode.parseSimpleDecimalLiteral(number, 0, number.length())) != null) {
                return IntNode.createInt(cls, value, inliningTarget, isPrimitiveIntProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory);
            }
            notSimpleDecimalLiteralProfile.enter(inliningTarget);
            value = IntNode.stringToIntInternal(number, base, this.getContext());
            if (value == null) {
                Object str;
                invalidValueProfile.enter(inliningTarget);
                if (this.callReprNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.callReprNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodSlot.Repr));
                }
                if (PGuards.isString(str = this.callReprNode.executeObject(frame, origObj))) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.INVALID_LITERAL_FOR_INT_WITH_BASE, base, str);
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError);
            }
            return IntNode.createInt(cls, value, inliningTarget, isPrimitiveIntProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory);
        }

        private static Object createInt(Object cls, Object value, Node inliningTarget, BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, InlinedBranchProfile bigIntegerProfile, InlinedBranchProfile primitiveIntProfile, InlinedBranchProfile fullIntProfile, PythonObjectFactory factory) {
            if (value instanceof BigInteger) {
                bigIntegerProfile.enter(inliningTarget);
                return factory.createInt(cls, (BigInteger)value);
            }
            if (IntNode.isPrimitiveInt(inliningTarget, cls, isPrimitiveIntProfile)) {
                primitiveIntProfile.enter(inliningTarget);
                return value;
            }
            fullIntProfile.enter(inliningTarget);
            if (value instanceof Integer) {
                return factory.createInt(cls, (Integer)value);
            }
            if (value instanceof Long) {
                return factory.createInt(cls, (Long)value);
            }
            if (value instanceof Boolean) {
                return factory.createInt(cls, (Boolean)value != false ? 1 : 0);
            }
            if (value instanceof PInt) {
                return factory.createInt(cls, ((PInt)value).getValue());
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("Unexpected type");
        }

        private static void checkBase(int base, Node inliningTarget, InlinedConditionProfile invalidBase, PRaiseNode.Lazy raiseNode) {
            if (invalidBase.profile(inliningTarget, (base < 2 || base > 36) && base != 0)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BASE_OUT_OF_RANGE_FOR_INT);
            }
        }

        private static void checkBase(PInt base, Node inliningTarget, InlinedConditionProfile invalidBase, PRaiseNode.Lazy raiseNode) {
            int ibase;
            try {
                ibase = base.intValueExact();
            }
            catch (OverflowException e) {
                ibase = 1;
            }
            IntNode.checkBase(ibase, inliningTarget, invalidBase, raiseNode);
        }

        private static BigInteger asciiToBigInteger(String str, int possibleBase, PythonContext context) throws NumberFormatException {
            int b;
            CompilerAsserts.neverPartOfCompilation();
            int base = possibleBase;
            int e = str.length();
            for (b = 0; b < e && Character.isWhitespace(str.charAt(b)); ++b) {
            }
            while (e > b && Character.isWhitespace(str.charAt(e - 1))) {
                --e;
            }
            boolean acceptUnderscore = false;
            boolean raiseIfNotZero = false;
            char sign = '\u0000';
            if (b < e) {
                sign = str.charAt(b);
                if (sign == '-' || sign == '+') {
                    ++b;
                }
                if (base == 16) {
                    if (str.charAt(b) == '0' && b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'X') {
                        b += 2;
                        acceptUnderscore = true;
                    }
                } else if (base == 0) {
                    if (str.charAt(b) == '0') {
                        if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'X') {
                            base = 16;
                            b += 2;
                            acceptUnderscore = true;
                        } else if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'O') {
                            base = 8;
                            b += 2;
                            acceptUnderscore = true;
                        } else if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'B') {
                            base = 2;
                            b += 2;
                            acceptUnderscore = true;
                        } else {
                            raiseIfNotZero = true;
                        }
                    }
                } else if (base == 8) {
                    if (b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'O') {
                        b += 2;
                        acceptUnderscore = true;
                    }
                } else if (base == 2 && b < e - 1 && Character.toUpperCase(str.charAt(b + 1)) == 'B') {
                    b += 2;
                    acceptUnderscore = true;
                }
            }
            if (base == 0) {
                base = 10;
            }
            for (int i = b; i < e; ++i) {
                char c = str.charAt(i);
                if (c == '_') {
                    if (!acceptUnderscore || i == e - 1) {
                        throw new NumberFormatException("Illegal underscore in int literal");
                    }
                    acceptUnderscore = false;
                    continue;
                }
                acceptUnderscore = true;
                if (Character.digit(c, base) != -1) continue;
                return null;
            }
            String s = str;
            if (b > 0 || e < str.length()) {
                s = str.substring(b, e);
            }
            s = s.replace("_", "");
            IntNode.checkMaxDigits(context, s.length(), base);
            BigInteger bi = sign == '-' ? new BigInteger("-" + s, base) : new BigInteger(s, base);
            if (raiseIfNotZero && !bi.equals(BigInteger.ZERO)) {
                throw new NumberFormatException("Obsolete octal int literal");
            }
            return bi;
        }

        private static void checkMaxDigits(PythonContext context, int digits, int base) {
            Integer maxDigits;
            if (digits > 640 && Integer.bitCount(base) != 1 && (maxDigits = Integer.valueOf(context.getIntMaxStrDigits())) > 0 && digits > maxDigits) {
                throw PRaiseNode.getUncached().raise(PythonErrorType.ValueError, ErrorMessages.EXCEEDS_THE_LIMIT_FOR_INTEGER_STRING_CONVERSION_D, maxDigits, digits);
            }
        }

        public static Object parseSimpleDecimalLiteral(String arg, int offset, int remaining) {
            int start;
            if (remaining <= 0) {
                return null;
            }
            int n = start = arg.charAt(offset) == '-' ? 1 : 0;
            if (remaining <= start || remaining > 18 + start) {
                return null;
            }
            if (arg.charAt(start + offset) == '0') {
                if (remaining > start + 1) {
                    return null;
                }
                return 0;
            }
            long value = 0L;
            for (int i = start; i < remaining; ++i) {
                char c = arg.charAt(i + offset);
                if (c < '0' || c > '9') {
                    return null;
                }
                value = value * 10L + (long)(c - 48);
            }
            if (start != 0) {
                value = -value;
            }
            if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                return (int)value;
            }
            return value;
        }

        protected static boolean isPrimitiveInt(Node inliningTarget, Object cls, BuiltinClassProfiles.IsBuiltinClassExactProfile profile) {
            return profile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PInt);
        }

        @Specialization
        static Object parseInt(Object cls, boolean arg, PNone base, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="primitiveInt") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (IntNode.isPrimitiveInt(inliningTarget, cls, isPrimitiveIntProfile)) {
                return arg ? 1 : 0;
            }
            return factory.createInt(cls, arg ? 1 : 0);
        }

        @Specialization(guards={"isNoValue(base)"})
        static Object createInt(Object cls, int arg, PNone base, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="primitiveInt") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached.Shared @Cached InlinedConditionProfile isIntProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (IntNode.isPrimitiveInt(inliningTarget, cls, isPrimitiveIntProfile)) {
                return arg;
            }
            return factory.createInt(cls, arg);
        }

        @Specialization(guards={"isNoValue(base)"})
        static Object createInt(Object cls, long arg, PNone base, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="primitiveInt") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached.Shared @Cached InlinedConditionProfile isIntProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (IntNode.isPrimitiveInt(inliningTarget, cls, isPrimitiveIntProfile)) {
                int intValue = (int)arg;
                if (isIntProfile.profile(inliningTarget, (long)intValue == arg)) {
                    return intValue;
                }
                return arg;
            }
            return factory.createInt(cls, arg);
        }

        @Specialization(guards={"isNoValue(base)"})
        static Object createInt(Object cls, double arg, PNone base, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached PyLongFromDoubleNode pyLongFromDoubleNode, @Cached.Exclusive @Cached InlinedBranchProfile bigIntegerProfile, @Cached.Exclusive @Cached InlinedBranchProfile primitiveIntProfile, @Cached.Exclusive @Cached InlinedBranchProfile fullIntProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object result = pyLongFromDoubleNode.execute(inliningTarget, arg);
            return IntNode.createInt(cls, result, inliningTarget, isPrimitiveIntProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        Object parseTStringError(VirtualFrame frame, Object cls, TruffleString number, Object base, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedBranchProfile baseIsNoneBranchProfile, @Cached.Exclusive @Cached InlinedBranchProfile baseIsIntBranchProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached.Exclusive @Cached PyNumberAsSizeNode asSizeNode, @Cached.Exclusive @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Exclusive @Cached InlinedConditionProfile invalidBase, @Cached.Exclusive @Cached InlinedBranchProfile notSimpleDecimalLiteralProfile, @Cached.Exclusive @Cached InlinedBranchProfile invalidValueProfile, @Cached.Exclusive @Cached InlinedBranchProfile bigIntegerProfile, @Cached.Exclusive @Cached InlinedBranchProfile primitiveIntProfile, @Cached.Exclusive @Cached InlinedBranchProfile fullIntProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int intBase;
            if (PGuards.isNoValue(base)) {
                baseIsNoneBranchProfile.enter(inliningTarget);
                intBase = 10;
            } else if (base instanceof Integer) {
                baseIsIntBranchProfile.enter(inliningTarget);
                intBase = (Integer)base;
            } else {
                intBase = asSizeNode.executeLossy((Frame)frame, inliningTarget, base);
            }
            IntNode.checkBase(intBase, inliningTarget, invalidBase, raiseNode);
            return this.stringToInt(frame, cls, toJavaStringNode.execute((AbstractTruffleString)number), intBase, number, inliningTarget, isPrimitiveIntProfile, notSimpleDecimalLiteralProfile, invalidValueProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory, raiseNode);
        }

        @Specialization(guards={"isNoValue(base) || isInt(base)"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        Object parseBytesError(VirtualFrame frame, Object cls, PBytesLike arg, Object base, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile baseIsNoneBranchProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached.Exclusive @Cached InlinedConditionProfile invalidBase, @Cached.Exclusive @Cached InlinedBranchProfile notSimpleDecimalLiteralProfile, @Cached.Exclusive @Cached InlinedBranchProfile invalidValueProfile, @Cached.Exclusive @Cached InlinedBranchProfile bigIntegerProfile, @Cached.Exclusive @Cached InlinedBranchProfile primitiveIntProfile, @Cached.Exclusive @Cached InlinedBranchProfile fullIntProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int intBase;
            if (baseIsNoneBranchProfile.profile(inliningTarget, PGuards.isNoValue(base))) {
                intBase = 10;
            } else {
                intBase = (Integer)base;
                IntNode.checkBase(intBase, inliningTarget, invalidBase, raiseNode);
            }
            return this.stringToInt(frame, cls, this.toString(arg), intBase, arg, inliningTarget, isPrimitiveIntProfile, notSimpleDecimalLiteralProfile, invalidValueProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory, raiseNode);
        }

        static boolean isNoValueOrIntOrPInt(Object x) {
            return PGuards.isNoValue(x) || x instanceof Integer || x instanceof PInt;
        }

        @Specialization(guards={"isNoValueOrIntOrPInt(base)"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        Object parsePString(VirtualFrame frame, Object cls, PString arg, Object base, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached.Exclusive @Cached CastToJavaStringNode castToStringNode, @Cached.Exclusive @Cached InlinedConditionProfile invalidBase, @Cached.Exclusive @Cached InlinedBranchProfile notSimpleDecimalLiteralProfile, @Cached.Exclusive @Cached InlinedBranchProfile invalidValueProfile, @Cached.Exclusive @Cached InlinedBranchProfile bigIntegerProfile, @Cached.Exclusive @Cached InlinedBranchProfile primitiveIntProfile, @Cached.Exclusive @Cached InlinedBranchProfile fullIntProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int intBase;
            if (PGuards.isNoValue(base)) {
                intBase = 10;
            } else if (base instanceof Integer) {
                intBase = (Integer)base;
                IntNode.checkBase(intBase, inliningTarget, invalidBase, raiseNode);
            } else {
                assert (base instanceof PInt);
                PInt pintBase = (PInt)base;
                IntNode.checkBase(pintBase, inliningTarget, invalidBase, raiseNode);
                intBase = pintBase.intValue();
            }
            Object result = this.callInt(frame, inliningTarget, arg, raiseNode);
            if (result != PNone.NO_VALUE) {
                return result;
            }
            return this.stringToInt(frame, cls, castToStringNode.execute(arg), intBase, arg, inliningTarget, isPrimitiveIntProfile, notSimpleDecimalLiteralProfile, invalidValueProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory, raiseNode);
        }

        @Specialization(guards={"isNoValue(base)"})
        static Object createInt(Object cls, PythonNativeVoidPtr arg, PNone base, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="primitiveInt") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile) {
            if (IntNode.isPrimitiveInt(inliningTarget, cls, isPrimitiveIntProfile)) {
                return arg;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("cannot wrap void ptr in int subclass");
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object createInt(Object cls, PNone none, PNone base, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="primitiveInt") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (IntNode.isPrimitiveInt(inliningTarget, cls, isPrimitiveIntProfile)) {
                return 0;
            }
            return factory.createInt(cls, 0);
        }

        @Specialization(guards={"!isString(arg)", "!isBytes(arg)", "!isNoValue(base)"})
        static Object fail(Object cls, Object arg, Object base, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INT_CANT_CONVERT_STRING_WITH_EXPL_BASE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isNoValue(base)", "!isNoValue(obj)", "!isHandledType(obj)"})
        @HostCompilerDirectives.InliningCutoff
        @ReportPolymorphism.Megamorphic
        Object createIntGeneric(VirtualFrame frame, Object cls, Object obj, PNone base, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PyIndexCheckNode indexCheckNode, @Cached PyLongCheckExactNode longCheckExact, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveIntProfile, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached InlinedBranchProfile notSimpleDecimalLiteralProfile, @Cached.Exclusive @Cached InlinedBranchProfile invalidValueProfile, @Cached.Exclusive @Cached InlinedBranchProfile bigIntegerProfile, @Cached.Exclusive @Cached InlinedBranchProfile primitiveIntProfile, @Cached.Exclusive @Cached InlinedBranchProfile fullIntProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object result = this.callInt(frame, inliningTarget, obj, raiseNode);
            if (result == PNone.NO_VALUE && (result = this.callIndex(frame, inliningTarget, obj, raiseNode)) == PNone.NO_VALUE) {
                Object truncResult = this.callTrunc(frame, inliningTarget, obj, indexCheckNode, raiseNode);
                if (truncResult == PNone.NO_VALUE) {
                    Object buffer;
                    try {
                        buffer = bufferAcquireLib.acquireReadonly(obj, frame, indirectCallData);
                    }
                    catch (PException e) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ARG_MUST_BE_STRING_OR_BYTELIKE_OR_NUMBER, "int()", obj);
                    }
                    try {
                        String number = IntNode.newString(bufferLib.getInternalOrCopiedByteArray(buffer), 0, bufferLib.getBufferLength(buffer));
                        Object object = this.stringToInt(frame, cls, number, 10, obj, inliningTarget, isPrimitiveIntProfile, notSimpleDecimalLiteralProfile, invalidValueProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory, raiseNode);
                        return object;
                    }
                    finally {
                        bufferLib.release(buffer, frame, indirectCallData);
                    }
                }
                if (IntNode.isIntegerType(truncResult)) {
                    result = truncResult;
                } else {
                    result = this.callIndex(frame, inliningTarget, truncResult, raiseNode);
                    if (result == PNone.NO_VALUE && (result = this.callInt(frame, inliningTarget, truncResult, raiseNode)) == PNone.NO_VALUE) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_INTEGRAL, "__trunc__", truncResult);
                    }
                }
            }
            if (!longCheckExact.execute(inliningTarget, result)) {
                this.getWarnNode().warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, obj, "__int__/__index__", "int", result, "int");
                if (PGuards.isPInt(result)) {
                    result = ((PInt)result).getValue();
                } else if (PGuards.isBoolean(result)) {
                    result = (Boolean)result != false ? 1 : 0;
                }
            }
            return IntNode.createInt(cls, result, inliningTarget, isPrimitiveIntProfile, bigIntegerProfile, primitiveIntProfile, fullIntProfile, factory);
        }

        protected static boolean isIntegerType(Object obj) {
            return PGuards.isBoolean(obj) || PGuards.isInteger(obj) || PGuards.isPInt(obj);
        }

        protected static boolean isHandledType(Object obj) {
            return PGuards.isInteger(obj) || obj instanceof Double || obj instanceof Boolean || PGuards.isString(obj) || PGuards.isBytes(obj) || obj instanceof PythonNativeVoidPtr;
        }

        private Object callIndex(VirtualFrame frame, Node inliningTarget, Object obj, PRaiseNode.Lazy raiseNode) {
            Object result;
            if (this.callIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callIndexNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodSlot.Index));
            }
            if ((result = this.callIndexNode.executeObject(frame, obj)) != PNone.NO_VALUE && !IntNode.isIntegerType(result)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_INT, "__index__", result);
            }
            return result;
        }

        private Object callTrunc(VirtualFrame frame, Node inliningTarget, Object obj, PyIndexCheckNode indexCheckNode, PRaiseNode.Lazy raiseNode) {
            Object result;
            if (this.callTruncNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callTruncNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodNames.T___TRUNC__));
            }
            if ((result = this.callTruncNode.executeObject(frame, obj)) != PNone.NO_VALUE) {
                this.getWarnNode().warnEx((Frame)frame, (Object)PythonErrorType.DeprecationWarning, ErrorMessages.WARN_DELEGATION_OF_INT_TO_TRUNC_IS_DEPRECATED, 1);
                if (indexCheckNode.execute(inliningTarget, result)) {
                    return this.callIndex(frame, inliningTarget, result, raiseNode);
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_INTEGRAL, "__trunc__", result);
            }
            return result;
        }

        private Object callInt(VirtualFrame frame, Node inliningTarget, Object object, PRaiseNode.Lazy raiseNode) {
            Object result;
            if (this.callIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callIntNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodSlot.Int));
            }
            if ((result = this.callIntNode.executeObject(frame, object)) != PNone.NO_VALUE && !IntNode.isIntegerType(result)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_INT, SpecialMethodNames.T___INT__, result);
            }
            return result;
        }

        private WarningsModuleBuiltins.WarnNode getWarnNode() {
            if (this.warnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.warnNode = (WarningsModuleBuiltins.WarnNode)this.insert(WarningsModuleBuiltins.WarnNode.create());
            }
            return this.warnNode;
        }

        private String toString(PBytesLike pByteArray) {
            if (this.toByteArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toByteArrayNode = (BytesNodes.ToBytesNode)this.insert(BytesNodes.ToBytesNode.create());
            }
            return IntNode.newString(this.toByteArrayNode.execute(pByteArray));
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String newString(byte[] bytes) {
            return new String(bytes);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String newString(byte[] bytes, int offset, int length) {
            return new String(bytes, offset, length);
        }
    }

    @Builtin(name="frozenset", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PFrozenSet)
    @GenerateNodeFactory
    public static abstract class FrozenSetNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(arg)"})
        static PFrozenSet frozensetEmpty(Object cls, PNone arg, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFrozenSet(cls);
        }

        @Specialization(guards={"isBuiltinClass.profileIsAnyBuiltinClass(inliningTarget, cls)"})
        static PFrozenSet frozensetIdentity(Object cls, PFrozenSet arg, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isBuiltinProfile") @Cached BuiltinClassProfiles.IsAnyBuiltinClassProfile isBuiltinClass) {
            return arg;
        }

        @Specialization(guards={"!isBuiltinClass.profileIsAnyBuiltinClass(inliningTarget, cls)"})
        static PFrozenSet subFrozensetIdentity(Object cls, PFrozenSet arg, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isBuiltinProfile") @Cached BuiltinClassProfiles.IsAnyBuiltinClassProfile isBuiltinClass, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFrozenSet(cls, arg.getDictStorage());
        }

        @Specialization(guards={"!isNoValue(iterable)", "!isPFrozenSet(iterable)"})
        static PFrozenSet frozensetIterable(VirtualFrame frame, Object cls, Object iterable, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage storage = getHashingStorageNode.doNoValue(frame, inliningTarget, iterable);
            return factory.createFrozenSet(cls, storage);
        }
    }

    @Builtin(name="float", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PFloat)
    @GenerateNodeFactory
    @ReportPolymorphism
    static abstract class FloatNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        NonPrimitiveFloatNode nonPrimitiveFloatNode;

        FloatNode() {
        }

        @Specialization
        Object doIt(VirtualFrame frame, Object cls, Object arg, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveFloatProfile, @Cached PrimitiveFloatNode primitiveFloatNode, @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode) {
            if (FloatNode.isPrimitiveFloat(inliningTarget, cls, isPrimitiveFloatProfile)) {
                return primitiveFloatNode.execute(frame, inliningTarget, arg);
            }
            boolean needsNativeAllocation = needsNativeAllocationNode.execute(inliningTarget, cls);
            if (this.nonPrimitiveFloatNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nonPrimitiveFloatNode = (NonPrimitiveFloatNode)this.insert(BuiltinConstructorsFactory.FloatNodeFactory.NonPrimitiveFloatNodeGen.create());
            }
            return this.nonPrimitiveFloatNode.execute(frame, cls, arg, needsNativeAllocation);
        }

        protected static boolean isPrimitiveFloat(Node inliningTarget, Object cls, BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile) {
            return isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PFloat);
        }

        @GenerateCached(value=false)
        @GenerateInline
        @ImportStatic(value={PGuards.class})
        static abstract class PrimitiveFloatNode
        extends Node {
            PrimitiveFloatNode() {
            }

            abstract double execute(VirtualFrame var1, Node var2, Object var3);

            @Specialization
            static double floatFromDouble(double arg) {
                return arg;
            }

            @Specialization
            static double floatFromInt(int arg) {
                return arg;
            }

            static double floatFromLong(long arg) {
                return arg;
            }

            @Specialization
            static double floatFromBoolean(boolean arg) {
                return arg ? 1.0 : 0.0;
            }

            @Specialization(guards={"isNoValue(obj)"})
            static double floatFromNoValue(PNone obj) {
                return 0.0;
            }

            @HostCompilerDirectives.InliningCutoff
            @Fallback
            static double floatFromObject(VirtualFrame frame, Node inliningTarget, Object obj, @Cached PyUnicodeCheckExactNode stringCheck, @Cached PyFloatFromString fromString, @Cached PyNumberFloatNode pyNumberFloat) {
                if (stringCheck.execute(inliningTarget, obj)) {
                    return fromString.execute((Frame)frame, inliningTarget, obj);
                }
                return pyNumberFloat.execute((Frame)frame, inliningTarget, obj);
            }
        }

        @ImportStatic(value={PGuards.class})
        @GenerateInline(value=false)
        static abstract class NonPrimitiveFloatNode
        extends Node {
            NonPrimitiveFloatNode() {
            }

            abstract Object execute(VirtualFrame var1, Object var2, Object var3, boolean var4);

            @Specialization(guards={"!needsNativeAllocation", "isNoValue(obj)"})
            @HostCompilerDirectives.InliningCutoff
            Object floatFromNoneManagedSubclass(Object cls, PNone obj, boolean needsNativeAllocation, @Cached.Shared @Cached PythonObjectFactory factory) {
                return factory.createFloat(cls, PrimitiveFloatNode.floatFromNoValue(obj));
            }

            @Specialization(guards={"!needsNativeAllocation"})
            @HostCompilerDirectives.InliningCutoff
            Object floatFromObjectManagedSubclass(VirtualFrame frame, Object cls, Object obj, boolean needsNativeAllocation, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PrimitiveFloatNode recursiveCallNode) {
                return factory.createFloat(cls, recursiveCallNode.execute(frame, inliningTarget, obj));
            }

            @Specialization(guards={"needsNativeAllocation", "isSubtypeOfFloat(frame, isSubtype, cls)"}, limit="1")
            @HostCompilerDirectives.InliningCutoff
            static Object floatFromObjectNativeSubclass(VirtualFrame frame, Object cls, Object obj, boolean needsNativeAllocation, @Bind(value="this") Node inliningTarget, @Cached IsSubtypeNode isSubtype, @Cached CExtNodes.FloatSubtypeNew subtypeNew, @Cached.Shared @Cached PrimitiveFloatNode recursiveCallNode) {
                return subtypeNew.call(cls, recursiveCallNode.execute(frame, inliningTarget, obj));
            }

            protected static boolean isSubtypeOfFloat(VirtualFrame frame, IsSubtypeNode isSubtypeNode, Object cls) {
                return isSubtypeNode.execute(frame, cls, (Object)PythonBuiltinClassType.PFloat);
            }
        }
    }

    @Builtin(name="reversed", minNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PReverseIterator)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodSlot.class})
    public static abstract class ReversedNode
    extends PythonBuiltinNode {
        @Specialization
        static PythonObject reversed(Object cls, PIntRange range, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile overflowProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            int lstart = range.getIntStart();
            int lstep = range.getIntStep();
            int ulen = range.getIntLength();
            try {
                int new_stop = PythonUtils.subtractExact(lstart, lstep);
                int new_start = PythonUtils.addExact(new_stop, PythonUtils.multiplyExact(ulen, lstep));
                return factory.createIntRangeIterator(new_start, new_stop, PythonUtils.negateExact(lstep), ulen);
            }
            catch (OverflowException e) {
                overflowProfile.enter(inliningTarget);
                return ReversedNode.handleOverflow(lstart, lstep, ulen, PythonContext.get(inliningTarget).factory());
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static PBigRangeIterator handleOverflow(int lstart, int lstep, int ulen, PythonObjectSlowPathFactory factory) {
            BigInteger bstart = BigInteger.valueOf(lstart);
            BigInteger bstep = BigInteger.valueOf(lstep);
            BigInteger blen = BigInteger.valueOf(ulen);
            BigInteger new_stop = bstart.subtract(bstep);
            BigInteger new_start = new_stop.add(blen.multiply(bstep));
            return factory.createBigRangeIterator(new_start, new_stop, bstep.negate(), blen);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PythonObject reversed(Object cls, PBigRange range) {
            BigInteger lstart = range.getBigIntegerStart();
            BigInteger lstep = range.getBigIntegerStep();
            BigInteger ulen = range.getBigIntegerLength();
            BigInteger new_stop = lstart.subtract(lstep);
            BigInteger new_start = new_stop.add(ulen.multiply(lstep));
            return this.getContext().factory().createBigRangeIterator(new_start, new_stop, lstep.negate(), ulen);
        }

        @Specialization
        static PythonObject reversed(Object cls, PString value, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createStringReverseIterator(cls, castToStringNode.execute(inliningTarget, value));
        }

        @Specialization
        static PythonObject reversed(Object cls, TruffleString value, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createStringReverseIterator(cls, value);
        }

        @Specialization(guards={"!isString(sequence)", "!isPRange(sequence)"})
        static Object reversed(VirtualFrame frame, Object cls, Object sequence, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(value="create(Reversed)") LookupSpecialMethodSlotNode lookupReversed, @Cached CallUnaryMethodNode callReversed, @Cached(value="create(Len)") LookupAndCallUnaryNode lookupLen, @Cached(value="create(GetItem)") LookupSpecialMethodSlotNode getItemNode, @Cached InlinedConditionProfile noReversedProfile, @Cached InlinedConditionProfile noGetItemProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object sequenceKlass = getClassNode.execute(inliningTarget, sequence);
            Object reversed = lookupReversed.execute((Frame)frame, sequenceKlass, sequence);
            if (noReversedProfile.profile(inliningTarget, reversed == PNone.NO_VALUE)) {
                int lengthHint;
                Object getItem = getItemNode.execute((Frame)frame, sequenceKlass, sequence);
                if (noGetItemProfile.profile(inliningTarget, getItem == PNone.NO_VALUE)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.OBJ_ISNT_REVERSIBLE, sequence);
                }
                Object h = lookupLen.executeObject(frame, sequence);
                try {
                    lengthHint = PGuards.expectInt(h);
                }
                catch (OverflowException | UnexpectedResultException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, h);
                }
                return factory.createSequenceReverseIterator(cls, sequence, lengthHint);
            }
            return callReversed.executeObject((Frame)frame, reversed, sequence);
        }
    }

    @Builtin(name="enumerate", minNumOfPositionalArgs=2, parameterNames={"cls", "iterable", "start"}, constructsClass=PythonBuiltinClassType.PEnumerate)
    @GenerateNodeFactory
    public static abstract class EnumerateNode
    extends PythonBuiltinNode {
        @Specialization
        static PEnumerate doNone(VirtualFrame frame, Object cls, Object iterable, PNone keywordArg, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createEnumerate(cls, getIter.execute((Frame)frame, inliningTarget, iterable), 0L);
        }

        @Specialization
        static PEnumerate doInt(VirtualFrame frame, Object cls, Object iterable, int start, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createEnumerate(cls, getIter.execute((Frame)frame, inliningTarget, iterable), start);
        }

        @Specialization
        static PEnumerate doLong(VirtualFrame frame, Object cls, Object iterable, long start, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createEnumerate(cls, getIter.execute((Frame)frame, inliningTarget, iterable), start);
        }

        @Specialization
        static PEnumerate doPInt(VirtualFrame frame, Object cls, Object iterable, PInt start, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createEnumerate(cls, getIter.execute((Frame)frame, inliningTarget, iterable), start);
        }

        static boolean isIntegerIndex(Object idx) {
            return PGuards.isInteger(idx) || idx instanceof PInt;
        }

        @Specialization(guards={"!isIntegerIndex(start)"})
        static void enumerate(Object cls, Object iterable, Object start, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, start);
        }
    }

    @Builtin(name="dict", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PDict)
    @GenerateNodeFactory
    public static abstract class DictionaryNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isBuiltinDict(cls)"})
        static PDict builtinDict(Object cls, Object[] args, PKeyword[] keywordArgs, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createDict();
        }

        @Specialization(replaces={"builtinDict"})
        static PDict dict(Object cls, Object[] args, PKeyword[] keywordArgs, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile orderedProfile, @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (orderedProfile.profile(inliningTarget, isSubtypeNode.execute(cls, (Object)PythonBuiltinClassType.POrderedDict))) {
                return factory.createOrderedDict(cls);
            }
            return factory.createDict(cls);
        }

        protected static boolean isBuiltinDict(Object cls) {
            return cls == PythonBuiltinClassType.PDict;
        }
    }

    @Builtin(name="complex", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.PComplex, parameterNames={"$cls", "real", "imag"}, doc="complex(real[, imag]) -> complex number\n\nCreate a complex number from a real part and an optional imaginary part.\nThis is equivalent to (real + imag*1j) where imag defaults to 0.")
    @GenerateNodeFactory
    public static abstract class ComplexNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private LookupAndCallUnaryNode callReprNode;
        @Node.Child
        private LookupAndCallUnaryNode callComplexNode;
        @Node.Child
        private WarningsModuleBuiltins.WarnNode warnNode;

        private static PComplex createComplex(Object cls, double real, double imaginary, Node inliningTarget, BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, PythonObjectFactory factory) {
            if (isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PComplex)) {
                return factory.createComplex(real, imaginary);
            }
            return factory.createComplex(cls, real, imaginary);
        }

        private static PComplex createComplex(Object cls, PComplex value, Node inliningTarget, BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, PyComplexCheckExactNode complexCheckExact, PythonObjectFactory factory) {
            if (isPrimitiveProfile.profileClass(inliningTarget, cls, PythonBuiltinClassType.PComplex)) {
                if (complexCheckExact.execute(inliningTarget, value)) {
                    return value;
                }
                return factory.createComplex(value.getReal(), value.getImag());
            }
            return factory.createComplex(cls, value.getReal(), value.getImag());
        }

        @Specialization(guards={"isNoValue(real)", "isNoValue(imag)"})
        static PComplex complexFromNone(Object cls, PNone real, PNone imag, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, 0.0, 0.0, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization
        static PComplex complexFromIntInt(Object cls, int real, int imaginary, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, real, imaginary, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization
        static PComplex complexFromLongLong(Object cls, long real, long imaginary, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, real, imaginary, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization
        PComplex complexFromLongLong(Object cls, PInt real, PInt imaginary, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, real.doubleValueWithOverflow(this), imaginary.doubleValueWithOverflow(this), inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization
        static PComplex complexFromDoubleDouble(Object cls, double real, double imaginary, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, real, imaginary, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"isNoValue(imag)"})
        static PComplex complexFromDouble(Object cls, double real, PNone imag, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, real, 0.0, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"isNoValue(imag)"})
        PComplex complexFromDouble(VirtualFrame frame, Object cls, PFloat real, PNone imag, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode isBuiltinObjectProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return this.complexFromObject(frame, cls, real, imag, inliningTarget, canBeDoubleNode, asDoubleNode, isComplexType, isResultComplexType, isPrimitiveProfile, isBuiltinObjectProfile, factory, raiseNode);
        }

        @Specialization(guards={"isNoValue(imag)"})
        static PComplex complexFromInt(Object cls, int real, PNone imag, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, real, 0.0, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"isNoValue(imag)"})
        static PComplex complexFromLong(Object cls, long real, PNone imag, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, real, 0.0, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"isNoValue(imag)"})
        PComplex complexFromLong(VirtualFrame frame, Object cls, PInt real, PNone imag, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode complexCheck, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return this.complexFromObject(frame, cls, real, imag, inliningTarget, canBeDoubleNode, asDoubleNode, isComplexType, isResultComplexType, isPrimitiveProfile, complexCheck, factory, raiseNode);
        }

        @Specialization(guards={"isNoValue(imag)", "!isNoValue(number)", "!isString(number)"})
        PComplex complexFromObject(VirtualFrame frame, Object cls, Object number, PNone imag, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared(value="isBuiltinObj") @Cached PyComplexCheckExactNode complexCheck, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, number, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, number)) {
                    return ComplexNode.createComplex(cls, asDoubleNode.execute(frame, inliningTarget, number), 0.0, inliningTarget, isPrimitiveProfile, factory);
                }
                throw ComplexNode.raiseFirstArgError(number, raiseNode.get(inliningTarget));
            }
            return ComplexNode.createComplex(cls, value, inliningTarget, isPrimitiveProfile, complexCheck, factory);
        }

        @Specialization
        static PComplex complexFromLongComplex(Object cls, long one, PComplex two, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, (double)one - two.getImag(), two.getReal(), inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization
        PComplex complexFromPIntComplex(Object cls, PInt one, PComplex two, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, one.doubleValueWithOverflow(this) - two.getImag(), two.getReal(), inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization
        static PComplex complexFromDoubleComplex(Object cls, double one, PComplex two, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            return ComplexNode.createComplex(cls, one - two.getImag(), two.getReal(), inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"!isString(one)"})
        PComplex complexFromComplexLong(VirtualFrame frame, Object cls, Object one, long two, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return ComplexNode.createComplex(cls, asDoubleNode.execute(frame, inliningTarget, one), two, inliningTarget, isPrimitiveProfile, factory);
                }
                throw ComplexNode.raiseFirstArgError(one, raiseNode.get(inliningTarget));
            }
            return ComplexNode.createComplex(cls, value.getReal(), value.getImag() + (double)two, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"!isString(one)"})
        PComplex complexFromComplexDouble(VirtualFrame frame, Object cls, Object one, double two, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return ComplexNode.createComplex(cls, asDoubleNode.execute(frame, inliningTarget, one), two, inliningTarget, isPrimitiveProfile, factory);
                }
                throw ComplexNode.raiseFirstArgError(one, raiseNode.get(inliningTarget));
            }
            return ComplexNode.createComplex(cls, value.getReal(), value.getImag() + two, inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"!isString(one)"})
        PComplex complexFromComplexPInt(VirtualFrame frame, Object cls, Object one, PInt two, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return ComplexNode.createComplex(cls, asDoubleNode.execute(frame, inliningTarget, one), two.doubleValueWithOverflow(this), inliningTarget, isPrimitiveProfile, factory);
                }
                throw ComplexNode.raiseFirstArgError(one, raiseNode.get(inliningTarget));
            }
            return ComplexNode.createComplex(cls, value.getReal(), value.getImag() + two.doubleValueWithOverflow(this), inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"!isString(one)"})
        PComplex complexFromComplexComplex(VirtualFrame frame, Object cls, Object one, PComplex two, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PComplex value = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (value == null) {
                if (canBeDoubleNode.execute(inliningTarget, one)) {
                    return ComplexNode.createComplex(cls, asDoubleNode.execute(frame, inliningTarget, one) - two.getImag(), two.getReal(), inliningTarget, isPrimitiveProfile, factory);
                }
                throw ComplexNode.raiseFirstArgError(one, raiseNode.get(inliningTarget));
            }
            return ComplexNode.createComplex(cls, value.getReal() - two.getImag(), value.getImag() + two.getReal(), inliningTarget, isPrimitiveProfile, factory);
        }

        @Specialization(guards={"!isString(one)", "!isNoValue(two)", "!isPComplex(two)"})
        PComplex complexFromComplexObject(VirtualFrame frame, Object cls, Object one, Object two, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CanBeDoubleNode canBeDoubleNode, @Cached.Shared(value="floatAsDouble") @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="isComplex") @Cached PyComplexCheckExactNode isComplexType, @Cached.Shared(value="isComplexResult") @Cached PyComplexCheckExactNode isResultComplexType, @Cached.Shared(value="isPrimitive") @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isPrimitiveProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PComplex oneValue = this.getComplexNumberFromObject(frame, one, inliningTarget, isComplexType, isResultComplexType, raiseNode);
            if (canBeDoubleNode.execute(inliningTarget, two)) {
                double twoValue = asDoubleNode.execute(frame, inliningTarget, two);
                if (oneValue == null) {
                    if (canBeDoubleNode.execute(inliningTarget, one)) {
                        return ComplexNode.createComplex(cls, asDoubleNode.execute(frame, inliningTarget, one), twoValue, inliningTarget, isPrimitiveProfile, factory);
                    }
                    throw ComplexNode.raiseFirstArgError(one, raiseNode.get(inliningTarget));
                }
                return ComplexNode.createComplex(cls, oneValue.getReal(), oneValue.getImag() + twoValue, inliningTarget, isPrimitiveProfile, factory);
            }
            throw ComplexNode.raiseSecondArgError(two, raiseNode.get(inliningTarget));
        }

        @Specialization
        PComplex complexFromString(VirtualFrame frame, Object cls, TruffleString real, Object imaginary, @Bind(value="this") Node inliningTarget, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (imaginary != PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.COMPLEX_CANT_TAKE_ARG);
            }
            return this.convertStringToComplex(frame, inliningTarget, toJavaStringNode.execute((AbstractTruffleString)real), cls, real, raiseNode);
        }

        @Specialization
        PComplex complexFromString(VirtualFrame frame, Object cls, PString real, Object imaginary, @Bind(value="this") Node inliningTarget, @Cached CastToJavaStringNode castToStringNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (imaginary != PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.COMPLEX_CANT_TAKE_ARG);
            }
            return this.convertStringToComplex(frame, inliningTarget, castToStringNode.execute(real), cls, real, raiseNode);
        }

        private Object callComplex(VirtualFrame frame, Object object) {
            if (this.callComplexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callComplexNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodNames.T___COMPLEX__));
            }
            return this.callComplexNode.executeObject(frame, object);
        }

        private WarningsModuleBuiltins.WarnNode getWarnNode() {
            if (this.warnNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.warnNode = (WarningsModuleBuiltins.WarnNode)this.insert(WarningsModuleBuiltins.WarnNode.create());
            }
            return this.warnNode;
        }

        private static PException raiseFirstArgError(Object x, PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_STRING_OR_NUMBER, "complex() first", x);
        }

        private static PException raiseSecondArgError(Object x, PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_NUMBER, "complex() second", x);
        }

        private PComplex getComplexNumberFromObject(VirtualFrame frame, Object object, Node inliningTarget, PyComplexCheckExactNode isComplexType, PyComplexCheckExactNode isResultComplexType, PRaiseNode.Lazy raiseNode) {
            if (isComplexType.execute(inliningTarget, object)) {
                return (PComplex)object;
            }
            Object result = this.callComplex(frame, object);
            if (result instanceof PComplex) {
                if (!isResultComplexType.execute(inliningTarget, result)) {
                    this.getWarnNode().warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, object, "__complex__", "complex", result, "complex");
                }
                return (PComplex)result;
            }
            if (result != PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.COMPLEX_RETURNED_NON_COMPLEX, result);
            }
            if (object instanceof PComplex) {
                return (PComplex)object;
            }
            return null;
        }

        @Fallback
        static Object complexGeneric(Object cls, Object realObj, Object imaginaryObj, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "complex.__new__(X): X", cls);
        }

        private PComplex convertStringToComplex(VirtualFrame frame, Node inliningTarget, String src, Object cls, Object origObj, PRaiseNode.Lazy raiseNode) {
            String str = FloatUtils.removeUnicodeAndUnderscores(src);
            if (str == null) {
                Object strStr;
                if (this.callReprNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.callReprNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodSlot.Repr));
                }
                if (PGuards.isString(strStr = this.callReprNode.executeObject(frame, origObj))) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.COULD_NOT_CONVERT_STRING_TO_COMPLEX, strStr);
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError);
            }
            PComplex c = this.convertStringToComplexOrNull(str, cls);
            if (c == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.COMPLEX_ARG_IS_MALFORMED_STR);
            }
            return c;
        }

        @CompilerDirectives.TruffleBoundary
        private PComplex convertStringToComplexOrNull(String str, Object cls) {
            boolean expectJ;
            double y;
            double x;
            char ch;
            boolean gotBracket;
            int len = str.length();
            int i = FloatUtils.skipAsciiWhitespace(str, 0, len);
            if (i < len && str.charAt(i) == '(') {
                gotBracket = true;
                i = FloatUtils.skipAsciiWhitespace(str, i + 1, len);
            } else {
                gotBracket = false;
            }
            FloatUtils.StringToDoubleResult res1 = FloatUtils.stringToDouble(str, i, len);
            if (res1 != null) {
                i = res1.position;
                char c = ch = i < len ? str.charAt(i) : (char)'\u0000';
                if (ch == '+' || ch == '-') {
                    x = res1.value;
                    FloatUtils.StringToDoubleResult res2 = FloatUtils.stringToDouble(str, i, len);
                    if (res2 != null) {
                        y = res2.value;
                        i = res2.position;
                    } else {
                        y = ch == '+' ? 1.0 : -1.0;
                        ++i;
                    }
                    expectJ = true;
                } else if (ch == 'j' || ch == 'J') {
                    ++i;
                    y = res1.value;
                    x = 0.0;
                    expectJ = false;
                } else {
                    x = res1.value;
                    y = 0.0;
                    expectJ = false;
                }
            } else {
                char c = ch = i < len ? str.charAt(i) : (char)'\u0000';
                if (ch == '+' || ch == '-') {
                    y = ch == '+' ? 1.0 : -1.0;
                    ++i;
                } else {
                    y = 1.0;
                }
                x = 0.0;
                expectJ = true;
            }
            if (expectJ) {
                char c = ch = i < len ? str.charAt(i) : (char)'\u0000';
                if (ch != 'j' && ch != 'J') {
                    return null;
                }
                ++i;
            }
            i = FloatUtils.skipAsciiWhitespace(str, i, len);
            if (gotBracket) {
                if (i >= len || str.charAt(i) != ')') {
                    return null;
                }
                i = FloatUtils.skipAsciiWhitespace(str, i + 1, len);
            }
            if (i != len) {
                return null;
            }
            return ComplexNode.createComplex(cls, x, y, null, BuiltinClassProfiles.IsBuiltinClassExactProfile.getUncached(), PythonObjectFactory.getUncached());
        }
    }

    @Builtin(name="bytearray", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PByteArray)
    @GenerateNodeFactory
    public static abstract class ByteArrayNode
    extends PythonBuiltinNode {
        @Specialization
        public PByteArray setEmpty(Object cls, Object arg, @Cached PythonObjectFactory factory) {
            return factory.createByteArray(cls, PythonUtils.EMPTY_BYTE_ARRAY);
        }
    }

    @Builtin(name="bytes", minNumOfPositionalArgs=1, parameterNames={"$self", "source", "encoding", "errors"}, constructsClass=PythonBuiltinClassType.PBytes)
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytes()\""}), @ArgumentClinic(name="errors", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytes()\""})})
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodSlot.class})
    public static abstract class BytesNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinConstructorsClinicProviders.BytesNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"isNoValue(source)"})
        static Object doEmpty(Object cls, PNone source, PNone encoding, PNone errors, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CreateBytes createBytes) {
            return createBytes.execute(inliningTarget, cls, PythonUtils.EMPTY_BYTE_ARRAY);
        }

        @Specialization(guards={"!isNoValue(source)"})
        static Object doCallBytes(VirtualFrame frame, Object cls, Object source, PNone encoding, PNone errors, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached InlinedConditionProfile hasBytes, @Cached(value="create(Bytes)") LookupSpecialMethodSlotNode lookupBytes, @Cached CallUnaryMethodNode callBytes, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached PyBytesCheckNode check, @Cached.Exclusive @Cached BytesNodes.BytesInitNode bytesInitNode, @Cached.Exclusive @Cached CreateBytes createBytes, @Cached PRaiseNode.Lazy raiseNode) {
            Object bytesMethod = lookupBytes.execute((Frame)frame, getClassNode.execute(inliningTarget, source), source);
            if (hasBytes.profile(inliningTarget, bytesMethod != PNone.NO_VALUE)) {
                Object bytes = callBytes.executeObject((Frame)frame, bytesMethod, source);
                if (check.execute(inliningTarget, bytes)) {
                    if (cls == PythonBuiltinClassType.PBytes) {
                        return bytes;
                    }
                    return createBytes.execute(inliningTarget, cls, toBytesNode.execute(frame, bytes));
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NONBYTES, SpecialMethodNames.T___BYTES__, bytes);
            }
            return createBytes.execute(inliningTarget, cls, bytesInitNode.execute(frame, inliningTarget, source, encoding, errors));
        }

        @Specialization(guards={"isNoValue(source) || (!isNoValue(encoding) || !isNoValue(errors))"})
        static Object dontCallBytes(VirtualFrame frame, Object cls, Object source, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BytesNodes.BytesInitNode bytesInitNode, @Cached.Exclusive @Cached CreateBytes createBytes) {
            return createBytes.execute(inliningTarget, cls, bytesInitNode.execute(frame, inliningTarget, source, encoding, errors));
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class CreateBytes
        extends PNodeWithContext {
            CreateBytes() {
            }

            abstract Object execute(Node var1, Object var2, byte[] var3);

            @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)"})
            static PBytes doManaged(Node inliningTarget, Object cls, byte[] bytes, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached(inline=false) PythonObjectFactory factory) {
                return factory.createBytes(cls, bytes);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Specialization(guards={"needsNativeAllocationNode.execute(inliningTarget, cls)"})
            static Object doNative(Node inliningTarget, Object cls, byte[] bytes, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNative, @Cached(inline=false) CApiTransitions.NativeToPythonNode toPython, @Cached(inline=false) CExtNodes.PCallCapiFunction call) {
                CArrayWrappers.CByteArrayWrapper wrapper = new CArrayWrappers.CByteArrayWrapper(bytes);
                try {
                    Object object = toPython.execute(call.call(NativeCAPISymbol.FUN_BYTES_SUBTYPE_NEW, toNative.execute(cls), wrapper, bytes.length));
                    return object;
                }
                finally {
                    wrapper.free();
                }
            }
        }
    }
}

