/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonFileDetector;
import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsClinicProviders;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ast.AstModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.compiler.Compiler;
import com.oracle.graal.python.compiler.RaisePythonExceptionErrorCallback;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyEvalGetGlobals;
import com.oracle.graal.python.lib.PyEvalGetLocals;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectDir;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.PyUnicodeFSDecoderNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.attributes.DeleteAttributeNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.SetAttributeNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.bytecode.GetAIterNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.call.CallDispatchNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNode;
import com.oracle.graal.python.nodes.expression.TernaryArithmetic;
import com.oracle.graal.python.nodes.frame.GetFrameLocalsNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.pegparser.AbstractParser;
import com.oracle.graal.python.pegparser.ErrorCallback;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.Parser;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.CharsetMapping;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.utilities.TriState;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

@CoreFunctions(defineModule="builtins", isEager=true)
public final class BuiltinFunctions
extends PythonBuiltins {
    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BuiltinFunctionsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant(BuiltinNames.T___GRAALPYTHON__, (Object)core.lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__));
        this.addBuiltinConstant(StringLiterals.T_NONE, (Object)PNone.NONE);
        this.addBuiltinConstant(StringLiterals.T_FALSE, (Object)false);
        this.addBuiltinConstant(StringLiterals.T_TRUE, (Object)true);
        super.initialize(core);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule builtinsModule = core.lookupBuiltinModule(BuiltinNames.T_BUILTINS);
        builtinsModule.setAttribute(BuiltinNames.T___DEBUG__, core.getContext().getOption(PythonOptions.PythonOptimizeFlag) == false);
    }

    @Builtin(name="aiter", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AIter
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doGeneric(VirtualFrame frame, Object arg, @Cached(neverDefault=true) GetAIterNode aiter) {
            return aiter.execute((Frame)frame, arg);
        }
    }

    @Builtin(name="anext", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ANext
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doGeneric(VirtualFrame frame, Object asyncIter, @Bind(value="this") Node inliningTarget, @Cached(parameters={"ANext"}) LookupSpecialMethodSlotNode getANext, @Cached GetClassNode getAsyncIterType, @Cached PRaiseNode.Lazy raiseNoANext, @Cached CallUnaryMethodNode callANext, @Cached TypeNodes.GetNameNode getName) {
            Object type = getAsyncIterType.execute(inliningTarget, asyncIter);
            Object getter = getANext.execute((Frame)frame, type, asyncIter);
            if (getter == PNone.NO_VALUE) {
                throw raiseNoANext.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJECT_NOT_ASYNCGEN, getName.execute(inliningTarget, type));
            }
            return callANext.executeObject((Frame)frame, getter, asyncIter);
        }
    }

    @Builtin(name="__build_class__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodSlot.class})
    public static abstract class BuildClassNode
    extends PythonVarargsBuiltinNode {
        private static final TruffleString T_METACLASS = PythonUtils.tsLiteral("metaclass");
        public static final TruffleString T_BUILD_JAVA_CLASS = PythonUtils.tsLiteral("build_java_class");

        @CompilerDirectives.TruffleBoundary
        private static Object buildJavaClass(Object namespace, TruffleString name, Object base) {
            PythonModule module = PythonContext.get(null).lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__);
            Object buildFunction = PyObjectLookupAttr.executeUncached(module, T_BUILD_JAVA_CLASS);
            return CallNode.getUncached().execute(buildFunction, namespace, name, base);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doItNonFunction(VirtualFrame frame, Object function, Object[] arguments, final PKeyword[] keywords, final @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PythonObjectFactory factory, final @Cached CalculateMetaclassNode calculateMetaClass, @Cached(value="create(T___PREPARE__)") GetAttributeNode getPrepare, @Cached(parameters={"GetItem"}) LookupCallableSlotInMRONode getGetItem, @Cached GetClassNode getGetItemClass, @Cached CallVarargsMethodNode callPrep, @Cached CallVarargsMethodNode callType, @Cached CallDispatchNode callBody, final @Cached UpdateBasesNode update, @Cached PyObjectSetItem setOrigBases, final @Cached GetClassNode getClass, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile noAttributeProfile) {
            Object ns;
            class InitializeBuildClass {
                boolean isClass;
                Object meta;
                PKeyword[] mkw;
                PTuple bases;
                final /* synthetic */ BuildClassNode this$0;

                @CompilerDirectives.TruffleBoundary
                InitializeBuildClass() {
                    this.this$0 = this$0;
                    this.bases = updateBasesNode.execute(pTuple, objectArray, objectArray.length);
                    this.mkw = pKeywordArray;
                    for (int i = 0; i < pKeywordArray.length; ++i) {
                        if (!T_METACLASS.equalsUncached((AbstractTruffleString)pKeywordArray[i].getName(), PythonUtils.TS_ENCODING)) continue;
                        this.meta = pKeywordArray[i].getValue();
                        this.mkw = PKeyword.create(pKeywordArray.length - 1);
                        PythonUtils.arraycopy(pKeywordArray, 0, this.mkw, 0, i);
                        PythonUtils.arraycopy(pKeywordArray, i + 1, this.mkw, i, this.mkw.length - i);
                        this.isClass = TypeNodes.IsTypeNode.executeUncached(this.meta);
                        break;
                    }
                    if (this.meta == null) {
                        this.meta = this.bases.getSequenceStorage().length() == 0 ? PythonContext.get(updateBasesNode).lookupType(PythonBuiltinClassType.PythonClass) : getClassNode.execute(node, this.bases.getSequenceStorage().getItemNormalized(0));
                        this.isClass = true;
                    }
                    if (this.isClass) {
                        this.meta = calculateMetaclassNode.execute(this.meta, this.bases);
                    }
                }
            }
            InitializeBuildClass init;
            TruffleString name;
            if (arguments.length < 1) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.BUILD_CLS_NOT_ENOUGH_ARGS);
            }
            if (!PGuards.isFunction(function)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.BUILD_CLS_FUNC_MUST_BE_FUNC);
            }
            try {
                name = CastToTruffleStringNode.executeUncached(arguments[0]);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.BUILD_CLS_NAME_NOT_STRING);
            }
            final Object[] basesArray = Arrays.copyOfRange(arguments, 1, arguments.length);
            final PTuple origBases = factory.createTuple(basesArray);
            TruffleLanguage.Env env = PythonContext.get(calculateMetaClass).getEnv();
            if (arguments.length == 2 && env.isHostObject(arguments[1]) && env.asHostObject(arguments[1]) instanceof Class) {
                PDict ns2 = PythonObjectFactory.getUncached().createDict(new DynamicObjectStorage(PythonLanguage.get(null)));
                Object[] args = PArguments.create(0);
                PArguments.setSpecialArgument(args, ns2);
                callBody.executeCall(frame, (PFunction)function, args);
                return BuildClassNode.buildJavaClass(ns2, name, arguments[1]);
            }
            Object savedState = ExecutionContext.IndirectCallContext.enter(frame, indirectCallData);
            try {
                init = new InitializeBuildClass();
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, indirectCallData, savedState);
            }
            try {
                Object prep = getPrepare.executeObject(frame, init.meta);
                ns = callPrep.execute((Frame)frame, prep, new Object[]{name, init.bases}, init.mkw);
            }
            catch (PException p) {
                p.expectAttributeError(inliningTarget, noAttributeProfile);
                ns = factory.createDict(new DynamicObjectStorage(PythonLanguage.get(this)));
            }
            if (PGuards.isNoValue(getGetItem.execute(getGetItemClass.execute(inliningTarget, ns)))) {
                if (init.isClass) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.N_PREPARE_MUST_RETURN_MAPPING, init.meta, ns);
                }
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.MTCLS_PREPARE_MUST_RETURN_MAPPING, ns);
            }
            Object[] bodyArguments = PArguments.create(0);
            PArguments.setSpecialArgument(bodyArguments, ns);
            callBody.executeCall(frame, (PFunction)function, bodyArguments);
            if (init.bases != origBases) {
                setOrigBases.execute((Frame)frame, inliningTarget, ns, SpecialAttributeNames.T___ORIG_BASES__, origBases);
            }
            Object cls = callType.execute((Frame)frame, init.meta, new Object[]{name, init.bases, ns}, init.mkw);
            return cls;
        }
    }

    static abstract class CalculateMetaclassNode
    extends Node {
        CalculateMetaclassNode() {
        }

        abstract Object execute(Object var1, PTuple var2);

        @Specialization
        static Object calculate(Object metatype, PTuple bases, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClass, @Cached IsSubtypeNode isSubType, @Cached IsSubtypeNode isSubTypeReverse, @Cached PRaiseNode.Lazy raiseNode) {
            CompilerAsserts.neverPartOfCompilation();
            SequenceStorage storage = bases.getSequenceStorage();
            int nbases = storage.length();
            Object winner = metatype;
            for (int i = 0; i < nbases; ++i) {
                Object tmp = storage.getItemNormalized(i);
                Object tmpType = getClass.execute(inliningTarget, tmp);
                if (isSubType.execute(winner, tmpType)) continue;
                if (isSubTypeReverse.execute(tmpType, winner)) {
                    winner = tmpType;
                    continue;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.METACLASS_CONFLICT);
            }
            return winner;
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    static abstract class UpdateBasesNode
    extends Node {
        UpdateBasesNode() {
        }

        abstract PTuple execute(PTuple var1, Object[] var2, int var3);

        @Specialization
        static PTuple update(PTuple bases, Object[] arguments, int nargs, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached PyObjectLookupAttr getMroEntries, @Cached CallUnaryMethodNode callMroEntries, @Cached PRaiseNode.Lazy raiseNode) {
            CompilerAsserts.neverPartOfCompilation();
            ArrayList<Object> newBases = null;
            for (int i = 0; i < nargs; ++i) {
                Object base = arguments[i];
                if (TypeNodes.IsTypeNode.executeUncached(base)) {
                    if (newBases == null) continue;
                    newBases.add(base);
                    continue;
                }
                Object meth = getMroEntries.execute(null, inliningTarget, base, SpecialMethodNames.T___MRO_ENTRIES__);
                if (PGuards.isNoValue(meth)) {
                    if (newBases == null) continue;
                    newBases.add(base);
                    continue;
                }
                Object newBase = callMroEntries.executeObject(null, meth, bases);
                if (!PGuards.isPTuple(newBase)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.MRO_ENTRIES_MUST_RETURN_TUPLE);
                }
                PTuple newBaseTuple = (PTuple)newBase;
                if (newBases == null) {
                    newBases = new ArrayList<Object>();
                    for (int j = 0; j < i; ++j) {
                        newBases.add(arguments[j]);
                    }
                }
                SequenceStorage storage = newBaseTuple.getSequenceStorage();
                for (int j = 0; j < storage.length(); ++j) {
                    newBases.add(storage.getItemNormalized(j));
                }
            }
            if (newBases == null) {
                return bases;
            }
            return factory.createTuple(newBases.toArray());
        }
    }

    @Builtin(name="open", minNumOfPositionalArgs=1, parameterNames={"file", "mode", "buffering", "encoding", "errors", "newline", "closefd", "opener"})
    @ArgumentsClinic(value={@ArgumentClinic(name="mode", conversionClass=IONodes.CreateIOModeNode.class, args={"true"}), @ArgumentClinic(name="buffering", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="newline", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="closefd", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true", useDefaultForNone=true)})
    @ImportStatic(value={IONodes.IOMode.class})
    @GenerateNodeFactory
    public static abstract class OpenNode
    extends IOModuleBuiltins.IOOpenNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.OpenNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="vars", maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class VarsNode
    extends PythonUnaryBuiltinNode {
        VarsNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object vars(VirtualFrame frame, PNone none, @Bind(value="this") Node inliningTarget, @Cached PyEvalGetLocals getLocals) {
            return getLocals.execute(frame, inliningTarget);
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object vars(VirtualFrame frame, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached PRaiseNode.Lazy raiseNode) {
            Object dict = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialAttributeNames.T___DICT__);
            if (dict == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.VARS_ARGUMENT_MUST_HAVE_DICT);
            }
            return dict;
        }
    }

    @Builtin(name="locals", needsFrame=true, alwaysNeedsCallerFrame=true)
    @GenerateNodeFactory
    static abstract class LocalsNode
    extends PythonBuiltinNode {
        LocalsNode() {
        }

        @Specialization
        Object locals(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @Cached PyEvalGetLocals getLocals) {
            return getLocals.execute(frame, inliningTarget);
        }
    }

    @Builtin(name="globals", needsFrame=true, alwaysNeedsCallerFrame=true)
    @GenerateNodeFactory
    static abstract class GlobalsNode
    extends PythonBuiltinNode {
        private final ConditionProfile condProfile = ConditionProfile.create();

        GlobalsNode() {
        }

        @Specialization
        public Object globals(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @Cached PyEvalGetGlobals getGlobals, @Cached GetOrCreateDictNode getDict) {
            Object globals = getGlobals.execute(frame, inliningTarget);
            if (this.condProfile.profile(globals instanceof PythonModule)) {
                return getDict.execute(inliningTarget, globals);
            }
            return globals;
        }
    }

    @Builtin(name="sum", minNumOfPositionalArgs=1, parameterNames={"iterable", "start"})
    @GenerateNodeFactory
    public static abstract class SumFunctionNode
    extends PythonBuiltinNode {
        @Node.Child
        private LookupAndCallUnaryNode next = LookupAndCallUnaryNode.create(SpecialMethodSlot.Next);
        @Node.Child
        private BinaryArithmetic.AddNode add = BinaryArithmetic.AddNode.create();

        @Specialization(rewriteOn={UnexpectedResultException.class})
        int sumIntNone(VirtualFrame frame, Object arg1, PNone start, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter) throws UnexpectedResultException {
            return this.sumIntInternal(frame, inliningTarget, arg1, 0, getIter, errorProfile);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        int sumIntInt(VirtualFrame frame, Object arg1, int start, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter) throws UnexpectedResultException {
            return this.sumIntInternal(frame, inliningTarget, arg1, start, getIter, errorProfile);
        }

        private int sumIntInternal(VirtualFrame frame, Node inliningTarget, Object arg1, int start, PyObjectGetIter getIter, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, arg1);
            int value = start;
            while (true) {
                int nextValue;
                try {
                    nextValue = PGuards.expectInteger(this.next.executeObject(frame, iterator));
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    return value;
                }
                catch (UnexpectedResultException e) {
                    Object newValue = this.add.executeObject(frame, value, e.getResult());
                    throw new UnexpectedResultException(this.iterateGeneric(frame, inliningTarget, iterator, newValue, errorProfile));
                }
                try {
                    value = this.add.executeInt(frame, value, nextValue);
                }
                catch (UnexpectedResultException e) {
                    throw new UnexpectedResultException(this.iterateGeneric(frame, inliningTarget, iterator, e.getResult(), errorProfile));
                }
            }
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        double sumDoubleDouble(VirtualFrame frame, Object arg1, double start, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared @Cached InlinedConditionProfile hasStart, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) throws UnexpectedResultException {
            return this.sumDoubleInternal(frame, inliningTarget, arg1, start, getIter, errorProfile);
        }

        private double sumDoubleInternal(VirtualFrame frame, Node inliningTarget, Object arg1, double start, PyObjectGetIter getIter, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, arg1);
            double value = start;
            while (true) {
                double nextValue;
                try {
                    nextValue = PGuards.expectDouble(this.next.executeObject(frame, iterator));
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    return value;
                }
                catch (UnexpectedResultException e) {
                    Object newValue = this.add.executeObject(frame, value, e.getResult());
                    throw new UnexpectedResultException(this.iterateGeneric(frame, inliningTarget, iterator, newValue, errorProfile));
                }
                try {
                    value = this.add.executeDouble(frame, value, nextValue);
                }
                catch (UnexpectedResultException e) {
                    throw new UnexpectedResultException(this.iterateGeneric(frame, inliningTarget, iterator, e.getResult(), errorProfile));
                }
            }
        }

        @Specialization(replaces={"sumIntNone", "sumIntInt", "sumDoubleDouble"})
        Object sum(VirtualFrame frame, Object arg1, Object start, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared @Cached InlinedConditionProfile hasStart, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (PGuards.isString(start)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANT_SUM_STRINGS);
            }
            if (start instanceof PBytes) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANT_SUM_BYTES);
            }
            if (start instanceof PByteArray) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANT_SUM_BYTEARRAY);
            }
            Object iterator = getIter.execute((Frame)frame, inliningTarget, arg1);
            return this.iterateGeneric(frame, inliningTarget, iterator, hasStart.profile(inliningTarget, start != PNone.NO_VALUE) ? start : Integer.valueOf(0), errorProfile);
        }

        private Object iterateGeneric(VirtualFrame frame, Node inliningTarget, Object iterator, Object start, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            Object value = start;
            while (true) {
                Object nextValue;
                try {
                    nextValue = this.next.executeObject(frame, iterator);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    return value;
                }
                value = this.add.executeObject(frame, value, nextValue);
            }
        }
    }

    @Builtin(name="pow", minNumOfPositionalArgs=2, parameterNames={"base", "exp", "mod"})
    @GenerateNodeFactory
    public static abstract class PowNode
    extends PythonTernaryBuiltinNode {
        @NeverDefault
        static BinaryOpNode binaryPow() {
            return BinaryArithmetic.Pow.create();
        }

        @NeverDefault
        static LookupAndCallTernaryNode ternaryPow() {
            return TernaryArithmetic.Pow.create();
        }

        @Specialization
        Object binary(VirtualFrame frame, Object x, Object y, PNone z, @Cached(value="binaryPow()") BinaryOpNode powNode) {
            return powNode.executeObject(frame, x, y);
        }

        @Specialization(guards={"!isPNone(z)"})
        Object ternary(VirtualFrame frame, Object x, Object y, Object z, @Cached(value="ternaryPow()") LookupAndCallTernaryNode powNode) {
            return powNode.execute(frame, x, y, z);
        }
    }

    @Builtin(name="breakpoint", takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class BreakPointNode
    extends PythonBuiltinNode {
        @Node.Child
        private ReadAttributeFromObjectNode getBreakpointhookNode;
        @Node.Child
        private CallNode callNode;

        @Specialization
        Object doIt(VirtualFrame frame, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode.Lazy raiseNode) {
            if (this.getDebuggerSessionCount() > 0) {
                return PNone.NONE;
            }
            if (this.getContext().isInitialized()) {
                PDict sysModules;
                Object sysModule;
                Object breakpointhook;
                if (this.callNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getBreakpointhookNode = (ReadAttributeFromObjectNode)this.insert(ReadAttributeFromObjectNode.create());
                    this.callNode = (CallNode)this.insert(CallNode.create());
                }
                if ((breakpointhook = this.getBreakpointhookNode.execute(sysModule = getItem.execute(inliningTarget, (sysModules = this.getContext().getSysModules()).getDictStorage(), BuiltinNames.T_SYS), (Object)BuiltinNames.T_BREAKPOINTHOOK)) == PNone.NO_VALUE) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.LOST_SYSBREAKPOINTHOOK);
                }
                return this.callNode.execute((Frame)frame, breakpointhook, args, kwargs);
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private int getDebuggerSessionCount() {
            return Debugger.find((TruffleLanguage.Env)this.getContext().getEnv()).getSessionCount();
        }
    }

    @Builtin(name="sorted", minNumOfPositionalArgs=1, parameterNames={"$self"}, keywordOnlyNames={"key", "reverse"})
    @ArgumentClinic(name="reverse", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false")
    @GenerateNodeFactory
    public static abstract class SortedNode
    extends PythonClinicBuiltinNode {
        public abstract Object executeInternal(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @Specialization
        Object sorted(VirtualFrame frame, Object iterable, Object keyfunc, boolean reverse, @Cached ListNodes.ConstructListNode constructListNode, @Cached ListBuiltins.ListSortNode sortNode) {
            PList list = constructListNode.execute((Frame)frame, iterable);
            sortNode.execute(frame, list, keyfunc, reverse);
            return list;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.SortedNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="hasattr", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class HasAttrNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        boolean hasAttr(VirtualFrame frame, Object object, Object key, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr pyObjectLookupAttr) {
            return pyObjectLookupAttr.execute((Frame)frame, inliningTarget, object, key) != PNone.NO_VALUE;
        }
    }

    @Builtin(name="setattr", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SetAttrNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        Object setAttr(VirtualFrame frame, Object object, Object key, Object value, @Cached SetAttributeNode.Dynamic setAttrNode) {
            setAttrNode.execute(frame, object, key, value);
            return PNone.NONE;
        }
    }

    @Builtin(name="round", minNumOfPositionalArgs=1, parameterNames={"number", "ndigits"})
    @GenerateNodeFactory
    public static abstract class RoundNode
    extends PythonBuiltinNode {
        @Specialization
        static Object round(VirtualFrame frame, Object x, PNone n, @Bind(value="this") Node inliningTarget, @Cached(value="create(Round)") LookupAndCallUnaryNode callRound, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callRound.executeObject(frame, x);
            if (result == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_METHOD, x, SpecialMethodNames.T___ROUND__);
            }
            return result;
        }

        @Specialization(guards={"!isPNone(n)"})
        static Object round(VirtualFrame frame, Object x, Object n, @Bind(value="this") Node inliningTarget, @Cached(value="create(Round)") LookupAndCallBinaryNode callRound, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callRound.executeObject(frame, x, n);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_METHOD, x, SpecialMethodNames.T___ROUND__);
            }
            return result;
        }
    }

    @Builtin(name="ascii", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AsciiNode
    extends PythonUnaryBuiltinNode {
        AsciiNode() {
        }

        @Specialization
        public static TruffleString ascii(VirtualFrame frame, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectAsciiNode asciiNode) {
            return asciiNode.execute((Frame)frame, inliningTarget, obj);
        }
    }

    @Builtin(name="format", minNumOfPositionalArgs=1, parameterNames={"object", "format_spec"})
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class FormatNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object format(VirtualFrame frame, Object obj, Object formatSpec, @Bind(value="this") Node inliningTarget, @Cached(value="create(Format)") LookupAndCallBinaryNode callFormat, @Cached InlinedConditionProfile formatIsNoValueProfile, @Cached PRaiseNode.Lazy raiseNode) {
            Object format = formatIsNoValueProfile.profile(inliningTarget, PGuards.isNoValue(formatSpec)) ? StringLiterals.T_EMPTY_STRING : formatSpec;
            Object res = callFormat.executeObject(frame, obj, format);
            if (res == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_FORMAT, obj);
            }
            if (!PGuards.isString(res)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_MUST_RETURN_S_NOT_P, SpecialMethodNames.T___FORMAT__, "str", res);
            }
            return res;
        }

        @NeverDefault
        public static FormatNode create() {
            return BuiltinFunctionsFactory.FormatNodeFactory.create();
        }
    }

    @Builtin(name="repr", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object repr(VirtualFrame frame, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsObjectNode reprNode) {
            return reprNode.execute((Frame)frame, inliningTarget, obj);
        }
    }

    @Builtin(name="print", takesVarArgs=true, keywordOnlyNames={"sep", "end", "file", "flush"}, doc="\nprint(value, ..., sep=' ', end='\\n', file=sys.stdout, flush=False)\n\nPrints the values to a stream, or to sys.stdout by default.\nOptional keyword arguments:\nfile:  a file-like object (stream); defaults to the current sys.stdout.\nsep:   string inserted between values, default a space.\nend:   string appended after the last value, default a newline.\nflush: whether to forcibly flush the stream.")
    @GenerateNodeFactory
    public static abstract class PrintNode
    extends PythonBuiltinNode {
        @Node.Child
        private ReadAttributeFromObjectNode readStdout;
        @CompilerDirectives.CompilationFinal
        private PythonModule cachedSys;

        @Specialization
        PNone printNoKeywords(VirtualFrame frame, Object[] values, PNone sep, PNone end, PNone file, PNone flush, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getWriteMethod") @Cached PyObjectGetAttr getWriteMethod, @Cached.Shared(value="callWrite") @Cached CallNode callWrite, @Cached.Shared(value="callFlush") @Cached PyObjectCallMethodObjArgs callFlush, @Cached.Shared(value="strNode") @Cached PyObjectStrAsObjectNode strNode) {
            Object stdout = this.getStdout();
            return PrintNode.printAllGiven(frame, values, StringLiterals.T_SPACE, StringLiterals.T_NEWLINE, stdout, false, inliningTarget, getWriteMethod, callWrite, callFlush, strNode);
        }

        @Specialization(guards={"!isNone(file)", "!isNoValue(file)"})
        static PNone printAllGiven(VirtualFrame frame, Object[] values, TruffleString sep, TruffleString end, Object file, boolean flush, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getWriteMethod") @Cached PyObjectGetAttr getWriteMethod, @Cached.Shared(value="callWrite") @Cached CallNode callWrite, @Cached.Shared(value="callFlush") @Cached PyObjectCallMethodObjArgs callFlush, @Cached.Shared(value="strNode") @Cached PyObjectStrAsObjectNode strNode) {
            int lastValue = values.length - 1;
            Object writeMethod = getWriteMethod.execute((Frame)frame, inliningTarget, file, IONodes.T_WRITE);
            for (int i = 0; i < lastValue; ++i) {
                callWrite.execute((Frame)frame, writeMethod, strNode.execute((Frame)frame, inliningTarget, values[i]));
                callWrite.execute((Frame)frame, writeMethod, new Object[]{sep});
            }
            if (lastValue >= 0) {
                callWrite.execute((Frame)frame, writeMethod, strNode.execute((Frame)frame, inliningTarget, values[lastValue]));
            }
            callWrite.execute((Frame)frame, writeMethod, new Object[]{end});
            if (flush) {
                callFlush.execute((Frame)frame, inliningTarget, file, IONodes.T_FLUSH, new Object[0]);
            }
            return PNone.NONE;
        }

        @Specialization(replaces={"printAllGiven", "printNoKeywords"})
        PNone printGeneric(VirtualFrame frame, Object[] values, Object sepIn, Object endIn, Object fileIn, Object flushIn, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castSep, @Cached CastToTruffleStringNode castEnd, @Cached CoerceToBooleanNode.YesNode castFlush, @Cached.Exclusive @Cached PyObjectGetAttr getWriteMethod, @Cached.Exclusive @Cached CallNode callWrite, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callFlush, @Cached.Exclusive @Cached PyObjectStrAsObjectNode strNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString end;
            TruffleString sep;
            try {
                sep = sepIn instanceof PNone ? StringLiterals.T_SPACE : castSep.execute(inliningTarget, sepIn);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.SEP_MUST_BE_NONE_OR_STRING, sepIn);
            }
            try {
                end = endIn instanceof PNone ? StringLiterals.T_NEWLINE : castEnd.execute(inliningTarget, endIn);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_NONE_OR_STRING, "end", sepIn);
            }
            Object file = fileIn instanceof PNone ? this.getStdout() : fileIn;
            boolean flush = flushIn instanceof PNone ? false : castFlush.executeBoolean(frame, inliningTarget, flushIn);
            return PrintNode.printAllGiven(frame, values, sep, end, file, flush, inliningTarget, getWriteMethod, callWrite, callFlush, strNode);
        }

        private Object getStdout() {
            Object stdout;
            PythonModule sys;
            if (this.getLanguage().isSingleContext()) {
                if (this.cachedSys == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cachedSys = this.getContext().lookupBuiltinModule(BuiltinNames.T_SYS);
                }
                sys = this.cachedSys;
            } else {
                if (this.cachedSys != null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.cachedSys = null;
                }
                sys = this.getContext().lookupBuiltinModule(BuiltinNames.T_SYS);
            }
            if (this.readStdout == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readStdout = (ReadAttributeFromObjectNode)this.insert(ReadAttributeFromObjectNode.create());
            }
            if ((stdout = this.readStdout.execute(sys, BuiltinNames.T_STDOUT)) instanceof PNone) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.LOST_SYSSTDOUT);
            }
            return stdout;
        }
    }

    @Builtin(name="ord", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class OrdNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isString(chrObj)"})
        static int ord(Object chrObj, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString chr;
            try {
                chr = castToStringNode.execute(inliningTarget, chrObj);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
            int len = codePointLengthNode.execute((AbstractTruffleString)chr, PythonUtils.TS_ENCODING);
            if (len != 1) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_CHARACTER_BUT_STRING_FOUND, "ord()", len);
            }
            return codePointAtIndexNode.execute((AbstractTruffleString)chr, 0, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static long ord(PBytesLike chr, @Bind(value="this") Node inliningTarget, @Cached CastToJavaLongExactNode castNode, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int len = chr.getSequenceStorage().length();
            if (len != 1) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_CHARACTER_BUT_STRING_FOUND, "ord()", len);
            }
            return castNode.execute(inliningTarget, getItemNode.execute(chr.getSequenceStorage(), 0));
        }

        @Specialization(guards={"!isString(obj)", "!isBytes(obj)"})
        static Object ord(Object obj, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.S_EXPECTED_STRING_OF_LEN_BUT_P, "ord()", "1", "obj");
        }
    }

    @Builtin(name="next", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object next(VirtualFrame frame, Object iterator, Object defaultObject, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile defaultIsNoValue, @Cached(value="createNextCall()") LookupAndCallUnaryNode callNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            if (defaultIsNoValue.profile(inliningTarget, PGuards.isNoValue(defaultObject))) {
                return callNode.executeObject(frame, iterator);
            }
            try {
                return callNode.executeObject(frame, iterator);
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return defaultObject;
            }
        }

        @NeverDefault
        protected LookupAndCallUnaryNode createNextCall() {
            return LookupAndCallUnaryNode.create(SpecialMethodNames.T___NEXT__, () -> new LookupAndCallUnaryNode.NoAttributeHandler(){
                @Node.Child
                PRaiseNode raiseNode = PRaiseNode.create();

                @Override
                public Object execute(Object iterator) {
                    throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_ISNT_ITERATOR, iterator);
                }
            });
        }
    }

    @Builtin(name="min", minNumOfPositionalArgs=1, takesVarArgs=true, keywordOnlyNames={"key", "default"})
    @GenerateNodeFactory
    public static abstract class MinNode
    extends PythonBuiltinNode {
        @Specialization
        static Object min(VirtualFrame frame, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, @Bind(value="this") Node inliningTarget, @Cached MinMaxNode minMaxNode, @Cached BinaryComparisonNode.LtNode ltNode) {
            return minMaxNode.execute(frame, inliningTarget, arg1, args, keywordArgIn, defaultVal, "min", ltNode);
        }
    }

    @Builtin(name="max", minNumOfPositionalArgs=1, takesVarArgs=true, keywordOnlyNames={"key", "default"}, doc="max(iterable, *[, default=obj, key=func]) -> value\nmax(arg1, arg2, *args, *[, key=func]) -> value\n\nWith a single iterable argument, return its biggest item. The\ndefault keyword-only argument specifies an object to return if\nthe provided iterable is empty.\nWith two or more arguments, return the largest argument.")
    @GenerateNodeFactory
    public static abstract class MaxNode
    extends PythonBuiltinNode {
        @Specialization
        static Object max(VirtualFrame frame, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, @Bind(value="this") Node inliningTarget, @Cached MinMaxNode minMaxNode, @Cached BinaryComparisonNode.GtNode gtNode) {
            return minMaxNode.execute(frame, inliningTarget, arg1, args, keywordArgIn, defaultVal, "max", gtNode);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class MinMaxNode
    extends Node {
        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object[] var4, Object var5, Object var6, String var7, BinaryComparisonNode var8);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"args.length == 0"})
        static Object minmaxSequenceWithKey(VirtualFrame frame, Node inliningTarget, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, String name, BinaryComparisonNode compare, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached(inline=false) GetNextNode nextNode, @Cached.Exclusive @Cached CoerceToBooleanNode.YesNode castToBooleanNode, @Cached.Exclusive @Cached CallNode.Lazy keyCall, @Cached.Exclusive @Cached InlinedBranchProfile seenNonBoolean, @Cached.Exclusive @Cached InlinedConditionProfile keywordArgIsNone, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile1, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile2, @Cached.Exclusive @Cached InlinedConditionProfile hasDefaultProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object currentValue;
            boolean kwArgsAreNone = keywordArgIsNone.profile(inliningTarget, PGuards.isPNone(keywordArgIn));
            Object keywordArg = kwArgsAreNone ? null : keywordArgIn;
            Object iterator = getIter.execute((Frame)frame, inliningTarget, arg1);
            try {
                currentValue = nextNode.execute((Frame)frame, iterator);
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile1);
                if (hasDefaultProfile.profile(inliningTarget, PGuards.isNoValue(defaultVal))) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARG_IS_EMPTY_SEQ, name);
                }
                return defaultVal;
            }
            Object currentKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, currentValue);
            int loopCount = 0;
            try {
                while (true) {
                    boolean isTrue;
                    Object nextValue;
                    try {
                        nextValue = nextNode.execute((Frame)frame, iterator);
                    }
                    catch (PException e) {
                        e.expectStopIteration(inliningTarget, errorProfile2);
                        break;
                    }
                    Object nextKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, nextValue);
                    if (!seenNonBoolean.wasEntered(inliningTarget)) {
                        try {
                            isTrue = compare.executeBool(frame, nextKey, currentKey);
                        }
                        catch (UnexpectedResultException e) {
                            seenNonBoolean.enter(inliningTarget);
                            isTrue = castToBooleanNode.executeBoolean(frame, inliningTarget, e.getResult());
                        }
                    } else {
                        isTrue = castToBooleanNode.executeBoolean(frame, inliningTarget, compare.executeObject(frame, nextKey, currentKey));
                    }
                    if (isTrue) {
                        currentKey = nextKey;
                        currentValue = nextValue;
                    }
                    ++loopCount;
                }
                LoopNode.reportLoopCount((Node)inliningTarget, (int)(loopCount < 0 ? Integer.MAX_VALUE : loopCount));
            }
            catch (Throwable throwable) {
                LoopNode.reportLoopCount((Node)inliningTarget, (int)(loopCount < 0 ? Integer.MAX_VALUE : loopCount));
                throw throwable;
            }
            return currentValue;
        }

        @Specialization(guards={"args.length != 0"})
        static Object minmaxBinaryWithKey(VirtualFrame frame, Node inliningTarget, Object arg1, Object[] args, Object keywordArgIn, Object defaultVal, String name, BinaryComparisonNode compare, @Cached.Exclusive @Cached CallNode.Lazy keyCall, @Cached.Exclusive @Cached CoerceToBooleanNode.YesNode castToBooleanNode, @Cached.Exclusive @Cached InlinedBranchProfile seenNonBoolean, @Cached.Exclusive @Cached InlinedConditionProfile keywordArgIsNone, @Cached.Exclusive @Cached InlinedConditionProfile moreThanTwo, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached.Exclusive @Cached InlinedConditionProfile hasDefaultProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            boolean isTrue;
            Object keywordArg;
            boolean kwArgsAreNone = keywordArgIsNone.profile(inliningTarget, PGuards.isPNone(keywordArgIn));
            Object object = keywordArg = kwArgsAreNone ? null : keywordArgIn;
            if (!hasDefaultProfile.profile(inliningTarget, PGuards.isNoValue(defaultVal))) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SPECIFY_DEFAULT_FOR_S, name);
            }
            Object currentValue = arg1;
            Object currentKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, currentValue);
            Object nextValue = args[0];
            Object nextKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, nextValue);
            if (!seenNonBoolean.wasEntered(inliningTarget)) {
                try {
                    isTrue = compare.executeBool(frame, nextKey, currentKey);
                }
                catch (UnexpectedResultException e) {
                    seenNonBoolean.enter(inliningTarget);
                    isTrue = castToBooleanNode.executeBoolean(frame, inliningTarget, e.getResult());
                }
            } else {
                isTrue = castToBooleanNode.executeBoolean(frame, inliningTarget, compare.executeObject(frame, nextKey, currentKey));
            }
            if (isTrue) {
                currentKey = nextKey;
                currentValue = nextValue;
            }
            if (moreThanTwo.profile(inliningTarget, args.length > 1)) {
                loopProfile.profileCounted(inliningTarget, (long)args.length);
                LoopNode.reportLoopCount((Node)inliningTarget, (int)args.length);
                int i = 0;
                while (loopProfile.inject(inliningTarget, i < args.length)) {
                    nextValue = args[i];
                    nextKey = MinMaxNode.applyKeyFunction(frame, inliningTarget, keywordArg, keyCall, nextValue);
                    if (!seenNonBoolean.wasEntered(inliningTarget)) {
                        try {
                            isTrue = compare.executeBool(frame, nextKey, currentKey);
                        }
                        catch (UnexpectedResultException e) {
                            seenNonBoolean.enter(inliningTarget);
                            isTrue = castToBooleanNode.executeBoolean(frame, inliningTarget, e.getResult());
                        }
                    } else {
                        isTrue = castToBooleanNode.executeBoolean(frame, inliningTarget, compare.executeObject(frame, nextKey, currentKey));
                    }
                    if (isTrue) {
                        currentKey = nextKey;
                        currentValue = nextValue;
                    }
                    ++i;
                }
            }
            return currentValue;
        }

        private static Object applyKeyFunction(VirtualFrame frame, Node inliningTarget, Object keywordArg, CallNode.Lazy keyCall, Object currentValue) {
            return keywordArg == null ? currentValue : keyCall.get(inliningTarget).execute((Frame)frame, keywordArg, new Object[]{currentValue}, PKeyword.EMPTY_KEYWORDS);
        }
    }

    @Builtin(name="len", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public int len(VirtualFrame frame, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute((Frame)frame, inliningTarget, obj);
        }
    }

    @Builtin(name="iter", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ReportPolymorphism
    public static abstract class IterNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(sentinel)"})
        static Object iter(VirtualFrame frame, Object object, PNone sentinel, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter) {
            return getIter.execute((Frame)frame, inliningTarget, object);
        }

        @Specialization(guards={"callableCheck.execute(this, callable)", "!isNoValue(sentinel)"}, limit="1")
        static Object iter(Object callable, Object sentinel, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Cached PythonObjectFactory factory) {
            return factory.createSentinelIterator(callable, sentinel);
        }

        @Fallback
        static Object iterNotCallable(Object callable, Object sentinel, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.ITER_V_MUST_BE_CALLABLE);
        }
    }

    @Builtin(name="issubclass", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IsSubClassNode
    extends RecursiveBinaryCheckBaseNode {
        public abstract boolean executeBoolean(VirtualFrame var1, Object var2, Object var3);

        protected IsSubClassNode(byte depth) {
            super(depth);
        }

        protected IsSubClassNode() {
            this(0);
        }

        @Override
        public IsSubClassNode createRecursive(byte newDepth) {
            return BuiltinFunctionsFactory.IsSubClassNodeFactory.create(newDepth);
        }

        @Specialization(guards={"!isPTuple(cls)"})
        static boolean isSubclass(VirtualFrame frame, Object derived, Object cls, @Bind(value="this") Node inliningTarget, @Cached(value="create(Subclasscheck)") LookupAndCallBinaryNode subclassCheckNode, @Cached CoerceToBooleanNode.YesNode castToBooleanNode, @Cached IsSubtypeNode isSubtypeNode) {
            Object instanceCheckResult = subclassCheckNode.executeObject(frame, cls, derived);
            if (instanceCheckResult != PNotImplemented.NOT_IMPLEMENTED) {
                return castToBooleanNode.executeBoolean(frame, inliningTarget, instanceCheckResult);
            }
            return isSubtypeNode.execute(frame, derived, cls);
        }

        @NeverDefault
        public static IsSubClassNode create() {
            return BuiltinFunctionsFactory.IsSubClassNodeFactory.create();
        }
    }

    @Builtin(name="isinstance", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IsInstanceNode
    extends RecursiveBinaryCheckBaseNode {
        protected IsInstanceNode(byte depth) {
            super(depth);
        }

        protected IsInstanceNode() {
            this(0);
        }

        @Override
        public IsInstanceNode createRecursive(byte newDepth) {
            return BuiltinFunctionsFactory.IsInstanceNodeFactory.create(newDepth);
        }

        private static TriState isInstanceCheckInternal(VirtualFrame frame, Node inliningTarget, Object instance, Object cls, LookupAndCallBinaryNode instanceCheckNode, CoerceToBooleanNode castToBooleanNode) {
            Object instanceCheckResult = instanceCheckNode.executeObject(frame, cls, instance);
            if (instanceCheckResult == PNotImplemented.NOT_IMPLEMENTED) {
                return TriState.UNDEFINED;
            }
            return TriState.valueOf((boolean)castToBooleanNode.executeBoolean(frame, inliningTarget, instanceCheckResult));
        }

        @Specialization(guards={"isPythonClass(cls)"})
        static boolean isInstance(VirtualFrame frame, Object instance, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="instanceCheck") @Cached(value="create(InstanceCheck)") LookupAndCallBinaryNode instanceCheckNode, @Cached.Exclusive @Cached CoerceToBooleanNode.YesNode castToBooleanNode, @Cached GetClassNode getClassNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached IsSubtypeNode isSubtypeNode) {
            Object instanceClass = getClassNode.execute(inliningTarget, instance);
            return isSameTypeNode.execute(inliningTarget, instanceClass, cls) || isSubtypeNode.execute(frame, instanceClass, cls) || IsInstanceNode.isInstanceCheckInternal(frame, inliningTarget, instance, cls, instanceCheckNode, castToBooleanNode) == TriState.TRUE;
        }

        @Specialization(guards={"!isPTuple(cls)", "!isPythonClass(cls)"})
        static boolean isInstance(VirtualFrame frame, Object instance, Object cls, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="instanceCheck") @Cached(value="create(InstanceCheck)") LookupAndCallBinaryNode instanceCheckNode, @Cached.Exclusive @Cached CoerceToBooleanNode.YesNode castToBooleanNode, @Cached TypeBuiltins.InstanceCheckNode typeInstanceCheckNode) {
            TriState check = IsInstanceNode.isInstanceCheckInternal(frame, inliningTarget, instance, cls, instanceCheckNode, castToBooleanNode);
            if (check == TriState.UNDEFINED) {
                return typeInstanceCheckNode.executeWith(frame, cls, instance);
            }
            return check == TriState.TRUE;
        }
    }

    public static abstract class RecursiveBinaryCheckBaseNode
    extends PythonBinaryBuiltinNode {
        static final int MAX_EXPLODE_LOOP = 16;
        static final byte NON_RECURSIVE = 127;
        protected final byte depth;

        protected RecursiveBinaryCheckBaseNode(byte depth) {
            this.depth = depth;
        }

        public abstract boolean executeWith(VirtualFrame var1, Object var2, Object var3);

        @NeverDefault
        protected final RecursiveBinaryCheckBaseNode createRecursive() {
            return this.createRecursive((byte)(this.depth + 1));
        }

        @NeverDefault
        protected final RecursiveBinaryCheckBaseNode createNonRecursive() {
            return this.createRecursive((byte)127);
        }

        protected RecursiveBinaryCheckBaseNode createRecursive(byte newDepth) {
            throw new AbstractMethodError();
        }

        @Idempotent
        protected int getMaxExplodeLoop() {
            return 16 >> this.depth;
        }

        @Specialization(guards={"depth < getNodeRecursionLimit()", "getLength(clsTuple) == cachedLen", "cachedLen < getMaxExplodeLoop()"}, limit="getVariableArgumentInlineCacheLimit()")
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
        static boolean doTupleConstantLen(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind(value="this") Node inliningTarget, @Cached(value="getLength(clsTuple)") int cachedLen, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached(value="createRecursive()") RecursiveBinaryCheckBaseNode recursiveNode) {
            Object[] array = getObjectArrayNode.execute(inliningTarget, clsTuple);
            for (int i = 0; i < cachedLen; ++i) {
                Object cls = array[i];
                if (!recursiveNode.executeWith(frame, instance, cls)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"depth < getNodeRecursionLimit()"}, replaces={"doTupleConstantLen"})
        static boolean doRecursiveWithNode(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Shared @Cached(value="createRecursive()") RecursiveBinaryCheckBaseNode recursiveNode) {
            for (Object cls : getObjectArrayNode.execute(inliningTarget, clsTuple)) {
                if (!recursiveNode.executeWith(frame, instance, cls)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"depth != NON_RECURSIVE", "depth >= getNodeRecursionLimit()"})
        static boolean doRecursiveWithLoop(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached(value="createNonRecursive()") RecursiveBinaryCheckBaseNode node) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                boolean bl = RecursiveBinaryCheckBaseNode.callRecursiveWithNodeTruffleBoundary(inliningTarget, instance, clsTuple, getObjectArrayNode, node);
                return bl;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @Specialization(guards={"depth == NON_RECURSIVE"})
        boolean doRecursiveWithLoopReuseThis(VirtualFrame frame, Object instance, PTuple clsTuple, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            assert (frame == null);
            return RecursiveBinaryCheckBaseNode.callRecursiveWithNodeTruffleBoundary(inliningTarget, instance, clsTuple, getObjectArrayNode, this);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean callRecursiveWithNodeTruffleBoundary(Node inliningTarget, Object instance, PTuple clsTuple, SequenceNodes.GetObjectArrayNode getObjectArrayNode, RecursiveBinaryCheckBaseNode node) {
            return RecursiveBinaryCheckBaseNode.doRecursiveWithNode(null, instance, clsTuple, inliningTarget, getObjectArrayNode, node);
        }

        protected static int getLength(PTuple t) {
            return t.getSequenceStorage().length();
        }
    }

    @Builtin(name="id", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IdNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object doObject(Object value, @Cached ObjectNodes.GetIdNode getIdNode) {
            return getIdNode.execute(value);
        }
    }

    @Builtin(name="getattr", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class GetAttrNode
    extends PythonTernaryBuiltinNode {
        GetAttrNode() {
        }

        @Specialization(guards={"isNoValue(defaultValue)"})
        static Object getAttrNoDefault(VirtualFrame frame, Object primary, Object nameObj, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode cast, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached PyObjectGetAttr getAttr) {
            TruffleString name = GetAttrNode.castName(inliningTarget, nameObj, cast, raiseNode);
            return getAttr.execute((Frame)frame, inliningTarget, primary, name);
        }

        @Specialization(guards={"!isNoValue(defaultValue)"})
        static Object getAttrWithDefault(VirtualFrame frame, Object primary, Object nameObj, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode cast, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached InlinedConditionProfile noValueProfile, @Cached PyObjectLookupAttr lookupAttr) {
            TruffleString name = GetAttrNode.castName(inliningTarget, nameObj, cast, raiseNode);
            Object result = lookupAttr.execute((Frame)frame, inliningTarget, primary, name);
            if (noValueProfile.profile(inliningTarget, result == PNone.NO_VALUE)) {
                return defaultValue;
            }
            return result;
        }

        private static TruffleString castName(Node inliningTarget, Object nameObj, CastToTruffleStringNode cast, PRaiseNode.Lazy raiseNode) {
            TruffleString name;
            try {
                name = cast.execute(inliningTarget, nameObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.GETATTR_ATTRIBUTE_NAME_MUST_BE_STRING);
            }
            return name;
        }
    }

    @Builtin(name="delattr", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DelAttrNode
    extends PythonBinaryBuiltinNode {
        DelAttrNode() {
        }

        @Specialization
        Object delattr(VirtualFrame frame, Object object, Object name, @Bind(value="this") Node inliningTarget, @Cached DeleteAttributeNode delNode) {
            delNode.execute(frame, inliningTarget, object, name);
            return PNone.NONE;
        }
    }

    @Builtin(name="compile", minNumOfPositionalArgs=3, parameterNames={"source", "filename", "mode", "flags", "dont_inherit", "optimize"}, keywordOnlyNames={"_feature_version"})
    @ArgumentsClinic(value={@ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="dont_inherit", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false"), @ArgumentClinic(name="optimize", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1"), @ArgumentClinic(name="_feature_version", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1")})
    @GenerateNodeFactory
    public static abstract class CompileNode
    extends PythonClinicBuiltinNode {
        private static final int CO_NESTED = 16;
        private static final int CO_FUTURE_DIVISION = 131072;
        private static final int CO_FUTURE_ABSOLUTE_IMPORT = 262144;
        private static final int CO_FUTURE_WITH_STATEMENT = 524288;
        private static final int CO_FUTURE_PRINT_FUNCTION = 0x100000;
        private static final int CO_FUTURE_UNICODE_LITERALS = 0x200000;
        private static final int CO_FUTURE_BARRY_AS_BDFL = FutureFeature.BARRY_AS_BDFL.flagValue;
        private static final int CO_FUTURE_GENERATOR_STOP = 0x800000;
        private static final int CO_FUTURE_ANNOTATIONS = FutureFeature.ANNOTATIONS.flagValue;
        private static final int PyCF_MASK = 0x3E0000 | CO_FUTURE_BARRY_AS_BDFL | 0x800000 | CO_FUTURE_ANNOTATIONS;
        private static final int PyCF_MASK_OBSOLETE = 16;
        private static final int PyCF_DONT_IMPLY_DEDENT = 512;
        public static final int PyCF_ONLY_AST = 1024;
        public static final int PyCF_TYPE_COMMENTS = 4096;
        public static final int PyCF_ALLOW_TOP_LEVEL_AWAIT = 8192;
        private static final int PyCF_ALLOW_INCOMPLETE_INPUT = 16384;
        private static final int PyCF_COMPILE_MASK = 30208;
        private final boolean mayBeFromFile;
        private final boolean lstrip;

        public CompileNode(boolean mayBeFromFile, boolean lstrip) {
            this.mayBeFromFile = mayBeFromFile;
            this.lstrip = lstrip;
        }

        public CompileNode() {
            this.mayBeFromFile = true;
            this.lstrip = false;
        }

        public final PCode compile(VirtualFrame frame, Object source, TruffleString filename, TruffleString mode, int optimize, int featureVersion) {
            return (PCode)this.executeInternal(frame, source, filename, mode, 0, false, optimize, featureVersion);
        }

        protected abstract Object executeInternal(VirtualFrame var1, Object var2, TruffleString var3, TruffleString var4, int var5, boolean var6, int var7, int var8);

        @Specialization
        Object doCompile(VirtualFrame frame, TruffleString expression, TruffleString filename, TruffleString mode, int flags, boolean dontInherit, int optimize, int featureVersion, @Cached.Shared @Cached ReadCallerFrameNode readCallerFrame, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (!dontInherit) {
                PFrame fr = readCallerFrame.executeWith(frame, 0);
                PCode code = factory.createCode(fr.getTarget());
                flags |= code.getFlags() & PyCF_MASK;
            }
            return this.compile(expression, filename, mode, flags, dontInherit, optimize, featureVersion, factory);
        }

        @CompilerDirectives.TruffleBoundary
        Object compile(TruffleString expression, TruffleString filename, TruffleString mode, int flags, boolean dontInherit, int optimize, int featureVersion, PythonObjectFactory factory) {
            int c;
            this.checkFlags(flags);
            this.checkOptimize(optimize, optimize);
            this.checkSource(expression);
            TruffleString code = expression;
            PythonContext context = this.getContext();
            InputType type = this.getParserInputType(mode, flags);
            if (type == InputType.FUNCTION_TYPE && (flags & 0x400) == 0) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.ValueError, ErrorMessages.COMPILE_MODE_FUNC_TYPE_REQUIED_FLAG_ONLY_AST);
            }
            if (this.lstrip && !code.isEmpty() && ((c = code.codePointAtIndexUncached(0, PythonUtils.TS_ENCODING)) == 32 || c == 9)) {
                code = code.substringUncached(1, code.codePointLengthUncached(PythonUtils.TS_ENCODING) - 1, PythonUtils.TS_ENCODING, true);
            }
            if ((flags & 0x400) != 0) {
                Source source = PythonLanguage.newSource(context, code, filename, this.mayBeFromFile, "text/x-python");
                RaisePythonExceptionErrorCallback errorCb = new RaisePythonExceptionErrorCallback(source, PythonOptions.isPExceptionWithJavaStacktrace(this.getLanguage()));
                EnumSet<AbstractParser.Flags> compilerFlags = EnumSet.noneOf(AbstractParser.Flags.class);
                if ((flags & 0x1000) != 0) {
                    compilerFlags.add(AbstractParser.Flags.TYPE_COMMENTS);
                }
                if (featureVersion < 0) {
                    featureVersion = 10;
                }
                if (featureVersion < 7) {
                    compilerFlags.add(AbstractParser.Flags.ASYNC_HACKS);
                }
                Parser parser = Compiler.createParser(code.toJavaStringUncached(), errorCb, type, compilerFlags, featureVersion);
                ModTy mod = (ModTy)parser.parse();
                errorCb.triggerDeprecationWarnings();
                return AstModuleBuiltins.sst2Obj(this.getContext(), mod);
            }
            TruffleString finalCode = code;
            Supplier createCode = () -> {
                if (type == InputType.FILE) {
                    Source source = PythonLanguage.newSource(context, finalCode, filename, this.mayBeFromFile, PythonLanguage.getCompileMimeType(optimize, flags));
                    return context.getEnv().parsePublic(source, new String[0]);
                }
                if (type == InputType.EVAL) {
                    Source source = PythonLanguage.newSource(context, finalCode, filename, this.mayBeFromFile, PythonLanguage.getEvalMimeType(optimize, flags));
                    return context.getEnv().parsePublic(source, new String[0]);
                }
                Source source = PythonLanguage.newSource(context, finalCode, filename, this.mayBeFromFile, "text/x-python");
                return context.getLanguage().parse(context, source, InputType.SINGLE, false, optimize, false, null, FutureFeature.fromFlags(flags));
            };
            CallTarget ct = this.getContext().isCoreInitialized() ? (CallTarget)createCode.get() : this.getContext().getLanguage().cacheCode(filename, createCode);
            return CompileNode.wrapRootCallTarget((RootCallTarget)ct, factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Specialization(limit="3")
        Object generic(VirtualFrame frame, Object wSource, Object wFilename, TruffleString mode, int flags, boolean dontInherit, int optimize, int featureVersion, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached CodecsModuleBuiltins.HandleDecodingErrorNode handleDecodingErrorNode, @Cached PyObjectStrAsTruffleStringNode asStrNode, @CachedLibrary(value="wSource") InteropLibrary interopLib, @Cached PyUnicodeFSDecoderNode asPath, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached ReadCallerFrameNode readCallerFrame, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (wSource instanceof PCode) {
                return wSource;
            }
            if (acquireLib.hasBuffer(wFilename)) {
                filenameBuffer = acquireLib.acquireReadonly(wFilename, frame, indirectCallData);
                try {
                    utf8 = fromByteArrayNode.execute(bufferLib.getCopiedByteArray(filenameBuffer), TruffleString.Encoding.UTF_8, false);
                    filename = switchEncodingNode.execute((AbstractTruffleString)utf8, PythonUtils.TS_ENCODING);
                    if (wFilename instanceof PBytes) ** GOTO lbl15
                    warnNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.PATH_SHOULD_BE_STR_BYTES_PATHLIKE_NOT_P, new Object[]{wFilename});
                }
                finally {
                    bufferLib.release(filenameBuffer, frame, indirectCallData);
                }
            } else {
                filename = asPath.execute((Frame)frame, wFilename);
            }
lbl15:
            // 3 sources

            if (!dontInherit) {
                fr = readCallerFrame.executeWith(frame, 0);
                code = factory.createCode(fr.getTarget());
                flags |= code.getFlags() & CompileNode.PyCF_MASK;
            }
            if (AstModuleBuiltins.isAst(this.getContext(), wSource)) {
                mod = AstModuleBuiltins.obj2sst(this.getContext(), wSource, this.getParserInputType(mode, flags));
                source = PythonUtils.createFakeSource(filename);
                rootCallTarget = this.getLanguage().compileForBytecodeInterpreter(this.getContext(), mod, source, false, optimize, null, null, flags);
                return CompileNode.wrapRootCallTarget(rootCallTarget, factory);
            }
            source = this.sourceAsString(frame, inliningTarget, wSource, filename, interopLib, acquireLib, bufferLib, handleDecodingErrorNode, asStrNode, switchEncodingNode, factory, raiseNode, indirectCallData);
            this.checkSource(source);
            return this.compile(source, filename, mode, flags, dontInherit, optimize, featureVersion, factory);
        }

        private static PCode wrapRootCallTarget(RootCallTarget rootCallTarget, PythonObjectFactory factory) {
            RootNode rootNode = rootCallTarget.getRootNode();
            if (rootNode instanceof PBytecodeRootNode) {
                ((PBytecodeRootNode)rootNode).triggerDeferredDeprecationWarnings();
            }
            return factory.createCode(rootCallTarget);
        }

        @CompilerDirectives.TruffleBoundary
        private void checkSource(TruffleString source) throws PException {
            if (source.indexOfCodePointUncached(0, 0, source.codePointLengthUncached(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) > -1) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.ValueError, ErrorMessages.SRC_CODE_CANNOT_CONTAIN_NULL_BYTES);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void checkOptimize(int optimize, Object kwOptimize) throws PException {
            if (optimize < -1 || optimize > 2) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.TypeError, ErrorMessages.INVALID_OPTIMIZE_VALUE, kwOptimize);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void checkFlags(int flags) {
            if ((flags & ~(PyCF_MASK | 0x10 | 0x7600)) != 0) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.ValueError, null, PNone.NO_VALUE, ErrorMessages.UNRECOGNIZED_FLAGS, PythonUtils.EMPTY_OBJECT_ARRAY);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private InputType getParserInputType(TruffleString mode, int flags) {
            if (mode.equalsUncached((AbstractTruffleString)BuiltinNames.T_EXEC, PythonUtils.TS_ENCODING)) {
                return InputType.FILE;
            }
            if (mode.equalsUncached((AbstractTruffleString)BuiltinNames.T_EVAL, PythonUtils.TS_ENCODING)) {
                return InputType.EVAL;
            }
            if (mode.equalsUncached((AbstractTruffleString)StringLiterals.T_SINGLE, PythonUtils.TS_ENCODING)) {
                return InputType.SINGLE;
            }
            if (mode.equalsUncached((AbstractTruffleString)StringLiterals.T_FUNC_TYPE, PythonUtils.TS_ENCODING)) {
                return InputType.FUNCTION_TYPE;
            }
            if ((flags & 0x400) != 0) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.ValueError, ErrorMessages.COMPILE_MODE_MUST_BE_AST_ONLY);
            }
            throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.ValueError, ErrorMessages.COMPILE_MODE_MUST_BE);
        }

        TruffleString sourceAsString(VirtualFrame frame, Node inliningTarget, Object source, TruffleString filename, InteropLibrary interopLib, PythonBufferAcquireLibrary acquireLib, PythonBufferAccessLibrary bufferLib, CodecsModuleBuiltins.HandleDecodingErrorNode handleDecodingErrorNode, PyObjectStrAsTruffleStringNode asStrNode, TruffleString.SwitchEncodingNode switchEncodingNode, PythonObjectFactory factory, PRaiseNode.Lazy raiseNode, IndirectCallData indirectCallData) {
            Object buffer;
            if (interopLib.isString(source)) {
                try {
                    return switchEncodingNode.execute((AbstractTruffleString)interopLib.asTruffleString(source), PythonUtils.TS_ENCODING);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            try {
                buffer = acquireLib.acquireReadonly(source, frame, indirectCallData);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ARG_D_MUST_BE_S, "compile()", 1, "string, bytes or AST object");
            }
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(source);
                int bytesLen = bufferLib.getBufferLength(source);
                Charset charset = PythonFileDetector.findEncodingStrict(bytes, bytesLen);
                TruffleString pythonEncodingNameFromJavaName = CharsetMapping.getPythonEncodingNameFromJavaName(charset.name());
                CodecsModuleBuiltins.TruffleDecoder decoder = new CodecsModuleBuiltins.TruffleDecoder(pythonEncodingNameFromJavaName, charset, bytes, bytesLen, CodingErrorAction.REPORT);
                if (!decoder.decodingStep(true)) {
                    try {
                        handleDecodingErrorNode.execute(decoder, StringLiterals.T_STRICT, factory.createBytes(bytes, bytesLen));
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                    catch (PException e) {
                        throw this.raiseInvalidSyntax(filename, "(unicode error) %s", asStrNode.execute((Frame)frame, inliningTarget, e.getEscapedException()));
                    }
                }
                TruffleString truffleString = decoder.getString();
                return truffleString;
            }
            catch (PythonFileDetector.InvalidEncodingException e) {
                throw this.raiseInvalidSyntax(filename, "(unicode error) %s", e.getEncodingName());
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private RuntimeException raiseInvalidSyntax(TruffleString filename, String format, Object ... args) {
            PythonContext context = this.getContext();
            Source source = PythonLanguage.newSource(context, StringLiterals.T_SPACE, filename, this.mayBeFromFile, null);
            SourceRange sourceRange = new SourceRange(1, 0, 1, 0);
            TruffleString message = PythonUtils.toTruffleStringUncached(String.format(format, args));
            throw RaisePythonExceptionErrorCallback.raiseSyntaxError(ErrorCallback.ErrorType.Syntax, sourceRange, message, source, PythonOptions.isPExceptionWithJavaStacktrace(context.getLanguage()));
        }

        public static CompileNode create(boolean mapFilenameToUri) {
            return BuiltinFunctionsFactory.CompileNodeFactory.create(mapFilenameToUri, false, new ReadArgumentNode[0]);
        }

        public static CompileNode create(boolean mapFilenameToUri, boolean lstrip) {
            return BuiltinFunctionsFactory.CompileNodeFactory.create(mapFilenameToUri, lstrip, new ReadArgumentNode[0]);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.CompileNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="exec", minNumOfPositionalArgs=1, parameterNames={"source", "globals", "locals"})
    @GenerateNodeFactory
    static abstract class ExecNode
    extends EvalNode {
        ExecNode() {
        }

        protected abstract Object executeInternal(VirtualFrame var1);

        @Override
        protected TruffleString getMode() {
            return BuiltinNames.T_EXEC;
        }

        @Override
        public final Object execute(VirtualFrame frame) {
            this.executeInternal(frame);
            return PNone.NONE;
        }

        @Override
        protected boolean shouldStripLeadingWhitespace() {
            return false;
        }
    }

    @Builtin(name="eval", minNumOfPositionalArgs=1, parameterNames={"expression", "globals", "locals"})
    @GenerateNodeFactory
    public static abstract class EvalNode
    extends PythonBuiltinNode {
        @Node.Child
        protected CompileNode compileNode;
        @Node.Child
        private GenericInvokeNode invokeNode = GenericInvokeNode.create();
        @Node.Child
        private GetOrCreateDictNode getOrCreateDictNode;

        final void assertNoFreeVars(Node inliningTarget, PCode code, PRaiseNode.Lazy raiseNode) {
            TruffleString[] freeVars = code.getFreeVars();
            if (freeVars.length > 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CODE_OBJ_NO_FREE_VARIABLES, this.getMode());
            }
        }

        protected TruffleString getMode() {
            return BuiltinNames.T_EVAL;
        }

        static boolean isMapping(Node inliningTarget, PyMappingCheckNode mappingCheckNode, Object object) {
            return mappingCheckNode.execute(inliningTarget, object);
        }

        static boolean isAnyNone(Object object) {
            return object instanceof PNone;
        }

        final PCode createAndCheckCode(VirtualFrame frame, Node inliningTarget, Object source, PRaiseNode.Lazy raiseNode) {
            PCode code = this.getCompileNode().compile(frame, source, StringLiterals.T_STRING_SOURCE, this.getMode(), -1, -1);
            this.assertNoFreeVars(inliningTarget, code, raiseNode);
            return code;
        }

        private static void inheritGlobals(PFrame callerFrame, Object[] args) {
            PArguments.setGlobals(args, callerFrame.getGlobals());
        }

        private static void inheritLocals(Node inliningTarget, PFrame callerFrame, Object[] args, GetFrameLocalsNode getFrameLocalsNode) {
            Object callerLocals = getFrameLocalsNode.execute(inliningTarget, callerFrame);
            EvalNode.setCustomLocals(args, callerLocals);
        }

        private static void setCustomLocals(Object[] args, Object locals) {
            PArguments.setSpecialArgument(args, locals);
        }

        private void setBuiltinsInGlobals(VirtualFrame frame, Node inliningTarget, PDict globals, HashingCollectionNodes.SetItemNode setBuiltins, PythonModule builtins) {
            if (builtins == null) {
                return;
            }
            PDict builtinsDict = this.getOrCreateDictNode(builtins);
            setBuiltins.execute((Frame)frame, inliningTarget, globals, BuiltinNames.T___BUILTINS__, builtinsDict);
        }

        private void setCustomGlobals(VirtualFrame frame, Node inliningTarget, PDict globals, HashingCollectionNodes.SetItemNode setBuiltins, Object[] args) {
            PythonModule builtins = this.getContext().getBuiltins();
            this.setBuiltinsInGlobals(frame, inliningTarget, globals, setBuiltins, builtins);
            PArguments.setGlobals(args, globals);
        }

        @Specialization
        Object execInheritGlobalsInheritLocals(VirtualFrame frame, Object source, PNone globals, PNone locals, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached ReadCallerFrameNode readCallerFrameNode, @Cached.Exclusive @Cached CodeNodes.GetCodeCallTargetNode getCt, @Cached GetFrameLocalsNode getFrameLocalsNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            PCode code = this.createAndCheckCode(frame, inliningTarget, source, raiseNode);
            PFrame callerFrame = readCallerFrameNode.executeWith(frame, 0);
            Object[] args = PArguments.create();
            EvalNode.inheritGlobals(callerFrame, args);
            EvalNode.inheritLocals(inliningTarget, callerFrame, args, getFrameLocalsNode);
            return this.invokeNode.execute(frame, getCt.execute(inliningTarget, code), args);
        }

        @Specialization
        Object execCustomGlobalsGlobalLocals(VirtualFrame frame, Object source, PDict globals, PNone locals, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.SetItemNode setBuiltins, @Cached.Shared(value="getCt") @Cached CodeNodes.GetCodeCallTargetNode getCt, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PCode code = this.createAndCheckCode(frame, inliningTarget, source, raiseNode);
            Object[] args = PArguments.create();
            this.setCustomGlobals(frame, inliningTarget, globals, setBuiltins, args);
            EvalNode.setCustomLocals(args, globals);
            RootCallTarget rootCallTarget = getCt.execute(inliningTarget, code);
            if (rootCallTarget == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_CREATE_CALL_TARGET, code);
            }
            return this.invokeNode.execute(frame, rootCallTarget, args);
        }

        @Specialization(guards={"isMapping(inliningTarget, mappingCheckNode, locals)"})
        Object execInheritGlobalsCustomLocals(VirtualFrame frame, Object source, PNone globals, Object locals, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyMappingCheckNode mappingCheckNode, @Cached.Exclusive @Cached ReadCallerFrameNode readCallerFrameNode, @Cached.Shared(value="getCt") @Cached CodeNodes.GetCodeCallTargetNode getCt, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PCode code = this.createAndCheckCode(frame, inliningTarget, source, raiseNode);
            PFrame callerFrame = readCallerFrameNode.executeWith(frame, 0);
            Object[] args = PArguments.create();
            EvalNode.inheritGlobals(callerFrame, args);
            EvalNode.setCustomLocals(args, locals);
            return this.invokeNode.execute(frame, getCt.execute(inliningTarget, code), args);
        }

        @Specialization(guards={"isMapping(inliningTarget, mappingCheckNode, locals)"})
        Object execCustomGlobalsCustomLocals(VirtualFrame frame, Object source, PDict globals, Object locals, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyMappingCheckNode mappingCheckNode, @Cached.Shared @Cached HashingCollectionNodes.SetItemNode setBuiltins, @Cached.Shared(value="getCt") @Cached CodeNodes.GetCodeCallTargetNode getCt, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PCode code = this.createAndCheckCode(frame, inliningTarget, source, raiseNode);
            Object[] args = PArguments.create();
            this.setCustomGlobals(frame, inliningTarget, globals, setBuiltins, args);
            EvalNode.setCustomLocals(args, locals);
            return this.invokeNode.execute(frame, getCt.execute(inliningTarget, code), args);
        }

        @Specialization(guards={"!isAnyNone(globals)", "!isDict(globals)"})
        PNone badGlobals(Object source, Object globals, Object locals, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.GLOBALS_MUST_BE_DICT, this.getMode(), globals);
        }

        @Specialization(guards={"isAnyNone(globals) || isDict(globals)", "!isAnyNone(locals)", "!isMapping(inliningTarget, mappingCheckNode, locals)"})
        PNone badLocals(Object source, PDict globals, Object locals, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyMappingCheckNode mappingCheckNode, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.LOCALS_MUST_BE_MAPPING, this.getMode(), locals);
        }

        private CompileNode getCompileNode() {
            if (this.compileNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compileNode = (CompileNode)this.insert(CompileNode.create(false, this.shouldStripLeadingWhitespace()));
            }
            return this.compileNode;
        }

        private PDict getOrCreateDictNode(PythonObject object) {
            if (this.getOrCreateDictNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getOrCreateDictNode = (GetOrCreateDictNode)this.insert(GetOrCreateDictNode.create());
            }
            return this.getOrCreateDictNode.executeCached(object);
        }

        protected boolean shouldStripLeadingWhitespace() {
            return true;
        }
    }

    @Builtin(name="divmod", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class DivModNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"b != 0"})
        static PTuple doLong(long a, long b, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{Math.floorDiv(a, b), Math.floorMod(a, b)});
        }

        @Specialization(replaces={"doLong"})
        static PTuple doLongZero(long a, long b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (b == 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZeroDivisionError, ErrorMessages.INTEGER_DIVISION_BY_ZERO);
            }
            return factory.createTuple(new Object[]{Math.floorDiv(a, b), Math.floorMod(a, b)});
        }

        @Specialization
        static PTuple doDouble(double a, double b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (b == 0.0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            double q = Math.floor(a / b);
            return factory.createTuple(new Object[]{q, FloatBuiltins.ModNode.mod(a, b)});
        }

        @Specialization
        static Object doObject(VirtualFrame frame, Object a, Object b, @Cached(value="DivMod.create()") BinaryOpNode callDivmod) {
            return callDivmod.executeObject(frame, a, b);
        }
    }

    @Builtin(name="dir", minNumOfPositionalArgs=0, maxNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1)
    @GenerateNodeFactory
    public static abstract class DirNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(object)"})
        Object locals(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached PyEvalGetLocals getLocals, @Cached(value="create(T_KEYS)") LookupAndCallUnaryNode callKeysNode, @Cached ListBuiltins.ListSortNode sortNode, @Cached ListNodes.ConstructListNode constructListNode) {
            Object localsDict = getLocals.execute(frame, inliningTarget);
            Object keysObj = callKeysNode.executeObject(frame, localsDict);
            PList list = constructListNode.execute((Frame)frame, keysObj);
            sortNode.execute(frame, list);
            return list;
        }

        @Specialization(guards={"!isNoValue(object)"})
        static Object dir(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectDir dir) {
            return dir.execute(frame, inliningTarget, object);
        }
    }

    @Builtin(name="hash", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        long hash(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode) {
            return hashNode.execute((Frame)frame, inliningTarget, object);
        }
    }

    @Builtin(name="chr", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"i"})
    @GenerateNodeFactory
    @ArgumentClinic(name="i", conversion=ArgumentClinic.ClinicConversion.Int)
    public static abstract class ChrNode
    extends PythonUnaryClinicBuiltinNode {
        @Specialization
        static TruffleString charFromInt(int arg, @Bind(value="this") Node inliningTarget, @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (arg >= 0 && arg <= 0x10FFFF) {
                return fromCodePointNode.execute(arg, PythonUtils.TS_ENCODING, true);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARG_NOT_IN_RANGE, "chr()", "0x110000");
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BuiltinFunctionsClinicProviders.ChrNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="callable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CallableNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isCallable(callable)"})
        static boolean doCallable(Object callable) {
            return true;
        }

        @Specialization
        static boolean doGeneric(Object object, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck) {
            return callableCheck.execute(inliningTarget, object);
        }
    }

    @Builtin(name="hex", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class HexNode
    extends PythonUnaryBuiltinNode {
        static final TruffleString T_HEX_PREFIX = PythonUtils.tsLiteral("0x");

        @Specialization
        static TruffleString doIt(VirtualFrame frame, Object x, @Bind(value="this") Node inliningTarget, @Cached BinOctHexHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, x, T_HEX_PREFIX, 16, HexNode::longToString);
        }

        @CompilerDirectives.TruffleBoundary
        private static String longToString(long x) {
            return Long.toHexString(x);
        }
    }

    @Builtin(name="oct", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class OctNode
    extends PythonUnaryBuiltinNode {
        static final TruffleString T_OCT_PREFIX = PythonUtils.tsLiteral("0o");

        @Specialization
        static TruffleString doIt(VirtualFrame frame, Object x, @Bind(value="this") Node inliningTarget, @Cached BinOctHexHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, x, T_OCT_PREFIX, 8, OctNode::longToString);
        }

        @CompilerDirectives.TruffleBoundary
        private static String longToString(long x) {
            return Long.toOctalString(x);
        }
    }

    @Builtin(name="bin", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class BinNode
    extends PythonUnaryBuiltinNode {
        static final TruffleString T_BIN_PREFIX = PythonUtils.tsLiteral("0b");

        @Specialization
        static TruffleString doIt(VirtualFrame frame, Object x, @Bind(value="this") Node inliningTarget, @Cached BinOctHexHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, x, T_BIN_PREFIX, 2, BinNode::longToString);
        }

        @CompilerDirectives.TruffleBoundary
        private static String longToString(long x) {
            return Long.toBinaryString(x);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class BinOctHexHelperNode
    extends Node {
        BinOctHexHelperNode() {
        }

        abstract TruffleString execute(VirtualFrame var1, Node var2, Object var3, TruffleString var4, int var5, LongToString var6);

        @CompilerDirectives.TruffleBoundary
        private static TruffleString buildString(boolean isNegative, TruffleString prefix, TruffleString number) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(PythonUtils.tsbCapacity(3) + number.byteLength(PythonUtils.TS_ENCODING)));
            if (isNegative) {
                sb.appendStringUncached(StringLiterals.T_MINUS);
            }
            sb.appendStringUncached(prefix);
            sb.appendStringUncached(number);
            return sb.toStringUncached();
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger longMaxPlusOne() {
            return BigInteger.valueOf(Long.MIN_VALUE).abs();
        }

        @CompilerDirectives.TruffleBoundary
        private static String bigToString(int radix, BigInteger x) {
            return x.toString(radix);
        }

        @Specialization
        static TruffleString doL(Node inliningTarget, long x, TruffleString prefix, int radix, LongToString longToString, @Cached.Exclusive @Cached InlinedConditionProfile isMinLong, @Cached.Shared @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (isMinLong.profile(inliningTarget, x == Long.MIN_VALUE)) {
                return BinOctHexHelperNode.buildString(true, prefix, fromJavaStringNode.execute(BinOctHexHelperNode.bigToString(radix, BinOctHexHelperNode.longMaxPlusOne()), PythonUtils.TS_ENCODING));
            }
            return BinOctHexHelperNode.buildString(x < 0L, prefix, fromJavaStringNode.execute(longToString.convert(Math.abs(x)), PythonUtils.TS_ENCODING));
        }

        @Specialization
        static TruffleString doD(double x, TruffleString prefix, int radix, LongToString longToString, @Cached(inline=false) PRaiseNode raise) {
            throw raise.raiseIntegerInterpretationError(x);
        }

        @Specialization
        static TruffleString doPI(PInt x, TruffleString prefix, int radix, LongToString longToString, @Cached.Shared @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            BigInteger value = x.getValue();
            return BinOctHexHelperNode.buildString(value.signum() < 0, prefix, fromJavaStringNode.execute(BinOctHexHelperNode.bigToString(radix, PInt.abs(value)), PythonUtils.TS_ENCODING));
        }

        @Specialization(replaces={"doL", "doD", "doPI"})
        static TruffleString doO(VirtualFrame frame, Node inliningTarget, Object x, TruffleString prefix, int radix, LongToString longToString, @Cached.Exclusive @Cached InlinedConditionProfile isMinLong, @Cached PyNumberIndexNode indexNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedBranchProfile isInt, @Cached InlinedBranchProfile isLong, @Cached InlinedBranchProfile isPInt, @Cached.Shared @Cached(inline=false) TruffleString.FromJavaStringNode fromJavaStringNode) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, x);
            if (index instanceof Boolean || index instanceof Integer) {
                isInt.enter(inliningTarget);
                return BinOctHexHelperNode.doL(inliningTarget, asSizeNode.executeExact((Frame)frame, inliningTarget, index), prefix, radix, longToString, isMinLong, fromJavaStringNode);
            }
            if (index instanceof Long) {
                isLong.enter(inliningTarget);
                return BinOctHexHelperNode.doL(inliningTarget, (Long)index, prefix, radix, longToString, isMinLong, fromJavaStringNode);
            }
            if (index instanceof PInt) {
                isPInt.enter(inliningTarget);
                return BinOctHexHelperNode.doPI((PInt)index, prefix, radix, longToString, fromJavaStringNode);
            }
            CompilerDirectives.transferToInterpreter();
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("bin/oct/hex with native integer subclasses"));
        }

        @FunctionalInterface
        static interface LongToString {
            public String convert(long var1);
        }
    }

    @Builtin(name="any", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AnyNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static boolean doList(VirtualFrame frame, PList object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ANY);
        }

        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static boolean doTuple(VirtualFrame frame, PTuple object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ANY);
        }

        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static boolean doHashColl(VirtualFrame frame, PHashingCollection object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached AllOrAnyHashingStorageNode allOrAnyNode) {
            return allOrAnyNode.execute((Frame)frame, object.getDictStorage(), AnyOrAllNodeType.ANY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean doObject(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PyObjectIsTrueNode isTrueNode) {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, object);
            int nbrIter = 0;
            while (true) {
                try {
                    Object next = nextNode.execute((Frame)frame, iterator);
                    ++nbrIter;
                    if (!isTrueNode.execute((Frame)frame, inliningTarget, next)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                }
                finally {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)nbrIter);
                    continue;
                }
                break;
            }
            return false;
        }
    }

    @Builtin(name="all", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AllNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static boolean doList(VirtualFrame frame, PList object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ALL);
        }

        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static boolean doTuple(VirtualFrame frame, PTuple object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="allOrAnySeqNode") @Cached AllOrAnySequenceStorageNode allOrAnyNode) {
            return allOrAnyNode.execute(frame, inliningTarget, object.getSequenceStorage(), AnyOrAllNodeType.ALL);
        }

        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static boolean doHashColl(VirtualFrame frame, PHashingCollection object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached AllOrAnyHashingStorageNode allOrAnyNode) {
            return allOrAnyNode.execute((Frame)frame, object.getDictStorage(), AnyOrAllNodeType.ALL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean doObject(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PyObjectIsTrueNode isTrueNode) {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, object);
            int nbrIter = 0;
            while (true) {
                try {
                    Object next = nextNode.execute((Frame)frame, iterator);
                    ++nbrIter;
                    if (isTrueNode.execute((Frame)frame, inliningTarget, next)) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                }
                finally {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)nbrIter);
                    continue;
                }
                break;
            }
            return true;
        }
    }

    @GenerateInline(value=false)
    static abstract class AllOrAnyHashingStorageNode
    extends PNodeWithContext {
        AllOrAnyHashingStorageNode() {
        }

        abstract boolean execute(Frame var1, HashingStorage var2, AnyOrAllNodeType var3);

        @Specialization
        protected boolean doHashStorage(VirtualFrame frame, HashingStorage hashingStorage, AnyOrAllNodeType nodeType, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode, @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext getIterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey getIterKey) {
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, hashingStorage);
            while (loopConditionProfile.profile(inliningTarget, getIterNext.execute(inliningTarget, hashingStorage, it))) {
                Object key = getIterKey.execute(inliningTarget, hashingStorage, it);
                if (nodeType == AnyOrAllNodeType.ALL) {
                    if (isTrueNode.execute((Frame)frame, inliningTarget, key)) continue;
                    return false;
                }
                if (nodeType != AnyOrAllNodeType.ANY || !isTrueNode.execute((Frame)frame, inliningTarget, key)) continue;
                return true;
            }
            return nodeType == AnyOrAllNodeType.ALL;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class AllOrAnySequenceStorageNode
    extends PNodeWithContext {
        AllOrAnySequenceStorageNode() {
        }

        abstract boolean execute(VirtualFrame var1, Node var2, SequenceStorage var3, AnyOrAllNodeType var4);

        @Specialization
        static boolean doBoolSequence(VirtualFrame frame, Node inliningTarget, BoolSequenceStorage sequenceStorage, AnyOrAllNodeType nodeType, @Cached.Shared @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached.Shared @Cached InlinedCountingConditionProfile earlyExitProfile, @Cached.Shared @Cached PyObjectIsTrueNode isTrueNode) {
            boolean[] internalArray = sequenceStorage.getInternalBoolArray();
            int seqLength = sequenceStorage.length();
            int i = 0;
            while (loopConditionProfile.profile(inliningTarget, i < seqLength)) {
                if (nodeType == AnyOrAllNodeType.ALL && earlyExitProfile.profile(inliningTarget, !isTrueNode.execute((Frame)frame, inliningTarget, internalArray[i]))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return false;
                }
                if (nodeType == AnyOrAllNodeType.ANY && earlyExitProfile.profile(inliningTarget, isTrueNode.execute((Frame)frame, inliningTarget, internalArray[i]))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return true;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)seqLength);
            return nodeType == AnyOrAllNodeType.ALL;
        }

        @Specialization
        static boolean doIntSequence(VirtualFrame frame, Node inliningTarget, IntSequenceStorage sequenceStorage, AnyOrAllNodeType nodeType, @Cached.Shared @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached.Shared @Cached InlinedCountingConditionProfile earlyExitProfile, @Cached.Shared @Cached PyObjectIsTrueNode isTrueNode) {
            int[] internalArray = sequenceStorage.getInternalIntArray();
            int seqLength = sequenceStorage.length();
            int i = 0;
            while (loopConditionProfile.profile(inliningTarget, i < seqLength)) {
                if (nodeType == AnyOrAllNodeType.ALL && earlyExitProfile.profile(inliningTarget, !isTrueNode.execute((Frame)frame, inliningTarget, internalArray[i]))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return false;
                }
                if (nodeType == AnyOrAllNodeType.ANY && earlyExitProfile.profile(inliningTarget, isTrueNode.execute((Frame)frame, inliningTarget, internalArray[i]))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return true;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)seqLength);
            return nodeType == AnyOrAllNodeType.ALL;
        }

        @Specialization
        static boolean doGenericSequence(VirtualFrame frame, Node inliningTarget, SequenceStorage sequenceStorage, AnyOrAllNodeType nodeType, @Cached.Shared @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached.Shared @Cached InlinedCountingConditionProfile earlyExitProfile, @Cached.Shared @Cached PyObjectIsTrueNode isTrueNode) {
            Object[] internalArray = sequenceStorage.getInternalArray();
            int seqLength = sequenceStorage.length();
            int i = 0;
            while (loopConditionProfile.profile(inliningTarget, i < seqLength)) {
                if (nodeType == AnyOrAllNodeType.ALL && earlyExitProfile.profile(inliningTarget, !isTrueNode.execute((Frame)frame, inliningTarget, internalArray[i]))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return false;
                }
                if (nodeType == AnyOrAllNodeType.ANY && earlyExitProfile.profile(inliningTarget, isTrueNode.execute((Frame)frame, inliningTarget, internalArray[i]))) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)i);
                    return true;
                }
                ++i;
            }
            LoopNode.reportLoopCount((Node)inliningTarget, (int)seqLength);
            return nodeType == AnyOrAllNodeType.ALL;
        }
    }

    static enum AnyOrAllNodeType {
        ALL,
        ANY;

    }

    @Builtin(name="abs", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AbsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static int absBoolean(boolean arg) {
            return arg ? 1 : 0;
        }

        @Specialization
        static double absDouble(double arg) {
            return Math.abs(arg);
        }

        @Specialization
        static Object absObject(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached(value="create(T___ABS__)") LookupAndCallUnaryNode callAbs, @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callAbs.executeObject(frame, object);
            if (result == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.BAD_OPERAND_FOR, "", "abs()", object);
            }
            return result;
        }
    }
}

