/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.GraalHPyUniversalModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.GraalHPyUniversalModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ImpModuleBuiltins;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyMode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.util.List;

@CoreFunctions(defineModule="_hpy_universal")
@GenerateNodeFactory
public final class GraalHPyUniversalModuleBuiltins
extends PythonBuiltins {
    public static final String J_HPY_UNIVERSAL = "_hpy_universal";

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GraalHPyUniversalModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        for (HPyMode mode : HPyMode.values()) {
            this.addBuiltinConstant(mode.name(), (Object)mode.getValue());
        }
        super.initialize(core);
    }

    @Builtin(name="_load_bootstrap", parameterNames={"name", "ext_name", "package", "file", "loader", "spec", "env"})
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="ext_name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="file", conversion=ArgumentClinic.ClinicConversion.TString)})
    static abstract class HPyUniversalLoadBootstrapNode
    extends PythonClinicBuiltinNode {
        HPyUniversalLoadBootstrapNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GraalHPyUniversalModuleBuiltinsClinicProviders.HPyUniversalLoadBootstrapNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, TruffleString name, TruffleString extName, Object pkg, TruffleString file, Object loader, Object spec, Object env, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached TruffleString.EqualNode eqNode, @Cached WriteAttributeToObjectNode writeAttrNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object module;
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                HPyMode hmode = HPyUniversalLoadBootstrapNode.getHPyModeFromEnviron(name, env);
                module = GraalHPyContext.loadHPyModule(inliningTarget, context, name, file, spec, hmode);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_MODE_VALUE_MUST_BE_STRING);
            }
            catch (LoadCExtException.ApiInitException ie) {
                throw ie.reraise(frame, inliningTarget, constructAndRaiseNode);
            }
            catch (LoadCExtException.ImportException ie) {
                throw ie.reraise(frame, inliningTarget, constructAndRaiseNode);
            }
            catch (IOException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e, eqNode);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
            writeAttrNode.execute(module, SpecialAttributeNames.T___FILE__, (Object)file);
            writeAttrNode.execute(module, SpecialAttributeNames.T___LOADER__, loader);
            writeAttrNode.execute(module, SpecialAttributeNames.T___NAME__, (Object)extName);
            writeAttrNode.execute(module, SpecialAttributeNames.T___PACKAGE__, pkg);
            writeAttrNode.execute(spec, ImpModuleBuiltins.T_ORIGIN, (Object)file);
            writeAttrNode.execute(module, SpecialAttributeNames.T___SPEC__, spec);
            return module;
        }

        @CompilerDirectives.TruffleBoundary
        private static HPyMode getHPyModeFromEnviron(TruffleString moduleName, Object env) throws CannotCastException {
            Object result;
            try {
                result = PyObjectGetItem.executeUncached(env, PythonUtils.tsLiteral("HPY"));
            }
            catch (PException e) {
                e.expect(null, PythonBuiltinClassType.KeyError, BuiltinClassProfiles.IsBuiltinObjectProfile.getUncached());
                return HPyMode.MODE_UNIVERSAL;
            }
            String s = CastToJavaStringNode.getUncached().execute(result);
            int colonIdx = s.indexOf(58);
            if (colonIdx != -1) {
                String[] moduleParts = s.split(",");
                String sModuleName = moduleName.toJavaStringUncached();
                for (String modulePars : moduleParts) {
                    String[] def = modulePars.split(":");
                    if (!sModuleName.equals(def[0])) continue;
                    return HPyMode.valueOf("MODE_" + def[1].toUpperCase());
                }
            } else {
                return HPyMode.valueOf("MODE_" + s.toUpperCase());
            }
            return HPyMode.MODE_UNIVERSAL;
        }
    }

    @Builtin(name="load", parameterNames={"name", "path", "spec", "debug", "mode"}, minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="path", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="debug", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1")})
    static abstract class HPyUniversalLoadNode
    extends PythonClinicBuiltinNode {
        HPyUniversalLoadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GraalHPyUniversalModuleBuiltinsClinicProviders.HPyUniversalLoadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, TruffleString name, TruffleString path, Object spec, boolean debug, int mode, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached TruffleString.EqualNode eqNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                HPyMode hmode;
                HPyMode hPyMode = hmode = debug ? HPyMode.MODE_DEBUG : HPyMode.MODE_UNIVERSAL;
                if (mode > 0) {
                    hmode = HPyMode.fromValue(mode);
                }
                Object object = GraalHPyContext.loadHPyModule(inliningTarget, context, name, path, spec, hmode);
                return object;
            }
            catch (LoadCExtException.ApiInitException ie) {
                throw ie.reraise(frame, inliningTarget, constructAndRaiseNode);
            }
            catch (LoadCExtException.ImportException ie) {
                throw ie.reraise(frame, inliningTarget, constructAndRaiseNode);
            }
            catch (IOException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e, eqNode);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }
    }
}

