/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.lib.PyComplexCheckExactNode;
import com.oracle.graal.python.lib.PyDictCheckExactNode;
import com.oracle.graal.python.lib.PyFloatCheckExactNode;
import com.oracle.graal.python.lib.PyFrozenSetCheckExactNode;
import com.oracle.graal.python.lib.PyListCheckExactNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PySetCheckExactNode;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@CoreFunctions(defineModule="marshal")
public final class MarshalModuleBuiltins
extends PythonBuiltins {
    static final int CURRENT_VERSION = 4;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MarshalModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(StringLiterals.T_VERSION, (Object)4);
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] serializeCodeUnit(CodeUnit code) {
        try {
            Marshal marshal = new Marshal(4, null, null);
            marshal.writeCodeUnit(code);
            return marshal.out.toByteArray();
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        catch (Marshal.MarshalError me) {
            throw PRaiseNode.getUncached().raise(me.type, me.message, me.arguments);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CodeUnit deserializeCodeUnit(byte[] bytes) {
        try {
            Marshal marshal = new Marshal(bytes, bytes.length);
            return marshal.readCodeUnit();
        }
        catch (Marshal.MarshalError me) {
            throw PRaiseNode.getUncached().raise(me.type, me.message, me.arguments);
        }
        catch (NumberFormatException e) {
            throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.ValueError, ErrorMessages.BAD_MARSHAL_DATA_S, e.getMessage());
        }
    }

    static final class Marshal {
        private static final char TYPE_NULL = '0';
        private static final char TYPE_NONE = 'N';
        private static final char TYPE_NOVALUE = 'n';
        private static final char TYPE_FALSE = 'F';
        private static final char TYPE_TRUE = 'T';
        private static final char TYPE_STOPITER = 'S';
        private static final char TYPE_ELLIPSIS = '.';
        private static final char TYPE_INT = 'i';
        private static final char TYPE_INT64 = 'I';
        private static final char TYPE_FLOAT = 'f';
        private static final char TYPE_BINARY_FLOAT = 'g';
        private static final char TYPE_COMPLEX = 'x';
        private static final char TYPE_BINARY_COMPLEX = 'y';
        private static final char TYPE_LONG = 'l';
        private static final char TYPE_STRING = 's';
        private static final char TYPE_INTERNED = 't';
        private static final char TYPE_REF = 'r';
        private static final char TYPE_TUPLE = '(';
        private static final char TYPE_LIST = '[';
        private static final char TYPE_DICT = '{';
        private static final char TYPE_UNICODE = 'u';
        private static final char TYPE_UNKNOWN = '?';
        private static final char TYPE_SET = '<';
        private static final char TYPE_FROZENSET = '>';
        private static final char FLAG_REF = '\u0080';
        private static final char TYPE_ASCII = 'a';
        private static final char TYPE_ASCII_INTERNED = 'A';
        private static final char TYPE_SMALL_TUPLE = ')';
        private static final char TYPE_SHORT_ASCII = 'z';
        private static final char TYPE_SHORT_ASCII_INTERNED = 'Z';
        private static final char TYPE_GRAALPYTHON_CODE = 'C';
        private static final char TYPE_GRAALPYTHON_CODE_UNIT = 'U';
        private static final char TYPE_BIG_INTEGER = 'B';
        private static final char TYPE_ARRAY = ']';
        private static final char ARRAY_TYPE_OBJECT = 'o';
        private static final char ARRAY_TYPE_INT = 'i';
        private static final char ARRAY_TYPE_LONG = 'l';
        private static final char ARRAY_TYPE_DOUBLE = 'd';
        private static final char ARRAY_TYPE_BYTE = 'b';
        private static final char ARRAY_TYPE_BOOLEAN = 'B';
        private static final char ARRAY_TYPE_SHORT = 's';
        private static final char ARRAY_TYPE_STRING = 'S';
        private static final int MAX_MARSHAL_STACK_DEPTH = 201;
        private static final int MARSHAL_SHIFT = 15;
        private static final BigInteger MARSHAL_BASE = BigInteger.valueOf(32768L);
        private static final int BYTES_PER_LONG = 8;
        private static final int BYTES_PER_INT = 4;
        private static final int BYTES_PER_SHORT = 2;
        private static final PythonObjectFactory factory = PythonObjectFactory.getUncached();
        final HashMap<Object, Integer> refMap;
        final ArrayList<Object> refList;
        final ByteArrayOutputStream out;
        final InputStream in;
        final int version;
        final PInt pyTrue;
        final PInt pyFalse;
        final ByteArraySupport baSupport = ByteArraySupport.littleEndian();
        byte[] buffer = new byte[8];
        int depth = 0;

        @CompilerDirectives.TruffleBoundary
        static byte[] dump(Object value, int version, Python3Core core) throws IOException, MarshalError {
            Marshal outMarshal = new Marshal(version, core.getTrue(), core.getFalse());
            outMarshal.writeObject(value);
            return outMarshal.out.toByteArray();
        }

        @CompilerDirectives.TruffleBoundary
        static Object load(byte[] ary, int length) throws NumberFormatException, MarshalError {
            Marshal inMarshal = new Marshal(ary, length);
            Object result = inMarshal.readObject();
            if (result == null) {
                throw new MarshalError(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_MARSHAL_DATA_NULL, new Object[0]);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        static Object loadFile(Object file) throws NumberFormatException, MarshalError {
            Marshal inMarshal = new Marshal(file);
            Object result = inMarshal.readObject();
            if (result == null) {
                throw new MarshalError(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_MARSHAL_DATA_NULL, new Object[0]);
            }
            return result;
        }

        Marshal(int version, PInt pyTrue, PInt pyFalse) {
            this.version = version;
            this.pyTrue = pyTrue;
            this.pyFalse = pyFalse;
            this.out = new ByteArrayOutputStream();
            this.refMap = new HashMap();
            this.in = null;
            this.refList = null;
        }

        Marshal(byte[] in, int length) {
            this.in = new ByteArrayInputStream(in, 0, length);
            this.refList = new ArrayList();
            this.version = -1;
            this.pyTrue = null;
            this.pyFalse = null;
            this.out = null;
            this.refMap = null;
        }

        Marshal(Object in) {
            this.in = new FileLikeInputStream(in);
            this.refList = new ArrayList();
            this.version = -1;
            this.pyTrue = null;
            this.pyFalse = null;
            this.out = null;
            this.refMap = null;
        }

        private void writeByte(int v) {
            this.out.write(v);
        }

        private int readByte() {
            int nextByte;
            try {
                nextByte = this.in.read();
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            if (nextByte < 0) {
                throw new MarshalError(PythonBuiltinClassType.EOFError, ErrorMessages.BAD_MARSHAL_DATA_EOF, new Object[0]);
            }
            return nextByte;
        }

        private void writeSize(int sz) {
            this.writeInt(sz);
        }

        private int readByteSize() {
            return Marshal.checkSize(this.readByte());
        }

        private int readSize() {
            return Marshal.checkSize(this.readInt());
        }

        private static int checkSize(int sz) {
            if (sz < 0) {
                throw new MarshalError(PythonBuiltinClassType.EOFError, ErrorMessages.BAD_MARSHAL_DATA_S, "size out of range");
            }
            return sz;
        }

        private void writeBytes(byte[] bytes) throws IOException {
            this.writeSize(bytes.length);
            this.out.write(bytes);
        }

        private byte[] readNBytes(int sz) {
            if (sz == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            if (this.buffer.length < sz) {
                this.buffer = new byte[sz];
            }
            return this.readNBytes(sz, this.buffer);
        }

        private byte[] readNBytes(int sz, byte[] output) {
            int read;
            if (sz == 0) {
                return output;
            }
            try {
                read = this.in.read(output, 0, sz);
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            if (read < sz) {
                throw new MarshalError(PythonBuiltinClassType.EOFError, ErrorMessages.BAD_MARSHAL_DATA_EOF, new Object[0]);
            }
            return output;
        }

        private byte[] readBytes() {
            int sz = this.readSize();
            return this.readNBytes(sz, new byte[sz]);
        }

        private void writeInt(int v) {
            for (int i = 0; i < 32; i += 8) {
                this.out.write(v >> i & 0xFF);
            }
        }

        private void writeShort(short v) {
            for (int i = 0; i < 16; i += 8) {
                this.out.write(v >> i & 0xFF);
            }
        }

        private int readInt() {
            return this.baSupport.getInt(this.readNBytes(4), 0);
        }

        private short readShort() {
            return this.baSupport.getShort(this.readNBytes(2), 0);
        }

        private void writeLong(long v) {
            for (int i = 0; i < 64; i += 8) {
                this.out.write((int)(v >>> i & 0xFFL));
            }
        }

        private long readLong() {
            return this.baSupport.getLong(this.readNBytes(8), 0);
        }

        private void writeBigInteger(BigInteger v) {
            ArrayList<Integer> digits = new ArrayList<Integer>();
            BigInteger quotient = v.abs();
            do {
                BigInteger[] divRem = quotient.divideAndRemainder(MARSHAL_BASE);
                quotient = divRem[0];
                digits.add(divRem[1].intValue());
            } while (quotient.signum() != 0);
            int sz = digits.size();
            if (v.signum() < 0) {
                this.writeSize(-sz);
            } else {
                this.writeSize(sz);
            }
            Iterator iterator = digits.iterator();
            while (iterator.hasNext()) {
                int digit = (Integer)iterator.next();
                for (int i = 0; i < 16; i += 8) {
                    this.out.write(digit >> i & 0xFF);
                }
            }
        }

        private BigInteger readBigInteger() {
            boolean negative;
            int sz = this.readInt();
            if (sz < 0) {
                negative = true;
                sz = -sz;
            } else {
                negative = false;
            }
            byte[] data = this.readNBytes(sz *= 2);
            int i = 0;
            short digit = this.baSupport.getShort(data, i);
            i += 2;
            BigInteger result = BigInteger.valueOf(digit);
            while (i < sz) {
                int power = i / 2;
                digit = this.baSupport.getShort(data, i);
                i += 2;
                result = result.add(BigInteger.valueOf(digit).multiply(MARSHAL_BASE.pow(power)));
            }
            if (negative) {
                return result.negate();
            }
            return result;
        }

        private void writeDouble(double v) {
            this.writeLong(Double.doubleToLongBits(v));
        }

        private double readDouble() {
            return Double.longBitsToDouble(this.readLong());
        }

        private void writeDoubleString(double v) throws IOException {
            this.writeShortString(Double.toString(v));
        }

        private double readDoubleString() throws NumberFormatException {
            return Double.parseDouble(this.readShortString().toJavaStringUncached());
        }

        private void writeReferenceOrComplexObject(Object v) {
            Integer reference = null;
            if (this.version < 3 || (reference = this.refMap.get(v)) == null) {
                int flag = 0;
                if (this.version >= 3) {
                    flag = 128;
                    this.refMap.put(v, this.refMap.size());
                }
                this.writeComplexObject(v, flag);
            } else if (reference != null) {
                this.writeByte(114);
                this.writeInt(reference);
            }
        }

        private Object readReference() {
            int n = this.readInt();
            if (n < 0 || n >= this.refList.size()) {
                throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.BAD_MARSHAL_DATA, new Object[0]);
            }
            Object o = this.refList.get(n);
            assert (o != null);
            return o;
        }

        private void writeObject(Object v) throws IOException {
            ++this.depth;
            if (this.depth >= 201) {
                throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.MAX_MARSHAL_STACK_DEPTH, new Object[0]);
            }
            if (v == null) {
                this.writeNull();
            } else if (v == PNone.NONE) {
                this.writeByte(78);
            } else if (v == PNone.NO_VALUE) {
                this.writeByte(110);
            } else if (TypeNodes.IsSameTypeNode.executeUncached(v, (Object)PythonBuiltinClassType.StopIteration)) {
                this.writeByte(83);
            } else if (TypeNodes.IsSameTypeNode.executeUncached(v, (Object)PythonBuiltinClassType.PEllipsis)) {
                this.writeByte(46);
            } else if (v == Boolean.TRUE || v == this.pyTrue) {
                this.writeByte(84);
            } else if (v == Boolean.FALSE || v == this.pyFalse) {
                this.writeByte(70);
            } else if (v instanceof Integer) {
                this.writeByte(105);
                this.writeInt((Integer)v);
            } else if (v instanceof Long) {
                this.writeByte(73);
                this.writeLong((Long)v);
            } else if (v instanceof Double) {
                if (this.version > 1) {
                    this.writeByte(103);
                    this.writeDouble((Double)v);
                } else {
                    this.writeByte(102);
                    this.writeDoubleString((Double)v);
                }
            } else if (v instanceof BigInteger) {
                this.writeByte(66);
                this.writeBigInteger((BigInteger)v);
            } else {
                this.writeReferenceOrComplexObject(v);
            }
            --this.depth;
        }

        private void writeNull() {
            this.writeByte(48);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeComplexObject(Object v, int flag) {
            block43: {
                try {
                    if (PyLongCheckExactNode.executeUncached(v)) {
                        BigInteger bigInt = ((PInt)v).getValue();
                        if (bigInt.signum() == 0) {
                            this.writeByte(0x69 | flag);
                            this.writeInt(0);
                        } else {
                            this.writeByte(0x6C | flag);
                            this.writeBigInteger(((PInt)v).getValue());
                        }
                        break block43;
                    }
                    if (PyFloatCheckExactNode.executeUncached(v)) {
                        if (this.version > 1) {
                            this.writeByte(0x67 | flag);
                            this.writeDouble(((PFloat)v).getValue());
                        } else {
                            this.writeByte(0x66 | flag);
                            this.writeDoubleString(((PFloat)v).getValue());
                        }
                        break block43;
                    }
                    if (PyComplexCheckExactNode.executeUncached(v)) {
                        if (this.version > 1) {
                            this.writeByte(0x79 | flag);
                            this.writeDouble(((PComplex)v).getReal());
                            this.writeDouble(((PComplex)v).getImag());
                        } else {
                            this.writeByte(0x78 | flag);
                            this.writeDoubleString(((PComplex)v).getReal());
                            this.writeDoubleString(((PComplex)v).getImag());
                        }
                        break block43;
                    }
                    if (TruffleStringMigrationHelpers.isJavaString(v)) {
                        this.writeByte(0x75 | flag);
                        this.writeString(TruffleString.fromJavaStringUncached((String)((String)v), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
                        break block43;
                    }
                    if (v instanceof TruffleString) {
                        this.writeByte(0x75 | flag);
                        this.writeString((TruffleString)v);
                        break block43;
                    }
                    if (PyUnicodeCheckExactNode.executeUncached(v)) {
                        if (this.version >= 3 && StringNodes.IsInternedStringNode.executeUncached((PString)v)) {
                            this.writeByte(0x74 | flag);
                        } else {
                            this.writeByte(0x75 | flag);
                        }
                        this.writeString(((PString)v).getValueUncached());
                        break block43;
                    }
                    if (PyTupleCheckExactNode.executeUncached(v)) {
                        Object[] items = SequenceNodes.GetObjectArrayNode.executeUncached(v);
                        if (this.version >= 4 && items.length < 256) {
                            this.writeByte(0x29 | flag);
                            this.writeByte(items.length);
                        } else {
                            this.writeByte(0x28 | flag);
                            this.writeSize(items.length);
                        }
                        for (Object item : items) {
                            this.writeObject(item);
                        }
                        break block43;
                    }
                    if (PyListCheckExactNode.executeUncached(v)) {
                        this.writeByte(0x5B | flag);
                        Object[] items = SequenceStorageNodes.GetInternalObjectArrayNode.executeUncached(SequenceNodes.GetSequenceStorageNode.executeUncached(v));
                        this.writeSize(items.length);
                        for (Object item : items) {
                            this.writeObject(item);
                        }
                        break block43;
                    }
                    if (v instanceof PDict && PyDictCheckExactNode.executeUncached(v)) {
                        HashingStorage dictStorage = ((PDict)v).getDictStorage();
                        this.writeByte(0x7B | flag);
                        HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(dictStorage);
                        while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(dictStorage, it)) {
                            this.writeObject(HashingStorageNodes.HashingStorageIteratorKey.executeUncached(dictStorage, it));
                            this.writeObject(HashingStorageNodes.HashingStorageIteratorValue.executeUncached(dictStorage, it));
                        }
                        this.writeNull();
                        break block43;
                    }
                    if (v instanceof PBaseSet && (PySetCheckExactNode.executeUncached(v) || PyFrozenSetCheckExactNode.executeUncached(v))) {
                        if (PyFrozenSetCheckExactNode.executeUncached(v)) {
                            this.writeByte(0x3E | flag);
                        } else {
                            this.writeByte(0x3C | flag);
                        }
                        HashingStorage dictStorage = ((PBaseSet)v).getDictStorage();
                        int len = HashingStorageNodes.HashingStorageLen.executeUncached(dictStorage);
                        this.writeSize(len);
                        HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(dictStorage);
                        while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(dictStorage, it)) {
                            this.writeObject(HashingStorageNodes.HashingStorageIteratorKey.executeUncached(dictStorage, it));
                        }
                        break block43;
                    }
                    if (v instanceof int[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(105);
                        this.writeIntArray((int[])v);
                        break block43;
                    }
                    if (v instanceof long[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(108);
                        this.writeLongArray((long[])v);
                        break block43;
                    }
                    if (v instanceof short[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(115);
                        this.writeShortArray((short[])v);
                        break block43;
                    }
                    if (v instanceof boolean[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(66);
                        this.writeBooleanArray((boolean[])v);
                        break block43;
                    }
                    if (v instanceof double[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(100);
                        this.writeDoubleArray((double[])v);
                        break block43;
                    }
                    if (v instanceof byte[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(98);
                        this.writeBytes((byte[])v);
                        break block43;
                    }
                    if (v instanceof TruffleString[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(83);
                        this.writeStringArray((TruffleString[])v);
                        break block43;
                    }
                    if (v instanceof Object[]) {
                        this.writeByte(0x5D | flag);
                        this.writeByte(111);
                        this.writeObjectArray((Object[])v);
                        break block43;
                    }
                    if (v instanceof PCode) {
                        PCode c = (PCode)v;
                        this.writeByte(0x43 | flag);
                        this.writeString(c.getFilename());
                        this.writeInt(c.getFlags());
                        this.writeBytes(c.getCodestring());
                        this.writeInt(c.getFirstLineNo());
                        byte[] lnotab = c.getLinetable();
                        if (lnotab == null) {
                            lnotab = PythonUtils.EMPTY_BYTE_ARRAY;
                        }
                        this.writeBytes(lnotab);
                        break block43;
                    }
                    if (v instanceof CodeUnit) {
                        this.writeByte(0x55 | flag);
                        this.writeCodeUnit((CodeUnit)v);
                        break block43;
                    }
                    PythonBufferAcquireLibrary acquireLib = (PythonBufferAcquireLibrary)PythonBufferAcquireLibrary.getFactory().getUncached(v);
                    if (acquireLib.hasBuffer(v)) {
                        this.writeByte(0x73 | flag);
                        Object buf = acquireLib.acquireReadonly(v);
                        PythonBufferAccessLibrary accessLib = (PythonBufferAccessLibrary)PythonBufferAccessLibrary.getFactory().getUncached(buf);
                        try {
                            int len = accessLib.getBufferLength(buf);
                            this.writeSize(len);
                            this.out.write(accessLib.getInternalOrCopiedByteArray(buf), 0, len);
                            break block43;
                        }
                        finally {
                            accessLib.release(buf);
                        }
                    }
                    this.writeByte(63);
                    throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.WAS_NOT_POSSIBLE_TO_MARSHAL_P, v);
                }
                catch (IOException e) {
                    throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.WAS_NOT_POSSIBLE_TO_MARSHAL_P, v);
                }
            }
        }

        private void writeObjectArray(Object[] a) throws IOException {
            this.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.writeObject(a[i]);
            }
        }

        private void writeDoubleArray(double[] a) {
            this.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.writeDouble(a[i]);
            }
        }

        private void writeLongArray(long[] a) {
            this.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.writeLong(a[i]);
            }
        }

        private void writeIntArray(int[] a) {
            this.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.writeInt(a[i]);
            }
        }

        private void writeStringArray(TruffleString[] a) {
            this.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.writeString(a[i]);
            }
        }

        private void writeShortArray(short[] a) {
            this.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.writeShort(a[i]);
            }
        }

        private void writeBooleanArray(boolean[] a) {
            this.writeInt(a.length);
            for (int i = 0; i < a.length; ++i) {
                this.writeByte(a[i] ? 1 : 0);
            }
        }

        private Object readObject() throws NumberFormatException {
            CompilerAsserts.neverPartOfCompilation();
            ++this.depth;
            if (this.depth >= 201) {
                throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.MAX_MARSHAL_STACK_DEPTH, new Object[0]);
            }
            int code = this.readByte();
            int flag = code & 0x80;
            int type = code & 0xFFFFFF7F;
            if (type == 114) {
                --this.depth;
                return this.readReference();
            }
            int reference = this.refList.size();
            if (flag != 0) {
                this.refList.add(null);
            }
            Object retval = this.readObject(type, o -> {
                if (flag != 0) {
                    this.refList.set(reference, o);
                }
                return o;
            });
            --this.depth;
            return retval;
        }

        private Object readObject(int type, AddRefAndReturn addRef) throws NumberFormatException {
            CompilerAsserts.neverPartOfCompilation();
            switch (type) {
                case 48: {
                    return null;
                }
                case 78: {
                    return PNone.NONE;
                }
                case 110: {
                    return PNone.NO_VALUE;
                }
                case 83: {
                    return PythonBuiltinClassType.StopIteration;
                }
                case 46: {
                    return PythonBuiltinClassType.PEllipsis;
                }
                case 70: {
                    return false;
                }
                case 84: {
                    return true;
                }
                case 105: {
                    return addRef.run(this.readInt());
                }
                case 73: {
                    return addRef.run(this.readLong());
                }
                case 66: {
                    return this.readBigInteger();
                }
                case 108: {
                    return addRef.run(factory.createInt(this.readBigInteger()));
                }
                case 102: {
                    return addRef.run(this.readDoubleString());
                }
                case 103: {
                    return addRef.run(this.readDouble());
                }
                case 120: {
                    return addRef.run(factory.createComplex(this.readDoubleString(), this.readDoubleString()));
                }
                case 121: {
                    return addRef.run(factory.createComplex(this.readDouble(), this.readDouble()));
                }
                case 115: {
                    return addRef.run(factory.createBytes(this.readBytes()));
                }
                case 65: {
                    return addRef.run(this.readAscii(this.readSize(), true));
                }
                case 97: {
                    return addRef.run(this.readAscii(this.readSize(), false));
                }
                case 90: {
                    return addRef.run(this.readAscii(this.readByteSize(), true));
                }
                case 122: {
                    return addRef.run(this.readAscii(this.readByteSize(), false));
                }
                case 116: {
                    return addRef.run(StringNodes.InternStringNode.executeUncached(this.readString()));
                }
                case 117: {
                    return addRef.run(this.readString());
                }
                case 41: {
                    int smallTupleSize = this.readByteSize();
                    Object[] smallTupleItems = new Object[smallTupleSize];
                    Object smallTuple = addRef.run(factory.createTuple(smallTupleItems));
                    this.readArray(smallTupleItems);
                    return smallTuple;
                }
                case 40: {
                    int tupleSize = this.readSize();
                    Object[] tupleItems = new Object[tupleSize];
                    Object tuple = addRef.run(factory.createTuple(tupleItems));
                    this.readArray(tupleItems);
                    return tuple;
                }
                case 91: {
                    int listSize = this.readSize();
                    Object[] listItems = new Object[listSize];
                    Object list = addRef.run(factory.createList(listItems));
                    this.readArray(listItems);
                    return list;
                }
                case 123: {
                    Object key;
                    HashingStorage store = PDict.createNewStorage(0);
                    PDict dict = factory.createDict(store);
                    addRef.run(dict);
                    while ((key = this.readObject()) != null) {
                        Object value = this.readObject();
                        if (value == null) continue;
                        store = HashingStorageNodes.HashingStorageSetItem.executeUncached(store, key, value);
                    }
                    dict.setDictStorage(store);
                    return dict;
                }
                case 60: 
                case 62: {
                    int setSz = this.readSize();
                    HashingStorage setStore = EconomicMapStorage.create(setSz);
                    PBaseSet set = type == 62 ? factory.createFrozenSet(setStore) : factory.createSet(setStore);
                    addRef.run(set);
                    for (int i = 0; i < setSz; ++i) {
                        Object key = this.readObject();
                        if (key == null) {
                            throw new MarshalError(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_MARSHAL_DATA_NULL, new Object[0]);
                        }
                        setStore = HashingStorageNodes.HashingStorageSetItem.executeUncached(setStore, key, PNone.NO_VALUE);
                    }
                    set.setDictStorage(setStore);
                    return set;
                }
                case 67: {
                    return addRef.run(this.readCode());
                }
                case 85: {
                    return addRef.run(this.readCodeUnit());
                }
                case 93: {
                    return addRef.run(this.readJavaArray());
                }
            }
            throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.BAD_MARSHAL_DATA, new Object[0]);
        }

        private void writeString(TruffleString v) {
            TruffleString.Encoding encoding;
            if (v.isValidUncached(PythonUtils.TS_ENCODING)) {
                encoding = TruffleString.Encoding.UTF_8;
            } else {
                encoding = TruffleString.Encoding.UTF_32LE;
                this.writeInt(-1);
            }
            InternalByteArray ba = v.switchEncodingUncached(encoding).getInternalByteArrayUncached(encoding);
            this.writeSize(ba.getLength());
            this.out.write(ba.getArray(), ba.getOffset(), ba.getLength());
        }

        private TruffleString readString() {
            TruffleString.Encoding encoding = TruffleString.Encoding.UTF_8;
            int sz = this.readInt();
            if (sz < 0) {
                encoding = TruffleString.Encoding.UTF_32LE;
                sz = this.readSize();
            }
            return TruffleString.fromByteArrayUncached((byte[])this.readNBytes(sz), (int)0, (int)sz, (TruffleString.Encoding)encoding, (boolean)true).switchEncodingUncached(PythonUtils.TS_ENCODING);
        }

        private void writeShortString(String v) throws IOException {
            byte[] bytes = v.getBytes(StandardCharsets.ISO_8859_1);
            assert (bytes.length < 256);
            this.writeByte(bytes.length);
            this.out.write(bytes);
        }

        private TruffleString readShortString() {
            int sz = this.readByteSize();
            byte[] bytes = this.readNBytes(sz);
            return TruffleString.fromByteArrayUncached((byte[])bytes, (int)0, (int)sz, (TruffleString.Encoding)TruffleString.Encoding.ISO_8859_1, (boolean)true).switchEncodingUncached(PythonUtils.TS_ENCODING);
        }

        private Object readAscii(long sz, boolean intern) {
            byte[] bytes = this.readNBytes((int)sz);
            TruffleString value = TruffleString.fromByteArrayUncached((byte[])bytes, (int)0, (int)((int)sz), (TruffleString.Encoding)TruffleString.Encoding.US_ASCII, (boolean)true).switchEncodingUncached(PythonUtils.TS_ENCODING);
            if (intern) {
                return StringNodes.InternStringNode.executeUncached(value);
            }
            return value;
        }

        private void readArray(Object[] items) throws NumberFormatException {
            for (int i = 0; i < items.length; ++i) {
                Object item = this.readObject();
                if (item == null) {
                    throw new MarshalError(PythonBuiltinClassType.EOFError, ErrorMessages.BAD_MARSHAL_DATA, new Object[0]);
                }
                items[i] = item;
            }
        }

        private Object readJavaArray() {
            int type = this.readByte();
            switch (type) {
                case 98: {
                    return this.readBytes();
                }
                case 105: {
                    return this.readIntArray();
                }
                case 108: {
                    return this.readLongArray();
                }
                case 100: {
                    return this.readDoubleArray();
                }
                case 115: {
                    return this.readShortArray();
                }
                case 66: {
                    return this.readBooleanArray();
                }
                case 83: {
                    return this.readStringArray();
                }
                case 111: {
                    return this.readObjectArray();
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"unknown array type");
        }

        private int[] readIntArray() {
            int length = this.readInt();
            int[] a = new int[length];
            for (int i = 0; i < length; ++i) {
                a[i] = this.readInt();
            }
            return a;
        }

        private long[] readLongArray() {
            int length = this.readInt();
            long[] a = new long[length];
            for (int i = 0; i < length; ++i) {
                a[i] = this.readLong();
            }
            return a;
        }

        private double[] readDoubleArray() {
            int length = this.readInt();
            double[] a = new double[length];
            for (int i = 0; i < length; ++i) {
                a[i] = this.readDouble();
            }
            return a;
        }

        private short[] readShortArray() {
            int length = this.readInt();
            short[] a = new short[length];
            for (int i = 0; i < length; ++i) {
                a[i] = this.readShort();
            }
            return a;
        }

        private boolean[] readBooleanArray() {
            int length = this.readInt();
            boolean[] a = new boolean[length];
            for (int i = 0; i < length; ++i) {
                a[i] = this.readByte() != 0;
            }
            return a;
        }

        private TruffleString[] readStringArray() {
            int length = this.readInt();
            TruffleString[] a = new TruffleString[length];
            for (int i = 0; i < length; ++i) {
                a[i] = this.readString();
            }
            return a;
        }

        private Object[] readObjectArray() {
            int length = this.readInt();
            Object[] a = new Object[length];
            for (int i = 0; i < length; ++i) {
                a[i] = this.readObject();
            }
            return a;
        }

        private void writeSparseTable(int[][] table) {
            this.writeInt(table.length);
            for (int i = 0; i < table.length; ++i) {
                if (table[i] == null || table[i].length <= 0) continue;
                this.writeInt(i);
                this.writeIntArray(table[i]);
            }
            this.writeInt(-1);
        }

        private int[][] readSparseTable() {
            int length = this.readInt();
            int[][] table = new int[length][];
            int i;
            while ((i = this.readInt()) != -1) {
                table[i] = this.readIntArray();
            }
            return table;
        }

        private CodeUnit readCodeUnit() {
            int fileVersion = this.readByte();
            if (fileVersion != 28) {
                throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.BYTECODE_VERSION_MISMATCH, 28, fileVersion);
            }
            TruffleString name = this.readString();
            TruffleString qualname = this.readString();
            int argCount = this.readInt();
            int kwOnlyArgCount = this.readInt();
            int positionalOnlyArgCount = this.readInt();
            int stacksize = this.readInt();
            byte[] code = this.readBytes();
            byte[] srcOffsetTable = this.readBytes();
            int flags = this.readInt();
            TruffleString[] names = this.readStringArray();
            TruffleString[] varnames = this.readStringArray();
            TruffleString[] cellvars = this.readStringArray();
            TruffleString[] freevars = this.readStringArray();
            int[] cell2arg = this.readIntArray();
            if (cell2arg.length == 0) {
                cell2arg = null;
            }
            Object[] constants = this.readObjectArray();
            long[] primitiveConstants = this.readLongArray();
            int[] exceptionHandlerRanges = this.readIntArray();
            int conditionProfileCount = this.readInt();
            int startLine = this.readInt();
            int startColumn = this.readInt();
            int endLine = this.readInt();
            int endColumn = this.readInt();
            byte[] outputCanQuicken = this.readBytes();
            byte[] variableShouldUnbox = this.readBytes();
            int[][] generalizeInputsMap = this.readSparseTable();
            int[][] generalizeVarsMap = this.readSparseTable();
            return new CodeUnit(name, qualname, argCount, kwOnlyArgCount, positionalOnlyArgCount, stacksize, code, srcOffsetTable, flags, names, varnames, cellvars, freevars, cell2arg, constants, primitiveConstants, exceptionHandlerRanges, conditionProfileCount, startLine, startColumn, endLine, endColumn, outputCanQuicken, variableShouldUnbox, generalizeInputsMap, generalizeVarsMap);
        }

        private void writeCodeUnit(CodeUnit code) throws IOException {
            this.writeByte(28);
            this.writeString(code.name);
            this.writeString(code.qualname);
            this.writeInt(code.argCount);
            this.writeInt(code.kwOnlyArgCount);
            this.writeInt(code.positionalOnlyArgCount);
            this.writeInt(code.stacksize);
            this.writeBytes(code.code);
            this.writeBytes(code.srcOffsetTable);
            this.writeInt(code.flags);
            this.writeStringArray(code.names);
            this.writeStringArray(code.varnames);
            this.writeStringArray(code.cellvars);
            this.writeStringArray(code.freevars);
            if (code.cell2arg != null) {
                this.writeIntArray(code.cell2arg);
            } else {
                this.writeIntArray(PythonUtils.EMPTY_INT_ARRAY);
            }
            this.writeObjectArray(code.constants);
            this.writeLongArray(code.primitiveConstants);
            this.writeIntArray(code.exceptionHandlerRanges);
            this.writeInt(code.conditionProfileCount);
            this.writeInt(code.startLine);
            this.writeInt(code.startColumn);
            this.writeInt(code.endLine);
            this.writeInt(code.endColumn);
            this.writeBytes(code.outputCanQuicken);
            this.writeBytes(code.variableShouldUnbox);
            this.writeSparseTable(code.generalizeInputsMap);
            this.writeSparseTable(code.generalizeVarsMap);
        }

        private PCode readCode() {
            TruffleString fileName = this.readString();
            int flags = this.readInt();
            int codeLen = this.readSize();
            byte[] codeString = new byte[codeLen + 8];
            try {
                this.in.read(codeString, 0, codeLen);
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            PythonContext context = PythonContext.get(null);
            ByteBuffer.wrap(codeString).putLong(codeLen, context.getDeserializationId(fileName));
            int firstLineNo = this.readInt();
            byte[] lnoTab = this.readBytes();
            return CodeNodes.CreateCodeNode.createCode(context, flags, codeString, fileName, firstLineNo, lnoTab);
        }

        static final class MarshalError
        extends RuntimeException {
            static final long serialVersionUID = 5323687983726237118L;
            final PythonBuiltinClassType type;
            final transient TruffleString message;
            final transient Object[] arguments;

            MarshalError(PythonBuiltinClassType type, TruffleString message, Object ... arguments) {
                super(null, null);
                this.type = type;
                this.message = message;
                this.arguments = arguments;
            }

            @Override
            public final Throwable fillInStackTrace() {
                return this;
            }
        }

        static final class FileLikeInputStream
        extends InputStream {
            private final Object fileLike;
            private final PyNumberAsSizeNode asSize;
            private final PByteArray buffer;
            private final ByteSequenceStorage singleByteStore;

            FileLikeInputStream(Object fileLike) {
                this.fileLike = fileLike;
                this.asSize = PyNumberAsSizeNode.getUncached();
                this.singleByteStore = new ByteSequenceStorage(new byte[1]);
                this.buffer = PythonObjectFactory.getUncached().createByteArray(this.singleByteStore);
            }

            @Override
            public int read() {
                Object readIntoResult = PyObjectCallMethodObjArgs.executeUncached(this.fileLike, IONodes.T_READINTO, this.buffer);
                int numRead = this.asSize.executeExact(null, readIntoResult, PythonBuiltinClassType.ValueError);
                if (numRead > 1) {
                    throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.S_RETURNED_TOO_MUCH_DATA, "read()", 1, numRead);
                }
                return this.singleByteStore.getIntItemNormalized(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) {
                assert (off == 0);
                ByteSequenceStorage tempStore = new ByteSequenceStorage(b, len);
                this.buffer.setSequenceStorage(tempStore);
                try {
                    Object readIntoResult = PyObjectCallMethodObjArgs.executeUncached(this.fileLike, IONodes.T_READINTO, this.buffer);
                    int numRead = this.asSize.executeExact(null, readIntoResult, PythonBuiltinClassType.ValueError);
                    if (numRead > len) {
                        throw new MarshalError(PythonBuiltinClassType.ValueError, ErrorMessages.S_RETURNED_TOO_MUCH_DATA, "read()", 1, numRead);
                    }
                    int n = numRead;
                    return n;
                }
                finally {
                    this.buffer.setSequenceStorage(this.singleByteStore);
                }
            }
        }

        @FunctionalInterface
        static interface AddRefAndReturn {
            public Object run(Object var1);
        }
    }

    @Builtin(name="loads", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"bytes"})
    @ArgumentClinic(name="bytes", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class LoadsNode
    extends PythonUnaryClinicBuiltinNode {
        LoadsNode() {
        }

        @Specialization
        static Object doit(VirtualFrame frame, Object buffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                Object object = Marshal.load(bufferLib.getInternalOrCopiedByteArray(buffer), bufferLib.getBufferLength(buffer));
                return object;
            }
            catch (NumberFormatException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.BAD_MARSHAL_DATA_S, e.getMessage());
            }
            catch (Marshal.MarshalError me) {
                throw raiseNode.get(inliningTarget).raise(me.type, me.message, me.arguments);
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MarshalModuleBuiltinsClinicProviders.LoadsNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="load", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class LoadNode
    extends PythonBuiltinNode {
        LoadNode() {
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallReadNode() {
            return LookupAndCallBinaryNode.create(IONodes.T_READ);
        }

        @Specialization
        static Object doit(VirtualFrame frame, Object file, @Bind(value="this") Node inliningTarget, @Cached(value="createCallReadNode()") LookupAndCallBinaryNode callNode, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferLib, @Cached PRaiseNode.Lazy raiseNode) {
            Object buffer = callNode.executeObject(frame, file, 0);
            if (!bufferLib.hasBuffer(buffer)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.READ_RETURNED_NOT_BYTES, buffer);
            }
            try {
                return Marshal.loadFile(file);
            }
            catch (NumberFormatException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.BAD_MARSHAL_DATA_S, e.getMessage());
            }
            catch (Marshal.MarshalError me) {
                throw raiseNode.get(inliningTarget).raise(me.type, me.message, me.arguments);
            }
        }
    }

    @Builtin(name="dumps", minNumOfPositionalArgs=1, parameterNames={"value", "version"})
    @ArgumentClinic(name="version", defaultValue="CURRENT_VERSION", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class DumpsNode
    extends PythonBinaryClinicBuiltinNode {
        DumpsNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MarshalModuleBuiltinsClinicProviders.DumpsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object doit(VirtualFrame frame, Object value, int version, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object savedState = ExecutionContext.IndirectCallContext.enter(frame, indirectCallData);
            try {
                PBytes pBytes = factory.createBytes(Marshal.dump(value, version, PythonContext.get(inliningTarget)));
                return pBytes;
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            catch (Marshal.MarshalError me) {
                throw raiseNode.get(inliningTarget).raise(me.type, me.message, me.arguments);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, indirectCallData, savedState);
            }
        }
    }

    @Builtin(name="dump", minNumOfPositionalArgs=2, parameterNames={"value", "file", "version"})
    @ArgumentClinic(name="version", defaultValue="CURRENT_VERSION", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class DumpNode
    extends PythonTernaryClinicBuiltinNode {
        DumpNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MarshalModuleBuiltinsClinicProviders.DumpNodeClinicProviderGen.INSTANCE;
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallWriteNode() {
            return LookupAndCallBinaryNode.create(IONodes.T_WRITE);
        }

        @Specialization
        static Object doit(VirtualFrame frame, Object value, Object file, int version, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached(value="createCallWriteNode()") LookupAndCallBinaryNode callNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object savedState = ExecutionContext.IndirectCallContext.enter(frame, indirectCallData);
            try {
                Object object = callNode.executeObject(frame, file, factory.createBytes(Marshal.dump(value, version, PythonContext.get(inliningTarget))));
                return object;
            }
            catch (IOException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            catch (Marshal.MarshalError me) {
                throw raiseNode.get(inliningTarget).raise(me.type, me.message, me.arguments);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, indirectCallData, savedState);
            }
        }
    }
}

