/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.MathModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodesFactory;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNodeGen;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNodeGen;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.lib.PyLongFromDoubleNodeGen;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberIndexNodeGen;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetIterNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNodeGen;
import com.oracle.graal.python.nodes.util.NarrowBigIntegerNode;
import com.oracle.graal.python.nodes.util.NarrowBigIntegerNodeGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=MathModuleBuiltins.class)
public final class MathModuleBuiltinsFactory {
    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(SqrtNodeFactory.getInstance(), ExpNodeFactory.getInstance(), Expm1NodeFactory.getInstance(), CeilNodeFactory.getInstance(), CopySignNodeFactory.getInstance(), FactorialNodeFactory.getInstance(), CombNodeFactory.getInstance(), PermNodeFactory.getInstance(), FloorNodeFactory.getInstance(), FmodNodeFactory.getInstance(), RemainderNodeFactory.getInstance(), FrexpNodeFactory.getInstance(), IsNanNodeFactory.getInstance(), IsCloseNodeFactory.getInstance(), LdexpNodeFactory.getInstance(), ModfNodeFactory.getInstance(), FsumNodeFactory.getInstance(), GcdNodeFactory.getInstance(), LcmNodeFactory.getInstance(), NextAfterNodeFactory.getInstance(), UlpNodeFactory.getInstance(), AcosNodeFactory.getInstance(), AcoshNodeFactory.getInstance(), AsinNodeFactory.getInstance(), CosNodeFactory.getInstance(), CoshNodeFactory.getInstance(), SinNodeFactory.getInstance(), SinhNodeFactory.getInstance(), TanNodeFactory.getInstance(), TanhNodeFactory.getInstance(), AtanNodeFactory.getInstance(), AtanhNodeFactory.getInstance(), AsinhNodeFactory.getInstance(), IsFiniteNodeFactory.getInstance(), IsInfNodeFactory.getInstance(), LogNodeFactory.getInstance(), Log1pNodeFactory.getInstance(), Log2NodeFactory.getInstance(), Log10NodeFactory.getInstance(), FabsNodeFactory.getInstance(), PowNodeFactory.getInstance(), TruncNodeFactory.getInstance(), Atan2NodeFactory.getInstance(), DegreesNodeFactory.getInstance(), RadiansNodeFactory.getInstance(), HypotNodeFactory.getInstance(), ErfNodeFactory.getInstance(), ErfcNodeFactory.getInstance(), GammaNodeFactory.getInstance(), LgammaNodeFactory.getInstance(), IsqrtNodeFactory.getInstance(), ProdNodeFactory.getInstance(), DistNodeFactory.getInstance());
    }

    @GeneratedBy(value=MathModuleBuiltins.SqrtNode.class)
    public static final class SqrtNodeFactory
    implements NodeFactory<MathModuleBuiltins.SqrtNode> {
        private static final SqrtNodeFactory SQRT_NODE_FACTORY_INSTANCE = new SqrtNodeFactory();

        private SqrtNodeFactory() {
        }

        public Class<MathModuleBuiltins.SqrtNode> getNodeClass() {
            return MathModuleBuiltins.SqrtNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.SqrtNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return SqrtNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.SqrtNode> getInstance() {
            return SQRT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.SqrtNode create() {
            return new SqrtNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.SqrtNode.class)
        public static final class SqrtNodeGen
        extends MathModuleBuiltins.SqrtNode {
            private static final InlineSupport.StateField STATE_0_SqrtNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SqrtNode_UPDATER.subUpdater(9, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field2_;

            private SqrtNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        SqrtNodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        SqrtNodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                SqrtNodeGen inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 4;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return this.doPI(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.ExpNode.class)
    public static final class ExpNodeFactory
    implements NodeFactory<MathModuleBuiltins.ExpNode> {
        private static final ExpNodeFactory EXP_NODE_FACTORY_INSTANCE = new ExpNodeFactory();

        private ExpNodeFactory() {
        }

        public Class<MathModuleBuiltins.ExpNode> getNodeClass() {
            return MathModuleBuiltins.ExpNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.ExpNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ExpNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.ExpNode> getInstance() {
            return EXP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.ExpNode create() {
            return new ExpNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.ExpNode.class)
        public static final class ExpNodeGen
        extends MathModuleBuiltins.ExpNode {
            private static final InlineSupport.StateField GENERAL__EXP_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__EXP_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private ExpNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.ExpNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.Expm1Node.class)
    public static final class Expm1NodeFactory
    implements NodeFactory<MathModuleBuiltins.Expm1Node> {
        private static final Expm1NodeFactory EXPM1_NODE_FACTORY_INSTANCE = new Expm1NodeFactory();

        private Expm1NodeFactory() {
        }

        public Class<MathModuleBuiltins.Expm1Node> getNodeClass() {
            return MathModuleBuiltins.Expm1Node.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.Expm1Node createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return Expm1NodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.Expm1Node> getInstance() {
            return EXPM1_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.Expm1Node create() {
            return new Expm1NodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.Expm1Node.class)
        public static final class Expm1NodeGen
        extends MathModuleBuiltins.Expm1Node {
            private static final InlineSupport.StateField GENERAL__EXPM1_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__EXPM1_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private Expm1NodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.Expm1Node.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.CeilNode.class)
    public static final class CeilNodeFactory
    implements NodeFactory<MathModuleBuiltins.CeilNode> {
        private static final CeilNodeFactory CEIL_NODE_FACTORY_INSTANCE = new CeilNodeFactory();

        private CeilNodeFactory() {
        }

        public Class<MathModuleBuiltins.CeilNode> getNodeClass() {
            return MathModuleBuiltins.CeilNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.CeilNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CeilNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.CeilNode> getInstance() {
            return CEIL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.CeilNode create() {
            return new CeilNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.CeilNode.class)
        public static final class CeilNodeGen
        extends MathModuleBuiltins.CeilNode {
            private static final InlineSupport.StateField STATE_0_CeilNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField FALLBACK__CEIL_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
            private static final PyLongFromDoubleNode INLINED_CEIL_DOUBLE_PY_LONG_FROM_DOUBLE_NODE_ = PyLongFromDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyLongFromDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CeilNode_UPDATER.subUpdater(2, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"ceilDouble_pyLongFromDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"ceilDouble_pyLongFromDoubleNode__field2_", Node.class)}));
            private static final GetClassNode INLINED_FALLBACK_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineSupport.InlineTarget.create(GetClassNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__CEIL_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 17), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_getClassNode__field1_", Node.class)}));
            private static final PyFloatAsDoubleNode INLINED_FALLBACK_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__CEIL_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(17, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_asDoubleNode__field2_", Node.class)}));
            private static final PyLongFromDoubleNode INLINED_FALLBACK_PY_LONG_FROM_DOUBLE_NODE_ = PyLongFromDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyLongFromDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__CEIL_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(24, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_pyLongFromDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_pyLongFromDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node ceilDouble_pyLongFromDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node ceilDouble_pyLongFromDoubleNode__field2_;
            @Node.Child
            private FallbackData fallback_cache;

            private CeilNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                return (state_0 & 1) != 0 || !(arg0Value instanceof Double);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    FallbackData s1_;
                    if ((state_0 & 1) != 0 && arg0Value instanceof Double) {
                        double arg0Value_ = (Double)arg0Value;
                        CeilNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.CeilNode.ceilDouble(arg0Value_, inliningTarget__, INLINED_CEIL_DOUBLE_PY_LONG_FROM_DOUBLE_NODE_);
                    }
                    if ((state_0 & 2) != 0 && (s1_ = this.fallback_cache) != null) {
                        FallbackData inliningTarget__1 = s1_;
                        if (this.fallbackGuard_(state_0, arg0Value)) {
                            return MathModuleBuiltins.CeilNode.ceil(frameValue, arg0Value, inliningTarget__1, INLINED_FALLBACK_GET_CLASS_NODE_, s1_.lookupCeil_, s1_.callCeil_, INLINED_FALLBACK_AS_DOUBLE_NODE_, INLINED_FALLBACK_PY_LONG_FROM_DOUBLE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                FallbackData s1_;
                int state_0 = this.state_0_;
                CeilNodeGen inliningTarget__ = null;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.CeilNode.ceilDouble(arg0Value_, inliningTarget__, INLINED_CEIL_DOUBLE_PY_LONG_FROM_DOUBLE_NODE_);
                }
                FallbackData inliningTarget__1 = null;
                inliningTarget__1 = s1_ = (FallbackData)this.insert(new FallbackData());
                LookupSpecialMethodNode lookupCeil__ = (LookupSpecialMethodNode)s1_.insert(LookupSpecialMethodNode.create(SpecialMethodNames.T___CEIL__));
                Objects.requireNonNull(lookupCeil__, "Specialization 'ceil(VirtualFrame, Object, Node, GetClassNode, LookupSpecialMethodNode, CallUnaryMethodNode, PyFloatAsDoubleNode, PyLongFromDoubleNode)' cache 'lookupCeil' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.lookupCeil_ = lookupCeil__;
                CallUnaryMethodNode callCeil__ = (CallUnaryMethodNode)s1_.insert(CallUnaryMethodNode.create());
                Objects.requireNonNull(callCeil__, "Specialization 'ceil(VirtualFrame, Object, Node, GetClassNode, LookupSpecialMethodNode, CallUnaryMethodNode, PyFloatAsDoubleNode, PyLongFromDoubleNode)' cache 'callCeil' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.callCeil_ = callCeil__;
                VarHandle.storeStoreFence();
                this.fallback_cache = s1_;
                this.state_0_ = state_0 |= 2;
                return MathModuleBuiltins.CeilNode.ceil(frameValue, arg0Value, inliningTarget__1, INLINED_FALLBACK_GET_CLASS_NODE_, lookupCeil__, callCeil__, INLINED_FALLBACK_AS_DOUBLE_NODE_, INLINED_FALLBACK_PY_LONG_FROM_DOUBLE_NODE_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.CeilNode.class)
            @DenyReplace
            private static final class FallbackData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int fallback_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_getClassNode__field1_;
                @Node.Child
                LookupSpecialMethodNode lookupCeil_;
                @Node.Child
                CallUnaryMethodNode callCeil_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_asDoubleNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_pyLongFromDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_pyLongFromDoubleNode__field2_;

                FallbackData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.CopySignNode.class)
    public static final class CopySignNodeFactory
    implements NodeFactory<MathModuleBuiltins.CopySignNode> {
        private static final CopySignNodeFactory COPY_SIGN_NODE_FACTORY_INSTANCE = new CopySignNodeFactory();

        private CopySignNodeFactory() {
        }

        public Class<MathModuleBuiltins.CopySignNode> getNodeClass() {
            return MathModuleBuiltins.CopySignNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.CopySignNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CopySignNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.CopySignNode> getInstance() {
            return COPY_SIGN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.CopySignNode create() {
            return new CopySignNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.CopySignNode.class)
        public static final class CopySignNodeGen
        extends MathModuleBuiltins.CopySignNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private CopySignNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return this.copySign(arg0Value_, arg1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private double executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.copySign(arg0Value_, arg1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.FactorialNode.class)
    public static final class FactorialNodeFactory
    implements NodeFactory<MathModuleBuiltins.FactorialNode> {
        private static final FactorialNodeFactory FACTORIAL_NODE_FACTORY_INSTANCE = new FactorialNodeFactory();

        private FactorialNodeFactory() {
        }

        public Class<MathModuleBuiltins.FactorialNode> getNodeClass() {
            return MathModuleBuiltins.FactorialNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.FactorialNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FactorialNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.FactorialNode> getInstance() {
            return FACTORIAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.FactorialNode create() {
            return new FactorialNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.FactorialNode.class)
        public static final class FactorialNodeGen
        extends MathModuleBuiltins.FactorialNode {
            private static final InlineSupport.StateField FALLBACK__FACTORIAL_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
            private static final PyLongAsLongAndOverflowNode INLINED_FALLBACK_CONVERT_ = PyLongAsLongAndOverflowNodeGen.inline(InlineSupport.InlineTarget.create(PyLongAsLongAndOverflowNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__FACTORIAL_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_convert__field1_", Node.class)}));
            private static final PyNumberAsSizeNode INLINED_FALLBACK_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberAsSizeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__FACTORIAL_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(6, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_asSizeNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_asSizeNode__field2_", Node.class)}));
            private static final PRaiseNode.Lazy INLINED_FALLBACK_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__FACTORIAL_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(11, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PRaiseNode raiseNode;
            @Node.Child
            private PythonObjectFactory factory;
            @Node.Child
            private FallbackData fallback_cache;

            private FactorialNodeGen() {
            }

            private boolean fallbackGuard_(Object arg0Value) {
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    if (arg0Value_ < 0) {
                        return false;
                    }
                    arg0Value_ = (Integer)arg0Value;
                    if (0 <= arg0Value_ && arg0Value_ < MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        return false;
                    }
                    arg0Value_ = (Integer)arg0Value;
                    if (arg0Value_ >= MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        return false;
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    if (arg0Value_ < 0L) {
                        return false;
                    }
                    arg0Value_ = (Long)arg0Value;
                    if (0L <= arg0Value_ && arg0Value_ < (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        return false;
                    }
                    arg0Value_ = (Long)arg0Value;
                    if (arg0Value_ >= (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    FallbackData s6_;
                    if ((state_0 & 7) != 0 && arg0Value instanceof Integer) {
                        PythonObjectFactory factory_;
                        PRaiseNode raiseNode_;
                        int arg0Value_ = (Integer)arg0Value;
                        if ((state_0 & 1) != 0 && (raiseNode_ = this.raiseNode) != null && arg0Value_ < 0) {
                            return MathModuleBuiltins.FactorialNode.factorialNegativeInt(arg0Value_, raiseNode_);
                        }
                        if ((state_0 & 2) != 0 && 0 <= arg0Value_ && arg0Value_ < MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                            return MathModuleBuiltins.FactorialNode.factorialSmallInt(arg0Value_);
                        }
                        if ((state_0 & 4) != 0 && (factory_ = this.factory) != null && arg0Value_ >= MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                            return MathModuleBuiltins.FactorialNode.factorialInt(arg0Value_, factory_);
                        }
                    }
                    if ((state_0 & 0x38) != 0 && arg0Value instanceof Long) {
                        PythonObjectFactory factory_1;
                        PRaiseNode raiseNode_1;
                        long arg0Value_ = (Long)arg0Value;
                        if ((state_0 & 8) != 0 && (raiseNode_1 = this.raiseNode) != null && arg0Value_ < 0L) {
                            return MathModuleBuiltins.FactorialNode.factorialNegativeLong(arg0Value_, raiseNode_1);
                        }
                        if ((state_0 & 0x10) != 0 && 0L <= arg0Value_ && arg0Value_ < (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                            return MathModuleBuiltins.FactorialNode.factorialSmallLong(arg0Value_);
                        }
                        if ((state_0 & 0x20) != 0 && (factory_1 = this.factory) != null && arg0Value_ >= (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                            return MathModuleBuiltins.FactorialNode.factorialLong(arg0Value_, factory_1);
                        }
                    }
                    if ((state_0 & 0x40) != 0 && (s6_ = this.fallback_cache) != null) {
                        FallbackData inliningTarget__ = s6_;
                        if (this.fallbackGuard_(arg0Value)) {
                            return MathModuleBuiltins.FactorialNode.factorialObject(frameValue, arg0Value, inliningTarget__, INLINED_FALLBACK_CONVERT_, INLINED_FALLBACK_AS_SIZE_NODE_, s6_.recursiveNode_, INLINED_FALLBACK_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, long arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x78) != 0) {
                    FallbackData s6_;
                    if ((state_0 & 0x38) != 0) {
                        PythonObjectFactory factory_1;
                        PRaiseNode raiseNode_1;
                        if ((state_0 & 8) != 0 && (raiseNode_1 = this.raiseNode) != null && arg0Value < 0L) {
                            return MathModuleBuiltins.FactorialNode.factorialNegativeLong(arg0Value, raiseNode_1);
                        }
                        if ((state_0 & 0x10) != 0 && 0L <= arg0Value && arg0Value < (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                            return MathModuleBuiltins.FactorialNode.factorialSmallLong(arg0Value);
                        }
                        if ((state_0 & 0x20) != 0 && (factory_1 = this.factory) != null && arg0Value >= (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                            return MathModuleBuiltins.FactorialNode.factorialLong(arg0Value, factory_1);
                        }
                    }
                    if ((state_0 & 0x40) != 0 && (s6_ = this.fallback_cache) != null) {
                        FallbackData inliningTarget__ = s6_;
                        if (this.fallbackGuard_(arg0Value)) {
                            return MathModuleBuiltins.FactorialNode.factorialObject(frameValue, arg0Value, inliningTarget__, INLINED_FALLBACK_CONVERT_, INLINED_FALLBACK_AS_SIZE_NODE_, s6_.recursiveNode_, INLINED_FALLBACK_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                FallbackData s6_;
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    if (arg0Value_ < 0) {
                        PRaiseNode raiseNode_;
                        PRaiseNode raiseNode__shared = this.raiseNode;
                        if (raiseNode__shared != null) {
                            raiseNode_ = raiseNode__shared;
                        } else {
                            raiseNode_ = (PRaiseNode)this.insert(PRaiseNode.create());
                            if (raiseNode_ == null) {
                                throw new IllegalStateException("Specialization 'factorialNegativeInt(int, PRaiseNode)' contains a shared cache with name 'raiseNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.raiseNode == null) {
                            VarHandle.storeStoreFence();
                            this.raiseNode = raiseNode_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return MathModuleBuiltins.FactorialNode.factorialNegativeInt(arg0Value_, raiseNode_);
                    }
                    if (0 <= arg0Value_ && arg0Value_ < MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        this.state_0_ = state_0 |= 2;
                        return MathModuleBuiltins.FactorialNode.factorialSmallInt(arg0Value_);
                    }
                    if (arg0Value_ >= MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        PythonObjectFactory factory_;
                        PythonObjectFactory factory__shared = this.factory;
                        if (factory__shared != null) {
                            factory_ = factory__shared;
                        } else {
                            factory_ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_ == null) {
                                throw new IllegalStateException("Specialization 'factorialInt(int, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_;
                        }
                        this.state_0_ = state_0 |= 4;
                        return MathModuleBuiltins.FactorialNode.factorialInt(arg0Value_, factory_);
                    }
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    if (arg0Value_ < 0L) {
                        PRaiseNode raiseNode_1;
                        PRaiseNode raiseNode_1_shared = this.raiseNode;
                        if (raiseNode_1_shared != null) {
                            raiseNode_1 = raiseNode_1_shared;
                        } else {
                            raiseNode_1 = (PRaiseNode)this.insert(PRaiseNode.create());
                            if (raiseNode_1 == null) {
                                throw new IllegalStateException("Specialization 'factorialNegativeLong(long, PRaiseNode)' contains a shared cache with name 'raiseNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.raiseNode == null) {
                            VarHandle.storeStoreFence();
                            this.raiseNode = raiseNode_1;
                        }
                        this.state_0_ = state_0 |= 8;
                        return MathModuleBuiltins.FactorialNode.factorialNegativeLong(arg0Value_, raiseNode_1);
                    }
                    if (0L <= arg0Value_ && arg0Value_ < (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        this.state_0_ = state_0 |= 0x10;
                        return MathModuleBuiltins.FactorialNode.factorialSmallLong(arg0Value_);
                    }
                    if (arg0Value_ >= (long)MathModuleBuiltins.FactorialNode.SMALL_FACTORIALS.length) {
                        PythonObjectFactory factory_1;
                        PythonObjectFactory factory_1_shared = this.factory;
                        if (factory_1_shared != null) {
                            factory_1 = factory_1_shared;
                        } else {
                            factory_1 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_1 == null) {
                                throw new IllegalStateException("Specialization 'factorialLong(long, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_1;
                        }
                        this.state_0_ = state_0 |= 0x20;
                        return MathModuleBuiltins.FactorialNode.factorialLong(arg0Value_, factory_1);
                    }
                }
                FallbackData inliningTarget__ = null;
                inliningTarget__ = s6_ = (FallbackData)this.insert(new FallbackData());
                MathModuleBuiltins.FactorialNode recursiveNode__ = (MathModuleBuiltins.FactorialNode)s6_.insert(FactorialNodeFactory.create());
                Objects.requireNonNull(recursiveNode__, "Specialization 'factorialObject(VirtualFrame, Object, Node, PyLongAsLongAndOverflowNode, PyNumberAsSizeNode, FactorialNode, Lazy)' cache 'recursiveNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s6_.recursiveNode_ = recursiveNode__;
                VarHandle.storeStoreFence();
                this.fallback_cache = s6_;
                this.state_0_ = state_0 |= 0x40;
                return MathModuleBuiltins.FactorialNode.factorialObject(frameValue, arg0Value, inliningTarget__, INLINED_FALLBACK_CONVERT_, INLINED_FALLBACK_AS_SIZE_NODE_, recursiveNode__, INLINED_FALLBACK_RAISE_NODE_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.FactorialNode.class)
            @DenyReplace
            private static final class FallbackData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int fallback_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_convert__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_asSizeNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_asSizeNode__field2_;
                @Node.Child
                MathModuleBuiltins.FactorialNode recursiveNode_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_raiseNode__field1_;

                FallbackData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.CombNode.class)
    public static final class CombNodeFactory
    implements NodeFactory<MathModuleBuiltins.CombNode> {
        private static final CombNodeFactory COMB_NODE_FACTORY_INSTANCE = new CombNodeFactory();

        private CombNodeFactory() {
        }

        public Class<MathModuleBuiltins.CombNode> getNodeClass() {
            return MathModuleBuiltins.CombNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.CombNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CombNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.CombNode> getInstance() {
            return COMB_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.CombNode create() {
            return new CombNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.CombNode.class)
        public static final class CombNodeGen
        extends MathModuleBuiltins.CombNode {
            private static final InlineSupport.StateField COMB4__COMB_NODE_COMB4_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Comb4Data.lookup_(), (String)"comb4_state_0_");
            private static final PyNumberIndexNode INLINED_COMB4_INDEX_NODE_ = PyNumberIndexNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{COMB4__COMB_NODE_COMB4_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Comb4Data.lookup_(), (String)"comb4_indexNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Comb4Data.lookup_(), (String)"comb4_indexNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Comb4Data.lookup_(), (String)"comb4_indexNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Comb4Data.lookup_(), (String)"comb4_indexNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Comb4Data.lookup_(), (String)"comb4_indexNode__field5_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PythonObjectFactory factory;
            @Node.Child
            private Comb4Data comb4_cache;

            private CombNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F) != 0) {
                    Comb4Data s4_;
                    if ((state_0 & 3) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0) >>> 5, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0) >>> 5, arg0Value);
                        if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x700) >>> 8, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x700) >>> 8, arg1Value);
                            PythonObjectFactory factory_ = this.factory;
                            if (factory_ != null) {
                                return this.comb(arg0Value_, arg1Value_, factory_);
                            }
                        }
                        if ((state_0 & 2) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            PythonObjectFactory factory_1 = this.factory;
                            if (factory_1 != null) {
                                return this.comb(arg0Value_, arg1Value_, factory_1);
                            }
                        }
                    }
                    if ((state_0 & 0xC) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 4) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x700) >>> 8, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x700) >>> 8, arg1Value);
                            PythonObjectFactory factory_2 = this.factory;
                            if (factory_2 != null) {
                                return this.comb(arg0Value_, arg1Value_, factory_2);
                            }
                        }
                        if ((state_0 & 8) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            PythonObjectFactory factory_3 = this.factory;
                            if (factory_3 != null) {
                                return this.comb(arg0Value_, arg1Value_, factory_3);
                            }
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (s4_ = this.comb4_cache) != null) {
                        Comb4Data inliningTarget__ = s4_;
                        return MathModuleBuiltins.CombNode.comb(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_COMB4_INDEX_NODE_, s4_.recursiveNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                Comb4Data s4_;
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    int longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        PythonObjectFactory factory_;
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                        PythonObjectFactory factory__shared = this.factory;
                        if (factory__shared != null) {
                            factory_ = factory__shared;
                        } else {
                            factory_ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_ == null) {
                                throw new IllegalStateException("Specialization 'comb(long, long, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_;
                        }
                        state_0 |= longCast0 << 5;
                        state_0 |= longCast1 << 8;
                        this.state_0_ = state_0 |= 1;
                        return this.comb(arg0Value_, arg1Value_, factory_);
                    }
                    if (arg1Value instanceof PInt) {
                        PythonObjectFactory factory_1;
                        PInt arg1Value_ = (PInt)arg1Value;
                        PythonObjectFactory factory_1_shared = this.factory;
                        if (factory_1_shared != null) {
                            factory_1 = factory_1_shared;
                        } else {
                            factory_1 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_1 == null) {
                                throw new IllegalStateException("Specialization 'comb(long, PInt, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_1;
                        }
                        state_0 |= longCast0 << 5;
                        this.state_0_ = state_0 |= 2;
                        return this.comb(arg0Value_, arg1Value_, factory_1);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    int longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        PythonObjectFactory factory_2;
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                        PythonObjectFactory factory_2_shared = this.factory;
                        if (factory_2_shared != null) {
                            factory_2 = factory_2_shared;
                        } else {
                            factory_2 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_2 == null) {
                                throw new IllegalStateException("Specialization 'comb(PInt, long, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_2;
                        }
                        state_0 |= longCast1 << 8;
                        this.state_0_ = state_0 |= 4;
                        return this.comb(arg0Value_, arg1Value_, factory_2);
                    }
                    if (arg1Value instanceof PInt) {
                        PythonObjectFactory factory_3;
                        PInt arg1Value_ = (PInt)arg1Value;
                        PythonObjectFactory factory_3_shared = this.factory;
                        if (factory_3_shared != null) {
                            factory_3 = factory_3_shared;
                        } else {
                            factory_3 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_3 == null) {
                                throw new IllegalStateException("Specialization 'comb(PInt, PInt, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_3;
                        }
                        this.state_0_ = state_0 |= 8;
                        return this.comb(arg0Value_, arg1Value_, factory_3);
                    }
                }
                Comb4Data inliningTarget__ = null;
                inliningTarget__ = s4_ = (Comb4Data)this.insert(new Comb4Data());
                MathModuleBuiltins.CombNode recursiveNode__ = (MathModuleBuiltins.CombNode)s4_.insert(CombNodeFactory.create());
                Objects.requireNonNull(recursiveNode__, "Specialization 'comb(VirtualFrame, Object, Object, Node, PyNumberIndexNode, CombNode)' cache 'recursiveNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s4_.recursiveNode_ = recursiveNode__;
                VarHandle.storeStoreFence();
                this.comb4_cache = s4_;
                this.state_0_ = state_0 |= 0x10;
                return MathModuleBuiltins.CombNode.comb(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_COMB4_INDEX_NODE_, recursiveNode__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0x1F & (state_0 & 0x1F) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.CombNode.class)
            @DenyReplace
            private static final class Comb4Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int comb4_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node comb4_indexNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node comb4_indexNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node comb4_indexNode__field3_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node comb4_indexNode__field4_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node comb4_indexNode__field5_;
                @Node.Child
                MathModuleBuiltins.CombNode recursiveNode_;

                Comb4Data() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.PermNode.class)
    public static final class PermNodeFactory
    implements NodeFactory<MathModuleBuiltins.PermNode> {
        private static final PermNodeFactory PERM_NODE_FACTORY_INSTANCE = new PermNodeFactory();

        private PermNodeFactory() {
        }

        public Class<MathModuleBuiltins.PermNode> getNodeClass() {
            return MathModuleBuiltins.PermNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.PermNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return PermNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.PermNode> getInstance() {
            return PERM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.PermNode create() {
            return new PermNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.PermNode.class)
        public static final class PermNodeGen
        extends MathModuleBuiltins.PermNode {
            private static final InlineSupport.StateField PERM5__PERM_NODE_PERM5_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Perm5Data.lookup_(), (String)"perm5_state_0_");
            private static final PyNumberIndexNode INLINED_PERM5_INDEX_NODE_ = PyNumberIndexNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{PERM5__PERM_NODE_PERM5_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Perm5Data.lookup_(), (String)"perm5_indexNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Perm5Data.lookup_(), (String)"perm5_indexNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Perm5Data.lookup_(), (String)"perm5_indexNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Perm5Data.lookup_(), (String)"perm5_indexNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Perm5Data.lookup_(), (String)"perm5_indexNode__field5_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PythonObjectFactory factory;
            @Node.Child
            private MathModuleBuiltins.FactorialNode perm4_factorialNode_;
            @Node.Child
            private Perm5Data perm5_cache;

            private PermNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x3F) != 0) {
                    if ((state_0 & 3) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C0) >>> 6, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C0) >>> 6, arg0Value);
                        if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE00) >>> 9, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE00) >>> 9, arg1Value);
                            PythonObjectFactory factory_ = this.factory;
                            if (factory_ != null) {
                                return this.perm(arg0Value_, arg1Value_, factory_);
                            }
                        }
                        if ((state_0 & 2) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            PythonObjectFactory factory_1 = this.factory;
                            if (factory_1 != null) {
                                return this.perm(arg0Value_, arg1Value_, factory_1);
                            }
                        }
                    }
                    if ((state_0 & 0xC) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 4) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE00) >>> 9, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE00) >>> 9, arg1Value);
                            PythonObjectFactory factory_2 = this.factory;
                            if (factory_2 != null) {
                                return this.perm(arg0Value_, arg1Value_, factory_2);
                            }
                        }
                        if ((state_0 & 8) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            PythonObjectFactory factory_3 = this.factory;
                            if (factory_3 != null) {
                                return this.perm(arg0Value_, arg1Value_, factory_3);
                            }
                        }
                    }
                    if ((state_0 & 0x30) != 0) {
                        Perm5Data s5_;
                        if ((state_0 & 0x10) != 0 && arg1Value instanceof PNone) {
                            PNone arg1Value_ = (PNone)arg1Value;
                            MathModuleBuiltins.FactorialNode factorialNode__ = this.perm4_factorialNode_;
                            if (factorialNode__ != null) {
                                return this.perm(frameValue, arg0Value, arg1Value_, factorialNode__);
                            }
                        }
                        if ((state_0 & 0x20) != 0 && (s5_ = this.perm5_cache) != null && !PGuards.isPNone(arg1Value)) {
                            Perm5Data inliningTarget__ = s5_;
                            return MathModuleBuiltins.PermNode.perm(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_PERM5_INDEX_NODE_, s5_.recursiveNode_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    int longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        PythonObjectFactory factory_;
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                        PythonObjectFactory factory__shared = this.factory;
                        if (factory__shared != null) {
                            factory_ = factory__shared;
                        } else {
                            factory_ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_ == null) {
                                throw new IllegalStateException("Specialization 'perm(long, long, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_;
                        }
                        state_0 |= longCast0 << 6;
                        state_0 |= longCast1 << 9;
                        this.state_0_ = state_0 |= 1;
                        return this.perm(arg0Value_, arg1Value_, factory_);
                    }
                    if (arg1Value instanceof PInt) {
                        PythonObjectFactory factory_1;
                        PInt arg1Value_ = (PInt)arg1Value;
                        PythonObjectFactory factory_1_shared = this.factory;
                        if (factory_1_shared != null) {
                            factory_1 = factory_1_shared;
                        } else {
                            factory_1 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_1 == null) {
                                throw new IllegalStateException("Specialization 'perm(long, PInt, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_1;
                        }
                        state_0 |= longCast0 << 6;
                        this.state_0_ = state_0 |= 2;
                        return this.perm(arg0Value_, arg1Value_, factory_1);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    int longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        PythonObjectFactory factory_2;
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                        PythonObjectFactory factory_2_shared = this.factory;
                        if (factory_2_shared != null) {
                            factory_2 = factory_2_shared;
                        } else {
                            factory_2 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_2 == null) {
                                throw new IllegalStateException("Specialization 'perm(PInt, long, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_2;
                        }
                        state_0 |= longCast1 << 9;
                        this.state_0_ = state_0 |= 4;
                        return this.perm(arg0Value_, arg1Value_, factory_2);
                    }
                    if (arg1Value instanceof PInt) {
                        PythonObjectFactory factory_3;
                        PInt arg1Value_ = (PInt)arg1Value;
                        PythonObjectFactory factory_3_shared = this.factory;
                        if (factory_3_shared != null) {
                            factory_3 = factory_3_shared;
                        } else {
                            factory_3 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_3 == null) {
                                throw new IllegalStateException("Specialization 'perm(PInt, PInt, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_3;
                        }
                        this.state_0_ = state_0 |= 8;
                        return this.perm(arg0Value_, arg1Value_, factory_3);
                    }
                }
                if (arg1Value instanceof PNone) {
                    PNone arg1Value_ = (PNone)arg1Value;
                    MathModuleBuiltins.FactorialNode factorialNode__ = (MathModuleBuiltins.FactorialNode)this.insert(FactorialNodeFactory.create());
                    Objects.requireNonNull(factorialNode__, "Specialization 'perm(VirtualFrame, Object, PNone, FactorialNode)' cache 'factorialNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.perm4_factorialNode_ = factorialNode__;
                    this.state_0_ = state_0 |= 0x10;
                    return this.perm(frameValue, arg0Value, arg1Value_, factorialNode__);
                }
                Perm5Data inliningTarget__ = null;
                if (!PGuards.isPNone(arg1Value)) {
                    Perm5Data s5_;
                    inliningTarget__ = s5_ = (Perm5Data)this.insert(new Perm5Data());
                    MathModuleBuiltins.PermNode recursiveNode__ = (MathModuleBuiltins.PermNode)s5_.insert(PermNodeFactory.create());
                    Objects.requireNonNull(recursiveNode__, "Specialization 'perm(VirtualFrame, Object, Object, Node, PyNumberIndexNode, PermNode)' cache 'recursiveNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s5_.recursiveNode_ = recursiveNode__;
                    VarHandle.storeStoreFence();
                    this.perm5_cache = s5_;
                    this.state_0_ = state_0 |= 0x20;
                    return MathModuleBuiltins.PermNode.perm(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_PERM5_INDEX_NODE_, recursiveNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0x3F) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0x3F & (state_0 & 0x3F) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.PermNode.class)
            @DenyReplace
            private static final class Perm5Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int perm5_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node perm5_indexNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node perm5_indexNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node perm5_indexNode__field3_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node perm5_indexNode__field4_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node perm5_indexNode__field5_;
                @Node.Child
                MathModuleBuiltins.PermNode recursiveNode_;

                Perm5Data() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.FloorNode.class)
    public static final class FloorNodeFactory
    implements NodeFactory<MathModuleBuiltins.FloorNode> {
        private static final FloorNodeFactory FLOOR_NODE_FACTORY_INSTANCE = new FloorNodeFactory();

        private FloorNodeFactory() {
        }

        public Class<MathModuleBuiltins.FloorNode> getNodeClass() {
            return MathModuleBuiltins.FloorNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.FloorNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FloorNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.FloorNode> getInstance() {
            return FLOOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.FloorNode create() {
            return new FloorNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.FloorNode.class)
        public static final class FloorNodeGen
        extends MathModuleBuiltins.FloorNode {
            private static final InlineSupport.StateField STATE_0_FloorNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField FALLBACK__FLOOR_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
            private static final PyLongFromDoubleNode INLINED_FLOOR_DOUBLE_PY_LONG_FROM_DOUBLE_NODE_ = PyLongFromDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyLongFromDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FloorNode_UPDATER.subUpdater(2, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"floorDouble_pyLongFromDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"floorDouble_pyLongFromDoubleNode__field2_", Node.class)}));
            private static final GetClassNode INLINED_FALLBACK_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineSupport.InlineTarget.create(GetClassNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__FLOOR_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 17), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_getClassNode__field1_", Node.class)}));
            private static final PyFloatAsDoubleNode INLINED_FALLBACK_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__FLOOR_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(17, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_asDoubleNode__field2_", Node.class)}));
            private static final PyLongFromDoubleNode INLINED_FALLBACK_PY_LONG_FROM_DOUBLE_NODE_ = PyLongFromDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyLongFromDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK__FLOOR_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(24, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_pyLongFromDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_pyLongFromDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node floorDouble_pyLongFromDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node floorDouble_pyLongFromDoubleNode__field2_;
            @Node.Child
            private FallbackData fallback_cache;

            private FloorNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                return (state_0 & 1) != 0 || !(arg0Value instanceof Double);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    FallbackData s1_;
                    if ((state_0 & 1) != 0 && arg0Value instanceof Double) {
                        double arg0Value_ = (Double)arg0Value;
                        FloorNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.FloorNode.floorDouble(arg0Value_, inliningTarget__, INLINED_FLOOR_DOUBLE_PY_LONG_FROM_DOUBLE_NODE_);
                    }
                    if ((state_0 & 2) != 0 && (s1_ = this.fallback_cache) != null) {
                        FallbackData inliningTarget__1 = s1_;
                        if (this.fallbackGuard_(state_0, arg0Value)) {
                            return MathModuleBuiltins.FloorNode.floor(frameValue, arg0Value, inliningTarget__1, INLINED_FALLBACK_GET_CLASS_NODE_, s1_.lookupFloor_, s1_.callFloor_, INLINED_FALLBACK_AS_DOUBLE_NODE_, INLINED_FALLBACK_PY_LONG_FROM_DOUBLE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                FallbackData s1_;
                int state_0 = this.state_0_;
                FloorNodeGen inliningTarget__ = null;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.FloorNode.floorDouble(arg0Value_, inliningTarget__, INLINED_FLOOR_DOUBLE_PY_LONG_FROM_DOUBLE_NODE_);
                }
                FallbackData inliningTarget__1 = null;
                inliningTarget__1 = s1_ = (FallbackData)this.insert(new FallbackData());
                LookupSpecialMethodNode lookupFloor__ = (LookupSpecialMethodNode)s1_.insert(LookupSpecialMethodNode.create(SpecialMethodNames.T___FLOOR__));
                Objects.requireNonNull(lookupFloor__, "Specialization 'floor(VirtualFrame, Object, Node, GetClassNode, LookupSpecialMethodNode, CallUnaryMethodNode, PyFloatAsDoubleNode, PyLongFromDoubleNode)' cache 'lookupFloor' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.lookupFloor_ = lookupFloor__;
                CallUnaryMethodNode callFloor__ = (CallUnaryMethodNode)s1_.insert(CallUnaryMethodNode.create());
                Objects.requireNonNull(callFloor__, "Specialization 'floor(VirtualFrame, Object, Node, GetClassNode, LookupSpecialMethodNode, CallUnaryMethodNode, PyFloatAsDoubleNode, PyLongFromDoubleNode)' cache 'callFloor' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s1_.callFloor_ = callFloor__;
                VarHandle.storeStoreFence();
                this.fallback_cache = s1_;
                this.state_0_ = state_0 |= 2;
                return MathModuleBuiltins.FloorNode.floor(frameValue, arg0Value, inliningTarget__1, INLINED_FALLBACK_GET_CLASS_NODE_, lookupFloor__, callFloor__, INLINED_FALLBACK_AS_DOUBLE_NODE_, INLINED_FALLBACK_PY_LONG_FROM_DOUBLE_NODE_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.FloorNode.class)
            @DenyReplace
            private static final class FallbackData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int fallback_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_getClassNode__field1_;
                @Node.Child
                LookupSpecialMethodNode lookupFloor_;
                @Node.Child
                CallUnaryMethodNode callFloor_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_asDoubleNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_pyLongFromDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_pyLongFromDoubleNode__field2_;

                FallbackData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.FmodNode.class)
    public static final class FmodNodeFactory
    implements NodeFactory<MathModuleBuiltins.FmodNode> {
        private static final FmodNodeFactory FMOD_NODE_FACTORY_INSTANCE = new FmodNodeFactory();

        private FmodNodeFactory() {
        }

        public Class<MathModuleBuiltins.FmodNode> getNodeClass() {
            return MathModuleBuiltins.FmodNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.FmodNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FmodNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.FmodNode> getInstance() {
            return FMOD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.FmodNode create() {
            return new FmodNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.FmodNode.class)
        public static final class FmodNodeGen
        extends MathModuleBuiltins.FmodNode {
            private static final InlineSupport.StateField STATE_0_FmodNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedConditionProfile INLINED_INF_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FmodNode_UPDATER.subUpdater(1, 2)}));
            private static final InlinedConditionProfile INLINED_ZERO_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FmodNode_UPDATER.subUpdater(3, 2)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FmodNode_UPDATER.subUpdater(5, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private FmodNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        FmodNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.FmodNode.fmodDD(arg0Value_, arg1Value_, inliningTarget__, INLINED_INF_PROFILE_, INLINED_ZERO_PROFILE_, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private double executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                FmodNodeGen inliningTarget__ = null;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        inliningTarget__ = this;
                        this.state_0_ = state_0 |= 1;
                        return MathModuleBuiltins.FmodNode.fmodDD(arg0Value_, arg1Value_, inliningTarget__, INLINED_INF_PROFILE_, INLINED_ZERO_PROFILE_, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.RemainderNode.class)
    public static final class RemainderNodeFactory
    implements NodeFactory<MathModuleBuiltins.RemainderNode> {
        private static final RemainderNodeFactory REMAINDER_NODE_FACTORY_INSTANCE = new RemainderNodeFactory();

        private RemainderNodeFactory() {
        }

        public Class<MathModuleBuiltins.RemainderNode> getNodeClass() {
            return MathModuleBuiltins.RemainderNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.RemainderNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RemainderNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.RemainderNode> getInstance() {
            return REMAINDER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.RemainderNode create() {
            return new RemainderNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.RemainderNode.class)
        public static final class RemainderNodeGen
        extends MathModuleBuiltins.RemainderNode {
            private static final InlineSupport.StateField STATE_0_RemainderNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_RemainderNode_UPDATER.subUpdater(1, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private RemainderNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        RemainderNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.RemainderNode.remainderDD(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private double executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                RemainderNodeGen inliningTarget__ = null;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        inliningTarget__ = this;
                        this.state_0_ = state_0 |= 1;
                        return MathModuleBuiltins.RemainderNode.remainderDD(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.FrexpNode.class)
    public static final class FrexpNodeFactory
    implements NodeFactory<MathModuleBuiltins.FrexpNode> {
        private static final FrexpNodeFactory FREXP_NODE_FACTORY_INSTANCE = new FrexpNodeFactory();

        private FrexpNodeFactory() {
        }

        public Class<MathModuleBuiltins.FrexpNode> getNodeClass() {
            return MathModuleBuiltins.FrexpNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.FrexpNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FrexpNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.FrexpNode> getInstance() {
            return FREXP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.FrexpNode create() {
            return new FrexpNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.FrexpNode.class)
        public static final class FrexpNodeGen
        extends MathModuleBuiltins.FrexpNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PythonObjectFactory factory_;

            private FrexpNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    PythonObjectFactory factory__ = this.factory_;
                    if (factory__ != null) {
                        return MathModuleBuiltins.FrexpNode.frexpD(arg0Value_, factory__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private PTuple executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    PythonObjectFactory factory__ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                    Objects.requireNonNull(factory__, "Specialization 'frexpD(double, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.FrexpNode.frexpD(arg0Value_, factory__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.IsNanNode.class)
    public static final class IsNanNodeFactory
    implements NodeFactory<MathModuleBuiltins.IsNanNode> {
        private static final IsNanNodeFactory IS_NAN_NODE_FACTORY_INSTANCE = new IsNanNodeFactory();

        private IsNanNodeFactory() {
        }

        public Class<MathModuleBuiltins.IsNanNode> getNodeClass() {
            return MathModuleBuiltins.IsNanNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.IsNanNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IsNanNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.IsNanNode> getInstance() {
            return IS_NAN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.IsNanNode create() {
            return new IsNanNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.IsNanNode.class)
        public static final class IsNanNodeGen
        extends MathModuleBuiltins.IsNanNode {
            private static final InlineSupport.StateField ISINF__IS_NAN_NODE_ISINF_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)IsinfData.lookup_(), (String)"isinf_state_0_");
            private static final PyFloatAsDoubleNode INLINED_ISINF_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{ISINF__IS_NAN_NODE_ISINF_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)IsinfData.lookup_(), (String)"isinf_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)IsinfData.lookup_(), (String)"isinf_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private IsinfData isinf_cache;

            private IsNanNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    IsinfData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return MathModuleBuiltins.IsNanNode.isNan(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return MathModuleBuiltins.IsNanNode.isNan(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return MathModuleBuiltins.IsNanNode.isNan(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.isinf_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        IsinfData inliningTarget__ = s3_;
                        return MathModuleBuiltins.IsNanNode.isinf(frameValue, arg0Value, inliningTarget__, INLINED_ISINF_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.IsNanNode.isNan(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    return MathModuleBuiltins.IsNanNode.isNan(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 4;
                    return MathModuleBuiltins.IsNanNode.isNan(arg0Value_);
                }
                IsinfData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    IsinfData s3_;
                    inliningTarget__ = s3_ = (IsinfData)this.insert(new IsinfData());
                    VarHandle.storeStoreFence();
                    this.isinf_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return MathModuleBuiltins.IsNanNode.isinf(frameValue, arg0Value, inliningTarget__, INLINED_ISINF_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.IsNanNode.class)
            @DenyReplace
            private static final class IsinfData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int isinf_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node isinf_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node isinf_asDoubleNode__field2_;

                IsinfData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.IsCloseNode.class)
    public static final class IsCloseNodeFactory
    implements NodeFactory<MathModuleBuiltins.IsCloseNode> {
        private static final IsCloseNodeFactory IS_CLOSE_NODE_FACTORY_INSTANCE = new IsCloseNodeFactory();

        private IsCloseNodeFactory() {
        }

        public Class<MathModuleBuiltins.IsCloseNode> getNodeClass() {
            return MathModuleBuiltins.IsCloseNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        public MathModuleBuiltins.IsCloseNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return IsCloseNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.IsCloseNode> getInstance() {
            return IS_CLOSE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.IsCloseNode create(ReadArgumentNode[] arguments) {
            return new IsCloseNodeGen(arguments);
        }

        @GeneratedBy(value=MathModuleBuiltins.IsCloseNode.class)
        public static final class IsCloseNodeGen
        extends MathModuleBuiltins.IsCloseNode {
            private static final InlineSupport.StateField STATE_0_IsCloseNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IsCloseNode_UPDATER.subUpdater(1, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @Node.Child
            private ReadArgumentNode arguments2_;
            @Node.Child
            private ReadArgumentNode arguments3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private IsCloseNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? this.createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof Double) {
                    double arguments0Value__ = (Double)arguments0Value_;
                    if (arguments1Value_ instanceof Double) {
                        double arguments1Value__ = (Double)arguments1Value_;
                        if (arguments2Value_ instanceof Double) {
                            double arguments2Value__ = (Double)arguments2Value_;
                            if (arguments3Value_ instanceof Double) {
                                double arguments3Value__ = (Double)arguments3Value_;
                                IsCloseNodeGen inliningTarget__ = this;
                                return MathModuleBuiltins.IsCloseNode.isCloseDouble(arguments0Value__, arguments1Value__, arguments2Value__, arguments3Value__, inliningTarget__, INLINED_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                IsCloseNodeGen inliningTarget__ = null;
                if (arguments0Value instanceof Double) {
                    double arguments0Value_ = (Double)arguments0Value;
                    if (arguments1Value instanceof Double) {
                        double arguments1Value_ = (Double)arguments1Value;
                        if (arguments2Value instanceof Double) {
                            double arguments2Value_ = (Double)arguments2Value;
                            if (arguments3Value instanceof Double) {
                                double arguments3Value_ = (Double)arguments3Value;
                                inliningTarget__ = this;
                                this.state_0_ = state_0 |= 1;
                                return MathModuleBuiltins.IsCloseNode.isCloseDouble(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, inliningTarget__, INLINED_RAISE_NODE_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.LdexpNode.class)
    public static final class LdexpNodeFactory
    implements NodeFactory<MathModuleBuiltins.LdexpNode> {
        private static final LdexpNodeFactory LDEXP_NODE_FACTORY_INSTANCE = new LdexpNodeFactory();

        private LdexpNodeFactory() {
        }

        public Class<MathModuleBuiltins.LdexpNode> getNodeClass() {
            return MathModuleBuiltins.LdexpNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.LdexpNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LdexpNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.LdexpNode> getInstance() {
            return LDEXP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.LdexpNode create() {
            return new LdexpNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.LdexpNode.class)
        public static final class LdexpNodeGen
        extends MathModuleBuiltins.LdexpNode {
            private static final InlineSupport.StateField STATE_0_LdexpNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField LDEXP1__LDEXP_NODE_LDEXP1_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_state_0_");
            private static final InlineSupport.StateField LDEXP1__LDEXP_NODE_LDEXP1_STATE_1_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_state_1_");
            private static final PRaiseNode.Lazy INLINED_LDEXP0_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LdexpNode_UPDATER.subUpdater(7, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"ldexp0_raiseNode__field1_", Node.class)}));
            private static final GetClassNode INLINED_LDEXP1_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineSupport.InlineTarget.create(GetClassNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{LDEXP1__LDEXP_NODE_LDEXP1_STATE_0_UPDATER.subUpdater(0, 17), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_getClassNode__field1_", Node.class)}));
            private static final PyNumberIndexNode INLINED_LDEXP1_INDEX_NODE_ = PyNumberIndexNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{LDEXP1__LDEXP_NODE_LDEXP1_STATE_0_UPDATER.subUpdater(17, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_indexNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_indexNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_indexNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_indexNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_indexNode__field5_", Node.class)}));
            private static final CastToJavaLongLossyNode INLINED_LDEXP1_CAST_ = CastToJavaLongLossyNodeGen.inline(InlineSupport.InlineTarget.create(CastToJavaLongLossyNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{LDEXP1__LDEXP_NODE_LDEXP1_STATE_0_UPDATER.subUpdater(23, 9), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_cast__field1_", Node.class)}));
            private static final PRaiseNode.Lazy INLINED_LDEXP1_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{LDEXP1__LDEXP_NODE_LDEXP1_STATE_1_UPDATER.subUpdater(0, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Ldexp1Data.lookup_(), (String)"ldexp1_raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node ldexp0_raiseNode__field1_;
            @Node.Child
            private Ldexp1Data ldexp1_cache;

            private LdexpNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0xC) >>> 2, arg0Value)) {
                    Ldexp1Data s1_;
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0xC) >>> 2, arg0Value);
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg1Value)) {
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg1Value);
                        LdexpNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.LdexpNode.ldexp(arg0Value_, arg1Value_, inliningTarget__, INLINED_LDEXP0_RAISE_NODE_);
                    }
                    if ((state_0 & 2) != 0 && (s1_ = this.ldexp1_cache) != null && !PGuards.isInteger(arg1Value)) {
                        Ldexp1Data inliningTarget__1 = s1_;
                        return MathModuleBuiltins.LdexpNode.ldexp(frameValue, arg0Value_, arg1Value, inliningTarget__1, INLINED_LDEXP1_GET_CLASS_NODE_, s1_.isSubtypeNode_, INLINED_LDEXP1_INDEX_NODE_, INLINED_LDEXP1_CAST_, INLINED_LDEXP1_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    LdexpNodeGen inliningTarget__ = null;
                    int longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                        inliningTarget__ = this;
                        state_0 |= doubleCast0 << 2;
                        state_0 |= longCast1 << 4;
                        this.state_0_ = state_0 |= 1;
                        return MathModuleBuiltins.LdexpNode.ldexp(arg0Value_, arg1Value_, inliningTarget__, INLINED_LDEXP0_RAISE_NODE_);
                    }
                    Ldexp1Data inliningTarget__1 = null;
                    if (!PGuards.isInteger(arg1Value)) {
                        Ldexp1Data s1_;
                        inliningTarget__1 = s1_ = (Ldexp1Data)this.insert(new Ldexp1Data());
                        IsSubtypeNode isSubtypeNode__ = (IsSubtypeNode)s1_.insert(IsSubtypeNode.create());
                        Objects.requireNonNull(isSubtypeNode__, "Specialization 'ldexp(VirtualFrame, double, Object, Node, GetClassNode, IsSubtypeNode, PyNumberIndexNode, CastToJavaLongLossyNode, Lazy)' cache 'isSubtypeNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s1_.isSubtypeNode_ = isSubtypeNode__;
                        VarHandle.storeStoreFence();
                        this.ldexp1_cache = s1_;
                        state_0 |= doubleCast0 << 2;
                        this.state_0_ = state_0 |= 2;
                        return MathModuleBuiltins.LdexpNode.ldexp(frameValue, arg0Value_, arg1Value, inliningTarget__1, INLINED_LDEXP1_GET_CLASS_NODE_, isSubtypeNode__, INLINED_LDEXP1_INDEX_NODE_, INLINED_LDEXP1_CAST_, INLINED_LDEXP1_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.LdexpNode.class)
            @DenyReplace
            private static final class Ldexp1Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int ldexp1_state_0_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int ldexp1_state_1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_getClassNode__field1_;
                @Node.Child
                IsSubtypeNode isSubtypeNode_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_indexNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_indexNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_indexNode__field3_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_indexNode__field4_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_indexNode__field5_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_cast__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node ldexp1_raiseNode__field1_;

                Ldexp1Data() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.ModfNode.class)
    public static final class ModfNodeFactory
    implements NodeFactory<MathModuleBuiltins.ModfNode> {
        private static final ModfNodeFactory MODF_NODE_FACTORY_INSTANCE = new ModfNodeFactory();

        private ModfNodeFactory() {
        }

        public Class<MathModuleBuiltins.ModfNode> getNodeClass() {
            return MathModuleBuiltins.ModfNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.ModfNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ModfNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.ModfNode> getInstance() {
            return MODF_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.ModfNode create() {
            return new ModfNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.ModfNode.class)
        public static final class ModfNodeGen
        extends MathModuleBuiltins.ModfNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PythonObjectFactory factory_;

            private ModfNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    PythonObjectFactory factory__ = this.factory_;
                    if (factory__ != null) {
                        return MathModuleBuiltins.ModfNode.modfD(arg0Value_, factory__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private PTuple executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    PythonObjectFactory factory__ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                    Objects.requireNonNull(factory__, "Specialization 'modfD(double, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.ModfNode.modfD(arg0Value_, factory__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.FsumNode.class)
    public static final class FsumNodeFactory
    implements NodeFactory<MathModuleBuiltins.FsumNode> {
        private static final FsumNodeFactory FSUM_NODE_FACTORY_INSTANCE = new FsumNodeFactory();

        private FsumNodeFactory() {
        }

        public Class<MathModuleBuiltins.FsumNode> getNodeClass() {
            return MathModuleBuiltins.FsumNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.FsumNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FsumNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.FsumNode> getInstance() {
            return FSUM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.FsumNode create() {
            return new FsumNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.FsumNode.class)
        public static final class FsumNodeGen
        extends MathModuleBuiltins.FsumNode {
            private static final InlineSupport.StateField STATE_0_FsumNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField STATE_1_FsumNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final PyObjectGetIter INLINED_GET_ITER_ = PyObjectGetIterNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectGetIter.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FsumNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field2_", Node.class)}));
            private static final PyFloatAsDoubleNode INLINED_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FsumNode_UPDATER.subUpdater(3, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asDoubleNode__field2_", Node.class)}));
            private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_STOP_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FsumNode_UPDATER.subUpdater(10, 22), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"stopProfile__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"stopProfile__field2_", Node.class)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_FsumNode_UPDATER.subUpdater(0, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field2_;
            @Node.Child
            private LookupAndCallUnaryNode callNextNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asDoubleNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node stopProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node stopProfile__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private FsumNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                LookupAndCallUnaryNode callNextNode__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (callNextNode__ = this.callNextNode_) != null) {
                    FsumNodeGen inliningTarget__ = this;
                    return MathModuleBuiltins.FsumNode.doIt(frameValue, arg0Value, inliningTarget__, INLINED_GET_ITER_, callNextNode__, INLINED_AS_DOUBLE_NODE_, INLINED_STOP_PROFILE_, INLINED_RAISE_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                FsumNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                LookupAndCallUnaryNode callNextNode__ = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodSlot.Next));
                Objects.requireNonNull(callNextNode__, "Specialization 'doIt(VirtualFrame, Object, Node, PyObjectGetIter, LookupAndCallUnaryNode, PyFloatAsDoubleNode, IsBuiltinObjectProfile, Lazy)' cache 'callNextNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.callNextNode_ = callNextNode__;
                this.state_0_ = state_0 |= 1;
                return MathModuleBuiltins.FsumNode.doIt(frameValue, arg0Value, inliningTarget__, INLINED_GET_ITER_, callNextNode__, INLINED_AS_DOUBLE_NODE_, INLINED_STOP_PROFILE_, INLINED_RAISE_NODE_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.GcdNode.class)
    public static final class GcdNodeFactory
    implements NodeFactory<MathModuleBuiltins.GcdNode> {
        private static final GcdNodeFactory GCD_NODE_FACTORY_INSTANCE = new GcdNodeFactory();

        private GcdNodeFactory() {
        }

        public Class<MathModuleBuiltins.GcdNode> getNodeClass() {
            return MathModuleBuiltins.GcdNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.GcdNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GcdNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.GcdNode> getInstance() {
            return GCD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.GcdNode create() {
            return new GcdNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.GcdNode.class)
        public static final class GcdNodeGen
        extends MathModuleBuiltins.GcdNode {
            private static final InlineSupport.StateField GCD_ONE__GCD_NODE_GCD_ONE_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GcdOneData.lookup_(), (String)"gcdOne_state_0_");
            private static final PyNumberIndexNode INLINED_GCD_ONE_INDEX_NODE_ = PyNumberIndexNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GCD_ONE__GCD_NODE_GCD_ONE_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GcdOneData.lookup_(), (String)"gcdOne_indexNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GcdOneData.lookup_(), (String)"gcdOne_indexNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GcdOneData.lookup_(), (String)"gcdOne_indexNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GcdOneData.lookup_(), (String)"gcdOne_indexNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GcdOneData.lookup_(), (String)"gcdOne_indexNode__field5_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private MathModuleBuiltins.Gcd2Node gcd_gdcNode_;
            @CompilerDirectives.CompilationFinal
            private LoopConditionProfile gcd_profile_;
            @Node.Child
            private GcdOneData gcdOne_cache;

            private GcdNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    GcdOneData s1_;
                    LoopConditionProfile profile__;
                    MathModuleBuiltins.Gcd2Node gdcNode__;
                    if ((state_0 & 1) != 0 && (gdcNode__ = this.gcd_gdcNode_) != null && (profile__ = this.gcd_profile_) != null && arg1Value.length > 1 && arg2Value.length == 0) {
                        return MathModuleBuiltins.GcdNode.gcd(frameValue, arg0Value, arg1Value, arg2Value, gdcNode__, profile__);
                    }
                    if ((state_0 & 2) != 0 && (s1_ = this.gcdOne_cache) != null && arg1Value.length == 1 && arg2Value.length == 0) {
                        GcdOneData inliningTarget__ = s1_;
                        return MathModuleBuiltins.GcdNode.gcdOne(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_GCD_ONE_INDEX_NODE_, s1_.absNode_);
                    }
                    if ((state_0 & 4) != 0 && arg1Value.length == 0 && arg2Value.length == 0) {
                        return MathModuleBuiltins.GcdNode.gcdEmpty(arg0Value, arg1Value, arg2Value);
                    }
                    if ((state_0 & 8) != 0 && arg2Value.length != 0) {
                        return this.gcdKeywords(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                if (arg1Value.length > 1 && arg2Value.length == 0) {
                    MathModuleBuiltins.Gcd2Node gdcNode__ = (MathModuleBuiltins.Gcd2Node)this.insert(MathModuleBuiltins.Gcd2Node.create());
                    Objects.requireNonNull(gdcNode__, "Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Gcd2Node, LoopConditionProfile)' cache 'gdcNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.gcd_gdcNode_ = gdcNode__;
                    LoopConditionProfile profile__ = LoopConditionProfile.create();
                    Objects.requireNonNull(profile__, "Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Gcd2Node, LoopConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.gcd_profile_ = profile__;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.GcdNode.gcd(frameValue, arg0Value, arg1Value, arg2Value, gdcNode__, profile__);
                }
                GcdOneData inliningTarget__ = null;
                if (arg1Value.length == 1 && arg2Value.length == 0) {
                    GcdOneData s1_;
                    inliningTarget__ = s1_ = (GcdOneData)this.insert(new GcdOneData());
                    BuiltinFunctions.AbsNode absNode__ = (BuiltinFunctions.AbsNode)s1_.insert(BuiltinFunctionsFactory.AbsNodeFactory.create());
                    Objects.requireNonNull(absNode__, "Specialization 'gcdOne(VirtualFrame, Object, Object[], PKeyword[], Node, PyNumberIndexNode, AbsNode)' cache 'absNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s1_.absNode_ = absNode__;
                    VarHandle.storeStoreFence();
                    this.gcdOne_cache = s1_;
                    this.state_0_ = state_0 |= 2;
                    return MathModuleBuiltins.GcdNode.gcdOne(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_GCD_ONE_INDEX_NODE_, absNode__);
                }
                if (arg1Value.length == 0 && arg2Value.length == 0) {
                    this.state_0_ = state_0 |= 4;
                    return MathModuleBuiltins.GcdNode.gcdEmpty(arg0Value, arg1Value, arg2Value);
                }
                if (arg2Value.length != 0) {
                    this.state_0_ = state_0 |= 8;
                    return this.gcdKeywords(arg0Value, arg1Value, arg2Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.GcdNode.class)
            @DenyReplace
            private static final class GcdOneData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int gcdOne_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node gcdOne_indexNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node gcdOne_indexNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node gcdOne_indexNode__field3_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node gcdOne_indexNode__field4_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node gcdOne_indexNode__field5_;
                @Node.Child
                BuiltinFunctions.AbsNode absNode_;

                GcdOneData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.LcmNode.class)
    public static final class LcmNodeFactory
    implements NodeFactory<MathModuleBuiltins.LcmNode> {
        private static final LcmNodeFactory LCM_NODE_FACTORY_INSTANCE = new LcmNodeFactory();

        private LcmNodeFactory() {
        }

        public Class<MathModuleBuiltins.LcmNode> getNodeClass() {
            return MathModuleBuiltins.LcmNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.LcmNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LcmNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.LcmNode> getInstance() {
            return LCM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.LcmNode create() {
            return new LcmNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.LcmNode.class)
        public static final class LcmNodeGen
        extends MathModuleBuiltins.LcmNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyNumberIndexNode INLINED_INDEX_NODE = PyNumberIndexNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(4, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"indexNode_field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"indexNode_field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"indexNode_field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"indexNode_field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"indexNode_field5_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node indexNode_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node indexNode_field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node indexNode_field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node indexNode_field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node indexNode_field5_;
            @Node.Child
            private BuiltinFunctions.AbsNode absNode;
            @Node.Child
            private GcdData gcd_cache;

            private LcmNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    BuiltinFunctions.AbsNode absNode_1;
                    BuiltinFunctions.AbsNode absNode_;
                    GcdData s0_;
                    if ((state_0 & 1) != 0 && (s0_ = this.gcd_cache) != null && (absNode_ = this.absNode) != null && arg1Value.length > 1 && arg2Value.length == 0) {
                        LcmNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.LcmNode.gcd(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, s0_.profile_, INLINED_INDEX_NODE, s0_.gcdNode_, s0_.floorDivNode_, s0_.mulNode_, s0_.eqNode_, absNode_);
                    }
                    if ((state_0 & 2) != 0 && (absNode_1 = this.absNode) != null && arg1Value.length == 1 && arg2Value.length == 0) {
                        LcmNodeGen inliningTarget__1 = this;
                        return MathModuleBuiltins.LcmNode.gcdOne(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__1, INLINED_INDEX_NODE, absNode_1);
                    }
                    if ((state_0 & 4) != 0 && arg1Value.length == 0 && arg2Value.length == 0) {
                        return MathModuleBuiltins.LcmNode.gcdEmpty(arg0Value, arg1Value, arg2Value);
                    }
                    if ((state_0 & 8) != 0 && arg2Value.length != 0) {
                        return this.gcdKeywords(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                LcmNodeGen inliningTarget__ = null;
                if (arg1Value.length > 1 && arg2Value.length == 0) {
                    BuiltinFunctions.AbsNode absNode_;
                    GcdData s0_ = (GcdData)this.insert(new GcdData());
                    inliningTarget__ = this;
                    LoopConditionProfile profile__ = LoopConditionProfile.create();
                    Objects.requireNonNull(profile__, "Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Node, LoopConditionProfile, PyNumberIndexNode, Gcd2Node, FloorDivNode, MulNode, EqNode, AbsNode)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.profile_ = profile__;
                    MathModuleBuiltins.Gcd2Node gcdNode__ = (MathModuleBuiltins.Gcd2Node)s0_.insert(MathModuleBuiltins.Gcd2Node.create());
                    Objects.requireNonNull(gcdNode__, "Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Node, LoopConditionProfile, PyNumberIndexNode, Gcd2Node, FloorDivNode, MulNode, EqNode, AbsNode)' cache 'gcdNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.gcdNode_ = gcdNode__;
                    IntBuiltins.FloorDivNode floorDivNode__ = (IntBuiltins.FloorDivNode)s0_.insert(IntBuiltins.FloorDivNode.create());
                    Objects.requireNonNull(floorDivNode__, "Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Node, LoopConditionProfile, PyNumberIndexNode, Gcd2Node, FloorDivNode, MulNode, EqNode, AbsNode)' cache 'floorDivNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.floorDivNode_ = floorDivNode__;
                    IntBuiltins.MulNode mulNode__ = (IntBuiltins.MulNode)s0_.insert(IntBuiltins.MulNode.create());
                    Objects.requireNonNull(mulNode__, "Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Node, LoopConditionProfile, PyNumberIndexNode, Gcd2Node, FloorDivNode, MulNode, EqNode, AbsNode)' cache 'mulNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.mulNode_ = mulNode__;
                    BinaryComparisonNode.EqNode eqNode__ = (BinaryComparisonNode.EqNode)s0_.insert(BinaryComparisonNode.EqNode.create());
                    Objects.requireNonNull(eqNode__, "Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Node, LoopConditionProfile, PyNumberIndexNode, Gcd2Node, FloorDivNode, MulNode, EqNode, AbsNode)' cache 'eqNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.eqNode_ = eqNode__;
                    BuiltinFunctions.AbsNode absNode__shared = this.absNode;
                    if (absNode__shared != null) {
                        absNode_ = absNode__shared;
                    } else {
                        absNode_ = (BuiltinFunctions.AbsNode)s0_.insert(BuiltinFunctionsFactory.AbsNodeFactory.create());
                        if (absNode_ == null) {
                            throw new IllegalStateException("Specialization 'gcd(VirtualFrame, Object, Object[], PKeyword[], Node, LoopConditionProfile, PyNumberIndexNode, Gcd2Node, FloorDivNode, MulNode, EqNode, AbsNode)' contains a shared cache with name 'absNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.absNode == null) {
                        this.absNode = absNode_;
                    }
                    VarHandle.storeStoreFence();
                    this.gcd_cache = s0_;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.LcmNode.gcd(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, profile__, INLINED_INDEX_NODE, gcdNode__, floorDivNode__, mulNode__, eqNode__, absNode_);
                }
                LcmNodeGen inliningTarget__1 = null;
                if (arg1Value.length == 1 && arg2Value.length == 0) {
                    BuiltinFunctions.AbsNode absNode_1;
                    inliningTarget__1 = this;
                    BuiltinFunctions.AbsNode absNode_1_shared = this.absNode;
                    if (absNode_1_shared != null) {
                        absNode_1 = absNode_1_shared;
                    } else {
                        absNode_1 = (BuiltinFunctions.AbsNode)this.insert(BuiltinFunctionsFactory.AbsNodeFactory.create());
                        if (absNode_1 == null) {
                            throw new IllegalStateException("Specialization 'gcdOne(VirtualFrame, Object, Object[], PKeyword[], Node, PyNumberIndexNode, AbsNode)' contains a shared cache with name 'absNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.absNode == null) {
                        VarHandle.storeStoreFence();
                        this.absNode = absNode_1;
                    }
                    this.state_0_ = state_0 |= 2;
                    return MathModuleBuiltins.LcmNode.gcdOne(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__1, INLINED_INDEX_NODE, absNode_1);
                }
                if (arg1Value.length == 0 && arg2Value.length == 0) {
                    this.state_0_ = state_0 |= 4;
                    return MathModuleBuiltins.LcmNode.gcdEmpty(arg0Value, arg1Value, arg2Value);
                }
                if (arg2Value.length != 0) {
                    this.state_0_ = state_0 |= 8;
                    return this.gcdKeywords(arg0Value, arg1Value, arg2Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.LcmNode.class)
            @DenyReplace
            private static final class GcdData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                LoopConditionProfile profile_;
                @Node.Child
                MathModuleBuiltins.Gcd2Node gcdNode_;
                @Node.Child
                IntBuiltins.FloorDivNode floorDivNode_;
                @Node.Child
                IntBuiltins.MulNode mulNode_;
                @Node.Child
                BinaryComparisonNode.EqNode eqNode_;

                GcdData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.NextAfterNode.class)
    public static final class NextAfterNodeFactory
    implements NodeFactory<MathModuleBuiltins.NextAfterNode> {
        private static final NextAfterNodeFactory NEXT_AFTER_NODE_FACTORY_INSTANCE = new NextAfterNodeFactory();

        private NextAfterNodeFactory() {
        }

        public Class<MathModuleBuiltins.NextAfterNode> getNodeClass() {
            return MathModuleBuiltins.NextAfterNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.NextAfterNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NextAfterNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.NextAfterNode> getInstance() {
            return NEXT_AFTER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.NextAfterNode create() {
            return new NextAfterNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.NextAfterNode.class)
        public static final class NextAfterNodeGen
        extends MathModuleBuiltins.NextAfterNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private NextAfterNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 6) >>> 1, arg0Value)) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 6) >>> 1, arg0Value);
                    if (PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x18) >>> 3, arg1Value)) {
                        double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x18) >>> 3, arg1Value);
                        return MathModuleBuiltins.NextAfterNode.nextAfter(arg0Value_, arg1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private double executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    int doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value);
                    if (doubleCast1 != 0) {
                        double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                        state_0 |= doubleCast0 << 1;
                        state_0 |= doubleCast1 << 3;
                        this.state_0_ = state_0 |= 1;
                        return MathModuleBuiltins.NextAfterNode.nextAfter(arg0Value_, arg1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.UlpNode.class)
    public static final class UlpNodeFactory
    implements NodeFactory<MathModuleBuiltins.UlpNode> {
        private static final UlpNodeFactory ULP_NODE_FACTORY_INSTANCE = new UlpNodeFactory();

        private UlpNodeFactory() {
        }

        public Class<MathModuleBuiltins.UlpNode> getNodeClass() {
            return MathModuleBuiltins.UlpNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.UlpNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return UlpNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.UlpNode> getInstance() {
            return ULP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.UlpNode create() {
            return new UlpNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.UlpNode.class)
        public static final class UlpNodeGen
        extends MathModuleBuiltins.UlpNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private UlpNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 6) >>> 1, arg0Value)) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 6) >>> 1, arg0Value);
                    return MathModuleBuiltins.UlpNode.ulp(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private double executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 1;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.UlpNode.ulp(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.AcosNode.class)
    public static final class AcosNodeFactory
    implements NodeFactory<MathModuleBuiltins.AcosNode> {
        private static final AcosNodeFactory ACOS_NODE_FACTORY_INSTANCE = new AcosNodeFactory();

        private AcosNodeFactory() {
        }

        public Class<MathModuleBuiltins.AcosNode> getNodeClass() {
            return MathModuleBuiltins.AcosNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.AcosNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AcosNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.AcosNode> getInstance() {
            return ACOS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.AcosNode create() {
            return new AcosNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.AcosNode.class)
        public static final class AcosNodeGen
        extends MathModuleBuiltins.AcosNode {
            private static final InlineSupport.StateField GENERAL__ACOS_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ACOS_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private AcosNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.AcosNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.AcoshNode.class)
    public static final class AcoshNodeFactory
    implements NodeFactory<MathModuleBuiltins.AcoshNode> {
        private static final AcoshNodeFactory ACOSH_NODE_FACTORY_INSTANCE = new AcoshNodeFactory();

        private AcoshNodeFactory() {
        }

        public Class<MathModuleBuiltins.AcoshNode> getNodeClass() {
            return MathModuleBuiltins.AcoshNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.AcoshNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AcoshNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.AcoshNode> getInstance() {
            return ACOSH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.AcoshNode create() {
            return new AcoshNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.AcoshNode.class)
        public static final class AcoshNodeGen
        extends MathModuleBuiltins.AcoshNode {
            private static final InlineSupport.StateField STATE_0_AcoshNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_AcoshNode_UPDATER.subUpdater(9, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field2_;

            private AcoshNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        AcoshNodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        AcoshNodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                AcoshNodeGen inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 4;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return this.doPI(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.AsinNode.class)
    public static final class AsinNodeFactory
    implements NodeFactory<MathModuleBuiltins.AsinNode> {
        private static final AsinNodeFactory ASIN_NODE_FACTORY_INSTANCE = new AsinNodeFactory();

        private AsinNodeFactory() {
        }

        public Class<MathModuleBuiltins.AsinNode> getNodeClass() {
            return MathModuleBuiltins.AsinNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.AsinNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AsinNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.AsinNode> getInstance() {
            return ASIN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.AsinNode create() {
            return new AsinNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.AsinNode.class)
        public static final class AsinNodeGen
        extends MathModuleBuiltins.AsinNode {
            private static final InlineSupport.StateField GENERAL__ASIN_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ASIN_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private AsinNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.AsinNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.CosNode.class)
    public static final class CosNodeFactory
    implements NodeFactory<MathModuleBuiltins.CosNode> {
        private static final CosNodeFactory COS_NODE_FACTORY_INSTANCE = new CosNodeFactory();

        private CosNodeFactory() {
        }

        public Class<MathModuleBuiltins.CosNode> getNodeClass() {
            return MathModuleBuiltins.CosNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.CosNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CosNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.CosNode> getInstance() {
            return COS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.CosNode create() {
            return new CosNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.CosNode.class)
        public static final class CosNodeGen
        extends MathModuleBuiltins.CosNode {
            private static final InlineSupport.StateField GENERAL__COS_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__COS_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private CosNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.CosNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.CoshNode.class)
    public static final class CoshNodeFactory
    implements NodeFactory<MathModuleBuiltins.CoshNode> {
        private static final CoshNodeFactory COSH_NODE_FACTORY_INSTANCE = new CoshNodeFactory();

        private CoshNodeFactory() {
        }

        public Class<MathModuleBuiltins.CoshNode> getNodeClass() {
            return MathModuleBuiltins.CoshNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.CoshNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CoshNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.CoshNode> getInstance() {
            return COSH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.CoshNode create() {
            return new CoshNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.CoshNode.class)
        public static final class CoshNodeGen
        extends MathModuleBuiltins.CoshNode {
            private static final InlineSupport.StateField GENERAL__COSH_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__COSH_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private CoshNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.CoshNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.SinNode.class)
    public static final class SinNodeFactory
    implements NodeFactory<MathModuleBuiltins.SinNode> {
        private static final SinNodeFactory SIN_NODE_FACTORY_INSTANCE = new SinNodeFactory();

        private SinNodeFactory() {
        }

        public Class<MathModuleBuiltins.SinNode> getNodeClass() {
            return MathModuleBuiltins.SinNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.SinNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return SinNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.SinNode> getInstance() {
            return SIN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.SinNode create() {
            return new SinNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.SinNode.class)
        public static final class SinNodeGen
        extends MathModuleBuiltins.SinNode {
            private static final InlineSupport.StateField GENERAL__SIN_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__SIN_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private SinNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.SinNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.SinhNode.class)
    public static final class SinhNodeFactory
    implements NodeFactory<MathModuleBuiltins.SinhNode> {
        private static final SinhNodeFactory SINH_NODE_FACTORY_INSTANCE = new SinhNodeFactory();

        private SinhNodeFactory() {
        }

        public Class<MathModuleBuiltins.SinhNode> getNodeClass() {
            return MathModuleBuiltins.SinhNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.SinhNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return SinhNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.SinhNode> getInstance() {
            return SINH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.SinhNode create() {
            return new SinhNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.SinhNode.class)
        public static final class SinhNodeGen
        extends MathModuleBuiltins.SinhNode {
            private static final InlineSupport.StateField GENERAL__SINH_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__SINH_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private SinhNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.SinhNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.TanNode.class)
    public static final class TanNodeFactory
    implements NodeFactory<MathModuleBuiltins.TanNode> {
        private static final TanNodeFactory TAN_NODE_FACTORY_INSTANCE = new TanNodeFactory();

        private TanNodeFactory() {
        }

        public Class<MathModuleBuiltins.TanNode> getNodeClass() {
            return MathModuleBuiltins.TanNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.TanNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return TanNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.TanNode> getInstance() {
            return TAN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.TanNode create() {
            return new TanNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.TanNode.class)
        public static final class TanNodeGen
        extends MathModuleBuiltins.TanNode {
            private static final InlineSupport.StateField GENERAL__TAN_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__TAN_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private TanNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.TanNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.TanhNode.class)
    public static final class TanhNodeFactory
    implements NodeFactory<MathModuleBuiltins.TanhNode> {
        private static final TanhNodeFactory TANH_NODE_FACTORY_INSTANCE = new TanhNodeFactory();

        private TanhNodeFactory() {
        }

        public Class<MathModuleBuiltins.TanhNode> getNodeClass() {
            return MathModuleBuiltins.TanhNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.TanhNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return TanhNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.TanhNode> getInstance() {
            return TANH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.TanhNode create() {
            return new TanhNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.TanhNode.class)
        public static final class TanhNodeGen
        extends MathModuleBuiltins.TanhNode {
            private static final InlineSupport.StateField GENERAL__TANH_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__TANH_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private TanhNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.TanhNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.AtanNode.class)
    public static final class AtanNodeFactory
    implements NodeFactory<MathModuleBuiltins.AtanNode> {
        private static final AtanNodeFactory ATAN_NODE_FACTORY_INSTANCE = new AtanNodeFactory();

        private AtanNodeFactory() {
        }

        public Class<MathModuleBuiltins.AtanNode> getNodeClass() {
            return MathModuleBuiltins.AtanNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.AtanNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AtanNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.AtanNode> getInstance() {
            return ATAN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.AtanNode create() {
            return new AtanNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.AtanNode.class)
        public static final class AtanNodeGen
        extends MathModuleBuiltins.AtanNode {
            private static final InlineSupport.StateField GENERAL__ATAN_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ATAN_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private AtanNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.AtanNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.AtanhNode.class)
    public static final class AtanhNodeFactory
    implements NodeFactory<MathModuleBuiltins.AtanhNode> {
        private static final AtanhNodeFactory ATANH_NODE_FACTORY_INSTANCE = new AtanhNodeFactory();

        private AtanhNodeFactory() {
        }

        public Class<MathModuleBuiltins.AtanhNode> getNodeClass() {
            return MathModuleBuiltins.AtanhNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.AtanhNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AtanhNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.AtanhNode> getInstance() {
            return ATANH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.AtanhNode create() {
            return new AtanhNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.AtanhNode.class)
        public static final class AtanhNodeGen
        extends MathModuleBuiltins.AtanhNode {
            private static final InlineSupport.StateField GENERAL__ATANH_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ATANH_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private AtanhNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.AtanhNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.AsinhNode.class)
    public static final class AsinhNodeFactory
    implements NodeFactory<MathModuleBuiltins.AsinhNode> {
        private static final AsinhNodeFactory ASINH_NODE_FACTORY_INSTANCE = new AsinhNodeFactory();

        private AsinhNodeFactory() {
        }

        public Class<MathModuleBuiltins.AsinhNode> getNodeClass() {
            return MathModuleBuiltins.AsinhNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.AsinhNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AsinhNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.AsinhNode> getInstance() {
            return ASINH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.AsinhNode create() {
            return new AsinhNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.AsinhNode.class)
        public static final class AsinhNodeGen
        extends MathModuleBuiltins.AsinhNode {
            private static final InlineSupport.StateField GENERAL__ASINH_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ASINH_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private AsinhNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.AsinhNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.IsFiniteNode.class)
    public static final class IsFiniteNodeFactory
    implements NodeFactory<MathModuleBuiltins.IsFiniteNode> {
        private static final IsFiniteNodeFactory IS_FINITE_NODE_FACTORY_INSTANCE = new IsFiniteNodeFactory();

        private IsFiniteNodeFactory() {
        }

        public Class<MathModuleBuiltins.IsFiniteNode> getNodeClass() {
            return MathModuleBuiltins.IsFiniteNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.IsFiniteNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IsFiniteNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.IsFiniteNode> getInstance() {
            return IS_FINITE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.IsFiniteNode create() {
            return new IsFiniteNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.IsFiniteNode.class)
        public static final class IsFiniteNodeGen
        extends MathModuleBuiltins.IsFiniteNode {
            private static final InlineSupport.StateField ISINF__IS_FINITE_NODE_ISINF_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)IsinfData.lookup_(), (String)"isinf_state_0_");
            private static final PyFloatAsDoubleNode INLINED_ISINF_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{ISINF__IS_FINITE_NODE_ISINF_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)IsinfData.lookup_(), (String)"isinf_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)IsinfData.lookup_(), (String)"isinf_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private IsinfData isinf_cache;

            private IsFiniteNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    IsinfData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.isfinite(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.isfinite(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return MathModuleBuiltins.IsFiniteNode.isfinite(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.isinf_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        IsinfData inliningTarget__ = s3_;
                        return MathModuleBuiltins.IsFiniteNode.isinf(frameValue, arg0Value, inliningTarget__, INLINED_ISINF_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.isfinite(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    return this.isfinite(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 4;
                    return MathModuleBuiltins.IsFiniteNode.isfinite(arg0Value_);
                }
                IsinfData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    IsinfData s3_;
                    inliningTarget__ = s3_ = (IsinfData)this.insert(new IsinfData());
                    VarHandle.storeStoreFence();
                    this.isinf_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return MathModuleBuiltins.IsFiniteNode.isinf(frameValue, arg0Value, inliningTarget__, INLINED_ISINF_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.IsFiniteNode.class)
            @DenyReplace
            private static final class IsinfData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int isinf_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node isinf_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node isinf_asDoubleNode__field2_;

                IsinfData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.IsInfNode.class)
    public static final class IsInfNodeFactory
    implements NodeFactory<MathModuleBuiltins.IsInfNode> {
        private static final IsInfNodeFactory IS_INF_NODE_FACTORY_INSTANCE = new IsInfNodeFactory();

        private IsInfNodeFactory() {
        }

        public Class<MathModuleBuiltins.IsInfNode> getNodeClass() {
            return MathModuleBuiltins.IsInfNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.IsInfNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IsInfNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.IsInfNode> getInstance() {
            return IS_INF_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.IsInfNode create() {
            return new IsInfNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.IsInfNode.class)
        public static final class IsInfNodeGen
        extends MathModuleBuiltins.IsInfNode {
            private static final InlineSupport.StateField ISINF3__IS_INF_NODE_ISINF3_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Isinf3Data.lookup_(), (String)"isinf3_state_0_");
            private static final PyFloatAsDoubleNode INLINED_ISINF3_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{ISINF3__IS_INF_NODE_ISINF3_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Isinf3Data.lookup_(), (String)"isinf3_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Isinf3Data.lookup_(), (String)"isinf3_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private Isinf3Data isinf3_cache;

            private IsInfNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    Isinf3Data s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return MathModuleBuiltins.IsInfNode.isinf(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return MathModuleBuiltins.IsInfNode.isinf(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return MathModuleBuiltins.IsInfNode.isinf(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.isinf3_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        Isinf3Data inliningTarget__ = s3_;
                        return MathModuleBuiltins.IsInfNode.isinf(frameValue, arg0Value, inliningTarget__, INLINED_ISINF3_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.IsInfNode.isinf(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    return MathModuleBuiltins.IsInfNode.isinf(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 4;
                    return MathModuleBuiltins.IsInfNode.isinf(arg0Value_);
                }
                Isinf3Data inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    Isinf3Data s3_;
                    inliningTarget__ = s3_ = (Isinf3Data)this.insert(new Isinf3Data());
                    VarHandle.storeStoreFence();
                    this.isinf3_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return MathModuleBuiltins.IsInfNode.isinf(frameValue, arg0Value, inliningTarget__, INLINED_ISINF3_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.IsInfNode.class)
            @DenyReplace
            private static final class Isinf3Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int isinf3_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node isinf3_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node isinf3_asDoubleNode__field2_;

                Isinf3Data() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.LogNode.class)
    public static final class LogNodeFactory
    implements NodeFactory<MathModuleBuiltins.LogNode> {
        private static final LogNodeFactory LOG_NODE_FACTORY_INSTANCE = new LogNodeFactory();

        private LogNodeFactory() {
        }

        public Class<MathModuleBuiltins.LogNode> getNodeClass() {
            return MathModuleBuiltins.LogNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.LogNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LogNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.LogNode> getInstance() {
            return LOG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.LogNode create() {
            return new LogNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.LogNode.class)
        public static final class LogNodeGen
        extends MathModuleBuiltins.LogNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField STATE_1_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlinedConditionProfile INLINED_DO_NOT_FIT = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(27, 2)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(29, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode_field1_", Node.class)}));
            private static final InlinedConditionProfile INLINED_DIV_BY_ZERO = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(30, 2)}));
            private static final PyFloatAsDoubleNode INLINED_AS_DOUBLE_NODE = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asDoubleNode_field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asDoubleNode_field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asDoubleNode_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asDoubleNode_field2_;

            private LogNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1FFFF) != 0) {
                    PythonAbstractObject arg1Value_;
                    if ((state_0 & 7) != 0 && arg1Value instanceof PNone) {
                        arg1Value_ = (PNone)arg1Value;
                        if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__ = this;
                            return MathModuleBuiltins.LogNode.log(arg0Value_, arg1Value_, inliningTarget__, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            LogNodeGen inliningTarget__1 = this;
                            return MathModuleBuiltins.LogNode.logDN(arg0Value_, arg1Value_, inliningTarget__1, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            LogNodeGen inliningTarget__2 = this;
                            return MathModuleBuiltins.LogNode.logPIN(arg0Value_, arg1Value_, inliningTarget__2, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x18) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                        long arg1Value_2 = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                        if ((state_0 & 8) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__3 = this;
                            return MathModuleBuiltins.LogNode.logLL(arg0Value_, arg1Value_2, inliningTarget__3, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x10) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            LogNodeGen inliningTarget__4 = this;
                            return MathModuleBuiltins.LogNode.logDL(arg0Value_, arg1Value_2, inliningTarget__4, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x60) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value)) {
                        double arg1Value_3 = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value);
                        if ((state_0 & 0x20) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__5 = this;
                            return MathModuleBuiltins.LogNode.logLD(arg0Value_, arg1Value_3, inliningTarget__5, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x40) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            LogNodeGen inliningTarget__6 = this;
                            return MathModuleBuiltins.LogNode.logDD(arg0Value_, arg1Value_3, inliningTarget__6, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x80) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_4 = (PInt)arg1Value;
                            LogNodeGen inliningTarget__7 = this;
                            return MathModuleBuiltins.LogNode.logDPI(arg0Value_, arg1Value_4, inliningTarget__7, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x300) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x100) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                            long arg1Value_5 = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                            LogNodeGen inliningTarget__8 = this;
                            return MathModuleBuiltins.LogNode.logPIL(arg0Value_, arg1Value_5, inliningTarget__8, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x200) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value)) {
                            double arg1Value_6 = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value);
                            LogNodeGen inliningTarget__9 = this;
                            return MathModuleBuiltins.LogNode.logPID(arg0Value_, arg1Value_6, inliningTarget__9, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xC00) != 0 && arg1Value instanceof PInt) {
                        arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x400) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__10 = this;
                            return MathModuleBuiltins.LogNode.logLPI(arg0Value_, (PInt)arg1Value_, inliningTarget__10, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x800) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            LogNodeGen inliningTarget__11 = this;
                            return MathModuleBuiltins.LogNode.logPIPI(arg0Value_, (PInt)arg1Value_, inliningTarget__11, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x3000) != 0) {
                        if ((state_0 & 0x1000) != 0 && arg1Value instanceof PNone) {
                            arg1Value_ = (PNone)arg1Value;
                            if (!MathGuards.isNumber(arg0Value)) {
                                LogNodeGen inliningTarget__12 = this;
                                return this.logO(frameValue, arg0Value, (PNone)arg1Value_, inliningTarget__12, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                        if ((state_0 & 0x2000) != 0 && !MathGuards.isNumber(arg0Value) && !PGuards.isNoValue(arg1Value)) {
                            LogNodeGen inliningTarget__13 = this;
                            return this.logOO(frameValue, arg0Value, arg1Value, inliningTarget__13, INLINED_AS_DOUBLE_NODE);
                        }
                    }
                    if ((state_0 & 0x1C000) != 0) {
                        if ((state_0 & 0x4000) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            if (!MathGuards.isNumber(arg1Value)) {
                                LogNodeGen inliningTarget__14 = this;
                                return this.logLO(frameValue, arg0Value_, arg1Value, inliningTarget__14, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                        if ((state_0 & 0x8000) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            if (!MathGuards.isNumber(arg1Value)) {
                                LogNodeGen inliningTarget__15 = this;
                                return this.logDO(frameValue, arg0Value_, arg1Value, inliningTarget__15, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                        if ((state_0 & 0x10000) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if (!MathGuards.isNumber(arg1Value)) {
                                LogNodeGen inliningTarget__16 = this;
                                return this.logPIO(frameValue, arg0Value_, arg1Value, inliningTarget__16, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1FFFF) != 0) {
                    PythonAbstractObject arg1Value_;
                    if ((state_0 & 7) != 0 && arg1Value instanceof PNone) {
                        arg1Value_ = (PNone)arg1Value;
                        if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__ = this;
                            return MathModuleBuiltins.LogNode.log(arg0Value_, arg1Value_, inliningTarget__, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            LogNodeGen inliningTarget__1 = this;
                            return MathModuleBuiltins.LogNode.logDN(arg0Value_, arg1Value_, inliningTarget__1, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            LogNodeGen inliningTarget__2 = this;
                            return MathModuleBuiltins.LogNode.logPIN(arg0Value_, arg1Value_, inliningTarget__2, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x18) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                        long arg1Value_2 = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                        if ((state_0 & 8) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__3 = this;
                            return MathModuleBuiltins.LogNode.logLL(arg0Value_, arg1Value_2, inliningTarget__3, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x10) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            LogNodeGen inliningTarget__4 = this;
                            return MathModuleBuiltins.LogNode.logDL(arg0Value_, arg1Value_2, inliningTarget__4, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x60) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value)) {
                        double arg1Value_3 = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value);
                        if ((state_0 & 0x20) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__5 = this;
                            return MathModuleBuiltins.LogNode.logLD(arg0Value_, arg1Value_3, inliningTarget__5, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x40) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            LogNodeGen inliningTarget__6 = this;
                            return MathModuleBuiltins.LogNode.logDD(arg0Value_, arg1Value_3, inliningTarget__6, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x80) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_4 = (PInt)arg1Value;
                            LogNodeGen inliningTarget__7 = this;
                            return MathModuleBuiltins.LogNode.logDPI(arg0Value_, arg1Value_4, inliningTarget__7, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x300) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x100) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                            long arg1Value_5 = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                            LogNodeGen inliningTarget__8 = this;
                            return MathModuleBuiltins.LogNode.logPIL(arg0Value_, arg1Value_5, inliningTarget__8, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x200) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value)) {
                            double arg1Value_6 = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x6000000) >>> 25, arg1Value);
                            LogNodeGen inliningTarget__9 = this;
                            return MathModuleBuiltins.LogNode.logPID(arg0Value_, arg1Value_6, inliningTarget__9, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xC00) != 0 && arg1Value instanceof PInt) {
                        arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x400) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            LogNodeGen inliningTarget__10 = this;
                            return MathModuleBuiltins.LogNode.logLPI(arg0Value_, (PInt)arg1Value_, inliningTarget__10, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x800) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            LogNodeGen inliningTarget__11 = this;
                            return MathModuleBuiltins.LogNode.logPIPI(arg0Value_, (PInt)arg1Value_, inliningTarget__11, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x3000) != 0) {
                        if ((state_0 & 0x1000) != 0 && arg1Value instanceof PNone) {
                            arg1Value_ = (PNone)arg1Value;
                            if (!MathGuards.isNumber(arg0Value)) {
                                LogNodeGen inliningTarget__12 = this;
                                return this.logO(frameValue, arg0Value, (PNone)arg1Value_, inliningTarget__12, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                        if ((state_0 & 0x2000) != 0 && !MathGuards.isNumber(arg0Value) && !PGuards.isNoValue(arg1Value)) {
                            LogNodeGen inliningTarget__13 = this;
                            return this.logOO(frameValue, arg0Value, arg1Value, inliningTarget__13, INLINED_AS_DOUBLE_NODE);
                        }
                    }
                    if ((state_0 & 0x1C000) != 0) {
                        if ((state_0 & 0x4000) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg0Value);
                            if (!MathGuards.isNumber(arg1Value)) {
                                LogNodeGen inliningTarget__14 = this;
                                return this.logLO(frameValue, arg0Value_, arg1Value, inliningTarget__14, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                        if ((state_0 & 0x8000) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x300000) >>> 20, arg0Value);
                            if (!MathGuards.isNumber(arg1Value)) {
                                LogNodeGen inliningTarget__15 = this;
                                return this.logDO(frameValue, arg0Value_, arg1Value, inliningTarget__15, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                        if ((state_0 & 0x10000) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if (!MathGuards.isNumber(arg1Value)) {
                                LogNodeGen inliningTarget__16 = this;
                                return this.logPIO(frameValue, arg0Value_, arg1Value, inliningTarget__16, INLINED_AS_DOUBLE_NODE);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int doubleCast1;
                int doubleCast0;
                int longCast0;
                int longCast1;
                int state_0 = this.state_0_;
                if (arg1Value instanceof PNone) {
                    PNone arg1Value_ = (PNone)arg1Value;
                    LogNodeGen inliningTarget__ = null;
                    int longCast02 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast02 != 0) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast02, arg0Value);
                        inliningTarget__ = this;
                        state_0 |= longCast02 << 17;
                        this.state_0_ = state_0 |= 1;
                        return MathModuleBuiltins.LogNode.log(arg0Value_, arg1Value_, inliningTarget__, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                    }
                    LogNodeGen inliningTarget__1 = null;
                    int doubleCast02 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                    if (doubleCast02 != 0) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast02, arg0Value);
                        inliningTarget__1 = this;
                        state_0 |= doubleCast02 << 20;
                        this.state_0_ = state_0 |= 2;
                        return MathModuleBuiltins.LogNode.logDN(arg0Value_, arg1Value_, inliningTarget__1, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                    }
                    LogNodeGen inliningTarget__2 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        inliningTarget__2 = this;
                        this.state_0_ = state_0 |= 4;
                        return MathModuleBuiltins.LogNode.logPIN(arg0Value_, arg1Value_, inliningTarget__2, INLINED_DO_NOT_FIT, INLINED_RAISE_NODE);
                    }
                }
                if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                    LogNodeGen inliningTarget__3 = null;
                    longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                        inliningTarget__3 = this;
                        state_0 |= longCast0 << 17;
                        state_0 |= longCast1 << 22;
                        this.state_0_ = state_0 |= 8;
                        return MathModuleBuiltins.LogNode.logLL(arg0Value_, arg1Value_, inliningTarget__3, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                    LogNodeGen inliningTarget__4 = null;
                    doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                    if (doubleCast0 != 0) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                        inliningTarget__4 = this;
                        state_0 |= doubleCast0 << 20;
                        state_0 |= longCast1 << 22;
                        this.state_0_ = state_0 |= 0x10;
                        return MathModuleBuiltins.LogNode.logDL(arg0Value_, arg1Value_, inliningTarget__4, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                }
                if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                    double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                    LogNodeGen inliningTarget__5 = null;
                    longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                        inliningTarget__5 = this;
                        state_0 |= longCast0 << 17;
                        state_0 |= doubleCast1 << 25;
                        this.state_0_ = state_0 |= 0x20;
                        return MathModuleBuiltins.LogNode.logLD(arg0Value_, arg1Value_, inliningTarget__5, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                    LogNodeGen inliningTarget__6 = null;
                    doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                    if (doubleCast0 != 0) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                        inliningTarget__6 = this;
                        state_0 |= doubleCast0 << 20;
                        state_0 |= doubleCast1 << 25;
                        this.state_0_ = state_0 |= 0x40;
                        return MathModuleBuiltins.LogNode.logDD(arg0Value_, arg1Value_, inliningTarget__6, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                }
                LogNodeGen inliningTarget__7 = null;
                int doubleCast03 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast03 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast03, arg0Value);
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        inliningTarget__7 = this;
                        state_0 |= doubleCast03 << 20;
                        this.state_0_ = state_0 |= 0x80;
                        return MathModuleBuiltins.LogNode.logDPI(arg0Value_, arg1Value_, inliningTarget__7, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    LogNodeGen inliningTarget__8 = null;
                    int longCast12 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast12 != 0) {
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast12, arg1Value);
                        inliningTarget__8 = this;
                        state_0 |= longCast12 << 22;
                        this.state_0_ = state_0 |= 0x100;
                        return MathModuleBuiltins.LogNode.logPIL(arg0Value_, arg1Value_, inliningTarget__8, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                    LogNodeGen inliningTarget__9 = null;
                    int doubleCast12 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value);
                    if (doubleCast12 != 0) {
                        double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast12, arg1Value);
                        inliningTarget__9 = this;
                        state_0 |= doubleCast12 << 25;
                        this.state_0_ = state_0 |= 0x200;
                        return MathModuleBuiltins.LogNode.logPID(arg0Value_, arg1Value_, inliningTarget__9, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    LogNodeGen inliningTarget__10 = null;
                    int longCast03 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast03 != 0) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast03, arg0Value);
                        inliningTarget__10 = this;
                        state_0 |= longCast03 << 17;
                        this.state_0_ = state_0 |= 0x400;
                        return MathModuleBuiltins.LogNode.logLPI(arg0Value_, arg1Value_, inliningTarget__10, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                    LogNodeGen inliningTarget__11 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        inliningTarget__11 = this;
                        this.state_0_ = state_0 |= 0x800;
                        return MathModuleBuiltins.LogNode.logPIPI(arg0Value_, arg1Value_, inliningTarget__11, INLINED_DO_NOT_FIT, INLINED_DIV_BY_ZERO, INLINED_RAISE_NODE);
                    }
                }
                LogNodeGen inliningTarget__12 = null;
                if (arg1Value instanceof PNone) {
                    PNone arg1Value_ = (PNone)arg1Value;
                    if (!MathGuards.isNumber(arg0Value)) {
                        inliningTarget__12 = this;
                        this.state_0_ = state_0 |= 0x1000;
                        return this.logO(frameValue, arg0Value, arg1Value_, inliningTarget__12, INLINED_AS_DOUBLE_NODE);
                    }
                }
                LogNodeGen inliningTarget__13 = null;
                if (!MathGuards.isNumber(arg0Value) && !PGuards.isNoValue(arg1Value)) {
                    inliningTarget__13 = this;
                    this.state_0_ = state_0 |= 0x2000;
                    return this.logOO(frameValue, arg0Value, arg1Value, inliningTarget__13, INLINED_AS_DOUBLE_NODE);
                }
                LogNodeGen inliningTarget__14 = null;
                int longCast04 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast04 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast04, arg0Value);
                    if (!MathGuards.isNumber(arg1Value)) {
                        inliningTarget__14 = this;
                        state_0 |= longCast04 << 17;
                        this.state_0_ = state_0 |= 0x4000;
                        return this.logLO(frameValue, arg0Value_, arg1Value, inliningTarget__14, INLINED_AS_DOUBLE_NODE);
                    }
                }
                LogNodeGen inliningTarget__15 = null;
                doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    if (!MathGuards.isNumber(arg1Value)) {
                        inliningTarget__15 = this;
                        state_0 |= doubleCast0 << 20;
                        this.state_0_ = state_0 |= 0x8000;
                        return this.logDO(frameValue, arg0Value_, arg1Value, inliningTarget__15, INLINED_AS_DOUBLE_NODE);
                    }
                }
                LogNodeGen inliningTarget__16 = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    if (!MathGuards.isNumber(arg1Value)) {
                        inliningTarget__16 = this;
                        this.state_0_ = state_0 |= 0x10000;
                        return this.logPIO(frameValue, arg0Value_, arg1Value, inliningTarget__16, INLINED_AS_DOUBLE_NODE);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1FFFF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                int counter = 0;
                if ((counter += Integer.bitCount(state_0 & 0x1FFFF)) == 1) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.Log1pNode.class)
    public static final class Log1pNodeFactory
    implements NodeFactory<MathModuleBuiltins.Log1pNode> {
        private static final Log1pNodeFactory LOG1P_NODE_FACTORY_INSTANCE = new Log1pNodeFactory();

        private Log1pNodeFactory() {
        }

        public Class<MathModuleBuiltins.Log1pNode> getNodeClass() {
            return MathModuleBuiltins.Log1pNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.Log1pNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return Log1pNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.Log1pNode> getInstance() {
            return LOG1P_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.Log1pNode create() {
            return new Log1pNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.Log1pNode.class)
        public static final class Log1pNodeGen
        extends MathModuleBuiltins.Log1pNode {
            private static final InlineSupport.StateField GENERAL__LOG1P_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__LOG1P_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private Log1pNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.Log1pNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.Log2Node.class)
    public static final class Log2NodeFactory
    implements NodeFactory<MathModuleBuiltins.Log2Node> {
        private static final Log2NodeFactory LOG2_NODE_FACTORY_INSTANCE = new Log2NodeFactory();

        private Log2NodeFactory() {
        }

        public Class<MathModuleBuiltins.Log2Node> getNodeClass() {
            return MathModuleBuiltins.Log2Node.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.Log2Node createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return Log2NodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.Log2Node> getInstance() {
            return LOG2_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.Log2Node create() {
            return new Log2NodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.Log2Node.class)
        public static final class Log2NodeGen
        extends MathModuleBuiltins.Log2Node {
            private static final InlineSupport.StateField STATE_0_Log2Node_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_Log2Node_UPDATER.subUpdater(9, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field2_;

            private Log2NodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        Log2NodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        Log2NodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                Log2NodeGen inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 4;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return this.doPI(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.Log10Node.class)
    public static final class Log10NodeFactory
    implements NodeFactory<MathModuleBuiltins.Log10Node> {
        private static final Log10NodeFactory LOG10_NODE_FACTORY_INSTANCE = new Log10NodeFactory();

        private Log10NodeFactory() {
        }

        public Class<MathModuleBuiltins.Log10Node> getNodeClass() {
            return MathModuleBuiltins.Log10Node.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.Log10Node createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return Log10NodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.Log10Node> getInstance() {
            return LOG10_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.Log10Node create() {
            return new Log10NodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.Log10Node.class)
        public static final class Log10NodeGen
        extends MathModuleBuiltins.Log10Node {
            private static final InlineSupport.StateField STATE_0_Log10Node_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_Log10Node_UPDATER.subUpdater(9, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field2_;

            private Log10NodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        Log10NodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && !MathGuards.isNumber(arg0Value)) {
                        Log10NodeGen inliningTarget__ = this;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                Log10NodeGen inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 4;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return this.doPI(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.FabsNode.class)
    public static final class FabsNodeFactory
    implements NodeFactory<MathModuleBuiltins.FabsNode> {
        private static final FabsNodeFactory FABS_NODE_FACTORY_INSTANCE = new FabsNodeFactory();

        private FabsNodeFactory() {
        }

        public Class<MathModuleBuiltins.FabsNode> getNodeClass() {
            return MathModuleBuiltins.FabsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.FabsNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FabsNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.FabsNode> getInstance() {
            return FABS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.FabsNode create() {
            return new FabsNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.FabsNode.class)
        public static final class FabsNodeGen
        extends MathModuleBuiltins.FabsNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private FabsNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    return this.fabs(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private double executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.fabs(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.PowNode.class)
    public static final class PowNodeFactory
    implements NodeFactory<MathModuleBuiltins.PowNode> {
        private static final PowNodeFactory POW_NODE_FACTORY_INSTANCE = new PowNodeFactory();

        private PowNodeFactory() {
        }

        public Class<MathModuleBuiltins.PowNode> getNodeClass() {
            return MathModuleBuiltins.PowNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.PowNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return PowNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.PowNode> getInstance() {
            return POW_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.PowNode create() {
            return new PowNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.PowNode.class)
        public static final class PowNodeGen
        extends MathModuleBuiltins.PowNode {
            private static final InlineSupport.StateField STATE_0_PowNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_PowNode_UPDATER.subUpdater(1, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private PowNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        PowNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.PowNode.pow(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private double executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                PowNodeGen inliningTarget__ = null;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        inliningTarget__ = this;
                        this.state_0_ = state_0 |= 1;
                        return MathModuleBuiltins.PowNode.pow(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.TruncNode.class)
    public static final class TruncNodeFactory
    implements NodeFactory<MathModuleBuiltins.TruncNode> {
        private static final TruncNodeFactory TRUNC_NODE_FACTORY_INSTANCE = new TruncNodeFactory();

        private TruncNodeFactory() {
        }

        public Class<MathModuleBuiltins.TruncNode> getNodeClass() {
            return MathModuleBuiltins.TruncNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.TruncNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return TruncNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.TruncNode> getInstance() {
            return TRUNC_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.TruncNode create() {
            return new TruncNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.TruncNode.class)
        public static final class TruncNodeGen
        extends MathModuleBuiltins.TruncNode {
            private static final InlineSupport.StateField STATE_0_TruncNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_TruncNode_UPDATER.subUpdater(1, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private LookupAndCallUnaryNode callTrunc_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private TruncNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                LookupAndCallUnaryNode callTrunc__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (callTrunc__ = this.callTrunc_) != null) {
                    TruncNodeGen inliningTarget__ = this;
                    return MathModuleBuiltins.TruncNode.trunc(frameValue, arg0Value, inliningTarget__, callTrunc__, INLINED_RAISE_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                TruncNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                LookupAndCallUnaryNode callTrunc__ = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodNames.T___TRUNC__));
                Objects.requireNonNull(callTrunc__, "Specialization 'trunc(VirtualFrame, Object, Node, LookupAndCallUnaryNode, Lazy)' cache 'callTrunc' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.callTrunc_ = callTrunc__;
                this.state_0_ = state_0 |= 1;
                return MathModuleBuiltins.TruncNode.trunc(frameValue, arg0Value, inliningTarget__, callTrunc__, INLINED_RAISE_NODE_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.Atan2Node.class)
    public static final class Atan2NodeFactory
    implements NodeFactory<MathModuleBuiltins.Atan2Node> {
        private static final Atan2NodeFactory ATAN2_NODE_FACTORY_INSTANCE = new Atan2NodeFactory();

        private Atan2NodeFactory() {
        }

        public Class<MathModuleBuiltins.Atan2Node> getNodeClass() {
            return MathModuleBuiltins.Atan2Node.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.Atan2Node createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return Atan2NodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.Atan2Node> getInstance() {
            return ATAN2_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.Atan2Node create() {
            return new Atan2NodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.Atan2Node.class)
        public static final class Atan2NodeGen
        extends MathModuleBuiltins.Atan2Node {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private Atan2NodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        return this.atan2DD(arg0Value_, arg1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private double executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Double) {
                    double arg0Value_ = (Double)arg0Value;
                    if (arg1Value instanceof Double) {
                        double arg1Value_ = (Double)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.atan2DD(arg0Value_, arg1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.DegreesNode.class)
    public static final class DegreesNodeFactory
    implements NodeFactory<MathModuleBuiltins.DegreesNode> {
        private static final DegreesNodeFactory DEGREES_NODE_FACTORY_INSTANCE = new DegreesNodeFactory();

        private DegreesNodeFactory() {
        }

        public Class<MathModuleBuiltins.DegreesNode> getNodeClass() {
            return MathModuleBuiltins.DegreesNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.DegreesNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return DegreesNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.DegreesNode> getInstance() {
            return DEGREES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.DegreesNode create() {
            return new DegreesNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.DegreesNode.class)
        public static final class DegreesNodeGen
        extends MathModuleBuiltins.DegreesNode {
            private static final InlineSupport.StateField GENERAL__DEGREES_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__DEGREES_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private DegreesNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.DegreesNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.RadiansNode.class)
    public static final class RadiansNodeFactory
    implements NodeFactory<MathModuleBuiltins.RadiansNode> {
        private static final RadiansNodeFactory RADIANS_NODE_FACTORY_INSTANCE = new RadiansNodeFactory();

        private RadiansNodeFactory() {
        }

        public Class<MathModuleBuiltins.RadiansNode> getNodeClass() {
            return MathModuleBuiltins.RadiansNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.RadiansNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RadiansNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.RadiansNode> getInstance() {
            return RADIANS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.RadiansNode create() {
            return new RadiansNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.RadiansNode.class)
        public static final class RadiansNodeGen
        extends MathModuleBuiltins.RadiansNode {
            private static final InlineSupport.StateField GENERAL__RADIANS_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__RADIANS_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private RadiansNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.RadiansNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.HypotNode.class)
    public static final class HypotNodeFactory
    implements NodeFactory<MathModuleBuiltins.HypotNode> {
        private static final HypotNodeFactory HYPOT_NODE_FACTORY_INSTANCE = new HypotNodeFactory();

        private HypotNodeFactory() {
        }

        public Class<MathModuleBuiltins.HypotNode> getNodeClass() {
            return MathModuleBuiltins.HypotNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.HypotNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return HypotNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.HypotNode> getInstance() {
            return HYPOT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.HypotNode create() {
            return new HypotNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.HypotNode.class)
        public static final class HypotNodeGen
        extends MathModuleBuiltins.HypotNode {
            private static final InlineSupport.StateField STATE_0_HypotNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyFloatAsDoubleNode INLINED_HYPOT2_X_AS_DOUBLE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_HypotNode_UPDATER.subUpdater(2, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hypot2_xAsDouble__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hypot2_xAsDouble__field2_", Node.class)}));
            private static final PyFloatAsDoubleNode INLINED_HYPOT2_Y_AS_DOUBLE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_HypotNode_UPDATER.subUpdater(9, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hypot2_yAsDouble__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hypot2_yAsDouble__field2_", Node.class)}));
            private static final PyFloatAsDoubleNode INLINED_HYPOT_GENERIC_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_HypotNode_UPDATER.subUpdater(16, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hypotGeneric_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hypotGeneric_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hypot2_xAsDouble__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hypot2_xAsDouble__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hypot2_yAsDouble__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hypot2_yAsDouble__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hypotGeneric_asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hypotGeneric_asDoubleNode__field2_;

            private HypotNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value.length == 2) {
                        HypotNodeGen inliningTarget__ = this;
                        return this.hypot2(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_HYPOT2_X_AS_DOUBLE_, INLINED_HYPOT2_Y_AS_DOUBLE_);
                    }
                    if ((state_0 & 2) != 0) {
                        HypotNodeGen inliningTarget__1 = this;
                        return this.hypotGeneric(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__1, INLINED_HYPOT_GENERIC_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object[] arg1Value, PKeyword[] arg2Value) {
                int state_0 = this.state_0_;
                HypotNodeGen inliningTarget__ = null;
                if (arg1Value.length == 2) {
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 1;
                    return this.hypot2(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_HYPOT2_X_AS_DOUBLE_, INLINED_HYPOT2_Y_AS_DOUBLE_);
                }
                HypotNodeGen inliningTarget__1 = null;
                inliningTarget__1 = this;
                this.state_0_ = state_0 |= 2;
                return this.hypotGeneric(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__1, INLINED_HYPOT_GENERIC_AS_DOUBLE_NODE_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.ErfNode.class)
    public static final class ErfNodeFactory
    implements NodeFactory<MathModuleBuiltins.ErfNode> {
        private static final ErfNodeFactory ERF_NODE_FACTORY_INSTANCE = new ErfNodeFactory();

        private ErfNodeFactory() {
        }

        public Class<MathModuleBuiltins.ErfNode> getNodeClass() {
            return MathModuleBuiltins.ErfNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.ErfNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ErfNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.ErfNode> getInstance() {
            return ERF_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.ErfNode create() {
            return new ErfNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.ErfNode.class)
        public static final class ErfNodeGen
        extends MathModuleBuiltins.ErfNode {
            private static final InlineSupport.StateField GENERAL__ERF_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ERF_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private ErfNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.ErfNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.ErfcNode.class)
    public static final class ErfcNodeFactory
    implements NodeFactory<MathModuleBuiltins.ErfcNode> {
        private static final ErfcNodeFactory ERFC_NODE_FACTORY_INSTANCE = new ErfcNodeFactory();

        private ErfcNodeFactory() {
        }

        public Class<MathModuleBuiltins.ErfcNode> getNodeClass() {
            return MathModuleBuiltins.ErfcNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.ErfcNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ErfcNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.ErfcNode> getInstance() {
            return ERFC_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.ErfcNode create() {
            return new ErfcNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.ErfcNode.class)
        public static final class ErfcNodeGen
        extends MathModuleBuiltins.ErfcNode {
            private static final InlineSupport.StateField GENERAL__ERFC_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ERFC_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private ErfcNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.ErfcNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.GammaNode.class)
    public static final class GammaNodeFactory
    implements NodeFactory<MathModuleBuiltins.GammaNode> {
        private static final GammaNodeFactory GAMMA_NODE_FACTORY_INSTANCE = new GammaNodeFactory();

        private GammaNodeFactory() {
        }

        public Class<MathModuleBuiltins.GammaNode> getNodeClass() {
            return MathModuleBuiltins.GammaNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.GammaNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GammaNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.GammaNode> getInstance() {
            return GAMMA_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.GammaNode create() {
            return new GammaNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.GammaNode.class)
        public static final class GammaNodeGen
        extends MathModuleBuiltins.GammaNode {
            private static final InlineSupport.StateField GENERAL__GAMMA_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__GAMMA_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private GammaNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.GammaNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.LgammaNode.class)
    public static final class LgammaNodeFactory
    implements NodeFactory<MathModuleBuiltins.LgammaNode> {
        private static final LgammaNodeFactory LGAMMA_NODE_FACTORY_INSTANCE = new LgammaNodeFactory();

        private LgammaNodeFactory() {
        }

        public Class<MathModuleBuiltins.LgammaNode> getNodeClass() {
            return MathModuleBuiltins.LgammaNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.LgammaNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LgammaNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.LgammaNode> getInstance() {
            return LGAMMA_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.LgammaNode create() {
            return new LgammaNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.LgammaNode.class)
        public static final class LgammaNodeGen
        extends MathModuleBuiltins.LgammaNode {
            private static final InlineSupport.StateField GENERAL__LGAMMA_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__LGAMMA_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private GeneralData general_cache;

            private LgammaNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            @Override
            public double executeObject(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) != 0) {
                    GeneralData s3_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                        return this.doL(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                        return this.doD(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPI(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                        GeneralData inliningTarget__ = s3_;
                        return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 4;
                    this.state_0_ = state_0 |= 1;
                    return this.doL(arg0Value_);
                }
                int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return this.doD(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return this.doPI(arg0Value_);
                }
                GeneralData inliningTarget__ = null;
                if (!MathGuards.isNumber(arg0Value)) {
                    GeneralData s3_;
                    inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                    VarHandle.storeStoreFence();
                    this.general_cache = s3_;
                    this.state_0_ = state_0 |= 8;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.LgammaNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_asDoubleNode__field2_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.IsqrtNode.class)
    public static final class IsqrtNodeFactory
    implements NodeFactory<MathModuleBuiltins.IsqrtNode> {
        private static final IsqrtNodeFactory ISQRT_NODE_FACTORY_INSTANCE = new IsqrtNodeFactory();

        private IsqrtNodeFactory() {
        }

        public Class<MathModuleBuiltins.IsqrtNode> getNodeClass() {
            return MathModuleBuiltins.IsqrtNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public MathModuleBuiltins.IsqrtNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IsqrtNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.IsqrtNode> getInstance() {
            return ISQRT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.IsqrtNode create() {
            return new IsqrtNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.IsqrtNode.class)
        public static final class IsqrtNodeGen
        extends MathModuleBuiltins.IsqrtNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField GENERAL__ISQRT_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
            private static final NarrowBigIntegerNode INLINED_MAKE_INT = NarrowBigIntegerNodeGen.inline(InlineSupport.InlineTarget.create(NarrowBigIntegerNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(6, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"makeInt_field1_", Node.class)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(12, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode_field1_", Node.class)}));
            private static final PyNumberIndexNode INLINED_GENERAL_INDEX_NODE_ = PyNumberIndexNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__ISQRT_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_indexNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_indexNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_indexNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_indexNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_indexNode__field5_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node makeInt_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode_field1_;
            @Node.Child
            private GeneralData general_cache;

            private IsqrtNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    GeneralData s2_;
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x38) >>> 3, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x38) >>> 3, arg0Value);
                        IsqrtNodeGen inliningTarget__ = this;
                        return MathModuleBuiltins.IsqrtNode.isqrtLong(arg0Value_, inliningTarget__, INLINED_MAKE_INT, INLINED_RAISE_NODE);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        IsqrtNodeGen inliningTarget__1 = this;
                        return MathModuleBuiltins.IsqrtNode.isqrtPInt(arg0Value_, inliningTarget__1, INLINED_MAKE_INT, INLINED_RAISE_NODE);
                    }
                    if ((state_0 & 4) != 0 && (s2_ = this.general_cache) != null && !MathGuards.isInteger(arg0Value)) {
                        GeneralData inliningTarget__2 = s2_;
                        return MathModuleBuiltins.IsqrtNode.doGeneral(frameValue, arg0Value, inliningTarget__2, INLINED_GENERAL_INDEX_NODE_, s2_.recursiveNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                IsqrtNodeGen inliningTarget__ = null;
                int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                    inliningTarget__ = this;
                    state_0 |= longCast0 << 3;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.IsqrtNode.isqrtLong(arg0Value_, inliningTarget__, INLINED_MAKE_INT, INLINED_RAISE_NODE);
                }
                IsqrtNodeGen inliningTarget__1 = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    inliningTarget__1 = this;
                    this.state_0_ = state_0 |= 2;
                    return MathModuleBuiltins.IsqrtNode.isqrtPInt(arg0Value_, inliningTarget__1, INLINED_MAKE_INT, INLINED_RAISE_NODE);
                }
                GeneralData inliningTarget__2 = null;
                if (!MathGuards.isInteger(arg0Value)) {
                    GeneralData s2_;
                    inliningTarget__2 = s2_ = (GeneralData)this.insert(new GeneralData());
                    MathModuleBuiltins.IsqrtNode recursiveNode__ = (MathModuleBuiltins.IsqrtNode)s2_.insert(IsqrtNodeFactory.create());
                    Objects.requireNonNull(recursiveNode__, "Specialization 'doGeneral(VirtualFrame, Object, Node, PyNumberIndexNode, IsqrtNode)' cache 'recursiveNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s2_.recursiveNode_ = recursiveNode__;
                    VarHandle.storeStoreFence();
                    this.general_cache = s2_;
                    this.state_0_ = state_0 |= 4;
                    return MathModuleBuiltins.IsqrtNode.doGeneral(frameValue, arg0Value, inliningTarget__2, INLINED_GENERAL_INDEX_NODE_, recursiveNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 7) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=MathModuleBuiltins.IsqrtNode.class)
            @DenyReplace
            private static final class GeneralData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int general_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_indexNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_indexNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_indexNode__field3_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_indexNode__field4_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node general_indexNode__field5_;
                @Node.Child
                MathModuleBuiltins.IsqrtNode recursiveNode_;

                GeneralData() {
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.ProdNode.class)
    public static final class ProdNodeFactory
    implements NodeFactory<MathModuleBuiltins.ProdNode> {
        private static final ProdNodeFactory PROD_NODE_FACTORY_INSTANCE = new ProdNodeFactory();

        private ProdNodeFactory() {
        }

        public Class<MathModuleBuiltins.ProdNode> getNodeClass() {
            return MathModuleBuiltins.ProdNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        public MathModuleBuiltins.ProdNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return ProdNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.ProdNode> getInstance() {
            return PROD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.ProdNode create(ReadArgumentNode[] arguments) {
            return new ProdNodeGen(arguments);
        }

        @GeneratedBy(value=MathModuleBuiltins.ProdNode.class)
        public static final class ProdNodeGen
        extends MathModuleBuiltins.ProdNode {
            private static final InlineSupport.StateField STATE_0_ProdNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_ERROR_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ProdNode_UPDATER.subUpdater(0, 22), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"errorProfile__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"errorProfile__field2_", Node.class)}));
            private static final InlinedConditionProfile INLINED_START_IS_NO_VALUE_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ProdNode_UPDATER.subUpdater(22, 2)}));
            private static final PyObjectGetIter INLINED_GET_ITER_ = PyObjectGetIterNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectGetIter.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ProdNode_UPDATER.subUpdater(24, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field2_", Node.class)}));
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node errorProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node errorProfile__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field2_;

            private ProdNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                ProdNodeGen inliningTarget__ = this;
                return this.doGeneric(frameValue, arguments0Value_, arguments1Value_, inliningTarget__, INLINED_ERROR_PROFILE_, INLINED_START_IS_NO_VALUE_PROFILE_, INLINED_GET_ITER_);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.DistNode.class)
    public static final class DistNodeFactory
    implements NodeFactory<MathModuleBuiltins.DistNode> {
        private static final DistNodeFactory DIST_NODE_FACTORY_INSTANCE = new DistNodeFactory();

        private DistNodeFactory() {
        }

        public Class<MathModuleBuiltins.DistNode> getNodeClass() {
            return MathModuleBuiltins.DistNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        public MathModuleBuiltins.DistNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return DistNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathModuleBuiltins.DistNode> getInstance() {
            return DIST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MathModuleBuiltins.DistNode create(ReadArgumentNode[] arguments) {
            return new DistNodeGen(arguments);
        }

        @GeneratedBy(value=MathModuleBuiltins.DistNode.class)
        public static final class DistNodeGen
        extends MathModuleBuiltins.DistNode {
            private static final InlineSupport.StateField STATE_0_DistNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyFloatAsDoubleNode INLINED_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_DistNode_UPDATER.subUpdater(1, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asDoubleNode__field2_", Node.class)}));
            private static final SequenceNodes.GetObjectArrayNode INLINED_GET_OBJECT_ARRAY_ = SequenceNodesFactory.GetObjectArrayNodeGen.inline(InlineSupport.InlineTarget.create(SequenceNodes.GetObjectArrayNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_DistNode_UPDATER.subUpdater(8, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getObjectArray__field1_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getObjectArray__field2_", Node.class)}));
            private static final InlinedLoopConditionProfile INLINED_LOOP_PROFILE1_ = InlinedLoopConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedLoopConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{InlineSupport.LongField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"loopProfile1__field0_"), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"loopProfile1__field1_")}));
            private static final InlinedLoopConditionProfile INLINED_LOOP_PROFILE2_ = InlinedLoopConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedLoopConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{InlineSupport.LongField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"loopProfile2__field0_"), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"loopProfile2__field1_")}));
            private static final InlinedConditionProfile INLINED_INF_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_DistNode_UPDATER.subUpdater(15, 2)}));
            private static final InlinedConditionProfile INLINED_NAN_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_DistNode_UPDATER.subUpdater(17, 2)}));
            private static final InlinedConditionProfile INLINED_TRIVIAL_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_DistNode_UPDATER.subUpdater(19, 2)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_DistNode_UPDATER.subUpdater(21, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asDoubleNode__field2_;
            @Node.Child
            private TupleNodes.ConstructTupleNode tupleCtor_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object getObjectArray__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getObjectArray__field2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private long loopProfile1__field0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int loopProfile1__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private long loopProfile2__field0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int loopProfile2__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private DistNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                TupleNodes.ConstructTupleNode tupleCtor__;
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state_0 & 1) != 0 && (tupleCtor__ = this.tupleCtor_) != null) {
                    DistNodeGen inliningTarget__ = this;
                    return MathModuleBuiltins.DistNode.doGeneric(frameValue, arguments0Value_, arguments1Value_, inliningTarget__, INLINED_AS_DOUBLE_NODE_, tupleCtor__, INLINED_GET_OBJECT_ARRAY_, INLINED_LOOP_PROFILE1_, INLINED_LOOP_PROFILE2_, INLINED_INF_PROFILE_, INLINED_NAN_PROFILE_, INLINED_TRIVIAL_PROFILE_, INLINED_RAISE_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
            }

            private double executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                DistNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                TupleNodes.ConstructTupleNode tupleCtor__ = (TupleNodes.ConstructTupleNode)this.insert(TupleNodes.ConstructTupleNode.create());
                Objects.requireNonNull(tupleCtor__, "Specialization 'doGeneric(VirtualFrame, Object, Object, Node, PyFloatAsDoubleNode, ConstructTupleNode, GetObjectArrayNode, InlinedLoopConditionProfile, InlinedLoopConditionProfile, InlinedConditionProfile, InlinedConditionProfile, InlinedConditionProfile, Lazy)' cache 'tupleCtor' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.tupleCtor_ = tupleCtor__;
                this.state_0_ = state_0 |= 1;
                return MathModuleBuiltins.DistNode.doGeneric(frameValue, arguments0Value, arguments1Value, inliningTarget__, INLINED_AS_DOUBLE_NODE_, tupleCtor__, INLINED_GET_OBJECT_ARRAY_, INLINED_LOOP_PROFILE1_, INLINED_LOOP_PROFILE2_, INLINED_INF_PROFILE_, INLINED_NAN_PROFILE_, INLINED_TRIVIAL_PROFILE_, INLINED_RAISE_NODE_);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.Gcd2Node.class)
    public static final class Gcd2NodeGen
    extends MathModuleBuiltins.Gcd2Node {
        private static final InlineSupport.StateField GCD9__GCD2_NODE_GCD9_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)Gcd9Data.lookup_(), (String)"gcd9_state_0_");
        private static final PyNumberIndexNode INLINED_GCD9_INDEX_NODE_ = PyNumberIndexNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GCD9__GCD2_NODE_GCD9_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Gcd9Data.lookup_(), (String)"gcd9_indexNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Gcd9Data.lookup_(), (String)"gcd9_indexNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Gcd9Data.lookup_(), (String)"gcd9_indexNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Gcd9Data.lookup_(), (String)"gcd9_indexNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)Gcd9Data.lookup_(), (String)"gcd9_indexNode__field5_", Node.class)}));
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private PRaiseNode raiseNode;
        @Node.Child
        private Gcd9Data gcd9_cache;

        private Gcd2NodeGen(boolean isRecursive) {
            super(isRecursive);
        }

        @Override
        Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FF) != 0) {
                if ((state_0 & 3) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x3800) >>> 11, arg0Value)) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x3800) >>> 11, arg0Value);
                    if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value)) {
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value);
                        return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        PythonObjectFactory factory_ = this.factory;
                        if (factory_ != null) {
                            return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, factory_);
                        }
                    }
                }
                if ((state_0 & 0xC) != 0 && arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    if ((state_0 & 4) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value)) {
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value);
                        PythonObjectFactory factory_1 = this.factory;
                        if (factory_1 != null) {
                            return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, factory_1);
                        }
                    }
                    if ((state_0 & 8) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        PythonObjectFactory factory_2 = this.factory;
                        if (factory_2 != null) {
                            return this.gcd(arg0Value_, arg1Value_, factory_2);
                        }
                    }
                }
                if ((state_0 & 0x30) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180000) >>> 19, arg1Value)) {
                    double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180000) >>> 19, arg1Value);
                    if ((state_0 & 0x10) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x60000) >>> 17, arg0Value)) {
                        double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x60000) >>> 17, arg0Value);
                        PRaiseNode raiseNode_ = this.raiseNode;
                        if (raiseNode_ != null) {
                            return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x3800) >>> 11, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x3800) >>> 11, arg0Value);
                        PRaiseNode raiseNode_1 = this.raiseNode;
                        if (raiseNode_1 != null) {
                            return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_1);
                        }
                    }
                }
                if ((state_0 & 0xC0) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x60000) >>> 17, arg0Value)) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x60000) >>> 17, arg0Value);
                    if ((state_0 & 0x40) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value)) {
                        long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value);
                        PRaiseNode raiseNode_2 = this.raiseNode;
                        if (raiseNode_2 != null) {
                            return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_2);
                        }
                    }
                    if ((state_0 & 0x80) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        PRaiseNode raiseNode_3 = this.raiseNode;
                        if (raiseNode_3 != null) {
                            return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_3);
                        }
                    }
                }
                if ((state_0 & 0x100) != 0 && arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    if (PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180000) >>> 19, arg1Value)) {
                        double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180000) >>> 19, arg1Value);
                        PRaiseNode raiseNode_4 = this.raiseNode;
                        if (raiseNode_4 != null) {
                            assert (DSLSupport.assertIdempotence((!this.isRecursive ? 1 : 0) != 0));
                            return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_4);
                        }
                    }
                }
                if ((state_0 & 0x600) != 0) {
                    Gcd9Data s9_;
                    if ((state_0 & 0x200) != 0 && (s9_ = this.gcd9_cache) != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? 1 : 0) != 0));
                        if (!MathGuards.isNumber(arg0Value) || !MathGuards.isNumber(arg1Value)) {
                            Gcd9Data inliningTarget__ = s9_;
                            return MathModuleBuiltins.Gcd2Node.gcd(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GCD9_INDEX_NODE_, s9_.recursiveNode_);
                        }
                    }
                    if ((state_0 & 0x400) != 0 && arg0Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject)arg0Value;
                        return this.gcdNative(arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
            int doubleCast0;
            int doubleCast1;
            int longCast1;
            int state_0 = this.state_0_;
            int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
            if (longCast0 != 0) {
                long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                if (longCast1 != 0) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                    state_0 |= longCast0 << 11;
                    state_0 |= longCast1 << 14;
                    this.state_0_ = state_0 |= 1;
                    return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_);
                }
                if (arg1Value instanceof PInt) {
                    PythonObjectFactory factory_;
                    PInt arg1Value_ = (PInt)arg1Value;
                    PythonObjectFactory factory__shared = this.factory;
                    if (factory__shared != null) {
                        factory_ = factory__shared;
                    } else {
                        factory_ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                        if (factory_ == null) {
                            throw new IllegalStateException("Specialization 'gcd(long, PInt, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.factory == null) {
                        VarHandle.storeStoreFence();
                        this.factory = factory_;
                    }
                    state_0 |= longCast0 << 11;
                    this.state_0_ = state_0 |= 2;
                    return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, factory_);
                }
            }
            if (arg0Value instanceof PInt) {
                PInt arg0Value_ = (PInt)arg0Value;
                int longCast12 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                if (longCast12 != 0) {
                    PythonObjectFactory factory_1;
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast12, arg1Value);
                    PythonObjectFactory factory_1_shared = this.factory;
                    if (factory_1_shared != null) {
                        factory_1 = factory_1_shared;
                    } else {
                        factory_1 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                        if (factory_1 == null) {
                            throw new IllegalStateException("Specialization 'gcd(PInt, long, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.factory == null) {
                        VarHandle.storeStoreFence();
                        this.factory = factory_1;
                    }
                    state_0 |= longCast12 << 14;
                    this.state_0_ = state_0 |= 4;
                    return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, factory_1);
                }
                if (arg1Value instanceof PInt) {
                    PythonObjectFactory factory_2;
                    PInt arg1Value_ = (PInt)arg1Value;
                    PythonObjectFactory factory_2_shared = this.factory;
                    if (factory_2_shared != null) {
                        factory_2 = factory_2_shared;
                    } else {
                        factory_2 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                        if (factory_2 == null) {
                            throw new IllegalStateException("Specialization 'gcd(PInt, PInt, PythonObjectFactory)' contains a shared cache with name 'factory' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.factory == null) {
                        VarHandle.storeStoreFence();
                        this.factory = factory_2;
                    }
                    this.state_0_ = state_0 |= 8;
                    return this.gcd(arg0Value_, arg1Value_, factory_2);
                }
            }
            if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                int doubleCast02 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast02 != 0) {
                    PRaiseNode raiseNode_;
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast02, arg0Value);
                    PRaiseNode raiseNode__shared = this.raiseNode;
                    if (raiseNode__shared != null) {
                        raiseNode_ = raiseNode__shared;
                    } else {
                        raiseNode_ = (PRaiseNode)this.insert(PRaiseNode.create());
                        if (raiseNode_ == null) {
                            throw new IllegalStateException("Specialization 'gcd(double, double, PRaiseNode)' contains a shared cache with name 'raiseNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.raiseNode == null) {
                        VarHandle.storeStoreFence();
                        this.raiseNode = raiseNode_;
                    }
                    state_0 |= doubleCast02 << 17;
                    state_0 |= doubleCast1 << 19;
                    this.state_0_ = state_0 |= 0x10;
                    return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_);
                }
                int longCast02 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
                if (longCast02 != 0) {
                    PRaiseNode raiseNode_1;
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast02, arg0Value);
                    PRaiseNode raiseNode_1_shared = this.raiseNode;
                    if (raiseNode_1_shared != null) {
                        raiseNode_1 = raiseNode_1_shared;
                    } else {
                        raiseNode_1 = (PRaiseNode)this.insert(PRaiseNode.create());
                        if (raiseNode_1 == null) {
                            throw new IllegalStateException("Specialization 'gcd(long, double, PRaiseNode)' contains a shared cache with name 'raiseNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.raiseNode == null) {
                        VarHandle.storeStoreFence();
                        this.raiseNode = raiseNode_1;
                    }
                    state_0 |= longCast02 << 11;
                    state_0 |= doubleCast1 << 19;
                    this.state_0_ = state_0 |= 0x20;
                    return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_1);
                }
            }
            if ((doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
                if (longCast1 != 0) {
                    PRaiseNode raiseNode_2;
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                    PRaiseNode raiseNode_2_shared = this.raiseNode;
                    if (raiseNode_2_shared != null) {
                        raiseNode_2 = raiseNode_2_shared;
                    } else {
                        raiseNode_2 = (PRaiseNode)this.insert(PRaiseNode.create());
                        if (raiseNode_2 == null) {
                            throw new IllegalStateException("Specialization 'gcd(double, long, PRaiseNode)' contains a shared cache with name 'raiseNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.raiseNode == null) {
                        VarHandle.storeStoreFence();
                        this.raiseNode = raiseNode_2;
                    }
                    state_0 |= doubleCast0 << 17;
                    state_0 |= longCast1 << 14;
                    this.state_0_ = state_0 |= 0x40;
                    return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_2);
                }
                if (arg1Value instanceof PInt) {
                    PRaiseNode raiseNode_3;
                    PInt arg1Value_ = (PInt)arg1Value;
                    PRaiseNode raiseNode_3_shared = this.raiseNode;
                    if (raiseNode_3_shared != null) {
                        raiseNode_3 = raiseNode_3_shared;
                    } else {
                        raiseNode_3 = (PRaiseNode)this.insert(PRaiseNode.create());
                        if (raiseNode_3 == null) {
                            throw new IllegalStateException("Specialization 'gcd(double, PInt, PRaiseNode)' contains a shared cache with name 'raiseNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.raiseNode == null) {
                        VarHandle.storeStoreFence();
                        this.raiseNode = raiseNode_3;
                    }
                    state_0 |= doubleCast0 << 17;
                    this.state_0_ = state_0 |= 0x80;
                    return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_3);
                }
            }
            if (arg0Value instanceof PInt) {
                PInt arg0Value_ = (PInt)arg0Value;
                int doubleCast12 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value);
                if (doubleCast12 != 0) {
                    double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast12, arg1Value);
                    if (!this.isRecursive) {
                        PRaiseNode raiseNode_4;
                        PRaiseNode raiseNode_4_shared = this.raiseNode;
                        if (raiseNode_4_shared != null) {
                            raiseNode_4 = raiseNode_4_shared;
                        } else {
                            raiseNode_4 = (PRaiseNode)this.insert(PRaiseNode.create());
                            if (raiseNode_4 == null) {
                                throw new IllegalStateException("Specialization 'gcd(PInt, double, PRaiseNode)' contains a shared cache with name 'raiseNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.raiseNode == null) {
                            VarHandle.storeStoreFence();
                            this.raiseNode = raiseNode_4;
                        }
                        state_0 |= doubleCast12 << 19;
                        this.state_0_ = state_0 |= 0x100;
                        return MathModuleBuiltins.Gcd2Node.gcd(arg0Value_, arg1Value_, raiseNode_4);
                    }
                }
            }
            Gcd9Data inliningTarget__ = null;
            if (!(this.isRecursive || MathGuards.isNumber(arg0Value) && MathGuards.isNumber(arg1Value))) {
                Gcd9Data s9_;
                inliningTarget__ = s9_ = (Gcd9Data)this.insert(new Gcd9Data());
                s9_.recursiveNode_ = (MathModuleBuiltins.Gcd2Node)s9_.insert(MathModuleBuiltins.Gcd2Node.create(true));
                VarHandle.storeStoreFence();
                this.gcd9_cache = s9_;
                this.state_0_ = state_0 |= 0x200;
                return MathModuleBuiltins.Gcd2Node.gcd(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GCD9_INDEX_NODE_, s9_.recursiveNode_);
            }
            if (arg0Value instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject)arg0Value;
                this.state_0_ = state_0 |= 0x400;
                return this.gcdNative(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x7FF & (state_0 & 0x7FF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static MathModuleBuiltins.Gcd2Node create(boolean isRecursive) {
            return new Gcd2NodeGen(isRecursive);
        }

        @GeneratedBy(value=MathModuleBuiltins.Gcd2Node.class)
        @DenyReplace
        private static final class Gcd9Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int gcd9_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node gcd9_indexNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node gcd9_indexNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node gcd9_indexNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node gcd9_indexNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node gcd9_indexNode__field5_;
            @Node.Child
            MathModuleBuiltins.Gcd2Node recursiveNode_;

            Gcd9Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=MathModuleBuiltins.MathDoubleUnaryBuiltinNode.class)
    public static final class MathDoubleUnaryBuiltinNodeGen
    extends MathModuleBuiltins.MathDoubleUnaryBuiltinNode {
        private static final InlineSupport.StateField GENERAL__MATH_DOUBLE_UNARY_BUILTIN_NODE_GENERAL_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_state_0_");
        private static final PyFloatAsDoubleNode INLINED_GENERAL_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineSupport.InlineTarget.create(PyFloatAsDoubleNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERAL__MATH_DOUBLE_UNARY_BUILTIN_NODE_GENERAL_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GeneralData.lookup_(), (String)"general_asDoubleNode__field2_", Node.class)}));
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private GeneralData general_cache;

        private MathDoubleUnaryBuiltinNodeGen() {
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) != 0) {
                GeneralData s3_;
                if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                    return this.doL(arg0Value_);
                }
                if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                    return this.doD(arg0Value_);
                }
                if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    return this.doPI(arg0Value_);
                }
                if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                    GeneralData inliningTarget__ = s3_;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value);
        }

        @Override
        public double executeObject(VirtualFrame frameValue, Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) != 0) {
                GeneralData s3_;
                if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x70) >>> 4, arg0Value)) {
                    long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x70) >>> 4, arg0Value);
                    return this.doL(arg0Value_);
                }
                if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0x180) >>> 7, arg0Value)) {
                    double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0x180) >>> 7, arg0Value);
                    return this.doD(arg0Value_);
                }
                if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    return this.doPI(arg0Value_);
                }
                if ((state_0 & 8) != 0 && (s3_ = this.general_cache) != null && !MathGuards.isNumber(arg0Value)) {
                    GeneralData inliningTarget__ = s3_;
                    return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value);
        }

        private double executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
            int state_0 = this.state_0_;
            int longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value);
            if (longCast0 != 0) {
                long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                state_0 |= longCast0 << 4;
                this.state_0_ = state_0 |= 1;
                return this.doL(arg0Value_);
            }
            int doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 |= doubleCast0 << 7;
                this.state_0_ = state_0 |= 2;
                return this.doD(arg0Value_);
            }
            if (arg0Value instanceof PInt) {
                PInt arg0Value_ = (PInt)arg0Value;
                this.state_0_ = state_0 |= 4;
                return this.doPI(arg0Value_);
            }
            GeneralData inliningTarget__ = null;
            if (!MathGuards.isNumber(arg0Value)) {
                GeneralData s3_;
                inliningTarget__ = s3_ = (GeneralData)this.insert(new GeneralData());
                VarHandle.storeStoreFence();
                this.general_cache = s3_;
                this.state_0_ = state_0 |= 8;
                return this.doGeneral(frameValue, arg0Value, inliningTarget__, INLINED_GENERAL_AS_DOUBLE_NODE_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static MathModuleBuiltins.MathDoubleUnaryBuiltinNode create() {
            return new MathDoubleUnaryBuiltinNodeGen();
        }

        @GeneratedBy(value=MathModuleBuiltins.MathDoubleUnaryBuiltinNode.class)
        @DenyReplace
        private static final class GeneralData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int general_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node general_asDoubleNode__field2_;

            GeneralData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }
}

