/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.LsprofModuleBuiltins;
import com.oracle.graal.python.builtins.modules.Profiler;
import com.oracle.graal.python.builtins.modules.ProfilerBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.CPUSamplerData;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@CoreFunctions(extendClasses={PythonBuiltinClassType.LsprofProfiler})
class ProfilerBuiltins
extends PythonBuiltins {
    ProfilerBuiltins() {
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ProfilerBuiltinsFactory.getFactories();
    }

    @Builtin(name="getstats", minNumOfPositionalArgs=1, doc="getstats() -> list of profiler_entry objects\n\nReturn all information collected by the profiler.\nEach profiler_entry is a tuple-like object with the\nfollowing attributes:\n\n    code          code object or functionname\n    callcount     how many times this was called\n    reccallcount  how many times called recursively\n    totaltime     total time in this entry\n    inlinetime    inline time in this entry (not in subcalls)\n    calls         details of the calls\n\nThe calls attribute is either None or a list of\nprofiler_subentry objects:\n\n    code          called code object\n    callcount     how many times this is called\n    reccallcount  how many times this is called recursively\n    totaltime     total time spent in this call\n    inlinetime    inline time (not in further subcalls)\n")
    @GenerateNodeFactory
    static abstract class GetStats
    extends PythonBuiltinNode {
        GetStats() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PList doit(Profiler self) {
            double avgSampleSeconds = (double)self.sampler.getPeriod() / 1000.0;
            ArrayList<PTuple> entries = new ArrayList<PTuple>();
            Map data = self.sampler.getData();
            for (TruffleContext context : data.keySet()) {
                Map threads = ((CPUSamplerData)data.get(context)).getThreadData();
                for (Thread thread : threads.keySet()) {
                    for (ProfilerNode node : (Collection)threads.get(thread)) {
                        GetStats.countNode(entries, (ProfilerNode<CPUSampler.Payload>)node, avgSampleSeconds);
                    }
                }
            }
            self.sampler.close();
            return PythonObjectFactory.getUncached().createList(entries.toArray());
        }

        private static void countNode(List<PTuple> entries, ProfilerNode<CPUSampler.Payload> node, double avgSampleTime) {
            PythonObjectSlowPathFactory factory = PythonContext.get(null).factory();
            Collection children = node.getChildren();
            Object[] profilerEntry = GetStats.getProfilerEntry(node, avgSampleTime);
            Object[] calls = new Object[children.size()];
            int callIdx = 0;
            for (ProfilerNode childNode : children) {
                GetStats.countNode(entries, (ProfilerNode<CPUSampler.Payload>)childNode, avgSampleTime);
                calls[callIdx++] = factory.createStructSeq(LsprofModuleBuiltins.PROFILER_SUBENTRY_DESC, GetStats.getProfilerEntry((ProfilerNode<CPUSampler.Payload>)childNode, avgSampleTime));
            }
            assert (callIdx == calls.length);
            profilerEntry = Arrays.copyOf(profilerEntry, 6);
            profilerEntry[profilerEntry.length - 1] = factory.createList(calls);
            entries.add(factory.createStructSeq(LsprofModuleBuiltins.PROFILER_ENTRY_DESC, profilerEntry));
        }

        private static Object[] getProfilerEntry(ProfilerNode<CPUSampler.Payload> node, double avgSampleTime) {
            SourceSection sec = node.getSourceSection();
            Object rootName = sec == null ? node.getRootName() : sec.getSource().getName() + ":" + sec.getStartLine() + "(" + node.getRootName() + ")";
            if (rootName == null) {
                rootName = "<unknown root>";
            }
            int otherHitCount = ((CPUSampler.Payload)node.getPayload()).getHitCount();
            int selfHitCount = ((CPUSampler.Payload)node.getPayload()).getSelfHitCount();
            long hitCount = (long)otherHitCount + (long)selfHitCount;
            Object[] profilerEntry = new Object[]{PythonUtils.toTruffleStringUncached((String)rootName), hitCount, 0, (double)otherHitCount * avgSampleTime, (double)selfHitCount * avgSampleTime};
            return profilerEntry;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class Clear
    extends PythonBuiltinNode {
        Clear() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone doit(Profiler self) {
            self.sampler.clearData();
            return PNone.NONE;
        }
    }

    @Builtin(name="disable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class Disable
    extends PythonBuiltinNode {
        Disable() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone doit(Profiler self) {
            self.sampler.setCollecting(false);
            self.time = ((double)System.currentTimeMillis() - self.time) / 1000.0;
            return PNone.NONE;
        }
    }

    @Builtin(name="enable", minNumOfPositionalArgs=1, parameterNames={"$self", "subcalls", "builtins"})
    @GenerateNodeFactory
    static abstract class Enable
    extends PythonBuiltinNode {
        Enable() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone doit(Profiler self, long subcalls, long builtins) {
            self.subcalls = subcalls > 0L;
            self.builtins = builtins > 0L;
            self.time = System.currentTimeMillis();
            self.sampler.setCollecting(true);
            return PNone.NONE;
        }

        @Specialization
        PNone doit(Profiler self, long subcalls, PNone builtins) {
            return this.doit(self, subcalls, self.builtins ? 1L : 0L);
        }

        @Specialization
        PNone doit(Profiler self, PNone subcalls, long builtins) {
            return this.doit(self, self.subcalls ? 1L : 0L, builtins);
        }

        @Specialization
        PNone doit(Profiler self, PNone subcalls, PNone builtins) {
            return this.doit(self, self.subcalls ? 1L : 0L, self.builtins ? 1L : 0L);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "timer", "timeunit", "subcalls", "builtins"})
    @GenerateNodeFactory
    static abstract class Init
    extends PythonBuiltinNode {
        Init() {
        }

        @Specialization
        PNone doit(Profiler self, Object timer, double timeunit, long subcalls, long builtins) {
            self.subcalls = subcalls > 0L;
            self.builtins = builtins > 0L;
            self.timeunit = timeunit;
            self.externalTimer = timer;
            return PNone.NONE;
        }

        @Specialization
        PNone doit(Profiler self, Object timer, PNone timeunit, PNone subcalls, PNone builtins) {
            self.subcalls = true;
            self.builtins = true;
            self.timeunit = -1.0;
            self.externalTimer = timer;
            return PNone.NONE;
        }
    }
}

