/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.SignalModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.SignalModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.Signals;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyTimeFromObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.graalvm.nativeimage.ImageInfo;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@CoreFunctions(defineModule="_signal", isEager=true)
public final class SignalModuleBuiltins
extends PythonBuiltins {
    private static final HiddenKey signalModuleDataKey = new HiddenKey("signalModuleData");
    private static final int ITIMER_REAL = 0;
    private static final int ITIMER_VIRTUAL = 1;
    private static final int ITIMER_PROF = 2;
    public static final String J_DEFAULT_INT_HANDLER = "default_int_handler";
    public static final TruffleString T_DEFAULT_INT_HANDLER = PythonUtils.tsLiteral("default_int_handler");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SignalModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("SIG_DFL", (Object)0);
        this.addBuiltinConstant("SIG_IGN", (Object)1);
        this.addBuiltinConstant("ITIMER_REAL", (Object)0);
        this.addBuiltinConstant("ITIMER_VIRTUAL", (Object)1);
        this.addBuiltinConstant("ITIMER_PROF", (Object)2);
        for (int i = 0; i < Signals.SIGNAL_NAMES.length; ++i) {
            String name = Signals.SIGNAL_NAMES[i];
            if (name == null) continue;
            this.addBuiltinConstant("SIG" + name, (Object)i);
        }
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule signalModule = core.lookupBuiltinModule(BuiltinNames.T__SIGNAL);
        ModuleData moduleData = new ModuleData();
        signalModule.setAttribute(signalModuleDataKey, moduleData);
        core.getContext().registerAsyncAction(() -> {
            SignalTriggerAction poll = moduleData.signalQueue.poll();
            if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
                try {
                    while (poll == null) {
                        moduleData.signalSema.acquire();
                        poll = moduleData.signalQueue.poll();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return poll;
        });
        if (!ImageInfo.inImageBuildtimeCode() && core.getContext().getOption(PythonOptions.InstallSignalHandlers).booleanValue()) {
            Object defaultSigintHandler = signalModule.getAttribute(T_DEFAULT_INT_HANDLER);
            assert (defaultSigintHandler != PNone.NO_VALUE);
            SignalNode.signal(null, new Signal("INT").getNumber(), defaultSigintHandler, moduleData);
        }
    }

    public static void resetSignalHandlers(PythonModule mod) {
        Object obj = ReadAttributeFromObjectNode.getUncached().execute((Object)mod, signalModuleDataKey);
        if (obj instanceof ModuleData) {
            ModuleData data = (ModuleData)obj;
            for (Map.Entry<Integer, SignalHandler> entry : data.defaultSignalHandlers.entrySet()) {
                Signals.setSignalHandler((int)entry.getKey(), entry.getValue());
            }
            data.signalHandlers.clear();
            data.defaultSignalHandlers.clear();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Object handlerToPython(SignalHandler handler, int signum, ModuleData data) {
        if (!(handler instanceof Signals.PythonSignalHandler)) {
            data.defaultSignalHandlers.put(signum, handler);
        }
        if (handler == SignalHandler.SIG_DFL) {
            return 0;
        }
        if (handler == SignalHandler.SIG_IGN) {
            return 1;
        }
        if (handler instanceof Signals.PythonSignalHandler) {
            return data.signalHandlers.getOrDefault(signum, PNone.NONE);
        }
        return 0;
    }

    private static ModuleData getModuleData(PythonModule mod) {
        return SignalModuleBuiltins.getModuleData(mod, ReadAttributeFromObjectNode.getUncached());
    }

    private static ModuleData getModuleData(PythonModule mod, ReadAttributeFromObjectNode readNode) {
        Object obj = readNode.execute((Object)mod, signalModuleDataKey);
        if (obj instanceof ModuleData) {
            return (ModuleData)obj;
        }
        throw new IllegalStateException("the signal module was not initialized properly!");
    }

    private static class ModuleData {
        final ConcurrentHashMap<Integer, Object> signalHandlers = new ConcurrentHashMap();
        final ConcurrentHashMap<Integer, SignalHandler> defaultSignalHandlers = new ConcurrentHashMap();
        final ConcurrentLinkedDeque<SignalTriggerAction> signalQueue = new ConcurrentLinkedDeque();
        final Semaphore signalSema = new Semaphore(0);
        ScheduledExecutorService itimerService;
        ScheduledFuture<?> itimerFuture;
        long itimerInterval;

        private ModuleData() {
        }
    }

    @Builtin(name="signal", minNumOfPositionalArgs=3, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class SignalNode
    extends PythonTernaryBuiltinNode {
        SignalNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object signalHandler(PythonModule self, Object signal, Object handler, @Bind(value="this") Node inliningTarget) {
            int id;
            ModuleData data = SignalModuleBuiltins.getModuleData(self);
            int signum = PyNumberAsSizeNode.executeExactUncached(signal);
            if (PyCallableCheckNode.executeUncached(handler)) {
                return SignalNode.signal(inliningTarget, signum, handler, data);
            }
            try {
                id = CastToJavaIntExactNode.executeUncached(handler);
            }
            catch (CannotCastException | PException e) {
                id = -1;
            }
            return SignalNode.signal(inliningTarget, signum, id, data);
        }

        @CompilerDirectives.TruffleBoundary
        static Object signal(Node raisingNode, int signum, Object handler, ModuleData data) {
            SignalHandler oldHandler;
            SignalTriggerAction signalTrigger = new SignalTriggerAction(handler, signum);
            try {
                oldHandler = Signals.setSignalHandler(signum, () -> {
                    data.signalQueue.add(signalTrigger);
                    data.signalSema.release();
                });
            }
            catch (IllegalArgumentException e) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.ValueError, e);
            }
            Object result = SignalModuleBuiltins.handlerToPython(oldHandler, signum, data);
            data.signalHandlers.put(signum, handler);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object signal(Node raisingNode, int signum, int id, ModuleData data) {
            SignalHandler oldHandler;
            try {
                oldHandler = id == 0 && data.defaultSignalHandlers.containsKey(signum) ? Signals.setSignalHandler(signum, data.defaultSignalHandlers.get(signum)) : Signals.setSignalHandler(signum, id);
            }
            catch (IllegalArgumentException e) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.TypeError, ErrorMessages.SIGNAL_MUST_BE_SIGIGN_SIGDFL_OR_CALLABLE_OBJ);
            }
            Object result = SignalModuleBuiltins.handlerToPython(oldHandler, signum, data);
            data.signalHandlers.remove(signum);
            return result;
        }
    }

    private static class SignalTriggerAction
    extends AsyncHandler.AsyncPythonAction {
        private final Object callableObject;
        private final int signum;

        SignalTriggerAction(Object callable, int signum) {
            this.callableObject = callable;
            this.signum = signum;
        }

        @Override
        public Object callable() {
            return this.callableObject;
        }

        @Override
        public Object[] arguments() {
            return new Object[]{this.signum, null};
        }

        @Override
        public int frameIndex() {
            return 1;
        }
    }

    @Builtin(name="getitimer", minNumOfPositionalArgs=1, declaresExplicitSelf=true, parameterNames={"$self", "which"})
    @ArgumentClinic(name="which", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class GetitimerNode
    extends PythonBinaryClinicBuiltinNode {
        GetitimerNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SignalModuleBuiltinsClinicProviders.GetitimerNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object doIt(VirtualFrame frame, PythonModule self, int which, @Bind(value="this") Node inliningTarget, @Cached ReadAttributeFromObjectNode readModuleDataNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            ModuleData moduleData = SignalModuleBuiltins.getModuleData(self, readModuleDataNode);
            if (which != 0) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.EINVAL);
            }
            return GetitimerNode.createResultTuple(factory, moduleData);
        }

        static PTuple createResultTuple(PythonObjectFactory factory, ModuleData moduleData) {
            long oldInterval = moduleData.itimerInterval;
            long oldDelay = GetitimerNode.getOldDelay(moduleData);
            return factory.createTuple(new Object[]{(double)oldDelay / 1000000.0, (double)oldInterval / 1000000.0});
        }

        @CompilerDirectives.TruffleBoundary
        static long getOldDelay(ModuleData moduleData) {
            if (moduleData.itimerFuture == null) {
                return 0L;
            }
            long delay = moduleData.itimerFuture.getDelay(TimeUnit.MICROSECONDS);
            if (delay < 0L) {
                return 0L;
            }
            return delay;
        }
    }

    @Builtin(name="setitimer", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "which", "seconds", "interval"})
    @ArgumentClinic(name="which", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class SetitimerNode
    extends PythonQuaternaryClinicBuiltinNode {
        SetitimerNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SignalModuleBuiltinsClinicProviders.SetitimerNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object doIt(VirtualFrame frame, PythonModule self, int which, Object seconds, Object interval, @Bind(value="this") Node inliningTarget, @Cached ReadAttributeFromObjectNode readModuleDataNode, @Cached PyTimeFromObjectNode timeFromObjectNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            ModuleData moduleData = SignalModuleBuiltins.getModuleData(self, readModuleDataNode);
            long usDelay = SetitimerNode.toMicroseconds(frame, inliningTarget, seconds, timeFromObjectNode);
            long usInterval = SetitimerNode.toMicroseconds(frame, inliningTarget, interval, timeFromObjectNode);
            if (which != 0) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.EINVAL);
            }
            PTuple resultTuple = GetitimerNode.createResultTuple(factory, moduleData);
            this.setitimer(moduleData, usDelay, usInterval);
            return resultTuple;
        }

        private static long toMicroseconds(VirtualFrame frame, Node inliningTarget, Object obj, PyTimeFromObjectNode timeFromObjectNode) {
            if (obj == PNone.NO_VALUE) {
                return 0L;
            }
            return timeFromObjectNode.execute(frame, inliningTarget, obj, PyTimeFromObjectNode.RoundType.CEILING, 1000000L);
        }

        @CompilerDirectives.TruffleBoundary
        private void setitimer(ModuleData moduleData, long usDelay, long usInterval) {
            if (moduleData.itimerFuture != null) {
                moduleData.itimerFuture.cancel(false);
                moduleData.itimerFuture = null;
                moduleData.itimerInterval = 0L;
            }
            if (usDelay == 0L) {
                return;
            }
            moduleData.itimerInterval = usInterval;
            Runnable r = () -> Signals.raiseSignal("ALRM");
            ScheduledExecutorService itimerService = this.getItimerService(moduleData);
            moduleData.itimerFuture = usInterval == 0L ? itimerService.schedule(r, usDelay, TimeUnit.MICROSECONDS) : itimerService.scheduleAtFixedRate(r, usDelay, usInterval, TimeUnit.MICROSECONDS);
        }

        @CompilerDirectives.TruffleBoundary
        private ScheduledExecutorService getItimerService(ModuleData moduleData) {
            if (moduleData.itimerService == null) {
                ScheduledExecutorService itimerService;
                moduleData.itimerService = itimerService = Executors.newSingleThreadScheduledExecutor(runnable -> {
                    Thread t = Executors.defaultThreadFactory().newThread(runnable);
                    t.setDaemon(true);
                    return t;
                });
                this.getContext().registerAtexitHook(ctx -> itimerService.shutdown());
            }
            return moduleData.itimerService;
        }
    }

    @Builtin(name="raise_signal", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"signalnum"})
    @ArgumentClinic(name="signalnum", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class RaiseSignalNode
    extends PythonUnaryClinicBuiltinNode {
        RaiseSignalNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone doInt(int signum) {
            Signal.raise(new Signal(Signals.signalNumberToName(signum)));
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SignalModuleBuiltinsClinicProviders.RaiseSignalNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="set_wakeup_fd", minNumOfPositionalArgs=1, parameterNames={"", "warn_on_full_buffer"})
    @GenerateNodeFactory
    static abstract class SetWakeupFdNode
    extends PythonBuiltinNode {
        SetWakeupFdNode() {
        }

        @Specialization
        static int doGeneric(Object fd, Object warnOnFullBuffer) {
            return -1;
        }
    }

    @Builtin(name="default_int_handler", minNumOfPositionalArgs=0, takesVarArgs=true, takesVarKeywordArgs=false)
    @GenerateNodeFactory
    static abstract class DefaultIntHandlerNode
    extends PythonBuiltinNode {
        DefaultIntHandlerNode() {
        }

        @Specialization
        static Object defaultIntHandler(Object[] args, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.KeyboardInterrupt);
        }
    }

    @Builtin(name="getsignal", declaresExplicitSelf=true, minNumOfPositionalArgs=2, parameterNames={"$mod", "signalnum"})
    @ArgumentClinic(name="signalnum", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class GetSignalNode
    extends PythonBinaryClinicBuiltinNode {
        GetSignalNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object getsignal(PythonModule mod, int signum) {
            ModuleData data = (ModuleData)mod.getAttribute(signalModuleDataKey);
            return SignalModuleBuiltins.handlerToPython(Signals.getCurrentSignalHandler(signum), signum, data);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SignalModuleBuiltinsClinicProviders.GetSignalNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="alarm", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, declaresExplicitSelf=true, parameterNames={"$mod", "seconds"})
    @ArgumentClinic(name="seconds", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class AlarmNode
    extends PythonBinaryClinicBuiltinNode {
        private static final HiddenKey CURRENT_ALARM = new HiddenKey("current_alarm");

        AlarmNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int alarm(PythonModule module, int seconds) {
            Signals.Alarm currentAlarm;
            int remaining = 0;
            Object currentAlarmObj = module.getAttribute(CURRENT_ALARM);
            if (currentAlarmObj instanceof Signals.Alarm && (currentAlarm = (Signals.Alarm)currentAlarmObj).isRunning()) {
                remaining = currentAlarm.getRemainingSeconds();
                if (remaining < 0) {
                    remaining = 0;
                }
                currentAlarm.cancel();
            }
            if (seconds > 0) {
                Signals.Alarm newAlarm = new Signals.Alarm(seconds);
                module.setAttribute(CURRENT_ALARM, newAlarm);
                newAlarm.start();
            }
            return remaining;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SignalModuleBuiltinsClinicProviders.AlarmNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="valid_signals")
    @GenerateNodeFactory
    static abstract class ValidSignalsNode
    extends PythonBuiltinNode {
        ValidSignalsNode() {
        }

        @Specialization
        static Object validSignals(@Cached PythonObjectFactory factory) {
            int signalCount = 0;
            for (int i = 0; i < Signals.SIGNAL_NAMES.length; ++i) {
                if (Signals.SIGNAL_NAMES[i] == null) continue;
                ++signalCount;
            }
            int[] validSignals = new int[signalCount];
            int j = 0;
            for (int i = 0; i < Signals.SIGNAL_NAMES.length; ++i) {
                if (Signals.SIGNAL_NAMES[i] == null) continue;
                validSignals[j++] = i;
            }
            return factory.createTuple(validSignals);
        }
    }
}

