/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextFileBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.PrepareExceptionNode;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNode;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextErrBuiltins {
    private static Object noneToNativeNull(Node node, Object obj) {
        return obj instanceof PNone ? PythonContext.get(node).getNativeNull() : obj;
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyException_SetTraceback
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetTraceback() {
        }

        @Specialization
        Object setTraceback(Object exc, Object traceback, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___TRACEBACK__, traceback);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyException_GetTraceback
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetTraceback() {
        }

        @Specialization
        Object getTraceback(Object exc, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___TRACEBACK__));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyException_SetContext
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetContext() {
        }

        @Specialization
        Object setContext(Object exc, Object context, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CONTEXT__, context);
            return PNone.NONE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyException_GetContext
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetContext() {
        }

        @Specialization
        Object setCause(Object exc, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CONTEXT__));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyException_GetCause
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetCause() {
        }

        @Specialization
        Object getCause(Object exc, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CAUSE__));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyException_SetCause
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetCause() {
        }

        @Specialization
        Object setCause(Object exc, Object cause, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___CAUSE__, cause);
            return PNone.NONE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_PrintEx
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyErr_PrintEx() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object raise(int set_sys_last_vars, @Cached PyErr_GivenExceptionMatches matchesNode, @Cached PyErr_Occurred errOccuredNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached SysModuleBuiltins.ExcInfoNode excInfoNode, @Cached PyErr_Restore restoreNode, @Cached PythonCextFileBuiltins.PyFile_WriteObject writeFileNode, @Cached PosixModuleBuiltins.ExitNode exitNode, @Cached PyTruffleErr_Fetch fetchNode, @Cached PyErr_Display errDisplayNode) {
            Object exceptHook;
            PythonNativePointer nativeNull = this.getNativeNull();
            Object err = errOccuredNode.execute();
            PythonModule sys = this.getCore().getSysModule();
            if (err != nativeNull && matchesNode.executeInt(err, (Object)PythonBuiltinClassType.SystemExit) != 0) {
                PyErr_PrintEx.handleSystemExit(excInfoNode, getItemNode, isInstanceNode, restoreNode, (SysModuleBuiltins)sys.getBuiltins(), writeFileNode, exitNode);
            }
            Object fetched = fetchNode.execute(null);
            Object type = null;
            Object val = null;
            Object tb = null;
            if (fetched != nativeNull) {
                PTuple fetchedTuple = (PTuple)fetched;
                type = getItemNode.execute((VirtualFrame)null, fetchedTuple, 0);
                val = getItemNode.execute((VirtualFrame)null, fetchedTuple, 1);
                tb = getItemNode.execute((VirtualFrame)null, fetchedTuple, 2);
            }
            if (type == null || type == PNone.NONE) {
                return PNone.NONE;
            }
            if (tb == nativeNull) {
                tb = PNone.NONE;
            }
            if (PyObjectLookupAttr.executeUncached(val, SpecialAttributeNames.T___TRACEBACK__) == PNone.NONE) {
                WriteAttributeToObjectNode.getUncached().execute(val, SpecialAttributeNames.T___TRACEBACK__, tb);
            }
            if (set_sys_last_vars != 0) {
                PyErr_PrintEx.writeLastVars(sys, type, val, tb, restoreNode);
            }
            if ((exceptHook = PyObjectLookupAttr.executeUncached(sys, BuiltinNames.T_EXCEPTHOOK)) != PNone.NO_VALUE) {
                PyErr_PrintEx.handleExceptHook(exceptHook, type, val, tb, excInfoNode, getItemNode, sys, errDisplayNode);
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static void writeLastVars(PythonModule sys, Object type, Object val, Object tb, PyErr_Restore restoreNode) {
            try {
                WriteAttributeToObjectNode.getUncached().execute((Object)sys, BuiltinNames.T_LAST_TYPE, type);
                WriteAttributeToObjectNode.getUncached().execute((Object)sys, BuiltinNames.T_LAST_VALUE, val);
                WriteAttributeToObjectNode.getUncached().execute((Object)sys, BuiltinNames.T_LAST_TRACEBACK, tb);
            }
            catch (PException e) {
                restoreNode.execute(PNone.NONE, PNone.NONE, PNone.NONE);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void handleExceptHook(Object exceptHook, Object type, Object val, Object tb, SysModuleBuiltins.ExcInfoNode excInfoNode, TupleBuiltins.GetItemNode getItemNode, PythonModule sys, PyErr_Display errDisplayNode) {
            try {
                CallNode.getUncached().execute(exceptHook, type, val, tb);
            }
            catch (PException e) {
                PTuple sysInfo = excInfoNode.execute(null);
                Object type1 = getItemNode.execute((VirtualFrame)null, sysInfo, 0);
                Object val1 = getItemNode.execute((VirtualFrame)null, sysInfo, 1);
                Object tb1 = getItemNode.execute((VirtualFrame)null, sysInfo, 2);
                Object stdErr = ((SysModuleBuiltins)sys.getBuiltins()).getStdErr();
                Object writeMethod = PyObjectGetAttr.executeUncached(stdErr, IONodes.T_WRITE);
                CallNode.getUncached().execute(null, writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, "Error in sys.excepthook:\n"));
                errDisplayNode.execute(type1, val1, tb1);
                CallNode.getUncached().execute(null, writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, "\nOriginal exception was:\n"));
                errDisplayNode.execute(type, val, tb);
                PyObjectCallMethodObjArgs.executeUncached(stdErr, IONodes.T_FLUSH, new Object[0]);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void handleSystemExit(SysModuleBuiltins.ExcInfoNode excInfoNode, TupleBuiltins.GetItemNode getItemNode, BuiltinFunctions.IsInstanceNode isInstanceNode, PyErr_Restore restoreNode, SysModuleBuiltins sys, PythonCextFileBuiltins.PyFile_WriteObject writeFileNode, PosixModuleBuiltins.ExitNode exitNode) {
            PTuple sysInfo = excInfoNode.execute(null);
            int rc = 0;
            Object returnObject = null;
            Object val = getItemNode.execute((VirtualFrame)null, sysInfo, 1);
            Object codeAttr = PyObjectLookupAttr.executeUncached(val, PBaseException.T_CODE);
            if (val != PNone.NONE && !(codeAttr instanceof PNone)) {
                returnObject = codeAttr;
            }
            if (!(codeAttr instanceof PNone) && isInstanceNode.executeWith(null, codeAttr, (Object)PythonBuiltinClassType.PInt)) {
                rc = (Integer)codeAttr;
            } else {
                restoreNode.execute(PNone.NONE, PNone.NONE, PNone.NONE);
                Object stdErr = sys.getStdErr();
                if (stdErr != null && stdErr != PNone.NONE) {
                    writeFileNode.execute(returnObject, stdErr, 1);
                } else {
                    Object stdOut = sys.getStdOut();
                    Object writeMethod = PyObjectGetAttr.executeUncached(stdOut, IONodes.T_WRITE);
                    CallNode.getUncached().execute(null, writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, returnObject));
                    PyObjectCallMethodObjArgs.executeUncached(stdOut, IONodes.T_FLUSH, new Object[0]);
                }
            }
            exitNode.execute(null, rc);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyErr_WriteUnraisableMsg
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyErr_WriteUnraisableMsg() {
        }

        @Specialization
        Object write(Object msg, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyTruffleErr_Fetch fetchNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached WriteAttributeToObjectNode writeAttrNode, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached WriteUnraisableNode writeUnraisableNode, @Cached InlinedBranchProfile noValProfile) {
            Object val = null;
            Object tb = null;
            Object fetched = fetchNode.execute(null);
            if (fetched != this.getNativeNull()) {
                PTuple fetchedTuple = (PTuple)fetched;
                val = getItemNode.execute((VirtualFrame)null, fetchedTuple, 1);
                tb = getItemNode.execute((VirtualFrame)null, fetchedTuple, 2);
            }
            if (!(val instanceof PBaseException)) {
                noValProfile.enter(inliningTarget);
                return PNone.NONE;
            }
            if (tb == this.getNativeNull()) {
                tb = PNone.NONE;
            }
            TruffleString m = null;
            if (msg instanceof TruffleString) {
                m = (TruffleString)msg;
            }
            writeAttrNode.execute(val, SpecialAttributeNames.T___TRACEBACK__, tb);
            writeUnraisableNode.execute((PBaseException)val, m, obj instanceof PNone ? PNone.NONE : obj);
            getThreadStateNode.setCaughtException(inliningTarget, PException.NO_EXCEPTION);
            return PNone.NONE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_GivenExceptionMatches
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyErr_GivenExceptionMatches() {
        }

        public abstract int executeInt(Object var1, Object var2);

        @Specialization(guards={"isPTuple(exc) || isTupleSubtype(this, exc, getClassNode, isSubtypeNode)"}, limit="1")
        static int matches(Object err, Object exc, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared(value="isSubtype") @Cached IsSubtypeNode isSubtypeNode, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached PyErr_GivenExceptionMatches matchesNode, @Cached InlinedLoopConditionProfile loopProfile) {
            int len = (Integer)lenNode.execute(null, exc);
            loopProfile.profileCounted(inliningTarget, (long)len);
            int i = 0;
            while (loopProfile.profile(inliningTarget, i < len)) {
                Object e = getItemNode.execute(null, exc, (Object)i);
                if (matchesNode.executeInt(err, e) != 0) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }

        @Specialization(guards={"!isPTuple(exc)", "!isTupleSubtype(inliningTarget, exc, getClassNode, isSubtypeNode)"}, limit="1")
        static int matches(Object errArg, Object exc, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared(value="isSubtype") @Cached IsSubtypeNode isSubtypeNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached IsNode isNode, @Cached InlinedBranchProfile isBaseExceptionProfile, @Cached InlinedConditionProfile isExceptionProfile) {
            if (errArg == PNone.NO_VALUE || exc == PNone.NO_VALUE) {
                return PInt.intValue(false);
            }
            Object err = errArg;
            if (isInstanceNode.executeWith(null, errArg, (Object)PythonBuiltinClassType.PBaseException)) {
                isBaseExceptionProfile.enter(inliningTarget);
                err = getClassNode.execute(inliningTarget, err);
            }
            if (isExceptionProfile.profile(inliningTarget, PyErr_GivenExceptionMatches.isExceptionClass(inliningTarget, err, isTypeNode, isSubClassNode) && PyErr_GivenExceptionMatches.isExceptionClass(inliningTarget, exc, isTypeNode, isSubClassNode))) {
                return PInt.intValue(isSubClassNode.executeWith(null, err, exc));
            }
            return PInt.intValue(isNode.execute(exc, err));
        }

        protected boolean isTupleSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PTuple);
        }

        private static boolean isExceptionClass(Node inliningTarget, Object obj, TypeNodes.IsTypeNode isTypeNode, BuiltinFunctions.IsSubClassNode isSubClassNode) {
            return isTypeNode.execute(inliningTarget, obj) && isSubClassNode.executeWith(null, obj, (Object)PythonBuiltinClassType.PBaseException);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleErr_GetExcInfo
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleErr_GetExcInfo() {
        }

        @Specialization
        Object info(@Bind(value="this") Node inliningTarget, @Cached ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode, @Cached GetClassNode getClassNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached InlinedBranchProfile noExceptionProfile, @Cached PythonObjectFactory factory) {
            PException currentException = getCaughtExceptionNode.executeFromNative();
            if (currentException == null) {
                noExceptionProfile.enter(inliningTarget);
                return this.getNativeNull();
            }
            assert (currentException != PException.NO_EXCEPTION);
            Object exception = currentException.getEscapedException();
            Object traceback = PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getTracebackNode.execute(inliningTarget, exception));
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, exception), exception, traceback});
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_NewExceptionWithDoc
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyErr_NewExceptionWithDoc() {
        }

        @Specialization
        static Object raise(TruffleString name, Object doc, Object base, Object dict, @Cached PyErr_NewException newExNode, @Cached WriteAttributeToObjectNode writeAtrrNode, @Cached PythonObjectFactory factory) {
            if (base == PNone.NO_VALUE) {
                base = PythonErrorType.Exception;
            }
            if (dict == PNone.NO_VALUE) {
                dict = factory.createDict();
            }
            Object ex = newExNode.execute(name, base, dict);
            if (doc != PNone.NO_VALUE) {
                writeAtrrNode.execute(ex, SpecialAttributeNames.T___DOC__, doc);
            }
            return ex;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_NewException
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_NewException() {
        }

        @Specialization
        static Object newEx(TruffleString name, Object base, Object dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached TruffleString.IndexOfCodePointNode indexOfCodepointNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached DictBuiltins.SetItemNode setItemNode, @Cached BuiltinConstructors.TypeNode typeNode, @Cached InlinedBranchProfile notDotProfile, @Cached InlinedBranchProfile notModuleProfile, @Cached InlinedConditionProfile baseProfile, @Cached PythonObjectFactory.Lazy factory, @Cached PRaiseNode.Lazy raiseNode) {
            int length;
            int dotIdx;
            if (base == PNone.NO_VALUE) {
                base = PythonErrorType.Exception;
            }
            if (dict == PNone.NO_VALUE) {
                dict = factory.get(inliningTarget).createDict();
            }
            if ((dotIdx = indexOfCodepointNode.execute((AbstractTruffleString)name, 46, 0, length = codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING)) < 0) {
                notDotProfile.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.MUST_BE_MODULE_CLASS, "PyErr_NewException", "name");
            }
            if (getItem.execute(null, inliningTarget, ((PDict)dict).getDictStorage(), base) == null) {
                notModuleProfile.enter(inliningTarget);
                setItemNode.execute(null, dict, SpecialAttributeNames.T___MODULE__, substringNode.execute((AbstractTruffleString)name, 0, dotIdx, PythonUtils.TS_ENCODING, false));
            }
            PTuple bases = baseProfile.profile(inliningTarget, base instanceof PTuple) ? (PTuple)base : factory.get(inliningTarget).createTuple(new Object[]{base});
            return typeNode.execute(null, (Object)PythonBuiltinClassType.PythonClass, substringNode.execute((AbstractTruffleString)name, dotIdx + 1, length - dotIdx - 1, PythonUtils.TS_ENCODING, false), bases, dict, PKeyword.EMPTY_KEYWORDS);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyErr_BadInternalCall
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyErr_BadInternalCall() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object raiseNone(Object filename, int lineno) {
            if (filename == PNone.NONE) {
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.SystemError, ErrorMessages.S_S_BAD_ARG_TO_INTERNAL_FUNC, filename, lineno);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyTruffleErr_CreateAndSetException
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyTruffleErr_CreateAndSetException() {
        }

        @Specialization(guards={"!isExceptionClass(inliningTarget, type, isTypeNode, isSubClassNode)"})
        static Object create(Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, type);
        }

        @Specialization(guards={"isExceptionClass(inliningTarget, type, isTypeNode, isSubClassNode)"})
        static Object create(Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached PrepareExceptionNode prepareExceptionNode) {
            Object exception = prepareExceptionNode.execute(null, type, value);
            throw PRaiseNode.raiseExceptionObject(inliningTarget, exception);
        }

        protected static boolean isExceptionClass(Node inliningTarget, Object obj, TypeNodes.IsTypeNode isTypeNode, BuiltinFunctions.IsSubClassNode isSubClassNode) {
            return isTypeNode.execute(inliningTarget, obj) && isSubClassNode.executeWith(null, obj, (Object)PythonBuiltinClassType.PBaseException);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_Display
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_Display() {
        }

        @Specialization
        Object run(Object typ, PBaseException val, Object tb) {
            if (val.getException() != null) {
                ExceptionUtils.printPythonLikeStackTrace((Throwable)((Object)val.getException()));
            }
            return PNone.NO_VALUE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_SetExcInfo
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_SetExcInfo() {
        }

        @Specialization
        Object doClear(PNone typ, PNone val, PNone tb) {
            this.getContext().setCaughtException(this.getLanguage(), PException.NO_EXCEPTION);
            return PNone.NONE;
        }

        @Specialization
        Object doFull(Object typ, PBaseException val, PTraceback tb) {
            PythonContext context = this.getContext();
            PythonLanguage language = this.getLanguage();
            context.setCaughtException(language, PException.fromExceptionInfo((Object)val, tb, PythonOptions.isPExceptionWithJavaStacktrace(language)));
            return PNone.NONE;
        }

        @Specialization
        Object doWithoutTraceback(Object typ, PBaseException val, PNone tb) {
            return this.doFull(typ, val, null);
        }

        @Fallback
        Object doFallback(Object typ, Object val, Object tb) {
            return PNone.NONE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.PyThreadState}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyErr_Occurred
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyErr_Occurred() {
        }

        @Specialization
        Object run(PThreadState state, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode) {
            PException currentException = state.getThreadState().getCurrentException();
            if (currentException != null) {
                return getClassNode.execute(inliningTarget, currentException.getUnreifiedException());
            }
            return this.getNativeNull();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_Occurred
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyErr_Occurred() {
        }

        @Specialization
        Object run(@Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached GetClassNode getClassNode) {
            PException currentException = getThreadStateNode.getCurrentException(inliningTarget);
            if (currentException != null) {
                return getClassNode.execute(inliningTarget, currentException.getUnreifiedException());
            }
            return this.getNativeNull();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleErr_Fetch
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleErr_Fetch() {
        }

        @Specialization
        Object run(@Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached GetClassNode getClassNode, @Cached MaterializeLazyTracebackNode materializeTraceback, @Cached PythonObjectFactory factory) {
            Object result;
            PException currentException = getThreadStateNode.getCurrentException(inliningTarget);
            if (currentException == null) {
                result = this.getNativeNull();
            } else {
                Object exception = currentException.getEscapedException();
                Object traceback = null;
                if (currentException.getTraceback() != null) {
                    traceback = materializeTraceback.execute(inliningTarget, currentException.getTraceback());
                }
                if (traceback == null) {
                    traceback = this.getNativeNull();
                }
                result = factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, exception), exception, traceback});
                getThreadStateNode.setCurrentException(inliningTarget, null);
            }
            return result;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyErr_ChainExceptions
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyErr_ChainExceptions() {
        }

        @Specialization
        Object run(PNone typ, PNone val, PNone tb) {
            this.getContext().setCurrentException(this.getLanguage(), null);
            return PNone.NONE;
        }

        @Specialization
        Object run(Object typ, PBaseException val, PNone tb) {
            PythonContext context = this.getContext();
            PythonLanguage language = this.getLanguage();
            context.setCurrentException(language, PException.fromExceptionInfo((Object)val, (LazyTraceback)null, PythonOptions.isPExceptionWithJavaStacktrace(language)));
            return PNone.NONE;
        }

        @Specialization
        Object run(Object typ, PBaseException val, PTraceback tb) {
            PythonContext context = this.getContext();
            PythonLanguage language = this.getLanguage();
            context.setCurrentException(language, PException.fromExceptionInfo((Object)val, tb, PythonOptions.isPExceptionWithJavaStacktrace(language)));
            return PNone.NONE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyErr_Restore
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_Restore() {
        }

        @Specialization(guards={"isNoValue(typ)", "isNoValue(val)"})
        Object restore(PNone typ, PNone val, Object tb) {
            this.getContext().setCurrentException(this.getLanguage(), null);
            return PNone.NO_VALUE;
        }

        @Fallback
        Object restore(Object typ, Object val, Object tb, @Bind(value="this") Node inliningTarget, @Cached PrepareExceptionNode prepareExceptionNode, @Cached ExceptionNodes.SetTracebackNode setTracebackNode) {
            Object exception;
            PythonContext context = this.getContext();
            PythonLanguage language = this.getLanguage();
            try {
                exception = prepareExceptionNode.execute(null, typ, val);
            }
            catch (PException e) {
                context.setCurrentException(language, e);
                return PNone.NO_VALUE;
            }
            if (tb instanceof PTraceback) {
                setTracebackNode.execute(inliningTarget, exception, tb);
            }
            context.setCurrentException(language, PException.fromExceptionInfo(exception, (LazyTraceback)null, PythonOptions.isPExceptionWithJavaStacktrace(language)));
            return PNone.NO_VALUE;
        }
    }
}

