/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.io.AbstractBufferedIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIONodes;
import com.oracle.graal.python.builtins.modules.io.BufferedIONodesFactory;
import com.oracle.graal.python.builtins.modules.io.BufferedIOUtil;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderMixinBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderMixinBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayOutputStream;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBufferedReader, PythonBuiltinClassType.PBufferedRandom})
public final class BufferedReaderMixinBuiltins
extends AbstractBufferedIOBuiltins {
    private static final byte[] BLOCKED = new byte[0];

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BufferedReaderMixinBuiltinsFactory.getFactories();
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class NextNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        NextNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static PBytes doit(VirtualFrame frame, PBuffered self, @Bind(value="this") Node inliningTarget, @Cached(value="create(T_READLINE)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached BufferedReadlineNode readlineNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            checkIsClosedNode.execute(frame, self);
            byte[] line = readlineNode.execute(frame, inliningTarget, self, -1);
            if (line.length == 0) {
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            return factory.createBytes(line);
        }
    }

    @Builtin(name="peek", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="0", useDefaultForNone=true)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class PeekNode
    extends AbstractBufferedIOBuiltins.PythonBinaryWithInitErrorClinicBuiltinNode {
        PeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedReaderMixinBuiltinsClinicProviders.PeekNodeClinicProviderGen.INSTANCE;
        }

        static byte[] bufferedreaderPeekUnlocked(VirtualFrame frame, Node inliningTarget, PBuffered self, FillBufferNode fillBufferNode) {
            int have = BufferedIOUtil.safeDowncast(self);
            if (have > 0) {
                return PythonUtils.arrayCopyOfRange(self.getBuffer(), self.getPos(), self.getPos() + have);
            }
            self.resetRead();
            int r = fillBufferNode.execute(frame, inliningTarget, self);
            if (r == -2) {
                r = 0;
            }
            self.setPos(0);
            return PythonUtils.arrayCopyOf(self.getBuffer(), r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, int size, @Bind(value="this") Node inliningTarget, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached(value="create(T_PEEK)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached FillBufferNode fillBufferNode, @Cached BufferedIONodes.FlushAndRewindUnlockedNode flushAndRewindUnlockedNode, @Cached PythonObjectFactory factory) {
            checkIsClosedNode.execute(frame, self);
            try {
                lock.enter(inliningTarget, self);
                if (self.isWritable()) {
                    flushAndRewindUnlockedNode.execute(frame, inliningTarget, self);
                }
                PBytes pBytes = factory.createBytes(PeekNode.bufferedreaderPeekUnlocked(frame, inliningTarget, self, fillBufferNode));
                return pBytes;
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends AbstractBufferedIOBuiltins.PythonBinaryWithInitErrorClinicBuiltinNode {
        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedReaderMixinBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.isOK()"})
        static PBytes doit(VirtualFrame frame, PBuffered self, int size, @Bind(value="this") Node inliningTarget, @Cached(value="create(T_READLINE)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached BufferedReadlineNode readlineNode, @Cached PythonObjectFactory factory) {
            checkIsClosedNode.execute(frame, self);
            byte[] res = readlineNode.execute(frame, inliningTarget, self, size);
            return factory.createBytes(res);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class BufferedReadlineNode
    extends PNodeWithContext {
        BufferedReadlineNode() {
        }

        public abstract byte[] execute(VirtualFrame var1, Node var2, PBuffered var3, int var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static byte[] readline(VirtualFrame frame, Node inliningTarget, PBuffered self, int size, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached BufferedIONodes.FlushAndRewindUnlockedNode flushAndRewindUnlockedNode, @Cached FillBufferNode fillBufferNode, @Cached InlinedConditionProfile notFound, @Cached InlinedConditionProfile reachedLimit) {
            int idx;
            int limit = size;
            int n = BufferedIOUtil.safeDowncast(self);
            if (limit >= 0 && n > limit) {
                n = limit;
            }
            if (notFound.profile(inliningTarget, (idx = BytesUtils.memchr(self.getBuffer(), self.getPos(), (byte)10, n)) != -1)) {
                byte[] res = PythonUtils.arrayCopyOfRange(self.getBuffer(), self.getPos(), idx + 1);
                self.incPos(idx - self.getPos() + 1);
                return res;
            }
            if (reachedLimit.profile(inliningTarget, n == limit)) {
                byte[] res = new byte[n];
                PythonUtils.arraycopy(self.getBuffer(), self.getPos(), res, 0, n);
                self.incPos(n);
                return res;
            }
            lock.enter(inliningTarget, self);
            try {
                ByteArrayOutputStream chunks = BytesUtils.createOutputStream();
                if (n > 0) {
                    BytesUtils.append(chunks, self.getBuffer(), self.getPos(), n);
                    self.incPos(n);
                    if (limit >= 0) {
                        limit -= n;
                    }
                }
                if (self.isWritable()) {
                    flushAndRewindUnlockedNode.execute(frame, inliningTarget, self);
                }
                while (true) {
                    self.resetRead();
                    n = fillBufferNode.execute(frame, inliningTarget, self);
                    if (n <= 0) break;
                    if (limit >= 0 && n > limit) {
                        n = limit;
                    }
                    int end = n;
                    int s = 0;
                    while (s < end) {
                        if (self.getBuffer()[s++] != 10) continue;
                        BytesUtils.append(chunks, self.getBuffer(), 0, s);
                        self.setPos(s);
                        byte[] byArray = BytesUtils.toByteArray(chunks);
                        return byArray;
                    }
                    if (n == limit) {
                        BytesUtils.append(chunks, self.getBuffer(), 0, n);
                        self.setPos(n);
                        byte[] byArray = BytesUtils.toByteArray(chunks);
                        return byArray;
                    }
                    BytesUtils.append(chunks, self.getBuffer(), 0, n);
                    if (limit < 0) continue;
                    limit -= n;
                }
                byte[] byArray = BytesUtils.toByteArray(chunks);
                return byArray;
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }
    }

    @Builtin(name="readinto1", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer)
    @GenerateNodeFactory
    static abstract class ReadInto1Node
    extends ReadIntoNode {
        ReadInto1Node() {
        }

        @Override
        protected boolean isReadinto1Mode() {
            return true;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedReaderMixinBuiltinsClinicProviders.ReadInto1NodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="readinto", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer)
    @GenerateNodeFactory
    static abstract class ReadIntoNode
    extends AbstractBufferedIOBuiltins.PythonBinaryWithInitErrorClinicBuiltinNode {
        @Node.Child
        private BufferedIONodes.CheckIsClosedNode checkIsClosedNode = BufferedIONodesFactory.CheckIsClosedNodeGen.create(IONodes.T_READLINE);

        ReadIntoNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()"}, limit="3")
        Object bufferedReadintoGeneric(VirtualFrame frame, PBuffered self, Object buffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached BufferedIONodes.FlushAndRewindUnlockedNode flushAndRewindUnlockedNode, @Cached RawReadNode rawReadNode, @Cached FillBufferNode fillBufferNode) {
            this.checkIsClosedNode.execute(frame, self);
            try {
                lock.enter(inliningTarget, self);
                int bufLen = bufferLib.getBufferLength(buffer);
                int written = 0;
                int n = BufferedIOUtil.safeDowncast(self);
                if (n > 0) {
                    if (n >= bufLen) {
                        bufferLib.writeFromByteArray(buffer, 0, self.getBuffer(), self.getPos(), bufLen);
                        self.incPos(bufLen);
                        Integer n2 = bufLen;
                        return n2;
                    }
                    bufferLib.writeFromByteArray(buffer, 0, self.getBuffer(), self.getPos(), n);
                    self.incPos(n);
                    written = n;
                }
                if (self.isWritable()) {
                    flushAndRewindUnlockedNode.execute(frame, inliningTarget, self);
                }
                self.resetRead();
                self.setPos(0);
                for (int remaining = bufLen - written; remaining > 0; remaining -= n) {
                    block17: {
                        block15: {
                            block16: {
                                block14: {
                                    if (remaining <= self.getBufferSize()) break block14;
                                    byte[] fill = rawReadNode.execute(frame, inliningTarget, self, remaining);
                                    if (fill == BLOCKED) {
                                        n = -2;
                                    } else {
                                        n = fill.length;
                                        bufferLib.writeFromByteArray(buffer, written, fill, 0, n);
                                    }
                                    break block15;
                                }
                                if (this.isReadinto1Mode() && written != 0) break block16;
                                n = fillBufferNode.execute(frame, inliningTarget, self);
                                if (n <= 0) break block15;
                                if (n > remaining) {
                                    n = remaining;
                                }
                                bufferLib.writeFromByteArray(buffer, written, self.getBuffer(), self.getPos(), n);
                                self.incPos(n);
                                break block17;
                            }
                            n = 0;
                        }
                        if (n == 0 || n == -2 && written > 0) break;
                        if (n == -2) {
                            PNone pNone = PNone.NONE;
                            return pNone;
                        }
                        if (this.isReadinto1Mode()) {
                            written += n;
                            break;
                        }
                    }
                    written += n;
                }
                Integer n3 = written;
                return n3;
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        protected boolean isReadinto1Mode() {
            return false;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedReaderMixinBuiltinsClinicProviders.ReadIntoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="read1", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class Read1Node
    extends AbstractBufferedIOBuiltins.PythonBinaryWithInitErrorClinicBuiltinNode {
        Read1Node() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedReaderMixinBuiltinsClinicProviders.Read1NodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()"})
        static PBytes doit(VirtualFrame frame, PBuffered self, int size, @Bind(value="this") Node inliningTarget, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached(value="create(T_READ)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached RawReadNode rawReadNode, @Cached PythonObjectFactory factory) {
            checkIsClosedNode.execute(frame, self);
            int n = size;
            if (n < 0) {
                n = self.getBufferSize();
            }
            if (n == 0) {
                return factory.createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
            }
            int have = BufferedIOUtil.safeDowncast(self);
            if (have > 0) {
                n = have < n ? have : n;
                byte[] b = ReadNode.bufferedreaderReadFast(self, n);
                return factory.createBytes(b);
            }
            try {
                lock.enter(inliningTarget, self);
                self.resetRead();
                byte[] fill = rawReadNode.execute(frame, inliningTarget, self, n);
                PBytes pBytes = factory.createBytes(fill == BLOCKED ? PythonUtils.EMPTY_BYTE_ARRAY : fill);
                return pBytes;
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @ImportStatic(value={AbstractBufferedIOBuiltins.class})
    @GenerateNodeFactory
    static abstract class ReadNode
    extends AbstractBufferedIOBuiltins.PythonBinaryWithInitErrorClinicBuiltinNode {
        @Node.Child
        private BufferedIONodes.CheckIsClosedNode checkIsClosedNode = BufferedIONodesFactory.CheckIsClosedNodeGen.create(IONodes.T_READ);
        public static final TruffleString T_READALL = PythonUtils.tsLiteral("readall");

        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedReaderMixinBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        protected static boolean isValidSize(int size) {
            return size >= -1;
        }

        protected static boolean isReadAll(int size) {
            return size == -1;
        }

        public static boolean isReadFast(PBuffered self, int size) {
            return size <= BufferedIOUtil.safeDowncast(self);
        }

        @Specialization(guards={"self.isOK()", "size == 0"})
        Object empty(VirtualFrame frame, PBuffered self, int size, @Cached.Shared @Cached PythonObjectFactory factory) {
            this.checkIsClosedNode.execute(frame, self);
            return factory.createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
        }

        public static byte[] bufferedreaderReadFast(PBuffered self, int size) {
            byte[] res = PythonUtils.arrayCopyOfRange(self.getBuffer(), self.getPos(), self.getPos() + size);
            self.incPos(size);
            return res;
        }

        @Specialization(guards={"self.isOK()", "size > 0", "isReadFast(self, size)"})
        Object readFast(VirtualFrame frame, PBuffered self, int size, @Cached.Shared @Cached PythonObjectFactory factory) {
            this.checkIsClosedNode.execute(frame, self);
            return factory.createBytes(ReadNode.bufferedreaderReadFast(self, size));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()", "size > 0", "!isReadFast(self, size)"})
        Object bufferedreaderReadGeneric(VirtualFrame frame, PBuffered self, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BufferedIONodes.EnterBufferedNode lock, @Cached RawReadNode rawReadNode, @Cached FillBufferNode fillBufferNode, @Cached.Exclusive @Cached BufferedIONodes.FlushAndRewindUnlockedNode flushAndRewindUnlockedNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            this.checkIsClosedNode.execute(frame, self);
            try {
                int r;
                lock.enter(inliningTarget, self);
                int currentSize = BufferedIOUtil.safeDowncast(self);
                if (size <= currentSize) {
                    PBytes pBytes = factory.createBytes(ReadNode.bufferedreaderReadFast(self, size));
                    return pBytes;
                }
                byte[] res = new byte[size];
                int remaining = size;
                int written = 0;
                if (currentSize > 0) {
                    PythonUtils.arraycopy(self.getBuffer(), self.getPos(), res, 0, currentSize);
                    remaining -= currentSize;
                    written += currentSize;
                    self.incPos(currentSize);
                }
                if (self.isWritable()) {
                    flushAndRewindUnlockedNode.execute(frame, inliningTarget, self);
                }
                self.resetRead();
                while (remaining > 0 && (r = BufferedIOUtil.minusLastBlock(self, remaining)) != 0) {
                    byte[] fill = rawReadNode.execute(frame, inliningTarget, self, r);
                    if (fill == BLOCKED) {
                        r = -2;
                    } else {
                        r = fill.length;
                        PythonUtils.arraycopy(fill, 0, res, written, r);
                    }
                    if (r == 0 || r == -2) {
                        if (r == 0 || written > 0) {
                            PBytes pBytes = factory.createBytes(PythonUtils.arrayCopyOf(res, written));
                            return pBytes;
                        }
                        PNone pNone = PNone.NONE;
                        return pNone;
                    }
                    remaining -= r;
                    written += r;
                }
                assert (remaining <= self.getBufferSize());
                self.setPos(0);
                self.setRawPos(0L);
                self.setReadEnd(0);
                while (remaining > 0 && self.getReadEnd() < self.getBufferSize()) {
                    r = fillBufferNode.execute(frame, inliningTarget, self);
                    if (r == 0 || r == -2) {
                        PythonAbstractObject pythonAbstractObject;
                        if (r == 0 || written > 0) {
                            pythonAbstractObject = factory.createBytes(PythonUtils.arrayCopyOf(res, written));
                            return pythonAbstractObject;
                        }
                        pythonAbstractObject = PNone.NONE;
                        return pythonAbstractObject;
                    }
                    if (remaining > r) {
                        PythonUtils.arraycopy(self.getBuffer(), self.getPos(), res, written, r);
                        written += r;
                        self.incPos(r);
                        remaining -= r;
                    } else {
                        PythonUtils.arraycopy(self.getBuffer(), self.getPos(), res, written, remaining);
                        written += remaining;
                        self.incPos(remaining);
                        remaining = 0;
                    }
                    if (remaining != 0) continue;
                    break;
                }
                PBytes pBytes = factory.createBytes(res);
                return pBytes;
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }

        @Specialization(guards={"self.isOK()", "isReadAll(size)"})
        Object bufferedreaderReadAll(VirtualFrame frame, PBuffered self, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BufferedIONodes.EnterBufferedNode lock, @Cached.Exclusive @Cached BufferedIONodes.FlushAndRewindUnlockedNode flushAndRewindUnlockedNode, @Cached(value="create(T_READALL)") LookupAttributeInMRONode readallAttr, @Cached InlinedConditionProfile hasReadallProfile, @Cached InlinedConditionProfile currentSize0Profile, @Cached CallUnaryMethodNode dispatchGetattribute, @Cached GetClassNode getClassNode, @Cached PyObjectCallMethodObjArgs callMethod, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            this.checkIsClosedNode.execute(frame, self);
            try {
                lock.enter(inliningTarget, self);
                byte[] data = PythonUtils.EMPTY_BYTE_ARRAY;
                int currentSize = BufferedIOUtil.safeDowncast(self);
                if (currentSize0Profile.profile(inliningTarget, currentSize != 0)) {
                    data = PythonUtils.arrayCopyOfRange(self.getBuffer(), self.getPos(), self.getPos() + currentSize);
                    self.incPos(currentSize);
                }
                if (self.isWritable()) {
                    flushAndRewindUnlockedNode.execute(frame, inliningTarget, self);
                }
                self.resetRead();
                Object clazz = getClassNode.execute(inliningTarget, self.getRaw());
                Object readall = readallAttr.execute(clazz);
                if (hasReadallProfile.profile(inliningTarget, readall != PNone.NO_VALUE)) {
                    Object tmp = dispatchGetattribute.executeObject((Frame)frame, readall, self.getRaw());
                    if (tmp != PNone.NONE && !(tmp instanceof PBytes)) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.IO_S_SHOULD_RETURN_BYTES, "readall()");
                    }
                    if (currentSize0Profile.profile(inliningTarget, currentSize != 0)) {
                        if (tmp != PNone.NONE) {
                            int bytesLen = bufferLib.getBufferLength(tmp);
                            byte[] res = new byte[data.length + bytesLen];
                            PythonUtils.arraycopy(data, 0, res, 0, data.length);
                            bufferLib.readIntoByteArray(tmp, 0, res, data.length, bytesLen);
                            PBytes pBytes = factory.createBytes(res);
                            return pBytes;
                        }
                        PBytes bytesLen = factory.createBytes(data);
                        return bytesLen;
                    }
                    Object bytesLen = tmp;
                    return bytesLen;
                }
                ByteArrayOutputStream chunks = BytesUtils.createOutputStream();
                int dataLen = data.length;
                while (true) {
                    Object r;
                    if (dataLen != 0) {
                        BytesUtils.append(chunks, data, dataLen);
                        dataLen = 0;
                    }
                    if ((r = callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_READ, new Object[0])) != PNone.NONE && !(r instanceof PBytes)) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.IO_S_SHOULD_RETURN_BYTES, "read()");
                    }
                    if (r != PNone.NONE) {
                        dataLen = bufferLib.getBufferLength(r);
                        data = bufferLib.getInternalOrCopiedByteArray(r);
                    }
                    if (dataLen == 0) {
                        if (currentSize == 0) {
                            Object object = r;
                            return object;
                        }
                        PBytes pBytes = factory.createBytes(BytesUtils.toByteArray(chunks));
                        return pBytes;
                    }
                    currentSize += dataLen;
                    if (self.getAbsPos() == -1L) continue;
                    self.incAbsPos(dataLen);
                }
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }

        @Specialization(guards={"self.isOK()", "!isValidSize(size)"})
        static Object initError(VirtualFrame frame, PBuffered self, int size, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEG_OR_NEG_1);
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        ReadableNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_READABLE, new Object[0]);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class FillBufferNode
    extends PNodeWithContext {
        FillBufferNode() {
        }

        public abstract int execute(VirtualFrame var1, Node var2, PBuffered var3);

        @Specialization
        static int bufferedreaderFillBuffer(VirtualFrame frame, Node inliningTarget, PBuffered self, @Cached RawReadNode rawReadNode) {
            int start = BufferedIOUtil.isValidReadBuffer(self) ? self.getReadEnd() : 0;
            int len = self.getBufferSize() - start;
            byte[] fill = rawReadNode.execute(frame, inliningTarget, self, len);
            if (fill == BLOCKED) {
                return -2;
            }
            int n = fill.length;
            if (n == 0) {
                return n;
            }
            PythonUtils.arraycopy(fill, 0, self.getBuffer(), start, n);
            self.setReadEnd(start + n);
            self.setRawPos(start + n);
            return n;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class RawReadNode
    extends PNodeWithContext {
        RawReadNode() {
        }

        public abstract byte[] execute(VirtualFrame var1, Node var2, PBuffered var3, int var4);

        @Specialization
        static byte[] bufferedreaderRawRead(VirtualFrame frame, Node inliningTarget, PBuffered self, int len, @Cached(inline=false) BytesNodes.ToBytesNode toBytes, @Cached(inline=false) PythonObjectFactory factory, @Cached PyObjectCallMethodObjArgs callMethodReadInto, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedConditionProfile osError, @Cached PRaiseNode.Lazy lazyRaiseNode) {
            int n;
            PByteArray memobj = factory.createByteArray(new byte[len]);
            Object res = callMethodReadInto.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_READINTO, memobj);
            if (res == PNone.NONE) {
                return BLOCKED;
            }
            try {
                n = asSizeNode.executeExact((Frame)frame, inliningTarget, res, PythonErrorType.ValueError);
            }
            catch (PException e) {
                throw lazyRaiseNode.get(inliningTarget).raiseWithCause(PythonErrorType.OSError, e, ErrorMessages.RAW_READINTO_FAILED, new Object[0]);
            }
            if (osError.profile(inliningTarget, n < 0 || n > len)) {
                throw lazyRaiseNode.get(inliningTarget).raise(PythonErrorType.OSError, ErrorMessages.IO_S_INVALID_LENGTH, "readinto()", n, len);
            }
            if (n > 0 && self.getAbsPos() != -1L) {
                self.incAbsPos(n);
            }
            if (n == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            byte[] bytes = toBytes.execute(memobj);
            if (n < len) {
                return PythonUtils.arrayCopyOf(bytes, n);
            }
            return bytes;
        }
    }
}

