/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.MultiprocessingGraalPyModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.multiprocessing.MultiprocessingGraalPyModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.multiprocessing.PGraalPySemLock;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;

@CoreFunctions(defineModule="_multiprocessing_graalpy")
public final class MultiprocessingGraalPyModuleBuiltins
extends PythonBuiltins {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(MultiprocessingGraalPyModuleBuiltins.class);

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultiprocessingGraalPyModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("flags", (Object)core.factory().createDict());
        super.initialize(core);
    }

    private static long convertTid(long tid) {
        return tid * -1L;
    }

    @Builtin(name="_select", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class SelectNode
    extends PythonBuiltinNode {
        SelectNode() {
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object multiprocessingFdsList, Object multiprocessingObjsList, Object posixFileObjsList, Object timeoutObj, @Bind(value="this") Node inliningTarget, @Cached PosixModuleBuiltins.FileDescriptorConversionNode fdConvertor, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectGetItem getItem, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached ListNodes.FastConstructListNode constructListNode, @Cached CastToJavaIntLossyNode castToJava, @Cached CastToJavaDoubleNode castToDouble, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            PythonContext context = this.getContext();
            PythonContext.SharedMultiprocessingData sharedData = context.getSharedMultiprocessingData();
            PSequence pSequence = constructListNode.execute((Frame)frame, inliningTarget, multiprocessingFdsList);
            int size = sizeNode.execute((Frame)frame, inliningTarget, pSequence);
            int[] multiprocessingFds = new int[size];
            for (int i = 0; i < size; ++i) {
                Object pythonObject = getItem.execute((Frame)frame, inliningTarget, pSequence, i);
                multiprocessingFds[i] = SelectNode.toInt(inliningTarget, castToJava, pythonObject);
            }
            Object[] posixFileObjs = getObjectArrayNode.execute(inliningTarget, posixFileObjsList);
            int[] posixFds = new int[posixFileObjs.length];
            for (int i = 0; i < posixFileObjs.length; ++i) {
                posixFds[i] = SelectNode.toInt(inliningTarget, castToJava, fdConvertor.execute(frame, posixFileObjs[i]));
            }
            double timeout = castToDouble.execute(inliningTarget, timeoutObj);
            Object[] multiprocessingObjs = getObjectArrayNode.execute(inliningTarget, multiprocessingObjsList);
            gil.release(true);
            try {
                int i;
                boolean[] selectedMultiprocessingFds = new boolean[multiprocessingFds.length];
                boolean[] selectedPosixFds = new boolean[posixFds.length];
                SelectNode.doSelect(context.getPosixSupport(), sharedData, posixFds, selectedPosixFds, multiprocessingFds, selectedMultiprocessingFds, timeout);
                ArrayBuilder<Object> result = new ArrayBuilder<Object>(4);
                for (i = 0; i < selectedMultiprocessingFds.length; ++i) {
                    if (!selectedMultiprocessingFds[i]) continue;
                    result.add(multiprocessingObjs[i]);
                }
                for (i = 0; i < selectedPosixFds.length; ++i) {
                    if (!selectedPosixFds[i]) continue;
                    result.add(posixFileObjs[i]);
                }
                PList pList = factory.createList(result.toArray(new Object[0]));
                return pList;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                gil.acquire();
            }
        }

        private static int toInt(Node inliningTarget, CastToJavaIntLossyNode castToJava, Object pythonObject) {
            try {
                return castToJava.execute(inliningTarget, pythonObject);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void doSelect(Object posix, PythonContext.SharedMultiprocessingData sharedData, int[] posixFds, boolean[] selectedPosixFds, int[] multiprocessingFds, boolean[] selectedMultiprocessingFds, double timeoutInS) throws PosixSupportLibrary.PosixException {
            PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
            boolean blocking = timeoutInS >= 0.0;
            boolean untilReady = timeoutInS == 0.0;
            long deadline = 0L;
            if (blocking && !untilReady) {
                long timeout = (long)(timeoutInS * 1.0E9);
                deadline = System.nanoTime() + timeout;
            }
            while (true) {
                boolean selected = false;
                if (posixFds.length > 0) {
                    PosixSupportLibrary.SelectResult selectResult = posixLib.select(posix, posixFds, PythonUtils.EMPTY_INT_ARRAY, PythonUtils.EMPTY_INT_ARRAY, PosixSupportLibrary.Timeval.SELECT_TIMEOUT_NOW);
                    System.arraycopy(selectResult.getReadFds(), 0, selectedPosixFds, 0, selectedPosixFds.length);
                    if (blocking) {
                        for (boolean b : selectedPosixFds) {
                            selected |= b;
                        }
                    }
                }
                for (int i = 0; i < multiprocessingFds.length; ++i) {
                    int fd = multiprocessingFds[i];
                    boolean bl = selectedMultiprocessingFds[i] = !sharedData.isBlocking(fd);
                    if (!selectedMultiprocessingFds[i]) continue;
                    selected = true;
                }
                if (!blocking || selected) {
                    return;
                }
                if (deadline != 0L && deadline - System.nanoTime() < 0L) {
                    return;
                }
                Thread.yield();
            }
        }
    }

    @Builtin(name="_close", minNumOfPositionalArgs=1, parameterNames={"fd"})
    @GenerateNodeFactory
    public static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PNone close(int fd) {
            assert (fd < 0);
            PythonContext.SharedMultiprocessingData sharedData = this.getContext().getSharedMultiprocessingData();
            if (!sharedData.decrementFDRefCount(fd)) {
                sharedData.closePipe(fd);
            }
            return PNone.NONE;
        }

        @Specialization
        PNone close(long fd) {
            return this.close((int)fd);
        }
    }

    @Builtin(name="_read", minNumOfPositionalArgs=2, parameterNames={"fd", "length"})
    @GenerateNodeFactory
    public static abstract class ReadNode
    extends PythonBinaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object doReadInt(int fd, Object length, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PythonObjectFactory factory) {
            PythonContext.SharedMultiprocessingData sharedData = this.getContext().getSharedMultiprocessingData();
            gil.release(true);
            try {
                Object data = sharedData.takePipeData(this, fd, () -> {
                    throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.OSError, ErrorMessages.BAD_FILE_DESCRIPTOR);
                });
                if (data == PNone.NONE) {
                    PBytes pBytes = factory.createBytes(PythonUtils.EMPTY_BYTE_ARRAY, 0, 0);
                    return pBytes;
                }
                PBytes pBytes = factory.createBytes((byte[])data);
                return pBytes;
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization
        Object doReadLong(long fd, Object length, @Cached.Shared @Cached GilNode gil, @Cached.Shared @Cached PythonObjectFactory factory) {
            return this.doReadInt((int)fd, length, gil, factory);
        }
    }

    @Builtin(name="_write", minNumOfPositionalArgs=2, parameterNames={"fd", "data"})
    @GenerateNodeFactory
    public static abstract class WriteNode
    extends PythonBinaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="1")
        Object doWrite(int fd, PBytes data, @CachedLibrary(value="data") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached GilNode gil) {
            PythonContext.SharedMultiprocessingData sharedData = this.getContext().getSharedMultiprocessingData();
            gil.release(true);
            try {
                byte[] bytes = bufferLib.getCopiedByteArray(data);
                sharedData.addPipeData(fd, bytes, () -> {
                    throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.OSError, ErrorMessages.BAD_FILE_DESCRIPTOR);
                }, () -> {
                    throw PConstructAndRaiseNode.getUncached().raiseOSError(null, OSErrorEnum.EPIPE.getNumber(), OSErrorEnum.EPIPE.getMessage(), null);
                });
                Integer n = bytes.length;
                return n;
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(limit="1")
        Object doWrite(long fd, PBytes data, @CachedLibrary(value="data") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached GilNode gil) {
            return this.doWrite((int)fd, data, bufferLib, gil);
        }
    }

    @Builtin(name="_pipe", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class PipeNode
    extends PythonBuiltinNode {
        PipeNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        PTuple pipe(@Cached GilNode gil, @Cached PythonObjectFactory factory) {
            int[] pipe;
            PythonContext ctx = this.getContext();
            PythonContext.SharedMultiprocessingData sharedData = ctx.getSharedMultiprocessingData();
            gil.release(true);
            try {
                pipe = sharedData.pipe();
                ctx.getChildContextFDs().add(pipe[0]);
                ctx.getChildContextFDs().add(pipe[1]);
            }
            finally {
                gil.acquire();
            }
            return factory.createTuple(new Object[]{pipe[0], pipe[1]});
        }
    }

    @Builtin(name="_terminate_spawned_thread", minNumOfPositionalArgs=2, parameterNames={"tid", "sig"})
    @GenerateNodeFactory
    static abstract class TerminateThreadNode
    extends PythonBinaryBuiltinNode {
        TerminateThreadNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object terminate(long id, PInt sig) {
            PythonContext.SharedMultiprocessingData multiprocessing = this.getContext().getSharedMultiprocessingData();
            Thread thread = multiprocessing.getChildContextThread(MultiprocessingGraalPyModuleBuiltins.convertTid(id));
            if (thread != null && thread.isAlive()) {
                PythonContext.ChildContextData data = multiprocessing.getChildContextData(MultiprocessingGraalPyModuleBuiltins.convertTid(id));
                try {
                    data.awaitRunning();
                    TruffleContext truffleCtx = data.getTruffleContext();
                    if (truffleCtx != null && !truffleCtx.isCancelling() && data.compareAndSetExiting(false, true)) {
                        LOGGER.fine("terminating spawned thread");
                        data.setSignaled(sig.intValue());
                        truffleCtx.closeCancelled((Node)this, "_terminate_spawned_thread");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.finest("got interrupt while terminating spawned thread");
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="_waittid", minNumOfPositionalArgs=2, parameterNames={"tid", "options"})
    @GenerateNodeFactory
    static abstract class WaitTidNode
    extends PythonBinaryBuiltinNode {
        WaitTidNode() {
        }

        @Specialization
        PTuple waittid(long id, int options, @Cached PythonObjectFactory factory) {
            long tid = MultiprocessingGraalPyModuleBuiltins.convertTid(id);
            PythonContext.SharedMultiprocessingData multiprocessing = this.getContext().getSharedMultiprocessingData();
            Thread thread = multiprocessing.getChildContextThread(tid);
            if (thread != null && thread.isAlive()) {
                return factory.createTuple(new Object[]{0, 0, 0});
            }
            PythonContext.ChildContextData data = multiprocessing.getChildContextData(tid);
            multiprocessing.removeChildContextData(tid);
            return factory.createTuple(new Object[]{id, data.wasSignaled() ? data.getExitCode() : 0, data.getExitCode()});
        }
    }

    @Builtin(name="_gettid")
    @GenerateNodeFactory
    static abstract class GetTidNode
    extends PythonBuiltinNode {
        GetTidNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long getTid(@Bind(value="this") Node inliningTarget) {
            return MultiprocessingGraalPyModuleBuiltins.convertTid(PThread.getThreadId(Objects.requireNonNull(PythonContext.get(inliningTarget).getMainThread())));
        }
    }

    @Builtin(name="_spawn_context", minNumOfPositionalArgs=3, parameterNames={"fd", "sentinel", "keepFds"})
    @GenerateNodeFactory
    static abstract class SpawnContextNode
    extends PythonBuiltinNode {
        SpawnContextNode() {
        }

        @Specialization
        long spawn(int fd, int sentinel, PList keepFds, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetItemNode getItem, @Cached CastToJavaIntExactNode castToJavaIntNode) {
            SequenceStorage storage = keepFds.getSequenceStorage();
            int length = storage.length();
            int[] keep = new int[length];
            for (int i = 0; i < length; ++i) {
                Object item = getItem.execute(storage, i);
                keep[i] = castToJavaIntNode.execute(inliningTarget, item);
            }
            PythonContext context = this.getContext();
            long tid = context.spawnTruffleContext(fd, sentinel, keep);
            return MultiprocessingGraalPyModuleBuiltins.convertTid(tid);
        }
    }

    @Builtin(name="sem_unlink", parameterNames={"name"})
    @GenerateNodeFactory
    static abstract class SemUnlink
    extends PythonUnaryBuiltinNode {
        SemUnlink() {
        }

        @Specialization
        PNone doit(VirtualFrame frame, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            Semaphore prev = this.getContext().getSharedMultiprocessingData().removeNamedSemaphore(name);
            if (prev == null) {
                throw constructAndRaiseNode.get(inliningTarget).raiseFileNotFoundError((Frame)frame, ErrorMessages.NO_SUCH_FILE_OR_DIR, "semaphores", name);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="SemLock", parameterNames={"cls", "kind", "value", "maxvalue", "name", "unlink"}, constructsClass=PythonBuiltinClassType.PGraalPySemLock)
    @ArgumentsClinic(value={@ArgumentClinic(name="kind", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="value", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="maxvalue", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="unlink", conversion=ArgumentClinic.ClinicConversion.IntToBoolean)})
    @GenerateNodeFactory
    static abstract class SemLockNode
    extends PythonClinicBuiltinNode {
        SemLockNode() {
        }

        @Specialization
        static PGraalPySemLock construct(Object cls, int kind, int value, int maxValue, TruffleString name, boolean unlink, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (kind != 0 && kind != 1) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNRECOGNIZED_KIND);
            }
            Semaphore semaphore = SemLockNode.newSemaphore(value);
            if (!unlink) {
                PythonContext.SharedMultiprocessingData multiprocessing = PythonContext.get(inliningTarget).getSharedMultiprocessingData();
                if (multiprocessing.getNamedSemaphore(name) != null) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.FileExistsError, ErrorMessages.SEMAPHORE_NAME_TAKEN, name);
                }
                multiprocessing.putNamedSemaphore(name, semaphore);
            }
            return factory.createGraalPySemLock(cls, name, kind, semaphore);
        }

        @CompilerDirectives.TruffleBoundary
        private static Semaphore newSemaphore(int value) {
            return new Semaphore(value);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultiprocessingGraalPyModuleBuiltinsClinicProviders.SemLockNodeClinicProviderGen.INSTANCE;
        }
    }
}

