/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.buffer;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PythonBufferAcquireLibrary.class)
final class PythonBufferAcquireLibraryGen
extends LibraryFactory<PythonBufferAcquireLibrary> {
    private static final Class<PythonBufferAcquireLibrary> LIBRARY_CLASS = PythonBufferAcquireLibraryGen.lazyLibraryClass();
    private static final Message HAS_BUFFER = new MessageImpl("hasBuffer", 0, false, Boolean.TYPE, Object.class);
    private static final Message ACQUIRE = new MessageImpl("acquire", 1, false, Object.class, Object.class, Integer.TYPE);
    private static final PythonBufferAcquireLibraryGen INSTANCE = new PythonBufferAcquireLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private PythonBufferAcquireLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(HAS_BUFFER, ACQUIRE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return PythonBufferAcquireLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected PythonBufferAcquireLibrary createAssertions(PythonBufferAcquireLibrary delegate) {
        return new PythonBufferAcquireLibrary.Assertions(delegate);
    }

    protected PythonBufferAcquireLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected PythonBufferAcquireLibrary createDelegate(PythonBufferAcquireLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        PythonBufferAcquireLibrary lib = (PythonBufferAcquireLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.hasBuffer(receiver);
            }
            case 1: {
                return lib.acquire(receiver, (Integer)args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected PythonBufferAcquireLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected PythonBufferAcquireLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<PythonBufferAcquireLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary", false, PythonBufferAcquireLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static final class Proxy
    extends PythonBufferAcquireLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean hasBuffer(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, HAS_BUFFER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object acquire(Object receiver_, int flags) {
            try {
                return this.lib.send(receiver_, ACQUIRE, new Object[]{flags});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static final class Delegate
    extends PythonBufferAcquireLibrary {
        @Node.Child
        private PythonBufferAcquireLibrary delegateLibrary;

        Delegate(PythonBufferAcquireLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean hasBuffer(Object receiver_) {
            if (PythonBufferAcquireLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = PythonBufferAcquireLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAcquireLibrary)PythonBufferAcquireLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).hasBuffer(delegate);
            }
            return this.delegateLibrary.hasBuffer(receiver_);
        }

        @Override
        public Object acquire(Object receiver_, int flags) {
            if (PythonBufferAcquireLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = PythonBufferAcquireLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAcquireLibrary)PythonBufferAcquireLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).acquire(delegate, flags);
            }
            return this.delegateLibrary.acquire(receiver_, flags);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(PythonBufferAcquireLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static abstract class CachedDispatch
    extends PythonBufferAcquireLibrary {
        @Node.Child
        PythonBufferAcquireLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(PythonBufferAcquireLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean hasBuffer(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAcquireLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.hasBuffer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object acquire(Object receiver_, int flags) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAcquireLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.acquire(receiver_, flags);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                PythonBufferAcquireLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (PythonBufferAcquireLibrary)this.insert((Node)((PythonBufferAcquireLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        PythonBufferAcquireLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (PythonBufferAcquireLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((PythonBufferAcquireLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends PythonBufferAcquireLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasBuffer(Object receiver_) {
            return ((PythonBufferAcquireLibrary)INSTANCE.getUncached(receiver_)).hasBuffer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object acquire(Object receiver_, int flags) {
            return ((PythonBufferAcquireLibrary)INSTANCE.getUncached(receiver_)).acquire(receiver_, flags);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static final class Default
    extends LibraryExport<PythonBufferAcquireLibrary> {
        private Default() {
            super(PythonBufferAcquireLibrary.class, Object.class, false, false, 0);
        }

        protected PythonBufferAcquireLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected PythonBufferAcquireLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=PythonBufferAcquireLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends PythonBufferAcquireLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasBuffer(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object acquire(Object receiver, int flags) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.acquire(receiver, flags);
            }
        }

        @GeneratedBy(value=PythonBufferAcquireLibrary.class)
        private static final class Cached
        extends PythonBufferAcquireLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean hasBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasBuffer(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object acquire(Object receiver, int flags) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.acquire(this.dynamicDispatch_.cast(receiver), flags);
            }
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(PythonBufferAcquireLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=PythonBufferAcquireLibrary.class)
    private static final class CachedToUncachedDispatch
    extends PythonBufferAcquireLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasBuffer(Object receiver_) {
            assert (PythonBufferAcquireLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PythonBufferAcquireLibrary)INSTANCE.getUncached(receiver_)).hasBuffer(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object acquire(Object receiver_, int flags) {
            assert (PythonBufferAcquireLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PythonBufferAcquireLibrary)INSTANCE.getUncached(receiver_)).acquire(receiver_, flags);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

