/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltinRegistry;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiCodeGen;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyDateTimeCAPIWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.SlotMethodDef;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.graal.python.util.WeakIdentityHashMap;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import sun.misc.Unsafe;

public final class CApiContext
extends CExtContext {
    public static final String LOGGER_CAPI_NAME = "capi";
    public static final int DEFAULT_RECURSION_LIMIT = 1000;
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger("capi");
    private static final int MAX_COLLECTION_RETRIES = 17;
    private long allocatedMemory = 0L;
    private Map<Object, AllocInfo> allocatedNativeMemory;
    private TraceMallocDomain[] traceMallocDomains;
    private Map<Object, AllocInfo> freedNativeMemory;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PrimitiveNativeWrapper[] primitiveNativeWrapperCache;
    private long maxModuleNumber;
    private final HashMap<Pair<TruffleString, TruffleString>, Object> extensions = new HashMap(4);
    private PDict internedUnicode;
    private final ArrayList<Object> modulesByIndex = new ArrayList(0);
    public final HashMap<Long, PLock> locks = new HashMap();
    public final AtomicLong lockId = new AtomicLong();
    private final ConcurrentHashMap<Long, ThreadLocal<Object>> tssStorage = new ConcurrentHashMap();
    private final AtomicLong nextTssKey = new AtomicLong();
    public Object timezoneType;
    private PyCapsule pyDateTimeCAPICapsule;
    private final HashMap<Object, ClosureInfo> callableClosureByExecutable = new HashMap();
    private final HashMap<Long, ClosureInfo> callableClosures = new HashMap();
    private final List<Object> loadedExtensions = new LinkedList<Object>();
    private static AtomicBoolean nativeCAPILoaded = new AtomicBoolean();
    private static AtomicBoolean warnedSecondContexWithNativeCAPI = new AtomicBoolean();
    private Runnable nativeFinalizerRunnable;
    private Thread nativeFinalizerShutdownHook;
    private final WeakIdentityHashMap<PythonManagedClass, PyProcsWrapper[]> procWrappers = new WeakIdentityHashMap();

    public static TruffleLogger getLogger(Class<?> clazz) {
        return PythonLanguage.getLogger("capi." + clazz.getSimpleName());
    }

    public CApiContext(PythonContext context, Object llvmLibrary, boolean useNativeBackend) {
        super(context, llvmLibrary, useNativeBackend);
        this.primitiveNativeWrapperCache = new PrimitiveNativeWrapper[262];
        for (int i = 0; i < this.primitiveNativeWrapperCache.length; ++i) {
            int value = i - 5;
            assert (CApiGuards.isSmallInteger(value));
            this.primitiveNativeWrapperCache[i] = PrimitiveNativeWrapper.createInt(value);
        }
    }

    public long getAndIncMaxModuleNumber() {
        return this.maxModuleNumber++;
    }

    @CompilerDirectives.TruffleBoundary
    void addLoadedExtensionLibrary(Object nativeLibrary) {
        this.loadedExtensions.add(nativeLibrary);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object asHex(Object ptr) {
        if (ptr instanceof Number) {
            return "0x" + Long.toHexString(((Number)ptr).longValue());
        }
        return Objects.toString(ptr);
    }

    public PDict getInternedUnicode() {
        return this.internedUnicode;
    }

    public void setInternedUnicode(PDict internedUnicode) {
        this.internedUnicode = internedUnicode;
    }

    public static Object asPointer(Object ptr, InteropLibrary lib) {
        if (lib.isPointer(ptr)) {
            try {
                return lib.asPointer(ptr);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return ptr;
    }

    public TraceMallocDomain getTraceMallocDomain(int domainIdx) {
        return this.traceMallocDomains[domainIdx];
    }

    public int findOrCreateTraceMallocDomain(int id) {
        int oldLength;
        if (this.traceMallocDomains != null) {
            for (int i = 0; i < this.traceMallocDomains.length; ++i) {
                if (this.traceMallocDomains[i].id != id) continue;
                return i;
            }
            oldLength = this.traceMallocDomains.length;
            this.traceMallocDomains = Arrays.copyOf(this.traceMallocDomains, this.traceMallocDomains.length + 1);
        } else {
            oldLength = 0;
            this.traceMallocDomains = new TraceMallocDomain[1];
        }
        this.traceMallocDomains[oldLength] = new TraceMallocDomain(id);
        return oldLength;
    }

    public long nextTssKey() {
        return this.nextTssKey.incrementAndGet();
    }

    @CompilerDirectives.TruffleBoundary
    public Object tssGet(long key) {
        ThreadLocal<Object> local = this.tssStorage.get(key);
        if (local != null) {
            return local.get();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void tssSet(long key, Object object) {
        this.tssStorage.computeIfAbsent(key, k -> new ThreadLocal()).set(object);
    }

    @CompilerDirectives.TruffleBoundary
    public void tssDelete(long key) {
        this.tssStorage.remove(key);
    }

    public PrimitiveNativeWrapper getCachedPrimitiveNativeWrapper(int i) {
        assert (CApiGuards.isSmallInteger(i));
        PrimitiveNativeWrapper primitiveNativeWrapper = this.primitiveNativeWrapperCache[i + 5];
        assert (primitiveNativeWrapper.getRefCount() > 0L);
        return primitiveNativeWrapper;
    }

    public PrimitiveNativeWrapper getCachedPrimitiveNativeWrapper(long l) {
        assert (CApiGuards.isSmallLong(l));
        return this.getCachedPrimitiveNativeWrapper((int)l);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected CExtContext.Store initializeSymbolCache() {
        PythonLanguage language = this.getContext().getLanguage();
        Shape symbolCacheShape = language.getCApiSymbolCacheShape();
        CExtContext.Store s = new CExtContext.Store(symbolCacheShape);
        for (NativeCAPISymbol sym : NativeCAPISymbol.getValues()) {
            DynamicObjectLibrary.getUncached().put((DynamicObject)s, (Object)sym, (Object)PNone.NO_VALUE);
        }
        return s;
    }

    public Object getModuleByIndex(int i) {
        if (i < this.modulesByIndex.size()) {
            return this.modulesByIndex.get(i);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public AllocInfo traceFree(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
        AllocInfo allocatedValue;
        AllocInfo freedValue;
        if (this.allocatedNativeMemory == null) {
            this.allocatedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        if (this.freedNativeMemory == null) {
            this.freedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        if ((freedValue = this.freedNativeMemory.put(ptr, allocatedValue = this.allocatedNativeMemory.remove(ptr))) != null) {
            LOGGER.severe(PythonUtils.formatJString("freeing memory that was already free'd %s (double-free)", CApiContext.asHex(ptr)));
        } else if (allocatedValue == null) {
            LOGGER.info(PythonUtils.formatJString("freeing non-allocated memory %s (maybe a double-free or we didn't trace the allocation)", CApiContext.asHex(ptr)));
        }
        return allocatedValue;
    }

    @CompilerDirectives.TruffleBoundary
    public void traceAlloc(Object ptr, PFrame.Reference curFrame, TruffleString clazzName, long size) {
        if (this.allocatedNativeMemory == null) {
            this.allocatedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        AllocInfo value = this.allocatedNativeMemory.put(ptr, new AllocInfo(clazzName, curFrame, size));
        if (this.freedNativeMemory != null) {
            this.freedNativeMemory.remove(ptr);
        }
        assert (value == null) : "native memory allocator reserved same memory twice";
    }

    public void trackObject(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
    }

    public void untrackObject(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
    }

    @CompilerDirectives.TruffleBoundary
    public void traceStaticMemory(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
        if (this.allocatedNativeMemory == null) {
            this.allocatedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        if (this.freedNativeMemory != null) {
            this.freedNativeMemory.remove(ptr);
        }
        this.allocatedNativeMemory.put(ptr, new AllocInfo(curFrame, clazzName));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isAllocated(Object ptr) {
        if (this.freedNativeMemory != null && this.freedNativeMemory.containsKey(ptr)) {
            assert (!this.allocatedNativeMemory.containsKey(ptr));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseMemoryPressure(VirtualFrame frame, Node inliningTarget, PythonContext.GetThreadStateNode getThreadStateNode, IndirectCallData indirectCallData, long size) {
        PythonContext context = this.getContext();
        if (this.allocatedMemory + size <= context.getOption(PythonOptions.MaxNativeMemory)) {
            this.allocatedMemory += size;
            return;
        }
        PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, context);
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, threadState, indirectCallData);
        try {
            this.triggerGC(context, size, inliningTarget);
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, threadState, savedState);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void triggerGC(PythonContext context, long size, Node caller) {
        long delay = 0L;
        for (int retries = 0; retries < 17; ++retries) {
            CApiContext.doGc(delay += 50L);
            CApiTransitions.pollReferenceQueue();
            PythonContext.triggerAsyncActions(caller);
            if (this.allocatedMemory + size > context.getOption(PythonOptions.MaxNativeMemory)) continue;
            this.allocatedMemory += size;
            return;
        }
        throw new OutOfMemoryError("native memory");
    }

    public void reduceMemoryPressure(long size) {
        this.allocatedMemory -= size;
    }

    @CompilerDirectives.TruffleBoundary
    private static void doGc(long millis) {
        LOGGER.fine("full GC due to native memory");
        PythonUtils.forceFullGC();
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public void checkAccess(Object pointerObject, InteropLibrary lib) {
        Object ptrVal;
        if (this.getContext().getOption(PythonOptions.TraceNativeMemory).booleanValue() && !this.isAllocated(ptrVal = CApiContext.asPointer(pointerObject, lib))) {
            LOGGER.severe(() -> "Access to invalid memory at " + String.valueOf(CApiContext.asHex(ptrVal)));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CApiContext ensureCapiWasLoaded() {
        try {
            return CApiContext.ensureCapiWasLoaded(null, PythonContext.get(null), StringLiterals.T_EMPTY_STRING, StringLiterals.T_EMPTY_STRING);
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CApiContext ensureCapiWasLoaded(Node node, PythonContext context, TruffleString name, TruffleString path) throws IOException, LoadCExtException.ImportException, LoadCExtException.ApiInitException {
        if (!context.hasCApiContext()) {
            TruffleLanguage.Env env = context.getEnv();
            InteropLibrary U = InteropLibrary.getUncached();
            TruffleFile homePath = env.getInternalTruffleFile(context.getCAPIHome().toJavaStringUncached());
            String libName = context.getLLVMSupportExt("python");
            TruffleFile capiFile = homePath.resolve(libName).getCanonicalFile(new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            try {
                Source.SourceBuilder capiSrcBuilder;
                boolean useNative;
                if (((Boolean)PythonOptions.NativeModules.getValue(env.getOptions())).booleanValue()) {
                    useNative = nativeCAPILoaded.compareAndSet(false, true);
                    if (!useNative && warnedSecondContexWithNativeCAPI.compareAndSet(false, true)) {
                        LOGGER.warning("GraalPy option 'NativeModules' is set to true, but only one context in the process can use native modules, second and other contexts fallback to NativeModules=false and will use LLVM bitcode execution via GraalVM LLVM.");
                    }
                } else {
                    useNative = false;
                }
                if (useNative) {
                    context.ensureNFILanguage(node, "NativeModules", "true");
                    capiSrcBuilder = Source.newBuilder((String)"nfi", (CharSequence)("load(RTLD_GLOBAL) \"" + capiFile.getPath() + "\""), (String)"<libpython>");
                } else {
                    context.ensureLLVMLanguage(node);
                    capiSrcBuilder = Source.newBuilder((String)"llvm", (TruffleFile)capiFile);
                }
                if (!context.getLanguage().getEngineOption(PythonOptions.ExposeInternalSources).booleanValue()) {
                    capiSrcBuilder.internal(true);
                }
                LOGGER.config(() -> "loading CAPI from " + String.valueOf(capiFile) + " as " + (useNative ? "native" : "bitcode"));
                CallTarget capiLibraryCallTarget = context.getEnv().parseInternal(capiSrcBuilder.build(), new String[0]);
                Object capiLibrary = capiLibraryCallTarget.call(new Object[0]);
                Object initFunction = U.readMember(capiLibrary, "initialize_graal_capi");
                CApiContext cApiContext = new CApiContext(context, capiLibrary, useNative);
                context.setCApiContext(cApiContext);
                if (!U.isExecutable(initFunction)) {
                    Object signature = env.parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"(ENV,(SINT32):POINTER):VOID", (String)"exec").build(), new String[0]).call(new Object[0]);
                    initFunction = SignatureLibrary.getUncached().bind(signature, initFunction);
                    U.execute(initFunction, new Object[]{new GetBuiltin()});
                } else {
                    U.execute(initFunction, new Object[]{NativePointer.createNull(), new GetBuiltin()});
                }
                assert (CApiCodeGen.assertBuiltins(capiLibrary));
                cApiContext.pyDateTimeCAPICapsule = PyDateTimeCAPIWrapper.initWrapper(context, cApiContext);
                context.runCApiHooks();
                if (useNative) {
                    Object finalizeFunction = U.readMember(capiLibrary, "GraalPy_get_finalize_capi_pointer_array");
                    Object finalizeSignature = env.parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"():POINTER", (String)"exec").build(), new String[0]).call(new Object[0]);
                    Object resetFunctionPointerArray = SignatureLibrary.getUncached().call(finalizeSignature, finalizeFunction, new Object[0]);
                    try {
                        cApiContext.addNativeFinalizer(env, resetFunctionPointerArray);
                    }
                    catch (RuntimeException e) {
                        LOGGER.warning(() -> "didn't register a native finalizer due to: " + e.getMessage());
                    }
                }
                return cApiContext;
            }
            catch (PException e) {
                throw e;
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException | RuntimeException e) {
                if (!libName.contains("managed") && !context.isNativeAccessAllowed()) {
                    throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED, new Object[0]);
                }
                throw new LoadCExtException.ApiInitException((Exception)e);
            }
        }
        return context.getCApiContext();
    }

    private void addNativeFinalizer(TruffleLanguage.Env env, Object resetFunctionPointerArray) {
        Unsafe unsafe = this.getContext().getUnsafe();
        InteropLibrary lib = InteropLibrary.getUncached((Object)resetFunctionPointerArray);
        if (!lib.isNull(resetFunctionPointerArray) && lib.isPointer(resetFunctionPointerArray)) {
            try {
                long lresetFunctionPointerArray = lib.asPointer(resetFunctionPointerArray);
                this.nativeFinalizerRunnable = () -> {
                    long resetFunctionPointerLocation;
                    long curElemAddr = lresetFunctionPointerArray;
                    while ((resetFunctionPointerLocation = unsafe.getLong(curElemAddr)) != 0L) {
                        long replacingFunctionPointer = unsafe.getLong(curElemAddr += 8L);
                        unsafe.putAddress(resetFunctionPointerLocation, replacingFunctionPointer);
                        curElemAddr += 8L;
                    }
                };
                this.nativeFinalizerShutdownHook = env.newTruffleThreadBuilder(this.nativeFinalizerRunnable).build();
                Runtime.getRuntime().addShutdownHook(this.nativeFinalizerShutdownHook);
            }
            catch (UnsupportedMessageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void finalizeCapi() {
        if (this.pyDateTimeCAPICapsule != null) {
            PyDateTimeCAPIWrapper.destroyWrapper(this.pyDateTimeCAPICapsule);
        }
        if (this.nativeFinalizerShutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.nativeFinalizerShutdownHook);
                this.nativeFinalizerRunnable.run();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object initCApiModule(Node location, Object sharedLibrary, TruffleString initFuncName, CExtContext.ModuleSpec spec, InteropLibrary llvmInteropLib, CExtCommonNodes.CheckFunctionResultNode checkFunctionResultNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, LoadCExtException.ImportException {
        Object nativeResult;
        Object pyinitFunc;
        PythonContext context = this.getContext();
        CApiContext cApiContext = context.getCApiContext();
        try {
            pyinitFunc = llvmInteropLib.readMember(sharedLibrary, initFuncName.toJavaStringUncached());
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e1) {
            throw new LoadCExtException.ImportException(null, spec.name, spec.path, ErrorMessages.NO_FUNCTION_FOUND, "", initFuncName, spec.path);
        }
        try {
            nativeResult = InteropLibrary.getUncached().execute(pyinitFunc, new Object[0]);
        }
        catch (UnsupportedMessageException e) {
            Object signature = context.getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"():POINTER", (String)"exec").build(), new String[0]).call(new Object[0]);
            Object bound = SignatureLibrary.getUncached().bind(signature, pyinitFunc);
            nativeResult = InteropLibrary.getUncached().execute(bound, new Object[0]);
        }
        catch (ArityException e) {
            Object[] arguments = new Object[e.getExpectedMinArity()];
            Arrays.fill(arguments, PNone.NO_VALUE);
            nativeResult = InteropLibrary.getUncached().execute(pyinitFunc, arguments);
        }
        checkFunctionResultNode.execute(context, initFuncName, nativeResult);
        Object result = CApiTransitions.NativeToPythonNode.executeUncached(nativeResult);
        if (!(result instanceof PythonModule)) {
            Object clazz = GetClassNodeGen.getUncached().execute(null, result);
            if (clazz == PNone.NO_VALUE) {
                throw PRaiseNode.raiseUncached(location, PythonBuiltinClassType.SystemError, ErrorMessages.INIT_FUNC_RETURNED_UNINT_OBJ, initFuncName);
            }
            return CExtNodesFactory.CreateModuleNodeGen.getUncached().execute(cApiContext, spec, result, sharedLibrary);
        }
        PythonModule module = (PythonModule)result;
        module.setAttribute(SpecialAttributeNames.T___FILE__, spec.path);
        module.setAttribute(SpecialAttributeNames.T___LIBRARY__, sharedLibrary);
        this.addLoadedExtensionLibrary(sharedLibrary);
        PDict sysModules = context.getSysModules();
        sysModules.setItem(spec.name, result);
        Object moduleDef = module.getNativeModuleDef();
        int mIndex = PythonUtils.toIntError(CStructAccess.ReadI64Node.getUncached().read(moduleDef, CFields.PyModuleDef_Base__m_index));
        while (this.modulesByIndex.size() <= mIndex) {
            this.modulesByIndex.add(null);
        }
        this.modulesByIndex.set(mIndex, module);
        this.extensions.put((Pair<TruffleString, TruffleString>)Pair.create((Object)spec.path, (Object)spec.name), module.getNativeModuleDef());
        return result;
    }

    public long getClosurePointer(Object executable) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosureByExecutable.get(executable);
        return info == null ? -1L : info.pointer;
    }

    public Object getClosureDelegate(long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosures.get(pointer);
        return info == null ? null : info.delegate;
    }

    public void setClosurePointer(Object closure, Object delegate, Object executable, long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = new ClosureInfo(closure, delegate, executable, pointer);
        this.callableClosureByExecutable.put(executable, info);
        this.callableClosures.put(pointer, info);
        LOGGER.finer(() -> PythonUtils.formatJString("new NFI closure: (%s, %s) -> %d 0x%x", executable.getClass().getSimpleName(), delegate, pointer, pointer));
    }

    public long registerClosure(String nfiSignature, Object executable, Object delegate) {
        CompilerAsserts.neverPartOfCompilation();
        PythonContext context = this.getContext();
        boolean panama = (Boolean)PythonOptions.UsePanama.getValue(context.getEnv().getOptions());
        Object signature = context.getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)((panama ? "with panama " : "") + nfiSignature), (String)"exec").build(), new String[0]).call(new Object[0]);
        Object closure = SignatureLibrary.getUncached().createClosure(signature, executable);
        long pointer = PythonUtils.coerceToLong(closure, InteropLibrary.getUncached());
        this.setClosurePointer(closure, delegate, executable, pointer);
        return pointer;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOrCreateProcWrapper(PythonManagedClass owner, SlotMethodDef slot, Supplier<PyProcsWrapper> supplier) {
        int idx;
        PyProcsWrapper[] slotWrappers = this.procWrappers.computeIfAbsent(owner, key -> new PyProcsWrapper[SlotMethodDef.values().length]);
        PyProcsWrapper wrapper = slotWrappers[idx = slot.ordinal()];
        if (wrapper == null) {
            slotWrappers[idx] = wrapper = (PyProcsWrapper)supplier.get();
        }
        return wrapper;
    }

    public static final class TraceMallocDomain {
        private final int id;
        private final EconomicMap<Object, Long> allocatedMemory;

        public TraceMallocDomain(int id) {
            this.id = id;
            this.allocatedMemory = EconomicMap.create();
        }

        @CompilerDirectives.TruffleBoundary
        public void track(Object pointerObject, long size) {
            this.allocatedMemory.put(pointerObject, (Object)size);
        }

        @CompilerDirectives.TruffleBoundary
        public long untrack(Object pointerObject) {
            Long value = (Long)this.allocatedMemory.removeKey(pointerObject);
            if (value != null) {
                return value;
            }
            return 0L;
        }

        public int getId() {
            return this.id;
        }
    }

    public static final class AllocInfo {
        public final TruffleString typeName;
        public final PFrame.Reference allocationSite;
        public final long size;

        public AllocInfo(TruffleString typeName, PFrame.Reference allocationSite, long size) {
            this.typeName = typeName;
            this.allocationSite = allocationSite;
            this.size = size;
        }

        public AllocInfo(PFrame.Reference allocationSite, TruffleString typeName) {
            this(typeName, allocationSite, -1L);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class GetBuiltin
    implements TruffleObject {
        GetBuiltin() {
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object execute(Object[] arguments) {
            assert (arguments.length == 1);
            int id = (Integer)arguments[0];
            try {
                PythonCextBuiltins.CApiBuiltinExecutable builtin = PythonCextBuiltinRegistry.builtins[id];
                CApiContext cApiContext = PythonContext.get(null).getCApiContext();
                if (cApiContext != null) {
                    Object llvmLibrary = cApiContext.getLLVMLibrary();
                    assert (builtin.call() == PythonCextBuiltins.CApiCallPath.Direct || !GetBuiltin.isAvailable(builtin, llvmLibrary)) : "name clash in builtin vs. CAPI library: " + builtin.name();
                }
                LOGGER.finer("CApiContext.GetBuiltin " + id + " / " + builtin.name());
                return builtin;
            }
            catch (Throwable e) {
                e.printStackTrace(new PrintStream(PythonContext.get(null).getEnv().err()));
                throw new RuntimeException(e);
            }
        }

        private static boolean isAvailable(PythonCextBuiltins.CApiBuiltinExecutable builtin, Object llvmLibrary) {
            if (!InteropLibrary.getUncached().isMemberReadable(llvmLibrary, builtin.name())) {
                return false;
            }
            try {
                InteropLibrary.getUncached().readMember(llvmLibrary, builtin.name());
                return true;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            catch (UnknownIdentifierException e) {
                return false;
            }
        }
    }

    private record ClosureInfo(Object closure, Object delegate, Object executable, long pointer) {
    }
}

