/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgBehavior;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.util.Supplier;

public final class ArgDescriptor
extends Enum<ArgDescriptor> {
    public static final /* enum */ ArgDescriptor Void = new ArgDescriptor(ArgBehavior.Void, "void");
    public static final /* enum */ ArgDescriptor VoidNoReturn = new ArgDescriptor(ArgBehavior.Void, "void");
    public static final /* enum */ ArgDescriptor PyObject = new ArgDescriptor(ArgBehavior.PyObject, "PyObject*");
    public static final /* enum */ ArgDescriptor ConstPyObject = new ArgDescriptor(ArgBehavior.PyObject, "const PyObject*");
    public static final /* enum */ ArgDescriptor PyObjectBorrowed = new ArgDescriptor(ArgBehavior.PyObjectBorrowed, "PyObject*");
    public static final /* enum */ ArgDescriptor PyObjectWrapper = new ArgDescriptor(ArgBehavior.PyObjectWrapper, "PyObject*");
    public static final /* enum */ ArgDescriptor PyObjectAsTruffleString = new ArgDescriptor(ArgBehavior.PyObjectAsTruffleString, "PyObject*");
    public static final /* enum */ ArgDescriptor PyTypeObject = new ArgDescriptor(ArgBehavior.PyObject, "PyTypeObject*");
    public static final /* enum */ ArgDescriptor PyTypeObjectBorrowed = new ArgDescriptor(ArgBehavior.PyObjectBorrowed, "PyTypeObject*");
    public static final /* enum */ ArgDescriptor PyTypeObjectTransfer = new ArgDescriptor(ArgBehavior.PyObject, "PyTypeObject*", true);
    public static final /* enum */ ArgDescriptor PyListObject = new ArgDescriptor(ArgBehavior.PyObject, "PyListObject*");
    public static final /* enum */ ArgDescriptor PyTupleObject = new ArgDescriptor(ArgBehavior.PyObject, "PyTupleObject*");
    public static final /* enum */ ArgDescriptor PyMethodObject = new ArgDescriptor(ArgBehavior.PyObject, "PyMethodObject*");
    public static final /* enum */ ArgDescriptor PyInstanceMethodObject = new ArgDescriptor(ArgBehavior.PyObject, "PyInstanceMethodObject*");
    public static final /* enum */ ArgDescriptor PyObjectTransfer = new ArgDescriptor(ArgBehavior.PyObject, "PyObject*", true);
    public static final /* enum */ ArgDescriptor Pointer = new ArgDescriptor(ArgBehavior.Pointer, "void*");
    public static final /* enum */ ArgDescriptor Py_ssize_t = new ArgDescriptor(ArgBehavior.Int64, "Py_ssize_t");
    public static final /* enum */ ArgDescriptor Py_hash_t = new ArgDescriptor(ArgBehavior.Int64, "Py_hash_t");
    public static final /* enum */ ArgDescriptor Int = new ArgDescriptor(ArgBehavior.Int32, "int");
    public static final /* enum */ ArgDescriptor ConstInt = new ArgDescriptor(ArgBehavior.Int32, "const int");
    public static final /* enum */ ArgDescriptor Double = new ArgDescriptor(ArgBehavior.Float64, "double");
    public static final /* enum */ ArgDescriptor Float = new ArgDescriptor(ArgBehavior.Float32, "float");
    public static final /* enum */ ArgDescriptor Long = new ArgDescriptor(ArgBehavior.Long, "long");
    public static final /* enum */ ArgDescriptor _FRAME = new ArgDescriptor(ArgBehavior.PyObject, "struct _frame*");
    public static final /* enum */ ArgDescriptor _MOD_PTR = new ArgDescriptor("struct _mod*");
    public static final /* enum */ ArgDescriptor _NODE_PTR = new ArgDescriptor("struct _node*");
    public static final /* enum */ ArgDescriptor _PY_CLOCK_INFO_T_PTR = new ArgDescriptor("_Py_clock_info_t*");
    public static final /* enum */ ArgDescriptor _PY_ERROR_HANDLER = new ArgDescriptor(ArgBehavior.Int32, "_Py_error_handler");
    public static final /* enum */ ArgDescriptor _PY_IDENTIFIER_PTR = new ArgDescriptor("struct _Py_Identifier*");
    public static final /* enum */ ArgDescriptor _PYARG_PARSER_PTR = new ArgDescriptor("struct _PyArg_Parser*");
    public static final /* enum */ ArgDescriptor _PYBYTESWRITER_PTR = new ArgDescriptor("_PyBytesWriter*");
    public static final /* enum */ ArgDescriptor _PYCROSSINTERPRETERDATA_PTR = new ArgDescriptor("_PyCrossInterpreterData*");
    public static final /* enum */ ArgDescriptor _PYERR_STACKITEM_PTR = new ArgDescriptor("_PyErr_StackItem*");
    public static final /* enum */ ArgDescriptor _PYTIME_ROUND_T = new ArgDescriptor("_PyTime_round_t");
    public static final /* enum */ ArgDescriptor _PYTIME_T = new ArgDescriptor("_PyTime_t");
    public static final /* enum */ ArgDescriptor _PYTIME_T_PTR = new ArgDescriptor("_PyTime_t*");
    public static final /* enum */ ArgDescriptor _PYUNICODEWRITER_PTR = new ArgDescriptor("_PyUnicodeWriter*");
    public static final /* enum */ ArgDescriptor CHAR = new ArgDescriptor(ArgBehavior.Char8, "char");
    public static final /* enum */ ArgDescriptor CHAR_CONST = new ArgDescriptor("char*const");
    public static final /* enum */ ArgDescriptor CHAR_CONST_PTR = new ArgDescriptor("char*const*");
    public static final /* enum */ ArgDescriptor CHAR_CONST_ARRAY = new ArgDescriptor("char*const []");
    public static final /* enum */ ArgDescriptor CHAR_PTR = new ArgDescriptor(ArgBehavior.Pointer, "char*");
    public static final /* enum */ ArgDescriptor CHAR_PTR_LIST = new ArgDescriptor(ArgBehavior.Pointer, "char**");
    public static final /* enum */ ArgDescriptor ConstCharPtrAsTruffleString = new ArgDescriptor(ArgBehavior.TruffleStringPointer, "const char*");
    public static final /* enum */ ArgDescriptor ConstCharPtr = new ArgDescriptor(ArgBehavior.Pointer, "const char*");
    public static final /* enum */ ArgDescriptor CharPtrAsTruffleString = new ArgDescriptor(ArgBehavior.TruffleStringPointer, "char*");
    public static final /* enum */ ArgDescriptor CONST_CHAR_PTR_LIST = new ArgDescriptor("const char**");
    public static final /* enum */ ArgDescriptor CONST_PY_BUFFER = new ArgDescriptor("const Py_buffer*");
    public static final /* enum */ ArgDescriptor CONST_PY_SSIZE_T = new ArgDescriptor("const Py_ssize_t");
    public static final /* enum */ ArgDescriptor CONST_PY_SSIZE_T_PTR = new ArgDescriptor("const Py_ssize_t*");
    public static final /* enum */ ArgDescriptor CONST_PY_UCS4 = new ArgDescriptor("const Py_UCS4");
    public static final /* enum */ ArgDescriptor CONST_PY_UNICODE = new ArgDescriptor("const Py_UNICODE*");
    public static final /* enum */ ArgDescriptor CONST_PYCONFIG_PTR = new ArgDescriptor("const PyConfig*");
    public static final /* enum */ ArgDescriptor CONST_PYPRECONFIG_PTR = new ArgDescriptor("const PyPreConfig*");
    public static final /* enum */ ArgDescriptor CONST_UNSIGNED_CHAR_PTR = new ArgDescriptor("const unsigned char*");
    public static final /* enum */ ArgDescriptor CONST_VOID_PTR = new ArgDescriptor(ArgBehavior.Pointer, "const void*");
    public static final /* enum */ ArgDescriptor CONST_VOID_PTR_LIST = new ArgDescriptor("const void**");
    public static final /* enum */ ArgDescriptor CONST_WCHAR_PTR = new ArgDescriptor(ArgBehavior.Pointer, "const wchar_t*");
    public static final /* enum */ ArgDescriptor CROSSINTERPDATAFUNC = new ArgDescriptor("crossinterpdatafunc");
    public static final /* enum */ ArgDescriptor FILE_PTR = new ArgDescriptor("FILE*");
    public static final /* enum */ ArgDescriptor FREEFUNC = new ArgDescriptor("freefunc");
    public static final /* enum */ ArgDescriptor INITTAB = new ArgDescriptor("struct _inittab*");
    public static final /* enum */ ArgDescriptor INT_LIST = new ArgDescriptor("int*");
    public static final /* enum */ ArgDescriptor INT8_T_PTR = new ArgDescriptor(ArgBehavior.Pointer, "int8_t*");
    public static final /* enum */ ArgDescriptor INT64_T = new ArgDescriptor(ArgBehavior.Int64, "int64_t");
    public static final /* enum */ ArgDescriptor LONG_LONG = new ArgDescriptor(ArgBehavior.Int64, "long long");
    public static final /* enum */ ArgDescriptor LONG_PTR = new ArgDescriptor("long*");
    public static final /* enum */ ArgDescriptor PyASCIIObject = new ArgDescriptor(ArgBehavior.PyObject, "PyASCIIObject*");
    public static final /* enum */ ArgDescriptor PY_AUDITHOOKFUNCTION = new ArgDescriptor("Py_AuditHookFunction");
    public static final /* enum */ ArgDescriptor Py_buffer = new ArgDescriptor("Py_buffer");
    public static final /* enum */ ArgDescriptor PY_BUFFER_PTR = new ArgDescriptor(ArgBehavior.Pointer, "Py_buffer*");
    public static final /* enum */ ArgDescriptor PY_C_FUNCTION = new ArgDescriptor(ArgBehavior.Pointer, "PyCFunction");
    public static final /* enum */ ArgDescriptor PyByteArrayObject = new ArgDescriptor(ArgBehavior.PyObject, "PyByteArrayObject*");
    public static final /* enum */ ArgDescriptor PyCFunctionObject = new ArgDescriptor(ArgBehavior.PyObject, "PyCFunctionObject*");
    public static final /* enum */ ArgDescriptor PyCMethodObject = new ArgDescriptor(ArgBehavior.PyObject, "PyCMethodObject*");
    public static final /* enum */ ArgDescriptor PY_CAPSULE_DESTRUCTOR = new ArgDescriptor(ArgBehavior.Pointer, "PyCapsule_Destructor");
    public static final /* enum */ ArgDescriptor PyCodeObject = new ArgDescriptor(ArgBehavior.PyObject, "PyCodeObject*");
    public static final /* enum */ ArgDescriptor PyCodeObjectTransfer = new ArgDescriptor(ArgBehavior.PyObject, "PyCodeObject*", true);
    public static final /* enum */ ArgDescriptor PY_COMPILER_FLAGS = new ArgDescriptor(ArgBehavior.Pointer, "PyCompilerFlags*");
    public static final /* enum */ ArgDescriptor PY_COMPLEX = new ArgDescriptor("Py_complex");
    public static final /* enum */ ArgDescriptor PyCodeAddressRange = new ArgDescriptor("PyCodeAddressRange*");
    public static final /* enum */ ArgDescriptor PyCompactUnicodeObject = new ArgDescriptor(ArgBehavior.PyObject, "PyCompactUnicodeObject*");
    public static final /* enum */ ArgDescriptor PyFrameConstructor = new ArgDescriptor("PyFrameConstructor*");
    public static final /* enum */ ArgDescriptor PyFrameObject = new ArgDescriptor(ArgBehavior.PyObject, "PyFrameObject*");
    public static final /* enum */ ArgDescriptor PyFrameObjectTransfer = new ArgDescriptor(ArgBehavior.PyObject, "PyFrameObject*", true);
    public static final /* enum */ ArgDescriptor _PyFrameEvalFunction = new ArgDescriptor("_PyFrameEvalFunction");
    public static final /* enum */ ArgDescriptor PY_GEN_OBJECT = new ArgDescriptor(ArgBehavior.PyObject, "PyGenObject*");
    public static final /* enum */ ArgDescriptor PyGetSetDef = new ArgDescriptor(ArgBehavior.Pointer, "PyGetSetDef*");
    public static final /* enum */ ArgDescriptor PY_GIL_STATE_STATE = new ArgDescriptor(ArgBehavior.Int32, "PyGILState_STATE");
    public static final /* enum */ ArgDescriptor PY_HASH_T_PTR = new ArgDescriptor("Py_hash_t*");
    public static final /* enum */ ArgDescriptor PY_IDENTIFIER = new ArgDescriptor("_Py_Identifier*");
    public static final /* enum */ ArgDescriptor PyInterpreterState = new ArgDescriptor(ArgBehavior.Pointer, "PyInterpreterState*");
    public static final /* enum */ ArgDescriptor PY_LOCK_STATUS = new ArgDescriptor("PyLockStatus");
    public static final /* enum */ ArgDescriptor PyLongObject = new ArgDescriptor(ArgBehavior.PyObject, "PyLongObject*");
    public static final /* enum */ ArgDescriptor PyLongObjectTransfer = new ArgDescriptor(ArgBehavior.PyObject, "PyLongObject*", true);
    public static final /* enum */ ArgDescriptor PyMemberDef = new ArgDescriptor(ArgBehavior.Pointer, "struct PyMemberDef*");
    public static final /* enum */ ArgDescriptor PyModuleObject = new ArgDescriptor(ArgBehavior.PyObject, "PyModuleObject*");
    public static final /* enum */ ArgDescriptor PyModuleObjectTransfer = new ArgDescriptor(ArgBehavior.PyObject, "PyModuleObject*", true);
    public static final /* enum */ ArgDescriptor PyMethodDef = new ArgDescriptor(ArgBehavior.WrappedPointer, "PyMethodDef*");
    public static final /* enum */ ArgDescriptor PyModuleDef = new ArgDescriptor(ArgBehavior.Pointer, "PyModuleDef*");
    public static final /* enum */ ArgDescriptor PyModuleDefSlot = new ArgDescriptor(ArgBehavior.Pointer, "PyModuleDef_Slot*");
    public static final /* enum */ ArgDescriptor PyNumberMethods = new ArgDescriptor(ArgBehavior.Pointer, "PyNumberMethods*");
    public static final /* enum */ ArgDescriptor PySequenceMethods = new ArgDescriptor(ArgBehavior.Pointer, "PySequenceMethods*");
    public static final /* enum */ ArgDescriptor PyMappingMethods = new ArgDescriptor(ArgBehavior.Pointer, "PyMappingMethods*");
    public static final /* enum */ ArgDescriptor PyAsyncMethods = new ArgDescriptor(ArgBehavior.Pointer, "PyAsyncMethods*");
    public static final /* enum */ ArgDescriptor PyBufferProcs = new ArgDescriptor(ArgBehavior.Pointer, "PyBufferProcs*");
    public static final /* enum */ ArgDescriptor PyMethodDescrObject = new ArgDescriptor(ArgBehavior.PyObject, "PyMethodDescrObject*");
    public static final /* enum */ ArgDescriptor PySendResult = new ArgDescriptor(ArgBehavior.Int32, "PySendResult");
    public static final /* enum */ ArgDescriptor PySetObject = new ArgDescriptor(ArgBehavior.PyObject, "PySetObject*");
    public static final /* enum */ ArgDescriptor PyDescrObject = new ArgDescriptor(ArgBehavior.PyObject, "PyDescrObject*");
    public static final /* enum */ ArgDescriptor PY_OPENCODEHOOKFUNCTION = new ArgDescriptor("Py_OpenCodeHookFunction");
    public static final /* enum */ ArgDescriptor PY_OS_SIGHANDLER = new ArgDescriptor("PyOS_sighandler_t");
    public static final /* enum */ ArgDescriptor PySliceObject = new ArgDescriptor(ArgBehavior.PyObject, "PySliceObject*");
    public static final /* enum */ ArgDescriptor PY_SSIZE_T_PTR = new ArgDescriptor(ArgBehavior.Pointer, "Py_ssize_t*");
    public static final /* enum */ ArgDescriptor PY_STRUCT_SEQUENCE_DESC = new ArgDescriptor("PyStructSequence_Desc*");
    public static final /* enum */ ArgDescriptor PyThreadState = new ArgDescriptor(ArgBehavior.Pointer, "PyThreadState*");
    public static final /* enum */ ArgDescriptor PY_THREAD_TYPE_LOCK = new ArgDescriptor(ArgBehavior.Int64, "PyThread_type_lock");
    public static final /* enum */ ArgDescriptor PY_THREAD_TYPE_LOCK_PTR = new ArgDescriptor(ArgBehavior.Pointer, "PyThread_type_lock*");
    public static final /* enum */ ArgDescriptor PyTryBlock = new ArgDescriptor("PyTryBlock*");
    public static final /* enum */ ArgDescriptor PY_TRACEFUNC = new ArgDescriptor("Py_tracefunc");
    public static final /* enum */ ArgDescriptor PY_TSS_T_PTR = new ArgDescriptor("Py_tss_t*");
    public static final /* enum */ ArgDescriptor TS_PTR = new ArgDescriptor("struct _ts*");
    public static final /* enum */ ArgDescriptor PY_TYPE_SPEC = new ArgDescriptor("PyType_Spec*");
    public static final /* enum */ ArgDescriptor PY_UCS4 = new ArgDescriptor(ArgBehavior.Int32, "Py_UCS4");
    public static final /* enum */ ArgDescriptor PY_UCS4_PTR = new ArgDescriptor("Py_UCS4*");
    public static final /* enum */ ArgDescriptor PY_UNICODE = new ArgDescriptor("Py_UNICODE");
    public static final /* enum */ ArgDescriptor PyUnicodeObject = new ArgDescriptor(ArgBehavior.PyObject, "PyUnicodeObject*");
    public static final /* enum */ ArgDescriptor PY_UNICODE_PTR = new ArgDescriptor(ArgBehavior.WrappedPointer, "Py_UNICODE*");
    public static final /* enum */ ArgDescriptor PyVarObject = new ArgDescriptor(ArgBehavior.PyObject, "PyVarObject*");
    public static final /* enum */ ArgDescriptor ConstPyVarObject = new ArgDescriptor(ArgBehavior.PyObject, "const PyVarObject*");
    public static final /* enum */ ArgDescriptor PYADDRPAIR_PTR = new ArgDescriptor("PyAddrPair*");
    public static final /* enum */ ArgDescriptor PYCONFIG_PTR = new ArgDescriptor("PyConfig*");
    public static final /* enum */ ArgDescriptor PYDICTKEYSOBJECT_PTR = new ArgDescriptor("PyDictKeysObject*");
    public static final /* enum */ ArgDescriptor PYDICTOBJECT_PTR = new ArgDescriptor("PyDictObject*");
    public static final /* enum */ ArgDescriptor PYHASH_FUNCDEF_PTR = new ArgDescriptor("PyHash_FuncDef*");
    public static final /* enum */ ArgDescriptor PYMEMALLOCATORDOMAIN = new ArgDescriptor("PyMemAllocatorDomain");
    public static final /* enum */ ArgDescriptor PYMEMALLOCATOREX_PTR = new ArgDescriptor("PyMemAllocatorEx*");
    public static final /* enum */ ArgDescriptor PYMODULEDEF_PTR = new ArgDescriptor("struct PyModuleDef*");
    public static final /* enum */ ArgDescriptor PyObjectConst = new ArgDescriptor("PyObject*const");
    public static final /* enum */ ArgDescriptor PyObjectConstPtr = new ArgDescriptor(ArgBehavior.Pointer, "PyObject*const*");
    public static final /* enum */ ArgDescriptor PYOBJECT_CONST_PTR_LIST = new ArgDescriptor("PyObject*const**");
    public static final /* enum */ ArgDescriptor PyObjectPtr = new ArgDescriptor(ArgBehavior.Pointer, "PyObject**");
    public static final /* enum */ ArgDescriptor PYOBJECTARENAALLOCATOR_PTR = new ArgDescriptor("PyObjectArenaAllocator*");
    public static final /* enum */ ArgDescriptor PYPRECONFIG_PTR = new ArgDescriptor("PyPreConfig*");
    public static final /* enum */ ArgDescriptor PYSTATUS = new ArgDescriptor("PyStatus");
    public static final /* enum */ ArgDescriptor PYUNICODE_KIND = new ArgDescriptor("enum PyUnicode_Kind");
    public static final /* enum */ ArgDescriptor PYWEAKREFERENCE_PTR = new ArgDescriptor("PyWeakReference*");
    public static final /* enum */ ArgDescriptor PYWIDESTRINGLIST_PTR = new ArgDescriptor("PyWideStringList*");
    public static final /* enum */ ArgDescriptor SIZE_T = new ArgDescriptor(ArgBehavior.Int64, "size_t");
    public static final /* enum */ ArgDescriptor SIZE_T_PTR = new ArgDescriptor("size_t*");
    public static final /* enum */ ArgDescriptor STAT_PTR = new ArgDescriptor("struct stat*");
    public static final /* enum */ ArgDescriptor PY_STAT_PTR = new ArgDescriptor("struct _Py_stat_struct*");
    public static final /* enum */ ArgDescriptor TIME_T = new ArgDescriptor("time_t");
    public static final /* enum */ ArgDescriptor TIME_T_PTR = new ArgDescriptor("time_t*");
    public static final /* enum */ ArgDescriptor TIMESPEC_PTR = new ArgDescriptor("struct timespec*");
    public static final /* enum */ ArgDescriptor TIMEVAL_PTR = new ArgDescriptor("struct timeval*");
    public static final /* enum */ ArgDescriptor TM_PTR = new ArgDescriptor("struct tm*");
    public static final /* enum */ ArgDescriptor UINTPTR_T = new ArgDescriptor(ArgBehavior.Pointer, "uintptr_t");
    public static final /* enum */ ArgDescriptor UINT64_T = new ArgDescriptor(ArgBehavior.Int64, "uint64_t");
    public static final /* enum */ ArgDescriptor UNSIGNED_CHAR_PTR = new ArgDescriptor(ArgBehavior.Pointer, "unsigned char*");
    public static final /* enum */ ArgDescriptor UNSIGNED_INT = new ArgDescriptor(ArgBehavior.UInt32, "unsigned int");
    public static final /* enum */ ArgDescriptor UNSIGNED_LONG = new ArgDescriptor(ArgBehavior.Long, "unsigned long");
    public static final /* enum */ ArgDescriptor UNSIGNED_LONG_LONG = new ArgDescriptor(ArgBehavior.Int64, "unsigned long long");
    public static final /* enum */ ArgDescriptor VA_LIST = new ArgDescriptor(ArgBehavior.Pointer, "va_list");
    public static final /* enum */ ArgDescriptor VA_LIST_PTR = new ArgDescriptor(ArgBehavior.Pointer, "va_list*");
    public static final /* enum */ ArgDescriptor VARARGS = new ArgDescriptor("...");
    public static final /* enum */ ArgDescriptor VOID_PTR_LIST = new ArgDescriptor("void**");
    public static final /* enum */ ArgDescriptor WCHAR_T_PTR = new ArgDescriptor(ArgBehavior.Pointer, "wchar_t*");
    public static final /* enum */ ArgDescriptor WCHAR_T_CONST_PTR = new ArgDescriptor(ArgBehavior.Pointer, "wchar_t*const*");
    public static final /* enum */ ArgDescriptor WCHAR_T_PTR_LIST = new ArgDescriptor(ArgBehavior.Pointer, "wchar_t**");
    public static final /* enum */ ArgDescriptor WCHAR_T_PTR_PTR_LIST = new ArgDescriptor(ArgBehavior.Pointer, "wchar_t***");
    public static final /* enum */ ArgDescriptor WRAPPERBASE = new ArgDescriptor(ArgBehavior.Pointer, "struct wrapperbase*");
    public static final /* enum */ ArgDescriptor destructor = new ArgDescriptor(ArgBehavior.Pointer, "destructor");
    public static final /* enum */ ArgDescriptor getattrfunc = new ArgDescriptor(ArgBehavior.Pointer, "getattrfunc");
    public static final /* enum */ ArgDescriptor setattrfunc = new ArgDescriptor(ArgBehavior.Pointer, "setattrfunc");
    public static final /* enum */ ArgDescriptor reprfunc = new ArgDescriptor(ArgBehavior.Pointer, "reprfunc");
    public static final /* enum */ ArgDescriptor hashfunc = new ArgDescriptor(ArgBehavior.Pointer, "hashfunc");
    public static final /* enum */ ArgDescriptor ternaryfunc = new ArgDescriptor(ArgBehavior.Pointer, "ternaryfunc");
    public static final /* enum */ ArgDescriptor getattrofunc = new ArgDescriptor(ArgBehavior.Pointer, "getattrofunc");
    public static final /* enum */ ArgDescriptor setattrofunc = new ArgDescriptor(ArgBehavior.Pointer, "setattrofunc");
    public static final /* enum */ ArgDescriptor traverseproc = new ArgDescriptor(ArgBehavior.Pointer, "traverseproc");
    public static final /* enum */ ArgDescriptor inquiry = new ArgDescriptor(ArgBehavior.Pointer, "inquiry");
    public static final /* enum */ ArgDescriptor richcmpfunc = new ArgDescriptor(ArgBehavior.Pointer, "richcmpfunc");
    public static final /* enum */ ArgDescriptor getiterfunc = new ArgDescriptor(ArgBehavior.Pointer, "getiterfunc");
    public static final /* enum */ ArgDescriptor iternextfunc = new ArgDescriptor(ArgBehavior.Pointer, "iternextfunc");
    public static final /* enum */ ArgDescriptor descrgetfunc = new ArgDescriptor(ArgBehavior.Pointer, "descrgetfunc");
    public static final /* enum */ ArgDescriptor descrsetfunc = new ArgDescriptor(ArgBehavior.Pointer, "descrsetfunc");
    public static final /* enum */ ArgDescriptor initproc = new ArgDescriptor(ArgBehavior.Pointer, "initproc");
    public static final /* enum */ ArgDescriptor allocfunc = new ArgDescriptor(ArgBehavior.Pointer, "allocfunc");
    public static final /* enum */ ArgDescriptor newfunc = new ArgDescriptor(ArgBehavior.Pointer, "newfunc");
    public static final /* enum */ ArgDescriptor freefunc = new ArgDescriptor(ArgBehavior.Pointer, "freefunc");
    public static final /* enum */ ArgDescriptor vectorcallfunc = new ArgDescriptor(ArgBehavior.Pointer, "vectorcallfunc");
    public static final /* enum */ ArgDescriptor binaryfunc = new ArgDescriptor(ArgBehavior.Pointer, "binaryfunc");
    public static final /* enum */ ArgDescriptor unaryfunc = new ArgDescriptor(ArgBehavior.Pointer, "unaryfunc");
    public static final /* enum */ ArgDescriptor lenfunc = new ArgDescriptor(ArgBehavior.Pointer, "lenfunc");
    public static final /* enum */ ArgDescriptor ssizeargfunc = new ArgDescriptor(ArgBehavior.Pointer, "ssizeargfunc");
    public static final /* enum */ ArgDescriptor ssizeobjargproc = new ArgDescriptor(ArgBehavior.Pointer, "ssizeobjargproc");
    public static final /* enum */ ArgDescriptor objobjproc = new ArgDescriptor(ArgBehavior.Pointer, "objobjproc");
    public static final /* enum */ ArgDescriptor objobjargproc = new ArgDescriptor(ArgBehavior.Pointer, "objobjargproc");
    public static final /* enum */ ArgDescriptor getbufferproc = new ArgDescriptor(ArgBehavior.Pointer, "getbufferproc");
    public static final /* enum */ ArgDescriptor releasebufferproc = new ArgDescriptor(ArgBehavior.Pointer, "releasebufferproc");
    public static final /* enum */ ArgDescriptor getter = new ArgDescriptor(ArgBehavior.Pointer, "getter");
    public static final /* enum */ ArgDescriptor setter = new ArgDescriptor(ArgBehavior.Pointer, "setter");
    public static final /* enum */ ArgDescriptor sendfunc = new ArgDescriptor(ArgBehavior.Pointer, "sendfunc");
    public static final /* enum */ ArgDescriptor func_objint = new ArgDescriptor("int (*)(PyObject*value)");
    public static final /* enum */ ArgDescriptor func_voidvoidptr = new ArgDescriptor("void (*)(void*)");
    public static final /* enum */ ArgDescriptor func_voidvoid = new ArgDescriptor(ArgBehavior.Pointer, "void (*)(void)");
    public static final /* enum */ ArgDescriptor func_intvoidptr = new ArgDescriptor("int (*)(void*)");
    public static final /* enum */ ArgDescriptor func_objvoid = new ArgDescriptor("PyObject*(*)(void)");
    public static final /* enum */ ArgDescriptor func_objcharsizevoidptr = new ArgDescriptor("PyObject*(*)(const char*, Py_ssize_t, void*)");
    public static final /* enum */ ArgDescriptor IterResult = new ArgDescriptor(ArgBehavior.PyObject, "void*", ExternalFunctionNodesFactory.CheckIterNextResultNodeGen::create, true);
    public static final /* enum */ ArgDescriptor InquiryResult = new ArgDescriptor(ArgBehavior.Int32, "int", ExternalFunctionNodesFactory.CheckInquiryResultNodeGen::create);
    public static final /* enum */ ArgDescriptor InitResult = new ArgDescriptor(ArgBehavior.Int32, "int", ExternalFunctionNodesFactory.InitCheckFunctionResultNodeGen::create);
    public static final /* enum */ ArgDescriptor PrimitiveResult32 = new ArgDescriptor(ArgBehavior.Int32, "int", ExternalFunctionNodesFactory.CheckPrimitiveFunctionResultNodeGen::create);
    public static final /* enum */ ArgDescriptor PrimitiveResult64 = new ArgDescriptor(ArgBehavior.Int64, "long", ExternalFunctionNodesFactory.CheckPrimitiveFunctionResultNodeGen::create);
    public final String cSignature;
    public final ArgBehavior behavior;
    private final boolean transfer;
    private final Supplier<CExtCommonNodes.CheckFunctionResultNode> checkResult;
    private static final /* synthetic */ ArgDescriptor[] $VALUES;

    public static ArgDescriptor[] values() {
        return (ArgDescriptor[])$VALUES.clone();
    }

    public static ArgDescriptor valueOf(String name) {
        return Enum.valueOf(ArgDescriptor.class, name);
    }

    private ArgDescriptor(String cSignature) {
        this.behavior = ArgBehavior.Unknown;
        this.cSignature = cSignature;
        this.transfer = false;
        this.checkResult = null;
    }

    private ArgDescriptor(ArgBehavior behavior, String cSignature) {
        this.behavior = behavior;
        this.cSignature = cSignature;
        this.transfer = false;
        this.checkResult = null;
    }

    private ArgDescriptor(ArgBehavior behavior, String cSignature, boolean transfer) {
        this.behavior = behavior;
        this.cSignature = cSignature;
        this.transfer = transfer;
        this.checkResult = null;
    }

    private ArgDescriptor(ArgBehavior behavior, String cSignature, Supplier<CExtCommonNodes.CheckFunctionResultNode> checkResult) {
        this.behavior = behavior;
        this.cSignature = cSignature;
        this.checkResult = checkResult;
        this.transfer = false;
    }

    private ArgDescriptor(ArgBehavior behavior, String cSignature, Supplier<CExtCommonNodes.CheckFunctionResultNode> checkResult, boolean transfer) {
        this.behavior = behavior;
        this.cSignature = cSignature;
        this.checkResult = checkResult;
        this.transfer = transfer;
    }

    public static CExtToJavaNode[] createNativeToPython(ArgDescriptor[] args) {
        CExtToJavaNode[] result = new CExtToJavaNode[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = args[i].createNativeToPythonNode();
        }
        return result;
    }

    public String getCSignature() {
        return this.cSignature;
    }

    public CExtToNativeNode createPythonToNativeNode() {
        Supplier<CExtToNativeNode> factory;
        assert (this.behavior != ArgBehavior.Unknown) : "undefined behavior in " + String.valueOf((Object)this);
        Supplier<CExtToNativeNode> supplier = factory = this.transfer ? this.behavior.pythonToNativeTransfer : this.behavior.pythonToNative;
        assert (!this.transfer || factory != null);
        return factory == null ? null : (CExtToNativeNode)((Object)factory.get());
    }

    public CExtToJavaNode createNativeToPythonNode() {
        Supplier<CExtToJavaNode> factory;
        assert (this.behavior != ArgBehavior.Unknown) : "undefined behavior in " + String.valueOf((Object)this);
        Supplier<CExtToJavaNode> supplier = factory = this.transfer ? this.behavior.nativeToPythonTransfer : this.behavior.nativeToPython;
        assert (!this.transfer || factory != null);
        return factory == null ? null : (CExtToJavaNode)((Object)factory.get());
    }

    public CExtCommonNodes.CheckFunctionResultNode createCheckResultNode() {
        assert (this.behavior != ArgBehavior.Unknown) : "undefined behavior in " + String.valueOf((Object)this);
        return this.checkResult == null ? null : (CExtCommonNodes.CheckFunctionResultNode)((Object)this.checkResult.get());
    }

    public String getNFISignature() {
        return this.behavior.nfiSignature;
    }

    public String getJniSignature() {
        return this.behavior.jniSignature;
    }

    public String getJniType() {
        return this.behavior.jniType;
    }

    public String getJavaSignature() {
        return this.behavior.javaSignature;
    }

    public boolean isPyObjectOrPointer() {
        return this.behavior == ArgBehavior.PyObject || this.behavior == ArgBehavior.PyObjectBorrowed || this.behavior == ArgBehavior.Pointer || this.behavior == ArgBehavior.WrappedPointer || this.behavior == ArgBehavior.TruffleStringPointer;
    }

    public boolean isPointer() {
        return this.behavior == ArgBehavior.Pointer || this.behavior == ArgBehavior.WrappedPointer || this.behavior == ArgBehavior.TruffleStringPointer;
    }

    public boolean isPyObject() {
        return this.behavior == ArgBehavior.PyObject || this.behavior == ArgBehavior.PyObjectBorrowed;
    }

    public boolean isValidReturnType() {
        return this.behavior != ArgBehavior.PyObject || this.transfer;
    }

    public boolean isCharPtr() {
        return this == CharPtrAsTruffleString || this == CHAR_PTR || this == ConstCharPtr || this == ConstCharPtrAsTruffleString;
    }

    public boolean isIntType() {
        return this.behavior == ArgBehavior.Int32 || this.behavior == ArgBehavior.UInt32 || this.behavior == ArgBehavior.Int64 || this.behavior == ArgBehavior.Long || this.behavior == ArgBehavior.Char16 || this.behavior == ArgBehavior.Unknown;
    }

    public boolean isFloatType() {
        return this.behavior == ArgBehavior.Float64 || this.behavior == ArgBehavior.Float32;
    }

    public boolean isVoid() {
        return this.behavior == ArgBehavior.Void;
    }

    public static ArgDescriptor resolve(String sig) {
        switch (sig) {
            case "struct _typeobject*": {
                return PyTypeObject;
            }
            case "struct PyGetSetDef*": {
                return PyGetSetDef;
            }
            case "const struct PyConfig*": {
                return CONST_PYCONFIG_PTR;
            }
            case "struct PyConfig*": {
                return PYCONFIG_PTR;
            }
        }
        for (ArgDescriptor d : ArgDescriptor.values()) {
            if (!d.cSignature.equals(sig)) continue;
            return d;
        }
        throw new IllegalArgumentException("unknown C signature: " + (String)sig);
    }

    public boolean isI64() {
        return this.behavior == ArgBehavior.Int64 || this.behavior == ArgBehavior.Long;
    }

    public boolean isI8() {
        return this.behavior == ArgBehavior.Char8;
    }

    public boolean isI32() {
        return this.behavior == ArgBehavior.Int32 || this.behavior == ArgBehavior.UInt32;
    }

    public boolean isI16() {
        return this.behavior == ArgBehavior.Char16;
    }

    public boolean isFloat() {
        return this.behavior == ArgBehavior.Float32;
    }

    public boolean isDouble() {
        return this.behavior == ArgBehavior.Float64;
    }

    private static /* synthetic */ ArgDescriptor[] $values() {
        return new ArgDescriptor[]{Void, VoidNoReturn, PyObject, ConstPyObject, PyObjectBorrowed, PyObjectWrapper, PyObjectAsTruffleString, PyTypeObject, PyTypeObjectBorrowed, PyTypeObjectTransfer, PyListObject, PyTupleObject, PyMethodObject, PyInstanceMethodObject, PyObjectTransfer, Pointer, Py_ssize_t, Py_hash_t, Int, ConstInt, Double, Float, Long, _FRAME, _MOD_PTR, _NODE_PTR, _PY_CLOCK_INFO_T_PTR, _PY_ERROR_HANDLER, _PY_IDENTIFIER_PTR, _PYARG_PARSER_PTR, _PYBYTESWRITER_PTR, _PYCROSSINTERPRETERDATA_PTR, _PYERR_STACKITEM_PTR, _PYTIME_ROUND_T, _PYTIME_T, _PYTIME_T_PTR, _PYUNICODEWRITER_PTR, CHAR, CHAR_CONST, CHAR_CONST_PTR, CHAR_CONST_ARRAY, CHAR_PTR, CHAR_PTR_LIST, ConstCharPtrAsTruffleString, ConstCharPtr, CharPtrAsTruffleString, CONST_CHAR_PTR_LIST, CONST_PY_BUFFER, CONST_PY_SSIZE_T, CONST_PY_SSIZE_T_PTR, CONST_PY_UCS4, CONST_PY_UNICODE, CONST_PYCONFIG_PTR, CONST_PYPRECONFIG_PTR, CONST_UNSIGNED_CHAR_PTR, CONST_VOID_PTR, CONST_VOID_PTR_LIST, CONST_WCHAR_PTR, CROSSINTERPDATAFUNC, FILE_PTR, FREEFUNC, INITTAB, INT_LIST, INT8_T_PTR, INT64_T, LONG_LONG, LONG_PTR, PyASCIIObject, PY_AUDITHOOKFUNCTION, Py_buffer, PY_BUFFER_PTR, PY_C_FUNCTION, PyByteArrayObject, PyCFunctionObject, PyCMethodObject, PY_CAPSULE_DESTRUCTOR, PyCodeObject, PyCodeObjectTransfer, PY_COMPILER_FLAGS, PY_COMPLEX, PyCodeAddressRange, PyCompactUnicodeObject, PyFrameConstructor, PyFrameObject, PyFrameObjectTransfer, _PyFrameEvalFunction, PY_GEN_OBJECT, PyGetSetDef, PY_GIL_STATE_STATE, PY_HASH_T_PTR, PY_IDENTIFIER, PyInterpreterState, PY_LOCK_STATUS, PyLongObject, PyLongObjectTransfer, PyMemberDef, PyModuleObject, PyModuleObjectTransfer, PyMethodDef, PyModuleDef, PyModuleDefSlot, PyNumberMethods, PySequenceMethods, PyMappingMethods, PyAsyncMethods, PyBufferProcs, PyMethodDescrObject, PySendResult, PySetObject, PyDescrObject, PY_OPENCODEHOOKFUNCTION, PY_OS_SIGHANDLER, PySliceObject, PY_SSIZE_T_PTR, PY_STRUCT_SEQUENCE_DESC, PyThreadState, PY_THREAD_TYPE_LOCK, PY_THREAD_TYPE_LOCK_PTR, PyTryBlock, PY_TRACEFUNC, PY_TSS_T_PTR, TS_PTR, PY_TYPE_SPEC, PY_UCS4, PY_UCS4_PTR, PY_UNICODE, PyUnicodeObject, PY_UNICODE_PTR, PyVarObject, ConstPyVarObject, PYADDRPAIR_PTR, PYCONFIG_PTR, PYDICTKEYSOBJECT_PTR, PYDICTOBJECT_PTR, PYHASH_FUNCDEF_PTR, PYMEMALLOCATORDOMAIN, PYMEMALLOCATOREX_PTR, PYMODULEDEF_PTR, PyObjectConst, PyObjectConstPtr, PYOBJECT_CONST_PTR_LIST, PyObjectPtr, PYOBJECTARENAALLOCATOR_PTR, PYPRECONFIG_PTR, PYSTATUS, PYUNICODE_KIND, PYWEAKREFERENCE_PTR, PYWIDESTRINGLIST_PTR, SIZE_T, SIZE_T_PTR, STAT_PTR, PY_STAT_PTR, TIME_T, TIME_T_PTR, TIMESPEC_PTR, TIMEVAL_PTR, TM_PTR, UINTPTR_T, UINT64_T, UNSIGNED_CHAR_PTR, UNSIGNED_INT, UNSIGNED_LONG, UNSIGNED_LONG_LONG, VA_LIST, VA_LIST_PTR, VARARGS, VOID_PTR_LIST, WCHAR_T_PTR, WCHAR_T_CONST_PTR, WCHAR_T_PTR_LIST, WCHAR_T_PTR_PTR_LIST, WRAPPERBASE, destructor, getattrfunc, setattrfunc, reprfunc, hashfunc, ternaryfunc, getattrofunc, setattrofunc, traverseproc, inquiry, richcmpfunc, getiterfunc, iternextfunc, descrgetfunc, descrsetfunc, initproc, allocfunc, newfunc, freefunc, vectorcallfunc, binaryfunc, unaryfunc, lenfunc, ssizeargfunc, ssizeobjargproc, objobjproc, objobjargproc, getbufferproc, releasebufferproc, getter, setter, sendfunc, func_objint, func_voidvoidptr, func_voidvoid, func_intvoidptr, func_objvoid, func_objcharsizevoidptr, IterResult, InquiryResult, InitResult, PrimitiveResult32, PrimitiveResult64};
    }

    static {
        $VALUES = ArgDescriptor.$values();
    }
}

