/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.TruffleObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetNativeWrapperNode;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetReplacementNode;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.NativeObjectReferenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import sun.misc.Unsafe;

public abstract class CApiTransitions {
    private static final int GCALot = Integer.getInteger("python.GCALot", 0);
    private static final int GCALotWait = Integer.getInteger("python.GCALotWait", 0);
    private static long GCALotTotalCounter = 0L;
    private static int GCALotCounter = 0;
    private static final TruffleLogger LOGGER = CApiContext.getLogger(CApiTransitions.class);
    private static final InteropLibrary LIB = InteropLibrary.getUncached();
    private static final Unsafe UNSAFE = PythonUtils.initUnsafe();
    private static final int TP_REFCNT_OFFSET = 0;

    private CApiTransitions() {
    }

    private static HandleContext getContext() {
        return PythonContext.get(null).nativeContext;
    }

    @CompilerDirectives.TruffleBoundary
    public static void registerNativeSequenceStorage(NativeSequenceStorage storage) {
        assert (PythonContext.get(null).ownsGil());
        HandleContext handleContext = CApiTransitions.getContext();
        NativeStorageReference ref = new NativeStorageReference(handleContext, storage);
        storage.setReference(ref);
        handleContext.nativeStorageReferences.add(ref);
    }

    @CompilerDirectives.TruffleBoundary
    public static void pollReferenceQueue() {
        HandleContext context = CApiTransitions.getContext();
        if (!context.referenceQueuePollActive) {
            try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
                ReferenceQueue<Object> queue = context.referenceQueue;
                int count = 0;
                long start = 0L;
                NativeObjectReferenceArrayWrapper referencesToBeFreed = CApiTransitions.getContext().referencesToBeFreed;
                while (true) {
                    Reference<Object> entry;
                    if ((entry = queue.poll()) == null) {
                        if (count > 0) {
                            assert (context.referenceQueuePollActive);
                            if (!referencesToBeFreed.isEmpty()) {
                                LOGGER.fine(() -> PythonUtils.formatJString("releasing %d NativeObjectReference instances", referencesToBeFreed.getArraySize()));
                                Object array = CStructAccessFactory.AllocateNodeGen.getUncached().alloc(referencesToBeFreed.getArraySize() * 8L);
                                CStructAccessFactory.WriteLongNodeGen.getUncached().writeLongArray(array, referencesToBeFreed.getArray(), (int)referencesToBeFreed.getArraySize(), 0, 0);
                                CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_BULK_DEALLOC, array, referencesToBeFreed.getArraySize());
                                CStructAccessFactory.FreeNodeGen.getUncached().free(array);
                                referencesToBeFreed.reset();
                            }
                            context.referenceQueuePollActive = false;
                            LOGGER.fine("collected " + count + " references from native reference queue in " + (System.nanoTime() - start) / 1000000L + "ms");
                        }
                        return;
                    }
                    if (count == 0) {
                        assert (!context.referenceQueuePollActive);
                        context.referenceQueuePollActive = true;
                        start = System.nanoTime();
                    } else assert (context.referenceQueuePollActive);
                    ++count;
                    if (entry instanceof PythonObjectReference) {
                        PythonObjectReference reference = (PythonObjectReference)entry;
                        LOGGER.finer(() -> PythonUtils.formatJString("releasing PythonObjectReference %s", reference));
                        if (HandlePointerConverter.pointsToPyHandleSpace(reference.pointer)) {
                            assert (CApiTransitions.nativeStubLookupGet(context, reference.pointer) != null) : Long.toHexString(reference.pointer);
                            CApiTransitions.nativeStubLookupRemove(context, reference.pointer);
                            long stubPointer = HandlePointerConverter.pointerToStub(reference.pointer);
                            if (CApiTransitions.subNativeRefCount(stubPointer, 10L) != 0L) continue;
                            LOGGER.finer(() -> String.format("freeing native object stub 0x%s", Long.toHexString(stubPointer)));
                            CStructAccess.FreeNode.executeUncached(stubPointer);
                            continue;
                        }
                        assert (CApiTransitions.nativeLookupGet(context, reference.pointer) != null) : Long.toHexString(reference.pointer);
                        CApiTransitions.nativeLookupRemove(context, reference.pointer);
                        continue;
                    }
                    if (entry instanceof NativeObjectReference) {
                        NativeObjectReference reference = (NativeObjectReference)entry;
                        LOGGER.finer(() -> PythonUtils.formatJString("releasing NativeObjectReference %s", reference));
                        CApiTransitions.nativeLookupRemove(context, reference.pointer);
                        if (CApiTransitions.subNativeRefCount(reference.pointer, 10L) != 0L) continue;
                        referencesToBeFreed.add(reference.pointer);
                        continue;
                    }
                    if (!(entry instanceof NativeStorageReference)) continue;
                    NativeStorageReference reference = (NativeStorageReference)entry;
                    LOGGER.finer(() -> PythonUtils.formatJString("releasing NativeStorageReference %s", reference));
                    context.nativeStorageReferences.remove(entry);
                    if (reference.type == SequenceStorage.ListStorageType.Generic) {
                        CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_PY_TRUFFLE_OBJECT_ARRAY_RELEASE, reference.ptr, reference.size);
                    }
                    CStructAccessFactory.FreeNodeGen.getUncached().free(reference.ptr);
                }
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void addNativeWeakRef(PythonContext pythonContext, PythonAbstractNativeObject object) {
        pythonContext.nativeContext.nativeWeakRef.put(CApiTransitions.getNativePointer(object), 0L);
    }

    @CompilerDirectives.TruffleBoundary
    public static void removeNativeWeakRef(PythonContext pythonContext, long pointer) {
        pythonContext.nativeContext.nativeWeakRef.remove(pointer);
    }

    public static long getNativePointer(Object obj) {
        if (obj instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject object = (PythonAbstractNativeObject)obj;
            return object.ref.pointer;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static void deallocateNativeWeakRefs(PythonContext pythonContext) {
        if (!pythonContext.isFinalizing()) {
            return;
        }
        HandleContext context = pythonContext.nativeContext;
        int idx = -1;
        Object[] list = context.nativeWeakRef.values().toArray();
        context.nativeWeakRef.clear();
        long[] ptrArray = new long[list.length];
        for (Object ptr : list) {
            if (!context.nativeLookup.containsKey(ptr)) continue;
            ptrArray[++idx] = (Long)ptr;
        }
        if (idx != -1) {
            int len = idx + 1;
            Object array = CStructAccessFactory.AllocateNodeGen.getUncached().alloc((long)len * 8L);
            try {
                CStructAccessFactory.WriteLongNodeGen.getUncached().writeLongArray(array, ptrArray, len, 0, 0);
                CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_SHUTDOWN_BULK_DEALLOC, array, len);
            }
            finally {
                CStructAccessFactory.FreeNodeGen.getUncached().free(array);
                context.nativeWeakRef.clear();
            }
        }
        if (context.nativeWeakRef.size() > 0) {
            LOGGER.warning("Weak references have been added during shutdown!");
        }
    }

    public static void maybeGCALot() {
        if (GCALot != 0) {
            CApiTransitions.maybeGC();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void maybeGC() {
        if (++GCALotTotalCounter >= (long)GCALotWait && ++GCALotCounter >= GCALot) {
            LOGGER.info("GC A Lot - calling System.gc (opportunities=" + GCALotTotalCounter + ")");
            GCALotCounter = 0;
            System.gc();
            CApiTransitions.pollReferenceQueue();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object lookupNative(long pointer) {
        CApiTransitions.log(pointer);
        IdReference<?> reference = CApiTransitions.nativeLookupGet(CApiTransitions.getContext(), pointer);
        if (reference != null) {
            return CApiTransitions.logResultBoundary(reference.get());
        }
        return CApiTransitions.logResult(null);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupGet(HandleContext context, long pointer) {
        return context.nativeLookup.get(pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupPut(HandleContext context, long pointer, IdReference<?> value) {
        return context.nativeLookup.put(pointer, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupRemove(HandleContext context, long pointer) {
        return context.nativeLookup.remove(pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static PythonObjectReference nativeStubLookupGet(HandleContext context, long pointer) {
        return context.nativeStubLookup.get(pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static PythonObjectReference nativeStubLookupPut(HandleContext context, long pointer, PythonObjectReference value) {
        return context.nativeStubLookup.put(pointer, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static PythonObjectReference nativeStubLookupRemove(HandleContext context, long pointer) {
        return context.nativeStubLookup.remove(pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static void createReference(PythonNativeWrapper obj, long ptr) {
        try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
            if (!obj.isNative()) {
                CApiTransitions.logVoid(obj, ptr);
                obj.setNativePointer(ptr);
                CApiTransitions.pollReferenceQueue();
                HandleContext context = CApiTransitions.getContext();
                CApiTransitions.nativeLookupPut(context, ptr, PythonObjectReference.create(context, obj, ptr));
            }
        }
    }

    public static void createManagedReference(Object delegate, Object pointer) {
        assert (PythonContext.get(null).ownsGil());
        CApiTransitions.getContext().managedNativeLookup.put(pointer, new WeakReference<Object>(delegate));
    }

    private static void log(Object ... args) {
        if (LOGGER.isLoggable(Level.FINER)) {
            CApiTransitions.logBoundary(args);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void logBoundary(Object ... args) {
        if (LOGGER.isLoggable(Level.FINER)) {
            CompilerAsserts.neverPartOfCompilation();
            StackTraceElement element = new RuntimeException().getStackTrace()[1];
            StringBuilder str = new StringBuilder();
            String className = element.getClassName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            str.append(className).append(".").append(element.getMethodName()).append(": ");
            for (int i = 0; i < args.length; ++i) {
                Object a = args[i];
                str.append(i == 0 ? "" : ", ");
                CApiTransitions.format(str, a);
            }
            LOGGER.finer(str.toString());
        }
    }

    private static void logVoid(Object ... args) {
        CApiTransitions.log(args);
    }

    private static void format(StringBuilder str, Object a) {
        if (a instanceof Long) {
            str.append(String.format("0x%x", (long)((Long)a)));
        } else if (a instanceof Integer) {
            str.append(String.format("0x%x", (int)((Integer)a)));
        } else {
            str.append(a);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T logResultBoundary(T value) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            CompilerAsserts.neverPartOfCompilation();
            StackTraceElement element = new RuntimeException().getStackTrace()[1];
            StringBuilder str = new StringBuilder("    ==> <").append(element.getLineNumber()).append("> ");
            CApiTransitions.format(str, value);
            LOGGER.finest(str.toString());
        }
        return value;
    }

    private static <T> T logResult(T value) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            CApiTransitions.logResultBoundary(value);
        }
        return value;
    }

    private static long addNativeRefCount(long pointer, long refCntDelta) {
        long refCount = UNSAFE.getLong(pointer + 0L);
        assert ((refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        assert (refCount + refCntDelta > 0L) : String.format("refcnt reached zero during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        LOGGER.finest(() -> PythonUtils.formatJString("addNativeRefCount %x %x %d + %d", pointer, refCount, refCount, refCntDelta));
        UNSAFE.putLong(pointer + 0L, refCount + refCntDelta);
        return refCount + refCntDelta;
    }

    private static long subNativeRefCount(long pointer, long refCntDelta) {
        long refCount = UNSAFE.getLong(pointer + 0L);
        assert ((refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value during managed adjustment for %016x (%d %016x - %d)\n", pointer, refCount, refCount, refCntDelta);
        assert (refCount - refCntDelta >= 0L) : String.format("refcnt below zero during managed adjustment for %016x (%d %016x - %d)\n", pointer, refCount, refCount, refCntDelta);
        LOGGER.finest(() -> PythonUtils.formatJString("subNativeRefCount %x %x %d + %d", pointer, refCount, refCount, refCntDelta));
        UNSAFE.putLong(pointer + 0L, refCount - refCntDelta);
        return refCount - refCntDelta;
    }

    public static long readNativeRefCount(long pointer) {
        long refCount = UNSAFE.getLong(pointer + 0L);
        assert (refCount == 0x3FFFFFFFFFFFFFFFL || (refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value for %016x (%d %016x)\n", pointer, refCount, refCount);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(PythonUtils.formatJString("readNativeRefCount(%x) = %d (%x)", pointer, refCount, refCount));
        }
        return refCount;
    }

    public static void writeNativeRefCount(long pointer, long newValue) {
        assert (newValue > 0L) : PythonUtils.formatJString("refcnt value to write below zero for %016x (%d %016x)\n", pointer, newValue, newValue);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(PythonUtils.formatJString("writeNativeRefCount(%x, %d (%x))", pointer, newValue, newValue));
        }
        UNSAFE.putLong(pointer + 0L, newValue);
    }

    private static Object createAbstractNativeObject(HandleContext handleContext, Object obj, boolean transfer, long pointer) {
        assert (CApiTransitions.isBackendPointerObject(obj)) : obj.getClass();
        CApiTransitions.pollReferenceQueue();
        PythonAbstractNativeObject result = new PythonAbstractNativeObject(obj);
        NativeObjectReference ref = new NativeObjectReference(handleContext, result, pointer);
        CApiTransitions.nativeLookupPut(CApiTransitions.getContext(), pointer, ref);
        long refCntDelta = 10L - (long)(transfer ? 1 : 0);
        CApiTransitions.addNativeRefCount(pointer, refCntDelta);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isBackendPointerObject(Object obj) {
        return obj != null && (obj.getClass().toString().contains("LLVMPointerImpl") || obj.getClass().toString().contains("NFIPointer") || obj.getClass().toString().contains("NativePointer"));
    }

    public static final class HandleContext {
        private static final int DEFAULT_CAPACITY = 10;
        public final NativeObjectReferenceArrayWrapper referencesToBeFreed = new NativeObjectReferenceArrayWrapper();
        public final HashMap<Long, IdReference<?>> nativeLookup = new HashMap();
        public final ConcurrentHashMap<Long, Long> nativeWeakRef = new ConcurrentHashMap();
        public final WeakHashMap<Object, WeakReference<Object>> managedNativeLookup = new WeakHashMap();
        public final HashMap<Long, PythonObjectReference> nativeStubLookup = new HashMap();
        public final Set<NativeStorageReference> nativeStorageReferences = new HashSet<NativeStorageReference>();
        public final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
        volatile boolean referenceQueuePollActive = false;
    }

    public static final class NativeStorageReference
    extends IdReference<NativeSequenceStorage> {
        private final SequenceStorage.ListStorageType type;
        private Object ptr;
        private int size;

        public NativeStorageReference(HandleContext handleContext, NativeSequenceStorage storage) {
            super(handleContext, storage);
            this.type = storage.getElementType();
            this.ptr = storage.getPtr();
            this.size = storage.length();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(PythonUtils.formatJString("new NativeStorageReference<%s>", this.ptr));
            }
        }

        public Object getPtr() {
            return this.ptr;
        }

        public void setPtr(Object ptr) {
            this.ptr = ptr;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    public static final class PythonObjectReference
    extends IdReference<PythonNativeWrapper> {
        private PythonNativeWrapper strongReference;
        private final long pointer;

        private PythonObjectReference(HandleContext handleContext, PythonNativeWrapper referent, boolean strong, long pointer) {
            super(handleContext, referent);
            this.pointer = pointer;
            PythonNativeWrapper pythonNativeWrapper = this.strongReference = strong ? referent : null;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(PythonUtils.formatJString("new %s PythonObjectReference<%s> to %s", strong ? "strong" : "weak", Long.toHexString(pointer), referent));
            }
            referent.ref = this;
        }

        public static PythonObjectReference create(HandleContext handleContext, PythonNativeWrapper.PythonAbstractObjectNativeWrapper referent, boolean strong, long pointer) {
            return new PythonObjectReference(handleContext, referent, strong, pointer);
        }

        public static PythonObjectReference create(HandleContext handleContext, PythonNativeWrapper referent, long pointer) {
            return new PythonObjectReference(handleContext, referent, true, pointer);
        }

        public boolean isStrongReference() {
            return this.strongReference != null;
        }

        public void setStrongReference(PythonNativeWrapper wrapper) {
            this.strongReference = wrapper;
        }

        public String toString() {
            return "PythonObjectReference<" + (this.strongReference == null ? "" : "strong,") + Long.toHexString(this.pointer) + ">";
        }
    }

    public static final class HandlePointerConverter {
        private static final long HANDLE_BASE = Long.MIN_VALUE;
        private static final int POINTER_ALIGNMENT_SHIFT = 3;
        private static final long POINTER_ALIGNMENT_MASK = 7L;

        public static long stubToPointer(long stubPointer) {
            assert ((stubPointer & 7L) == 0L);
            return stubPointer | Long.MIN_VALUE;
        }

        public static long pointerToStub(long pointer) {
            assert ((pointer & Long.MAX_VALUE & 7L) == 0L);
            return pointer & Long.MAX_VALUE;
        }

        public static boolean pointsToPyHandleSpace(long pointer) {
            return (pointer & Long.MIN_VALUE) != 0L;
        }
    }

    public static abstract class IdReference<T>
    extends WeakReference<T> {
        public IdReference(HandleContext handleContext, T referent) {
            super(referent, handleContext.referenceQueue);
        }
    }

    public static final class NativeObjectReference
    extends IdReference<PythonAbstractNativeObject> {
        final Object object;
        final long pointer;

        public NativeObjectReference(HandleContext handleContext, PythonAbstractNativeObject referent, long pointer) {
            super(handleContext, referent);
            this.object = referent.object;
            this.pointer = pointer;
            referent.ref = this;
            assert ((pointer & 7L) == 0L);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(PythonUtils.formatJString("new NativeObjectReference<%s> to %s", Long.toHexString(pointer), referent));
            }
        }

        public String toString() {
            return "NativeObjectReference<" + (this.get() == null ? "freed," : "") + Long.toHexString(this.pointer) + ">";
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class ToPythonWrapperNode
    extends CExtToJavaNode {
        public abstract PythonNativeWrapper executeWrapper(Object var1);

        @Specialization(guards={"!isNativeWrapper(obj)"}, limit="3")
        static PythonNativeWrapper doNonWrapper(Object obj, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="obj") InteropLibrary interopLibrary, @Cached InlinedConditionProfile isNullProfile, @Cached InlinedConditionProfile isLongProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedExactClassProfile nativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile) {
            long pointer;
            if (isLongProfile.profile(inliningTarget, obj instanceof Long)) {
                pointer = (Long)obj;
            } else {
                if (!interopLibrary.isPointer(obj)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("not a pointer: " + String.valueOf(obj)));
                }
                try {
                    pointer = interopLibrary.asPointer(obj);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            if (isNullProfile.profile(inliningTarget, pointer == 0L)) {
                return null;
            }
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                PythonNativeWrapper wrapper;
                PythonObjectReference reference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer);
                if (reference == null || (wrapper = (PythonNativeWrapper)reference.get()) == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
                }
                return wrapper;
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (isNativeProfile.profile(inliningTarget, lookup != null)) {
                Object ref = lookup.get();
                if (ref == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
                }
                Object profiled = nativeWrapperProfile.profile(inliningTarget, ref);
                if (profiled instanceof PythonNativeWrapper) {
                    PythonNativeWrapper nativeWrapper = (PythonNativeWrapper)profiled;
                    return nativeWrapper;
                }
            }
            return null;
        }

        @Specialization
        static PythonNativeWrapper doWrapper(PythonNativeWrapper wrapper) {
            return wrapper;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class NativePtrToPythonNode
    extends PNodeWithContext {
        public abstract Object execute(long var1, boolean var3);

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(long object, boolean stealing) {
            return CApiTransitionsFactory.NativePtrToPythonNodeGen.getUncached().execute(object, stealing);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        Object doNonWrapper(long pointer, boolean stealing, @Bind(value="$node") Node inliningTarget, @Cached InlinedConditionProfile isZeroProfile, @Cached InlinedConditionProfile createNativeProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile isNativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile, @Cached InlinedExactClassProfile wrapperProfile) {
            PythonNativeWrapper wrapper;
            CompilerAsserts.partialEvaluationConstant((boolean)stealing);
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            if (isZeroProfile.profile(inliningTarget, pointer == 0L)) {
                return PNone.NO_VALUE;
            }
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                PythonObjectReference reference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer);
                if (reference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was freed: " + Long.toHexString(pointer)));
                }
                wrapper = (PythonNativeWrapper)reference.get();
                if (wrapper != null) return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, stealing, wrapper);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (!isNativeProfile.profile(inliningTarget, lookup != null)) return CApiTransitions.createAbstractNativeObject(nativeContext, pointer, stealing, pointer);
            Object ref = lookup.get();
            if (createNativeProfile.profile(inliningTarget, ref == null)) {
                LOGGER.fine(() -> "re-creating collected PythonAbstractNativeObject reference" + Long.toHexString(pointer));
                return CApiTransitions.createAbstractNativeObject(nativeContext, pointer, stealing, pointer);
            }
            if (isNativeWrapperProfile.profile(inliningTarget, ref instanceof PythonNativeWrapper)) {
                wrapper = (PythonNativeWrapper)ref;
                return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, stealing, wrapper);
            } else {
                PythonAbstractNativeObject result = (PythonAbstractNativeObject)ref;
                if (!stealing) return result;
                CApiTransitions.addNativeRefCount(pointer, -1L);
                return result;
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class NativeToPythonStealingNode
    extends NativeToPythonNode {
        @Specialization
        static Object dummy(Void dummy) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.NativeToPythonStealingNodeGen.getUncached().execute(obj);
        }

        @Override
        protected final boolean needsTransfer() {
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class NativeToPythonNode
    extends CExtToJavaNode {
        public abstract Object execute(PythonNativeWrapper var1);

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.NativeToPythonNodeGen.getUncached().execute(obj);
        }

        protected boolean needsTransfer() {
            return false;
        }

        @Specialization
        static Object doWrapper(PythonNativeWrapper value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached InlinedExactClassProfile wrapperProfile) {
            return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, false, value);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization(guards={"!isNativeWrapper(value)"}, limit="3")
        Object doNonWrapper(Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="value") InteropLibrary interopLibrary, @Cached InlinedConditionProfile isNullProfile, @Cached InlinedConditionProfile isZeroProfile, @Cached InlinedConditionProfile createNativeProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile isNativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile, @Cached.Exclusive @Cached InlinedExactClassProfile wrapperProfile) {
            PythonNativeWrapper wrapper;
            long pointer;
            assert (!(value instanceof TruffleString));
            assert (!(value instanceof PythonAbstractObject));
            assert (!(value instanceof Number));
            if (isNullProfile.profile(inliningTarget, interopLibrary.isNull(value))) {
                return PNone.NO_VALUE;
            }
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            if (!interopLibrary.isPointer(value)) {
                return NativeToPythonNode.getManagedReference(value, nativeContext);
            }
            try {
                pointer = interopLibrary.asPointer(value);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (isZeroProfile.profile(inliningTarget, pointer == 0L)) {
                return PNone.NO_VALUE;
            }
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                PythonObjectReference reference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer);
                if (reference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was freed: " + Long.toHexString(pointer)));
                }
                wrapper = (PythonNativeWrapper)reference.get();
                if (wrapper != null) return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, this.needsTransfer(), wrapper);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (!isNativeProfile.profile(inliningTarget, lookup != null)) return CApiTransitions.createAbstractNativeObject(nativeContext, value, this.needsTransfer(), pointer);
            Object ref = lookup.get();
            if (createNativeProfile.profile(inliningTarget, ref == null)) {
                if (!LOGGER.isLoggable(Level.FINE)) return CApiTransitions.createAbstractNativeObject(nativeContext, value, this.needsTransfer(), pointer);
                LOGGER.fine(() -> "re-creating collected PythonAbstractNativeObject reference" + Long.toHexString(pointer));
                return CApiTransitions.createAbstractNativeObject(nativeContext, value, this.needsTransfer(), pointer);
            }
            if (isNativeWrapperProfile.profile(inliningTarget, ref instanceof PythonNativeWrapper)) {
                wrapper = (PythonNativeWrapper)ref;
                return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, this.needsTransfer(), wrapper);
            } else {
                PythonAbstractNativeObject result = (PythonAbstractNativeObject)ref;
                if (!this.needsTransfer()) return result;
                CApiTransitions.addNativeRefCount(pointer, -1L);
                return result;
            }
        }

        static Object handleWrapper(Node node, InlinedExactClassProfile wrapperProfile, boolean transfer, PythonNativeWrapper wrapper) {
            PythonNativeWrapper profiledWrapper = (PythonNativeWrapper)wrapperProfile.profile(node, (Object)wrapper);
            if (transfer && profiledWrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)profiledWrapper;
                assert (objectNativeWrapper.getRefCount() > 10L);
                objectNativeWrapper.decRef();
            }
            if (profiledWrapper instanceof PrimitiveNativeWrapper) {
                PrimitiveNativeWrapper primitive = (PrimitiveNativeWrapper)profiledWrapper;
                if (primitive.isBool()) {
                    return primitive.getBool();
                }
                if (primitive.isInt()) {
                    return primitive.getInt();
                }
                if (primitive.isLong()) {
                    return primitive.getLong();
                }
                if (primitive.isDouble()) {
                    return primitive.getDouble();
                }
                throw CompilerDirectives.shouldNotReachHere();
            }
            return wrapper.getDelegate();
        }

        @CompilerDirectives.TruffleBoundary
        private static Object getManagedReference(Object value, HandleContext nativeContext) {
            assert (value.toString().startsWith("ManagedMemoryBlock"));
            assert (PythonContext.get(null).ownsGil());
            WeakReference ref = nativeContext.managedNativeLookup.computeIfAbsent(value, o -> new WeakReference<PythonAbstractNativeObject>(new PythonAbstractNativeObject(o)));
            Object result = ref.get();
            if (result == null) {
                result = new PythonAbstractNativeObject(value);
                nativeContext.managedNativeLookup.put(value, new WeakReference<PythonAbstractNativeObject>((PythonAbstractNativeObject)result));
            }
            return result;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PythonToNativeNewRefNode
    extends PythonToNativeNode {
        @Specialization
        static Object dummy(Void dummy) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.PythonToNativeNewRefNodeGen.getUncached().execute(obj);
        }

        @Override
        protected final boolean needsTransfer() {
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class, PGuards.class})
    public static abstract class PythonToNativeNode
    extends CExtToNativeNode {
        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.PythonToNativeNodeGen.getUncached().execute(obj);
        }

        protected boolean needsTransfer() {
            return false;
        }

        @Specialization
        Object doNative(PythonAbstractNativeObject obj, @Cached CExtNodes.PCallCapiFunction callAddRef) {
            if (this.needsTransfer()) {
                callAddRef.call(NativeCAPISymbol.FUN_ADDREF, obj.object, 1);
            }
            return obj.getPtr();
        }

        @Specialization
        static Object doNative(PythonNativePointer obj) {
            return obj.getPtr();
        }

        @Specialization
        Object doNative(DescriptorDeleteMarker obj) {
            return this.getContext().getNativeNull().getPtr();
        }

        @Specialization(guards={"isNoValue(obj)"})
        Object doNoValue(PNone obj) {
            return this.getContext().getNativeNull().getPtr();
        }

        static boolean isOther(Object obj) {
            return !(obj instanceof PythonAbstractNativeObject) && !(obj instanceof PythonNativePointer) && !(obj instanceof DescriptorDeleteMarker) && obj != PNone.NO_VALUE;
        }

        @Specialization(guards={"isOther(obj)"})
        static Object doOther(Object obj, @Bind(value="needsTransfer()") boolean needsTransfer, @Bind(value="this") Node inliningTarget, @Cached GetNativeWrapperNode getWrapper, @Cached GetReplacementNode getReplacementNode, @Cached InlinedConditionProfile isStrongProfile, @CachedLibrary(limit="3") InteropLibrary lib) {
            CompilerAsserts.partialEvaluationConstant((boolean)needsTransfer);
            CApiTransitions.pollReferenceQueue();
            PythonNativeWrapper wrapper = getWrapper.execute(obj);
            Object replacement = getReplacementNode.execute(inliningTarget, wrapper);
            if (replacement != null) {
                return replacement;
            }
            assert (PythonContext.get(inliningTarget).getEnv().isNativeAccessAllowed());
            assert (obj != PNone.NO_VALUE);
            if (!lib.isPointer((Object)wrapper)) {
                lib.toNative((Object)wrapper);
            }
            if (needsTransfer && wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
                objectNativeWrapper.incRef();
                assert (wrapper.ref != null);
                if (isStrongProfile.profile(inliningTarget, !objectNativeWrapper.ref.isStrongReference())) {
                    objectNativeWrapper.ref.setStrongReference(objectNativeWrapper);
                }
            }
            assert (wrapper != null);
            return wrapper;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CharPtrToPythonNode
    extends CExtToJavaNode {
        @Specialization
        static Object doForeign(Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary interopLibrary, @Cached InlinedExactClassProfile classProfile, @Cached InlinedConditionProfile isNullProfile, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached ResolveHandleNode resolveHandleNode) {
            Object profiledValue = classProfile.profile(inliningTarget, value);
            if (isNullProfile.profile(inliningTarget, interopLibrary.isNull(profiledValue))) {
                return PNone.NO_VALUE;
            }
            CApiTransitions.log(profiledValue);
            assert (!(profiledValue instanceof Long));
            if (profiledValue instanceof String) {
                return CApiTransitions.logResult(PythonUtils.toTruffleStringUncached((String)profiledValue));
            }
            if (profiledValue instanceof TruffleString) {
                return CApiTransitions.logResult(profiledValue);
            }
            if (interopLibrary.isPointer(profiledValue)) {
                PythonNativeWrapper obj;
                long pointer;
                try {
                    pointer = interopLibrary.asPointer(profiledValue);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (HandlePointerConverter.pointsToPyHandleSpace(pointer) && (obj = resolveHandleNode.execute(inliningTarget, pointer)) != null) {
                    return CApiTransitions.logResult(obj.getDelegate());
                }
            }
            return CApiTransitions.logResult(fromCharPointerNode.execute(profiledValue));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ResolveHandleNode
    extends Node {
        public abstract PythonNativeWrapper execute(Node var1, long var2);

        @Specialization
        static PythonNativeWrapper doGeneric(Node inliningTarget, long pointer, @Cached InlinedExactClassProfile profile) {
            HandleContext nativeContext = PythonContext.get((Node)inliningTarget).nativeContext;
            PythonObjectReference pythonObjectReference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer);
            PythonNativeWrapper wrapper = (PythonNativeWrapper)profile.profile(inliningTarget, (Object)((PythonNativeWrapper)pythonObjectReference.get()));
            assert (wrapper != null) : "reference was collected: " + Long.toHexString(pointer);
            if (wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
                objectNativeWrapper.incRef();
            }
            return wrapper;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FirstToNativeNode
    extends Node {
        public static long executeUncached(PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper, boolean immortal) {
            return CApiTransitionsFactory.FirstToNativeNodeGen.getUncached().execute(null, wrapper, immortal);
        }

        public final long execute(Node inliningTarget, PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper) {
            return this.execute(inliningTarget, wrapper, false);
        }

        public abstract long execute(Node var1, PythonNativeWrapper.PythonAbstractObjectNativeWrapper var2, boolean var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static long doGeneric(Node inliningTarget, PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper, boolean immortal, @Cached(inline=false) GilNode gil, @Cached(inline=false) CStructAccess.AllocateNode allocateNode, @Cached(inline=false) CStructAccess.WriteLongNode writeLongNode, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObjectNode, @Cached InlinedExactClassProfile wrapperProfile, @Cached GetClassNode getClassNode, @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode) {
            boolean acquired = gil.acquire();
            try {
                CApiTransitions.log(wrapper);
                assert (!(wrapper instanceof TruffleObjectNativeWrapper));
                CApiTransitions.pollReferenceQueue();
                long initialRefCount = immortal ? 0x3FFFFFFFFFFFFFFFL : 10L;
                Object type = getClassNode.execute(inliningTarget, NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, false, wrapper));
                Object nativeObjectStub = allocateNode.alloc(CStructs.PyObject);
                writeLongNode.write(nativeObjectStub, CFields.PyObject__ob_refcnt, initialRefCount);
                writeObjectNode.write(nativeObjectStub, CFields.PyObject__ob_type, type);
                HandleContext handleContext = PythonContext.get((Node)inliningTarget).nativeContext;
                long pointer = coerceToLongNode.execute(inliningTarget, nativeObjectStub);
                long stubPointer = HandlePointerConverter.stubToPointer(pointer);
                PythonObjectReference ref = PythonObjectReference.create(handleContext, wrapper, immortal, stubPointer);
                CApiTransitions.nativeStubLookupPut(handleContext, stubPointer, ref);
                long l = CApiTransitions.logResult(stubPointer);
                return l;
            }
            finally {
                gil.release(acquired);
            }
        }
    }
}

