/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCField;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;

public abstract class GraalHPyCAccess {
    private GraalHPyCAccess() {
    }

    public static abstract class WriteSizeTNode
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, long var5);

        public final void write(GraalHPyContext ctx, Object basePointer, GraalHPyCField field, long value) {
            this.execute(ctx, basePointer, ctx.getCFieldOffset(field), value);
        }

        public final void write(GraalHPyContext ctx, Object basePointer, long value) {
            this.execute(ctx, basePointer, 0L, value);
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc == HPyContextSignatureType.Size_t || desc == HPyContextSignatureType.HPy_ssize_t;
        }

        @NeverDefault
        public static WriteSizeTNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWriteSizeTNode();
        }

        public static WriteSizeTNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWriteSizeTNode();
        }
    }

    public static abstract class WritePointerNode
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, Object var5);

        public final void write(GraalHPyContext ctx, Object basePointer, GraalHPyCField field, Object valuePointer) {
            this.execute(ctx, basePointer, ctx.getCFieldOffset(field), valuePointer);
        }

        public final void write(GraalHPyContext ctx, Object basePointer, Object valuePointer) {
            this.execute(ctx, basePointer, 0L, valuePointer);
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return "POINTER".equals(desc.nfiType);
        }

        @NeverDefault
        public static WritePointerNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWritePointerNode();
        }

        public static WritePointerNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWritePointerNode();
        }
    }

    public static abstract class WriteHPyFieldNode
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, PythonObject var2, Object var3, long var4, Object var6);

        public final void write(GraalHPyContext ctx, PythonObject owner, Object pointer, GraalHPyCField field, Object value) {
            this.execute(ctx, owner, pointer, ctx.getCFieldOffset(field), value);
        }

        public final void write(GraalHPyContext ctx, PythonObject owner, Object pointer, Object value) {
            this.execute(ctx, owner, pointer, 0L, value);
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc == HPyContextSignatureType.HPyField;
        }

        @NeverDefault
        public static WriteHPyFieldNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWriteHPyFieldNode();
        }

        public static WriteHPyFieldNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWriteHPyFieldNode();
        }
    }

    public static abstract class WriteHPyNode
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, Object var5);

        public final void write(GraalHPyContext ctx, Object pointer, GraalHPyCField field, Object value) {
            this.execute(ctx, pointer, ctx.getCFieldOffset(field), value);
        }

        public final void write(GraalHPyContext ctx, Object pointer, Object value) {
            this.execute(ctx, pointer, 0L, value);
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc == HPyContextSignatureType.HPy;
        }

        @NeverDefault
        public static WriteHPyNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWriteHPyNode();
        }

        public static WriteHPyNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWriteHPyNode();
        }
    }

    public static abstract class WriteGenericNode
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, HPyContextSignatureType var5, Object var6);

        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, HPyContextSignatureType var5, long var6);

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return true;
        }

        @NeverDefault
        public static WriteGenericNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWriteGenericNode();
        }

        public static WriteGenericNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWriteGenericNode();
        }
    }

    public static abstract class WriteI64Node
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, long var5);

        public final void write(GraalHPyContext ctx, Object pointer, GraalHPyCField field, long value) {
            this.execute(ctx, pointer, ctx.getCFieldOffset(field), value);
        }

        public final void write(GraalHPyContext ctx, Object pointer, long value) {
            this.execute(ctx, pointer, 0L, value);
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc.jniType == Long.TYPE;
        }

        @NeverDefault
        public static WriteI64Node create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWriteI64Node();
        }

        public static WriteI64Node getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWriteI64Node();
        }
    }

    public static abstract class WriteI32Node
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, int var5);

        public final void write(GraalHPyContext ctx, Object pointer, GraalHPyCField field, int value) {
            this.execute(ctx, pointer, ctx.getCFieldOffset(field), value);
        }

        public final void write(GraalHPyContext ctx, Object pointer, int value) {
            this.execute(ctx, pointer, 0L, value);
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc.jniType == Integer.TYPE;
        }

        public final void writeArrayElement(GraalHPyContext ctx, Object pointer, long element, int value) {
            this.execute(ctx, pointer, element * 4L, value);
        }

        @NeverDefault
        public static WriteI32Node create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWriteI32Node();
        }

        public static WriteI32Node getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWriteI32Node();
        }
    }

    public static abstract class WriteDoubleNode
    extends CStructAccessNode {
        protected abstract void execute(GraalHPyContext var1, Object var2, long var3, double var5);

        public final void write(GraalHPyContext ctx, Object pointer, GraalHPyCField field, double value) {
            this.execute(ctx, pointer, ctx.getCFieldOffset(field), value);
        }

        public final void write(GraalHPyContext ctx, Object pointer, double value) {
            this.execute(ctx, pointer, 0L, value);
        }

        public final void writeArrayElement(GraalHPyContext ctx, Object pointer, long element, double value) {
            this.execute(ctx, pointer, element * 8L, value);
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc == HPyContextSignatureType.CDouble;
        }

        @NeverDefault
        public static WriteDoubleNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createWriteDoubleNode();
        }

        public static WriteDoubleNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedWriteDoubleNode();
        }
    }

    public static abstract class ReadPointerNode
    extends CStructAccessNode {
        protected abstract Object execute(GraalHPyContext var1, Object var2, long var3);

        public final Object read(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field));
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return "POINTER".equals(desc.nfiType);
        }

        public final Object readArrayElement(GraalHPyContext ctx, Object pointer, long element) {
            return this.execute(ctx, pointer, element * (long)ctx.getCTypeSize(HPyContextSignatureType.VoidPtr));
        }

        @NeverDefault
        public static ReadPointerNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadPointerNode();
        }

        public static ReadPointerNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadPointerNode();
        }
    }

    public static abstract class ReadDoubleNode
    extends CStructAccessNode {
        protected abstract double execute(GraalHPyContext var1, Object var2, long var3);

        public final double read(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field));
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc.jniType == Double.TYPE;
        }

        public final double readArrayElement(GraalHPyContext ctx, Object pointer, int element) {
            return this.execute(ctx, pointer, (long)element * 8L);
        }

        @NeverDefault
        public static ReadDoubleNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadDoubleNode();
        }

        public static ReadDoubleNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadDoubleNode();
        }
    }

    public static abstract class ReadFloatNode
    extends CStructAccessNode {
        protected abstract double execute(GraalHPyContext var1, Object var2, long var3);

        public final double read(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field));
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc.jniType == Double.TYPE;
        }

        public final double readArrayElement(GraalHPyContext ctx, Object pointer, int element) {
            return this.execute(ctx, pointer, (long)element * 4L);
        }

        @NeverDefault
        public static ReadFloatNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadFloatNode();
        }

        public static ReadFloatNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadFloatNode();
        }
    }

    public static abstract class ReadI64Node
    extends CStructAccessNode {
        protected abstract long execute(GraalHPyContext var1, Object var2, long var3);

        public final long read(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field));
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc.jniType == Long.TYPE;
        }

        @NeverDefault
        public static ReadI64Node create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadI64Node();
        }

        public static ReadI64Node getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadI64Node();
        }
    }

    public static abstract class ReadI32Node
    extends CStructAccessNode {
        protected abstract int execute(GraalHPyContext var1, Object var2, long var3);

        public final int read(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field));
        }

        public final long readUnsigned(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            assert (field.getType() == HPyContextSignatureType.Uint32_t);
            return (long)this.execute(ctx, pointer, ctx.getCFieldOffset(field)) & 0xFFFFFFFFL;
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return desc.jniType == Integer.TYPE;
        }

        public final int readOffset(GraalHPyContext ctx, Object pointer, long offset) {
            return this.execute(ctx, pointer, offset);
        }

        public final int readArrayElement(GraalHPyContext ctx, Object pointer, long element) {
            return this.execute(ctx, pointer, element * 4L);
        }

        @NeverDefault
        public static ReadI32Node create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadI32Node();
        }

        public static ReadI32Node getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadI32Node();
        }
    }

    public static abstract class ReadHPyArrayNode
    extends CStructAccessNode {
        protected abstract Object[] execute(GraalHPyContext var1, Object var2, long var3, long var5);

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return false;
        }

        @NeverDefault
        public static ReadHPyArrayNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadHPyArrayNode();
        }

        public static ReadHPyArrayNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadHPyArrayNode();
        }
    }

    public static abstract class ReadHPyFieldNode
    extends CStructAccessNode {
        protected abstract Object execute(GraalHPyContext var1, PythonObject var2, Object var3, long var4, boolean var6);

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return false;
        }

        public final Object read(GraalHPyContext ctx, PythonObject owner, Object pointer, long offset) {
            return this.execute(ctx, owner, pointer, offset, false);
        }

        public final Object read(GraalHPyContext ctx, PythonObject owner, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, owner, pointer, ctx.getCFieldOffset(field), false);
        }

        @NeverDefault
        public static ReadHPyFieldNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadHPyFieldNode();
        }

        public static ReadHPyFieldNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadFieldHPyNode();
        }
    }

    public static abstract class ReadHPyNode
    extends CStructAccessNode {
        protected abstract Object execute(GraalHPyContext var1, Object var2, long var3, boolean var5);

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return false;
        }

        public final Object read(GraalHPyContext ctx, Object pointer, long offset) {
            return this.execute(ctx, pointer, offset, false);
        }

        public final Object read(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field), false);
        }

        public final Object readAndClose(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field), true);
        }

        @NeverDefault
        public static ReadHPyNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadHPyNode();
        }

        public static ReadHPyNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadHPyNode();
        }
    }

    public static abstract class ReadI8ArrayNode
    extends CStructAccessNode {
        protected abstract byte[] execute(GraalHPyContext var1, Object var2, long var3, long var5);

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return false;
        }

        @NeverDefault
        public static ReadI8ArrayNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadI8ArrayNode();
        }

        public static ReadI8ArrayNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadI8ArrayNode();
        }
    }

    public static abstract class ReadGenericNode
    extends CStructAccessNode {
        protected abstract Object execute(GraalHPyContext var1, Object var2, long var3, HPyContextSignatureType var5);

        protected abstract int executeInt(GraalHPyContext var1, Object var2, long var3, HPyContextSignatureType var5);

        protected abstract long executeLong(GraalHPyContext var1, Object var2, long var3, HPyContextSignatureType var5);

        @Override
        boolean accepts(HPyContextSignatureType type) {
            return true;
        }

        public final Object read(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field), field.getType());
        }

        public final int readInt(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.executeInt(ctx, pointer, ctx.getCFieldOffset(field), field.getType());
        }

        public final long readLong(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.executeLong(ctx, pointer, ctx.getCFieldOffset(field), field.getType());
        }

        @NeverDefault
        public static ReadGenericNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createReadGenericNode();
        }

        public static ReadGenericNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedReadGenericNode();
        }
    }

    public static abstract class GetElementPtrNode
    extends CStructAccessNode {
        public abstract Object execute(GraalHPyContext var1, Object var2, long var3);

        public final Object getElementPtr(GraalHPyContext ctx, Object pointer, GraalHPyCField field) {
            return this.execute(ctx, pointer, ctx.getCFieldOffset(field));
        }

        @Override
        public final boolean accepts(HPyContextSignatureType desc) {
            return true;
        }

        @NeverDefault
        public static GetElementPtrNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createGetElementPtrNode();
        }

        public static GetElementPtrNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedGetElementPtrNode();
        }
    }

    public static abstract class IsNullNode
    extends Node {
        protected abstract boolean execute(GraalHPyContext var1, Object var2);

        public static boolean executeUncached(GraalHPyContext ctx, Object pointer) {
            return IsNullNode.getUncached(ctx).execute(ctx, pointer);
        }

        @NeverDefault
        public static IsNullNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createIsNullNode();
        }

        public static IsNullNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedIsNullNode();
        }
    }

    public static abstract class BulkFreeHandleReferencesNode
    extends Node {
        protected abstract void execute(GraalHPyContext var1, GraalHPyContext.GraalHPyHandleReference[] var2);

        @NeverDefault
        public static BulkFreeHandleReferencesNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createBulkFreeHandleReferencesNode();
        }
    }

    public static abstract class FreeNode
    extends Node {
        protected abstract void execute(GraalHPyContext var1, Object var2);

        public final void free(GraalHPyContext ctx, Object pointer) {
            this.execute(ctx, pointer);
        }

        @NeverDefault
        public static FreeNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createFreeNode();
        }

        public static FreeNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedFreeNode();
        }
    }

    public static abstract class AllocateNode
    extends Node {
        protected abstract Object execute(GraalHPyContext var1, long var2, boolean var4);

        public final Object malloc(GraalHPyContext ctx, long size) {
            return this.execute(ctx, size, false);
        }

        public final Object malloc(GraalHPyContext ctx, HPyContextSignatureType ctype) {
            return this.execute(ctx, ctx.getCTypeSize(ctype), false);
        }

        public final Object calloc(GraalHPyContext ctx, long count, long size) {
            return this.execute(ctx, count * size, true);
        }

        @NeverDefault
        public static AllocateNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createAllocateNode();
        }

        public static AllocateNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedAllocateNode();
        }
    }

    private static abstract class CStructAccessNode
    extends Node {
        private CStructAccessNode() {
        }

        abstract boolean accepts(HPyContextSignatureType var1);

        final boolean accepts(GraalHPyCField field) {
            return this.accepts(field.getType());
        }

        public static long getElementPtr(GraalHPyContext ctx, long idx, long elementSize, GraalHPyCField field) {
            return idx * elementSize + (long)ctx.getCFieldOffset(field);
        }

        public static long getElementPtr(GraalHPyContext ctx, long idx, HPyContextSignatureType elementType, GraalHPyCField field) {
            return idx * (long)ctx.getCTypeSize(elementType) + (long)ctx.getCFieldOffset(field);
        }
    }
}

