/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.llvm;

import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMContext;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.Arrays;

abstract class HPyArrayWrappers {
    HPyArrayWrappers() {
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class IntArrayWrapper
    implements TruffleObject {
        final int[] delegate;

        public IntArrayWrapper(int[] delegate) {
            this.delegate = delegate;
        }

        public int[] getDelegate() {
            return this.delegate;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.delegate.length;
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable")})
        boolean isValidIndex(long index) {
            return 0L <= index && index < (long)this.delegate.length;
        }

        @ExportMessage
        boolean isArrayElementInsertable(long index) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            return this.delegate[this.checkIndex(index)];
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void writeArrayElement(long index, Object value, @CachedLibrary(limit="1") InteropLibrary lib) throws UnsupportedTypeException, InvalidArrayIndexException {
            this.delegate[this.checkIndex((long)index)] = this.coerceToInt(value, lib);
        }

        private int coerceToInt(Object value, InteropLibrary lib) throws UnsupportedTypeException {
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                return i;
            }
            if (lib.fitsInInt(value)) {
                try {
                    return lib.asInt(value);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw UnsupportedTypeException.create((Object[])new Object[]{value});
        }

        private int checkIndex(long index) throws InvalidArrayIndexException {
            if (index < 0L || index > (long)this.delegate.length) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return (int)index;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HPyCloseArrayWrapperNode
    extends Node {
        HPyCloseArrayWrapperNode() {
        }

        public abstract void execute(Node var1, HPyArrayWrapper var2);

        @Specialization(guards={"cachedLen == wrapper.delegate.length", "cachedLen <= 8"}, limit="1")
        @ExplodeLoop
        static void doCachedLen(Node inliningTarget, HPyArrayWrapper wrapper, @Cached(value="wrapper.delegate.length") int cachedLen, @Cached.Exclusive @Cached GraalHPyNodes.HPyCloseHandleNode closeHandleNode, @Cached(value="createProfiles(cachedLen)", dimensions=1) ConditionProfile[] profiles, @Cached.Exclusive @Cached InlinedConditionProfile isPointerProfile) {
            for (int i = 0; i < cachedLen; ++i) {
                Object element = wrapper.delegate[i];
                if (!profiles[i].profile(element instanceof GraalHPyHandle)) continue;
                closeHandleNode.execute(inliningTarget, element);
            }
            if (isPointerProfile.profile(inliningTarget, wrapper.isPointer())) {
                wrapper.hpyContext.freeNativeArgumentsArray(wrapper.delegate.length);
                wrapper.setNativePointer(-1L);
            }
        }

        @Specialization(replaces={"doCachedLen"})
        static void doLoop(Node inliningTarget, HPyArrayWrapper wrapper, @Cached.Exclusive @Cached GraalHPyNodes.HPyCloseHandleNode closeHandleNode, @Cached.Exclusive @Cached InlinedConditionProfile profile, @Cached.Exclusive @Cached InlinedConditionProfile isPointerProfile) {
            for (Object element : wrapper.delegate) {
                if (!profile.profile(inliningTarget, element instanceof GraalHPyHandle)) continue;
                closeHandleNode.execute(inliningTarget, element);
            }
            if (isPointerProfile.profile(inliningTarget, wrapper.isPointer())) {
                wrapper.hpyContext.freeNativeArgumentsArray(wrapper.delegate.length);
                wrapper.setNativePointer(-1L);
            }
        }

        static ConditionProfile[] createProfiles(int n) {
            ConditionProfile[] profiles = new ConditionProfile[n];
            for (int i = 0; i < profiles.length; ++i) {
                profiles[i] = ConditionProfile.create();
            }
            return profiles;
        }
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=false)})
    static final class HPyArrayWrapper
    implements TruffleObject {
        private static final int UNINITIALIZED = 0;
        private static final int INVALIDATED = -1;
        final GraalHPyContext hpyContext;
        final Object[] delegate;
        private final GraalHPyHandle[] wrappers;
        private long nativePointer = 0L;

        public HPyArrayWrapper(GraalHPyContext hpyContext, Object[] delegate) {
            this.hpyContext = hpyContext;
            this.delegate = delegate;
            this.wrappers = new GraalHPyHandle[delegate.length];
        }

        public Object[] getDelegate() {
            return this.delegate;
        }

        void setNativePointer(long nativePointer) {
            assert (nativePointer != 0L);
            this.nativePointer = nativePointer;
        }

        long getNativePointer() {
            return this.nativePointer;
        }

        public int hashCode() {
            CompilerAsserts.neverPartOfCompilation();
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.delegate);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.delegate == ((HPyArrayWrapper)obj).delegate;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.delegate.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < (long)this.delegate.length;
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached GraalHPyNodes.HPyAsHandleNode asHandleNode) throws InvalidArrayIndexException {
            if (index < 0L || index > (long)this.delegate.length) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
            int i = (int)index;
            GraalHPyHandle wrapper = this.wrappers[i];
            if (wrapper == null) {
                this.wrappers[i] = wrapper = asHandleNode.execute(this.delegate[i]);
            }
            return wrapper;
        }

        @ExportMessage
        boolean isPointer() {
            return this.nativePointer != 0L;
        }

        @ExportMessage
        long asPointer() throws UnsupportedMessageException {
            if (!this.isPointer()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedMessageException.create();
            }
            return this.nativePointer;
        }

        @ExportMessage
        void toNative() {
            if (!this.isPointer()) {
                this.setNativePointer(this.hpyContext.createNativeArguments(this.delegate));
            }
        }

        @ExportMessage
        boolean hasNativeType() {
            return this.hpyContext.getBackend() instanceof GraalHPyLLVMContext;
        }

        @ExportMessage
        Object getNativeType() {
            GraalHPyNativeContext graalHPyNativeContext = this.hpyContext.getBackend();
            if (graalHPyNativeContext instanceof GraalHPyLLVMContext) {
                GraalHPyLLVMContext llvmContext = (GraalHPyLLVMContext)graalHPyNativeContext;
                return llvmContext.getHPyArrayNativeType();
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        void close() {
            for (int i = 0; i < this.wrappers.length; ++i) {
                if (this.wrappers[i] == null) continue;
                GraalHPyNodes.HPyCloseHandleNode.executeUncached(this.wrappers[i]);
                this.wrappers[i] = null;
            }
            if (this.isPointer()) {
                this.hpyContext.freeNativeArgumentsArray(this.delegate.length);
            }
        }
    }
}

