/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodesFactory;
import com.oracle.graal.python.builtins.objects.common.KeywordsStorage;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMapFactory;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.util.CastBuiltinStringToTruffleStringNode;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public class HashingStorageNodes {
    static EconomicMapStorage dynamicObjectStorageToEconomicMap(Node inliningTarget, DynamicObjectStorage s, DynamicObjectLibrary dylib, PyObjectHashNode hashNode, ObjectHashMap.PutNode putNode) {
        Object[] keys;
        DynamicObject store = s.store;
        EconomicMapStorage result = EconomicMapStorage.create(dylib.getShape(store).getPropertyCount());
        ObjectHashMap resultMap = result.map;
        for (Object k : keys = dylib.getKeyArray(store)) {
            Object v;
            if (!(k instanceof TruffleString) || (v = dylib.getOrDefault(store, k, (Object)PNone.NO_VALUE)) == PNone.NO_VALUE) continue;
            putNode.execute(null, inliningTarget, resultMap, k, hashNode.execute(null, inliningTarget, k), v);
        }
        return result;
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class HashingStorageAddAllToOther
    extends Node {
        public static void executeUncached(HashingStorage source, PHashingCollection dest) {
            HashingStorageNodesFactory.HashingStorageAddAllToOtherNodeGen.getUncached().execute(null, null, source, dest);
        }

        @NeverDefault
        public static HashingStorageAddAllToOther create() {
            return HashingStorageNodesFactory.HashingStorageAddAllToOtherNodeGen.create();
        }

        public final void execute(Frame frame, Node inliningTarget, HashingStorage source, PHashingCollection dest) {
            dest.setDictStorage(this.execute(frame, inliningTarget, source, dest.getDictStorage()));
        }

        public final HashingStorage executeCached(Frame frame, HashingStorage source, HashingStorage dest) {
            return this.execute(frame, (Node)this, source, dest);
        }

        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, HashingStorage var4);

        @Specialization(guards={"source == dest"})
        static HashingStorage doIdentical(Frame frame, HashingStorage source, HashingStorage dest) {
            return dest;
        }

        @Specialization(guards={"source != dest"})
        static HashingStorage doIt(Frame frame, Node inliningTarget, HashingStorage source, HashingStorage dest, @Cached HashingStorageForEach forEach, @Cached HashingStorageTransferItem transferItem) {
            return forEach.execute(frame, inliningTarget, source, transferItem, dest);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HashingStorageTransferItem
    extends HashingStorageForEachCallback<HashingStorage> {
        @Override
        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, HashingStorageIterator var4, HashingStorage var5);

        @Specialization
        static EconomicMapStorage economic2Economic(Frame frame, Node inliningTarget, EconomicMapStorage src, HashingStorageIterator it, EconomicMapStorage destStorage, @Cached ObjectHashMap.PutNode putNode) {
            ObjectHashMap srcMap = src.map;
            putNode.put(frame, inliningTarget, destStorage.map, srcMap.getKey(it.index), srcMap.hashes[it.index], srcMap.getValue(it.index));
            return destStorage;
        }

        @Specialization(replaces={"economic2Economic"})
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage economic2Generic(Frame frame, Node inliningTarget, EconomicMapStorage src, HashingStorageIterator it, HashingStorage destStorage, @Cached HashingStorageSetItemWithHash setItemWithHash) {
            ObjectHashMap srcMap = src.map;
            return setItemWithHash.execute(frame, inliningTarget, destStorage, srcMap.getKey(it.index), srcMap.hashes[it.index], srcMap.getValue(it.index));
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static HashingStorage generic2Generic(Frame frame, Node inliningTarget, HashingStorage src, HashingStorageIterator it, HashingStorage destStorage, @Cached HashingStorageIteratorKey iterKey, @Cached HashingStorageIteratorValue iterValue, @Cached HashingStorageSetItem setItem) {
            return setItem.execute(frame, inliningTarget, destStorage, iterKey.execute(inliningTarget, src, it), iterValue.execute(inliningTarget, src, it));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageAreDisjoint
    extends Node {
        public abstract boolean execute(Frame var1, Node var2, HashingStorage var3, HashingStorage var4);

        @Specialization
        static boolean doGeneric(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorage bStorage, @Cached HashingStorageLen aLenNode, @Cached HashingStorageLen bLenNode, @Cached HashingStorageForEach forEach, @Cached HashingStorageAreDisjointCallback callback) {
            int aLen = aLenNode.execute(inliningTarget, aStorage);
            int bLen = bLenNode.execute(inliningTarget, bStorage);
            try {
                if (aLen > bLen) {
                    forEach.execute(frame, inliningTarget, bStorage, callback, aStorage);
                } else {
                    forEach.execute(frame, inliningTarget, aStorage, callback, bStorage);
                }
                return true;
            }
            catch (AbortIteration ignore) {
                return false;
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageAreDisjointCallback
    extends HashingStorageForEachCallback<HashingStorage> {
        @Override
        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, HashingStorageIterator var4, HashingStorage var5);

        @Specialization
        static HashingStorage doGeneric(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorageIterator it, HashingStorage bStorage, @Cached HashingStorageGetItemWithHash getFromOther, @Cached HashingStorageIteratorKey iterKey, @Cached HashingStorageIteratorKeyHash iterHash) {
            long hash;
            Object key = iterKey.execute(inliningTarget, aStorage, it);
            Object otherValue = getFromOther.execute(frame, inliningTarget, bStorage, key, hash = iterHash.execute(inliningTarget, aStorage, it));
            if (otherValue != null) {
                throw AbortIteration.INSTANCE;
            }
            return bStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageCompareKeys
    extends Node {
        public abstract int execute(Frame var1, Node var2, HashingStorage var3, HashingStorage var4);

        @Specialization(guards={"aStorage == bStorage"})
        static int doSame(HashingStorage aStorage, HashingStorage bStorage) {
            return 0;
        }

        @Specialization(guards={"aStorage != bStorage"})
        static int doGeneric(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorage bStorage, @Cached HashingStorageLen aLenNode, @Cached HashingStorageLen bLenNode, @Cached HashingStorageForEach forEachA, @Cached HashingStorageCompareKeysCallback callback) {
            int bLen;
            int aLen = aLenNode.execute(inliningTarget, aStorage);
            if (aLen > (bLen = bLenNode.execute(inliningTarget, bStorage))) {
                return 1;
            }
            try {
                forEachA.execute(frame, inliningTarget, aStorage, callback, bStorage);
            }
            catch (AbortIteration ignored) {
                return 1;
            }
            if (aLen == bLen) {
                return 0;
            }
            return -1;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageCompareKeysCallback
    extends HashingStorageForEachCallback<HashingStorage> {
        @Override
        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, HashingStorageIterator var4, HashingStorage var5);

        @Specialization
        static HashingStorage doGeneric(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorageIterator it, HashingStorage bStorage, @Cached HashingStorageGetItemWithHash getFromOther, @Cached HashingStorageIteratorKey iterKey, @Cached HashingStorageIteratorKeyHash iterHash) {
            long hash;
            Object key = iterKey.execute(inliningTarget, aStorage, it);
            Object otherValue = getFromOther.execute(frame, inliningTarget, bStorage, key, hash = iterHash.execute(inliningTarget, aStorage, it));
            if (otherValue == null) {
                throw AbortIteration.INSTANCE;
            }
            return bStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageDiff
    extends Node {
        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, HashingStorage var4);

        @Specialization
        static HashingStorage doIt(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorage bStorage, @Cached HashingStorageForEach forEachA, @Cached HashingStorageDiffCallback callback) {
            EconomicMapStorage result = EconomicMapStorage.createWithSideEffects();
            ResultAndOther acc = new ResultAndOther(result.map, bStorage);
            forEachA.execute(frame, inliningTarget, aStorage, callback, acc);
            return result;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageDiffCallback
    extends HashingStorageForEachCallback<ResultAndOther> {
        @Override
        public abstract ResultAndOther execute(Frame var1, Node var2, HashingStorage var3, HashingStorageIterator var4, ResultAndOther var5);

        @Specialization
        static ResultAndOther doGeneric(Frame frame, Node inliningTarget, HashingStorage storage, HashingStorageIterator it, ResultAndOther acc, @Cached ObjectHashMap.PutNode putResultNode, @Cached HashingStorageGetItemWithHash getFromOther, @Cached HashingStorageIteratorKey iterKey, @Cached HashingStorageIteratorKeyHash iterHash, @Cached HashingStorageIteratorValue iterValue) {
            long hash;
            Object key = iterKey.execute(inliningTarget, storage, it);
            Object otherValue = getFromOther.execute(frame, inliningTarget, acc.other, key, hash = iterHash.execute(inliningTarget, storage, it));
            if (otherValue == null) {
                putResultNode.put(frame, inliningTarget, acc.result, key, hash, iterValue.execute(inliningTarget, storage, it));
            }
            return acc;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageIntersect
    extends Node {
        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, HashingStorage var4);

        @Specialization
        static HashingStorage doIt(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorage bStorage, @Cached HashingStorageForEach forEachA, @Cached HashingStorageIntersectCallback callback) {
            EconomicMapStorage result = EconomicMapStorage.createWithSideEffects();
            ResultAndOther acc = new ResultAndOther(result.map, bStorage);
            forEachA.execute(frame, inliningTarget, aStorage, callback, acc);
            return result;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageIntersectCallback
    extends HashingStorageForEachCallback<ResultAndOther> {
        @Override
        public abstract ResultAndOther execute(Frame var1, Node var2, HashingStorage var3, HashingStorageIterator var4, ResultAndOther var5);

        @Specialization
        static ResultAndOther doGeneric(Frame frame, Node inliningTarget, HashingStorage storage, HashingStorageIterator it, ResultAndOther acc, @Cached ObjectHashMap.PutNode putResultNode, @Cached HashingStorageGetItemWithHash getFromOther, @Cached HashingStorageIteratorKey iterKey, @Cached HashingStorageIteratorKeyHash iterHash) {
            long hash;
            Object key = iterKey.execute(inliningTarget, storage, it);
            Object otherValue = getFromOther.execute(frame, inliningTarget, acc.other, key, hash = iterHash.execute(inliningTarget, storage, it));
            if (otherValue != null) {
                putResultNode.put(frame, inliningTarget, acc.result, key, hash, otherValue);
            }
            return acc;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageXor
    extends Node {
        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, HashingStorage var4);

        @Specialization
        static HashingStorage doIt(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorage bStorage, @Cached HashingStorageForEach forEachA, @Cached HashingStorageForEach forEachB, @Cached HashingStorageXorCallback callbackA, @Cached HashingStorageXorCallback callbackB) {
            EconomicMapStorage result = EconomicMapStorage.createWithSideEffects();
            ObjectHashMap resultMap = result.map;
            ResultAndOther accA = new ResultAndOther(resultMap, bStorage);
            forEachA.execute(frame, inliningTarget, aStorage, callbackA, accA);
            ResultAndOther accB = new ResultAndOther(resultMap, aStorage);
            forEachB.execute(frame, inliningTarget, bStorage, callbackB, accB);
            return result;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageXorCallback
    extends HashingStorageForEachCallback<ResultAndOther> {
        @Override
        public abstract ResultAndOther execute(Frame var1, Node var2, HashingStorage var3, HashingStorageIterator var4, ResultAndOther var5);

        @Specialization
        static ResultAndOther doGeneric(Frame frame, Node inliningTarget, HashingStorage storage, HashingStorageIterator it, ResultAndOther acc, @Cached ObjectHashMap.PutNode putResultNode, @Cached HashingStorageGetItemWithHash getFromOther, @Cached HashingStorageIteratorKey iterKey, @Cached HashingStorageIteratorValue iterValue, @Cached HashingStorageIteratorKeyHash iterHash) {
            long hash;
            Object key = iterKey.execute(inliningTarget, storage, it);
            Object otherValue = getFromOther.execute(frame, inliningTarget, acc.other, key, hash = iterHash.execute(inliningTarget, storage, it));
            if (otherValue == null) {
                putResultNode.put(frame, inliningTarget, acc.result, key, hash, iterValue.execute(inliningTarget, storage, it));
            }
            return acc;
        }
    }

    @CompilerDirectives.ValueType
    public static final class ResultAndOther {
        final ObjectHashMap result;
        final HashingStorage other;

        public ResultAndOther(ObjectHashMap result, HashingStorage other) {
            this.result = result;
            this.other = other;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageForEach
    extends Node {
        public static <T> T executeUncached(HashingStorage storage, HashingStorageForEachCallback<T> callback, T accumulator) {
            return (T)HashingStorageNodesFactory.HashingStorageForEachNodeGen.getUncached().executeUntyped(null, null, storage, callback, accumulator);
        }

        public final <T> T execute(Frame frame, Node inliningTarget, HashingStorage storage, HashingStorageForEachCallback<T> callback, T accumulator) {
            CompilerAsserts.partialEvaluationConstant(callback);
            return (T)this.executeUntyped(frame, inliningTarget, storage, callback, accumulator);
        }

        abstract Object executeUntyped(Frame var1, Node var2, HashingStorage var3, HashingStorageForEachCallback<Object> var4, Object var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doIt(Frame frame, Node callbackInliningTarget, HashingStorage storage, HashingStorageForEachCallback<Object> callback, Object accumulatorIn, @Bind(value="this") Node inliningTarget, @Cached HashingStorageGetIterator getIter, @Cached HashingStorageIteratorNext iterNext, @Cached InlinedLoopConditionProfile loopProfile) {
            int index = 0;
            Object accumulator = accumulatorIn;
            try {
                HashingStorageIterator aIter = getIter.execute(inliningTarget, storage);
                while (loopProfile.profile(inliningTarget, iterNext.execute(inliningTarget, storage, aIter))) {
                    if (CompilerDirectives.hasNextTier()) {
                        ++index;
                    }
                    accumulator = callback.execute(frame, callbackInliningTarget, storage, aIter, accumulator);
                }
            }
            finally {
                if (index != 0) {
                    LoopNode.reportLoopCount((Node)getIter, (int)index);
                }
            }
            return accumulator;
        }
    }

    public static abstract class HashingStorageForEachCallback<T>
    extends Node {
        public abstract T execute(Frame var1, Node var2, HashingStorage var3, HashingStorageIterator var4, T var5);
    }

    private static final class AbortIteration
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private static final AbortIteration INSTANCE = new AbortIteration();

        public AbortIteration() {
            super(null, null);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageEq
    extends Node {
        public abstract boolean execute(Frame var1, Node var2, HashingStorage var3, HashingStorage var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean doIt(Frame frame, Node inliningTarget, HashingStorage aStorage, HashingStorage bStorage, @Cached HashingStorageGetItemWithHash getBNode, @Cached HashingStorageLen lenANode, @Cached HashingStorageLen lenBNode, @Cached HashingStorageGetIterator getAIter, @Cached HashingStorageIteratorNext aIterNext, @Cached HashingStorageIteratorKey aIterKey, @Cached HashingStorageIteratorValue aIterValue, @Cached HashingStorageIteratorKeyHash aIterHash, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedLoopConditionProfile earlyExitProfile) {
            if (lenANode.execute(inliningTarget, aStorage) != lenBNode.execute(inliningTarget, bStorage)) {
                return false;
            }
            int index = 0;
            try {
                HashingStorageIterator aIter = getAIter.execute(inliningTarget, aStorage);
                while (loopProfile.profile(inliningTarget, aIterNext.execute(inliningTarget, aStorage, aIter))) {
                    if (CompilerDirectives.hasNextTier()) {
                        ++index;
                    }
                    Object aKey = aIterKey.execute(inliningTarget, aStorage, aIter);
                    long aHash = aIterHash.execute(inliningTarget, aStorage, aIter);
                    Object bValue = getBNode.execute(frame, inliningTarget, bStorage, aKey, aHash);
                    Object aValue = aIterValue.execute(inliningTarget, aStorage, aIter);
                    if (earlyExitProfile.profile(inliningTarget, bValue != null && eqNode.compare(frame, inliningTarget, bValue, aValue))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (index != 0) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)index);
                }
            }
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageIteratorKeyHash
    extends Node {
        public static long executeUncached(HashingStorage storage, HashingStorageIterator it) {
            return HashingStorageNodesFactory.HashingStorageIteratorKeyHashNodeGen.getUncached().execute(null, storage, it);
        }

        public abstract long execute(Node var1, HashingStorage var2, HashingStorageIterator var3);

        @Specialization
        static long economicMap(EconomicMapStorage self, HashingStorageIterator it) {
            return self.map.hashes[it.index];
        }

        @Specialization
        static long dom(DynamicObjectStorage self, HashingStorageIterator it, @Cached.Shared(value="hash") @Cached(inline=false) TruffleString.HashCodeNode hashNode) {
            return PyObjectHashNode.hash((TruffleString)it.domKeys[it.index], hashNode);
        }

        @Specialization
        static long empty(EmptyStorage self, HashingStorageIterator it) {
            throw CompilerDirectives.shouldNotReachHere((String)"empty in HashingStorageIteratorKey");
        }

        @Specialization
        static long keywords(KeywordsStorage self, HashingStorageIterator it, @Cached.Shared(value="hash") @Cached(inline=false) TruffleString.HashCodeNode hashNode) {
            return PyObjectHashNode.hash(self.keywords[it.index].getName(), hashNode);
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageIteratorKey
    extends Node {
        public static Object executeUncached(HashingStorage storage, HashingStorageIterator it) {
            return HashingStorageNodesFactory.HashingStorageIteratorKeyNodeGen.getUncached().execute(null, storage, it);
        }

        public final Object executeCached(HashingStorage storage, HashingStorageIterator it) {
            return this.execute(this, storage, it);
        }

        @NeverDefault
        public static HashingStorageIteratorKey create() {
            return HashingStorageNodesFactory.HashingStorageIteratorKeyNodeGen.create();
        }

        public abstract Object execute(Node var1, HashingStorage var2, HashingStorageIterator var3);

        @Specialization
        static Object economicMap(EconomicMapStorage self, HashingStorageIterator it) {
            return self.map.getKey(it.index);
        }

        @Specialization
        static TruffleString dom(DynamicObjectStorage self, HashingStorageIterator it) {
            return (TruffleString)it.domKeys[it.index];
        }

        @Specialization
        static boolean empty(EmptyStorage self, HashingStorageIterator it) {
            throw CompilerDirectives.shouldNotReachHere((String)"empty in HashingStorageIteratorKey");
        }

        @Specialization
        static Object keywords(KeywordsStorage self, HashingStorageIterator it) {
            return self.keywords[it.index].getName();
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageIteratorValue
    extends Node {
        public static Object executeUncached(HashingStorage storage, HashingStorageIterator it) {
            return HashingStorageNodesFactory.HashingStorageIteratorValueNodeGen.getUncached().execute(null, storage, it);
        }

        public final Object executeCached(HashingStorage storage, HashingStorageIterator it) {
            return this.execute(this, storage, it);
        }

        @NeverDefault
        public static HashingStorageIteratorValue create() {
            return HashingStorageNodesFactory.HashingStorageIteratorValueNodeGen.create();
        }

        public abstract Object execute(Node var1, HashingStorage var2, HashingStorageIterator var3);

        @Specialization
        static Object economicMap(EconomicMapStorage self, HashingStorageIterator it) {
            return it.currentValue;
        }

        @Specialization
        static Object dom(DynamicObjectStorage self, HashingStorageIterator it) {
            return it.currentValue;
        }

        @Specialization
        static boolean empty(EmptyStorage self, HashingStorageIterator it) {
            throw CompilerDirectives.shouldNotReachHere((String)"empty in HashingStorageIteratorValue");
        }

        @Specialization
        static Object keywords(KeywordsStorage self, HashingStorageIterator it) {
            return self.keywords[it.index].getValue();
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageIteratorNext
    extends Node {
        public static boolean executeUncached(HashingStorage storage, HashingStorageIterator it) {
            return HashingStorageNodesFactory.HashingStorageIteratorNextNodeGen.getUncached().execute(null, storage, it);
        }

        public final boolean executeCached(HashingStorage storage, HashingStorageIterator it) {
            return this.execute(this, storage, it);
        }

        @NeverDefault
        public static HashingStorageIteratorNext create() {
            return HashingStorageNodesFactory.HashingStorageIteratorNextNodeGen.create();
        }

        public abstract boolean execute(Node var1, HashingStorage var2, HashingStorageIterator var3);

        @Specialization(guards={"!it.isReverse"})
        static boolean economicMap(EconomicMapStorage self, HashingStorageIterator it) {
            ObjectHashMap map = self.map;
            ++it.index;
            while (it.index < map.usedHashes) {
                Object val = map.getValue(it.index);
                if (val != null) {
                    it.currentValue = val;
                    return true;
                }
                ++it.index;
            }
            if (!$assertionsDisabled) {
                it.currentValue = null;
                if (null != null) {
                    throw new AssertionError();
                }
            }
            return false;
        }

        @Specialization(guards={"it.isReverse"})
        static boolean economicMapReverse(EconomicMapStorage self, HashingStorageIterator it) {
            ObjectHashMap map = self.map;
            --it.index;
            while (it.index >= 0) {
                Object val = map.getValue(it.index);
                if (val != null) {
                    it.currentValue = val;
                    return true;
                }
                --it.index;
            }
            if (!$assertionsDisabled) {
                it.currentValue = null;
                if (null != null) {
                    throw new AssertionError();
                }
            }
            return false;
        }

        @Specialization(guards={"!it.isReverse"})
        static boolean dom(DynamicObjectStorage self, HashingStorageIterator it) {
            ++it.index;
            while (it.index < it.domKeys.length) {
                Object val;
                if (it.domKeys[it.index] instanceof TruffleString && (val = it.dylib.getOrDefault(self.store, it.domKeys[it.index], (Object)PNone.NO_VALUE)) != PNone.NO_VALUE) {
                    it.currentValue = val;
                    return true;
                }
                ++it.index;
            }
            if (!$assertionsDisabled) {
                it.currentValue = null;
                if (null != null) {
                    throw new AssertionError();
                }
            }
            return false;
        }

        @Specialization(guards={"it.isReverse"})
        static boolean domReverse(DynamicObjectStorage self, HashingStorageIterator it) {
            --it.index;
            while (it.index >= 0) {
                Object val;
                if (it.domKeys[it.index] instanceof TruffleString && (val = it.dylib.getOrDefault(self.store, it.domKeys[it.index], (Object)PNone.NO_VALUE)) != PNone.NO_VALUE) {
                    it.currentValue = val;
                    return true;
                }
                --it.index;
            }
            if (!$assertionsDisabled) {
                it.currentValue = null;
                if (null != null) {
                    throw new AssertionError();
                }
            }
            return false;
        }

        @Specialization
        static boolean empty(EmptyStorage self, HashingStorageIterator it) {
            return false;
        }

        @Specialization(guards={"!it.isReverse"})
        static boolean keywords(KeywordsStorage self, HashingStorageIterator it) {
            return ++it.index < self.length();
        }

        @Specialization(guards={"it.isReverse"})
        static boolean keywordsReverse(KeywordsStorage self, HashingStorageIterator it) {
            return --it.index >= 0;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageGetReverseIterator
    extends Node {
        public static HashingStorageIterator executeUncached(HashingStorage storage) {
            return HashingStorageNodesFactory.HashingStorageGetReverseIteratorNodeGen.getUncached().execute(null, storage);
        }

        public final HashingStorageIterator execute(Node node, HashingStorage storage) {
            HashingStorageIterator result = this.executeImpl(node, storage);
            assert (result.isReverse);
            return result;
        }

        abstract HashingStorageIterator executeImpl(Node var1, HashingStorage var2);

        @Specialization
        static HashingStorageIterator economicMap(EconomicMapStorage self) {
            HashingStorageIterator it = new HashingStorageIterator(true);
            it.index = self.map.usedHashes;
            return it;
        }

        @Specialization
        static HashingStorageIterator dom(DynamicObjectStorage self, @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            HashingStorageIterator it = new HashingStorageIterator(dylib.getKeyArray(self.store), dylib, true);
            it.index = it.domKeys.length;
            return it;
        }

        @Specialization
        static HashingStorageIterator empty(EmptyStorage self) {
            return new HashingStorageIterator(true);
        }

        @Specialization
        static HashingStorageIterator keywords(KeywordsStorage self) {
            HashingStorageIterator it = new HashingStorageIterator(true);
            it.index = self.length();
            return it;
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageGetIterator
    extends Node {
        public static HashingStorageIterator executeUncached(HashingStorage storage) {
            return HashingStorageNodesFactory.HashingStorageGetIteratorNodeGen.getUncached().execute(null, storage);
        }

        @NeverDefault
        public static HashingStorageGetIterator create() {
            return HashingStorageNodesFactory.HashingStorageGetIteratorNodeGen.create();
        }

        public final HashingStorageIterator executeCached(HashingStorage storage) {
            return this.execute(this, storage);
        }

        public final HashingStorageIterator execute(Node node, HashingStorage storage) {
            HashingStorageIterator result = this.executeImpl(node, storage);
            assert (!result.isReverse);
            return result;
        }

        public abstract HashingStorageIterator executeImpl(Node var1, HashingStorage var2);

        @Specialization
        static HashingStorageIterator economicMap(EconomicMapStorage self) {
            return new HashingStorageIterator();
        }

        @Specialization
        static HashingStorageIterator dom(DynamicObjectStorage self, @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            return new HashingStorageIterator(dylib.getKeyArray(self.store), dylib, false);
        }

        @Specialization
        static HashingStorageIterator empty(EmptyStorage self) {
            return new HashingStorageIterator();
        }

        @Specialization
        static HashingStorageIterator keywords(KeywordsStorage self) {
            return new HashingStorageIterator();
        }
    }

    @CompilerDirectives.ValueType
    public static final class HashingStorageIterator {
        int index = -1;
        Object currentValue;
        final Object[] domKeys;
        final DynamicObjectLibrary dylib;
        final boolean isReverse;

        public HashingStorageIterator() {
            this.domKeys = null;
            this.dylib = null;
            this.isReverse = false;
        }

        public HashingStorageIterator(boolean isReverse) {
            this.domKeys = null;
            this.dylib = null;
            this.isReverse = isReverse;
        }

        public HashingStorageIterator(Object[] domKeys, DynamicObjectLibrary dylib, boolean isReverse) {
            this.domKeys = domKeys;
            this.dylib = dylib;
            this.isReverse = isReverse;
        }

        public int getState() {
            return this.index;
        }

        public void setState(int state) {
            this.index = state;
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class HashingStorageCopy
    extends Node {
        @NeverDefault
        public static HashingStorageCopy create() {
            return HashingStorageNodesFactory.HashingStorageCopyNodeGen.create();
        }

        public static HashingStorage executeUncached(HashingStorage source) {
            return HashingStorageNodesFactory.HashingStorageCopyNodeGen.getUncached().execute(null, source);
        }

        public final HashingStorage executeCached(HashingStorage source) {
            return this.execute(this, source);
        }

        public abstract HashingStorage execute(Node var1, HashingStorage var2);

        @Specialization
        static HashingStorage economic(EconomicMapStorage map) {
            return map.copy();
        }

        @Specialization
        static EmptyStorage empty(EmptyStorage map) {
            return EmptyStorage.INSTANCE;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static DynamicObjectStorage dom(Node inliningTarget, DynamicObjectStorage dom, @Cached DynamicObjectStorage.Copy copyNode) {
            return copyNode.execute(inliningTarget, dom);
        }

        @Specialization
        static HashingStorage keywords(KeywordsStorage self) {
            return self.copy();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HashingStorageClear
    extends Node {
        public abstract HashingStorage execute(Node var1, HashingStorage var2);

        @Specialization
        static HashingStorage economicMap(EconomicMapStorage self) {
            self.clear();
            return self;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage dom(Node inliningTarget, DynamicObjectStorage self, @Cached DynamicObjectStorage.ClearNode clearNode) {
            clearNode.execute(inliningTarget, self);
            return self;
        }

        @Fallback
        static HashingStorage empty(HashingStorage self) {
            return EmptyStorage.INSTANCE;
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class HashingStorageLen
    extends Node {
        public static int executeUncached(HashingStorage dictStorage) {
            return HashingStorageNodesFactory.HashingStorageLenNodeGen.getUncached().execute(null, dictStorage);
        }

        public final int executeCached(HashingStorage storage) {
            return this.execute(this, storage);
        }

        @NeverDefault
        public static HashingStorageLen create() {
            return HashingStorageNodesFactory.HashingStorageLenNodeGen.create();
        }

        public abstract int execute(Node var1, HashingStorage var2);

        @Specialization
        static int economicMap(EconomicMapStorage self) {
            return self.length();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static int dom(Node inliningTarget, DynamicObjectStorage self, @Cached(inline=false) DynamicObjectStorage.LengthNode lengthNode) {
            return lengthNode.execute(self);
        }

        @Specialization
        static int empty(EmptyStorage self) {
            return 0;
        }

        @Specialization
        static int keywords(KeywordsStorage self) {
            return self.length();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageDelItem
    extends Node {
        public static void executeUncached(HashingStorage self, Object key, PHashingCollection toUpdate) {
            HashingStorageNodesFactory.HashingStorageDelItemNodeGen.getUncached().executeWithAsserts(null, null, self, key, false, toUpdate);
        }

        public static void executeUncachedWithHash(EconomicMapStorage storage, Object key, long hash) {
            ObjectHashMapFactory.RemoveNodeGen.getUncached().execute(null, null, storage.map, key, hash);
        }

        public final void execute(Node inliningTarget, HashingStorage self, TruffleString key, PHashingCollection toUpdate) {
            this.executeWithAsserts(null, inliningTarget, self, key, false, toUpdate);
        }

        public final void execute(Frame frame, Node inliningTarget, HashingStorage self, Object key, PHashingCollection toUpdate) {
            this.executeWithAsserts(frame, inliningTarget, self, key, false, toUpdate);
        }

        public final Object executePop(Node inliningTarget, HashingStorage self, TruffleString key, PHashingCollection toUpdate) {
            return this.executeWithAsserts(null, inliningTarget, self, key, true, toUpdate);
        }

        public final Object executePop(Frame frame, Node inliningTarget, HashingStorage self, Object key, PHashingCollection toUpdate) {
            return this.executeWithAsserts(frame, inliningTarget, self, key, true, toUpdate);
        }

        final Object executeWithAsserts(Frame frame, Node inliningTarget, HashingStorage self, Object key, boolean isPop, PHashingCollection toUpdate) {
            assert (toUpdate != null);
            CompilerAsserts.partialEvaluationConstant((boolean)isPop);
            return this.executeImpl(frame, inliningTarget, self, key, isPop, toUpdate);
        }

        abstract Object executeImpl(Frame var1, Node var2, HashingStorage var3, Object var4, boolean var5, PHashingCollection var6);

        @Specialization(guards={"isEconomicMapOrEmpty(self)"})
        static Object economicMap(Frame frame, Node inliningTarget, HashingStorage self, Object key, boolean isPop, PHashingCollection toUpdate, @Cached.Exclusive @Cached InlinedBranchProfile isEconomicMapProfile, @Cached.Exclusive @Cached PyObjectHashNode hashNode, @Cached.Exclusive @Cached ObjectHashMap.RemoveNode removeNode2) {
            long hash = hashNode.execute(frame, inliningTarget, key);
            if (self instanceof EconomicMapStorage) {
                EconomicMapStorage economicMap = (EconomicMapStorage)self;
                isEconomicMapProfile.enter(inliningTarget);
                Object result = removeNode2.execute(frame, inliningTarget, economicMap.map, key, hash);
                return isPop ? result : null;
            }
            return null;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object domStringKey(Frame frame, Node inliningTarget, DynamicObjectStorage self, Object keyObj, boolean isPop, PHashingCollection toUpdate, @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached CastBuiltinStringToTruffleStringNode castStr, @Cached.Exclusive @Cached PyObjectHashNode hashNode, @Cached.Exclusive @Cached InlinedBranchProfile invalidateMroProfile, @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            if (!isBuiltinString.execute(inliningTarget, keyObj)) {
                hashNode.execute(frame, inliningTarget, keyObj);
                return null;
            }
            TruffleString key = castStr.execute(inliningTarget, keyObj);
            DynamicObject store = self.store;
            if (isPop) {
                Object val = dylib.getOrDefault(store, (Object)key, (Object)PNone.NO_VALUE);
                if (val == PNone.NO_VALUE) {
                    return null;
                }
                dylib.put(store, (Object)key, (Object)PNone.NO_VALUE);
                self.invalidateAttributeInMROFinalAssumption(key, inliningTarget, invalidateMroProfile);
                return val;
            }
            if (dylib.putIfPresent(store, (Object)key, (Object)PNone.NO_VALUE)) {
                self.invalidateAttributeInMROFinalAssumption(key, inliningTarget, invalidateMroProfile);
            }
            return null;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object keywords(Frame frame, Node inliningTarget, KeywordsStorage self, Object key, boolean isPop, PHashingCollection toUpdate, @Cached.Exclusive @Cached PyObjectHashNode hashNode, @Cached.Exclusive @Cached ObjectHashMap.RemoveNode removeNode2, @Cached EconomicMapStorage.EconomicMapSetStringKey specializedPutNode) {
            EconomicMapStorage newStorage = EconomicMapStorage.create(self.length());
            self.addAllTo(inliningTarget, newStorage, specializedPutNode);
            toUpdate.setDictStorage(newStorage);
            Object result = removeNode2.execute(frame, inliningTarget, newStorage.map, key, hashNode.execute(frame, inliningTarget, key));
            return isPop ? result : null;
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageSetItem
    extends Node {
        @NeverDefault
        public static HashingStorageSetItem create() {
            return HashingStorageNodesFactory.HashingStorageSetItemNodeGen.create();
        }

        public static HashingStorage executeUncached(HashingStorage storage, Object key, Object value) {
            return HashingStorageNodesFactory.HashingStorageSetItemNodeGen.getUncached().execute(null, null, storage, key, value);
        }

        public final HashingStorage executeCached(Frame frame, HashingStorage storage, Object key, Object value) {
            return this.execute(frame, this, storage, key, value);
        }

        public final HashingStorage execute(Node inliningTarget, HashingStorage self, TruffleString key, Object value) {
            return this.execute(null, inliningTarget, self, key, value);
        }

        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, Object var4, Object var5);

        @Specialization
        static HashingStorage economicMap(Frame frame, Node inliningTarget, EconomicMapStorage self, Object key, Object value, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Exclusive @Cached PyObjectHashNode hashNode, @Cached.Exclusive @Cached ObjectHashMap.PutNode putNode) {
            putNode.execute(frame, inliningTarget, self.map, key, hashNode.execute(frame, inliningTarget, key), value);
            if (!self.map.hasSideEffect() && !isBuiltinString.execute(inliningTarget, key)) {
                self.map.setSideEffectingKeysFlag();
            }
            return self;
        }

        @Specialization
        static HashingStorage empty(Frame frame, Node inliningTarget, EmptyStorage self, Object key, Object value, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Exclusive @Cached PyObjectHashNode hashNode, @Cached.Exclusive @Cached ObjectHashMap.PutNode putNode) {
            return HashingStorageSetItem.economicMap(frame, inliningTarget, EconomicMapStorage.create(1), key, value, isBuiltinString, hashNode, putNode);
        }

        @Specialization(guards={"!self.shouldTransitionOnPut()"})
        static HashingStorage domStringKey(Node inliningTarget, DynamicObjectStorage self, TruffleString key, Object value, @Cached InlinedBranchProfile invalidateMroProfile, @Cached.Shared @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            self.setStringKey(key, value, dylib, inliningTarget, invalidateMroProfile);
            return self;
        }

        @Specialization(replaces={"domStringKey"})
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage dom(Frame frame, Node inliningTarget, DynamicObjectStorage self, Object key, Object value, @Cached InlinedConditionProfile shouldTransitionProfile, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Shared @CachedLibrary(limit="3") DynamicObjectLibrary dylib, @Cached DOMStorageSetItem domNode) {
            boolean transition = true;
            if (shouldTransitionProfile.profile(inliningTarget, !self.shouldTransitionOnPut()) && isBuiltinString.execute(inliningTarget, key)) {
                transition = false;
            }
            return domNode.execute(frame, inliningTarget, self, key, value, transition, dylib);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage keywords(Frame frame, Node inliningTarget, KeywordsStorage self, Object key, Object value, @Cached.Exclusive @Cached PyObjectHashNode hashNode, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Exclusive @Cached ObjectHashMap.PutNode putNode, @Cached EconomicMapStorage.EconomicMapSetStringKey specializedPutNode) {
            EconomicMapStorage result = EconomicMapStorage.create(self.length());
            self.addAllTo(inliningTarget, result, specializedPutNode);
            return HashingStorageSetItem.economicMap(frame, inliningTarget, result, key, value, isBuiltinString, hashNode, putNode);
        }

        @GenerateUncached
        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={PGuards.class})
        static abstract class DOMStorageSetItem
        extends Node {
            DOMStorageSetItem() {
            }

            public abstract HashingStorage execute(Frame var1, Node var2, DynamicObjectStorage var3, Object var4, Object var5, boolean var6, DynamicObjectLibrary var7);

            @Specialization(guards={"!transition", "isBuiltinString.execute(inliningTarget, key)"}, limit="1")
            static HashingStorage domStringKey(Node inliningTarget, DynamicObjectStorage self, Object key, Object value, boolean transition, DynamicObjectLibrary dylib, @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached CastBuiltinStringToTruffleStringNode castStr, @Cached InlinedBranchProfile invalidateMroProfile) {
                self.setStringKey(castStr.execute(inliningTarget, key), value, dylib, inliningTarget, invalidateMroProfile);
                return self;
            }

            @Fallback
            static HashingStorage domTransition(Frame frame, Node inliningTarget, DynamicObjectStorage self, Object key, Object value, boolean transition, DynamicObjectLibrary dylib, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.PutNode putNode) {
                EconomicMapStorage result = HashingStorageNodes.dynamicObjectStorageToEconomicMap(inliningTarget, self, dylib, hashNode, putNode);
                putNode.execute(frame, inliningTarget, result.map, key, hashNode.execute(frame, inliningTarget, key), value);
                return result;
            }
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageSetItemWithHash
    extends Node {
        @NeverDefault
        public static HashingStorageSetItemWithHash create() {
            return HashingStorageNodesFactory.HashingStorageSetItemWithHashNodeGen.create();
        }

        public abstract HashingStorage execute(Frame var1, Node var2, HashingStorage var3, Object var4, long var5, Object var7);

        public final HashingStorage executeCached(Frame frame, HashingStorage self, Object key, long keyHash, Object value) {
            return this.execute(frame, this, self, key, keyHash, value);
        }

        @Specialization
        static HashingStorage economicMap(Frame frame, Node inliningTarget, EconomicMapStorage self, Object key, long keyHash, Object value, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Exclusive @Cached ObjectHashMap.PutNode putNode) {
            putNode.execute(frame, inliningTarget, self.map, key, keyHash, value);
            if (!self.map.hasSideEffect() && !isBuiltinString.execute(inliningTarget, key)) {
                self.map.setSideEffectingKeysFlag();
            }
            return self;
        }

        @Specialization
        static HashingStorage empty(Frame frame, Node inliningTarget, EmptyStorage self, Object key, long keyHash, Object value, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Exclusive @Cached ObjectHashMap.PutNode putNode) {
            EconomicMapStorage storage = EconomicMapStorage.create(1);
            putNode.execute(frame, inliningTarget, storage.map, key, keyHash, value);
            if (!isBuiltinString.execute(inliningTarget, key)) {
                storage.map.setSideEffectingKeysFlag();
            }
            return storage;
        }

        @Specialization(guards={"!self.shouldTransitionOnPut()"})
        static HashingStorage domStringKey(Node inliningTarget, DynamicObjectStorage self, TruffleString key, long keyHash, Object value, @Cached InlinedBranchProfile invalidateMroProfile, @Cached.Shared @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            self.setStringKey(key, value, dylib, inliningTarget, invalidateMroProfile);
            return self;
        }

        @Specialization(replaces={"domStringKey"})
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage dom(Frame frame, Node inliningTarget, DynamicObjectStorage self, Object key, long keyHash, Object value, @Cached InlinedConditionProfile shouldTransitionProfile, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Shared @CachedLibrary(limit="3") DynamicObjectLibrary dylib, @Cached DOMStorageSetItemWithHash domNode) {
            boolean transition = true;
            if (shouldTransitionProfile.profile(inliningTarget, !self.shouldTransitionOnPut()) && isBuiltinString.execute(inliningTarget, key)) {
                transition = false;
            }
            return domNode.execute(frame, inliningTarget, self, key, keyHash, value, transition, dylib);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage keywords(Frame frame, Node inliningTarget, KeywordsStorage self, Object key, long keyHash, Object value, @Cached.Exclusive @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached.Exclusive @Cached ObjectHashMap.PutNode putNode, @Cached EconomicMapStorage.EconomicMapSetStringKey specializedPutNode) {
            EconomicMapStorage result = EconomicMapStorage.create(self.length());
            self.addAllTo(inliningTarget, result, specializedPutNode);
            return HashingStorageSetItemWithHash.economicMap(frame, inliningTarget, result, key, keyHash, value, isBuiltinString, putNode);
        }

        @GenerateUncached
        @GenerateInline
        @GenerateCached(value=false)
        @ImportStatic(value={PGuards.class})
        static abstract class DOMStorageSetItemWithHash
        extends Node {
            DOMStorageSetItemWithHash() {
            }

            public abstract HashingStorage execute(Frame var1, Node var2, DynamicObjectStorage var3, Object var4, long var5, Object var7, boolean var8, DynamicObjectLibrary var9);

            @Specialization(guards={"!transition", "isBuiltinString.execute(inliningTarget, key)"}, limit="1")
            static HashingStorage domStringKey(Node inliningTarget, DynamicObjectStorage self, Object key, long keyHash, Object value, boolean transition, DynamicObjectLibrary dylib, @Cached PyUnicodeCheckExactNode isBuiltinString, @Cached CastBuiltinStringToTruffleStringNode castStr, @Cached InlinedBranchProfile invalidateMroProfile) {
                self.setStringKey(castStr.execute(inliningTarget, key), value, dylib, inliningTarget, invalidateMroProfile);
                return self;
            }

            @Fallback
            static HashingStorage domTransition(Frame frame, Node inliningTarget, DynamicObjectStorage self, Object key, long keyHash, Object value, boolean transition, DynamicObjectLibrary dylib, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.PutNode putNode) {
                EconomicMapStorage result = HashingStorageNodes.dynamicObjectStorageToEconomicMap(inliningTarget, self, dylib, hashNode, putNode);
                putNode.execute(frame, inliningTarget, result.map, key, keyHash, value);
                return result;
            }
        }
    }

    static abstract class SpecializedSetStringKey
    extends Node {
        SpecializedSetStringKey() {
        }

        public abstract void execute(Node var1, HashingStorage var2, TruffleString var3, Object var4);
    }

    @GenerateInline(value=false)
    public static abstract class CachedHashingStorageGetItem
    extends Node {
        public abstract Object execute(Frame var1, HashingStorage var2, Object var3);

        @Specialization
        Object doIt(Frame frame, HashingStorage s, Object k, @Cached HashingStorageGetItem getItem) {
            return getItem.execute(frame, this, s, k);
        }

        @NeverDefault
        public static CachedHashingStorageGetItem create() {
            return HashingStorageNodesFactory.CachedHashingStorageGetItemNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HashingStorageGetItem
    extends Node {
        public static boolean hasKeyUncached(HashingStorage storage, Object key) {
            return HashingStorageNodesFactory.HashingStorageGetItemNodeGen.getUncached().execute(null, null, storage, key) != null;
        }

        public final boolean hasKey(Node inliningTarget, HashingStorage self, TruffleString key) {
            return this.execute(null, inliningTarget, self, key) != null;
        }

        public final boolean hasKey(Frame frame, Node inliningTarget, HashingStorage self, Object key) {
            return this.execute(frame, inliningTarget, self, key) != null;
        }

        public static Object executeUncached(HashingStorage storage, Object key) {
            return HashingStorageNodesFactory.HashingStorageGetItemNodeGen.getUncached().execute(null, null, storage, key);
        }

        public final Object execute(Node inliningTarget, HashingStorage self, TruffleString key) {
            return this.execute(null, inliningTarget, self, key);
        }

        public final Object execute(Node inliningTarget, HashingStorage self, HiddenKey key) {
            return this.execute(null, inliningTarget, self, key);
        }

        public abstract Object execute(Frame var1, Node var2, HashingStorage var3, Object var4);

        @Specialization(guards={"isEconomicMapOrEmpty(self)"})
        static Object economicMap(Frame frame, Node inliningTarget, HashingStorage self, Object key, @Cached PyObjectHashNode hashNode, @Cached InlinedConditionProfile isEconomicMapProfile, @Cached ObjectHashMap.GetNode getNode) {
            long hash = hashNode.execute(frame, inliningTarget, key);
            if (isEconomicMapProfile.profile(inliningTarget, self instanceof EconomicMapStorage)) {
                return getNode.execute(frame, inliningTarget, ((EconomicMapStorage)self).map, key, hash);
            }
            return null;
        }

        @Specialization
        static Object dom(Frame frame, Node inliningTarget, DynamicObjectStorage self, Object key, @Cached DynamicObjectStorage.GetItemNode getNode) {
            return getNode.execute(frame, inliningTarget, self, key, -1L);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object keywords(Frame frame, Node inliningTarget, KeywordsStorage self, Object key, @Cached KeywordsStorage.GetKeywordsStorageItemNode getNode) {
            return getNode.execute(frame, inliningTarget, self, key, -1L);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HashingStorageGetItemWithHash
    extends Node {
        public static Object getItemWithHash(HashingStorage self, Object key, long keyHash) {
            return HashingStorageNodesFactory.HashingStorageGetItemWithHashNodeGen.getUncached().execute(null, null, self, key, keyHash);
        }

        public abstract Object execute(Frame var1, Node var2, HashingStorage var3, Object var4, long var5);

        @Specialization
        static Object economicMap(Frame frame, Node inliningTarget, EconomicMapStorage self, Object key, long keyHash, @Cached ObjectHashMap.GetNode getNode) {
            return getNode.execute(frame, inliningTarget, self.map, key, keyHash);
        }

        @Specialization
        static Object dom(Frame frame, Node inliningTarget, DynamicObjectStorage self, Object key, long keyHash, @Cached DynamicObjectStorage.GetItemNode getNode) {
            return getNode.execute(frame, inliningTarget, self, key, keyHash);
        }

        @Specialization
        static Object empty(Frame frame, EmptyStorage self, Object key, long keyHash) {
            return null;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object keywords(Frame frame, Node inliningTarget, KeywordsStorage self, Object key, long keyHash, @Cached KeywordsStorage.GetKeywordsStorageItemNode getNode) {
            return getNode.execute(frame, inliningTarget, self, key, keyHash);
        }
    }

    public static abstract class HashingStorageGuards {
        private HashingStorageGuards() {
        }

        public static boolean mayHaveSideEffectingEq(PHashingCollection wrapper) {
            return wrapper.getDictStorage() instanceof EconomicMapStorage;
        }

        public static boolean mayHaveSideEffects(PHashingCollection wrapper) {
            HashingStorage s = wrapper.getDictStorage();
            return !(s instanceof EconomicMapStorage) || !((EconomicMapStorage)s).map.hasSideEffect();
        }
    }
}

