/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.UnicodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.UnicodeTranslateErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.UnicodeTranslateError})
public final class UnicodeTranslateErrorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnicodeTranslateErrorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class UnicodeTranslateErrorStrNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        TruffleString str(VirtualFrame frame, PBaseException self, @Bind(value="this") Node inliningTarget, @Cached BaseExceptionAttrNode attrNode, @Cached CastToTruffleStringNode toStringNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            if (self.getExceptionAttributes() == null) {
                return StringLiterals.T_EMPTY_STRING;
            }
            TruffleString object = toStringNode.execute(inliningTarget, attrNode.get(self, 1, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY));
            int start = attrNode.getInt(self, 2, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            int end = attrNode.getInt(self, 3, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            TruffleString reason = strNode.execute((Frame)frame, inliningTarget, attrNode.get(self, 4, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY));
            if (start < codePointLengthNode.execute((AbstractTruffleString)object, PythonUtils.TS_ENCODING) && end == start + 1) {
                int badChar = codePointAtIndexNode.execute((AbstractTruffleString)object, start, PythonUtils.TS_ENCODING);
                String badCharStr = badChar <= 255 ? PythonUtils.formatJString("\\x%02x", badChar) : (badChar <= 65535 ? PythonUtils.formatJString("\\u%04x", badChar) : PythonUtils.formatJString("\\U%08x", badChar));
                return simpleTruffleStringFormatNode.format("can't translate character '%s' in position %d: %s", badCharStr, start, reason);
            }
            return simpleTruffleStringFormatNode.format("can't translate characters in position %d-%d: %s", start, end - 1, reason);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class UnicodeTranslateErrorInitNode
    extends PythonBuiltinNode {
        public abstract Object execute(PBaseException var1, Object[] var2);

        @Specialization
        static Object initNoArgs(PBaseException self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode toStringNode, @Cached CastToJavaIntExactNode toJavaIntExactNode, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseInitNode, @Cached PRaiseNode.Lazy raiseNode) {
            baseInitNode.execute(self, args);
            self.setExceptionAttributes(new Object[]{null, UnicodeErrorBuiltins.getArgAsString(inliningTarget, args, 0, raiseNode, toStringNode), UnicodeErrorBuiltins.getArgAsInt(inliningTarget, args, 1, raiseNode, toJavaIntExactNode), UnicodeErrorBuiltins.getArgAsInt(inliningTarget, args, 2, raiseNode, toJavaIntExactNode), UnicodeErrorBuiltins.getArgAsString(inliningTarget, args, 3, raiseNode, toStringNode)});
            return PNone.NONE;
        }
    }
}

