/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.getsetdescriptor;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.MemberDescriptorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MemberDescriptor})
public final class MemberDescriptorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MemberDescriptorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__delete__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetSetDeleteNode
    extends PythonBinaryBuiltinNode {
        GetSetDeleteNode() {
        }

        @Specialization
        static Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, @Bind(value="this") Node inliningTarget, @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrDeleteNode deleteNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            return deleteNode.execute(frame, descr, obj);
        }
    }

    @Builtin(name="__set__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class MemberSetNode
    extends PythonTernaryBuiltinNode {
        MemberSetNode() {
        }

        @Specialization
        static Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object value, @Bind(value="this") Node inliningTarget, @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrSetNode setNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            return setNode.execute(frame, descr, obj, value);
        }
    }

    @Builtin(name="__get__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class MemberGetNode
    extends PythonTernaryBuiltinNode {
        MemberGetNode() {
        }

        @Specialization(guards={"isNone(obj)", "!isPNone(type)"})
        static Object doNone(Object descr, PNone obj, Object type) {
            return descr;
        }

        @Specialization(guards={"isNone(obj)"})
        static Object doNoneNone(Object descr, PNone obj, PNone type, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.GET_NONE_NONE_IS_INVALID);
        }

        @Specialization(guards={"!isNone(obj)"})
        static Object doGetSetDescriptor(VirtualFrame frame, GetSetDescriptor descr, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached DescriptorBuiltins.DescriptorCheckNode descriptorCheckNode, @Cached DescriptorBuiltins.DescrGetNode getNode) {
            descriptorCheckNode.execute(inliningTarget, descr.getType(), descr.getName(), obj);
            return getNode.execute(frame, descr, obj);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class MemberDescriptorReduceNode
    extends PythonUnaryBuiltinNode {
        MemberDescriptorReduceNode() {
        }

        @Specialization
        Object doGeneric(GetSetDescriptor descr, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached ObjectNodes.GetIdNode getIdNode, @Cached PythonObjectFactory factory) {
            Object getattr = readAttributeFromObjectNode.execute(this.getContext().getBuiltins(), BuiltinNames.T_GETATTR);
            Object id = getIdNode.execute(getattr);
            return factory.createTuple(new Object[]{id, factory.createTuple(new Object[]{descr.getType(), descr.getName()})});
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class MemberDescriptorReprNode
    extends PythonUnaryBuiltinNode {
        MemberDescriptorReprNode() {
        }

        @Specialization
        static TruffleString repr(GetSetDescriptor descr, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetNameNode getName, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<member '%s' of '%s' objects>", descr.getName(), getName.execute(inliningTarget, descr.getType()));
        }
    }
}

