/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.PRepeat;
import com.oracle.graal.python.builtins.objects.itertools.RepeatBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PRepeat})
public final class RepeatBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return RepeatBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getCnt() >= 0"})
        static TruffleString reprPos(VirtualFrame frame, PRepeat self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClass") @Cached GetClassNode getClass, @Cached.Shared(value="getAttr") @Cached PyObjectGetAttr getAttrNode, @Cached.Shared(value="repr") @Cached PyObjectReprAsObjectNode reprNode, @Cached.Shared(value="castToTruffleString") @Cached CastToTruffleStringNode castNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object type = getClass.execute(inliningTarget, self);
            return simpleTruffleStringFormatNode.format("%s(%s, %d)", castNode.execute(inliningTarget, getAttrNode.execute((Frame)frame, inliningTarget, type, SpecialAttributeNames.T___NAME__)), castNode.execute(inliningTarget, reprNode.execute((Frame)frame, inliningTarget, self.getElement())), self.getCnt());
        }

        @Specialization(guards={"self.getCnt() < 0"})
        static TruffleString reprNeg(VirtualFrame frame, PRepeat self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClass") @Cached GetClassNode getClass, @Cached.Shared(value="getAttr") @Cached PyObjectGetAttr getAttrNode, @Cached.Shared(value="repr") @Cached PyObjectReprAsObjectNode reprNode, @Cached.Shared(value="castToTruffleString") @Cached CastToTruffleStringNode castNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object type = getClass.execute(inliningTarget, self);
            return simpleTruffleStringFormatNode.format("%s(%s)", castNode.execute(inliningTarget, getAttrNode.execute((Frame)frame, inliningTarget, type, SpecialAttributeNames.T___NAME__)), castNode.execute(inliningTarget, reprNode.execute((Frame)frame, inliningTarget, self.getElement())));
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PRepeat self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile negativeCountProfile, @Cached GetClassNode getClass, @Cached PythonObjectFactory factory) {
            Object type = getClass.execute(inliningTarget, self);
            Object[] tupleElements = negativeCountProfile.profile(inliningTarget, self.getCnt() < 0) ? new Object[]{self.getElement()} : new Object[]{self.getElement(), self.getCnt()};
            PTuple tuple = factory.createTuple(tupleElements);
            return factory.createTuple(new Object[]{type, tuple});
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getCnt() >= 0"})
        static Object hintPos(PRepeat self) {
            return self.getCnt();
        }

        @Specialization(guards={"self.getCnt() < 0"})
        static Object hintNeg(PRepeat self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.LEN_OF_UNSIZED_OBJECT);
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getCnt() > 0"})
        static Object nextPos(PRepeat self) {
            self.setCnt(self.getCnt() - 1);
            return self.getElement();
        }

        @Specialization(guards={"self.getCnt() == 0"})
        static Object nextZero(PRepeat self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseStopIteration();
        }

        @Specialization(guards={"self.getCnt() < 0"})
        static Object nextNeg(PRepeat self) {
            return self.getElement();
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PRepeat self) {
            return self;
        }
    }
}

