/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.list;

import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class)
public final class PList
extends PSequence {
    private final ListOrigin origin;
    private SequenceStorage store;

    public PList(Object cls, Shape instanceShape, SequenceStorage store) {
        super(cls, instanceShape);
        this.origin = null;
        this.store = store;
    }

    public PList(Object cls, Shape instanceShape, SequenceStorage store, ListOrigin origin) {
        super(cls, instanceShape);
        this.origin = origin;
        this.store = store;
    }

    @Override
    public final SequenceStorage getSequenceStorage() {
        return this.store;
    }

    @Override
    public final void setSequenceStorage(SequenceStorage newStorage) {
        this.store = newStorage;
    }

    @Override
    public final String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return this.store.toString();
    }

    public final void reverse() {
        this.store.reverse();
    }

    @ExportMessage.Ignore
    public final boolean equals(Object other) {
        if (!(other instanceof PList)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PList otherList = (PList)other;
        SequenceStorage otherStore = otherList.getSequenceStorage();
        return this.store.equals(otherStore);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public ListOrigin getOrigin() {
        return this.origin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public SourceSection getSourceLocation(@Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            ListOrigin node = this.getOrigin();
            SourceSection result = null;
            if (node != null) {
                result = node.getSourceSection();
            }
            if (result == null) {
                throw UnsupportedMessageException.create();
            }
            SourceSection sourceSection = result;
            return sourceSection;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return this.getOrigin() != null && this.getOrigin().getSourceSection() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementModifiable(long index, @Cached.Exclusive @Cached IndexNodes.NormalizeIndexCustomMessageNode normalize, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            try {
                normalize.execute(index, len, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            catch (PException e) {
                boolean bl = false;
                gil.release(mustRelease);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementInsertable(long index, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            boolean bl = index == (long)len;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementRemovable(long index, @Cached.Exclusive @Cached IndexNodes.NormalizeIndexCustomMessageNode normalize, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            try {
                normalize.execute(index, len, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            catch (PException e) {
                boolean bl = false;
                gil.release(mustRelease);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void writeArrayElement(long index, Object value, @Bind(value="$node") Node inliningTarget, @Cached PForeignToPTypeNode convert, @Cached.Exclusive @Cached SequenceStorageNodes.SetItemScalarNode setItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                setItem.execute(inliningTarget, this.store, PInt.intValueExact(index), convert.executeConvert(value));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeArrayElement(long index, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.DeleteItemNode delItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                delItem.execute(inliningTarget, this.store, PInt.intValueExact(index));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    public static interface ListOrigin {
        public void reportUpdatedCapacity(BasicSequenceStorage var1);

        public SourceSection getSourceSection();

        @CompilerDirectives.ValueType
        public static final class SizeEstimate {
            private static final int NUM_DIGITS = 3;
            private static final int NUM_DIGITS_POW2 = 8;
            @CompilerDirectives.CompilationFinal
            private int shiftedStorageSizeEstimate;

            public SizeEstimate(int storageSizeEstimate) {
                assert (storageSizeEstimate >= 0);
                this.shiftedStorageSizeEstimate = storageSizeEstimate * 8;
            }

            public int estimate() {
                return this.shiftedStorageSizeEstimate >> 3;
            }

            public int updateFrom(int newSizeEstimate) {
                int newValue = this.shiftedStorageSizeEstimate + newSizeEstimate - this.estimate();
                this.shiftedStorageSizeEstimate = Math.max(newValue, 0);
                return this.shiftedStorageSizeEstimate;
            }
        }
    }
}

