/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.memoryview;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.BufferStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.memoryview.BufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodesFactory;
import com.oracle.graal.python.builtins.objects.memoryview.NativeBufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public class MemoryViewNodes {
    static boolean isByteFormat(BufferFormat format) {
        return format == BufferFormat.UINT_8 || format == BufferFormat.INT_8 || format == BufferFormat.CHAR;
    }

    static void checkBufferBounds(Node node, PMemoryView self, PythonBufferAccessLibrary bufferLib, int offset, int length) {
        if (offset + length > bufferLib.getBufferLength(self.getBuffer())) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.IndexError, ErrorMessages.INVALID_BUFFER_ACCESS);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReleaseBufferNode
    extends Node {
        public abstract void execute(Node var1, BufferLifecycleManager var2);

        public static void executeUncached(BufferLifecycleManager buffer) {
            MemoryViewNodesFactory.ReleaseBufferNodeGen.getUncached().execute(null, buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute(VirtualFrame frame, Node inliningTarget, IndirectCallData indirectCallData, BufferLifecycleManager buffer) {
            Object state = ExecutionContext.IndirectCallContext.enter(frame, indirectCallData);
            try {
                this.execute(inliningTarget, buffer);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, indirectCallData, state);
            }
        }

        @Specialization
        static void doCApiCached(NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromType buffer, @Cached(inline=false) CExtNodes.PCallCapiFunction callReleaseNode) {
            callReleaseNode.call(NativeCAPISymbol.FUN_PY_TRUFFLE_RELEASE_BUFFER, buffer.bufferStructPointer);
        }

        @Specialization
        static void doCExtBuffer(NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromSlot buffer, @Cached(inline=false) CallNode callNode) {
            callNode.execute(buffer.releaseFunction, buffer.self, buffer.buffer);
        }

        @Fallback
        static void doManaged(BufferLifecycleManager buffer) {
        }
    }

    @GenerateInline(value=false)
    public static abstract class ReleaseNode
    extends Node {
        public final void execute(PMemoryView self) {
            this.execute(null, self);
        }

        public abstract void execute(VirtualFrame var1, PMemoryView var2);

        @Specialization(guards={"self.getReference() == null"})
        static void releaseSimple(PMemoryView self, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
            self.checkExports(raiseNode);
            self.setReleased();
        }

        @Specialization(guards={"self.getReference() != null"})
        static void releaseNative(VirtualFrame frame, PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached ReleaseBufferNode releaseNode, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
            self.checkExports(raiseNode);
            if (self.checkShouldReleaseBuffer()) {
                releaseNode.execute(frame, inliningTarget, indirectCallData, self.getLifecycleManager());
            }
            self.setReleased();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ToJavaBytesFortranOrderNode
    extends ToJavaBytesNode {
        @Override
        protected void convert(Node inliningTarget, byte[] dest, PMemoryView self, int ndim, ReadBytesAtNode readBytesAtNode, CExtNodes.PCallCapiFunction callCapiFunction) {
            ToJavaBytesFortranOrderNode.recursive(inliningTarget, dest, 0, self.getItemSize(), self, 0, ndim, self.getBufferPointer(), self.getOffset(), readBytesAtNode, callCapiFunction);
        }

        private static void recursive(Node inliningTarget, byte[] dest, int initialDestOffset, int destStride, PMemoryView self, int dim, int ndim, Object ptr, int initialOffset, ReadBytesAtNode readBytesAtNode, CExtNodes.PCallCapiFunction callCapiFunction) {
            int offset = initialOffset;
            int destOffset = initialDestOffset;
            for (int i = 0; i < self.getBufferShape()[dim]; ++i) {
                Object xptr = ptr;
                int xoffset = offset;
                if (self.getBufferSuboffsets() != null && self.getBufferSuboffsets()[dim] >= 0) {
                    xptr = callCapiFunction.call(NativeCAPISymbol.FUN_TRUFFLE_ADD_SUBOFFSET, ptr, offset, self.getBufferSuboffsets()[dim]);
                    xoffset = 0;
                }
                if (dim == ndim - 1) {
                    readBytesAtNode.execute(inliningTarget, dest, destOffset, self.getItemSize(), self, xptr, xoffset);
                } else {
                    ToJavaBytesFortranOrderNode.recursive(inliningTarget, dest, destOffset, destStride * self.getBufferShape()[dim], self, dim + 1, ndim, xptr, xoffset, readBytesAtNode, callCapiFunction);
                }
                destOffset += destStride;
                offset += self.getBufferStrides()[dim];
            }
        }

        public static ToJavaBytesFortranOrderNode create() {
            return MemoryViewNodesFactory.ToJavaBytesFortranOrderNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ToJavaBytesNode
    extends Node {
        public abstract byte[] execute(PMemoryView var1);

        @Specialization(guards={"self.getDimensions() == cachedDimensions", "cachedDimensions < 8"}, limit="3")
        byte[] tobytesCached(PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached(value="self.getDimensions()") int cachedDimensions, @Cached.Shared @Cached ReadBytesAtNode readBytesAtNode, @Cached.Shared @Cached CExtNodes.PCallCapiFunction callCapiFunction, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            self.checkReleased(inliningTarget, raiseNode);
            byte[] bytes = new byte[self.getLength()];
            if (cachedDimensions == 0) {
                readBytesAtNode.execute(inliningTarget, bytes, 0, self.getItemSize(), self, self.getBufferPointer(), self.getOffset());
            } else {
                this.convert(inliningTarget, bytes, self, cachedDimensions, readBytesAtNode, callCapiFunction);
            }
            return bytes;
        }

        @Specialization(replaces={"tobytesCached"})
        byte[] tobytesGeneric(PMemoryView self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ReadBytesAtNode readBytesAtNode, @Cached.Shared @Cached CExtNodes.PCallCapiFunction callCapiFunction, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            self.checkReleased(inliningTarget, raiseNode);
            byte[] bytes = new byte[self.getLength()];
            if (self.getDimensions() == 0) {
                readBytesAtNode.execute(inliningTarget, bytes, 0, self.getItemSize(), self, self.getBufferPointer(), self.getOffset());
            } else {
                this.convertBoundary(inliningTarget, bytes, self, self.getDimensions(), readBytesAtNode, callCapiFunction);
            }
            return bytes;
        }

        @CompilerDirectives.TruffleBoundary
        private void convertBoundary(Node inliningTarget, byte[] dest, PMemoryView self, int ndim, ReadBytesAtNode readBytesAtNode, CExtNodes.PCallCapiFunction callCapiFunction) {
            this.convert(inliningTarget, dest, self, ndim, readBytesAtNode, callCapiFunction);
        }

        protected void convert(Node inliningTarget, byte[] dest, PMemoryView self, int ndim, ReadBytesAtNode readBytesAtNode, CExtNodes.PCallCapiFunction callCapiFunction) {
            ToJavaBytesNode.recursive(inliningTarget, dest, 0, self, 0, ndim, self.getBufferPointer(), self.getOffset(), readBytesAtNode, callCapiFunction);
        }

        private static int recursive(Node inliningTarget, byte[] dest, int initialDestOffset, PMemoryView self, int dim, int ndim, Object ptr, int initialOffset, ReadBytesAtNode readBytesAtNode, CExtNodes.PCallCapiFunction callCapiFunction) {
            int offset = initialOffset;
            int destOffset = initialDestOffset;
            for (int i = 0; i < self.getBufferShape()[dim]; ++i) {
                Object xptr = ptr;
                int xoffset = offset;
                if (self.getBufferSuboffsets() != null && self.getBufferSuboffsets()[dim] >= 0) {
                    xptr = callCapiFunction.call(NativeCAPISymbol.FUN_TRUFFLE_ADD_SUBOFFSET, ptr, offset, self.getBufferSuboffsets()[dim]);
                    xoffset = 0;
                }
                if (dim == ndim - 1) {
                    readBytesAtNode.execute(inliningTarget, dest, destOffset, self.getItemSize(), self, xptr, xoffset);
                    destOffset += self.getItemSize();
                } else {
                    destOffset = ToJavaBytesNode.recursive(inliningTarget, dest, destOffset, self, dim + 1, ndim, xptr, xoffset, readBytesAtNode, callCapiFunction);
                }
                offset += self.getBufferStrides()[dim];
            }
            return destOffset;
        }

        @NeverDefault
        public static ToJavaBytesNode create() {
            return MemoryViewNodesFactory.ToJavaBytesNodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    static abstract class PointerLookupNode
    extends Node {
        @Node.Child
        private CExtNodes.PCallCapiFunction callCapiFunction;
        @Node.Child
        private PyNumberAsSizeNode asSizeNode;

        PointerLookupNode() {
        }

        public abstract MemoryPointer execute(VirtualFrame var1, PMemoryView var2, Object var3);

        public abstract MemoryPointer execute(VirtualFrame var1, PMemoryView var2, int var3);

        private void lookupDimension(Node inliningTarget, PMemoryView self, MemoryPointer ptr, int dim, int initialIndex, InlinedConditionProfile hasSuboffsetsProfile, PRaiseNode.Lazy raiseNode) {
            int index = initialIndex;
            int[] shape = self.getBufferShape();
            int nitems = shape[dim];
            if (index < 0) {
                index += nitems;
            }
            if (index < 0 || index >= nitems) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.INDEX_OUT_OF_BOUNDS_ON_DIMENSION_D, dim + 1);
            }
            ptr.offset += self.getBufferStrides()[dim] * index;
            int[] suboffsets = self.getBufferSuboffsets();
            if (hasSuboffsetsProfile.profile(inliningTarget, suboffsets != null) && suboffsets[dim] >= 0) {
                ptr.ptr = this.getCallCapiFunction().call(NativeCAPISymbol.FUN_TRUFFLE_ADD_SUBOFFSET, ptr.ptr, ptr.offset, suboffsets[dim]);
                ptr.offset = 0;
            }
        }

        @Specialization
        MemoryPointer resolveInt(PMemoryView self, int index, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile hasOneDimensionProfile, @Cached.Shared @Cached InlinedConditionProfile hasSuboffsetsProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (hasOneDimensionProfile.profile(inliningTarget, self.getDimensions() == 1)) {
                MemoryPointer ptr = new MemoryPointer(self.getBufferPointer(), self.getOffset());
                this.lookupDimension(inliningTarget, self, ptr, 0, index, hasSuboffsetsProfile, raiseNode);
                return ptr;
            }
            if (self.getDimensions() == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_INDEXING_OF_0_DIM_MEMORY);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.MULTI_DIMENSIONAL_SUB_VIEWS_NOT_IMPLEMENTED);
        }

        @Specialization(guards={"cachedDimensions == self.getDimensions()", "cachedDimensions <= 8"}, limit="3")
        @ExplodeLoop
        MemoryPointer resolveTupleCached(VirtualFrame frame, PMemoryView self, PTuple indices, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile hasSuboffsetsProfile, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached(value="self.getDimensions()") int cachedDimensions, @Cached.Shared @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage indicesStorage = getSequenceStorageNode.execute(inliningTarget, indices);
            PointerLookupNode.checkTupleLength(inliningTarget, indicesStorage, cachedDimensions, raiseNode);
            MemoryPointer ptr = new MemoryPointer(self.getBufferPointer(), self.getOffset());
            for (int dim = 0; dim < cachedDimensions; ++dim) {
                Object indexObj = getItemNode.execute(inliningTarget, indicesStorage, dim);
                int index = this.convertIndex(frame, inliningTarget, indexCheckNode, indexObj, raiseNode);
                this.lookupDimension(inliningTarget, self, ptr, dim, index, hasSuboffsetsProfile, raiseNode);
            }
            return ptr;
        }

        @Specialization(replaces={"resolveTupleCached"})
        MemoryPointer resolveTupleGeneric(VirtualFrame frame, PMemoryView self, PTuple indices, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile hasSuboffsetsProfile, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage indicesStorage = getSequenceStorageNode.execute(inliningTarget, indices);
            int ndim = self.getDimensions();
            PointerLookupNode.checkTupleLength(inliningTarget, indicesStorage, ndim, raiseNode);
            MemoryPointer ptr = new MemoryPointer(self.getBufferPointer(), self.getOffset());
            for (int dim = 0; dim < ndim; ++dim) {
                Object indexObj = getItemNode.execute(inliningTarget, indicesStorage, dim);
                int index = this.convertIndex(frame, inliningTarget, indexCheckNode, indexObj, raiseNode);
                this.lookupDimension(inliningTarget, self, ptr, dim, index, hasSuboffsetsProfile, raiseNode);
            }
            return ptr;
        }

        @Specialization(guards={"!isPTuple(indexObj)"})
        MemoryPointer resolveIntObj(VirtualFrame frame, PMemoryView self, Object indexObj, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile hasOneDimensionProfile, @Cached.Shared @Cached InlinedConditionProfile hasSuboffsetsProfile, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            int index = this.convertIndex(frame, inliningTarget, indexCheckNode, indexObj, raiseNode);
            return this.resolveInt(self, index, inliningTarget, hasOneDimensionProfile, hasSuboffsetsProfile, raiseNode);
        }

        private static void checkTupleLength(Node inliningTarget, SequenceStorage indicesStorage, int ndim, PRaiseNode.Lazy raiseNode) {
            int length = indicesStorage.length();
            if (length == ndim) {
                return;
            }
            if (ndim == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_INDEXING_OF_0_DIM_MEMORY);
            }
            if (length > ndim) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_INDEX_D_DIMENSION_VIEW_WITH_D, ndim, length);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.SUB_VIEWS_NOT_IMPLEMENTED);
        }

        private int convertIndex(VirtualFrame frame, Node inliningTarget, PyIndexCheckNode indexCheckNode, Object indexObj, PRaiseNode.Lazy raiseNode) {
            if (!indexCheckNode.execute(inliningTarget, indexObj)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMORYVIEW_INVALID_SLICE_KEY);
            }
            return this.getAsSizeNode().executeExact((Frame)frame, inliningTarget, indexObj, PythonBuiltinClassType.IndexError);
        }

        private PyNumberAsSizeNode getAsSizeNode() {
            if (this.asSizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asSizeNode = (PyNumberAsSizeNode)this.insert(PyNumberAsSizeNode.create());
            }
            return this.asSizeNode;
        }

        private CExtNodes.PCallCapiFunction getCallCapiFunction() {
            if (this.callCapiFunction == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callCapiFunction = (CExtNodes.PCallCapiFunction)this.insert(CExtNodes.PCallCapiFunction.create());
            }
            return this.callCapiFunction;
        }
    }

    @CompilerDirectives.ValueType
    static class MemoryPointer {
        public Object ptr;
        public int offset;

        public MemoryPointer(Object ptr, int offset) {
            this.ptr = ptr;
            this.offset = offset;
        }
    }

    static abstract class WriteItemAtNode
    extends Node {
        WriteItemAtNode() {
        }

        public abstract void execute(VirtualFrame var1, PMemoryView var2, Object var3, int var4, Object var5);

        @Specialization(guards={"ptr != null"})
        static void doNative(VirtualFrame frame, PMemoryView self, Object ptr, int offset, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PackValueNode packValueNode) {
            int itemSize = self.getItemSize();
            MemoryViewNodes.checkBufferBounds(inliningTarget, self, bufferLib, offset, itemSize);
            NativeByteSequenceStorage buffer = NativeByteSequenceStorage.create(ptr, itemSize + offset, itemSize + offset, false);
            packValueNode.execute(frame, inliningTarget, self.getFormat(), self.getFormatString(), object, buffer, offset);
        }

        @Specialization(guards={"ptr == null"})
        static void doManaged(VirtualFrame frame, PMemoryView self, Object ptr, int offset, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PackValueNode packValueNode) {
            int itemSize = self.getItemSize();
            MemoryViewNodes.checkBufferBounds(inliningTarget, self, bufferLib, offset, itemSize);
            packValueNode.execute(frame, inliningTarget, self.getFormat(), self.getFormatString(), object, self.getBuffer(), offset);
        }
    }

    static abstract class ReadItemAtNode
    extends Node {
        ReadItemAtNode() {
        }

        public abstract Object execute(VirtualFrame var1, PMemoryView var2, Object var3, int var4);

        @Specialization(guards={"ptr != null"})
        static Object doNative(PMemoryView self, Object ptr, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached UnpackValueNode unpackValueNode) {
            int itemSize = self.getItemSize();
            MemoryViewNodes.checkBufferBounds(inliningTarget, self, bufferLib, offset, itemSize);
            NativeByteSequenceStorage buffer = NativeByteSequenceStorage.create(ptr, itemSize + offset, itemSize + offset, false);
            return unpackValueNode.execute(inliningTarget, self.getFormat(), self.getFormatString(), buffer, offset);
        }

        @Specialization(guards={"ptr == null"})
        static Object doManaged(PMemoryView self, Object ptr, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached UnpackValueNode unpackValueNode) {
            int itemSize = self.getItemSize();
            MemoryViewNodes.checkBufferBounds(inliningTarget, self, bufferLib, offset, itemSize);
            return unpackValueNode.execute(inliningTarget, self.getFormat(), self.getFormatString(), self.getBuffer(), offset);
        }

        @NeverDefault
        protected static CastToByteNode createCoerce() {
            return CastToByteNode.create(true);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class WriteBytesAtNode
    extends Node {
        WriteBytesAtNode() {
        }

        public abstract void execute(Node var1, byte[] var2, int var3, int var4, PMemoryView var5, Object var6, int var7);

        @Specialization(guards={"ptr != null", "cachedLen == len", "cachedLen <= 8"}, limit="4")
        @ExplodeLoop
        static void doNativeCached(byte[] src, int srcOffset, int len, PMemoryView self, Object ptr, int offset, @Cached(value="len") int cachedLen, @Cached.Shared @Cached(inline=false) CStructAccess.WriteByteNode writeNode) {
            writeNode.writeByteArray(ptr, src, cachedLen, srcOffset, offset);
        }

        @Specialization(guards={"ptr != null"}, replaces={"doNativeCached"})
        static void doNativeGeneric(byte[] src, int srcOffset, int len, PMemoryView self, Object ptr, int offset, @Cached.Shared @Cached(inline=false) CStructAccess.WriteByteNode writeNode) {
            writeNode.writeByteArray(ptr, src, len, srcOffset, offset);
        }

        @Specialization(guards={"ptr == null", "cachedLen == len", "cachedLen <= 8"}, limit="4")
        @ExplodeLoop
        void doManagedCached(byte[] src, int srcOffset, int len, PMemoryView self, Object ptr, int offset, @CachedLibrary(value="self.getBuffer()") PythonBufferAccessLibrary bufferLib, @Cached(value="len") int cachedLen) {
            MemoryViewNodes.checkBufferBounds(this, self, bufferLib, offset, cachedLen);
            bufferLib.writeFromByteArray(self.getBuffer(), offset, src, srcOffset, cachedLen);
        }

        @Specialization(guards={"ptr == null"}, replaces={"doManagedCached"}, limit="3")
        void doManagedGeneric(byte[] src, int srcOffset, int len, PMemoryView self, Object ptr, int offset, @CachedLibrary(value="self.getBuffer()") PythonBufferAccessLibrary bufferLib) {
            MemoryViewNodes.checkBufferBounds(this, self, bufferLib, offset, len);
            bufferLib.writeFromByteArray(self.getBuffer(), offset, src, srcOffset, len);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ReadBytesAtNode
    extends Node {
        ReadBytesAtNode() {
        }

        public abstract void execute(Node var1, byte[] var2, int var3, int var4, PMemoryView var5, Object var6, int var7);

        @Specialization(guards={"ptr != null", "cachedLen == len", "cachedLen <= 8"}, limit="4")
        @ExplodeLoop
        static void doNativeCached(byte[] dest, int destOffset, int len, PMemoryView self, Object ptr, int offset, @Cached(value="len") int cachedLen, @Cached.Shared @Cached(inline=false) CStructAccess.ReadByteNode readNode) {
            readNode.readByteArray(ptr, dest, cachedLen, offset, destOffset);
        }

        @Specialization(guards={"ptr != null"}, replaces={"doNativeCached"})
        static void doNativeGeneric(byte[] dest, int destOffset, int len, PMemoryView self, Object ptr, int offset, @Cached.Shared @Cached(inline=false) CStructAccess.ReadByteNode readNode) {
            readNode.readByteArray(ptr, dest, len, offset, destOffset);
        }

        @Specialization(guards={"ptr == null", "cachedLen == len", "cachedLen <= 8"}, limit="4")
        @ExplodeLoop
        void doManagedCached(byte[] dest, int destOffset, int len, PMemoryView self, Object ptr, int offset, @CachedLibrary(value="self.getBuffer()") PythonBufferAccessLibrary bufferLib, @Cached(value="len") int cachedLen) {
            MemoryViewNodes.checkBufferBounds(this, self, bufferLib, offset, cachedLen);
            bufferLib.readIntoByteArray(self.getBuffer(), offset, dest, destOffset, cachedLen);
        }

        @Specialization(guards={"ptr == null"}, replaces={"doManagedCached"}, limit="3")
        void doManagedGeneric(byte[] dest, int destOffset, int len, PMemoryView self, Object ptr, int offset, @CachedLibrary(value="self.getBuffer()") PythonBufferAccessLibrary bufferLib) {
            MemoryViewNodes.checkBufferBounds(this, self, bufferLib, offset, len);
            bufferLib.readIntoByteArray(self.getBuffer(), offset, dest, destOffset, len);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={BufferFormat.class})
    public static abstract class PackValueNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, BufferFormat var3, TruffleString var4, Object var5, Object var6, int var7);

        @Specialization(guards={"format != OTHER"})
        static void pack(VirtualFrame frame, Node inliningTarget, BufferFormat format, TruffleString formatStr, Object value, Object buffer, int offset, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached BufferStorageNodes.PackValueNode packValueNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                packValueNode.execute(frame, inliningTarget, format, value, buffer, offset);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.OverflowError, errorProfile);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.MEMORYVIEW_INVALID_VALUE_FOR_FORMAT_S, formatStr);
            }
        }

        @Fallback
        static void notImplemented(Node inliningTarget, BufferFormat format, TruffleString formatStr, Object object, Object buffer, int offset) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.MEMORYVIEW_FORMAT_S_NOT_SUPPORTED, formatStr);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={BufferFormat.class})
    public static abstract class UnpackValueNode
    extends Node {
        public abstract Object execute(Node var1, BufferFormat var2, TruffleString var3, Object var4, int var5);

        @Specialization(guards={"format != OTHER"})
        static Object unpack(Node inliningTarget, BufferFormat format, TruffleString formatStr, Object buffer, int offset, @Cached BufferStorageNodes.UnpackValueNode unpackValueNode) {
            return unpackValueNode.execute(inliningTarget, format, buffer, offset);
        }

        @Fallback
        static Object notImplemented(Node inliningTarget, BufferFormat format, TruffleString formatStr, Object buffer, int offset) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.MEMORYVIEW_FORMAT_S_NOT_SUPPORTED, formatStr);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class InitFlagsNode
    extends Node {
        public abstract int execute(Node var1, int var2, int var3, int[] var4, int[] var5, int[] var6);

        @Specialization
        static int compute(int ndim, int itemsize, int[] shape, int[] strides, int[] suboffsets) {
            int dim;
            int i;
            if (ndim == 0) {
                return 14;
            }
            if (suboffsets != null) {
                return 16;
            }
            int flags = 6;
            int expectedStride = itemsize;
            for (i = ndim - 1; i >= 0; --i) {
                dim = shape[i];
                if (dim > 1 && strides[i] != expectedStride) {
                    flags &= 0xFFFFFFFD;
                    break;
                }
                expectedStride *= dim;
            }
            expectedStride = itemsize;
            for (i = 0; i < ndim; ++i) {
                dim = shape[i];
                if (dim > 1 && strides[i] != expectedStride) {
                    flags &= 0xFFFFFFFB;
                    break;
                }
                expectedStride *= dim;
            }
            return flags;
        }
    }
}

