/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.posix;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.posix.PDirEntry;
import com.oracle.graal.python.builtins.objects.posix.PScandirIterator;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltinsFactory;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PScandirIterator})
public final class ScandirIteratorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ScandirIteratorBuiltinsFactory.getFactories();
    }

    static class ReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final PScandirIterator.DirStreamRef ref;

        ReleaseCallback(PScandirIterator.DirStreamRef ref) {
            this.ref = ref;
        }

        @Override
        public void execute(PythonContext context) {
            if (this.ref.isReleased()) {
                return;
            }
            PythonLanguage language = context.getLanguage();
            RootCallTarget callTarget = language.createCachedCallTarget(ReleaserRootNode::new, (Object)ReleaserRootNode.class);
            callTarget.call(new Object[]{this.ref});
        }

        private static class ReleaserRootNode
        extends RootNode {
            @Node.Child
            private PosixSupportLibrary posixSupportLibrary = (PosixSupportLibrary)PosixSupportLibrary.getFactory().createDispatched(1);

            ReleaserRootNode(TruffleLanguage<?> language) {
                super(language);
            }

            public Object execute(VirtualFrame frame) {
                PScandirIterator.DirStreamRef ref = (PScandirIterator.DirStreamRef)frame.getArguments()[0];
                ref.rewindAndClose(this.posixSupportLibrary, PythonContext.get((Node)this).getPosixSupport());
                return null;
            }
        }
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class ExitNode
    extends PythonBuiltinNode {
        ExitNode() {
        }

        @Specialization
        PNone exit(PScandirIterator self, Object type, Object value, Object traceback, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib) {
            self.ref.rewindAndClose(posixLib, this.getPosixSupport());
            return PNone.NONE;
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class EnterNode
    extends PythonUnaryBuiltinNode {
        EnterNode() {
        }

        @Specialization
        PScandirIterator iter(PScandirIterator self) {
            return self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        NextNode() {
        }

        @Specialization
        static PDirEntry next(VirtualFrame frame, PScandirIterator self, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (self.ref.isReleased()) {
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            PosixSupport posixSupport = PosixSupport.get(inliningTarget);
            try {
                Object dirEntryData = posixLib.readdir(posixSupport, self.ref.getReference());
                if (dirEntryData == null) {
                    self.ref.rewindAndClose(posixLib, posixSupport);
                    throw raiseNode.get(inliningTarget).raiseStopIteration();
                }
                return factory.createDirEntry(dirEntryData, self.path);
            }
            catch (PosixSupportLibrary.PosixException e) {
                self.ref.rewindAndClose(posixLib, posixSupport);
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        PScandirIterator iter(PScandirIterator self) {
            return self;
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        PNone close(PScandirIterator self, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib) {
            self.ref.rewindAndClose(posixLib, this.getPosixSupport());
            return PNone.NONE;
        }
    }
}

