/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public final class MroShape {
    private final Shape shape;
    private final MroShape parent;
    private final int size;
    private final ConcurrentHashMap<Shape, MroShape> children = new ConcurrentHashMap();

    public MroShape(Shape shape, MroShape parent, int size) {
        this.shape = shape;
        this.parent = parent;
        this.size = size;
    }

    public static MroShape createRoot() {
        CompilerAsserts.neverPartOfCompilation();
        return new MroShape(null, null, 0);
    }

    public static MroShape create(MroSequenceStorage mro, PythonLanguage lang) {
        CompilerAsserts.neverPartOfCompilation();
        MroShape mroShape = lang.getMroShapeRoot();
        for (int i = mro.length() - 1; i >= 0; --i) {
            PythonManagedClass managedClass;
            PythonAbstractClass element = mro.getItemNormalized(i);
            if (PythonManagedClass.isInstance(element)) {
                managedClass = PythonManagedClass.cast(element);
                if (GetDictIfExistsNode.getUncached().execute(managedClass) != null) {
                    return null;
                }
                if ((DynamicObjectLibrary.getUncached().getShapeFlags((DynamicObject)managedClass) & 4) != 0) {
                    return null;
                }
                assert (MroShape.hasNoNoValueProperties(managedClass));
            } else {
                return null;
            }
            mroShape = mroShape.add(managedClass.getShape());
        }
        return mroShape;
    }

    public MroShapeLookupResult lookup(TruffleString attrName) {
        CompilerAsserts.neverPartOfCompilation();
        int index = 0;
        MroShape curr = this;
        while (curr.parent != null) {
            if (curr.shape.getProperty((Object)attrName) != null) {
                return new MroShapeLookupResult(index);
            }
            ++index;
            curr = curr.parent;
        }
        return MroShapeLookupResult.createNotFound();
    }

    private MroShape add(Shape newShape) {
        return this.children.computeIfAbsent(newShape, s -> new MroShape((Shape)s, this, this.size + 1));
    }

    private static boolean hasNoNoValueProperties(PythonManagedClass klass) {
        DynamicObjectLibrary lib = (DynamicObjectLibrary)DynamicObjectLibrary.getFactory().getUncached((Object)klass);
        for (Object key : klass.getShape().getKeyList()) {
            if (!(key instanceof TruffleString) || lib.getOrDefault((DynamicObject)klass, key, null) != PNone.NO_VALUE) continue;
            assert (false) : String.valueOf(klass) + "." + String.valueOf(key);
            return false;
        }
        return true;
    }

    public static boolean validate(Object obj, PythonLanguage language) {
        if (!(obj instanceof PythonClass)) {
            return true;
        }
        PythonClass klass = (PythonClass)obj;
        MroSequenceStorage mro = klass.getMethodResolutionOrder();
        if (mro == null) {
            return true;
        }
        MroShape mroShape = klass.getMroShape();
        for (int i = 0; i < mro.length(); ++i) {
            if (mro.getItemNormalized(i) instanceof PythonManagedClass) continue;
            assert (mroShape == null) : mro.getClassName();
            return true;
        }
        if (mroShape == null) {
            return true;
        }
        MroShape currMroShape = mroShape;
        for (int i = 0; i < mro.length(); ++i) {
            PythonManagedClass kls = (PythonManagedClass)mro.getItemNormalized(i);
            if (kls.getShape() != currMroShape.shape) {
                Object property22;
                String message = String.format("mro:%s,index:%d,curr klass:%s\nactual shape:\n%s,\nexpected shape:\n%s", mro.getClassName(), i, kls, kls.getShape(), currMroShape.shape);
                HashSet<Object> klsShapeProps = new HashSet<Object>();
                for (Object property22 : kls.getShape().getPropertyList()) {
                    if (property22.isHidden()) continue;
                    klsShapeProps.add(property22.getKey());
                }
                klsShapeProps.removeIf(x -> DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)kls, x, null) == PNone.NO_VALUE);
                HashSet<Object> currMroShapeProps = new HashSet<Object>();
                property22 = currMroShape.shape.getPropertyList().iterator();
                while (property22.hasNext()) {
                    Property property3 = (Property)property22.next();
                    if (property3.isHidden()) continue;
                    currMroShapeProps.add(property3.getKey());
                }
                HashSet<Object> diff = new HashSet<Object>(klsShapeProps);
                diff.addAll(currMroShapeProps);
                diff.removeIf(x -> klsShapeProps.contains(x) && currMroShapeProps.contains(x));
                diff.remove(SpecialAttributeNames.T___SLOTNAMES__);
                if (diff.size() > 0) {
                    HashSet<String> sDiff = new HashSet<String>(diff.size());
                    for (Object e : diff) {
                        sDiff.add(e.toString());
                    }
                    assert (diff.isEmpty()) : message + ",diff:" + String.join((CharSequence)",", sDiff);
                }
            }
            currMroShape = currMroShape.parent;
        }
        assert (currMroShape == language.getMroShapeRoot()) : mro.getClassName();
        return true;
    }

    public static final class MroShapeLookupResult
    extends Node {
        private static final int NOT_FOUND_INDEX = -1;
        private final int mroIndex;
        @Node.Child
        ReadAttributeFromDynamicObjectNode readNode;

        public MroShapeLookupResult(int mroIndex) {
            this.mroIndex = mroIndex;
            if (mroIndex != -1) {
                this.readNode = ReadAttributeFromDynamicObjectNode.create();
            }
        }

        static MroShapeLookupResult createNotFound() {
            return new MroShapeLookupResult(-1);
        }

        public Object getFromMro(MroSequenceStorage mro, Object key) {
            if (this.mroIndex == -1) {
                return PNone.NO_VALUE;
            }
            Object result = this.readNode.execute((Object)mro.getItemNormalized(this.mroIndex), key);
            assert (result != PNone.NO_VALUE) : String.valueOf(mro.getClassName()) + "." + String.valueOf(key);
            return result;
        }
    }
}

