/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.type.MroShape;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONodeGen;
import com.oracle.graal.python.nodes.attributes.LookupInMROBaseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
public abstract class LookupAttributeInMRONode
extends LookupInMROBaseNode {
    private final boolean skipNonStaticBases;
    protected final TruffleString key;
    @Node.Child
    private TypeNodes.IsSameTypeNode isSameTypeNode;
    @Node.Child
    private TypeNodes.GetMroStorageNode getMroNode;

    public LookupAttributeInMRONode(TruffleString key, boolean skipNonStaticBases) {
        this.key = key;
        this.skipNonStaticBases = skipNonStaticBases;
    }

    @NeverDefault
    public static LookupAttributeInMRONode create(TruffleString key) {
        return LookupAttributeInMRONodeGen.create(key, false);
    }

    @NeverDefault
    public static LookupAttributeInMRONode createForLookupOfUnmanagedClasses(TruffleString key) {
        return LookupAttributeInMRONodeGen.create(key, true);
    }

    protected static Object findAttr(Python3Core core, PythonBuiltinClassType klass, Object key) {
        return LookupAttributeInMRONode.findAttr(core, klass, key, ReadAttributeFromDynamicObjectNode.getUncached());
    }

    public static Object findAttr(Python3Core core, PythonBuiltinClassType klass, Object key, ReadAttributeFromDynamicObjectNode readAttrNode) {
        Object value = PNone.NO_VALUE;
        for (PythonBuiltinClassType current = klass; current != null; current = current.getBase()) {
            value = readAttrNode.execute((Object)core.lookupType(current), key);
            if (value == PNone.NO_VALUE) continue;
            return value;
        }
        return value;
    }

    @Specialization(guards={"isSingleContext()", "klass == cachedKlass"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    protected static Object lookupPBCTCached(PythonBuiltinClassType klass, @Cached(value="klass") PythonBuiltinClassType cachedKlass, @Cached(value="findAttr(getContext(), cachedKlass, key)") Object cachedValue) {
        return cachedValue;
    }

    @Idempotent
    protected static boolean canCache(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Double || value instanceof PNone;
    }

    @Specialization(guards={"klass == cachedKlass", "canCache(cachedValue)"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    protected static Object lookupPBCTCachedMulti(PythonBuiltinClassType klass, @Cached(value="klass") PythonBuiltinClassType cachedKlass, @Cached(value="findAttr(getContext(), cachedKlass, key)") Object cachedValue) {
        return cachedValue;
    }

    public static PythonBuiltinClassType findOwnerInMro(Python3Core core, PythonBuiltinClassType klass, Object key) {
        ReadAttributeFromDynamicObjectNode readNode = ReadAttributeFromDynamicObjectNode.getUncached();
        for (PythonBuiltinClassType current = klass; current != null; current = current.getBase()) {
            if (readNode.execute((Object)core.lookupType(current), key) == PNone.NO_VALUE) continue;
            return current;
        }
        return null;
    }

    @Specialization(replaces={"lookupPBCTCached", "lookupPBCTCachedMulti"}, guards={"klass == cachedKlass"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    @HostCompilerDirectives.InliningCutoff
    protected Object lookupPBCTCachedOwner(PythonBuiltinClassType klass, @Cached(value="klass") PythonBuiltinClassType cachedKlass, @Cached(value="findOwnerInMro(getContext(), cachedKlass, key)") PythonBuiltinClassType ownerKlass, @Cached.Shared @Cached ReadAttributeFromDynamicObjectNode readAttrNode) {
        if (ownerKlass == null) {
            return PNone.NO_VALUE;
        }
        return readAttrNode.execute((Object)PythonContext.get(this).lookupType(ownerKlass), this.key);
    }

    @Specialization(replaces={"lookupPBCTCachedOwner"})
    @HostCompilerDirectives.InliningCutoff
    protected Object lookupPBCTGeneric(PythonBuiltinClassType klass, @Cached.Shared @Cached ReadAttributeFromDynamicObjectNode readAttrNode) {
        return LookupAttributeInMRONode.findAttr(PythonContext.get(this), klass, this.key, readAttrNode);
    }

    private static boolean skipNonStaticBase(Object clsObj, boolean skipNonStaticBases, DynamicObjectLibrary dylib) {
        return skipNonStaticBases && clsObj instanceof PythonClass && !((PythonClass)clsObj).isStaticBase(dylib);
    }

    protected AttributeAssumptionPair findAttrAndAssumptionInMRO(Object klass) {
        PDict dict;
        CompilerAsserts.neverPartOfCompilation();
        DynamicObjectLibrary dylib = DynamicObjectLibrary.getUncached();
        if (klass instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject nativeKlass = (PythonAbstractNativeObject)klass;
            Object nativedict = CStructAccess.ReadObjectNode.getUncached().readFromObj(nativeKlass, CFields.PyTypeObject__tp_dict);
            dict = nativedict == PNone.NO_VALUE ? null : (PDict)nativedict;
        } else {
            dict = GetDictIfExistsNode.getUncached().execute(klass);
        }
        if (dict != null && HashingStorageNodes.HashingStorageGuards.mayHaveSideEffects(dict)) {
            return null;
        }
        MroSequenceStorage mro = this.getMro(klass);
        Assumption attrAssumption = mro.createAttributeInMROFinalAssumption(this.key);
        for (int i = 0; i < mro.length(); ++i) {
            Object value;
            PythonAbstractClass clsObj = mro.getItemNormalized(i);
            if (i > 0) {
                assert (clsObj != klass) : "MRO chain is incorrect: '" + String.valueOf(klass) + "' was found at position " + i;
                this.getMro(clsObj).addAttributeInMROFinalAssumption(this.key, attrAssumption);
            }
            if (LookupAttributeInMRONode.skipNonStaticBase(clsObj, this.skipNonStaticBases, dylib) || (value = ReadAttributeFromObjectNode.getUncachedForceType().execute(clsObj, (Object)this.key)) == PNone.NO_VALUE) continue;
            return new AttributeAssumptionPair(attrAssumption, value);
        }
        return new AttributeAssumptionPair(attrAssumption, PNone.NO_VALUE);
    }

    @Specialization(guards={"isSingleContext()", "isSameType(cachedKlass, klass)", "cachedAttrInMROInfo != null"}, limit="getAttributeAccessInlineCacheMaxDepth()", assumptions={"cachedAttrInMROInfo.assumption"})
    protected static Object lookupConstantMROCached(Object klass, @Cached(value="klass") Object cachedKlass, @Cached(value="findAttrAndAssumptionInMRO(cachedKlass)") AttributeAssumptionPair cachedAttrInMROInfo) {
        return cachedAttrInMROInfo.value;
    }

    public MroShape.MroShapeLookupResult lookupInMroShape(MroShape shape, Object klass) {
        assert (MroShape.validate(klass, PythonLanguage.get(this)));
        return shape.lookup(this.key);
    }

    @Specialization(guards={"!isSingleContext()", "cachedMroShape != null", "klass.getMroShape() == cachedMroShape"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    @HostCompilerDirectives.InliningCutoff
    protected Object lookupConstantMROShape(PythonClass klass, @Cached(value="klass.getMroShape()") MroShape cachedMroShape, @Cached(value="lookupInMroShape(cachedMroShape, klass)") MroShape.MroShapeLookupResult lookupResult) {
        return lookupResult.getFromMro(this.getMro(klass), this.key);
    }

    @NeverDefault
    protected static ReadAttributeFromObjectNode[] create(int size) {
        ReadAttributeFromObjectNode[] nodes = new ReadAttributeFromObjectNode[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = ReadAttributeFromObjectNode.createForceType();
        }
        return nodes;
    }

    @Specialization(guards={"isSingleContext()", "isSameType(cachedKlass, klass)", "mroLength < 32"}, limit="getAttributeAccessInlineCacheMaxDepth()", replaces={"lookupConstantMROShape"}, assumptions={"lookupStable"})
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    @HostCompilerDirectives.InliningCutoff
    protected Object lookupConstantMRO(Object klass, @Cached(value="klass") Object cachedKlass, @Cached(value="getMro(cachedKlass)") MroSequenceStorage mro, @Cached(value="mro.getLookupStableAssumption()") Assumption lookupStable, @Cached(value="mro.length()") int mroLength, @Cached.Exclusive @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached(value="create(mroLength)") ReadAttributeFromObjectNode[] readAttrNodes) {
        for (int i = 0; i < mroLength; ++i) {
            Object value;
            PythonAbstractClass kls = mro.getItemNormalized(i);
            if (LookupAttributeInMRONode.skipNonStaticBase(kls, this.skipNonStaticBases, dylib) || (value = readAttrNodes[i].execute(kls, (Object)this.key)) == PNone.NO_VALUE) continue;
            return value;
        }
        return PNone.NO_VALUE;
    }

    @Specialization(guards={"mroLength == cachedMroLength", "cachedMroLength < 32"}, replaces={"lookupConstantMROCached", "lookupConstantMRO"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    @HostCompilerDirectives.InliningCutoff
    protected Object lookupCachedLen(Object klass, @Bind(value="getMro(klass)") MroSequenceStorage mro, @Bind(value="mro.length()") int mroLength, @Cached(value="mro.length()") int cachedMroLength, @Cached.Exclusive @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached(value="create(cachedMroLength)") ReadAttributeFromObjectNode[] readAttrNodes) {
        for (int i = 0; i < cachedMroLength; ++i) {
            Object value;
            PythonAbstractClass kls = mro.getItemNormalized(i);
            if (LookupAttributeInMRONode.skipNonStaticBase(kls, this.skipNonStaticBases, dylib) || (value = readAttrNodes[i].execute(kls, (Object)this.key)) == PNone.NO_VALUE) continue;
            return value;
        }
        return PNone.NO_VALUE;
    }

    @Specialization(replaces={"lookupConstantMROCached", "lookupConstantMRO", "lookupCachedLen"})
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    protected Object lookupGeneric(Object klass, @Cached.Exclusive @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttrNode) {
        return LookupAttributeInMRONode.lookup(this.key, this.getMro(klass), readAttrNode, this.skipNonStaticBases, dylib);
    }

    protected TypeNodes.GetMroStorageNode ensureGetMroNode() {
        if (this.getMroNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getMroNode = (TypeNodes.GetMroStorageNode)this.insert(TypeNodes.GetMroStorageNode.create());
        }
        return this.getMroNode;
    }

    protected MroSequenceStorage getMro(Object clazz) {
        return this.ensureGetMroNode().executeCached(clazz);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object lookupSlowPath(Object klass, Object key) {
        return LookupAttributeInMRONode.lookup(key, TypeNodes.GetMroStorageNode.executeUncached(klass), ReadAttributeFromObjectNode.getUncachedForceType(), false, DynamicObjectLibrary.getUncached());
    }

    public static Object lookup(Object key, MroSequenceStorage mro, ReadAttributeFromObjectNode readAttrNode, boolean skipNonStaticBases, DynamicObjectLibrary dylib) {
        for (int i = 0; i < mro.length(); ++i) {
            Object value;
            PythonAbstractClass kls = mro.getItemNormalized(i);
            if (LookupAttributeInMRONode.skipNonStaticBase(kls, skipNonStaticBases, dylib) || (value = readAttrNode.execute(kls, key)) == PNone.NO_VALUE) continue;
            return value;
        }
        return PNone.NO_VALUE;
    }

    protected boolean isSameType(Object cachedKlass, Object klass) {
        if (this.isSameTypeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isSameTypeNode = (TypeNodes.IsSameTypeNode)this.insert(TypeNodesFactory.IsSameTypeNodeGen.create());
        }
        return this.isSameTypeNode.executeCached(cachedKlass, klass);
    }

    static final class AttributeAssumptionPair {
        public final Assumption assumption;
        public final Object value;

        AttributeAssumptionPair(Assumption assumption, Object value) {
            this.assumption = assumption;
            this.value = value;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class Dynamic
    extends PNodeWithContext {
        public abstract Object execute(Object var1, Object var2);

        @Specialization(guards={"stringEquals(key, cachedKey, equalNode)"}, limit="2")
        protected static Object lookupConstantMRO(Object klass, TruffleString key, @Cached(value="key") TruffleString cachedKey, @Cached TruffleString.EqualNode equalNode, @Cached(value="create(key)") LookupAttributeInMRONode lookup) {
            return lookup.execute(klass);
        }

        @Specialization(replaces={"lookupConstantMRO"})
        @HostCompilerDirectives.InliningCutoff
        protected Object lookupInBuiltinType(PythonBuiltinClassType klass, Object key, @Cached ReadAttributeFromDynamicObjectNode readAttrNode) {
            return LookupAttributeInMRONode.findAttr(PythonContext.get(this), klass, key, readAttrNode);
        }

        @Specialization(replaces={"lookupConstantMRO"})
        @HostCompilerDirectives.InliningCutoff
        protected static Object lookupGeneric(Object klass, Object key, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetMroStorageNode getMroNode, @Cached(value="createForceType()", uncached="getUncachedForceType()") ReadAttributeFromObjectNode readAttrNode) {
            return LookupAttributeInMRONode.lookup(key, getMroNode.execute(inliningTarget, klass), readAttrNode, false, DynamicObjectLibrary.getUncached());
        }

        @NeverDefault
        public static Dynamic create() {
            return LookupAttributeInMRONodeGen.DynamicNodeGen.create();
        }

        public static Dynamic getUncached() {
            return LookupAttributeInMRONodeGen.DynamicNodeGen.getUncached();
        }
    }
}

