/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.builtins;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodesFactory;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;

public abstract class ListNodes {

    @GenerateInline(value=false)
    public static abstract class GetNativeListStorage
    extends Node {
        public abstract NativeSequenceStorage execute(PythonAbstractNativeObject var1);

        @Specialization
        NativeSequenceStorage getNative(PythonAbstractNativeObject list, @Cached CStructAccess.ReadPointerNode getContents, @Cached CStructAccess.ReadI64Node readI64Node) {
            assert (IsSubtypeNode.getUncached().execute(GetClassNode.executeUncached(list), (Object)PythonBuiltinClassType.PList));
            Object array = getContents.readFromObj(list, CFields.PyListObject__ob_item);
            int size = (int)readI64Node.readFromObj(list, CFields.PyVarObject__ob_size);
            int allocated = (int)readI64Node.readFromObj(list, CFields.PyListObject__allocated);
            return NativeObjectSequenceStorage.create(array, size, allocated, false);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class AppendNode
    extends PNodeWithContext {
        private static final BranchProfile[] DISABLED = new BranchProfile[]{BranchProfile.getUncached()};

        public abstract void execute(PList var1, Object var2);

        @NeverDefault
        static BranchProfile[] getUpdateStoreProfile() {
            return new BranchProfile[1];
        }

        static BranchProfile[] getUpdateStoreProfileUncached() {
            return DISABLED;
        }

        @Specialization
        void appendObjectGeneric(PList list, Object value, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.AppendNode appendNode, @Cached(value="getUpdateStoreProfile()", uncached="getUpdateStoreProfileUncached()", dimensions=1) BranchProfile[] updateStoreProfile) {
            if (updateStoreProfile[0] == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                SequenceStorage newStore = SequenceStorageNodes.AppendNode.executeUncached(list.getSequenceStorage(), value, SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
                updateStoreProfile[0] = BranchProfile.create();
                list.setSequenceStorage(newStore);
                if (list.getOrigin() != null && newStore instanceof BasicSequenceStorage) {
                    list.getOrigin().reportUpdatedCapacity((BasicSequenceStorage)newStore);
                }
            } else {
                SequenceStorage newStore = appendNode.execute(inliningTarget, list.getSequenceStorage(), value, SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
                if (list.getSequenceStorage() != newStore) {
                    updateStoreProfile[0].enter();
                    list.setSequenceStorage(newStore);
                }
                if (CompilerDirectives.inInterpreter() && list.getOrigin() != null && newStore instanceof BasicSequenceStorage) {
                    list.getOrigin().reportUpdatedCapacity((BasicSequenceStorage)newStore);
                }
            }
        }

        @NeverDefault
        public static AppendNode create() {
            return ListNodesFactory.AppendNodeGen.create();
        }

        public static AppendNode getUncached() {
            return ListNodesFactory.AppendNodeGen.getUncached();
        }
    }

    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class IndexNode
    extends PNodeWithContext {
        @Node.Child
        private PRaiseNode raise;
        private static final TruffleString DEFAULT_ERROR_MSG = StringUtils.cat(BuiltinNames.T_LIST, StringLiterals.T_SPACE, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES);
        @Node.Child
        LookupAndCallUnaryNode getIndexNode;
        private final CheckType checkType;
        private final TruffleString errorMessage;

        protected IndexNode(TruffleString message, CheckType type) {
            this.checkType = type;
            this.getIndexNode = LookupAndCallUnaryNode.create(SpecialMethodSlot.Index);
            this.errorMessage = message;
        }

        @NeverDefault
        public static IndexNode create(TruffleString message) {
            return ListNodesFactory.IndexNodeGen.create(message, CheckType.SUBSCRIPT);
        }

        @NeverDefault
        public static IndexNode create() {
            return ListNodesFactory.IndexNodeGen.create(DEFAULT_ERROR_MSG, CheckType.SUBSCRIPT);
        }

        @NeverDefault
        public static IndexNode createInteger(TruffleString msg) {
            return ListNodesFactory.IndexNodeGen.create(msg, CheckType.INTEGER);
        }

        @NeverDefault
        public static IndexNode createNumber(TruffleString msg) {
            return ListNodesFactory.IndexNodeGen.create(msg, CheckType.NUMBER);
        }

        public abstract Object execute(VirtualFrame var1, Object var2);

        @Idempotent
        protected boolean isSubscript() {
            return this.checkType == CheckType.SUBSCRIPT;
        }

        @Idempotent
        protected boolean isNumber() {
            return this.checkType == CheckType.NUMBER;
        }

        @Specialization
        long doLong(long slice) {
            return slice;
        }

        @Specialization
        PInt doPInt(PInt slice) {
            return slice;
        }

        @Specialization(guards={"isSubscript()"})
        PSlice doSlice(PSlice slice) {
            return slice;
        }

        @Specialization(guards={"isNumber()"})
        float doFloat(float slice) {
            return slice;
        }

        @Specialization(guards={"isNumber()"})
        double doDouble(double slice) {
            return slice;
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        Object doGeneric(VirtualFrame frame, Object object) {
            Object idx = this.getIndexNode.executeObject(frame, object);
            boolean valid = false;
            switch (this.checkType.ordinal()) {
                case 0: {
                    valid = MathGuards.isInteger(idx) || idx instanceof PSlice;
                    break;
                }
                case 2: {
                    valid = MathGuards.isNumber(idx);
                    break;
                }
                case 1: {
                    valid = MathGuards.isInteger(idx);
                }
            }
            if (valid) {
                return idx;
            }
            if (this.raise == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raise = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            throw this.raise.raise(PythonErrorType.TypeError, this.errorMessage, idx);
        }

        protected static enum CheckType {
            SUBSCRIPT,
            INTEGER,
            NUMBER;

        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FastConstructListNode
    extends PNodeWithContext {
        public abstract PSequence execute(Frame var1, Node var2, Object var3);

        @Specialization(guards={"cannotBeOverridden(value, inliningTarget, getClassNode)"}, limit="1")
        protected static PSequence doPList(Node inliningTarget, PSequence value, @Cached GetClassNode getClassNode) {
            return value;
        }

        @Fallback
        protected PSequence doGeneric(VirtualFrame frame, Object value, @Cached(inline=false) ConstructListNode constructListNode) {
            return constructListNode.execute((Frame)frame, (Object)PythonBuiltinClassType.PList, value);
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class, PythonOptions.class})
    @GenerateInline(value=false)
    public static abstract class ConstructListNode
    extends PNodeWithContext {
        public final PList execute(Frame frame, Object value) {
            return this.execute(frame, (Object)PythonBuiltinClassType.PList, value);
        }

        protected abstract PList execute(Frame var1, Object var2, Object var3);

        @Specialization
        static PList listString(Object cls, TruffleString arg, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            return factory.createList(cls, StringUtils.toCharacterArray(arg, codePointLengthNode, createCodePointIteratorNode, nextNode, fromCodePointNode));
        }

        @Specialization
        static PList listString(Object cls, PString arg, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            return ConstructListNode.listString(cls, castToStringNode.execute(inliningTarget, arg), factory, codePointLengthNode, createCodePointIteratorNode, nextNode, fromCodePointNode);
        }

        @Specialization(guards={"isNoValue(none)"})
        static PList none(Object cls, PNone none, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createList(cls);
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(list)"})
        static PList fromList(Object cls, PList list, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.CopyNode copyNode) {
            return factory.createList(cls, copyNode.execute(inliningTarget, getSequenceStorageNode.execute(inliningTarget, list)));
        }

        @Specialization(guards={"!isNoValue(iterable)", "!isString(iterable)"})
        static PList listIterable(VirtualFrame frame, Object cls, Object iterable, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached SequenceStorageNodes.CreateStorageFromIteratorNode createStorageFromIteratorNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object iterObj = getIter.execute((Frame)frame, inliningTarget, iterable);
            SequenceStorage storage = createStorageFromIteratorNode.execute(frame, iterObj);
            return factory.createList(cls, storage);
        }

        @Fallback
        static PList listObject(Object cls, Object value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("list does not support iterable object " + String.valueOf(value)));
        }

        @NeverDefault
        public static ConstructListNode create() {
            return ListNodesFactory.ConstructListNodeGen.create();
        }

        public static ConstructListNode getUncached() {
            return ListNodesFactory.ConstructListNodeGen.getUncached();
        }
    }
}

