/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.interop;

import com.oracle.graal.python.builtins.modules.PolyglotModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.nodes.interop.InteropBehavior;
import com.oracle.graal.python.nodes.interop.InteropBehaviorMethod;
import com.oracle.graal.python.nodes.interop.IsInteropBehaviorDefinedNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
@GenerateInline
public abstract class IsInteropBehaviorDefinedNode
extends Node {
    public abstract boolean execute(Node var1, PythonAbstractObject var2, InteropBehaviorMethod var3);

    @Specialization
    static boolean isDefined(Node inlineTarget, PythonAbstractObject receiver, InteropBehaviorMethod method, @Cached GetClassNode getClassNode, @Cached InlinedConditionProfile isMethodDefined, @CachedLibrary(limit="1") DynamicObjectLibrary dylib) {
        InteropBehavior behavior;
        Object klass = getClassNode.execute(inlineTarget, receiver);
        Object value = dylib.getOrDefault((DynamicObject)klass, (Object)PolyglotModuleBuiltins.RegisterInteropBehaviorNode.HOST_INTEROP_BEHAVIOR, null);
        return value instanceof InteropBehavior && isMethodDefined.profile(inlineTarget, (behavior = (InteropBehavior)value).isDefined(method));
    }

    @NeverDefault
    public static IsInteropBehaviorDefinedNode create() {
        return IsInteropBehaviorDefinedNodeGen.create();
    }

    public static IsInteropBehaviorDefinedNode getUncached() {
        return IsInteropBehaviorDefinedNodeGen.getUncached();
    }
}

