/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.TypedSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class MroSequenceStorage
extends TypedSequenceStorage {
    private final TruffleString className;
    private final CyclicAssumption lookupStableAssumption;
    private final Map<TruffleString, List<Assumption>> attributesInMROFinalAssumptions;
    private boolean hasAttributesInMROFinalAssumptions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PythonAbstractClass[] values;
    private static final Predicate<List<Assumption>> REMOVE_IF_LARGE = new Predicate<List<Assumption>>(){

        @Override
        public boolean test(List<Assumption> assumptions) {
            return MroSequenceStorage.invalidateAttributesInMROFinalAssumptions(assumptions, "");
        }
    };

    @CompilerDirectives.TruffleBoundary
    public MroSequenceStorage(TruffleString className, PythonAbstractClass[] elements) {
        this.className = className;
        this.values = elements;
        this.capacity = elements.length;
        this.length = elements.length;
        this.lookupStableAssumption = new CyclicAssumption(className.toJavaStringUncached());
        this.attributesInMROFinalAssumptions = new HashMap<TruffleString, List<Assumption>>();
    }

    @CompilerDirectives.TruffleBoundary
    public MroSequenceStorage(TruffleString className, int capacity) {
        this.className = className;
        this.values = new PythonAbstractClass[capacity];
        this.capacity = capacity;
        this.length = 0;
        this.lookupStableAssumption = new CyclicAssumption(className.toJavaStringUncached());
        this.attributesInMROFinalAssumptions = new HashMap<TruffleString, List<Assumption>>();
    }

    @Override
    public final PythonAbstractClass getItemNormalized(int idx) {
        return this.values[idx];
    }

    @Override
    public void setItemNormalized(int idx, Object value) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public void insertItem(int idx, Object value) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public MroSequenceStorage getSliceInBound(int start, int stop, int step, int sliceLength) {
        PythonAbstractClass[] newArray = new PythonAbstractClass[sliceLength];
        if (step == 1) {
            PythonUtils.arraycopy(this.values, start, newArray, 0, sliceLength);
            return new MroSequenceStorage(this.getClassName(), newArray);
        }
        int i = start;
        for (int j = 0; j < sliceLength; ++j) {
            newArray[j] = this.values[i];
            i += step;
        }
        return new MroSequenceStorage(this.getClassName(), newArray);
    }

    public TruffleString getClassName() {
        return this.className;
    }

    @Override
    public SequenceStorage copy() {
        return new MroSequenceStorage(this.getClassName(), PythonUtils.arrayCopyOf(this.values, this.length));
    }

    @Override
    public SequenceStorage createEmpty(int newCapacity) {
        return new MroSequenceStorage(this.getClassName(), newCapacity);
    }

    @Override
    public Object[] getInternalArray() {
        return this.values;
    }

    public final PythonAbstractClass[] getInternalClassArray() {
        return this.values;
    }

    @Override
    public void increaseCapacityExactWithCopy(int newCapacity) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public void increaseCapacityExact(int newCapacity) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public void reverse() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public Object getIndicativeValue() {
        return null;
    }

    @Override
    public boolean equals(SequenceStorage other) {
        Object[] otherArray = other.getInternalArray();
        return Arrays.equals(this.values, otherArray);
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("should not be reached");
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Generic;
    }

    public Assumption getLookupStableAssumption() {
        return this.lookupStableAssumption.getAssumption();
    }

    public Assumption createAttributeInMROFinalAssumption(TruffleString name) {
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<Assumption> attrAssumptions = this.attributesInMROFinalAssumptions.getOrDefault(name, null);
        if (attrAssumptions == null) {
            attrAssumptions = new ArrayList<Assumption>();
            this.hasAttributesInMROFinalAssumptions = true;
            this.attributesInMROFinalAssumptions.put(name, attrAssumptions);
        }
        Assumption assumption = Truffle.getRuntime().createAssumption(name.toString());
        attrAssumptions.add(assumption);
        return assumption;
    }

    public void addAttributeInMROFinalAssumption(TruffleString name, Assumption assumption) {
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<Assumption> attrAssumptions = this.attributesInMROFinalAssumptions.getOrDefault(name, null);
        if (attrAssumptions == null) {
            attrAssumptions = new ArrayList<Assumption>();
            this.hasAttributesInMROFinalAssumptions = true;
            this.attributesInMROFinalAssumptions.put(name, attrAssumptions);
        }
        attrAssumptions.add(assumption);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean invalidateAttributeInMROFinalAssumptions(TruffleString name) {
        List<Assumption> assumptions = this.attributesInMROFinalAssumptions.getOrDefault(name, Collections.emptyList());
        if (!assumptions.isEmpty()) {
            if (MroSequenceStorage.invalidateAttributesInMROFinalAssumptions(assumptions, String.valueOf(this.getClassName()) + "." + String.valueOf(name))) {
                this.attributesInMROFinalAssumptions.remove(name);
            }
            return true;
        }
        return false;
    }

    public void lookupChanged() {
        CompilerAsserts.neverPartOfCompilation();
        this.attributesInMROFinalAssumptions.values().removeIf(REMOVE_IF_LARGE);
        this.lookupStableAssumption.invalidate();
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean invalidateAttributesInMROFinalAssumptions(List<Assumption> list, String reason) {
        int n = list.size();
        if (n > 0) {
            for (Assumption assumption : list) {
                assumption.invalidate(reason);
            }
        }
        if (n < 16) {
            list.clear();
            return false;
        }
        return true;
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return this.getInternalArray();
    }

    public final boolean hasAttributeInMROFinalAssumptions() {
        return this.hasAttributesInMROFinalAssumptions;
    }
}

