// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.AllocateLockNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.ConstructLockNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.ConstructRLockNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.ExitNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetCurrentThreadIdNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetNativeIdNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetThreadCountNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.GetThreadStackSizeNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.InterruptMainThreadNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.SetSentinelNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.StartNewThreadNode;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins.ThreadLocalNode;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.thread.PRLock;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNodeGen;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(ThreadModuleBuiltins.class)
@SuppressWarnings({"javadoc", "unused"})
public final class ThreadModuleBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(ThreadLocalNodeFactory.getInstance(), AllocateLockNodeFactory.getInstance(), ConstructLockNodeFactory.getInstance(), ConstructRLockNodeFactory.getInstance(), GetCurrentThreadIdNodeFactory.getInstance(), GetNativeIdNodeFactory.getInstance(), GetThreadCountNodeFactory.getInstance(), GetThreadStackSizeNodeFactory.getInstance(), StartNewThreadNodeFactory.getInstance(), SetSentinelNodeFactory.getInstance(), InterruptMainThreadNodeFactory.getInstance(), ExitNodeFactory.getInstance());
    }

    @GeneratedBy(ThreadLocalNode.class)
    static final class ThreadLocalNodeFactory implements NodeFactory<ThreadLocalNode> {

        private static final ThreadLocalNodeFactory THREAD_LOCAL_NODE_FACTORY_INSTANCE = new ThreadLocalNodeFactory();

        private ThreadLocalNodeFactory() {
        }

        @Override
        public Class<ThreadLocalNode> getNodeClass() {
            return ThreadLocalNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public ThreadLocalNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ThreadLocalNode> getInstance() {
            return THREAD_LOCAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ThreadLocalNode create(ReadArgumentNode[] arguments) {
            return new ThreadLocalNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ThreadLocalNode#construct}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(ThreadLocalNode.class)
        @SuppressWarnings("javadoc")
        static final class ThreadLocalNodeGen extends ThreadLocalNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ThreadLocalNode#construct}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ThreadLocalNode#construct}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;

            private ThreadLocalNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.ThreadLocalNode.construct(Object, Object[], PKeyword[], PythonObjectFactory)] */ && arguments1Value_ instanceof Object[]) {
                    Object[] arguments1Value__ = (Object[]) arguments1Value_;
                    if (arguments2Value_ instanceof PKeyword[]) {
                        PKeyword[] arguments2Value__ = (PKeyword[]) arguments2Value_;
                        {
                            PythonObjectFactory factory__ = this.factory_;
                            if (factory__ != null) {
                                return construct(arguments0Value_, arguments1Value__, arguments2Value__, factory__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private PThreadLocal executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                int state_0 = this.state_0_;
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[]) arguments1Value;
                    if (arguments2Value instanceof PKeyword[]) {
                        PKeyword[] arguments2Value_ = (PKeyword[]) arguments2Value;
                        PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                        Objects.requireNonNull(factory__, "Specialization 'construct(Object, Object[], PKeyword[], PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.factory_ = factory__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.ThreadLocalNode.construct(Object, Object[], PKeyword[], PythonObjectFactory)] */;
                        this.state_0_ = state_0;
                        return construct(arguments0Value, arguments1Value_, arguments2Value_, factory__);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(AllocateLockNode.class)
    public static final class AllocateLockNodeFactory implements NodeFactory<AllocateLockNode> {

        private static final AllocateLockNodeFactory ALLOCATE_LOCK_NODE_FACTORY_INSTANCE = new AllocateLockNodeFactory();

        private AllocateLockNodeFactory() {
        }

        @Override
        public Class<AllocateLockNode> getNodeClass() {
            return AllocateLockNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public AllocateLockNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AllocateLockNode> getInstance() {
            return ALLOCATE_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AllocateLockNode create() {
            return new AllocateLockNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AllocateLockNode#construct}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(AllocateLockNode.class)
        @SuppressWarnings("javadoc")
        public static final class AllocateLockNodeGen extends AllocateLockNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AllocateLockNode#construct}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AllocateLockNode#construct}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;

            private AllocateLockNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.AllocateLockNode.construct(Object, Object, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            return construct(arg0Value, arg1Value, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private PLock executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                Objects.requireNonNull(factory__, "Specialization 'construct(Object, Object, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.AllocateLockNode.construct(Object, Object, PythonObjectFactory)] */;
                this.state_0_ = state_0;
                return construct(arg0Value, arg1Value, factory__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ConstructLockNode.class)
    static final class ConstructLockNodeFactory implements NodeFactory<ConstructLockNode> {

        private static final ConstructLockNodeFactory CONSTRUCT_LOCK_NODE_FACTORY_INSTANCE = new ConstructLockNodeFactory();

        private ConstructLockNodeFactory() {
        }

        @Override
        public Class<ConstructLockNode> getNodeClass() {
            return ConstructLockNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ConstructLockNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ConstructLockNode> getInstance() {
            return CONSTRUCT_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ConstructLockNode create() {
            return new ConstructLockNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ConstructLockNode#construct}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(ConstructLockNode.class)
        @SuppressWarnings("javadoc")
        static final class ConstructLockNodeGen extends ConstructLockNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ConstructLockNode#construct}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConstructLockNode#construct}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;

            private ConstructLockNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.ConstructLockNode.construct(Object, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            return construct(arg0Value, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PLock executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                Objects.requireNonNull(factory__, "Specialization 'construct(Object, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.ConstructLockNode.construct(Object, PythonObjectFactory)] */;
                this.state_0_ = state_0;
                return construct(arg0Value, factory__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ConstructRLockNode.class)
    static final class ConstructRLockNodeFactory implements NodeFactory<ConstructRLockNode> {

        private static final ConstructRLockNodeFactory CONSTRUCT_R_LOCK_NODE_FACTORY_INSTANCE = new ConstructRLockNodeFactory();

        private ConstructRLockNodeFactory() {
        }

        @Override
        public Class<ConstructRLockNode> getNodeClass() {
            return ConstructRLockNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ConstructRLockNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ConstructRLockNode> getInstance() {
            return CONSTRUCT_R_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ConstructRLockNode create() {
            return new ConstructRLockNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ConstructRLockNode#construct}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(ConstructRLockNode.class)
        @SuppressWarnings("javadoc")
        static final class ConstructRLockNodeGen extends ConstructRLockNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ConstructRLockNode#construct}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ConstructRLockNode#construct}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;

            private ConstructRLockNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.ConstructRLockNode.construct(Object, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            return construct(arg0Value, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PRLock executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                Objects.requireNonNull(factory__, "Specialization 'construct(Object, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.ConstructRLockNode.construct(Object, PythonObjectFactory)] */;
                this.state_0_ = state_0;
                return construct(arg0Value, factory__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetCurrentThreadIdNode.class)
    public static final class GetCurrentThreadIdNodeFactory implements NodeFactory<GetCurrentThreadIdNode> {

        private static final GetCurrentThreadIdNodeFactory GET_CURRENT_THREAD_ID_NODE_FACTORY_INSTANCE = new GetCurrentThreadIdNodeFactory();

        private GetCurrentThreadIdNodeFactory() {
        }

        @Override
        public Class<GetCurrentThreadIdNode> getNodeClass() {
            return GetCurrentThreadIdNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public GetCurrentThreadIdNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetCurrentThreadIdNode> getInstance() {
            return GET_CURRENT_THREAD_ID_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetCurrentThreadIdNode create(ReadArgumentNode[] arguments) {
            return new GetCurrentThreadIdNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetCurrentThreadIdNode#getId}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetCurrentThreadIdNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetCurrentThreadIdNodeGen extends GetCurrentThreadIdNode {

            private GetCurrentThreadIdNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return GetCurrentThreadIdNode.getId();
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(GetNativeIdNode.class)
    public static final class GetNativeIdNodeFactory implements NodeFactory<GetNativeIdNode> {

        private static final GetNativeIdNodeFactory GET_NATIVE_ID_NODE_FACTORY_INSTANCE = new GetNativeIdNodeFactory();

        private GetNativeIdNodeFactory() {
        }

        @Override
        public Class<GetNativeIdNode> getNodeClass() {
            return GetNativeIdNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public GetNativeIdNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetNativeIdNode> getInstance() {
            return GET_NATIVE_ID_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetNativeIdNode create(ReadArgumentNode[] arguments) {
            return new GetNativeIdNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetNativeIdNode#getId}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetNativeIdNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetNativeIdNodeGen extends GetNativeIdNode {

            private GetNativeIdNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return GetNativeIdNode.getId();
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(GetThreadCountNode.class)
    static final class GetThreadCountNodeFactory implements NodeFactory<GetThreadCountNode> {

        private static final GetThreadCountNodeFactory GET_THREAD_COUNT_NODE_FACTORY_INSTANCE = new GetThreadCountNodeFactory();

        private GetThreadCountNodeFactory() {
        }

        @Override
        public Class<GetThreadCountNode> getNodeClass() {
            return GetThreadCountNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetThreadCountNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetThreadCountNode> getInstance() {
            return GET_THREAD_COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetThreadCountNode create() {
            return new GetThreadCountNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetThreadCountNode#getCount}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetThreadCountNode.class)
        @SuppressWarnings("javadoc")
        static final class GetThreadCountNodeGen extends GetThreadCountNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetThreadCountNode#getCount}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetThreadCountNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadCountNode.getCount(PythonModule)] */ && arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule) arg0Value;
                    return getCount(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PythonModule) {
                    PythonModule arg0Value_ = (PythonModule) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.GetThreadCountNode.getCount(PythonModule)] */;
                    this.state_0_ = state_0;
                    return getCount(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetThreadStackSizeNode.class)
    static final class GetThreadStackSizeNodeFactory implements NodeFactory<GetThreadStackSizeNode> {

        private static final GetThreadStackSizeNodeFactory GET_THREAD_STACK_SIZE_NODE_FACTORY_INSTANCE = new GetThreadStackSizeNodeFactory();

        private GetThreadStackSizeNodeFactory() {
        }

        @Override
        public Class<GetThreadStackSizeNode> getNodeClass() {
            return GetThreadStackSizeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetThreadStackSizeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetThreadStackSizeNode> getInstance() {
            return GET_THREAD_STACK_SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetThreadStackSizeNode create() {
            return new GetThreadStackSizeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetThreadStackSizeNode#getStackSize(PNone)}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link GetThreadStackSizeNode#getStackSize(long, Node, Lazy)}
         *     Activation probability: 0.35000
         *     With/without class size: 12/5 bytes
         * </pre>
         */
        @GeneratedBy(GetThreadStackSizeNode.class)
        @SuppressWarnings("javadoc")
        static final class GetThreadStackSizeNodeGen extends GetThreadStackSizeNode {

            private static final StateField STATE_0_GetThreadStackSizeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetThreadStackSizeNode#getStackSize(long, Node, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_GET_STACK_SIZE1_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_GetThreadStackSizeNode_UPDATER.subUpdater(5, 1), ReferenceField.create(MethodHandles.lookup(), "getStackSize1_raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetThreadStackSizeNode#getStackSize(PNone)}
             *   1: SpecializationActive {@link GetThreadStackSizeNode#getStackSize(long, Node, Lazy)}
             *   2-4: ImplicitCast[type=long, index=0]
             *   5: InlinedCache
             *        Specialization: {@link GetThreadStackSizeNode#getStackSize(long, Node, Lazy)}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetThreadStackSizeNode#getStackSize(long, Node, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getStackSize1_raiseNode__field1_;

            private GetThreadStackSizeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(PNone)] || SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(long, Node, Lazy)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(PNone)] */ && arg0Value instanceof PNone) {
                        PNone arg0Value_ = (PNone) arg0Value;
                        return getStackSize(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(long, Node, Lazy)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100) >>> 2 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                        {
                            Node inliningTarget__ = (this);
                            return GetThreadStackSizeNode.getStackSize(arg0Value_, inliningTarget__, INLINED_GET_STACK_SIZE1_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PNone) {
                    PNone arg0Value_ = (PNone) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(PNone)] */;
                    this.state_0_ = state_0;
                    return getStackSize(arg0Value_);
                }
                {
                    Node inliningTarget__ = null;
                    int longCast0;
                    if ((longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                        inliningTarget__ = (this);
                        state_0 = (state_0 | (longCast0 << 2) /* set-int ImplicitCast[type=long, index=0] */);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ThreadModuleBuiltins.GetThreadStackSizeNode.getStackSize(long, Node, Lazy)] */;
                        this.state_0_ = state_0;
                        return GetThreadStackSizeNode.getStackSize(arg0Value_, inliningTarget__, INLINED_GET_STACK_SIZE1_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(StartNewThreadNode.class)
    static final class StartNewThreadNodeFactory implements NodeFactory<StartNewThreadNode> {

        private static final StartNewThreadNodeFactory START_NEW_THREAD_NODE_FACTORY_INSTANCE = new StartNewThreadNodeFactory();

        private StartNewThreadNodeFactory() {
        }

        @Override
        public Class<StartNewThreadNode> getNodeClass() {
            return StartNewThreadNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public StartNewThreadNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<StartNewThreadNode> getInstance() {
            return START_NEW_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StartNewThreadNode create(ReadArgumentNode[] arguments) {
            return new StartNewThreadNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link StartNewThreadNode#start}
         *     Activation probability: 1.00000
         *     With/without class size: 40/17 bytes
         * </pre>
         */
        @GeneratedBy(StartNewThreadNode.class)
        @SuppressWarnings("javadoc")
        static final class StartNewThreadNodeGen extends StartNewThreadNode {

            private static final StateField STATE_0_StartNewThreadNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link ExpandKeywordStarargsNode} getKwArgsNode
             *   Inline method: {@link ExpandKeywordStarargsNodeGen#inline}</pre>
             */
            private static final ExpandKeywordStarargsNode INLINED_GET_KW_ARGS_NODE_ = ExpandKeywordStarargsNodeGen.inline(InlineTarget.create(ExpandKeywordStarargsNode.class, STATE_0_StartNewThreadNode_UPDATER.subUpdater(1, 2), ReferenceField.create(MethodHandles.lookup(), "getKwArgsNode__field1_", Node.class)));

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link StartNewThreadNode#start}
             *   1-2: InlinedCache
             *        Specialization: {@link StartNewThreadNode#start}
             *        Parameter: {@link ExpandKeywordStarargsNode} getKwArgsNode
             *        Inline method: {@link ExpandKeywordStarargsNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link CallNode} callNode</pre>
             */
            @Child private CallNode callNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link ExecutePositionalStarargsNode} getArgsNode</pre>
             */
            @Child private ExecutePositionalStarargsNode getArgsNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link ExpandKeywordStarargsNode} getKwArgsNode
             *   Inline method: {@link ExpandKeywordStarargsNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getKwArgsNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link StartNewThreadNode#start}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;

            private StartNewThreadNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ThreadModuleBuiltins.StartNewThreadNode.start(VirtualFrame, Object, Object, Object, Object, Node, CallNode, ExecutePositionalStarargsNode, ExpandKeywordStarargsNode, PythonObjectFactory)] */) {
                    {
                        CallNode callNode__ = this.callNode_;
                        if (callNode__ != null) {
                            ExecutePositionalStarargsNode getArgsNode__ = this.getArgsNode_;
                            if (getArgsNode__ != null) {
                                PythonObjectFactory factory__ = this.factory_;
                                if (factory__ != null) {
                                    Node inliningTarget__ = (this);
                                    return start(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, inliningTarget__, callNode__, getArgsNode__, INLINED_GET_KW_ARGS_NODE_, factory__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    CallNode callNode__ = this.insert((CallNode.create()));
                    Objects.requireNonNull(callNode__, "Specialization 'start(VirtualFrame, Object, Object, Object, Object, Node, CallNode, ExecutePositionalStarargsNode, ExpandKeywordStarargsNode, PythonObjectFactory)' cache 'callNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.callNode_ = callNode__;
                    ExecutePositionalStarargsNode getArgsNode__ = this.insert((ExecutePositionalStarargsNode.create()));
                    Objects.requireNonNull(getArgsNode__, "Specialization 'start(VirtualFrame, Object, Object, Object, Object, Node, CallNode, ExecutePositionalStarargsNode, ExpandKeywordStarargsNode, PythonObjectFactory)' cache 'getArgsNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.getArgsNode_ = getArgsNode__;
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "Specialization 'start(VirtualFrame, Object, Object, Object, Object, Node, CallNode, ExecutePositionalStarargsNode, ExpandKeywordStarargsNode, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.StartNewThreadNode.start(VirtualFrame, Object, Object, Object, Object, Node, CallNode, ExecutePositionalStarargsNode, ExpandKeywordStarargsNode, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return start(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, inliningTarget__, callNode__, getArgsNode__, INLINED_GET_KW_ARGS_NODE_, factory__);
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(SetSentinelNode.class)
    static final class SetSentinelNodeFactory implements NodeFactory<SetSentinelNode> {

        private static final SetSentinelNodeFactory SET_SENTINEL_NODE_FACTORY_INSTANCE = new SetSentinelNodeFactory();

        private SetSentinelNodeFactory() {
        }

        @Override
        public Class<SetSentinelNode> getNodeClass() {
            return SetSentinelNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public SetSentinelNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<SetSentinelNode> getInstance() {
            return SET_SENTINEL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SetSentinelNode create(ReadArgumentNode[] arguments) {
            return new SetSentinelNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SetSentinelNode#setSentinel}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(SetSentinelNode.class)
        @SuppressWarnings("javadoc")
        static final class SetSentinelNodeGen extends SetSentinelNode {

            private SetSentinelNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return setSentinel();
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(InterruptMainThreadNode.class)
    static final class InterruptMainThreadNodeFactory implements NodeFactory<InterruptMainThreadNode> {

        private static final InterruptMainThreadNodeFactory INTERRUPT_MAIN_THREAD_NODE_FACTORY_INSTANCE = new InterruptMainThreadNodeFactory();

        private InterruptMainThreadNodeFactory() {
        }

        @Override
        public Class<InterruptMainThreadNode> getNodeClass() {
            return InterruptMainThreadNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public InterruptMainThreadNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<InterruptMainThreadNode> getInstance() {
            return INTERRUPT_MAIN_THREAD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static InterruptMainThreadNode create() {
            return new InterruptMainThreadNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link InterruptMainThreadNode#getCount}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(InterruptMainThreadNode.class)
        @SuppressWarnings("javadoc")
        static final class InterruptMainThreadNodeGen extends InterruptMainThreadNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InterruptMainThreadNode#getCount}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private InterruptMainThreadNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.InterruptMainThreadNode.getCount(int)] */ && arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    return getCount(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (int) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.InterruptMainThreadNode.getCount(int)] */;
                    this.state_0_ = state_0;
                    return getCount(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ExitNode.class)
    static final class ExitNodeFactory implements NodeFactory<ExitNode> {

        private static final ExitNodeFactory EXIT_NODE_FACTORY_INSTANCE = new ExitNodeFactory();

        private ExitNodeFactory() {
        }

        @Override
        public Class<ExitNode> getNodeClass() {
            return ExitNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList();
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public ExitNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ExitNode> getInstance() {
            return EXIT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ExitNode create(ReadArgumentNode[] arguments) {
            return new ExitNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ExitNode#exit}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(ExitNode.class)
        @SuppressWarnings("javadoc")
        static final class ExitNodeGen extends ExitNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ExitNode#exit}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ExitNode#exit}
             *   Parameter: {@link PRaiseNode} raiseNode</pre>
             */
            @Child private PRaiseNode raiseNode_;

            private ExitNodeGen(ReadArgumentNode[] arguments) {
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ThreadModuleBuiltins.ExitNode.exit(PRaiseNode)] */) {
                    {
                        PRaiseNode raiseNode__ = this.raiseNode_;
                        if (raiseNode__ != null) {
                            return exit(raiseNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize();
            }

            private Object executeAndSpecialize() {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "Specialization 'exit(PRaiseNode)' cache 'raiseNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[ThreadModuleBuiltins.ExitNode.exit(PRaiseNode)] */;
                this.state_0_ = state_0;
                return exit(raiseNode__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
