// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.array;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.VarHandle;

@GeneratedBy(PArray.class)
@SuppressWarnings("javadoc")
final class PArrayGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    static  {
        LibraryExport.register(PArray.class, new PythonBufferAcquireLibraryExports(), new PythonBufferAccessLibraryExports());
    }

    private PArrayGen() {
    }

    @GeneratedBy(PArray.class)
    private static final class PythonBufferAcquireLibraryExports extends LibraryExport<PythonBufferAcquireLibrary> {

        private static final Uncached UNCACHED = new Uncached();
        private static final Cached CACHE = new Cached();

        private PythonBufferAcquireLibraryExports() {
            super(PythonBufferAcquireLibrary.class, PArray.class, false, false, 0);
        }

        @Override
        protected PythonBufferAcquireLibrary createUncached(Object receiver) {
            assert receiver instanceof PArray;
            PythonBufferAcquireLibrary uncached = PythonBufferAcquireLibraryExports.UNCACHED;
            return uncached;
        }

        @Override
        protected PythonBufferAcquireLibrary createCached(Object receiver) {
            assert receiver instanceof PArray;
            return PythonBufferAcquireLibraryExports.CACHE;
        }

        @GeneratedBy(PArray.class)
        private static final class Cached extends PythonBufferAcquireLibrary {

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PArray) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PArray;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public boolean hasBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((PArray) receiver)).hasBuffer();
            }

            @Override
            public Object acquire(Object receiver, int flags) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (((PArray) receiver)).acquire(flags);
            }

        }
        @GeneratedBy(PArray.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAcquireLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PArray) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PArray;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PArray) receiver) .hasBuffer();
            }

            @TruffleBoundary
            @Override
            public Object acquire(Object receiver, int flags) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PArray) receiver) .acquire(flags);
            }

        }
    }
    @GeneratedBy(PArray.class)
    private static final class PythonBufferAccessLibraryExports extends LibraryExport<PythonBufferAccessLibrary> {

        private PythonBufferAccessLibraryExports() {
            super(PythonBufferAccessLibrary.class, PArray.class, false, false, 0);
        }

        @Override
        protected PythonBufferAccessLibrary createUncached(Object receiver) {
            assert receiver instanceof PArray;
            PythonBufferAccessLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected PythonBufferAccessLibrary createCached(Object receiver) {
            assert receiver instanceof PArray;
            return new Cached();
        }

        @GeneratedBy(PArray.class)
        private static final class Cached extends PythonBufferAccessLibrary {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PArray#hasInternalByteArray(PArray, PythonBufferAccessLibrary)}
             *   1: SpecializationActive {@link PArray#getInternalByteArray(PArray, PythonBufferAccessLibrary)}
             *   2: SpecializationActive {@link PArray#readByte(PArray, int, PythonBufferAccessLibrary)}
             *   3: SpecializationActive {@link PArray#writeByte(PArray, int, byte, PythonBufferAccessLibrary)}
             *   4: SpecializationActive {@link PArray#readShort(PArray, int, PythonBufferAccessLibrary)}
             *   5: SpecializationActive {@link PArray#writeShort(PArray, int, short, PythonBufferAccessLibrary)}
             *   6: SpecializationActive {@link PArray#readInt(PArray, int, PythonBufferAccessLibrary)}
             *   7: SpecializationActive {@link PArray#writeInt(PArray, int, int, PythonBufferAccessLibrary)}
             *   8: SpecializationActive {@link PArray#readLong(PArray, int, PythonBufferAccessLibrary)}
             *   9: SpecializationActive {@link PArray#writeLong(PArray, int, long, PythonBufferAccessLibrary)}
             *   10: SpecializationActive {@link PArray#readFloat(PArray, int, PythonBufferAccessLibrary)}
             *   11: SpecializationActive {@link PArray#writeFloat(PArray, int, float, PythonBufferAccessLibrary)}
             *   12: SpecializationActive {@link PArray#readDouble(PArray, int, PythonBufferAccessLibrary)}
             *   13: SpecializationActive {@link PArray#writeDouble(PArray, int, double, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PArray#hasInternalByteArray}
             *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
             */
            @Child private PythonBufferAccessLibrary bufferLib;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PArray) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PArray;
            }

            @Override
            public TruffleString getFormatString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PArray) receiver)).getFormatStringForBuffer();
            }

            @Override
            protected boolean isBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PArray) receiver)).isBuffer();
            }

            @Override
            public int getBufferLength(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PArray) receiver)).getBufferLength();
            }

            @Override
            public boolean isReadonly(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PArray) receiver)).isReadonly();
            }

            @Override
            public int getItemSize(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PArray) receiver)).getItemSize();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#hasInternalByteArray(PArray, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PArray.hasInternalByteArray(PArray, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.hasInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private boolean hasInternalByteArrayNode_AndSpecialize(PArray arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'hasInternalByteArray(PArray, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1 /* add SpecializationActive[PArray.hasInternalByteArray(PArray, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.hasInternalByteArray(bufferLib_);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#getInternalByteArray(PArray, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[PArray.getInternalByteArray(PArray, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.getInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private byte[] getInternalByteArrayNode_AndSpecialize(PArray arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'getInternalByteArray(PArray, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[PArray.getInternalByteArray(PArray, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.getInternalByteArray(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#readByte(PArray, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[PArray.readByte(PArray, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readByte(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readByteNode_AndSpecialize(PArray arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readByte(PArray, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[PArray.readByte(PArray, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readByte(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#writeByte(PArray, int, byte, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeByte(Object arg0Value_, int arg1Value, byte arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[PArray.writeByte(PArray, int, byte, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeByte(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeByteNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeByteNode_AndSpecialize(PArray arg0Value, int arg1Value, byte arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeByte(PArray, int, byte, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[PArray.writeByte(PArray, int, byte, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeByte(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#readShort(PArray, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short readShort(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[PArray.readShort(PArray, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readShort(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readShortNode_AndSpecialize(arg0Value, arg1Value);
            }

            private short readShortNode_AndSpecialize(PArray arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readShort(PArray, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[PArray.readShort(PArray, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readShort(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#writeShort(PArray, int, short, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeShort(Object arg0Value_, int arg1Value, short arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[PArray.writeShort(PArray, int, short, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeShort(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeShortNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeShortNode_AndSpecialize(PArray arg0Value, int arg1Value, short arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeShort(PArray, int, short, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[PArray.writeShort(PArray, int, short, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeShort(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#readInt(PArray, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int readInt(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[PArray.readInt(PArray, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readInt(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readIntNode_AndSpecialize(arg0Value, arg1Value);
            }

            private int readIntNode_AndSpecialize(PArray arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readInt(PArray, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[PArray.readInt(PArray, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readInt(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#writeInt(PArray, int, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeInt(Object arg0Value_, int arg1Value, int arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[PArray.writeInt(PArray, int, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeInt(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeIntNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeIntNode_AndSpecialize(PArray arg0Value, int arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeInt(PArray, int, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[PArray.writeInt(PArray, int, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeInt(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#readLong(PArray, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long readLong(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[PArray.readLong(PArray, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readLong(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readLongNode_AndSpecialize(arg0Value, arg1Value);
            }

            private long readLongNode_AndSpecialize(PArray arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readLong(PArray, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[PArray.readLong(PArray, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readLong(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#writeLong(PArray, int, long, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeLong(Object arg0Value_, int arg1Value, long arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[PArray.writeLong(PArray, int, long, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeLong(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeLongNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeLongNode_AndSpecialize(PArray arg0Value, int arg1Value, long arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeLong(PArray, int, long, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[PArray.writeLong(PArray, int, long, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeLong(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#readFloat(PArray, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float readFloat(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[PArray.readFloat(PArray, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readFloat(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatNode_AndSpecialize(PArray arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readFloat(PArray, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[PArray.readFloat(PArray, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readFloat(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#writeFloat(PArray, int, float, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeFloat(Object arg0Value_, int arg1Value, float arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[PArray.writeFloat(PArray, int, float, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeFloat(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeFloatNode_AndSpecialize(PArray arg0Value, int arg1Value, float arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeFloat(PArray, int, float, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[PArray.writeFloat(PArray, int, float, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeFloat(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#readDouble(PArray, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double readDouble(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[PArray.readDouble(PArray, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readDouble(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleNode_AndSpecialize(PArray arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readDouble(PArray, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[PArray.readDouble(PArray, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readDouble(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PArray#writeDouble(PArray, int, double, PythonBufferAccessLibrary)}
             *     Activation probability: 0.07143
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeDouble(Object arg0Value_, int arg1Value, double arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PArray arg0Value = ((PArray) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[PArray.writeDouble(PArray, int, double, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeDouble(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeDoubleNode_AndSpecialize(PArray arg0Value, int arg1Value, double arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(2)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeDouble(PArray, int, double, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[PArray.writeDouble(PArray, int, double, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeDouble(arg1Value, arg2Value, bufferLib_);
                return;
            }

        }
        @GeneratedBy(PArray.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAccessLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PArray) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PArray;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public TruffleString getFormatString(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PArray) receiver) .getFormatStringForBuffer();
            }

            @TruffleBoundary
            @Override
            protected boolean isBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PArray) receiver) .isBuffer();
            }

            @TruffleBoundary
            @Override
            public int getBufferLength(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PArray) receiver) .getBufferLength();
            }

            @TruffleBoundary
            @Override
            public boolean isReadonly(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PArray) receiver) .isReadonly();
            }

            @TruffleBoundary
            @Override
            public int getItemSize(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PArray) receiver) .getItemSize();
            }

            @TruffleBoundary
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.hasInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.getInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.readByte(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeByte(Object arg0Value_, int arg1Value, byte arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                arg0Value.writeByte(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public short readShort(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.readShort(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeShort(Object arg0Value_, int arg1Value, short arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                arg0Value.writeShort(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public int readInt(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.readInt(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeInt(Object arg0Value_, int arg1Value, int arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                arg0Value.writeInt(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public long readLong(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.readLong(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeLong(Object arg0Value_, int arg1Value, long arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                arg0Value.writeLong(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public float readFloat(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.readFloat(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeFloat(Object arg0Value_, int arg1Value, float arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                arg0Value.writeFloat(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public double readDouble(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                return arg0Value.readDouble(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeDouble(Object arg0Value_, int arg1Value, double arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PArray arg0Value = ((PArray) arg0Value_);
                arg0Value.writeDouble(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

        }
    }
}
