// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.memoryview;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes.ReleaseBufferNode;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodesFactory.ReleaseBufferNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.nio.ByteOrder;
import java.util.Objects;

@GeneratedBy(PMemoryView.class)
@SuppressWarnings("javadoc")
final class PMemoryViewGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    static  {
        LibraryExport.register(PMemoryView.class, new PythonBufferAcquireLibraryExports(), new PythonBufferAccessLibraryExports());
    }

    private PMemoryViewGen() {
    }

    @GeneratedBy(PMemoryView.class)
    private static final class PythonBufferAcquireLibraryExports extends LibraryExport<PythonBufferAcquireLibrary> {

        private PythonBufferAcquireLibraryExports() {
            super(PythonBufferAcquireLibrary.class, PMemoryView.class, false, false, 0);
        }

        @Override
        protected PythonBufferAcquireLibrary createUncached(Object receiver) {
            assert receiver instanceof PMemoryView;
            PythonBufferAcquireLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected PythonBufferAcquireLibrary createCached(Object receiver) {
            assert receiver instanceof PMemoryView;
            return new Cached();
        }

        @GeneratedBy(PMemoryView.class)
        private static final class Cached extends PythonBufferAcquireLibrary {

            private static final StateField STATE_0_AcquireNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#acquire(PMemoryView, int, Node, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_AcquireNode__UPDATER.subUpdater(0, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link PMemoryView#acquire}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#acquire(PMemoryView, int, Node, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @Override
            public boolean hasBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).hasBuffer();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#acquire(PMemoryView, int, Node, Lazy)}
             *     Activation probability: 1.00000
             *     With/without class size: 28/5 bytes
             * </pre>
             */
            @Override
            public Object acquire(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                {
                    Node inliningTarget__ = (this);
                    return arg0Value.acquire(arg1Value, inliningTarget__, INLINED_RAISE_NODE_);
                }
            }

        }
        @GeneratedBy(PMemoryView.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAcquireLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @TruffleBoundary
            @Override
            public boolean hasBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .hasBuffer();
            }

            @TruffleBoundary
            @Override
            public Object acquire(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.acquire(arg1Value, (this), (Lazy.getUncached()));
            }

        }
    }
    @GeneratedBy(PMemoryView.class)
    private static final class PythonBufferAccessLibraryExports extends LibraryExport<PythonBufferAccessLibrary> {

        private PythonBufferAccessLibraryExports() {
            super(PythonBufferAccessLibrary.class, PMemoryView.class, false, false, 0);
        }

        @Override
        protected PythonBufferAccessLibrary createUncached(Object receiver) {
            assert receiver instanceof PMemoryView;
            PythonBufferAccessLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected PythonBufferAccessLibrary createCached(Object receiver) {
            assert receiver instanceof PMemoryView;
            return new Cached();
        }

        @GeneratedBy(PMemoryView.class)
        private static final class Cached extends PythonBufferAccessLibrary {

            private static final StateField RELEASE__RELEASE_NODE__RELEASE_STATE_0_UPDATER = StateField.create(ReleaseNode_ReleaseData.lookup_(), "release_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
             *   Parameter: {@link ReleaseBufferNode} releaseNode
             *   Inline method: {@link ReleaseBufferNodeGen#inline}</pre>
             */
            private static final ReleaseBufferNode INLINED_RELEASE_NODE__RELEASE_RELEASE_NODE_ = ReleaseBufferNodeGen.inline(InlineTarget.create(ReleaseBufferNode.class, RELEASE__RELEASE_NODE__RELEASE_STATE_0_UPDATER.subUpdater(0, 3), ReferenceField.create(ReleaseNode_ReleaseData.lookup_(), "releaseNode__release_releaseNode__field1_", Node.class), ReferenceField.create(ReleaseNode_ReleaseData.lookup_(), "releaseNode__release_releaseNode__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
             *   1: SpecializationActive {@link PMemoryView#hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *   2: SpecializationActive {@link PMemoryView#getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *   3: SpecializationActive {@link PMemoryView#readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *   4: SpecializationActive {@link PMemoryView#writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *   5: SpecializationActive {@link PMemoryView#readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)}
             *   6: SpecializationActive {@link PMemoryView#readByte(PMemoryView, int, PythonBufferAccessLibrary)}
             *   7: SpecializationActive {@link PMemoryView#writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)}
             *   8: SpecializationActive {@link PMemoryView#readShortByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *   9: SpecializationActive {@link PMemoryView#writeShortByteOrder(PMemoryView, int, short, ByteOrder, PythonBufferAccessLibrary)}
             *   10: SpecializationActive {@link PMemoryView#readIntByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *   11: SpecializationActive {@link PMemoryView#writeIntByteOrder(PMemoryView, int, int, ByteOrder, PythonBufferAccessLibrary)}
             *   12: SpecializationActive {@link PMemoryView#readLongByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *   13: SpecializationActive {@link PMemoryView#writeLongByteOrder(PMemoryView, int, long, ByteOrder, PythonBufferAccessLibrary)}
             *   14: SpecializationActive {@link PMemoryView#readFloatByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *   15: SpecializationActive {@link PMemoryView#writeFloatByteOrder(PMemoryView, int, float, ByteOrder, PythonBufferAccessLibrary)}
             *   16: SpecializationActive {@link PMemoryView#readDoubleByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *   17: SpecializationActive {@link PMemoryView#writeDoubleByteOrder(PMemoryView, int, double, ByteOrder, PythonBufferAccessLibrary)}
             *   18: SpecializationActive {@link PMemoryView#isNative(PMemoryView, PythonBufferAccessLibrary)}
             *   19: SpecializationActive {@link PMemoryView#getNativePointer(PMemoryView, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#hasInternalByteArray}
             *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
             */
            @Child private PythonBufferAccessLibrary bufferLib;
            @Child private ReleaseNode_ReleaseData releaseNode__release_cache;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @Override
            public int getItemSize(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).getItemSize();
            }

            @Override
            public TruffleString getFormatString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).getFormatString();
            }

            @Override
            public boolean isBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).isBuffer();
            }

            @Override
            public int getBufferLength(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).getBufferLength();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
             *     Activation probability: 0.05000
             *     With/without class size: 5/13 bytes
             * </pre>
             */
            @Override
            public void release(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PMemoryView.release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)] */) {
                    ReleaseNode_ReleaseData s0_ = this.releaseNode__release_cache;
                    if (s0_ != null) {
                        {
                            Node inliningTarget__ = (s0_);
                            arg0Value.release(inliningTarget__, s0_.raiseNode_, INLINED_RELEASE_NODE__RELEASE_RELEASE_NODE_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                releaseNode_AndSpecialize(arg0Value);
                return;
            }

            private void releaseNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    ReleaseNode_ReleaseData s0_ = this.insert(new ReleaseNode_ReleaseData());
                    inliningTarget__ = (s0_);
                    PRaiseNode raiseNode__ = s0_.insert((PRaiseNode.create()));
                    Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.raiseNode_ = raiseNode__;
                    VarHandle.storeStoreFence();
                    this.releaseNode__release_cache = s0_;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[PMemoryView.release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)] */;
                    this.state_0_ = state_0;
                    arg0Value.release(inliningTarget__, raiseNode__, INLINED_RELEASE_NODE__RELEASE_RELEASE_NODE_);
                    return;
                }
            }

            @Override
            public boolean isReadonly(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).isReadonly();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[PMemoryView.hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.hasInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private boolean hasInternalByteArrayNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[PMemoryView.hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.hasInternalByteArray(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[PMemoryView.getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.getInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private byte[] getInternalByteArrayNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[PMemoryView.getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.getInternalByteArray(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void readIntoByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[PMemoryView.readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.readIntoByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                readIntoByteArrayNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                return;
            }

            private void readIntoByteArrayNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[PMemoryView.readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.readIntoByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeFromByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[PMemoryView.writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeFromByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeFromByteArrayNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                return;
            }

            private void writeFromByteArrayNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[PMemoryView.writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeFromByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void readIntoBuffer(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, PythonBufferAccessLibrary arg5Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[PMemoryView.readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.readIntoBuffer(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                readIntoBufferNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                return;
            }

            private void readIntoBufferNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, PythonBufferAccessLibrary arg5Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[PMemoryView.readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.readIntoBuffer(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readByte(PMemoryView, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[PMemoryView.readByte(PMemoryView, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readByte(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readByteNode_AndSpecialize(PMemoryView arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[PMemoryView.readByte(PMemoryView, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readByte(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeByte(Object arg0Value_, int arg1Value, byte arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[PMemoryView.writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeByte(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeByteNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeByteNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, byte arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[PMemoryView.writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeByte(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readShortByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short readShortByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[PMemoryView.readShortByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readShortByteOrder(arg1Value, arg2Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readShortByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private short readShortByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, ByteOrder arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[PMemoryView.readShortByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readShortByteOrder(arg1Value, arg2Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeShortByteOrder(PMemoryView, int, short, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeShortByteOrder(Object arg0Value_, int arg1Value, short arg2Value, ByteOrder arg3Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[PMemoryView.writeShortByteOrder(PMemoryView, int, short, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeShortByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeShortByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeShortByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, short arg2Value, ByteOrder arg3Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[PMemoryView.writeShortByteOrder(PMemoryView, int, short, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeShortByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readIntByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int readIntByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[PMemoryView.readIntByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readIntByteOrder(arg1Value, arg2Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readIntByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int readIntByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, ByteOrder arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[PMemoryView.readIntByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readIntByteOrder(arg1Value, arg2Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeIntByteOrder(PMemoryView, int, int, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeIntByteOrder(Object arg0Value_, int arg1Value, int arg2Value, ByteOrder arg3Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[PMemoryView.writeIntByteOrder(PMemoryView, int, int, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeIntByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeIntByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeIntByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, int arg2Value, ByteOrder arg3Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[PMemoryView.writeIntByteOrder(PMemoryView, int, int, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeIntByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readLongByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long readLongByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[PMemoryView.readLongByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readLongByteOrder(arg1Value, arg2Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readLongByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private long readLongByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, ByteOrder arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[PMemoryView.readLongByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readLongByteOrder(arg1Value, arg2Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeLongByteOrder(PMemoryView, int, long, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeLongByteOrder(Object arg0Value_, int arg1Value, long arg2Value, ByteOrder arg3Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[PMemoryView.writeLongByteOrder(PMemoryView, int, long, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeLongByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeLongByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeLongByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, long arg2Value, ByteOrder arg3Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[PMemoryView.writeLongByteOrder(PMemoryView, int, long, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeLongByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readFloatByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float readFloatByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[PMemoryView.readFloatByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readFloatByteOrder(arg1Value, arg2Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readFloatByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private float readFloatByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, ByteOrder arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[PMemoryView.readFloatByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readFloatByteOrder(arg1Value, arg2Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeFloatByteOrder(PMemoryView, int, float, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeFloatByteOrder(Object arg0Value_, int arg1Value, float arg2Value, ByteOrder arg3Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[PMemoryView.writeFloatByteOrder(PMemoryView, int, float, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeFloatByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeFloatByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeFloatByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, float arg2Value, ByteOrder arg3Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[PMemoryView.writeFloatByteOrder(PMemoryView, int, float, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeFloatByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readDoubleByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double readDoubleByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000) != 0 /* is SpecializationActive[PMemoryView.readDoubleByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readDoubleByteOrder(arg1Value, arg2Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readDoubleByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private double readDoubleByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, ByteOrder arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0x10000 /* add SpecializationActive[PMemoryView.readDoubleByteOrder(PMemoryView, int, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readDoubleByteOrder(arg1Value, arg2Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeDoubleByteOrder(PMemoryView, int, double, ByteOrder, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeDoubleByteOrder(Object arg0Value_, int arg1Value, double arg2Value, ByteOrder arg3Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000) != 0 /* is SpecializationActive[PMemoryView.writeDoubleByteOrder(PMemoryView, int, double, ByteOrder, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeDoubleByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeDoubleByteOrderNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeDoubleByteOrderNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, double arg2Value, ByteOrder arg3Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0x20000 /* add SpecializationActive[PMemoryView.writeDoubleByteOrder(PMemoryView, int, double, ByteOrder, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeDoubleByteOrder(arg1Value, arg2Value, arg3Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#isNative(PMemoryView, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isNative(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000) != 0 /* is SpecializationActive[PMemoryView.isNative(PMemoryView, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.isNative(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isNativeNode_AndSpecialize(arg0Value);
            }

            private boolean isNativeNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0x40000 /* add SpecializationActive[PMemoryView.isNative(PMemoryView, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.isNative(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#getNativePointer(PMemoryView, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05000
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getNativePointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x80000) != 0 /* is SpecializationActive[PMemoryView.getNativePointer(PMemoryView, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.getNativePointer(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getNativePointerNode_AndSpecialize(arg0Value);
            }

            private Object getNativePointerNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0x80000 /* add SpecializationActive[PMemoryView.getNativePointer(PMemoryView, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.getNativePointer(bufferLib_);
            }

            @GeneratedBy(PMemoryView.class)
            @DenyReplace
            private static final class ReleaseNode_ReleaseData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-2: InlinedCache
                 *        Specialization: {@link PMemoryView#release}
                 *        Parameter: {@link ReleaseBufferNode} releaseNode
                 *        Inline method: {@link ReleaseBufferNodeGen#inline}
                 * </pre>
                 */
                @CompilationFinal @UnsafeAccessedField private int release_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
                 *   Parameter: {@link PRaiseNode} raiseNode</pre>
                 */
                @Child PRaiseNode raiseNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
                 *   Parameter: {@link ReleaseBufferNode} releaseNode
                 *   Inline method: {@link ReleaseBufferNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node releaseNode__release_releaseNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
                 *   Parameter: {@link ReleaseBufferNode} releaseNode
                 *   Inline method: {@link ReleaseBufferNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node releaseNode__release_releaseNode__field2_;

                ReleaseNode_ReleaseData() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
        @GeneratedBy(PMemoryView.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAccessLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @TruffleBoundary
            @Override
            public int getItemSize(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .getItemSize();
            }

            @TruffleBoundary
            @Override
            public TruffleString getFormatString(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .getFormatString();
            }

            @TruffleBoundary
            @Override
            public boolean isBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .isBuffer();
            }

            @TruffleBoundary
            @Override
            public int getBufferLength(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .getBufferLength();
            }

            @TruffleBoundary
            @Override
            public void release(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.release((this), (PRaiseNode.getUncached()), (ReleaseBufferNodeGen.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isReadonly(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .isReadonly();
            }

            @TruffleBoundary
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.hasInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.getInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void readIntoByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.readIntoByteArray(arg1Value, arg2Value, arg3Value, arg4Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeFromByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeFromByteArray(arg1Value, arg2Value, arg3Value, arg4Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void readIntoBuffer(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, PythonBufferAccessLibrary arg5Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.readIntoBuffer(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readByte(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeByte(Object arg0Value_, int arg1Value, byte arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeByte(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public short readShortByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readShortByteOrder(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeShortByteOrder(Object arg0Value_, int arg1Value, short arg2Value, ByteOrder arg3Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeShortByteOrder(arg1Value, arg2Value, arg3Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public int readIntByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readIntByteOrder(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeIntByteOrder(Object arg0Value_, int arg1Value, int arg2Value, ByteOrder arg3Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeIntByteOrder(arg1Value, arg2Value, arg3Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public long readLongByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readLongByteOrder(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeLongByteOrder(Object arg0Value_, int arg1Value, long arg2Value, ByteOrder arg3Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeLongByteOrder(arg1Value, arg2Value, arg3Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public float readFloatByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readFloatByteOrder(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeFloatByteOrder(Object arg0Value_, int arg1Value, float arg2Value, ByteOrder arg3Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeFloatByteOrder(arg1Value, arg2Value, arg3Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public double readDoubleByteOrder(Object arg0Value_, int arg1Value, ByteOrder arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readDoubleByteOrder(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeDoubleByteOrder(Object arg0Value_, int arg1Value, double arg2Value, ByteOrder arg3Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeDoubleByteOrder(arg1Value, arg2Value, arg3Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isNative(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.isNative((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object getNativePointer(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.getNativePointer((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

        }
    }
}
