// CheckStyle: start generated
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link PyLongFromDoubleNode#doInt}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link PyLongFromDoubleNode#doLong}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link PyLongFromDoubleNode#doFinite}
 *     Activation probability: 0.20500
 *     With/without class size: 8/4 bytes
 *   Specialization {@link PyLongFromDoubleNode#doInfinite}
 *     Activation probability: 0.11500
 *     With/without class size: 6/4 bytes
 * </pre>
 */
@GeneratedBy(PyLongFromDoubleNode.class)
@SuppressWarnings("javadoc")
public final class PyLongFromDoubleNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException2LD(Node thisNode_, Object arg0Value, double arg1Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
    }

    @NeverDefault
    public static PyLongFromDoubleNode getUncached() {
        return PyLongFromDoubleNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#finite_factory_}
     * <li>{@link Inlined#infinite_raiseNode_}
     * </ul>
     */
    @NeverDefault
    public static PyLongFromDoubleNode inline(@RequiredField(bits = 4, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
        return new PyLongFromDoubleNodeGen.Inlined(target);
    }

    @GeneratedBy(PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Inlined extends PyLongFromDoubleNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link PyLongFromDoubleNode#doInt}
         *   1: SpecializationActive {@link PyLongFromDoubleNode#doLong}
         *   2: SpecializationActive {@link PyLongFromDoubleNode#doFinite}
         *   3: SpecializationActive {@link PyLongFromDoubleNode#doInfinite}
         * </pre>
         */
        private final StateField state_0_;
        private final ReferenceField<PythonObjectFactory> finite_factory_;
        private final ReferenceField<PRaiseNode> infinite_raiseNode_;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(PyLongFromDoubleNode.class);
            this.state_0_ = target.getState(0, 4);
            this.finite_factory_ = target.getReference(1, PythonObjectFactory.class);
            this.infinite_raiseNode_ = target.getReference(2, PRaiseNode.class);
        }

        @Override
        public Object execute(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0 /* is SpecializationActive[PyLongFromDoubleNode.doInt(double)] || SpecializationActive[PyLongFromDoubleNode.doLong(double)] || SpecializationActive[PyLongFromDoubleNode.doFinite(double, PythonObjectFactory)] || SpecializationActive[PyLongFromDoubleNode.doInfinite(double, PRaiseNode)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doInt(double)] */) {
                    if ((MathGuards.fitInt(arg1Value))) {
                        return PyLongFromDoubleNode.doInt(arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doLong(double)] */) {
                    if ((MathGuards.fitLong(arg1Value))) {
                        return PyLongFromDoubleNode.doLong(arg1Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doFinite(double, PythonObjectFactory)] */) {
                    {
                        PythonObjectFactory factory__ = this.finite_factory_.get(arg0Value);
                        if (factory__ != null) {
                            if ((!(MathGuards.fitLong(arg1Value))) && (PyLongFromDoubleNode.isFinite(arg1Value))) {
                                return PyLongFromDoubleNode.doFinite(arg1Value, factory__);
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[PyLongFromDoubleNode.doInfinite(double, PRaiseNode)] */) {
                    {
                        PRaiseNode raiseNode__ = this.infinite_raiseNode_.get(arg0Value);
                        if (raiseNode__ != null) {
                            if ((!(PyLongFromDoubleNode.isFinite(arg1Value)))) {
                                return PyLongFromDoubleNode.doInfinite(arg1Value, raiseNode__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Node arg0Value, double arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((MathGuards.fitInt(arg1Value))) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[PyLongFromDoubleNode.doInt(double)] */;
                this.state_0_.set(arg0Value, state_0);
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if ((MathGuards.fitLong(arg1Value))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[PyLongFromDoubleNode.doLong(double)] */;
                this.state_0_.set(arg0Value, state_0);
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            if ((!(MathGuards.fitLong(arg1Value))) && (PyLongFromDoubleNode.isFinite(arg1Value))) {
                PythonObjectFactory factory__ = arg0Value.insert((PythonObjectFactory.create()));
                Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.finite_factory_.set(arg0Value, factory__);
                state_0 = state_0 | 0b100 /* add SpecializationActive[PyLongFromDoubleNode.doFinite(double, PythonObjectFactory)] */;
                this.state_0_.set(arg0Value, state_0);
                return PyLongFromDoubleNode.doFinite(arg1Value, factory__);
            }
            if ((!(PyLongFromDoubleNode.isFinite(arg1Value)))) {
                PRaiseNode raiseNode__ = arg0Value.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.infinite_raiseNode_.set(arg0Value, raiseNode__);
                state_0 = state_0 | 0b1000 /* add SpecializationActive[PyLongFromDoubleNode.doInfinite(double, PRaiseNode)] */;
                this.state_0_.set(arg0Value, state_0);
                return PyLongFromDoubleNode.doInfinite(arg1Value, raiseNode__);
            }
            throw newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }

    }
    @GeneratedBy(PyLongFromDoubleNode.class)
    @DenyReplace
    private static final class Uncached extends PyLongFromDoubleNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public Object execute(Node arg0Value, double arg1Value) {
            if ((MathGuards.fitInt(arg1Value))) {
                return PyLongFromDoubleNode.doInt(arg1Value);
            }
            if ((MathGuards.fitLong(arg1Value))) {
                return PyLongFromDoubleNode.doLong(arg1Value);
            }
            if ((!(MathGuards.fitLong(arg1Value))) && (PyLongFromDoubleNode.isFinite(arg1Value))) {
                return PyLongFromDoubleNode.doFinite(arg1Value, (PythonObjectFactory.getUncached()));
            }
            if ((!(PyLongFromDoubleNode.isFinite(arg1Value)))) {
                return PyLongFromDoubleNode.doInfinite(arg1Value, (PRaiseNode.getUncached()));
            }
            throw newUnsupportedSpecializationException2LD(this, arg0Value, arg1Value);
        }

    }
}
