// CheckStyle: start generated
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;

/**
 * Debug Info: <pre>
 *   Specialization {@link PyTupleCheckExactNode#doBuiltinTuple}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link PyTupleCheckExactNode#doOther}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(PyTupleCheckExactNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class PyTupleCheckExactNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static PyTupleCheckExactNode getUncached() {
        return PyTupleCheckExactNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul>
     */
    @NeverDefault
    public static PyTupleCheckExactNode inline(@RequiredField(bits = 2, value = StateField.class) InlineTarget target) {
        return new PyTupleCheckExactNodeGen.Inlined(target);
    }

    @GeneratedBy(PyTupleCheckExactNode.class)
    @DenyReplace
    private static final class Inlined extends PyTupleCheckExactNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link PyTupleCheckExactNode#doBuiltinTuple}
         *   1: SpecializationActive {@link PyTupleCheckExactNode#doOther}
         * </pre>
         */
        private final StateField state_0_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(PyTupleCheckExactNode.class);
            this.state_0_ = target.getState(0, 2);
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof PTuple) {
                PTuple arg1Value_ = (PTuple) arg1Value;
                if ((PGuards.isBuiltinTuple(arg1Value_))) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0 /* is SpecializationActive[PyTupleCheckExactNode.doBuiltinTuple(PTuple)] || SpecializationActive[PyTupleCheckExactNode.doOther(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PyTupleCheckExactNode.doBuiltinTuple(PTuple)] */ && arg1Value instanceof PTuple) {
                    PTuple arg1Value_ = (PTuple) arg1Value;
                    if ((PGuards.isBuiltinTuple(arg1Value_))) {
                        return PyTupleCheckExactNode.doBuiltinTuple(arg1Value_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[PyTupleCheckExactNode.doOther(Object)] */) {
                    if (fallbackGuard_(arg0Value, arg1Value)) {
                        return PyTupleCheckExactNode.doOther(arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof PTuple) {
                PTuple arg1Value_ = (PTuple) arg1Value;
                if ((PGuards.isBuiltinTuple(arg1Value_))) {
                    state_0 = state_0 | 0b1 /* add SpecializationActive[PyTupleCheckExactNode.doBuiltinTuple(PTuple)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return PyTupleCheckExactNode.doBuiltinTuple(arg1Value_);
                }
            }
            state_0 = state_0 | 0b10 /* add SpecializationActive[PyTupleCheckExactNode.doOther(Object)] */;
            this.state_0_.set(arg0Value, state_0);
            return PyTupleCheckExactNode.doOther(arg1Value);
        }

    }
    @GeneratedBy(PyTupleCheckExactNode.class)
    @DenyReplace
    private static final class Uncached extends PyTupleCheckExactNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof PTuple) {
                PTuple arg1Value_ = (PTuple) arg1Value;
                if ((PGuards.isBuiltinTuple(arg1Value_))) {
                    return PyTupleCheckExactNode.doBuiltinTuple(arg1Value_);
                }
            }
            return PyTupleCheckExactNode.doOther(arg1Value);
        }

    }
}
