// CheckStyle: start generated
package com.oracle.graal.python.nodes.bytecode.instrumentation;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.Node;

@GeneratedBy(InstrumentedBytecodeStatement.class)
final class InstrumentedBytecodeStatementWrapper extends InstrumentedBytecodeStatement implements WrapperNode {

    @Child private InstrumentedBytecodeStatement delegateNode;
    @Child private ProbeNode probeNode;

    InstrumentedBytecodeStatementWrapper(InstrumentedBytecodeStatement delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public InstrumentedBytecodeStatement getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public void execute(@SuppressWarnings("unused") VirtualFrame frame) {
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, null);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    break;
                }
                throw t;
            }
        }
    }

    @Override
    public void insertHelperNode(Node node, int bci) {
        this.delegateNode.insertHelperNode(node, bci);
    }

    @Override
    void setContainsBreakpoint() {
        this.delegateNode.setContainsBreakpoint();
    }

    @Override
    void coversBci(int bci, int length) {
        this.delegateNode.coversBci(bci, length);
    }

}
