// CheckStyle: start generated
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;

/**
 * Debug Info: <pre>
 *   Specialization {@link CastToJavaIntNode#toInt}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link CastToJavaIntNode#doUnsupported}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(CastToJavaIntNode.class)
@SuppressWarnings({"javadoc", "unused"})
final class CastToJavaIntNodeGen {

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul>
     */
    @NeverDefault
    public static CastToJavaIntNode inline(@RequiredField(bits = 4, value = StateField.class) InlineTarget target) {
        return new CastToJavaIntNodeGen.Inlined(target);
    }

    @GeneratedBy(CastToJavaIntNode.class)
    @DenyReplace
    private static final class Inlined extends CastToJavaIntNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link CastToJavaIntNode#toInt}
         *   1: SpecializationActive {@link CastToJavaIntNode#doUnsupported}
         *   2-3: ImplicitCast[type=int, index=1]
         * </pre>
         */
        private final StateField state_0_;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(CastToJavaIntNode.class);
            this.state_0_ = target.getState(0, 4);
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(Node arg0Value, Object arg1Value) {
            if (PythonArithmeticTypesGen.isImplicitInteger(arg1Value)) {
                return false;
            }
            return true;
        }

        @Override
        public int execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b11) != 0 /* is SpecializationActive[CastToJavaIntNode.toInt(int)] || SpecializationActive[CastToJavaIntNode.doUnsupported(Object)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaIntNode.toInt(int)] */ && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b1100) >>> 2 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b1100) >>> 2 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                    return CastToJavaIntNode.toInt(arg1Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaIntNode.doUnsupported(Object)] */) {
                    if (fallbackGuard_(arg0Value, arg1Value)) {
                        return CastToJavaIntNode.doUnsupported(arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public int execute(Node arg0Value, long arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaIntNode.doUnsupported(Object)] */) {
                if (fallbackGuard_(arg0Value, arg1Value)) {
                    return CastToJavaIntNode.doUnsupported(arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            {
                int intCast1;
                if ((intCast1 = PythonArithmeticTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast1, arg1Value);
                    state_0 = (state_0 | (intCast1 << 2) /* set-int ImplicitCast[type=int, index=1] */);
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CastToJavaIntNode.toInt(int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CastToJavaIntNode.toInt(arg1Value_);
                }
            }
            state_0 = state_0 | 0b10 /* add SpecializationActive[CastToJavaIntNode.doUnsupported(Object)] */;
            this.state_0_.set(arg0Value, state_0);
            return CastToJavaIntNode.doUnsupported(arg1Value);
        }

    }
}
