// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.DetachNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.EncodingNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.ErrorsNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.NewlinesNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.ReadNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.ReadlineNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.WriteNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(TextIOBaseBuiltins.class)
@SuppressWarnings("javadoc")
public final class TextIOBaseBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(DetachNodeFactory.getInstance(), ReadNodeFactory.getInstance(), ReadlineNodeFactory.getInstance(), WriteNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), NewlinesNodeFactory.getInstance(), ErrorsNodeFactory.getInstance());
    }

    @GeneratedBy(DetachNode.class)
    static final class DetachNodeFactory implements NodeFactory<DetachNode> {

        private static final DetachNodeFactory DETACH_NODE_FACTORY_INSTANCE = new DetachNodeFactory();

        private DetachNodeFactory() {
        }

        @Override
        public Class<DetachNode> getNodeClass() {
            return DetachNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public DetachNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<DetachNode> getInstance() {
            return DETACH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DetachNode create(ReadArgumentNode[] arguments) {
            return new DetachNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DetachNode#detach}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(DetachNode.class)
        @SuppressWarnings("javadoc")
        static final class DetachNodeGen extends DetachNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DetachNode#detach}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link DetachNode#detach}
             *   Parameter: {@link PRaiseNode} raiseNode</pre> */
            @Child private PRaiseNode raiseNode_;

            private DetachNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[TextIOBaseBuiltins.DetachNode.detach(Object, PRaiseNode)] */) {
                    {
                        PRaiseNode raiseNode__ = this.raiseNode_;
                        if (raiseNode__ != null) {
                            return DetachNode.detach(arguments0Value_, raiseNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[TextIOBaseBuiltins.DetachNode.detach(Object, PRaiseNode)] */;
                this.state_0_ = state_0;
                return DetachNode.detach(arguments0Value, raiseNode__);
            }

        }
    }
    @GeneratedBy(ReadNode.class)
    static final class ReadNodeFactory implements NodeFactory<ReadNode> {

        private static final ReadNodeFactory READ_NODE_FACTORY_INSTANCE = new ReadNodeFactory();

        private ReadNodeFactory() {
        }

        @Override
        public Class<ReadNode> getNodeClass() {
            return ReadNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ReadNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReadNode> getInstance() {
            return READ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReadNode create(ReadArgumentNode[] arguments) {
            return new ReadNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReadNode#read}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(ReadNode.class)
        @SuppressWarnings("javadoc")
        static final class ReadNodeGen extends ReadNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReadNode#read}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadNode#read}
             *   Parameter: {@link PRaiseNode} raiseNode</pre> */
            @Child private PRaiseNode raiseNode_;

            private ReadNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[TextIOBaseBuiltins.ReadNode.read(Object, Object, PRaiseNode)] */) {
                    {
                        PRaiseNode raiseNode__ = this.raiseNode_;
                        if (raiseNode__ != null) {
                            return ReadNode.read(arguments0Value_, arguments1Value_, raiseNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[TextIOBaseBuiltins.ReadNode.read(Object, Object, PRaiseNode)] */;
                this.state_0_ = state_0;
                return ReadNode.read(arguments0Value, arguments1Value, raiseNode__);
            }

        }
    }
    @GeneratedBy(ReadlineNode.class)
    static final class ReadlineNodeFactory implements NodeFactory<ReadlineNode> {

        private static final ReadlineNodeFactory READLINE_NODE_FACTORY_INSTANCE = new ReadlineNodeFactory();

        private ReadlineNodeFactory() {
        }

        @Override
        public Class<ReadlineNode> getNodeClass() {
            return ReadlineNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public ReadlineNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReadlineNode> getInstance() {
            return READLINE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReadlineNode create(ReadArgumentNode[] arguments) {
            return new ReadlineNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReadlineNode#read}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(ReadlineNode.class)
        @SuppressWarnings("javadoc")
        static final class ReadlineNodeGen extends ReadlineNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReadlineNode#read}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadlineNode#read}
             *   Parameter: {@link PRaiseNode} raiseNode</pre> */
            @Child private PRaiseNode raiseNode_;

            private ReadlineNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[TextIOBaseBuiltins.ReadlineNode.read(Object, Object, PRaiseNode)] */) {
                    {
                        PRaiseNode raiseNode__ = this.raiseNode_;
                        if (raiseNode__ != null) {
                            return ReadlineNode.read(arguments0Value_, arguments1Value_, raiseNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[TextIOBaseBuiltins.ReadlineNode.read(Object, Object, PRaiseNode)] */;
                this.state_0_ = state_0;
                return ReadlineNode.read(arguments0Value, arguments1Value, raiseNode__);
            }

        }
    }
    @GeneratedBy(WriteNode.class)
    static final class WriteNodeFactory implements NodeFactory<WriteNode> {

        private static final WriteNodeFactory WRITE_NODE_FACTORY_INSTANCE = new WriteNodeFactory();

        private WriteNodeFactory() {
        }

        @Override
        public Class<WriteNode> getNodeClass() {
            return WriteNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public WriteNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<WriteNode> getInstance() {
            return WRITE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static WriteNode create(ReadArgumentNode[] arguments) {
            return new WriteNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link WriteNode#write}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre> */
        @GeneratedBy(WriteNode.class)
        @SuppressWarnings("javadoc")
        static final class WriteNodeGen extends WriteNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link WriteNode#write}
             * </pre> */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteNode#write}
             *   Parameter: {@link PRaiseNode} raiseNode</pre> */
            @Child private PRaiseNode raiseNode_;

            private WriteNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[TextIOBaseBuiltins.WriteNode.write(Object, Object, PRaiseNode)] */) {
                    {
                        PRaiseNode raiseNode__ = this.raiseNode_;
                        if (raiseNode__ != null) {
                            return WriteNode.write(arguments0Value_, arguments1Value_, raiseNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[TextIOBaseBuiltins.WriteNode.write(Object, Object, PRaiseNode)] */;
                this.state_0_ = state_0;
                return WriteNode.write(arguments0Value, arguments1Value, raiseNode__);
            }

        }
    }
    @GeneratedBy(EncodingNode.class)
    static final class EncodingNodeFactory implements NodeFactory<EncodingNode> {

        private static final EncodingNodeFactory ENCODING_NODE_FACTORY_INSTANCE = new EncodingNodeFactory();

        private EncodingNodeFactory() {
        }

        @Override
        public Class<EncodingNode> getNodeClass() {
            return EncodingNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public EncodingNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<EncodingNode> getInstance() {
            return ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNode create() {
            return new EncodingNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link EncodingNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(EncodingNode.class)
        @SuppressWarnings("javadoc")
        static final class EncodingNodeGen extends EncodingNode {

            private EncodingNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return EncodingNode.doit(arg0Value);
            }

        }
    }
    @GeneratedBy(NewlinesNode.class)
    static final class NewlinesNodeFactory implements NodeFactory<NewlinesNode> {

        private static final NewlinesNodeFactory NEWLINES_NODE_FACTORY_INSTANCE = new NewlinesNodeFactory();

        private NewlinesNodeFactory() {
        }

        @Override
        public Class<NewlinesNode> getNodeClass() {
            return NewlinesNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public NewlinesNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NewlinesNode> getInstance() {
            return NEWLINES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NewlinesNode create() {
            return new NewlinesNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NewlinesNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(NewlinesNode.class)
        @SuppressWarnings("javadoc")
        static final class NewlinesNodeGen extends NewlinesNode {

            private NewlinesNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return NewlinesNode.doit(arg0Value);
            }

        }
    }
    @GeneratedBy(ErrorsNode.class)
    static final class ErrorsNodeFactory implements NodeFactory<ErrorsNode> {

        private static final ErrorsNodeFactory ERRORS_NODE_FACTORY_INSTANCE = new ErrorsNodeFactory();

        private ErrorsNodeFactory() {
        }

        @Override
        public Class<ErrorsNode> getNodeClass() {
            return ErrorsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public ErrorsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ErrorsNode> getInstance() {
            return ERRORS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ErrorsNode create() {
            return new ErrorsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ErrorsNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre> */
        @GeneratedBy(ErrorsNode.class)
        @SuppressWarnings("javadoc")
        static final class ErrorsNodeGen extends ErrorsNode {

            private ErrorsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return ErrorsNode.doit(arg0Value);
            }

        }
    }
}
