// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.floats;

import com.oracle.graal.python.builtins.objects.floats.FloatUtils.PFloatUnboxing;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@GeneratedBy(PFloatUnboxing.class)
public final class PFloatUnboxingGen extends PFloatUnboxing {

    protected PFloatUnboxingGen() {
    }

    public static double expectImplicitDouble(int state, Object value) throws UnexpectedResultException {
        if ((state & 0b1) != 0 && value instanceof Double) {
            return (double) value;
        } else if ((state & 0b10) != 0 && value instanceof PFloat) {
            return PFloatToDouble((PFloat) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(value);
        }
    }

    public static boolean isImplicitDouble(int state, Object value) {
        return ((state & 0b1) != 0 && value instanceof Double)
             || ((state & 0b10) != 0 && value instanceof PFloat);
    }

    public static boolean isImplicitDouble(Object value) {
        return value instanceof Double
             || value instanceof PFloat;
    }

    public static double asImplicitDouble(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return asImplicitDouble(value);
        }
        if ((state & 0b1) != 0 && value instanceof Double) {
            return (double) value;
        } else if ((state & 0b10) != 0 && value instanceof PFloat) {
            return PFloatToDouble((PFloat) value);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static double asImplicitDouble(Object value) {
        if (value instanceof Double) {
            return (double) value;
        } else if (value instanceof PFloat) {
            return PFloatToDouble((PFloat) value);
        } else {
            throw new IllegalArgumentException("Illegal implicit source type.");
        }
    }

    public static int specializeImplicitDouble(Object value) {
        if (value instanceof Double) {
            return 0b1;
        } else if (value instanceof PFloat) {
            return 0b10;
        } else {
            return 0;
        }
    }

}
