/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.PolyglotModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.PolyglotModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.interop.InteropBehavior;
import com.oracle.graal.python.nodes.interop.InteropBehaviorMethod;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.GetForeignObjectClassNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Map;

@CoreFunctions(defineModule="polyglot")
public final class PolyglotModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_READ_SIDE_EFFECTS = PythonUtils.tsLiteral("read-side-effects");
    private static final TruffleString T_WRITE_SIDE_EFFECTS = PythonUtils.tsLiteral("write-side-effects");
    private static final TruffleString T_EXISTS = PythonUtils.tsLiteral("exists");
    private static final TruffleString T_INSERTABLE = PythonUtils.tsLiteral("insertable");
    private static final TruffleString T_REMOVABLE = PythonUtils.tsLiteral("removable");
    private static final TruffleString T_MODIFIABLE = PythonUtils.tsLiteral("modifiable");
    private static final TruffleString T_INVOKABLE = PythonUtils.tsLiteral("invokable");
    private static final TruffleString T_INTERNAL = PythonUtils.tsLiteral("internal");
    private static final TruffleString T_INTERNAL_POLYGLOT_MODULE = PythonUtils.tsLiteral("_polyglot");
    @CompilerDirectives.CompilationFinal
    static InteropLibrary UNCACHED_INTEROP;

    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PolyglotModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        PythonContext context = core.getContext();
        TruffleLanguage.Env env = context.getEnv();
        TruffleString coreHome = context.getCoreHome();
        try {
            TruffleFile coreDir = env.getInternalTruffleFile(coreHome.toJavaStringUncached());
            TruffleFile docDir = coreDir.resolveSibling("docs");
            if (docDir.exists(new LinkOption[0]) || docDir.getParent() != null && (docDir = coreDir.getParent().resolveSibling("docs")).exists(new LinkOption[0])) {
                this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)new String(docDir.resolve("user").resolve("Interoperability.md").readAllBytes()));
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        GetForeignObjectClassNode.getUncached().defineSingleTraitClasses();
        AbstractImportNode.importModule(T_INTERNAL_POLYGLOT_MODULE);
    }

    static InteropLibrary getInterop() {
        if (UNCACHED_INTEROP == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            UNCACHED_INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        }
        return UNCACHED_INTEROP;
    }

    public static void clearInteropTypeRegistryCache(PythonContext pythonContext) {
        pythonContext.getLanguage().noInteropTypeRegisteredAssumption.invalidate();
        pythonContext.interopTypeRegistryCacheValidAssumption.invalidate();
        pythonContext.interopGeneratedClassCache.clear();
    }

    @Builtin(name="storage", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class StorageNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doSequence(PSequence seq, @Bind(value="this") Node inliningTarget) {
            Object arrayObject;
            SequenceStorage storage = seq.getSequenceStorage();
            if (storage instanceof EmptySequenceStorage) {
                arrayObject = seq instanceof PBytesLike ? PythonUtils.EMPTY_BYTE_ARRAY : (byte[])PythonUtils.EMPTY_OBJECT_ARRAY;
            } else if (storage instanceof ArrayBasedSequenceStorage) {
                ArrayBasedSequenceStorage basicStorage = (ArrayBasedSequenceStorage)storage;
                arrayObject = basicStorage.getInternalArrayObject();
            } else {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.GETTING_POLYGLOT_STORAGE_FOR_NATIVE_STORAGE_NOT_IMPLEMENTED);
            }
            return PythonContext.get(inliningTarget).getEnv().asGuestValue(arrayObject);
        }

        @Fallback
        static Object doError(Object object, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_P, object);
        }
    }

    @Builtin(name="__element_info__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class ArrayElementInfoNode
    extends PythonBuiltinNode {
        @Specialization
        static boolean keyInfo(Object receiver, long member, TruffleString info, @Cached TruffleString.EqualNode equalNode) {
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_EXISTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementExisting(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_READABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementReadable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_WRITABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementWritable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INSERTABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementInsertable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_REMOVABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementRemovable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_MODIFIABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementModifiable(receiver, member);
            }
            return false;
        }
    }

    @Builtin(name="__keys__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class KeysNode
    extends PythonBuiltinNode {
        @Specialization
        static Object remove(Object receiver, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PolyglotModuleBuiltins.getInterop().getMembers(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, (Exception)((Object)e));
            }
        }
    }

    @Builtin(name="__key_info__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class KeyInfoNode
    extends PythonBuiltinNode {
        @Specialization
        static boolean keyInfo(Object receiver, TruffleString tmember, TruffleString info, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.EqualNode equalNode) {
            String member = toJavaStringNode.execute((AbstractTruffleString)tmember);
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_READ_SIDE_EFFECTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().hasMemberReadSideEffects(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_WRITE_SIDE_EFFECTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().hasMemberWriteSideEffects(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_EXISTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberExisting(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_READABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberReadable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_WRITABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberWritable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INSERTABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberInsertable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_REMOVABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberRemovable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_MODIFIABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberModifiable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INVOKABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberInvocable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INTERNAL, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberInternal(receiver, member);
            }
            return false;
        }
    }

    @Builtin(name="__has_keys__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HasKeysNode
    extends PythonBuiltinNode {
        @Specialization
        static boolean hasKeys(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().hasMembers(receiver);
        }
    }

    @Builtin(name="__is_boxed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsBoxedNode
    extends PythonBuiltinNode {
        @Specialization
        static boolean isBoxed(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().isString(receiver) || PolyglotModuleBuiltins.getInterop().fitsInDouble(receiver) || PolyglotModuleBuiltins.getInterop().fitsInLong(receiver);
        }
    }

    @Builtin(name="__get_size__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetSizeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object getSize(Object receiver, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PolyglotModuleBuiltins.getInterop().getArraySize(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, (Exception)((Object)e));
            }
        }
    }

    @Builtin(name="__has_size__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HasSizeNode
    extends PythonBuiltinNode {
        @Specialization
        static boolean hasSize(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().hasArrayElements(receiver);
        }
    }

    @Builtin(name="__is_null__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsNullNode
    extends PythonBuiltinNode {
        @Specialization
        static boolean isNull(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().isNull(receiver);
        }
    }

    @Builtin(name="__invoke__", minNumOfPositionalArgs=2, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class invokeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object invoke(Object receiver, TruffleString key, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PolyglotModuleBuiltins.getInterop().invokeMember(receiver, toJavaStringNode.execute((AbstractTruffleString)key), arguments);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class newNode
    extends PythonBuiltinNode {
        @Specialization
        static Object instantiate(Object receiver, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PolyglotModuleBuiltins.getInterop().instantiate(receiver, arguments);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="__execute__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class executeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object exec(Object receiver, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PolyglotModuleBuiltins.getInterop().execute(receiver, arguments);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="__remove__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class removeNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object remove(Object receiver, Object key) {
            block5: {
                try {
                    if (key instanceof TruffleString) {
                        PolyglotModuleBuiltins.getInterop().removeMember(receiver, ((TruffleString)key).toJavaStringUncached());
                        break block5;
                    }
                    if (TruffleStringMigrationHelpers.isJavaString(key)) {
                        PolyglotModuleBuiltins.getInterop().removeMember(receiver, (String)key);
                        break block5;
                    }
                    if (key instanceof Number) {
                        PolyglotModuleBuiltins.getInterop().removeArrayElement(receiver, ((Number)key).longValue());
                        break block5;
                    }
                    throw PRaiseNode.raiseUncached(this, PythonErrorType.AttributeError, ErrorMessages.UNKNOWN_ATTR, key);
                }
                catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                    throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.AttributeError, (Exception)e);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__write__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class WriteNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object write(Object receiver, Object key, Object value) {
            block5: {
                try {
                    if (key instanceof TruffleString) {
                        PolyglotModuleBuiltins.getInterop().writeMember(receiver, ((TruffleString)key).toJavaStringUncached(), value);
                        break block5;
                    }
                    if (TruffleStringMigrationHelpers.isJavaString(key)) {
                        PolyglotModuleBuiltins.getInterop().writeMember(receiver, (String)key, value);
                        break block5;
                    }
                    if (key instanceof Number) {
                        PolyglotModuleBuiltins.getInterop().writeArrayElement(receiver, ((Number)key).longValue(), value);
                        break block5;
                    }
                    throw PRaiseNode.raiseUncached(this, PythonErrorType.AttributeError, ErrorMessages.UNKNOWN_ATTR, key);
                }
                catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.AttributeError, (Exception)e);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__read__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReadNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object read(Object receiver, Object key) {
            try {
                if (key instanceof TruffleString) {
                    return PolyglotModuleBuiltins.getInterop().readMember(receiver, ((TruffleString)key).toJavaStringUncached());
                }
                if (TruffleStringMigrationHelpers.isJavaString(key)) {
                    return PolyglotModuleBuiltins.getInterop().readMember(receiver, (String)key);
                }
                if (key instanceof Number) {
                    return PolyglotModuleBuiltins.getInterop().readArrayElement(receiver, ((Number)key).longValue());
                }
                throw PRaiseNode.raiseUncached(this, PythonErrorType.AttributeError, ErrorMessages.UNKNOWN_ATTR, key);
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="register_interop_type", minNumOfPositionalArgs=2, parameterNames={"foreign_class", "python_class"}, takesVarKeywordArgs=true, keywordOnlyNames={"allow_method_overwrites"}, doc="register_interop_type(foreign_class, python_class, allow_method_overwrites=False)\n\nRegisters the python class for the given foreign_class.\nEvery instance of foreign_class or its subclasses will be treated as an instance of pythonClass.\n\nMultiple registrations per foreign_class are allowed.\nIf two registered classes for the same foreign_class define the same method, an error will be raised.\nIf allow_method_overwrites=True, defining the same method is explicitly allowed.\nIn case of method conflicts, the newest registered class \"wins\".\n\nExample registering a custom interop type for the java class YourClass\n\n>>> from polyglot import register_interop_type\n>>> import java\n\n>>> class JYourClass:\n...     def __str__(self):\n...         return self.getClass().getSimpleName()\n\n>>> YourClass = java.type(\"fully.qualified.package.path.YourClass\")\n>>> register_interop_type(YourClass, JYourClass)\n>>> yourClassObject = YourClass()\n>>> print(yourClassObject)\nYourClass\n\nPer default registering classes with the same methods for one foreign_class raises an error.\nIf you want to overwrite methods defined in JYourClass use \"allow_method_overwrites=True\":\n\n>>> class NewJYourClass:\n...     def __str__(self):\n...         return self.getClass().getName()\n\n>>> register_interop_type(YourClass, NewJYourClass, allow_method_overwrites=True)\n\n>>> print(yourClassObject)  # Note: yourClassObject is still the same instance\nfully.qualified.package.path.YourClass\n")
    @GenerateNodeFactory
    @ArgumentClinic(name="allow_method_overwrites", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false", useDefaultForNone=true)
    public static abstract class RegisterInteropTypeNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PolyglotModuleBuiltinsClinicProviders.RegisterInteropTypeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object register(Object foreignClass, PythonClass pythonClass, boolean allowMethodOverwrites, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isClassTypeNode, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interopLibrary, @Cached ObjectHashMap.PutNode putNode, @Cached ObjectHashMap.GetNode getNode, @Cached PRaiseNode raiseNode) {
            foreignClass = RegisterInteropTypeNode.checkAndCleanForeignClass(foreignClass, interopLibrary, raiseNode, this.getContext().getEnv());
            if (!isClassTypeNode.execute(inliningTarget, pythonClass)) {
                throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "second", "a python class", pythonClass);
            }
            ObjectHashMap interopTypeRegistry = this.getContext().interopTypeRegistry;
            try {
                Object possibleClasses = getNode.execute(null, inliningTarget, interopTypeRegistry, foreignClass, interopLibrary.identityHashCode(foreignClass));
                if (possibleClasses == null) {
                    putNode.put(null, inliningTarget, interopTypeRegistry, foreignClass, interopLibrary.identityHashCode(foreignClass), new PythonClass[]{pythonClass});
                } else if (possibleClasses instanceof PythonManagedClass[]) {
                    PythonManagedClass[] registeredClasses = (PythonManagedClass[])possibleClasses;
                    if (RegisterInteropTypeNode.checkIfAlreadyRegistered(pythonClass, registeredClasses, interopLibrary)) {
                        throw raiseNode.raise(PythonErrorType.KeyError, ErrorMessages.INTEROP_TYPE_ALREADY_REGISTERED, interopLibrary.getMetaQualifiedName(foreignClass));
                    }
                    if (!allowMethodOverwrites) {
                        RegisterInteropTypeNode.checkForMethodConflict(pythonClass, registeredClasses, raiseNode);
                    }
                    PythonManagedClass[] newClasses = new PythonManagedClass[registeredClasses.length + 1];
                    newClasses[0] = pythonClass;
                    System.arraycopy(registeredClasses, 0, newClasses, 1, registeredClasses.length);
                    putNode.put(null, inliningTarget, interopTypeRegistry, foreignClass, interopLibrary.identityHashCode(foreignClass), newClasses);
                } else {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                PolyglotModuleBuiltins.clearInteropTypeRegistryCache(this.getContext());
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            return PNone.NONE;
        }

        private static boolean checkIfAlreadyRegistered(PythonManagedClass pythonManagedClass, PythonManagedClass[] registeredClasses, InteropLibrary interopLibrary) {
            for (PythonManagedClass registeredClass : registeredClasses) {
                if (!interopLibrary.isIdentical((Object)registeredClass, (Object)pythonManagedClass, interopLibrary)) continue;
                return true;
            }
            return false;
        }

        private static void checkForMethodConflict(PythonManagedClass toCheck, PythonManagedClass[] registeredClasses, PRaiseNode raiseNode) {
            for (TruffleString name : toCheck.getAttributeNames()) {
                if (!(toCheck.getAttribute(name) instanceof PFunction)) continue;
                for (PythonManagedClass registeredClass : registeredClasses) {
                    if (!(registeredClass.getAttribute(name) instanceof PFunction)) continue;
                    throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.INTEROP_TYPE_NOT_MERGABLE, toCheck, registeredClass, name);
                }
            }
        }

        private static Object checkAndCleanForeignClass(Object object, InteropLibrary interopLibrary, PRaiseNode raiseNode, TruffleLanguage.Env env) {
            if (!interopLibrary.isMetaObject(object)) {
                throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "first", "a class or interface", object);
            }
            if (!env.isHostObject(object)) {
                return object;
            }
            String memberClass = "class";
            try {
                if (interopLibrary.isMemberExisting(object, "class") && interopLibrary.isMemberReadable(object, "class")) {
                    object = interopLibrary.readMember(object, "class");
                }
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            return object;
        }
    }

    @Builtin(name="register_interop_behavior", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1, takesVarKeywordArgs=true, keywordOnlyNames={"is_boolean", "is_date", "is_duration", "is_iterator", "is_number", "is_string", "is_time", "is_time_zone", "is_executable", "fits_in_big_integer", "fits_in_byte", "fits_in_double", "fits_in_float", "fits_in_int", "fits_in_long", "fits_in_short", "as_big_integer", "as_boolean", "as_byte", "as_date", "as_double", "as_duration", "as_float", "as_int", "as_long", "as_short", "as_string", "as_time", "as_time_zone", "execute", "read_array_element", "get_array_size", "has_array_elements", "is_array_element_readable", "is_array_element_modifiable", "is_array_element_insertable", "is_array_element_removable", "remove_array_element", "write_array_element", "has_iterator", "has_iterator_next_element", "get_iterator", "get_iterator_next_element", "has_hash_entries", "get_hash_entries_iterator", "get_hash_keys_iterator", "get_hash_size", "get_hash_values_iterator", "is_hash_entry_readable", "is_hash_entry_modifiable", "is_hash_entry_insertable", "is_hash_entry_removable", "read_hash_value", "write_hash_entry", "remove_hash_entry"}, doc="register_interop_behavior(type, is_boolean=None, is_date=None, is_duration=None, is_iterator=None, is_number=None, is_string=None, is_time=None,\nis_time_zone=None, is_executable=None, fits_in_big_integer=None, fits_in_byte=None, fits_in_double=None, fits_in_float=None, fits_in_int=None,\nfits_in_long=None, fits_in_short=None, as_big_integer=None, as_boolean=None, as_byte=None, as_date=None, as_double=None, as_duration=None, as_float=None,\nas_int=None, as_long=None, as_short=None, as_string=None, as_time=None, as_time_zone=None, execute=None, read_array_element=None, get_array_size=None,\nhas_array_elements=None, is_array_element_readable=None, is_array_element_modifiable=None, is_array_element_insertable=None, is_array_element_removable=None,\nremove_array_element=None, write_array_element=None, has_iterator=None, has_iterator_next_element=None, get_iterator=None, get_iterator_next_element=None,\nhas_hash_entries=None, get_hash_entries_iterator=None, get_hash_keys_iterator=None, get_hash_size=None, get_hash_values_iterator=None, is_hash_entry_readable=None,\nis_hash_entry_modifiable=None, is_hash_entry_insertable=None, is_hash_entry_removable=None, read_hash_value=None, write_hash_entry=None, remove_hash_entry=None)\n\nRegisters the specified interop behavior with the passed type. The extensions are directly mapped to the Truffle (host) Interop 2.0 protocol.\nMost Truffle InteropLibrary messages (http://www.graalvm.org/truffle/javadoc/com/oracle/truffle/api/interop/InteropLibrary.html) are supported (see keyword parameter list).\n\nExample extending the interop behavior for iterators:\n\n>>> from polyglot import register_interop_behavior\n\n>>> class MyType(object):\n...     data = [0,1,2]\n\n>>> register_interop_behavior(MyType, is_iterator=False, has_iterator=True, get_iterator=lambda t: iter(t.data))\n")
    @GenerateNodeFactory
    public static abstract class RegisterInteropBehaviorNode
    extends PythonBuiltinNode {
        void handleArg(Object value, InteropBehaviorMethod method, InteropBehavior interopBehavior, PRaiseNode raiseNode) {
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                interopBehavior.defineBehavior(method, boolValue);
            } else if (value instanceof PFunction) {
                PFunction function = (PFunction)value;
                interopBehavior.defineBehavior(method, function);
                Signature signature = function.getCode().getSignature();
                if (function.getKwDefaults().length != 0) {
                    throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, method.name);
                }
                if (function.getCode().getCellVars().length != 0) {
                    throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_CANNOT_HAVE_S, method.name, "cell vars");
                }
                if (function.getCode().getFreeVars().length != 0) {
                    throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_CANNOT_HAVE_S, method.name, "free vars");
                }
                if (method.takesVarArgs != signature.takesVarArgs()) {
                    throw raiseNode.raise(PythonErrorType.ValueError, method.takesVarArgs ? ErrorMessages.S_TAKES_VARARGS : ErrorMessages.S_DOES_NOT_TAKE_VARARGS, method.name);
                }
                if (signature.getMaxNumOfPositionalArgs() != method.getNumPositionalArguments()) {
                    throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_TAKES_EXACTLY_D_ARGS, method.name, method.getNumPositionalArguments(), signature.getMaxNumOfPositionalArgs());
                }
            }
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object register(PythonAbstractObject receiver, Object is_boolean, Object is_date, Object is_duration, Object is_iterator, Object is_number, Object is_string, Object is_time, Object is_time_zone, Object is_executable, Object fits_in_big_integer, Object fits_in_byte, Object fits_in_double, Object fits_in_float, Object fits_in_int, Object fits_in_long, Object fits_in_short, Object as_big_integer, Object as_boolean, Object as_byte, Object as_date, Object as_double, Object as_duration, Object as_float, Object as_int, Object as_long, Object as_short, Object as_string, Object as_time, Object as_time_zone, Object execute, Object read_array_element, Object get_array_size, Object has_array_elements, Object is_array_element_readable, Object is_array_element_modifiable, Object is_array_element_insertable, Object is_array_element_removable, Object remove_array_element, Object write_array_element, Object has_iterator, Object has_iterator_next_element, Object get_iterator, Object get_iterator_next_element, Object has_hash_entries, Object get_hash_entries_iterator, Object get_hash_keys_iterator, Object get_hash_size, Object get_hash_values_iterator, Object is_hash_entry_readable, Object is_hash_entry_modifiable, Object is_hash_entry_insertable, Object is_hash_entry_removable, Object read_hash_value, Object write_hash_entry, Object remove_hash_entry, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PRaiseNode raiseNode) {
            if (isTypeNode.execute(inliningTarget, receiver)) {
                InteropBehavior interopBehavior = new InteropBehavior(receiver);
                this.handleArg(is_boolean, InteropBehaviorMethod.is_boolean, interopBehavior, raiseNode);
                this.handleArg(is_date, InteropBehaviorMethod.is_date, interopBehavior, raiseNode);
                this.handleArg(is_duration, InteropBehaviorMethod.is_duration, interopBehavior, raiseNode);
                this.handleArg(is_iterator, InteropBehaviorMethod.is_iterator, interopBehavior, raiseNode);
                this.handleArg(is_number, InteropBehaviorMethod.is_number, interopBehavior, raiseNode);
                this.handleArg(is_string, InteropBehaviorMethod.is_string, interopBehavior, raiseNode);
                this.handleArg(is_time, InteropBehaviorMethod.is_time, interopBehavior, raiseNode);
                this.handleArg(is_time_zone, InteropBehaviorMethod.is_time_zone, interopBehavior, raiseNode);
                this.handleArg(is_executable, InteropBehaviorMethod.is_executable, interopBehavior, raiseNode);
                this.handleArg(fits_in_big_integer, InteropBehaviorMethod.fits_in_big_integer, interopBehavior, raiseNode);
                this.handleArg(fits_in_byte, InteropBehaviorMethod.fits_in_byte, interopBehavior, raiseNode);
                this.handleArg(fits_in_double, InteropBehaviorMethod.fits_in_double, interopBehavior, raiseNode);
                this.handleArg(fits_in_float, InteropBehaviorMethod.fits_in_float, interopBehavior, raiseNode);
                this.handleArg(fits_in_int, InteropBehaviorMethod.fits_in_int, interopBehavior, raiseNode);
                this.handleArg(fits_in_long, InteropBehaviorMethod.fits_in_long, interopBehavior, raiseNode);
                this.handleArg(fits_in_short, InteropBehaviorMethod.fits_in_short, interopBehavior, raiseNode);
                this.handleArg(as_big_integer, InteropBehaviorMethod.as_big_integer, interopBehavior, raiseNode);
                this.handleArg(as_boolean, InteropBehaviorMethod.as_boolean, interopBehavior, raiseNode);
                this.handleArg(as_byte, InteropBehaviorMethod.as_byte, interopBehavior, raiseNode);
                this.handleArg(as_date, InteropBehaviorMethod.as_date, interopBehavior, raiseNode);
                this.handleArg(as_double, InteropBehaviorMethod.as_double, interopBehavior, raiseNode);
                this.handleArg(as_duration, InteropBehaviorMethod.as_duration, interopBehavior, raiseNode);
                this.handleArg(as_float, InteropBehaviorMethod.as_float, interopBehavior, raiseNode);
                this.handleArg(as_int, InteropBehaviorMethod.as_int, interopBehavior, raiseNode);
                this.handleArg(as_long, InteropBehaviorMethod.as_long, interopBehavior, raiseNode);
                this.handleArg(as_short, InteropBehaviorMethod.as_short, interopBehavior, raiseNode);
                this.handleArg(as_string, InteropBehaviorMethod.as_string, interopBehavior, raiseNode);
                this.handleArg(as_time, InteropBehaviorMethod.as_time, interopBehavior, raiseNode);
                this.handleArg(as_time_zone, InteropBehaviorMethod.as_time_zone, interopBehavior, raiseNode);
                this.handleArg(execute, InteropBehaviorMethod.execute, interopBehavior, raiseNode);
                this.handleArg(read_array_element, InteropBehaviorMethod.read_array_element, interopBehavior, raiseNode);
                this.handleArg(get_array_size, InteropBehaviorMethod.get_array_size, interopBehavior, raiseNode);
                this.handleArg(has_array_elements, InteropBehaviorMethod.has_array_elements, interopBehavior, raiseNode);
                this.handleArg(is_array_element_readable, InteropBehaviorMethod.is_array_element_readable, interopBehavior, raiseNode);
                this.handleArg(is_array_element_modifiable, InteropBehaviorMethod.is_array_element_modifiable, interopBehavior, raiseNode);
                this.handleArg(is_array_element_insertable, InteropBehaviorMethod.is_array_element_insertable, interopBehavior, raiseNode);
                this.handleArg(is_array_element_removable, InteropBehaviorMethod.is_array_element_removable, interopBehavior, raiseNode);
                this.handleArg(remove_array_element, InteropBehaviorMethod.remove_array_element, interopBehavior, raiseNode);
                this.handleArg(write_array_element, InteropBehaviorMethod.write_array_element, interopBehavior, raiseNode);
                this.handleArg(has_iterator, InteropBehaviorMethod.has_iterator, interopBehavior, raiseNode);
                this.handleArg(has_iterator_next_element, InteropBehaviorMethod.has_iterator_next_element, interopBehavior, raiseNode);
                this.handleArg(get_iterator, InteropBehaviorMethod.get_iterator, interopBehavior, raiseNode);
                this.handleArg(get_iterator_next_element, InteropBehaviorMethod.get_iterator_next_element, interopBehavior, raiseNode);
                this.handleArg(has_hash_entries, InteropBehaviorMethod.has_hash_entries, interopBehavior, raiseNode);
                this.handleArg(get_hash_entries_iterator, InteropBehaviorMethod.get_hash_entries_iterator, interopBehavior, raiseNode);
                this.handleArg(get_hash_keys_iterator, InteropBehaviorMethod.get_hash_keys_iterator, interopBehavior, raiseNode);
                this.handleArg(get_hash_size, InteropBehaviorMethod.get_hash_size, interopBehavior, raiseNode);
                this.handleArg(get_hash_values_iterator, InteropBehaviorMethod.get_hash_values_iterator, interopBehavior, raiseNode);
                this.handleArg(is_hash_entry_readable, InteropBehaviorMethod.is_hash_entry_readable, interopBehavior, raiseNode);
                this.handleArg(is_hash_entry_modifiable, InteropBehaviorMethod.is_hash_entry_modifiable, interopBehavior, raiseNode);
                this.handleArg(is_hash_entry_insertable, InteropBehaviorMethod.is_hash_entry_insertable, interopBehavior, raiseNode);
                this.handleArg(is_hash_entry_removable, InteropBehaviorMethod.is_hash_entry_removable, interopBehavior, raiseNode);
                this.handleArg(read_hash_value, InteropBehaviorMethod.read_hash_value, interopBehavior, raiseNode);
                this.handleArg(write_hash_entry, InteropBehaviorMethod.write_hash_entry, interopBehavior, raiseNode);
                this.handleArg(remove_hash_entry, InteropBehaviorMethod.remove_hash_entry, interopBehavior, raiseNode);
                HiddenAttr.WriteNode.executeUncached(receiver, HiddenAttr.HOST_INTEROP_BEHAVIOR, interopBehavior);
                return PNone.NONE;
            }
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "first", "a type", receiver);
        }
    }

    @Builtin(name="get_registered_interop_behavior", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetRegisteredInteropBehaviorNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PList get(PythonAbstractObject klass, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode raiseNode, @Cached HiddenAttr.ReadNode readHiddenAttrNode) {
            if (isTypeNode.execute(inliningTarget, klass)) {
                Object value = readHiddenAttrNode.execute(inliningTarget, klass, HiddenAttr.HOST_INTEROP_BEHAVIOR, null);
                if (value instanceof InteropBehavior) {
                    InteropBehavior behavior = (InteropBehavior)value;
                    return factory.createList(behavior.getDefinedMethods());
                }
                return factory.createList();
            }
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "first", "a type", klass);
        }
    }

    @Builtin(name="fits_in_double", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FitsInDoubleNode
    extends FitsInNumberNode {
        static int PRECISION = 53;
        static long MIN = -((long)Math.pow(2.0, PRECISION));
        static long MAX = (long)Math.pow(2.0, PRECISION) - 1L;

        static boolean fits(long number) {
            return number >= MIN && number <= MAX;
        }

        @Specialization
        static boolean check(int number) {
            return true;
        }

        @Specialization
        static boolean check(long number) {
            return FitsInDoubleNode.fits(number);
        }

        @Specialization
        static boolean check(double number) {
            return true;
        }

        @Specialization
        static boolean check(PInt number, @CachedLibrary(limit="1") InteropLibrary ilib) {
            return ilib.fitsInDouble((Object)number);
        }
    }

    @Builtin(name="fits_in_float", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FitsInFloatNode
    extends FitsInNumberNode {
        static int PRECISION = 24;
        static long MIN = -((long)Math.pow(2.0, PRECISION));
        static long MAX = (long)Math.pow(2.0, PRECISION) - 1L;

        static boolean fits(long number) {
            return number >= MIN && number <= MAX;
        }

        @Specialization
        static boolean check(int number) {
            return FitsInFloatNode.fits(number);
        }

        @Specialization
        static boolean check(long number) {
            return FitsInFloatNode.fits(number);
        }

        @Specialization
        static boolean check(double number) {
            return !Double.isFinite(number) || (double)((float)number) == number;
        }

        @Specialization
        static boolean check(PInt number, @CachedLibrary(limit="1") InteropLibrary ilib) {
            return ilib.fitsInFloat((Object)number);
        }
    }

    @Builtin(name="fits_in_big_integer", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FitsInBigIntegerNode
    extends FitsInNumberNode {
        @Specialization
        static boolean check(int number) {
            return true;
        }

        @Specialization
        static boolean check(long number) {
            return true;
        }

        @Specialization
        static boolean check(double number) {
            return FitsInBigIntegerNode.isWhole(number);
        }

        @Specialization
        static boolean check(PInt number) {
            return true;
        }
    }

    @Builtin(name="fits_in_long", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FitsInLongNode
    extends FitsInNumberNode {
        @Specialization
        static boolean check(int number) {
            return true;
        }

        @Specialization
        static boolean check(long number) {
            return true;
        }

        @Specialization
        static boolean check(double number) {
            return FitsInLongNode.isWhole(number);
        }

        @Specialization
        static boolean check(PInt number, @CachedLibrary(limit="1") InteropLibrary ilib) {
            return ilib.fitsInLong((Object)number);
        }
    }

    @Builtin(name="fits_in_int", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FitsInIntNode
    extends FitsInNumberNode {
        static boolean fits(long number) {
            return number >= Integer.MIN_VALUE && number < Integer.MAX_VALUE;
        }

        @Specialization
        static boolean check(int number) {
            return true;
        }

        @Specialization
        static boolean check(long number) {
            return FitsInIntNode.fits(number);
        }

        @Specialization
        static boolean check(double number) {
            if (FitsInIntNode.isWhole(number)) {
                return FitsInIntNode.fits((long)number);
            }
            return false;
        }

        @Specialization
        static boolean check(PInt number, @CachedLibrary(limit="1") InteropLibrary ilib) {
            return ilib.fitsInInt((Object)number);
        }
    }

    @Builtin(name="fits_in_short", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FitsInShortNode
    extends FitsInNumberNode {
        static boolean fits(long number) {
            return number >= -32768L && number < 32767L;
        }

        @Specialization
        static boolean check(int number) {
            return FitsInShortNode.fits(number);
        }

        @Specialization
        static boolean check(long number) {
            return FitsInShortNode.fits(number);
        }

        @Specialization
        static boolean check(double number) {
            if (FitsInShortNode.isWhole(number)) {
                return FitsInShortNode.fits((long)number);
            }
            return false;
        }

        @Specialization
        static boolean check(PInt number, @CachedLibrary(limit="1") InteropLibrary ilib) {
            return ilib.fitsInShort((Object)number);
        }
    }

    @Builtin(name="fits_in_byte", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FitsInByteNode
    extends FitsInNumberNode {
        static boolean fits(long number) {
            return number >= 0L && number < 256L;
        }

        @Specialization
        static boolean check(int number) {
            return FitsInByteNode.fits(number);
        }

        @Specialization
        static boolean check(long number) {
            return FitsInByteNode.fits(number);
        }

        @Specialization
        static boolean check(double number) {
            if (FitsInByteNode.isWhole(number)) {
                return FitsInByteNode.fits((long)number);
            }
            return false;
        }

        @Specialization
        static boolean check(PInt number, @CachedLibrary(limit="1") InteropLibrary ilib) {
            return ilib.fitsInByte((Object)number);
        }
    }

    static abstract class FitsInNumberNode
    extends PythonUnaryBuiltinNode {
        FitsInNumberNode() {
        }

        static boolean isSupportedNumber(Object number) {
            return number instanceof Number || number instanceof PInt;
        }

        static boolean isWhole(double number) {
            return !(number % 1.0 > 0.0);
        }

        @Specialization(guards={"!isSupportedNumber(number)"})
        static boolean unsupported(PythonAbstractObject number, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_NUMBER, "given", number);
        }
    }

    @Builtin(name="export_value", minNumOfPositionalArgs=1, parameterNames={"name", "value"})
    @GenerateNodeFactory
    public static abstract class ExportSymbolNode
    extends PythonBuiltinNode {
        private static final TruffleLogger LOGGER = PythonLanguage.getLogger(ExportSymbolNode.class);

        @Specialization(guards={"!isString(value)"})
        @CompilerDirectives.TruffleBoundary
        Object exportSymbolKeyValue(TruffleString name, Object value) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(name.toJavaStringUncached(), value);
            return value;
        }

        @Specialization(guards={"!isString(value)"})
        @CompilerDirectives.TruffleBoundary
        Object exportSymbolValueKey(Object value, TruffleString name) {
            LOGGER.warning("[deprecation] polyglot.export_value(value, name) is deprecated and will be removed. Please swap the arguments.");
            return this.exportSymbolKeyValue(name, value);
        }

        @Specialization(guards={"isString(arg1)"})
        @CompilerDirectives.TruffleBoundary
        Object exportSymbolAmbiguous(Object arg1, TruffleString arg2) {
            LOGGER.warning("[deprecation] polyglot.export_value(str, str) is ambiguous. In the future, this will default to using the first argument as the name and the second as value, but now it uses the first argument as value and the second as the name.");
            return this.exportSymbolValueKey(arg1, arg2);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object exportSymbol(PFunction fun, PNone name) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(fun.getName().toJavaStringUncached(), (Object)fun);
            return fun;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object exportSymbol(PBuiltinFunction fun, PNone name) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(fun.getName().toJavaStringUncached(), (Object)fun);
            return fun;
        }

        @Specialization(guards={"isModuleMethod(fun)"})
        static Object exportSymbol(VirtualFrame frame, Object fun, PNone name, @Bind(value="this") Node inliningTarget, @Cached(value="create(T___NAME__)") GetAttributeNode.GetFixedAttributeNode getNameAttributeNode, @Cached CastToJavaStringNode castToStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            String methodName;
            Object attrNameValue = getNameAttributeNode.executeObject(frame, fun);
            try {
                methodName = castToStringNode.execute(attrNameValue);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.METHOD_NAME_MUST_BE, attrNameValue);
            }
            ExportSymbolNode.export(inliningTarget, methodName, fun);
            return fun;
        }

        @Fallback
        static Object exportSymbol(Object value, Object name, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_ARG_TYPES_S_S_BUT_NOT_P_P, "function", "object, str", value, name);
        }

        protected static boolean isModuleMethod(Object o) {
            PBuiltinMethod bm;
            PMethod m;
            return o instanceof PMethod && (m = (PMethod)o).getSelf() instanceof PythonModule || o instanceof PBuiltinMethod && (bm = (PBuiltinMethod)o).getSelf() instanceof PythonModule;
        }

        @CompilerDirectives.TruffleBoundary
        private static void export(Node raisingNode, String name, Object obj) {
            TruffleLanguage.Env env = PythonContext.get(raisingNode).getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(name, obj);
        }
    }

    @Builtin(name="eval", minNumOfPositionalArgs=0, parameterNames={"path", "string", "language"})
    @GenerateNodeFactory
    static abstract class EvalInteropNode
    extends PythonTernaryBuiltinNode {
        EvalInteropNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object eval(Object pathObj, Object stringObj, Object languageObj) {
            LanguageInfo language;
            boolean hasPath;
            if (languageObj instanceof PNone) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.ValueError, ErrorMessages.POLYGLOT_EVAL_MUST_PASS_LANG_AND_STRING_OR_PATH);
            }
            boolean hasString = !(stringObj instanceof PNone);
            boolean bl = hasPath = !(pathObj instanceof PNone);
            if (!hasString && !hasPath || hasString && hasPath) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.ValueError, ErrorMessages.POLYGLOT_EVAL_MUST_PASS_LANG_AND_STRING_OR_PATH);
            }
            String languageName = this.toJavaString(languageObj, "language");
            String string = hasString ? this.toJavaString(stringObj, "string") : null;
            String path = hasPath ? this.toJavaString(pathObj, "path") : null;
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotEvalAllowed(null)) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.RuntimeError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            Map languages = env.getPublicLanguages();
            String mimeType = null;
            if (EvalInteropNode.isMimeType(languageName)) {
                mimeType = languageName;
                languageName = EvalInteropNode.findLanguageByMimeType(languages, languageName);
            }
            if ((language = (LanguageInfo)languages.get(languageName)) == null) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.ValueError, ErrorMessages.POLYGLOT_LANGUAGE_S_NOT_FOUND, languageName);
            }
            if (!env.isPolyglotEvalAllowed(language)) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.RuntimeError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED_FOR_LANGUAGE_S, languageName);
            }
            try {
                Object builder = hasString ? Source.newBuilder((String)languageName, (CharSequence)string, (String)string) : Source.newBuilder((String)languageName, (TruffleFile)env.getPublicTruffleFile(path)).name(path);
                if (mimeType != null) {
                    builder = builder.mimeType(mimeType);
                }
                Object result = env.parsePublic(builder.build(), new String[0]).call(new Object[0]);
                return PForeignToPTypeNode.getUncached().executeConvert(result);
            }
            catch (AbstractTruffleException e) {
                throw e;
            }
            catch (IOException e) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.OSError, ErrorMessages.S, e);
            }
            catch (RuntimeException e) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.RuntimeError, e);
            }
        }

        private String toJavaString(Object object, String parameterName) {
            try {
                return CastToJavaStringNode.getUncached().execute(object);
            }
            catch (CannotCastException e) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.TypeError, ErrorMessages.S_BRACKETS_ARG_S_MUST_BE_S_NOT_P, "polyglot.eval", parameterName, "str", object);
            }
        }

        private static String findLanguageByMimeType(Map<String, LanguageInfo> languages, String mimeType) {
            for (String language : languages.keySet()) {
                for (String registeredMimeType : languages.get(language).getMimeTypes()) {
                    if (!mimeType.equals(registeredMimeType)) continue;
                    return language;
                }
            }
            return null;
        }

        private static boolean isMimeType(String lang) {
            return lang.contains("/");
        }
    }

    @Builtin(name="import_value", minNumOfPositionalArgs=1, parameterNames={"name"})
    @GenerateNodeFactory
    public static abstract class ImportNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object importSymbol(TruffleString name, @Cached PForeignToPTypeNode convert) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            Object object = env.importSymbol(name.toJavaStringUncached());
            if (object == null) {
                return PNone.NONE;
            }
            return convert.executeConvert(object);
        }
    }
}

