/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.enumerate;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public final class PEnumerate
extends PythonBuiltinObject {
    private final Object iterator;
    private long index;
    private PInt bigIndex;

    public PEnumerate(Object clazz, Shape instanceShape, Object iterator, PInt start) {
        this(clazz, instanceShape, iterator, -1L);
        this.bigIndex = start;
    }

    public PEnumerate(Object clazz, Shape instanceShape, Object iterator, long start) {
        super(clazz, instanceShape);
        this.iterator = iterator;
        this.index = start;
    }

    public Object getDecoratedIterator() {
        return this.iterator;
    }

    public Object getAndIncrementIndex(Node inliningTarget, PythonObjectFactory factory, InlinedConditionProfile bigIntIndexProfile) {
        if (bigIntIndexProfile.profile(inliningTarget, this.bigIndex != null)) {
            PInt idx = this.bigIndex;
            this.bigIndex = factory.createInt(this.bigIndex.inc());
            return idx;
        }
        return this.index++;
    }

    public Object getIndex(Node inliningTarget, InlinedConditionProfile bigIntIndexProfile) {
        if (bigIntIndexProfile.profile(inliningTarget, this.bigIndex != null)) {
            return this.bigIndex;
        }
        return this.index;
    }
}

