/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.FunctionBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.function.FunctionBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFunction})
public final class FunctionBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = FunctionBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FunctionBuiltinsFactory.getFactories();
    }

    @Builtin(name="__doc__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class DocNode
    extends PythonBinaryBuiltinNode {
        DocNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        Object get(PFunction self, Object none) {
            return self.getDoc();
        }

        @Specialization(guards={"!isNoValue(value)", "!isDeleteMarker(value)"})
        Object set(PFunction self, Object value) {
            self.setDoc(value);
            return PNone.NONE;
        }

        @Specialization
        Object delete(PFunction self, DescriptorDeleteMarker marker) {
            self.setDoc(PNone.NONE);
            return PNone.NONE;
        }
    }

    @Builtin(name="__code__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class GetCodeNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object getCodeU(PFunction self, PNone none, @Bind(value="this") Node inliningTarget, @Cached FunctionNodes.GetFunctionCodeNode getFunctionCodeNode) {
            return getFunctionCodeNode.execute(inliningTarget, self);
        }

        @Specialization
        static Object setCode(PFunction self, PCode code, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            int freeVarsLength;
            int closureLength = self.getClosure() == null ? 0 : self.getClosure().length;
            if (closureLength != (freeVarsLength = code.getFreeVars().length)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.REQUIRES_CODE_OBJ, self.getName(), closureLength, freeVarsLength);
            }
            self.setCode(code);
            return PNone.NONE;
        }
    }

    @Builtin(name="__truffle_source__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFunctionSourceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doFunction(PFunction function, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String sourceCode = function.getSourceCode();
            if (sourceCode != null) {
                return fromJavaStringNode.execute(sourceCode, PythonUtils.TS_ENCODING);
            }
            return PNone.NONE;
        }

        @Specialization
        static Object doMethod(PMethod method, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String sourceCode;
            Object function = method.getFunction();
            if (function instanceof PFunction && (sourceCode = ((PFunction)function).getSourceCode()) != null) {
                return fromJavaStringNode.execute(sourceCode, PythonUtils.TS_ENCODING);
            }
            return PNone.NONE;
        }

        @Fallback
        static Object doGeneric(Object object, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.GETTING_THER_SOURCE_NOT_SUPPORTED_FOR_P, object);
        }
    }

    @Builtin(name="__kwdefaults__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class GetKeywordDefaultsNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(arg)"})
        static Object get(PFunction self, PNone arg, @Cached PythonObjectFactory factory) {
            PKeyword[] kwdefaults = self.getKwDefaults();
            return kwdefaults.length > 0 ? factory.createDict(kwdefaults) : PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(arg)"})
        static Object set(PFunction self, PNone arg) {
            self.setKwDefaults(PKeyword.EMPTY_KEYWORDS);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(arg)"})
        @CompilerDirectives.TruffleBoundary
        Object set(PFunction self, PDict arg) {
            ArrayList<PKeyword> keywords = new ArrayList<PKeyword>();
            HashingStorage storage = arg.getDictStorage();
            HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(storage);
            while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(storage, it)) {
                Object key = TruffleStringMigrationHelpers.assertNoJavaString(HashingStorageNodes.HashingStorageIteratorKey.executeUncached(storage, it));
                if (key instanceof PString) {
                    key = ((PString)key).getValueUncached();
                } else if (!(key instanceof TruffleString)) {
                    throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, ErrorMessages.KEYWORD_NAMES_MUST_BE_STR_GOT_P, key);
                }
                keywords.add(new PKeyword((TruffleString)key, HashingStorageNodes.HashingStorageIteratorValue.executeUncached(storage, it)));
            }
            self.setKwDefaults(keywords.isEmpty() ? PKeyword.EMPTY_KEYWORDS : keywords.toArray(new PKeyword[keywords.size()]));
            return PNone.NONE;
        }
    }

    @Builtin(name="__defaults__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    public static abstract class GetDefaultsNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(defaults)"})
        static Object defaults(PFunction self, PNone defaults, @Cached PythonObjectFactory factory) {
            Object[] argDefaults = self.getDefaults();
            assert (argDefaults != null);
            return argDefaults.length == 0 ? PNone.NONE : factory.createTuple(argDefaults);
        }

        @Specialization
        static Object setDefaults(PFunction self, PTuple defaults, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            self.setDefaults(getObjectArrayNode.execute(inliningTarget, defaults));
            return PNone.NONE;
        }

        @Specialization(guards={"isDeleteMarker(defaults)"})
        static Object setDefaults(PFunction self, Object defaults) {
            self.setDefaults(PythonUtils.EMPTY_OBJECT_ARRAY);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(defaults)"})
        static Object setDefaults(PFunction self, PNone defaults) {
            self.setDefaults(PythonUtils.EMPTY_OBJECT_ARRAY);
            return PNone.NONE;
        }

        @Fallback
        static Object setDefaults(Object self, Object defaults, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_SET_TO_S_NOT_P, SpecialAttributeNames.T___DEFAULTS__, "tuple");
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class QualnameNode
    extends PythonBinaryBuiltinNode {
        QualnameNode() {
        }

        @Specialization(guards={"isNoValue(noValue)"})
        static Object getQualname(PFunction self, PNone noValue) {
            return self.getQualname();
        }

        @Specialization
        static Object setQualname(PFunction self, TruffleString value) {
            self.setQualname(value);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setQualname(PFunction self, Object value, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast) {
            return QualnameNode.setQualname(self, cast.cast(inliningTarget, value, ErrorMessages.MUST_BE_SET_TO_S_OBJ, SpecialAttributeNames.T___QUALNAME__, "string"));
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends PythonBinaryBuiltinNode {
        NameNode() {
        }

        @Specialization(guards={"isNoValue(noValue)"})
        static Object getName(PFunction self, PNone noValue) {
            return self.getName();
        }

        @Specialization
        static Object setName(PFunction self, TruffleString value) {
            self.setName(value);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setName(PFunction self, Object value, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast) {
            return NameNode.setName(self, cast.cast(inliningTarget, value, ErrorMessages.MUST_BE_SET_TO_S_OBJ, SpecialAttributeNames.T___NAME__, "string"));
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString reprFunction(PFunction self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<function %s at 0x%s>", self.getQualname(), PythonAbstractObject.objectHashCodeAsHexString(self));
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        @Specialization(guards={"!isPNone(instance)"})
        static PMethod doMethod(PFunction self, Object instance, Object klass, @Cached PythonObjectFactory factory) {
            return factory.createMethod(instance, self);
        }

        @Specialization
        static Object doFunction(PFunction self, PNone instance, Object klass) {
            return self;
        }
    }
}

