/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.builtins.objects.iterator.PIntegerIterator;
import com.oracle.truffle.api.object.Shape;

public final class PIntRangeIterator
extends PIntegerIterator {
    private final int start;
    private final int stop;
    private final int step;
    private final int len;

    public PIntRangeIterator(Object clazz, Shape instanceShape, int start, int stop, int step, int len) {
        super(clazz, instanceShape);
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.len = len;
    }

    public int getRemainingLength() {
        return this.len - this.index;
    }

    public int nextInt() {
        return this.start + this.index++ * this.step;
    }

    public boolean hasNextInt() {
        return this.index < this.len;
    }

    @Override
    public int next() {
        return this.nextInt();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextInt();
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public int getStep() {
        return this.step;
    }

    public int getLen() {
        return this.len;
    }
}

