/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tokenize;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.compiler.RaisePythonExceptionErrorCallback;
import com.oracle.graal.python.pegparser.ErrorCallback;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import com.oracle.graal.python.pegparser.tokenizer.Tokenizer;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import java.util.EnumSet;

public final class PTokenizerIter
extends PythonBuiltinObject {
    private final Source source;
    private final RaisePythonExceptionErrorCallback errorCallback;
    private final Tokenizer tokenizer;

    @CompilerDirectives.TruffleBoundary
    public PTokenizerIter(Object cls, Shape instanceShape, String sourceString) {
        super(cls, instanceShape);
        this.source = Source.newBuilder((String)"python", (CharSequence)sourceString, (String)"<string>").build();
        this.errorCallback = new RaisePythonExceptionErrorCallback(this.source, PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(null)));
        this.tokenizer = Tokenizer.fromString(this.errorCallback, sourceString, EnumSet.of(Tokenizer.Flag.EXEC_INPUT), null);
    }

    @CompilerDirectives.TruffleBoundary
    Token getNextToken() {
        Token token = this.tokenizer.next();
        this.errorCallback.triggerAndClearDeprecationWarnings();
        if (token.type == 60 && this.tokenizer.getDone() == Tokenizer.StatusCode.SYNTAX_ERROR) {
            throw this.errorCallback.raiseSyntaxError(ErrorCallback.ErrorType.Syntax, token.sourceRange, (String)token.extraData);
        }
        return token;
    }

    @CompilerDirectives.TruffleBoundary
    String getTokenString(Token token) {
        return token.type == 4 ? "" : this.tokenizer.getTokenString(token);
    }

    @CompilerDirectives.TruffleBoundary
    String getLine(Token token) {
        return String.valueOf(this.source.getCharacters(token.sourceRange.startLine)) + "\n";
    }
}

