/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.CallBinaryOp1Node;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberMultiplyNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateInline(inlineByDefault=true)
public abstract class PyNumberMultiplyNode
extends BinaryOpNode {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

    @Override
    public final Object executeObject(VirtualFrame frame, Object left, Object right) {
        return this.executeCached(frame, left, right);
    }

    public final Object executeCached(VirtualFrame frame, Object v, Object w) {
        return this.execute(frame, this, v, w);
    }

    public abstract int executeInt(VirtualFrame var1, Node var2, int var3, int var4) throws UnexpectedResultException;

    public abstract double executeDouble(VirtualFrame var1, Node var2, double var3, double var5) throws UnexpectedResultException;

    @Specialization(rewriteOn={ArithmeticException.class})
    public static int doII(int x, int y) throws ArithmeticException {
        return Math.multiplyExact(x, y);
    }

    @Specialization(replaces={"doII"})
    public static long doIIL(int x, int y) {
        return (long)x * (long)y;
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    public static long doLL(long x, long y) {
        return Math.multiplyExact(x, y);
    }

    @Specialization
    public static double doDL(double left, long right) {
        return left * (double)right;
    }

    @Specialization
    public static double doLD(long left, double right) {
        return (double)left * right;
    }

    @Specialization
    public static double doDD(double left, double right) {
        return left * right;
    }

    @Fallback
    static Object doIt(VirtualFrame frame, Node inliningTarget, Object v, Object w, @Cached.Exclusive @Cached GetClassNode getVClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached.Exclusive @Cached GetClassNode getWClass, @Cached CallBinaryOp1Node callBinaryOp1Node, @Cached InlinedBranchProfile hasNbMulResult, @Cached InlinedBranchProfile vHasSqRepeat, @Cached InlinedBranchProfile wHasSqRepeat, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSlotNode, @Cached PRaiseNode.Lazy raiseNode) {
        Object result;
        Object classV = getVClass.execute(inliningTarget, v);
        Object classW = getWClass.execute(inliningTarget, w);
        TpSlots slotsV = getVSlots.execute(inliningTarget, classV);
        TpSlots slotsW = getWSlots.execute(inliningTarget, classW);
        TpSlot slotV = slotsV.nb_multiply();
        TpSlot slotW = slotsW.nb_multiply();
        if ((slotV != null || slotW != null) && (result = callBinaryOp1Node.execute(frame, inliningTarget, v, classV, slotV, w, classW, slotW, TpSlotBinaryOp.BinaryOpSlot.NB_MULTIPLY)) != PNotImplemented.NOT_IMPLEMENTED) {
            hasNbMulResult.enter(inliningTarget);
            return result;
        }
        if (slotsV.sq_repeat() != null) {
            vHasSqRepeat.enter(inliningTarget);
            return PyNumberMultiplyNode.sequenceRepeat(frame, inliningTarget, slotsV.sq_repeat(), v, w, indexCheckNode, asSizeNode, callSlotNode, raiseNode);
        }
        if (slotsW.sq_repeat() != null) {
            wHasSqRepeat.enter(inliningTarget);
            return PyNumberMultiplyNode.sequenceRepeat(frame, inliningTarget, slotsW.sq_repeat(), w, v, indexCheckNode, asSizeNode, callSlotNode, raiseNode);
        }
        return PyNumberMultiplyNode.raiseNotSupported(inliningTarget, v, w, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Node inliningTarget, Object v, Object w, PRaiseNode.Lazy raiseNode) {
        return raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P, "+", v, w);
    }

    private static Object sequenceRepeat(VirtualFrame frame, Node inliningTarget, TpSlot slot, Object seq, Object n, PyIndexCheckNode indexCheckNode, PyNumberAsSizeNode asSizeNode, TpSlotSizeArgFun.CallSlotSizeArgFun callSlotNode, PRaiseNode.Lazy raiseNode) {
        if (indexCheckNode.execute(inliningTarget, n)) {
            int count = asSizeNode.execute((Frame)frame, inliningTarget, n, (Object)PythonBuiltinClassType.OverflowError);
            return callSlotNode.execute(frame, inliningTarget, slot, seq, count);
        }
        throw PyNumberMultiplyNode.raiseNonIntSqMul(inliningTarget, n, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNonIntSqMul(Node inliningTarget, Object n, PRaiseNode.Lazy raiseNode) {
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_MULTIPLY_SEQ_BY_NON_INT, n);
    }

    @NeverDefault
    public static PyNumberMultiplyNode create() {
        return PyNumberMultiplyNodeGen.create();
    }
}

