/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.lib.PyObjectDelItemNodeGen;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
@ImportStatic(value={PGuards.class})
public abstract class PyObjectDelItem
extends Node {
    public final void executeCached(Frame frame, Object container, Object index) {
        this.execute(frame, this, container, index);
    }

    public abstract void execute(Frame var1, Node var2, Object var3, Object var4);

    @Specialization(guards={"isBuiltinList(object)"})
    static void doList(VirtualFrame frame, PList object, Object key, @Cached(inline=false) ListBuiltins.SetSubscriptNode setItemNode) {
        setItemNode.executeVoid(frame, object, key, PNone.NO_VALUE);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"doList"})
    static void doGeneric(VirtualFrame frame, Node inliningTarget, Object object, Object key, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached PyObjectDelItemGeneric genericNode) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, object);
        genericNode.execute((Frame)frame, inliningTarget, object, slots, key);
    }

    @NeverDefault
    public static PyObjectDelItem create() {
        return PyObjectDelItemNodeGen.create();
    }

    public static PyObjectDelItem getUncached() {
        return PyObjectDelItemNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PyObjectDelItemGeneric
    extends Node {
        PyObjectDelItemGeneric() {
        }

        public abstract void execute(Frame var1, Node var2, Object var3, TpSlots var4, Object var5);

        @Specialization(guards={"slots.mp_ass_subscript() != null"})
        static void doMapping(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, Object key, @Cached TpSlotMpAssSubscript.CallSlotMpAssSubscriptNode callNode) {
            callNode.execute(frame, inliningTarget, slots.mp_ass_subscript(), object, key, PNone.NO_VALUE);
        }

        @Specialization(guards={"slots.mp_ass_subscript() == null", "slots.sq_ass_item() != null", "key >= 0"})
        static void doSequenceFastPath(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, int key, @Cached.Exclusive @Cached TpSlotSqAssItem.CallSlotSqAssItemNode callSqItem) {
            callSqItem.execute(frame, inliningTarget, slots.sq_ass_item(), object, key, PNone.NO_VALUE);
        }

        @Specialization(guards={"slots.mp_ass_subscript() == null", "slots.sq_ass_item() != null"}, replaces={"doSequenceFastPath"})
        @HostCompilerDirectives.InliningCutoff
        static void doSequence(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, Object key, @Cached PySequenceGetItemNode.IndexForSqSlot indexForSqSlot, @Cached.Exclusive @Cached TpSlotSqAssItem.CallSlotSqAssItemNode callSqItem) {
            int index = indexForSqSlot.execute(frame, inliningTarget, object, slots, key);
            callSqItem.execute(frame, inliningTarget, slots.sq_ass_item(), object, index, PNone.NO_VALUE);
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static void error(Object object, TpSlots slots, Object key, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_DELETION, object);
        }
    }
}

