/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;

@ImportStatic(value={PGuards.class, PythonOptions.class, SpecialMethodNames.class, SpecialAttributeNames.class, SpecialMethodSlot.class, BuiltinNames.class})
public abstract class PNodeWithContext
extends Node {
    @Idempotent
    protected final boolean isUncachedNode() {
        return !this.isAdoptable();
    }

    @CompilerDirectives.TruffleBoundary
    public static void printStack() {
        ExceptionUtils.printPythonLikeStackTrace();
    }

    @Idempotent
    public final PythonLanguage getLanguage() {
        return PythonLanguage.get(this);
    }

    @NonIdempotent
    public final PythonContext getContext() {
        return PythonContext.get(this);
    }

    @NonIdempotent
    public static PythonContext getContext(Node node) {
        return PythonContext.get(node);
    }

    @Idempotent
    public final boolean isSingleContext() {
        return this.getLanguage().isSingleContext();
    }

    @Idempotent
    public static boolean isSingleContext(Node node) {
        return PythonLanguage.get(node).isSingleContext();
    }

    public ValueProfile createValueIdentityProfile() {
        return this.getLanguage().isSingleContext() ? ValueProfile.createIdentityProfile() : ValueProfile.createClassProfile();
    }

    public final PosixSupport getPosixSupport() {
        return this.getContext().getPosixSupport();
    }
}

