/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow.vector;

import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateCached(value=false)
@GenerateInline
public abstract class GetFormatFromVectorNode
extends PNodeWithContext {
    static final String INT8_PACKAGE_PATH = "org.apache.arrow.vector.TinyIntVector";
    static final String INT16_PACKAGE_PATH = "org.apache.arrow.vector.SmallIntVector";
    static final String INT32_PACKAGE_PATH = "org.apache.arrow.vector.IntVector";
    static final String INT64_PACKAGE_PATH = "org.apache.arrow.vector.BigIntVector";
    static final String BOOLEAN_PACKAGE_PATH = "org.apache.arrow.vector.BitVector";
    static final String FLOAT2_PACKAGE_PATH = "org.apache.arrow.vector.Float2Vector";
    static final String FLOAT4_PACKAGE_PATH = "org.apache.arrow.vector.Float4Vector";
    static final String FLOAT8_PACKAGE_PATH = "org.apache.arrow.vector.Float8Vector";

    public abstract byte execute(Node var1, Object var2);

    @Specialization(guards={"int32VectorClass.isInstance(hostVector)"}, limit="1")
    static byte doInt32(Object hostVector, @Cached(value="getClass(INT32_PACKAGE_PATH)") Class<?> int32VectorClass) {
        return 105;
    }

    @Specialization(guards={"int64VectorClass.isInstance(hostVector)"}, limit="1")
    static byte doInt64(Object hostVector, @Cached(value="getClass(INT64_PACKAGE_PATH)") Class<?> int64VectorClass) {
        return 108;
    }

    @Specialization(guards={"float4VectorClass.isInstance(hostVector)"}, limit="1")
    static byte doFloat4(Object hostVector, @Cached(value="getClass(FLOAT4_PACKAGE_PATH)") Class<?> float4VectorClass) {
        return 102;
    }

    @Specialization(guards={"float8VectorClass.isInstance(hostVector)"}, limit="1")
    static byte doFloat8(Object hostVector, @Cached(value="getClass(FLOAT8_PACKAGE_PATH)") Class<?> float8VectorClass) {
        return 103;
    }

    @Specialization(guards={"int16VectorClass.isInstance(hostVector)"}, limit="1")
    static byte doInt16(Object hostVector, @Cached(value="getClass(INT16_PACKAGE_PATH)") Class<?> int16VectorClass) {
        return 115;
    }

    @Specialization(guards={"int8VectorClass.isInstance(hostVector)"}, limit="1")
    static byte doInt8(Object hostVector, @Cached(value="getClass(INT8_PACKAGE_PATH)") Class<?> int8VectorClass) {
        return 99;
    }

    @Specialization(guards={"boolVectorClass.isInstance(hostVector)"}, limit="1")
    static byte doBoolean(Object hostVector, @Cached(value="getClass(BOOLEAN_PACKAGE_PATH)") Class<?> boolVectorClass) {
        return 98;
    }

    @Specialization(guards={"float2VectorClass.isInstance(hostVector)"}, limit="1")
    static byte doFloat2(Object hostVector, @Cached(value="getClass(FLOAT2_PACKAGE_PATH)") Class<?> float2VectorClass) {
        return 101;
    }

    @Fallback
    static byte doError(Object obj) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    static Class<?> getClass(String path) {
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

